(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16899,        598]
NotebookOptionsPosition[     12574,        463]
NotebookOutlinePosition[     15218,        533]
CellTagsIndexPosition[     15127,        527]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functional Operations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Array" :> Documentation`HelpLookup["paclet:ref/Array"], 
          "ComposeList" :> Documentation`HelpLookup["paclet:ref/ComposeList"],
           "FoldList" :> Documentation`HelpLookup["paclet:ref/FoldList"], 
          "NestList" :> Documentation`HelpLookup["paclet:ref/NestList"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Array\"\>", 
       2->"\<\"ComposeList\"\>", 3->"\<\"FoldList\"\>", 
       4->"\<\"NestList\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Building Lists from Functions", "Title",
 CellTags->{"S2.2.6", "6.1"},
 CellID->18271],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Array"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "generate a length ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " list of the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "[", "1", "]"}], ",", 
         RowBox[{"f", "[", "2", "]"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Array"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "generate an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         SubscriptBox["n", "1"], "\[Cross]", 
         SubscriptBox["n", "2"], "\[Cross]"}], "..."}], TraditionalForm]], 
      "InlineMath"],
     " nested list, each of whose entries consists of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " applied to its indices"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NestList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NestList"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "generate a list of the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", "x", "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"f", "[", "x", "]"}], "]"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     ", where ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is nested up to ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " deep"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FoldList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FoldList"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "generate a list of the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", 
          RowBox[{"x", ",", "a"}], "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", 
         "\[Ellipsis]"}], "}"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ComposeList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ComposeList"], "[", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "generate a list of the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{
          SubscriptBox["f", "1"], "[", "x", "]"}], ",", 
         RowBox[{
          SubscriptBox["f", "2"], "[", 
          RowBox[{
           SubscriptBox["f", "1"], "[", "x", "]"}], "]"}], ",", 
         "\[Ellipsis]"}], "}"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15813],

Cell["Making lists from functions. ", "Caption",
 CellID->27415],

Cell[TextData[{
 "This makes a list of 5 elements, each of the form ",
 Cell[BoxData[
  RowBox[{"p", "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"p", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->318],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", "1", "]"}], ",", 
   RowBox[{"p", "[", "2", "]"}], ",", 
   RowBox[{"p", "[", "3", "]"}], ",", 
   RowBox[{"p", "[", "4", "]"}], ",", 
   RowBox[{"p", "[", "5", "]"}]}], "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->3580]
}, Open  ]],

Cell["Here is another way to produce the same list. ", "MathCaption",
 CellID->1331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"p", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->7267],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", "1", "]"}], ",", 
   RowBox[{"p", "[", "2", "]"}], ",", 
   RowBox[{"p", "[", "3", "]"}], ",", 
   RowBox[{"p", "[", "4", "]"}], ",", 
   RowBox[{"p", "[", "5", "]"}]}], "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->8387]
}, Open  ]],

Cell[TextData[{
 "This produces a list whose elements are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "+", 
    SuperscriptBox["i", "2"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->13444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "+", 
     RowBox[{"#", "^", "2"}]}], "&"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->23186],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "6", ",", "12", ",", "20", ",", "30"}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->14507]
}, Open  ]],

Cell[TextData[{
 "This generates a 2x3 matrix whose entries are ",
 Cell[BoxData[
  RowBox[{"m", "[", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->17827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"m", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ",", 
     RowBox[{"m", "[", 
      RowBox[{"1", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"m", "[", 
      RowBox[{"2", ",", "2"}], "]"}], ",", 
     RowBox[{"m", "[", 
      RowBox[{"2", ",", "3"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{380, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->28074]
}, Open  ]],

Cell["\<\
This generates a 3x3 matrix whose elements are the squares of the sums of \
their indices. \
\>", "MathCaption",
 CellID->26431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Plus", "[", "##", "]"}], "^", "2"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->7152],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "9", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "16", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "25", ",", "36"}], "}"}]}], "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->30271]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 " were discussed in \"",
 ButtonBox["Applying Functions Repeatedly\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"],
 ". Particularly by using them with pure functions, you can construct some \
very elegant and efficient ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs. "
}], "Text",
 CellID->10268],

Cell[TextData[{
 "This gives a list of results obtained by successively differentiating ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "n"], TraditionalForm]], "InlineMath"],
 " with respect to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->4693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{"x", "^", "n"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->19885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "n"], ",", 
   RowBox[{"n", " ", 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "n"}]]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "n"}]]}]}], "}"}]], "Output",
 ImageSize->{331, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->337]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->56442551],

Cell[TextData[ButtonBox["Functional Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionalOperationsOverview"]], "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Building Lists from Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functional Operations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionalOperationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PureFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SelectingPartsOfExpressionsWithFunctions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 7.4985582}", "context" -> "", 
    "keywords" -> {
     "array", "ComposeList", "compose list", "composition of functions", 
      "dimensions", "FoldList", "functional composition", "lists", "matrices",
       "NestList", "tensors"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Making lists from functions. This makes a list of 5 elements, each of \
the form p[i]. Here is another way to produce the same list. ", 
    "synonyms" -> {"2.2.6"}, "title" -> "Building Lists from Functions", 
    "type" -> "Tutorial", "uri" -> "tutorial/BuildingListsFromFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.2.6"->{
  Cell[2108, 62, 92, 2, 70, "Title",
   CellTags->{"S2.2.6", "6.1"},
   CellID->18271]},
 "6.1"->{
  Cell[2108, 62, 92, 2, 70, "Title",
   CellTags->{"S2.2.6", "6.1"},
   CellID->18271]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.2.6", 14916, 516},
 {"6.1", 15015, 520}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1483, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2108, 62, 92, 2, 70, "Title",
 CellTags->{"S2.2.6", "6.1"},
 CellID->18271],
Cell[2203, 66, 3932, 125, 70, "DefinitionBox",
 CellID->15813],
Cell[6138, 193, 64, 1, 70, "Caption",
 CellID->27415],
Cell[6205, 196, 196, 7, 70, "MathCaption",
 CellID->6085],
Cell[CellGroupData[{
Cell[6426, 207, 119, 4, 28, "Input",
 CellID->318],
Cell[6548, 213, 375, 12, 36, "Output",
 CellID->3580]
}, Open  ]],
Cell[6938, 228, 84, 1, 70, "MathCaption",
 CellID->1331],
Cell[CellGroupData[{
Cell[7047, 233, 198, 7, 28, "Input",
 CellID->7267],
Cell[7248, 242, 375, 12, 36, "Output",
 CellID->8387]
}, Open  ]],
Cell[7638, 257, 215, 8, 70, "MathCaption",
 CellID->13444],
Cell[CellGroupData[{
Cell[7878, 269, 191, 7, 28, "Input",
 CellID->23186],
Cell[8072, 278, 234, 7, 36, "Output",
 CellID->14507]
}, Open  ]],
Cell[8321, 288, 238, 9, 70, "MathCaption",
 CellID->4360],
Cell[CellGroupData[{
Cell[8584, 301, 170, 6, 70, "Input",
 CellID->17827],
Cell[8757, 309, 667, 23, 36, "Output",
 CellID->28074]
}, Open  ]],
Cell[9439, 335, 138, 4, 70, "MathCaption",
 CellID->26431],
Cell[CellGroupData[{
Cell[9602, 343, 248, 9, 70, "Input",
 CellID->7152],
Cell[9853, 354, 394, 13, 36, "Output",
 CellID->30271]
}, Open  ]],
Cell[10262, 370, 617, 20, 70, "Text",
 CellID->10268],
Cell[10882, 392, 305, 10, 70, "MathCaption",
 CellID->4693],
Cell[CellGroupData[{
Cell[11212, 406, 233, 8, 70, "Input",
 CellID->19885],
Cell[11448, 416, 787, 29, 39, "Output",
 CellID->337]
}, Open  ]],
Cell[CellGroupData[{
Cell[12272, 450, 71, 1, 70, "RelatedTutorialsSection",
 CellID->56442551],
Cell[12346, 453, 174, 4, 70, "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],
Cell[12547, 461, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

