(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29942,        975]
NotebookOptionsPosition[     22543,        736]
NotebookOutlinePosition[     25743,        814]
CellTagsIndexPosition[     25652,        808]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Strings and Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringsAndCharactersOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Strings and Characters\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CharacterRange" :> 
          Documentation`HelpLookup["paclet:ref/CharacterRange"], 
          "FromCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/FromCharacterCode"], 
          "ToCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/ToCharacterCode"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CharacterRange\"\>", 
       2->"\<\"FromCharacterCode\"\>", 
       3->"\<\"ToCharacterCode\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Character Codes", "Title",
 CellTags->{"S2.8.8", "8.1"},
 CellID->32119],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToCharacterCode",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToCharacterCode"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], Cell["\<\
give a list of the character codes for the characters in a string\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["FromCharacterCode",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FromCharacterCode"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[
    "construct a character from its character code", "TableText"]},
   {
    RowBox[{
     ButtonBox["FromCharacterCode",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FromCharacterCode"], "[", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
construct a string of characters from a list of character codes\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20577],

Cell["Converting to and from character codes. ", "Caption",
 CellID->10737],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assigns every character that can appear in a string a unique ",
 StyleBox["character code",
  FontSlant->"Italic"],
 ". This code is used internally as a way to represent the character. "
}], "Text",
 CellID->14091],

Cell["\<\
This gives the character codes for the characters in the string. \
\>", "MathCaption",
 CellID->20556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCharacterCode", "[", "\"\<ABCD abcd\>\"", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->22795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "65", ",", "66", ",", "67", ",", "68", ",", "32", ",", "97", ",", "98", ",",
    "99", ",", "100"}], "}"}]], "Output",
 ImageSize->{241, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->16060]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFormula"],
 " reconstructs the original string. "
}], "MathCaption",
 CellID->21901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->8793],

Cell[BoxData["\<\"ABCD abcd\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->3432]
}, Open  ]],

Cell["Special characters also have character codes. ", "MathCaption",
 CellID->2136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCharacterCode", "[", 
  "\"\<\[Alpha]\[CirclePlus]\[CapitalGamma]\[CircleMinus]\[EmptySet]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->4580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"945", ",", "8853", ",", "915", ",", "8854", ",", "8709"}], 
  "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->14875]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CharacterRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacterRange"], "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}], Cell["\<\
generate a list of characters with successive character codes\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5907],

Cell["Generating sequences of characters. ", "Caption",
 CellID->21184],

Cell["This gives part of the English alphabet. ", "MathCaption",
 CellID->28074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<a\>\"", ",", "\"\<k\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->8719],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>", 
   ",", "\<\"i\"\>", ",", "\<\"j\"\>", ",", "\<\"k\"\>"}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->26790]
}, Open  ]],

Cell["Here is the Greek alphabet. ", "MathCaption",
 CellID->20476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<\[Omega]\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->30041],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[Alpha]\"\>", ",", "\<\"\[Beta]\"\>", ",", "\<\"\[Gamma]\"\>",
    ",", "\<\"\[Delta]\"\>", ",", "\<\"\[CurlyEpsilon]\"\>", 
   ",", "\<\"\[Zeta]\"\>", ",", "\<\"\[Eta]\"\>", ",", "\<\"\[Theta]\"\>", 
   ",", "\<\"\[Iota]\"\>", ",", "\<\"\[Kappa]\"\>", ",", "\<\"\[Lambda]\"\>", 
   ",", "\<\"\[Mu]\"\>", ",", "\<\"\[Nu]\"\>", ",", "\<\"\[Xi]\"\>", 
   ",", "\<\"\[Omicron]\"\>", ",", "\<\"\[Pi]\"\>", ",", "\<\"\[Rho]\"\>", 
   ",", "\<\"\[FinalSigma]\"\>", ",", "\<\"\[Sigma]\"\>", 
   ",", "\<\"\[Tau]\"\>", ",", "\<\"\[Upsilon]\"\>", 
   ",", "\<\"\[CurlyPhi]\"\>", ",", "\<\"\[Chi]\"\>", ",", "\<\"\[Psi]\"\>", 
   ",", "\<\"\[Omega]\"\>"}], "}"}]], "Output",
 ImageSize->{464, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->3351]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assigns names such as ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", "Alpha", "]"}]}]], "InlineFormula"],
 " to a large number of special characters. This means that you can always \
refer to such characters just by giving their names, without ever having to \
know their character codes. "
}], "Text",
 CellID->8329],

Cell["\<\
This generates a string of special characters from their character codes. \
\>", "MathCaption",
 CellID->16290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", 
  RowBox[{"{", 
   RowBox[{"8706", ",", "8709", ",", "8711", ",", "8712"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->22974],

Cell[BoxData["\<\"\[PartialD]\[EmptySet]\[Del]\[Element]\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->23072]
}, Open  ]],

Cell["\<\
You can always refer to these characters by their names, without knowing \
their character codes. \
\>", "MathCaption",
 CellID->3591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->12189],

Cell["\"\[PartialD]\[EmptySet]\[Del]\[Element]\"", "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//InputForm= ",
 CellID->15787]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has names for all the common characters that are used in mathematical \
notation and in standard European languages. But for a language such as \
Japanese, there are more than 3,000 additional characters, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not assign an explicit name to each of them. Instead, it refers to \
such characters by standardized character codes. "
}], "Text",
 CellID->31490],

Cell["Here is a string containing Japanese characters. ", "MathCaption",
 CellID->3239],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\"\<\:6570\:5b66\>\"", TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->14893],

Cell[BoxData["\<\"\:6570\:5b66\"\>"], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2255143]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", these characters are referred to by standardized character codes. The \
character codes are given in hexadecimal. "
}], "MathCaption",
 CellID->17063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10681],

Cell["\"\:6570\:5b66\"", "Output",
 ImageSize->{36, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->330984686]
}, Open  ]],

Cell[TextData[{
 "The notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is typically set up so that when you enter a character in a particular \
font, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically work out the character code for that character. "
}], "Text",
 CellID->27005],

Cell["\<\
Sometimes, however, you may find it convenient to be able to enter characters \
directly using character codes. \
\>", "Text",
 CellID->24176],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\[Backslash]", "0"}], Cell["null byte (code 0)", "TableText"]},
   {
    RowBox[{"\[Backslash]", 
     RowBox[{".", 
      StyleBox["nn", "TI"]}]}], Cell[TextData[{
     "a character with hexadecimal code ",
     Cell[BoxData[
      StyleBox["nn", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{"\\:", 
      StyleBox["nnnn", "TI"]}]], Cell[TextData[{
     "a character with hexadecimal code ",
     Cell[BoxData[
      StyleBox["nnnn", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18479],

Cell["\<\
Ways to enter characters directly in terms of character codes. \
\>", "Caption",
 CellID->1695],

Cell[TextData[{
 "For characters with character codes below 256, you can use ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{".", 
    StyleBox["nn", "TI"]}]}]], "InlineFormula"],
 ". For characters with character codes above 256, you must use ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{":", 
    StyleBox["nnnn", "TI"]}]}]], "InlineFormula"],
 ". Note that in all cases you must give a fixed number of hexadecimal \
digits, padding with leading ",
 Cell[BoxData["0"], "InlineFormula"],
 "s if necessary. "
}], "Text",
 CellID->6139],

Cell["\<\
This gives character codes in hexadecimal for a few characters. \
\>", "MathCaption",
 CellID->32468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{
   "ToCharacterCode", "[", "\"\<A\[AGrave]\[Alpha]\[Aleph]\>\"", "]"}], ",", 
   "16"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->13998],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     SubscriptBox["\<\"41\"\>", "\<\"16\"\>"],
     65,
     Editable->False], ",", 
    InterpretationBox[
     SubscriptBox["\<\"e0\"\>", "\<\"16\"\>"],
     224,
     Editable->False], ",", 
    InterpretationBox[
     SubscriptBox["\<\"3b1\"\>", "\<\"16\"\>"],
     945,
     Editable->False], ",", 
    InterpretationBox[
     SubscriptBox["\<\"2135\"\>", "\<\"16\"\>"],
     8501,
     Editable->False]}], "}"}],
  BaseForm[#, 16]& ]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//BaseForm= ",
 CellID->21083]
}, Open  ]],

Cell[TextData[{
 "This enters the characters using their character codes. Note the leading ",
 Cell[BoxData["0"], "InlineFormula"],
 " inserted in the character code for ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->23639],

Cell[CellGroupData[{

Cell[BoxData["\"\<A\[AGrave]\[Alpha]\[Aleph]\>\""], "Input",
 CellLabel->"In[11]:= ",
 CellID->29515],

Cell[BoxData["\<\"A\[AGrave]\[Alpha]\[Aleph]\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->27621]
}, Open  ]],

Cell[TextData[{
 "In assigning codes to characters, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows three compatible standards: ASCII, ISO Latin\[Hyphen]1, and \
Unicode. ASCII covers the characters on a normal American English keyboard. \
ISO Latin\[Hyphen]1 covers characters in many European languages. Unicode is \
a more general standard which defines character codes for several tens of \
thousands of characters used in languages and notations around the world. "
}], "Text",
 CellID->29993],

Cell[BoxData[GridBox[{
   {Cell["0 \[Dash] 127 (\[Backslash].00 \[Dash] \[Backslash].7f)", 
     "TableText"], Cell["ASCII characters", "TableText"]},
   {Cell["1 \[Dash] 31 (\[Backslash].01 \[Dash] \[Backslash].1f)", 
     "TableText"], Cell["ASCII control characters", "TableText"]},
   {Cell["32 \[Dash] 126 (\[Backslash].20 \[Dash] \[Backslash].7e)", 
     "TableText"], Cell["printable ASCII characters", "TableText"]},
   {Cell["97 \[Dash] 122 (\[Backslash].61 \[Dash] \[Backslash].7a)", 
     "TableText"], Cell["lower\[Hyphen]case English letters", "TableText"]},
   {Cell["129 \[Dash] 255 (\[Backslash].81 \[Dash] \[Backslash].ff)", 
     "TableText"], Cell["ISO Latin\[Hyphen]1 characters", "TableText"]},
   {Cell["192 \[Dash] 255 (\[Backslash].c0 \[Dash] \[Backslash].ff)", 
     "TableText"], Cell["letters in European languages", "TableText"]},
   {Cell["0 \[Dash] 59391 (\[Backslash]:0000 \[Dash] \[Backslash]:e7ff)", 
     "TableText"], Cell["Unicode standard public characters", "TableText"]},
   {
    StyleBox[Cell[
     "913 \[Dash] 1009 (\[Backslash]:0391 \[Dash] \[Backslash]:03f1)", 
      "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], Cell[
    "Greek letters", "TableText"]},
   {
    StyleBox[Cell["\<\
12288 \[Dash] 35839 (\[Backslash]:3000 \[Dash] \[Backslash]:8bff)\
\>", "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], Cell[
    "Chinese, Japanese and Korean characters", "TableText"]},
   {
    StyleBox[Cell[
     "8450 \[Dash] 8504 (\[Backslash]:2102 \[Dash] \[Backslash]:2138)", 
      "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], Cell[
    "modified letters used in mathematical notation", "TableText"]},
   {
    StyleBox[Cell[
     "8592 \[Dash] 8677 (\[Backslash]:2190 \[Dash] \[Backslash]:21e5)", 
      "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], Cell[
    "arrows", "TableText"]},
   {
    StyleBox[Cell[
     "8704 \[Dash] 8945 (\[Backslash]:2200 \[Dash] \[Backslash]:22f1)", 
      "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], Cell[
    "mathematical symbols and operators", "TableText"]},
   {
    StyleBox[Cell["\<\
64256 \[Dash] 64300 (\[Backslash]:fb00 \[Dash] \[Backslash]:fb2c)\
\>", "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], Cell[TextData[{
     "Unicode private characters defined specially by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, True, False, True, False, False, False, False,
      False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15826],

Cell[TextData[{
 "A few ranges of character codes used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->15722],

Cell["Here are all the printable ASCII characters. ", "MathCaption",
 CellID->23838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"32", ",", "126"}], "]"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->24828],

Cell[BoxData["\<\" \
!\\\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\\\]^_`\
abcdefghijklmnopqrstuvwxyz{|}~\"\>"], "Output",
 ImageSize->{445, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->12581]
}, Open  ]],

Cell["\<\
Here are some ISO Latin\[Hyphen]1 letters. \
\>", "MathCaption",
 CellID->24399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"192", ",", "255"}], "]"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->8978],

Cell[BoxData["\<\"\[CapitalAGrave]\[CapitalAAcute]\[CapitalAHat]\
\[CapitalATilde]\[CapitalADoubleDot]\[CapitalARing]\[CapitalAE]\
\[CapitalCCedilla]\[CapitalEGrave]\[CapitalEAcute]\[CapitalEHat]\
\[CapitalEDoubleDot]\[CapitalIGrave]\[CapitalIAcute]\[CapitalIHat]\
\[CapitalIDoubleDot]\[CapitalEth]\[CapitalNTilde]\[CapitalOGrave]\
\[CapitalOAcute]\[CapitalOHat]\[CapitalOTilde]\[CapitalODoubleDot]\[Times]\
\[CapitalOSlash]\[CapitalUGrave]\[CapitalUAcute]\[CapitalUHat]\
\[CapitalUDoubleDot]\[CapitalYAcute]\[CapitalThorn]\[SZ]\[AGrave]\[AAcute]\
\[AHat]\[ATilde]\[ADoubleDot]\[ARing]\[AE]\[CCedilla]\[EGrave]\[EAcute]\[EHat]\
\[EDoubleDot]\[IGrave]\[IAcute]\[IHat]\[IDoubleDot]\[Eth]\[NTilde]\[OGrave]\
\[OAcute]\[OHat]\[OTilde]\[ODoubleDot]\[Divide]\[OSlash]\[UGrave]\[UAcute]\
\[UHat]\[UDoubleDot]\[YAcute]\[Thorn]\[YDoubleDot]\"\>"], "Output",
 ImageSize->{452, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->11891]
}, Open  ]],

Cell["\<\
Here are some special characters used in mathematical notation. The empty \
boxes correspond to characters not available in the current font. \
\>", "MathCaption",
 CellID->1023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"8704", ",", "8750"}], "]"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->26943],

Cell[BoxData["\<\"\[ForAll]\:2201\[PartialD]\[Exists]\[NotExists]\[EmptySet]\
\:2206\[Del]\[Element]\[NotElement]\:220a\[ReverseElement]\[NotReverseElement]\
\[SuchThat]\:220e\[Product]\[Coproduct]\[Sum]\:2212\[MinusPlus]\:2214\:2215\
\[Backslash]\:2217\[SmallCircle]\:2219\[Sqrt]\:221b\:221c\[Proportional]\
\[Infinity]\[RightAngle]\[Angle]\[MeasuredAngle]\[SphericalAngle]\
\[VerticalBar]\[NotVerticalBar]\[DoubleVerticalBar]\[NotDoubleVerticalBar]\
\[And]\[Or]\:2229\:222a\[Integral]\:222c\:222d\[ContourIntegral]\"\>"], \
"Output",
 ImageSize->{339, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->24834]
}, Open  ]],

Cell["Here are a few Japanese characters. ", "MathCaption",
 CellID->14243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"30000", ",", "30030"}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->7349],

Cell[BoxData["\<\"\:7530\:7531\:7532\:7533\:7534\:7535\:7536\:7537\:7538\:7539\
\:753a\:753b\:753c\:753d\:753e\:753f\:7540\:7541\:7542\:7543\:7544\:7545\:7546\
\:7547\:7548\:7549\:754a\:754b\:754c\:754d\:754e\"\>"], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->2702]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->234997562],

Cell[TextData[ButtonBox["Strings and Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StringsAndCharactersOverview"]], "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Character Codes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Strings and Characters", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/StringsAndCharactersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NewlinesAndTabsInStrings"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RawCharacterEncodings"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 11.8267940}", "context" -> "", 
    "keywords" -> {
     "alphabet", "ASCII", "\\catcode (TeX)", "character codes", 
      "CharacterRange", "\\char (TeX)", "Chinese characters", "codes", 
      "control characters", "conversion", "encoding", "European languages", 
      "FromCharacterCode", "Greek alphabet", "Greek letters", 
      "hexadecimal codes", "ISO Latin 1", "ISO Latin1", "ISO Latin 2", 
      "ISO Latin 2", "Japanese characters", "keyboards", "Korean characters", 
      "letters", "mapping", "\\nn (special characters)", 
      "\\nnn (special characters)", "\\nnnn (special characters)", 
      "octal codes", "ranges of characters", "raw codes", "sequences", 
      "ToCharacterCode", "Unicode"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Converting to and from character codes. Mathematica assigns every \
character that can appear in a string a unique character code. This code is \
used internally as a way to represent the character. This gives the character \
codes for the characters in the string. ", "synonyms" -> {"2.8.8"}, "title" -> 
    "Character Codes", "type" -> "Tutorial", "uri" -> 
    "tutorial/CharacterCodes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.8.8"->{
  Cell[2111, 64, 78, 2, 70, "Title",
   CellTags->{"S2.8.8", "8.1"},
   CellID->32119]},
 "8.1"->{
  Cell[2111, 64, 78, 2, 70, "Title",
   CellTags->{"S2.8.8", "8.1"},
   CellID->32119]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.8.8", 25441, 797},
 {"8.1", 25540, 801}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1486, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2111, 64, 78, 2, 70, "Title",
 CellTags->{"S2.8.8", "8.1"},
 CellID->32119],
Cell[2192, 68, 1446, 40, 70, "DefinitionBox",
 CellID->20577],
Cell[3641, 110, 75, 1, 70, "Caption",
 CellID->10737],
Cell[3719, 113, 283, 8, 70, "Text",
 CellID->14091],
Cell[4005, 123, 112, 3, 70, "MathCaption",
 CellID->20556],
Cell[CellGroupData[{
Cell[4142, 130, 124, 3, 28, "Input",
 CellID->22795],
Cell[4269, 135, 288, 9, 36, "Output",
 CellID->16060]
}, Open  ]],
Cell[4572, 147, 226, 7, 70, "MathCaption",
 CellID->21901],
Cell[CellGroupData[{
Cell[4823, 158, 109, 3, 28, "Input",
 CellID->8793],
Cell[4935, 163, 170, 5, 36, "Output",
 CellID->3432]
}, Open  ]],
Cell[5120, 171, 84, 1, 70, "MathCaption",
 CellID->2136],
Cell[CellGroupData[{
Cell[5229, 176, 181, 5, 70, "Input",
 CellID->4580],
Cell[5413, 183, 247, 8, 36, "Output",
 CellID->14875]
}, Open  ]],
Cell[5675, 194, 757, 21, 70, "DefinitionBox",
 CellID->5907],
Cell[6435, 217, 71, 1, 70, "Caption",
 CellID->21184],
Cell[6509, 220, 80, 1, 70, "MathCaption",
 CellID->28074],
Cell[CellGroupData[{
Cell[6614, 225, 145, 4, 70, "Input",
 CellID->8719],
Cell[6762, 231, 387, 9, 36, "Output",
 CellID->26790]
}, Open  ]],
Cell[7164, 243, 67, 1, 70, "MathCaption",
 CellID->20476],
Cell[CellGroupData[{
Cell[7256, 248, 160, 4, 70, "Input",
 CellID->30041],
Cell[7419, 254, 836, 16, 36, "Output",
 CellID->3351]
}, Open  ]],
Cell[8270, 273, 399, 11, 70, "Text",
 CellID->8329],
Cell[8672, 286, 121, 3, 70, "MathCaption",
 CellID->16290],
Cell[CellGroupData[{
Cell[8818, 293, 192, 6, 70, "Input",
 CellID->22974],
Cell[9013, 301, 200, 5, 36, "Output",
 CellID->23072]
}, Open  ]],
Cell[9228, 309, 144, 4, 70, "MathCaption",
 CellID->3591],
Cell[CellGroupData[{
Cell[9397, 317, 102, 3, 70, "Input",
 CellID->12189],
Cell[9502, 322, 198, 5, 50, "Output",
 CellID->15787]
}, Open  ]],
Cell[9715, 330, 484, 11, 70, "Text",
 CellID->31490],
Cell[10202, 343, 87, 1, 70, "MathCaption",
 CellID->3239],
Cell[CellGroupData[{
Cell[10314, 348, 113, 3, 70, "Input",
 CellID->14893],
Cell[10430, 353, 175, 5, 36, "Output",
 CellID->2255143]
}, Open  ]],
Cell[10620, 361, 299, 9, 70, "MathCaption",
 CellID->17063],
Cell[CellGroupData[{
Cell[10944, 374, 101, 3, 70, "Input",
 CellID->10681],
Cell[11048, 379, 175, 5, 50, "Output",
 CellID->330984686]
}, Open  ]],
Cell[11238, 387, 330, 10, 70, "Text",
 CellID->27005],
Cell[11571, 399, 152, 4, 70, "Text",
 CellID->24176],
Cell[11726, 405, 899, 27, 70, "DefinitionBox",
 CellID->18479],
Cell[12628, 434, 105, 3, 70, "Caption",
 CellID->1695],
Cell[12736, 439, 554, 16, 70, "Text",
 CellID->6139],
Cell[13293, 457, 111, 3, 70, "MathCaption",
 CellID->32468],
Cell[CellGroupData[{
Cell[13429, 464, 210, 7, 70, "Input",
 CellID->13998],
Cell[13642, 473, 664, 25, 50, "Output",
 CellID->21083]
}, Open  ]],
Cell[14321, 501, 284, 8, 70, "MathCaption",
 CellID->23639],
Cell[CellGroupData[{
Cell[14630, 513, 101, 2, 70, "Input",
 CellID->29515],
Cell[14734, 517, 189, 5, 36, "Output",
 CellID->27621]
}, Open  ]],
Cell[14938, 525, 513, 10, 70, "Text",
 CellID->29993],
Cell[15454, 537, 3053, 67, 70, "DefinitionBox",
 CellID->15826],
Cell[18510, 606, 146, 6, 70, "Caption",
 CellID->15722],
Cell[18659, 614, 84, 1, 70, "MathCaption",
 CellID->23838],
Cell[CellGroupData[{
Cell[18768, 619, 170, 5, 70, "Input",
 CellID->24828],
Cell[18941, 626, 269, 7, 54, "Output",
 CellID->12581]
}, Open  ]],
Cell[19225, 636, 90, 3, 70, "MathCaption",
 CellID->24399],
Cell[CellGroupData[{
Cell[19340, 643, 170, 5, 70, "Input",
 CellID->8978],
Cell[19513, 650, 977, 16, 36, "Output",
 CellID->11891]
}, Open  ]],
Cell[20505, 669, 188, 4, 70, "MathCaption",
 CellID->1023],
Cell[CellGroupData[{
Cell[20718, 677, 173, 5, 70, "Input",
 CellID->26943],
Cell[20894, 684, 664, 12, 42, "Output",
 CellID->24834]
}, Open  ]],
Cell[21573, 699, 75, 1, 70, "MathCaption",
 CellID->14243],
Cell[CellGroupData[{
Cell[21673, 704, 174, 5, 70, "Input",
 CellID->7349],
Cell[21850, 711, 353, 7, 36, "Output",
 CellID->2702]
}, Open  ]],
Cell[CellGroupData[{
Cell[22240, 723, 72, 1, 70, "RelatedTutorialsSection",
 CellID->234997562],
Cell[22315, 726, 174, 4, 70, "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],
Cell[22516, 734, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

