(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19616,        661]
NotebookOptionsPosition[     13984,        480]
NotebookOutlinePosition[     16768,        552]
CellTagsIndexPosition[     16677,        546]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Strings and Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringsAndCharactersOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Strings and Characters\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CharacterRange" :> 
          Documentation`HelpLookup["paclet:ref/CharacterRange"], "Characters" :> 
          Documentation`HelpLookup["paclet:ref/Characters"], "DigitQ" :> 
          Documentation`HelpLookup["paclet:ref/DigitQ"], "LetterQ" :> 
          Documentation`HelpLookup["paclet:ref/LetterQ"], "LowerCaseQ" :> 
          Documentation`HelpLookup["paclet:ref/LowerCaseQ"], "StringJoin" :> 
          Documentation`HelpLookup["paclet:ref/StringJoin"], "ToLowerCase" :> 
          Documentation`HelpLookup["paclet:ref/ToLowerCase"], "ToUpperCase" :> 
          Documentation`HelpLookup["paclet:ref/ToUpperCase"], "UpperCaseQ" :> 
          Documentation`HelpLookup["paclet:ref/UpperCaseQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CharacterRange\"\>", 
       2->"\<\"Characters\"\>", 3->"\<\"DigitQ\"\>", 4->"\<\"LetterQ\"\>", 
       5->"\<\"LowerCaseQ\"\>", 6->"\<\"StringJoin\"\>", 
       7->"\<\"ToLowerCase\"\>", 8->"\<\"ToUpperCase\"\>", 
       9->"\<\"UpperCaseQ\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Characters in Strings", "Title",
 CellTags->{"S2.8.3", "3.1"},
 CellID->8707],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Characters",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Characters"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], Cell[
    "convert a string to a list of characters", "TableText"]},
   {
    RowBox[{
     ButtonBox["StringJoin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringJoin"], "[", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[
    "convert a list of characters to a string", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20502],

Cell["Converting between strings and lists of characters. ", "Caption",
 CellID->25141],

Cell["This gives a list of the characters in the string. ", "MathCaption",
 CellID->10687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "\"\<A string.\>\"", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->8346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\" \"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", 
   ",", "\<\"r\"\>", ",", "\<\"i\"\>", ",", "\<\"n\"\>", ",", "\<\"g\"\>", 
   ",", "\<\".\"\>"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->15891]
}, Open  ]],

Cell["\<\
You can apply standard list manipulation operations to this list. \
\>", "MathCaption",
 CellID->24637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateLeft", "[", 
  RowBox[{"%", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->18413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"t\"\>", ",", "\<\"r\"\>", ",", "\<\"i\"\>", ",", "\<\"n\"\>", 
   ",", "\<\"g\"\>", ",", "\<\".\"\>", ",", "\<\"A\"\>", ",", "\<\" \"\>", 
   ",", "\<\"s\"\>"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->11400]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringJoin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringJoin"]], "InlineFormula"],
 " converts the list of characters back to a single string. "
}], "MathCaption",
 CellID->22816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->31690],

Cell[BoxData["\<\"tring.A s\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->13162]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DigitQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DigitQ"], "[", 
     StyleBox["string", "TI"], "]"}], Cell[
    "test whether all characters in a string are digits", "TableText"]},
   {
    RowBox[{
     ButtonBox["LetterQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LetterQ"], "[", 
     StyleBox["string", "TI"], "]"}], Cell[
    "test whether all characters in a string are letters", "TableText"]},
   {
    RowBox[{
     ButtonBox["UpperCaseQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UpperCaseQ"], "[", 
     StyleBox["string", "TI"], "]"}], Cell["\<\
test whether all characters in a string are upper\[Hyphen]case letters\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["LowerCaseQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LowerCaseQ"], "[", 
     StyleBox["string", "TI"], "]"}], Cell["\<\
test whether all characters in a string are lower\[Hyphen]case letters\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8935],

Cell["Testing characters in a string. ", "Caption",
 CellID->29126],

Cell["All characters in the string given are letters. ", "MathCaption",
 CellID->19410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterQ", "[", "\"\<Mixed\>\"", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->19877],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->11382]
}, Open  ]],

Cell[TextData[{
 "Not all the letters are upper case, so the result is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpperCaseQ", "[", "\"\<Mixed\>\"", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->27189],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->26705]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToUpperCase",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToUpperCase"], "[", 
     StyleBox["string", "TI"], "]"}], Cell[
    "generate a string in which all letters are upper case", "TableText"]},
   {
    RowBox[{
     ButtonBox["ToLowerCase",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToLowerCase"], "[", 
     StyleBox["string", "TI"], "]"}], Cell[
    "generate a string in which all letters are lower case", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13874],

Cell["Converting between upper and lower case. ", "Caption",
 CellID->2663],

Cell["This converts all letters to upper case. ", "MathCaption",
 CellID->20722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", "\"\<Mixed Form\>\"", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->32195],

Cell[BoxData["\<\"MIXED FORM\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->22566]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CharacterRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacterRange"], "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}], Cell[TextData[{
     "generate a list of all characters from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], "1"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], "2"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16360],

Cell["Generating ranges of characters. ", "Caption",
 CellID->6038],

Cell["\<\
This generates a list of lower\[Hyphen]case letters in alphabetical order. \
\>", "MathCaption",
 CellID->18588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<a\>\"", ",", "\"\<h\>\""}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->7811],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>"}], 
  "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->28245]
}, Open  ]],

Cell["\<\
Here is a list of upper\[Hyphen]case letters. \
\>", "MathCaption",
 CellID->9467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<T\>\"", ",", "\"\<Z\>\""}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->32425],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"T\"\>", ",", "\<\"U\"\>", ",", "\<\"V\"\>", ",", "\<\"W\"\>", 
   ",", "\<\"X\"\>", ",", "\<\"Y\"\>", ",", "\<\"Z\"\>"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->26867]
}, Open  ]],

Cell["Here are some digits. ", "MathCaption",
 CellID->13189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<0\>\"", ",", "\"\<7\>\""}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->10542],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"2\"\>", ",", "\<\"3\"\>", 
   ",", "\<\"4\"\>", ",", "\<\"5\"\>", ",", "\<\"6\"\>", ",", "\<\"7\"\>"}], 
  "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->13063]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CharacterRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterRange"]], "InlineFormula"],
 " will usually give meaningful results for any range of characters that have \
a natural ordering. The way ",
 Cell[BoxData[
  ButtonBox["CharacterRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterRange"]], "InlineFormula"],
 " works is by using the character codes that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " internally assigns to every character. "
}], "Text",
 CellID->21547],

Cell[TextData[{
 "This shows the ordering defined by the internal character codes used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->30502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<T\>\"", ",", "\"\<e\>\""}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->29617],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"T\"\>", ",", "\<\"U\"\>", ",", "\<\"V\"\>", ",", "\<\"W\"\>", 
   ",", "\<\"X\"\>", ",", "\<\"Y\"\>", ",", "\<\"Z\"\>", ",", "\<\"[\"\>", 
   ",", "\<\"\\\\\"\>", ",", "\<\"]\"\>", ",", "\<\"^\"\>", ",", "\<\"_\"\>", 
   ",", "\<\"`\"\>", ",", "\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", 
   ",", "\<\"d\"\>", ",", "\<\"e\"\>"}], "}"}]], "Output",
 ImageSize->{335, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->9099]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->136323670],

Cell[TextData[ButtonBox["Strings and Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StringsAndCharactersOverview"]], "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Characters in Strings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Strings and Characters", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/StringsAndCharactersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OperationsOnStrings"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/StringPatterns"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 12.6393148}", "context" -> "", 
    "keywords" -> {
     "alphabet", "alphabetic characters", "capital letters", "CharacterRange",
       "characters", "conversion", "DigitQ", "digits", "explode", "implode", 
      "LetterQ", "letters", "LowerCaseQ", "ranges of characters", "sequences",
       "small letters", "StringJoin", "strings", "ToLowerCase", "ToUpperCase",
       "UpperCaseQ"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Converting between strings and lists of characters. This gives a list of \
the characters in the string. You can apply standard list manipulation \
operations to this list. ", "synonyms" -> {"2.8.3"}, "title" -> 
    "Characters in Strings", "type" -> "Tutorial", "uri" -> 
    "tutorial/CharactersInStrings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.8.3"->{
  Cell[2672, 70, 83, 2, 70, "Title",
   CellTags->{"S2.8.3", "3.1"},
   CellID->8707]},
 "3.1"->{
  Cell[2672, 70, 83, 2, 70, "Title",
   CellTags->{"S2.8.3", "3.1"},
   CellID->8707]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.8.3", 16468, 535},
 {"3.1", 16566, 539}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2047, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2672, 70, 83, 2, 70, "Title",
 CellTags->{"S2.8.3", "3.1"},
 CellID->8707],
Cell[2758, 74, 1038, 29, 70, "DefinitionBox",
 CellID->20502],
Cell[3799, 105, 87, 1, 70, "Caption",
 CellID->25141],
Cell[3889, 108, 90, 1, 70, "MathCaption",
 CellID->10687],
Cell[CellGroupData[{
Cell[4004, 113, 118, 3, 28, "Input",
 CellID->8346],
Cell[4125, 118, 351, 9, 36, "Output",
 CellID->15891]
}, Open  ]],
Cell[4491, 130, 113, 3, 70, "MathCaption",
 CellID->24637],
Cell[CellGroupData[{
Cell[4629, 137, 126, 4, 28, "Input",
 CellID->18413],
Cell[4758, 143, 351, 9, 36, "Output",
 CellID->11400]
}, Open  ]],
Cell[5124, 155, 235, 7, 70, "MathCaption",
 CellID->22816],
Cell[CellGroupData[{
Cell[5384, 166, 103, 3, 28, "Input",
 CellID->31690],
Cell[5490, 171, 171, 5, 36, "Output",
 CellID->13162]
}, Open  ]],
Cell[5676, 179, 1351, 39, 70, "DefinitionBox",
 CellID->8935],
Cell[7030, 220, 67, 1, 70, "Caption",
 CellID->29126],
Cell[7100, 223, 87, 1, 70, "MathCaption",
 CellID->19410],
Cell[CellGroupData[{
Cell[7212, 228, 112, 3, 70, "Input",
 CellID->19877],
Cell[7327, 233, 158, 5, 36, "Output",
 CellID->11382]
}, Open  ]],
Cell[7500, 241, 227, 8, 70, "MathCaption",
 CellID->26260],
Cell[CellGroupData[{
Cell[7752, 253, 115, 3, 70, "Input",
 CellID->27189],
Cell[7870, 258, 159, 5, 36, "Output",
 CellID->26705]
}, Open  ]],
Cell[8044, 266, 823, 23, 70, "DefinitionBox",
 CellID->13874],
Cell[8870, 291, 75, 1, 70, "Caption",
 CellID->2663],
Cell[8948, 294, 80, 1, 70, "MathCaption",
 CellID->20722],
Cell[CellGroupData[{
Cell[9053, 299, 121, 3, 70, "Input",
 CellID->32195],
Cell[9177, 304, 172, 5, 36, "Output",
 CellID->22566]
}, Open  ]],
Cell[9364, 312, 949, 28, 70, "DefinitionBox",
 CellID->16360],
Cell[10316, 342, 67, 1, 70, "Caption",
 CellID->6038],
Cell[10386, 345, 122, 3, 70, "MathCaption",
 CellID->18588],
Cell[CellGroupData[{
Cell[10533, 352, 145, 4, 70, "Input",
 CellID->7811],
Cell[10681, 358, 332, 9, 36, "Output",
 CellID->28245]
}, Open  ]],
Cell[11028, 370, 92, 3, 70, "MathCaption",
 CellID->9467],
Cell[CellGroupData[{
Cell[11145, 377, 146, 4, 70, "Input",
 CellID->32425],
Cell[11294, 383, 311, 8, 36, "Output",
 CellID->26867]
}, Open  ]],
Cell[11620, 394, 61, 1, 70, "MathCaption",
 CellID->13189],
Cell[CellGroupData[{
Cell[11706, 399, 146, 4, 70, "Input",
 CellID->10542],
Cell[11855, 405, 332, 9, 36, "Output",
 CellID->13063]
}, Open  ]],
Cell[12202, 417, 558, 16, 70, "Text",
 CellID->21547],
Cell[12763, 435, 182, 6, 70, "MathCaption",
 CellID->30502],
Cell[CellGroupData[{
Cell[12970, 445, 147, 4, 70, "Input",
 CellID->29617],
Cell[13120, 451, 524, 11, 36, "Output",
 CellID->9099]
}, Open  ]],
Cell[CellGroupData[{
Cell[13681, 467, 72, 1, 70, "RelatedTutorialsSection",
 CellID->136323670],
Cell[13756, 470, 174, 4, 70, "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],
Cell[13957, 478, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

