(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9683,        341]
NotebookOptionsPosition[      5848,        226]
NotebookOutlinePosition[      8431,        292]
CellTagsIndexPosition[      8342,        286]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Lists" :> 
         Documentation`HelpLookup["paclet:tutorial/ListsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Lists\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Collecting Objects Together", "Title",
 CellTags->{"S1.8.1", "1.1"},
 CellID->15568],

Cell[TextData[{
 "We first encountered lists in \"",
 ButtonBox["Making Lists of Objects\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MakingListsOfObjects"],
 " as a way of collecting numbers together. Here, we shall see many different \
ways to use lists. You will find that lists are some of the most flexible and \
powerful objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You will see that lists in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represent generalizations of several standard concepts in mathematics and \
computer science. "
}], "Text",
 CellID->4422],

Cell[TextData[{
 "At a basic level, what a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list essentially does is to provide a way for you to collect together \
several expressions of any kind. "
}], "Text",
 CellID->16895],

Cell["Here is a list of numbers. ", "MathCaption",
 CellID->6135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "4"}], "}"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->18008],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->12361]
}, Open  ]],

Cell["This gives a list of symbolic expressions. ", "MathCaption",
 CellID->16742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "%"}], "-", "1"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->22194],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "4"]}]}], "}"}]], "Output",
 ImageSize->{160, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->23699]
}, Open  ]],

Cell["You can differentiate these expressions. ", "MathCaption",
 CellID->23188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->20178],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x"}], ",", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "3"]}]}], "}"}]], "Output",
 ImageSize->{103, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->4042]
}, Open  ]],

Cell[TextData[{
 "And then you can find values when ",
 Cell[BoxData["x"], "InlineFormula"],
 " is replaced with ",
 Cell[BoxData["3"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "->", "3"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->23941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "27", ",", "108"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->1847]
}, Open  ]],

Cell[TextData[{
 "The mathematical functions that are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are mostly set up to be \[OpenCurlyDoubleQuote]listable\
\[CloseCurlyDoubleQuote] so that they act separately on each element of a \
list.",
 " ",
 "This is, however, not true of all functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Unless you set it up specially, a new function ",
 Cell[BoxData["f"], "InlineFormula"],
 " that you introduce will treat lists just as single objects. \"",
 ButtonBox["Applying Functions to Parts of Expressions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"],
 " and \"",
 ButtonBox["Structural Operations\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/StructuralOperations"],
 " will describe how you can use ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 " to apply a function like this separately to each element in a list. "
}], "Text",
 CellID->7469],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->632707681],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Collecting Objects Together - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MakingTablesOfValues"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 13.5768388}", "context" -> "", 
    "keywords" -> {"collections", "lists", "tuples"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "We first encountered lists in \"Making Lists of Objects\" as a way of \
collecting numbers together. Here, we shall see many different ways to use \
lists. You will find that lists are some of the most flexible and powerful \
objects in Mathematica. You will see that lists in Mathematica represent \
generalizations of several standard concepts in mathematics and computer \
science. At a basic level, what a Mathematica list essentially does is to \
provide a way for you to collect together several expressions of any kind. \
Here is a list of numbers. ", "synonyms" -> {"1.8.1"}, "title" -> 
    "Collecting Objects Together", "type" -> "Tutorial", "uri" -> 
    "tutorial/CollectingObjectsTogether"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.1"->{
  Cell[1205, 42, 90, 2, 70, "Title",
   CellTags->{"S1.8.1", "1.1"},
   CellID->15568]},
 "1.1"->{
  Cell[1205, 42, 90, 2, 70, "Title",
   CellTags->{"S1.8.1", "1.1"},
   CellID->15568]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.1", 8131, 275},
 {"1.1", 8230, 279}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 580, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1205, 42, 90, 2, 70, "Title",
 CellTags->{"S1.8.1", "1.1"},
 CellID->15568],
Cell[1298, 46, 609, 16, 70, "Text",
 CellID->4422],
Cell[1910, 64, 232, 7, 70, "Text",
 CellID->16895],
Cell[2145, 73, 65, 1, 70, "MathCaption",
 CellID->6135],
Cell[CellGroupData[{
Cell[2235, 78, 122, 4, 28, "Input",
 CellID->18008],
Cell[2360, 84, 210, 7, 36, "Output",
 CellID->12361]
}, Open  ]],
Cell[2585, 94, 82, 1, 70, "MathCaption",
 CellID->16742],
Cell[CellGroupData[{
Cell[2692, 99, 112, 4, 28, "Input",
 CellID->22194],
Cell[2807, 105, 421, 16, 39, "Output",
 CellID->23699]
}, Open  ]],
Cell[3243, 124, 80, 1, 70, "MathCaption",
 CellID->23188],
Cell[CellGroupData[{
Cell[3348, 129, 117, 4, 28, "Input",
 CellID->20178],
Cell[3468, 135, 334, 12, 39, "Output",
 CellID->4042]
}, Open  ]],
Cell[3817, 150, 194, 7, 70, "MathCaption",
 CellID->31357],
Cell[CellGroupData[{
Cell[4036, 161, 114, 4, 70, "Input",
 CellID->23941],
Cell[4153, 167, 212, 7, 36, "Output",
 CellID->1847]
}, Open  ]],
Cell[4380, 177, 1175, 33, 70, "Text",
 CellID->7469],
Cell[CellGroupData[{
Cell[5580, 214, 72, 1, 70, "RelatedTutorialsSection",
 CellID->632707681],
Cell[5655, 217, 139, 3, 70, "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],
Cell[5821, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

