(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     66474,       2334]
NotebookOptionsPosition[     57588,       2063]
NotebookOutlinePosition[     61537,       2152]
CellTagsIndexPosition[     61444,       2146]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BellB" :> Documentation`HelpLookup["paclet:ref/BellB"], 
          "BernoulliB" :> Documentation`HelpLookup["paclet:ref/BernoulliB"], 
          "Binomial" :> Documentation`HelpLookup["paclet:ref/Binomial"], 
          "CatalanNumber" :> 
          Documentation`HelpLookup["paclet:ref/CatalanNumber"], 
          "ClebschGordan" :> 
          Documentation`HelpLookup["paclet:ref/ClebschGordan"], "EulerE" :> 
          Documentation`HelpLookup["paclet:ref/EulerE"], "Fibonacci" :> 
          Documentation`HelpLookup["paclet:ref/Fibonacci"], "HarmonicNumber" :> 
          Documentation`HelpLookup["paclet:ref/HarmonicNumber"], 
          "IntegerPartitions" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPartitions"], "LucasL" :> 
          Documentation`HelpLookup["paclet:ref/LucasL"], "Multinomial" :> 
          Documentation`HelpLookup["paclet:ref/Multinomial"], "NorlundB" :> 
          Documentation`HelpLookup["paclet:ref/NorlundB"], "PartitionsP" :> 
          Documentation`HelpLookup["paclet:ref/PartitionsP"], "PartitionsQ" :> 
          Documentation`HelpLookup["paclet:ref/PartitionsQ"], "Signature" :> 
          Documentation`HelpLookup["paclet:ref/Signature"], "SixJSymbol" :> 
          Documentation`HelpLookup["paclet:ref/SixJSymbol"], "StirlingS1" :> 
          Documentation`HelpLookup["paclet:ref/StirlingS1"], "StirlingS2" :> 
          Documentation`HelpLookup["paclet:ref/StirlingS2"], "Subfactorial" :> 
          Documentation`HelpLookup["paclet:ref/Subfactorial"], "ThreeJSymbol" :> 
          Documentation`HelpLookup["paclet:ref/ThreeJSymbol"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BellB\"\>", 2->"\<\"BernoulliB\"\>",
        3->"\<\"Binomial\"\>", 4->"\<\"CatalanNumber\"\>", 
       5->"\<\"ClebschGordan\"\>", 6->"\<\"EulerE\"\>", 
       7->"\<\"Fibonacci\"\>", 8->"\<\"HarmonicNumber\"\>", 
       9->"\<\"IntegerPartitions\"\>", 10->"\<\"LucasL\"\>", 
       11->"\<\"Multinomial\"\>", 12->"\<\"NorlundB\"\>", 
       13->"\<\"PartitionsP\"\>", 14->"\<\"PartitionsQ\"\>", 
       15->"\<\"Signature\"\>", 16->"\<\"SixJSymbol\"\>", 
       17->"\<\"StirlingS1\"\>", 18->"\<\"StirlingS2\"\>", 
       19->"\<\"Subfactorial\"\>", 
       20->"\<\"ThreeJSymbol\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Combinatorial Functions", "Title",
 CellTags->{"S3.2.6", "6.1"},
 CellID->8942],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["n", "TI"], "!"}], Cell[TextData[{
     "factorial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"n", "(", 
         RowBox[{"n", "-", "1"}], ")"}], " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}], "\[Cross]", "\[Ellipsis]", 
         "\[Cross]", "1"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["n", "TI"], "!!"}], Cell[TextData[{
     "double factorial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"n", "(", 
         RowBox[{"n", "-", "2"}], ")"}], " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "-", "4"}], ")"}], "\[Cross]", "\[Ellipsis]"}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Binomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Binomial"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "binomial coefficient ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"(", GridBox[{
           {"n"},
           {"m"}
          }], ")"}], "=", 
        RowBox[{
         RowBox[{"n", "!"}], "/", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"m", "!"}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "-", "m"}], ")"}], "!"}]}], "]"}]}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Multinomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Multinomial"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "multinomial coefficient ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["n", "1"], "+", 
           SubscriptBox["n", "2"], "+", "\[Ellipsis]"}], ")"}], "!"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["n", "1"], "!"}], 
          RowBox[{
           SubscriptBox["n", "2"], "!"}], "\[Ellipsis]"}], ")"}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CatalanNumber",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CatalanNumber"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Catalan number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "n"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Subfactorial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Subfactorial"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "number of derangements of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " objects"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Fibonacci",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fibonacci"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Fibonacci number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["F", "n"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Fibonacci",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fibonacci"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "Fibonacci polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["F", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LucasL",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LucasL"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Lucas number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["L", "n"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HarmonicNumber",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HarmonicNumber"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "harmonic number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["H", "n"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HarmonicNumber",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HarmonicNumber"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["r", "TI"], "]"}], Cell[TextData[{
     "harmonic number ",
     Cell[BoxData[
      FormBox[
       SubsuperscriptBox["H", "n", "r"], TraditionalForm]], "InlineMath"],
     " of order ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BernoulliB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BernoulliB"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Bernoulli number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["B", "n"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BernoulliB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BernoulliB"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "Bernoulli polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["B", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NorlundB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NorlundB"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["a", "TI"]}], "]"}], Cell[TextData[{
     "N\[ODoubleDot]rlund polynomial ",
     Cell[BoxData[
      FormBox[
       SubsuperscriptBox["B", "n", 
        RowBox[{"(", "a", ")"}]], TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NorlundB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NorlundB"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "generalized Bernoulli polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["B", "n", 
         RowBox[{"(", "a", ")"}]], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EulerE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EulerE"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Euler number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["E", "n"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EulerE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EulerE"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "Euler polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["E", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StirlingS1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StirlingS1"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "Stirling number of the first kind ",
     Cell[BoxData[
      FormBox[
       SubsuperscriptBox["S", "n", 
        RowBox[{"(", "m", ")"}]], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StirlingS2",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StirlingS2"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "Stirling number of the second kind ",
     Cell[BoxData[
      FormBox[
       SubsuperscriptBox["\[ScriptCapitalS]", "n", 
        RowBox[{"(", "m", ")"}]], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BellB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BellB"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Bell number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["B", "n"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BellB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BellB"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "Bell polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["B", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PartitionsP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PartitionsP"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the number ",
     Cell[BoxData[
      FormBox[
       RowBox[{"p", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
     " of unrestricted partitions of the integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerPartitions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerPartitions"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[
    "partitions of an integer", "TableText"]},
   {
    RowBox[{
     ButtonBox["PartitionsQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PartitionsQ"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the number ",
     Cell[BoxData[
      FormBox[
       RowBox[{"q", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
     " of partitions of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " into distinct parts"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Signature",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Signature"], "[", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "the signature of a permutation", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, True, False, True, False, False, True, False, 
     True, False, False, False, True, False, False, False, False, False, 
     False, True, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->19264],

Cell["Combinatorial functions.", "Caption",
 CellID->22648],

Cell[TextData[{
 "The ",
 StyleBox["factorial function", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "!"}], TraditionalForm]], "InlineMath"],
 " gives the number of ways of ordering ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " objects. For non\[Hyphen]integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", the numerical value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "!"}], TraditionalForm]], "InlineMath"],
 " is obtained from the gamma function, discussed in \"",
 ButtonBox["Special Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SpecialFunctions"],
 ". "
}], "Text",
 CellID->27446],

Cell[TextData[{
 "The ",
 StyleBox["binomial coefficient", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Binomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Binomial"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " can be written as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", GridBox[{
       {"n"},
       {"m"}
      }], ")"}], "=", 
    RowBox[{
     RowBox[{"n", "!"}], "/", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"m", "!"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "m"}], ")"}], "!"}]}], "]"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". It gives the number of ways of choosing ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " objects from a collection of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " objects, without regard to order. The ",
 StyleBox["Catalan numbers", "TB"],
 ", which appear in various tree enumeration problems, are given in terms of \
binomial coefficients as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "n"], "=", 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"2", "n"}]},
       {"n"}
      }], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->23805],

Cell[TextData[{
 "The ",
 StyleBox["subfactorial",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subfactorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subfactorial"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " gives the number of permutations of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " objects that leave no object fixed. Such a permutation is called a \
derangement. The subfactorial is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"n", "!"}], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "n"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "k"], "/", 
      RowBox[{"k", "!"}]}]}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->221576235],

Cell[TextData[{
 "The ",
 StyleBox["multinomial coefficient", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Multinomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Multinomial"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ", denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"N", ";", 
      RowBox[{
       SubscriptBox["n", "1"], ",", 
       SubscriptBox["n", "2"], ",", "...", ",", 
       SubscriptBox["n", "m"]}]}], ")"}], "=", 
    RowBox[{
     RowBox[{"N", "!"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["n", "1"], "!", 
       SubscriptBox["n", "2"], 
       RowBox[{"!", "..."}], 
       SubscriptBox["n", "m"], "!"}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", gives the number of ways of partitioning ",
 Cell[BoxData[
  FormBox["N", TraditionalForm]], "InlineMath"],
 " distinct objects into ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " sets of sizes ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 " (with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"N", "=", 
    UnderoverscriptBox[
     StyleBox["\[Sum]",
      SpanMinSize->2], 
     RowBox[{"i", "=", "1"}], "m",
     LimitsPositioning->True], 
    SubscriptBox["n", "i"]}], TraditionalForm]], "InlineMath"],
 ")."
}], "Text",
 CellID->15890],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gives the exact integer result for the factorial of an integer. "
}], "MathCaption",
 CellID->6729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"30", "!"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24370],

Cell[BoxData["265252859812191058636308480000000"], "Output",
 ImageSize->{257, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->551399794]
}, Open  ]],

Cell[TextData[{
 "For non\[Hyphen]integers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluates factorials using the gamma function. "
}], "MathCaption",
 CellID->15006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"3.6", "!"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31101],

Cell[BoxData["13.381285870932441`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->984400953]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can give symbolic results for some binomial coefficients. "
}], "MathCaption",
 CellID->3548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{"n", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19629],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n"}]], "Output",
 ImageSize->{77, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->612800583]
}, Open  ]],

Cell[TextData[{
 "This gives the number of ways of partitioning ",
 Cell[BoxData[
  FormBox[
   RowBox[{"6", "+", "5", "=", "11"}], TraditionalForm]], "InlineMath"],
 " objects into sets containing 6 and 5 objects. "
}], "MathCaption",
 CellID->24084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{"6", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->19954],

Cell[BoxData["462"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->7827469]
}, Open  ]],

Cell[TextData[{
 "The result is the same as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"11"},
      {"6"}
     }], ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->11840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{"11", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4966],

Cell[BoxData["462"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->559769016]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Fibonacci numbers", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Fibonacci",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fibonacci"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " satisfy the recurrence relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["F", "n"], "=", 
    SubscriptBox["F", 
     RowBox[{"n", "-", "1"}]], "+", 
    SubscriptBox["F", 
     RowBox[{"n", "-", "2"}]]}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["F", "1"], "=", 
    SubscriptBox["F", "2"], "=", "1"}], TraditionalForm]], "InlineMath"],
 ". They appear in a wide range of discrete mathematical problems. For large \
",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["F", "n"], "/", 
    SubscriptBox["F", 
     RowBox[{"n", "-", "1"}]]}], TraditionalForm]], "InlineMath"],
 " approaches the golden ratio. The ",
 StyleBox["Lucas numbers", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LucasL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LucasL"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " satisfy the same recurrence relation as the Fibonacci numbers do, but with \
initial conditions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["L", "1"], "=", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["L", "2"], "=", "3"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->13931],

Cell[TextData[{
 "The ",
 StyleBox["Fibonacci polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Fibonacci",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fibonacci"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " appear as the coefficients of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["t", "n"], TraditionalForm]], "InlineMath"],
 " in the expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"t", "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x", "t", "-", 
       SuperscriptBox["t", "2"]}], ")"}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      SubscriptBox["F", "n"], 
      RowBox[{"(", "x", ")"}], 
      SuperscriptBox["t", "n"], " "}]}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->26308],

Cell[TextData[{
 "The ",
 StyleBox["harmonic numbers", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HarmonicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicNumber"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["H", "n"], "=", 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "n",
     LimitsPositioning->True], "1", "/", "i"}], TraditionalForm]], 
  "InlineMath"],
 "; the harmonic numbers of order ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HarmonicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicNumber"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
 " are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["H", "n", 
     RowBox[{"(", "r", ")"}]], "=", 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "n",
     LimitsPositioning->True], "1", "/", 
    SuperscriptBox["i", "r"]}], TraditionalForm]], "InlineMath"],
 ". Harmonic numbers appear in many combinatorial estimation problems, often \
playing the role of discrete analogs of logarithms. "
}], "Text",
 CellID->16944],

Cell[TextData[{
 "The ",
 StyleBox["Bernoulli polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BernoulliB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BernoulliB"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " satisfy the generating function relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"t", 
      SuperscriptBox["e", 
       RowBox[{"x", " ", "t"}]]}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["e", "t"], "-", "1"}], ")"}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{
       SubscriptBox["B", "n"], "(", "x", ")"}], 
      RowBox[{
       SuperscriptBox["t", "n"], "/", 
       RowBox[{"n", "!"}], " "}]}]}]}], TraditionalForm]], "InlineMath"],
 ". The ",
 StyleBox["Bernoulli numbers", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BernoulliB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BernoulliB"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["B", "n"], "=", 
    RowBox[{
     SubscriptBox["B", "n"], "(", "0", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". The ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "n"], TraditionalForm]], "InlineMath"],
 " appear as the coefficients of the terms in the Euler\[Hyphen]Maclaurin \
summation formula for approximating integrals. The Bernoulli numbers are \
related to the ",
 StyleBox["Genocchi numbers", "TB"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["G", "n"], "=", "2", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["2", "n"]}], ")"}], 
    SubscriptBox["B", "n"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->32439],

Cell[TextData[{
 "Numerical values for Bernoulli numbers are needed in many numerical \
algorithms. You can always get these numerical values by first finding exact \
rational results using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BernoulliB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BernoulliB"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ", and then applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->24626],

Cell[TextData[{
 "The ",
 StyleBox["Euler polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EulerE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerE"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " have generating function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["e", 
       RowBox[{"x", " ", "t"}]]}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["e", "t"], "+", "1"}], ")"}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{
       SubscriptBox["E", "n"], "(", "x", ")"}], 
      RowBox[{
       SuperscriptBox["t", "n"], "/", 
       RowBox[{"n", "!"}], " "}]}]}]}], TraditionalForm]], "InlineMath"],
 ", and the ",
 StyleBox["Euler numbers", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EulerE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerE"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["E", "n"], "=", 
    RowBox[{
     SuperscriptBox["2", "n"], 
     RowBox[{
      SubscriptBox["E", "n"], "(", 
      FractionBox["1", "2"], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->11323],

Cell[TextData[{
 "The ",
 StyleBox["N\[ODoubleDot]rlund polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NorlundB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NorlundB"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 " satisfy the generating function relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "a"], "/", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["e", "t"], "-", "1"}], ")"}], "a"]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      SubsuperscriptBox["B", "n", 
       RowBox[{"(", "a", ")"}]], 
      RowBox[{
       SuperscriptBox["t", "n"], "/", 
       RowBox[{"n", "!"}], " "}]}]}]}], TraditionalForm]], "InlineMath"],
 ". The N\[ODoubleDot]rlund polynomials give the Bernoulli numbers when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". For other positive integer values of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ", the N\[ODoubleDot]rlund polynomials give higher-order Bernoulli numbers. \
The ",
 StyleBox["generalized Bernoulli polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["NorlundB",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NorlundB"], "[", 
    RowBox[{
     StyleBox["n", "TI"], ",", 
     StyleBox["a", "TI"], 
     StyleBox[",", "TI"], 
     StyleBox["x", "TI"]}], "]"}], " "}]], "InlineFormula"],
 " satisfy the generating function relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "a"], 
     RowBox[{
      SuperscriptBox["e", 
       RowBox[{"x", " ", "t"}]], "/", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["e", "t"], "-", "1"}], ")"}], "a"]}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["B", "n", 
        RowBox[{"(", "a", ")"}]], "(", "x", ")"}], 
      RowBox[{
       SuperscriptBox["t", "n"], "/", 
       RowBox[{"n", "!"}], " "}]}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->322603501],

Cell[TextData[{
 "This gives the second Bernoulli polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["B", "2"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->5537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BernoulliB", "[", 
  RowBox[{"2", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->21538],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], "-", "x", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{60, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->2059478052]
}, Open  ]],

Cell["\<\
You can also get Bernoulli polynomials by explicitly computing the power \
series for the generating function. \
\>", "MathCaption",
 CellID->2082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"t", " ", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"x", " ", "t"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Exp", "[", "t", "]"}], "-", "1"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->22929],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], "+", "x"}], ")"}], " ", "t"}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"6", " ", "x"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    SuperscriptBox["t", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "3"]}]}], ")"}], " ", 
    SuperscriptBox["t", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "720"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"30", " ", 
       SuperscriptBox["x", "2"]}], "-", 
      RowBox[{"60", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"30", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}], " ", 
    SuperscriptBox["t", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "t", "]"}], "5"],
    SeriesData[$CellContext`t, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`t, 0, {
   1, Rational[-1, 2] + $CellContext`x, 
    Rational[1, 12] (1 - 6 $CellContext`x + 6 $CellContext`x^2), 
    Rational[1, 12] ($CellContext`x - 3 $CellContext`x^2 + 
     2 $CellContext`x^3), 
    Rational[1, 720] (-1 + 30 $CellContext`x^2 - 60 $CellContext`x^3 + 
     30 $CellContext`x^4)}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{397, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->506197618]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BernoulliB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BernoulliB"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " gives exact rational\[Hyphen]number results for Bernoulli numbers. "
}], "MathCaption",
 CellID->4833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BernoulliB", "[", "20", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->31115],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["174611", "330"]}]], "Output",
 ImageSize->{60, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1480639959]
}, Open  ]],

Cell[TextData[{
 "Stirling numbers show up in many combinatorial enumeration problems. For ",
 StyleBox["Stirling numbers of the first kind", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StirlingS1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StirlingS1"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"n", "-", "m"}]], 
    SubsuperscriptBox["S", "n", 
     RowBox[{"(", "m", ")"}]]}], TraditionalForm]], "InlineMath"],
 " gives the number of permutations of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " elements which contain exactly ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " cycles. These Stirling numbers satisfy the generating function relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", 
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "\[Ellipsis]", 
    RowBox[{"(", 
     RowBox[{"x", "-", "n", "+", "1"}], ")"}], "=", 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"m", "=", "0"}], "n",
     LimitsPositioning->True], 
    SubsuperscriptBox["S", "n", 
     RowBox[{"(", "m", ")"}]], 
    SuperscriptBox["x", "m"]}], TraditionalForm]], "InlineMath"],
 ". Note that some definitions of the ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["S", "n", 
    RowBox[{"(", "m", ")"}]], TraditionalForm]], "InlineMath"],
 " differ by a factor ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"n", "-", "m"}]], TraditionalForm]], "InlineMath"],
 " from what is used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->29658],

Cell[TextData[{
 StyleBox["Stirling numbers of the second kind", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StirlingS2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StirlingS2"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 ", sometimes denoted ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[ScriptCapitalS]", "n", 
    RowBox[{"(", "m", ")"}]], TraditionalForm]], "InlineMath"],
 ", give the number of ways of partitioning a set of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " elements into ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " non\[Hyphen]empty subsets. They satisfy the relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "n"], "=", 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"m", "=", "0"}], "n",
     LimitsPositioning->True], 
    SubsuperscriptBox["\[ScriptCapitalS]", "n", 
     RowBox[{"(", "m", ")"}]], "x", 
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "...", 
    RowBox[{"(", 
     RowBox[{"x", "-", "m", "+", "1"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->22704],

Cell[TextData[{
 "The ",
 StyleBox["Bell numbers", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BellB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BellB"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " give the total number of ways of that a set of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " elements can be partitioned into non\[Hyphen]empty subsets. The ",
 StyleBox["Bell polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BellB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BellB"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " satisfy the generating function relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["e", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["e", "t"], "-", "1"}], ")"}], "x"}]], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{
       SubscriptBox["B", "n"], "(", "x", ")"}], 
      FractionBox[
       SuperscriptBox["t", "n"], 
       RowBox[{"n", "!"}]]}]}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->9930],

Cell[TextData[{
 "The ",
 StyleBox["partition function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PartitionsP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PartitionsP"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " gives the number of ways of writing the integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " as a sum of positive integers, without regard to order. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PartitionsQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PartitionsQ"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " gives the number of ways of writing ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " as a sum of positive integers, with the constraint that all the integers \
in each sum are distinct."
}], "Text",
 CellID->13977],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPartitions"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " gives a list of the partitions of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 ", with length ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    ButtonBox["PartitionsP",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PartitionsP"], "[", 
    StyleBox["n", "TI"], "]"}], TraditionalForm]], "InlineFormula"],
 "."
}], "Text",
 CellID->162149931],

Cell["This gives a table of Stirling numbers of the first kind. ", \
"MathCaption",
 CellID->2306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"StirlingS1", "[", 
    RowBox[{"5", ",", "i"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->31673],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"24", ",", 
   RowBox[{"-", "50"}], ",", "35", ",", 
   RowBox[{"-", "10"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->75289477]
}, Open  ]],

Cell["\<\
The Stirling numbers appear as coefficients in this product. \
\>", "MathCaption",
 CellID->5021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"x", "-", "i"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->28745],

Cell[BoxData[
 RowBox[{
  RowBox[{"24", " ", "x"}], "-", 
  RowBox[{"50", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"35", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->522371856]
}, Open  ]],

Cell["Here are the partitions of 4.", "MathCaption",
 CellID->151147588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", "4", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->747710409],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->590634856]
}, Open  ]],

Cell[TextData[{
 "The number of partitions is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PartitionsP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PartitionsP"], "[", "4", "]"}]], 
  "InlineFormula"],
 "."
}], "MathCaption",
 CellID->70390537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "%", "]"}], "\[Equal]", 
  RowBox[{"PartitionsP", "[", "4", "]"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->69445989],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1130608358]
}, Open  ]],

Cell["\<\
This gives the number of partitions of 100, with and without the constraint \
that the terms should be distinct. \
\>", "MathCaption",
 CellID->19072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PartitionsQ", "[", "100", "]"}], ",", 
   RowBox[{"PartitionsP", "[", "100", "]"}]}], "}"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->6270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"444793", ",", "190569292"}], "}"}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->1199364250]
}, Open  ]],

Cell[TextData[{
 "The partition function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 " increases asymptotically like ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", 
    SqrtBox["n"]], TraditionalForm]], "InlineMath"],
 ". Note that you cannot simply use ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " to generate a plot of a function like ",
 Cell[BoxData[
  ButtonBox["PartitionsP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsP"]], "InlineFormula"],
 " because the function can only be evaluated with integer arguments. "
}], "MathCaption",
 CellID->26777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"Log", "[", 
      RowBox[{"PartitionsP", "[", "n", "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->15573],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWFdv1UgUduLbCCBqEghFYSkJRZQVHQKhbUQHAQqgUC41WRSCQigCIYpo
ouzCLqEkIDoI8cADCCRekRA88cozf8TMeOyZ8fE3nksUEFeKnbG/cs6ZM3N9
vTLf1ri7Od/WtDNfWdeaP9DYtPNg5V8treySW+Q4zhv21zbIYf977D//743n
sbN+rGLHFLtVzM7F7FzBr/ILXvjhVwcHZzc4DyLjcnZ2NRVXOztONT+mhaY8
+ljHlU6+huYMEKX8kNERGDewQFxpomMYIy9lET/718YWFCUHOGnpHaiV/wbx
jwOImCa9H/EoNIvSoAcMCt0cd1mimwvvlP3EOlcVqG2Om6+xcNXIi7+0V6q9
6GrGe0OFloFpb6B7gtob4jtSbxL5E3WVez998mV+zZ2rVz489q+XsOMzdjkV
RX3+9K1l/+t3b7+miFq6m8c/W/9Xj2k+GVXXoBflBDhDCHYuGQ8j49ExrfoN
z5jWkkV3nUexe3IKtXtypbgqigeKmdV7U2lriJyOYA6b6p8LmfsKo0UsvJRS
Aiot4j154n0Q171I1GmidA8qpaBSJ8RmiGICKqVn2gFxWaLWEYk+B+O6DZV6
+I5CSQBvJeCYJrMTphhXAr3bIbYXyaI9kkXvWC1uQBXRhUJlUW1n4PhfAlZE
t2rFw8BXYPmcu3LuFacPzOiaz8nBDlTjfrHq/ls4LyOrLdO6amTzYX+YneBk
Ip1NvpEiVb4i8Uk7TSms+iWfmw28ICerx6eYF+F8lcOMFFZ9z+kZXIBaFTDi
c2asK32dYoZ2XIYP7p+BrKGGWcPoYTA3heW5VcZyOw21KmFuJ81YwyycgIw/
LNU4BlmjDNVQaJ7hGIv2EahdZdDG6OqEjA9BxjhLVK2QNcEQlULzjCdatFug
9iSDNkZPTsi42WcEj2DBJ3wapLvDn5ZY//ZF4k/DdD+j46mGbH5Ejw+nWeLb
28X4Zhji66reTEucu7qoO9sQp9ALHtr9T/gcT2d4TkKn7JC9xZnzLDlsg504
3/P05wYmTnkNkFcL3VRsmLWQH3KMtWP7yy0NL0hCmyFniSWvesiqM1ReoXnN
llq010PtZdaarYW85ZaaYdbKxJqthpw1lrxWRKqwzprPUuiyzpIPZm1IzKcO
cjZCp6a9rwKnxZC1OZpXbU0HzWtBpA4NYWTMpf3GR9I5C6DHVktk/qqUb6/E
J5Sga3176C/j1f3934OxHcYlY3o/zw9pmZOhH2Z1SXu3tW+mF6zLh3ss/aSp
xd6b0Fo2JnbZVKUUeydEn6z3WWZ4ikf38pSHn6+brf04EfbYfi/Yy0hfUvb4
SDe3Wqo5HnodDL1I3ajXGMg+bPHErKNhXaQnrfFIyDsezjFcLyMi1fCfnA3r
QPkMhz6nrPM2BPL83wIlcD+RloMh86wWrZgCZhpbtWWQe77AbhkQqc8lNHMp
EayItD90u2yYOzXnfSHvnwL7rCdkX7f0GWb9b+2zHOTdTOwz9U6P19F/i5Ml
fRb8dsxA9U4tF/5+DqPEe1un6DvSralJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->94260783]
}, Open  ]],

Cell[TextData[{
 "Most of the functions here allow you to ",
 StyleBox["count",
  FontSlant->"Italic"],
 " various kinds of combinatorial objects. Functions like ",
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Permutations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Permutations"]], "InlineFormula"],
 " allow you instead to ",
 StyleBox["generate",
  FontSlant->"Italic"],
 " lists of various combinations of elements. "
}], "Text",
 CellID->16512],

Cell[TextData[{
 "The ",
 StyleBox["signature function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Signature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Signature"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " gives the signature of a permutation. It is equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 " for even permutations (composed of an even number of transpositions), and \
to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " for odd permutations. The signature function can be thought of as a \
totally antisymmetric tensor, ",
 StyleBox["Levi\[Hyphen]Civita symbol", "TB"],
 " or ",
 StyleBox["epsilon symbol", "TB"],
 "."
}], "Text",
 CellID->23986],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ClebschGordan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ClebschGordan"], "[", "{", 
     SubscriptBox[
      StyleBox["j", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["m", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["j", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["m", "TI"], "2"], "}", ",", "{", 
     StyleBox["j", "TI"], ",", 
     StyleBox["m", "TI"], "}", "]"}], Cell[
    "Clebsch\[Hyphen]Gordan coefficient", "TableText"]},
   {
    RowBox[{
     ButtonBox["ThreeJSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ThreeJSymbol"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], "1"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], "2"], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], "3"], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], "3"]}], "}"}]}], "]"}], Cell[
    "Wigner 3\[Hyphen]j symbol", "TableText"]},
   {
    RowBox[{
     ButtonBox["SixJSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SixJSymbol"], "[", "{", 
     SubscriptBox[
      StyleBox["j", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "3"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["j", "TI"], "4"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "5"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "6"], "}", "]"}], Cell[
    "Racah 6\[Hyphen]j symbol", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.5]}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13290],

Cell["Rotational coupling coefficients. ", "Caption",
 CellID->9161],

Cell[TextData[{
 "Clebsch\[Hyphen]Gordan coefficients and ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "\[Hyphen]j symbols arise in the study of angular momenta in quantum \
mechanics, and in other applications of the rotation group. The ",
 StyleBox["Clebsch\[Hyphen]Gordan coefficients", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClebschGordan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClebschGordan"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["j", "TI"], ",", 
      StyleBox["m", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " give the coefficients in the expansion of the quantum mechanical angular \
momentum state ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[VerticalSeparator]", "j", ",", "m", "\[RightAngleBracket]"}], 
   TraditionalForm]], "InlineMath"],
 " in terms of products of states ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[VerticalSeparator]", 
         SubscriptBox["j", "1"]}], ",", 
        SubscriptBox["m", "1"]}], "\[RightAngleBracket]"}], " ", 
      "\[VerticalSeparator]", 
      SubscriptBox["j", "2"]}], ",", 
     SubscriptBox["m", "2"]}], "\[RightAngleBracket]"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->18636],

Cell[TextData[{
 "The ",
 StyleBox["3\[Hyphen]j symbols", "TB"],
 " or ",
 StyleBox["Wigner coefficients", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ThreeJSymbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ThreeJSymbol"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["3", "TR"]], ",", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " are a more symmetrical form of Clebsch\[Hyphen]Gordan coefficients. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the Clebsch\[Hyphen]Gordan coefficients are given in terms of 3\[Hyphen]j \
symbols by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["C", 
     RowBox[{
      SubscriptBox["m", "1"], 
      SubscriptBox["m", "2"], 
      SubscriptBox["m", "3"]}], 
     RowBox[{
      SubscriptBox["j", "1"], 
      SubscriptBox["j", "2"], 
      SubscriptBox["j", "3"]}]], " ", "=", " ", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{
       SubscriptBox["m", "3"], "+", 
       SubscriptBox["j", "1"], "-", 
       SubscriptBox["j", "2"]}]], 
     SqrtBox[
      RowBox[{"2", 
       SubscriptBox["j", "3"], "+", "1"}]], 
     RowBox[{"(", 
      RowBox[{GridBox[{
         {
          SubscriptBox["j", "1"]},
         {
          SubscriptBox["m", "1"]}
        }], " ", GridBox[{
         {
          SubscriptBox["j", "2"]},
         {
          SubscriptBox["m", "2"]}
        }], " ", GridBox[{
         {
          SubscriptBox["j", "3"]},
         {
          RowBox[{"-", 
           SubscriptBox["m", "3"]}]}
        }]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->22355],

Cell[TextData[{
 "The ",
 StyleBox["6\[Hyphen]j symbols", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SixJSymbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SixJSymbol"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["3", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["4", "TR"]], ",", 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["5", "TR"]], ",", 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["6", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " give the couplings of three quantum mechanical angular momentum states. \
The ",
 StyleBox["Racah coefficients", "TB"],
 " are related by a phase to the 6\[Hyphen]j symbols. "
}], "Text",
 CellID->24767],

Cell["\<\
You can give symbolic parameters in 3\[Hyphen]j symbols. \
\>", "MathCaption",
 CellID->23655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThreeJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"j", ",", "m"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"j", "+", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{
      RowBox[{"-", "m"}], "-", 
      RowBox[{"1", "/", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->15574],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"-", "j"}], "+", "m"}]], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{"1", "+", "j", "+", "m"}], 
      RowBox[{"1", "+", 
       RowBox[{"3", " ", "j"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["j", "2"]}]}]]]}], 
   SqrtBox["2"]]}]], "Output",
 ImageSize->{138, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1337855410]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->466223188],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Combinatorial Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ElementaryTranscendentalFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 14.4362358}", "context" -> "", 
    "keywords" -> {
     "!!", "!", "3-j symbols", "6-j symbols", "angular momentum", 
      "antisymmetry", "bang", "BellB", "BernoulliB", "Bernoulli numbers", 
      "Bernoulli polynomials", "binomial", "Catalan numbers", "choose", 
      "ClebschGordan", "combinatorial functions", "double factorial", 
      "epsilon symbol", "EulerE", "Euler-Maclaurin summation formula", 
      "Euler numbers", "Euler polynomials", "exclamation point", "factorial", 
      "Factorial2", "Fibonacci", "Genocchi numbers", 
      "group coupling coefficients", "HarmonicNumber", "harmonic series", 
      "integers", "Levi-Civita symbol", "Multinomial", "partitions", 
      "PartitionsP", "PartitionsQ", "Permutations", "polynomials", 
      "pseudotensors", "quantum mechanics", "Racah coefficients", 
      "recoupling coefficients", "rotational coupling coefficients", 
      "rotation group", "shriek", "signature", "SixJSymbol", "spin", 
      "Stirling numbers", "StirlingS1", "StirlingS2", "ThreeJSymbol", 
      "Wigner coefficients"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Combinatorial functions. The factorial function n! gives the number of \
ways of ordering n objects. For non-integer n, the numerical value of n! is \
obtained from the gamma function, discussed in \"Special Functions\". The \
binomial coefficient Binomial[n,m] can be written as (GridBox[{{n}, \
{m}}])=n!/[m!(n-m)!]. It gives the number of ways of choosing m objects from \
a collection of n objects, without regard to order. The Catalan numbers, \
which appear in various tree enumeration problems, are given in terms of \
binomial coefficients as c_n=(GridBox[{{RowBox[{2, n}]}, {n}}])/(n+1). ", 
    "synonyms" -> {"3.2.6"}, "title" -> "Combinatorial Functions", "type" -> 
    "Tutorial", "uri" -> "tutorial/CombinatorialFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.6"->{
  Cell[3905, 89, 85, 2, 70, "Title",
   CellTags->{"S3.2.6", "6.1"},
   CellID->8942]},
 "6.1"->{
  Cell[3905, 89, 85, 2, 70, "Title",
   CellTags->{"S3.2.6", "6.1"},
   CellID->8942]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.6", 61235, 2135},
 {"6.1", 61333, 2139}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3280, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3905, 89, 85, 2, 70, "Title",
 CellTags->{"S3.2.6", "6.1"},
 CellID->8942],
Cell[3993, 93, 10571, 358, 70, "DefinitionBox",
 CellID->19264],
Cell[14567, 453, 59, 1, 70, "Caption",
 CellID->22648],
Cell[14629, 456, 673, 23, 70, "Text",
 CellID->27446],
Cell[15305, 481, 1364, 52, 70, "Text",
 CellID->23805],
Cell[16672, 535, 836, 30, 70, "Text",
 CellID->221576235],
Cell[17511, 567, 1546, 58, 70, "Text",
 CellID->15890],
Cell[19060, 627, 167, 5, 70, "MathCaption",
 CellID->6729],
Cell[CellGroupData[{
Cell[19252, 636, 84, 3, 28, "Input",
 CellID->24370],
Cell[19339, 641, 191, 5, 36, "Output",
 CellID->551399794]
}, Open  ]],
Cell[19545, 649, 182, 6, 70, "MathCaption",
 CellID->15006],
Cell[CellGroupData[{
Cell[19752, 659, 85, 3, 70, "Input",
 CellID->31101],
Cell[19840, 664, 176, 5, 36, "Output",
 CellID->984400953]
}, Open  ]],
Cell[20031, 672, 161, 5, 70, "MathCaption",
 CellID->3548],
Cell[CellGroupData[{
Cell[20217, 681, 123, 4, 70, "Input",
 CellID->19629],
Cell[20343, 687, 278, 10, 51, "Output",
 CellID->612800583]
}, Open  ]],
Cell[20636, 700, 251, 7, 70, "MathCaption",
 CellID->24084],
Cell[CellGroupData[{
Cell[20912, 711, 126, 4, 70, "Input",
 CellID->19954],
Cell[21041, 717, 158, 5, 36, "Output",
 CellID->7827469]
}, Open  ]],
Cell[21214, 725, 215, 10, 70, "MathCaption",
 CellID->11840],
Cell[CellGroupData[{
Cell[21454, 739, 123, 4, 70, "Input",
 CellID->4966],
Cell[21580, 745, 160, 5, 36, "Output",
 CellID->559769016]
}, Open  ]],
Cell[21755, 753, 1587, 58, 70, "Text",
 CellID->13931],
Cell[23345, 813, 925, 34, 70, "Text",
 CellID->26308],
Cell[24273, 849, 1294, 44, 70, "Text",
 CellID->16944],
Cell[25570, 895, 1894, 69, 70, "Text",
 CellID->32439],
Cell[27467, 966, 530, 17, 70, "Text",
 CellID->24626],
Cell[28000, 985, 1391, 54, 70, "Text",
 CellID->11323],
Cell[29394, 1041, 2357, 80, 70, "Text",
 CellID->322603501],
Cell[31754, 1123, 223, 9, 70, "MathCaption",
 CellID->5537],
Cell[CellGroupData[{
Cell[32002, 1136, 125, 4, 70, "Input",
 CellID->21538],
Cell[32130, 1142, 236, 8, 51, "Output",
 CellID->2059478052]
}, Open  ]],
Cell[32381, 1153, 157, 4, 70, "MathCaption",
 CellID->2082],
Cell[CellGroupData[{
Cell[32563, 1161, 377, 13, 70, "Input",
 CellID->22929],
Cell[32943, 1176, 1706, 54, 81, "Output",
 CellID->506197618]
}, Open  ]],
Cell[34664, 1233, 295, 9, 70, "MathCaption",
 CellID->4833],
Cell[CellGroupData[{
Cell[34984, 1246, 103, 3, 70, "Input",
 CellID->31115],
Cell[35090, 1251, 204, 7, 51, "Output",
 CellID->1480639959]
}, Open  ]],
Cell[35309, 1261, 1784, 59, 70, "Text",
 CellID->29658],
Cell[37096, 1322, 1185, 39, 70, "Text",
 CellID->22704],
Cell[38284, 1363, 1252, 45, 70, "Text",
 CellID->9930],
Cell[39539, 1410, 840, 26, 70, "Text",
 CellID->13977],
Cell[40382, 1438, 559, 20, 70, "Text",
 CellID->162149931],
Cell[40944, 1460, 98, 2, 70, "MathCaption",
 CellID->2306],
Cell[CellGroupData[{
Cell[41067, 1466, 232, 8, 70, "Input",
 CellID->31673],
Cell[41302, 1476, 275, 9, 36, "Output",
 CellID->75289477]
}, Open  ]],
Cell[41592, 1488, 107, 3, 70, "MathCaption",
 CellID->5021],
Cell[CellGroupData[{
Cell[41724, 1495, 243, 8, 70, "Input",
 CellID->28745],
Cell[41970, 1505, 407, 14, 36, "Output",
 CellID->522371856]
}, Open  ]],
Cell[42392, 1522, 72, 1, 70, "MathCaption",
 CellID->151147588],
Cell[CellGroupData[{
Cell[42489, 1527, 114, 3, 70, "Input",
 CellID->747710409],
Cell[42606, 1532, 485, 16, 36, "Output",
 CellID->590634856]
}, Open  ]],
Cell[43106, 1551, 259, 10, 70, "MathCaption",
 CellID->70390537],
Cell[CellGroupData[{
Cell[43390, 1565, 170, 5, 70, "Input",
 CellID->69445989],
Cell[43563, 1572, 163, 5, 36, "Output",
 CellID->1130608358]
}, Open  ]],
Cell[43741, 1580, 160, 4, 70, "MathCaption",
 CellID->19072],
Cell[CellGroupData[{
Cell[43926, 1588, 193, 6, 70, "Input",
 CellID->6270],
Cell[44122, 1596, 219, 7, 36, "Output",
 CellID->1199364250]
}, Open  ]],
Cell[44356, 1606, 701, 22, 70, "MathCaption",
 CellID->26777],
Cell[CellGroupData[{
Cell[45082, 1632, 315, 10, 28, "Input",
 CellID->15573],
Cell[45400, 1644, 1770, 33, 137, "Output",
 Evaluatable->False,
 CellID->94260783]
}, Open  ]],
Cell[47185, 1680, 587, 19, 70, "Text",
 CellID->16512],
Cell[47775, 1701, 994, 34, 70, "Text",
 CellID->23986],
Cell[48772, 1737, 2280, 72, 70, "DefinitionBox",
 CellID->13290],
Cell[51055, 1811, 68, 1, 70, "Caption",
 CellID->9161],
Cell[51126, 1814, 1728, 57, 70, "Text",
 CellID->18636],
Cell[52857, 1873, 2210, 84, 70, "Text",
 CellID->22355],
Cell[55070, 1959, 1021, 37, 70, "Text",
 CellID->24767],
Cell[56094, 1998, 104, 3, 70, "MathCaption",
 CellID->23655],
Cell[CellGroupData[{
Cell[56223, 2005, 465, 17, 70, "Input",
 CellID->15574],
Cell[56691, 2024, 556, 21, 80, "Output",
 CellID->1337855410]
}, Open  ]],
Cell[CellGroupData[{
Cell[57284, 2050, 72, 1, 70, "RelatedTutorialsSection",
 CellID->466223188],
Cell[57359, 2053, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],
Cell[57561, 2061, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

