(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10011,        349]
NotebookOptionsPosition[      6476,        242]
NotebookOutlinePosition[      8982,        310]
CellTagsIndexPosition[      8893,        304]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsOverview"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Join" :> Documentation`HelpLookup["paclet:ref/Join"], "Riffle" :> 
          Documentation`HelpLookup["paclet:ref/Riffle"], "Union" :> 
          Documentation`HelpLookup["paclet:ref/Union"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Join\"\>", 2->"\<\"Riffle\"\>", 
       3->"\<\"Union\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Combining Lists", "Title",
 CellTags->{"S1.8.7", "7.1"},
 CellID->41],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Join",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Join"], "[", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "concatenate lists together", "TableText"]},
   {
    RowBox[{
     ButtonBox["Union",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Union"], "[", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell["\<\
combine lists, removing repeated elements and sorting the result\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Riffle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Riffle"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[TextData[{
     "interleave elements of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->18467],

Cell["Functions for combining lists. ", "Caption",
 CellID->6334],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Join",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Join"]], "InlineFormula"],
 " concatenates any number of lists together. "
}], "MathCaption",
 CellID->26500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "u"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->19169],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "x", ",", "y", ",", "t", ",", "u"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->15724]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Union",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]], "InlineFormula"],
 " combines lists, keeping only distinct elements. "
}], "MathCaption",
 CellID->11478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->29358],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->26962]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Riffle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Riffle"]], "InlineFormula"],
 " combines lists by interleaving their elements."
}], "MathCaption",
 CellID->833694027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->479976609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", "b", ",", "y", ",", "c", ",", "z"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83087867]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->107265766],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Combining Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/AddingRemovingAndModifyingListElements"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ListsAsSets"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 15.2643820}", "context" -> "", 
    "keywords" -> {
     "catenating lists", "combining lists", "concatenating lists", 
      "join lists", "merging lists", "Riffle", "splicing", "Union"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Functions for combining lists. Join concatenates any number of lists \
together. Union combines lists, keeping only distinct elements. ", 
    "synonyms" -> {"1.8.7"}, "title" -> "Combining Lists", "type" -> 
    "Tutorial", "uri" -> "tutorial/CombiningLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.7"->{
  Cell[1916, 59, 75, 2, 70, "Title",
   CellTags->{"S1.8.7", "7.1"},
   CellID->41]},
 "7.1"->{
  Cell[1916, 59, 75, 2, 70, "Title",
   CellTags->{"S1.8.7", "7.1"},
   CellID->41]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.7", 8688, 293},
 {"7.1", 8784, 297}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1291, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1916, 59, 75, 2, 70, "Title",
 CellTags->{"S1.8.7", "7.1"},
 CellID->41],
Cell[1994, 63, 1799, 61, 70, "DefinitionBox",
 CellID->18467],
Cell[3796, 126, 65, 1, 70, "Caption",
 CellID->6334],
Cell[3864, 129, 209, 7, 70, "MathCaption",
 CellID->26500],
Cell[CellGroupData[{
Cell[4098, 140, 287, 10, 28, "Input",
 CellID->19169],
Cell[4388, 152, 254, 8, 36, "Output",
 CellID->15724]
}, Open  ]],
Cell[4657, 163, 216, 7, 70, "MathCaption",
 CellID->11478],
Cell[CellGroupData[{
Cell[4898, 174, 298, 10, 28, "Input",
 CellID->29358],
Cell[5199, 186, 220, 7, 36, "Output",
 CellID->26962]
}, Open  ]],
Cell[5434, 196, 220, 7, 70, "MathCaption",
 CellID->833694027],
Cell[CellGroupData[{
Cell[5679, 207, 243, 8, 28, "Input",
 CellID->479976609],
Cell[5925, 217, 246, 8, 36, "Output",
 CellID->83087867]
}, Open  ]],
Cell[CellGroupData[{
Cell[6208, 230, 72, 1, 70, "RelatedTutorialsSection",
 CellID->107265766],
Cell[6283, 233, 139, 3, 70, "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],
Cell[6449, 240, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

