(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12426,        419]
NotebookOptionsPosition[      8318,        300]
NotebookOutlinePosition[     11304,        376]
CellTagsIndexPosition[     11213,        370]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abs" :> Documentation`HelpLookup["paclet:ref/Abs"], "Arg" :> 
          Documentation`HelpLookup["paclet:ref/Arg"], "Conjugate" :> 
          Documentation`HelpLookup["paclet:ref/Conjugate"], "I" :> 
          Documentation`HelpLookup["paclet:ref/I"], "Im" :> 
          Documentation`HelpLookup["paclet:ref/Im"], "Re" :> 
          Documentation`HelpLookup["paclet:ref/Re"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Abs\"\>", 2->"\<\"Arg\"\>", 
       3->"\<\"Conjugate\"\>", 4->"\<\"I\"\>", 5->"\<\"Im\"\>", 
       6->"\<\"Re\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Complex Numbers", "Title",
 CellTags->{"S1.1.5", "5.1"},
 CellID->9161],

Cell[TextData[{
 "You can enter complex numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just by including the constant ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 ", equal to ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 ". Make sure that you type a capital ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->18636],

Cell[TextData[{
 "If you are using notebooks, you can also enter ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"],
 " by typing ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ii\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " (see\[NonBreakingSpace]\"",
 ButtonBox["Mathematical Notation in Notebooks: Numerical Calculations\"",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathematicalNotationInNotebooks-NumericalCalculations"],
 "). The form ",
 Cell[BoxData[
  FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"],
 " is normally what is used in output. Note that an ordinary ",
 Cell[BoxData["i"], "InlineFormula"],
 " means a variable named ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 ", not ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->22355],

Cell[TextData[{
 "This gives the imaginary number result\[NonBreakingSpace]",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "i"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->24767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"-", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->23655],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]"}]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->15574]
}, Open  ]],

Cell["This gives the ratio of two complex numbers. ", "MathCaption",
 CellID->4031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"4", "+", 
    RowBox[{"3", " ", "I"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"2", "-", "I"}], ")"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->12052],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->27350]
}, Open  ]],

Cell["Here is the numerical value of a complex exponential. ", "MathCaption",
 CellID->1150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", 
   RowBox[{"2", "+", 
    RowBox[{"9", " ", "I"}]}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->16941],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "6.7323926184992535`"}], "+", 
  RowBox[{"3.045166606857663`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->21724]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "+", 
     ButtonBox["I",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/I"], " ", 
     StyleBox["y", "TI"]}], Cell[TextData[{
     "the complex number ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "+", 
        RowBox[{"i", " ", "y"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Re",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Re"], "[", 
     StyleBox["z", "TI"], "]"}], Cell["real part", "TableText"]},
   {
    RowBox[{
     ButtonBox["Im",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Im"], "[", 
     StyleBox["z", "TI"], "]"}], Cell["imaginary part", "TableText"]},
   {
    RowBox[{
     ButtonBox["Conjugate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Conjugate"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "complex conjugate ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["z", "*"], TraditionalForm]], "InlineMath"],
     " or ",
     Cell[BoxData[
      FormBox[
       OverscriptBox["z", "_"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "absolute value ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[VerticalSeparator]", "z", "\[VerticalSeparator]"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Arg",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Arg"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "the argument ",
     Cell[BoxData[
      FormBox["\[CurlyPhi]", TraditionalForm]], "InlineMath"],
     " in ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[VerticalSeparator]", "z", "\[VerticalSeparator]", 
        RowBox[{
         SuperscriptBox["e", "i"], "\[CurlyPhi]"}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13966],

Cell["Complex number operations. ", "Caption",
 CellID->3430],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->318316046],

Cell[TextData[ButtonBox["Numerical Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalCalculationsOverview"]], "RelatedTutorials",
 CellID->21356267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Complex Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ArbitraryPrecisionCalculations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/GettingUsedToMathematica"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 19.4832400}", "context" -> "", 
    "keywords" -> {
     "abs", "absolute value", "Arg", "argument of complex number", 
      "complex conjugate", "complex numbers", "conjugate", "I", "Im", 
      "imaginary part", "imaginary unit", "modulus", "phase", "re", 
      "real part"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "You can enter complex numbers in Mathematica just by including the \
constant I, equal to SqrtBox[RowBox[{-, 1}]]. Make sure that you type a \
capital I. If you are using notebooks, you can also enter I as I by typing \
Esc ii Esc (see \"Mathematical Notation in Notebooks: Numerical \
Calculations\"). The form I is normally what is used in output. Note that an \
ordinary i means a variable named i, not SqrtBox[RowBox[{-, 1}]]. This gives \
the imaginary number result 2i. ", "synonyms" -> {}, "title" -> 
    "Complex Numbers", "type" -> "Tutorial", "uri" -> 
    "tutorial/ComplexNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.1.5"->{
  Cell[2220, 64, 77, 2, 70, "Title",
   CellTags->{"S1.1.5", "5.1"},
   CellID->9161]},
 "5.1"->{
  Cell[2220, 64, 77, 2, 70, "Title",
   CellTags->{"S1.1.5", "5.1"},
   CellID->9161]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.1.5", 11004, 359},
 {"5.1", 11102, 363}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1595, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2220, 64, 77, 2, 70, "Title",
 CellTags->{"S1.1.5", "5.1"},
 CellID->9161],
Cell[2300, 68, 537, 21, 70, "Text",
 CellID->18636],
Cell[2840, 91, 1037, 33, 70, "Text",
 CellID->22355],
Cell[3880, 126, 201, 7, 70, "MathCaption",
 CellID->24767],
Cell[CellGroupData[{
Cell[4106, 137, 115, 4, 28, "Input",
 CellID->23655],
Cell[4224, 143, 189, 6, 36, "Output",
 CellID->15574]
}, Open  ]],
Cell[4428, 152, 83, 1, 70, "MathCaption",
 CellID->4031],
Cell[CellGroupData[{
Cell[4536, 157, 208, 8, 28, "Input",
 CellID->12052],
Cell[4747, 167, 212, 7, 36, "Output",
 CellID->27350]
}, Open  ]],
Cell[4974, 177, 92, 1, 70, "MathCaption",
 CellID->1150],
Cell[CellGroupData[{
Cell[5091, 182, 169, 6, 28, "Input",
 CellID->16941],
Cell[5263, 190, 266, 8, 36, "Output",
 CellID->21724]
}, Open  ]],
Cell[5544, 201, 2381, 79, 70, "DefinitionBox",
 CellID->13966],
Cell[7928, 282, 61, 1, 70, "Caption",
 CellID->3430],
Cell[CellGroupData[{
Cell[8014, 287, 72, 1, 70, "RelatedTutorialsSection",
 CellID->318316046],
Cell[8089, 290, 175, 4, 70, "RelatedTutorials",
 CellID->21356267]
}, Open  ]]
}, Open  ]],
Cell[8291, 298, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

