(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    287983,      10156]
NotebookOptionsPosition[    231820,       8248]
NotebookOutlinePosition[    262633,       9238]
CellTagsIndexPosition[    261427,       9195]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/SolvingEquations"], 
          "Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/Inequalities-SymbolicMathematics"], 
          "Generic and Non\[Hyphen]Generic Solutions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GenericAndNonGenericSolutions"], 
          "Equations and Inequalities over Domains" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EquationsAndInequalitiesOverDomains"], 
          "Solving Logical Combinations of Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingLogicalCombinationsOfEquations"], 
          "The Representation of Solution Sets" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfSolutionSets"], "Quantifiers" :> 
          Documentation`HelpLookup["paclet:tutorial/Quantifiers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Solving Equations\"\>", 
       2->"\<\"Inequalities\"\>", 
       3->"\<\"Generic and Non\[Hyphen]Generic Solutions\"\>", 
       4->"\<\"Equations and Inequalities over Domains\"\>", 
       5->"\<\"Solving Logical Combinations of Equations\"\>", 
       6->"\<\"The Representation of Solution Sets\"\>", 
       7->"\<\"Quantifiers\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Equation Solving" :> 
          Documentation`HelpLookup["paclet:guide/EquationSolving"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>",
        2->"\<\"Equation Solving\"\>", 3->"\<\"Polynomial Algebra\"\>", 
       4->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GroebnerBasis" :> 
          Documentation`HelpLookup["paclet:ref/GroebnerBasis"], "Integers" :> 
          Documentation`HelpLookup["paclet:ref/Integers"], "Method" :> 
          Documentation`HelpLookup["paclet:ref/Method"], "Rationals" :> 
          Documentation`HelpLookup["paclet:ref/Rationals"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GroebnerBasis\"\>", 
       2->"\<\"Integers\"\>", 3->"\<\"Method\"\>", 
       4->"\<\"Rationals\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Complex Polynomial Systems", "Title",
 CellID->7121304],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->{"t:3", "c:3", "b:0.0"},
 CellID->73712623],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " allow you to solve a wide variety of problems that can be expressed in \
terms of equations and inequalities. The functions use a collection of \
algorithms applicable to classes of problems satisfying particular \
properties, as well as a set of heuristics that attempt to reduce the given \
problem to a sequence of problems that can be solved using the algorithms. \
This tutorial describes the algorithms used to solve the class of problems \
known as complex polynomial systems. It characterizes the structure of the \
returned answers and describes the options that affect various aspects of the \
methods involved."
}], "Text",
 CellTags->"b:0.0",
 CellID->142044117],

Cell["\<\
A complex polynomial system is an expression constructed with polynomial \
equations and inequations\
\>", "Text",
 CellTags->"b:0.0",
 CellID->60612736],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", " ", 
    RowBox[{
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], "  ", 
     StyleBox["and", "Text"], "  ", 
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], "\[NotEqual]", " ", 
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}]}]}], TraditionalForm]], "DisplayMath",
 CellTags->"b:0.0",
 CellID->646880285],

Cell["combined using logical connectives and quantifiers", "Text",
 CellTags->"b:0.0",
 CellID->9470698],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "1"], "\[And]", 
    SubscriptBox["\[CapitalPhi]", "2"]}], ",", " ", 
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "1"], "\[Or]", 
    SubscriptBox["\[CapitalPhi]", "2"]}], ",", " ", 
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "1"], "\[Implies]", 
    SubscriptBox["\[CapitalPhi]", "2"]}], ",", 
   RowBox[{"\[Not]", "\[CapitalPhi]"}], ",", 
   RowBox[{
    SubscriptBox["\[ForAll]", "x"], "\[CapitalPhi]"}], ",", " ", 
   RowBox[{
    StyleBox["and", "Text"], "  ", 
    RowBox[{
     SubscriptBox["\[Exists]", "x"], 
     RowBox[{"\[CapitalPhi]", "."}]}]}]}], TraditionalForm]], "DisplayMath",
 CellTags->"b:0.0",
 CellID->92176511],

Cell[TextData[{
 "An occurrence of a variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " inside ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ForAll]", "x"], "\[CapitalPhi]"}], TraditionalForm]], 
  "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Exists]", "x"], "\[CapitalPhi]"}], TraditionalForm]], 
  "InlineMath"],
 " is called a ",
 "bound occurrence",
 ", and any other occurrence of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is called a ",
 "free occurrence.",
 " A variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is called a ",
 "free variable",
 " of a complex polynomial system if the system contains a free occurrence of \
",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". A complex polynomial system is ",
 "quantifier-free",
 " if it contains no quantifiers."
}], "Text",
 CellTags->"b:0.0",
 CellID->321261601],

Cell[TextData[{
 "Here is an example of a complex polynomial system with free variables ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.0",
 CellID->9009455],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", 
    SuperscriptBox["z", "2"]}], "\[And]", 
   RowBox[{
    SubscriptBox["\[Exists]", "t"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[ForAll]", "u"], 
       RowBox[{
        RowBox[{"t", " ", "x"}], "\[NotEqual]", 
        RowBox[{
         RowBox[{"u", " ", "y", " ", "z"}], "+", "7"}]}]}], "\[Or]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "t"}], "\[Equal]", 
       RowBox[{
        RowBox[{"2", " ", "z"}], "+", "1"}]}]}], ")"}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(1)"}]]}, {None, None}},
 CellTags->{"Complex1", "b:0.0"},
 CellID->403973843],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " quantifiers are represented using the functions ",
 Cell[BoxData[
  ButtonBox["Exists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exists"]], "InlineFormula"],
 " (",
 Cell[BoxData[
  FormBox["\[Exists]", TraditionalForm]], "InlineMath"],
 ") and ",
 Cell[BoxData[
  ButtonBox["ForAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ForAll"]], "InlineFormula"],
 " (",
 Cell[BoxData[
  FormBox["\[ForAll]", TraditionalForm]], "InlineMath"],
 ")."
}], "Text",
 CellTags->"b:0.0",
 CellID->107843165],

Cell["\<\
Any complex polynomial system can be transformed to the prenex normal form\
\>", "Text",
 CellTags->"b:0.0",
 CellID->14769913],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["Q", 
     RowBox[{"1", " ", 
      SubscriptBox["x", "1"]}]], 
    SubscriptBox["Q", 
     RowBox[{"2", " ", 
      SubscriptBox["x", "2"]}]], 
    SubscriptBox["\[Ellipsis]Q", 
     RowBox[{"n", " ", 
      SubscriptBox["x", "n"]}]], 
    RowBox[{"\[CapitalPhi]", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      RowBox[{
       SubscriptBox["x", "n"], ";", 
       SubscriptBox["y", "1"]}], ",", "\[Ellipsis]", ",", 
      SubscriptBox["y", "m"]}], ")"}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellTags->{"PNF", "b:0.0"},
 CellID->545791106],

Cell[TextData[{
 "where each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Q", "i"], TraditionalForm]], "InlineMath"],
 " is a quantifier ",
 Cell[BoxData[
  FormBox["\[ForAll]", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox["\[Exists]", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     RowBox[{
      SubscriptBox["x", "n"], ";", 
      SubscriptBox["y", "1"]}], ",", "\[Ellipsis]", ",", 
     SubscriptBox["y", "m"]}], ")"}], TraditionalForm]], "InlineMath"],
 " is quantifier-free."
}], "Text",
 CellTags->"b:0.0",
 CellID->337844267],

Cell["\<\
Any quantifier-free complex polynomial system can be transformed to the \
disjunctive normal form\
\>", "Text",
 CellTags->"b:0.0",
 CellID->928012757],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[CurlyPhi]", 
       RowBox[{"1", ",", "1"}]], "\[And]", "\[Ellipsis]", "\[And]", 
      SubscriptBox["\[CurlyPhi]", 
       RowBox[{"1", ",", 
        SubscriptBox["n", "1"]}]]}], ")"}], "\[Or]", "\[Ellipsis]", "\[Or]", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[CurlyPhi]", 
       RowBox[{"m", ",", "1"}]], "\[And]", "\[Ellipsis]", "\[And]", 
      SubscriptBox["\[CurlyPhi]", 
       RowBox[{"m", ",", 
        SubscriptBox["n", "m"]}]]}], ")"}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellTags->{"DNF", "b:0.0"},
 CellID->348193030],

Cell[TextData[{
 "where each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CurlyPhi]", 
    RowBox[{"i", ",", "j"}]], TraditionalForm]], "InlineMath"],
 " is a polynomial equation or inequation. "
}], "Text",
 CellTags->"b:0.0",
 CellID->112672566],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " always put complex polynomial systems in the prenex normal form, with \
quantifier-free parts in the disjunctive normal form, and subtract the sides \
of the equations and inequations to put them in the form"
}], "Text",
 CellTags->"b:0.0",
 CellID->336911978],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", " ", 
    RowBox[{"0", "  ", "and", "  ", 
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], "\[NotEqual]", " ", "0."}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.0",
 CellID->602828466],

Cell["\<\
In all the tutorials for complex polynomial system solving, assume that the \
system has been transformed to this form.\
\>", "Text",
 CellTags->"b:0.0",
 CellID->443188525],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can solve arbitrary complex polynomial systems. The solution (possibly \
after expanding ",
 Cell[BoxData[
  FormBox["\[And]", TraditionalForm]], "InlineMath"],
 " with respect to ",
 Cell[BoxData[
  FormBox["\[Or]", TraditionalForm]], "InlineMath"],
 ") is a disjunction of terms of the form"
}], "Text",
 CellTags->"b:0.0",
 CellID->332287509],

Cell[BoxData[{
 FormBox[
  RowBox[{
   SubscriptBox["x", "1"], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["r", "1"], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "1"], "(", 
       SubscriptBox["x", "1"], ")"}], "\[NotEqual]", "0"}], "\[And]", 
     SubscriptBox["x", "2"]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["r", "2"], "(", 
      SubscriptBox["x", "1"], ")"}], " ", "\[And]", "  ", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "2"], "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", 
        SubscriptBox["x", "2"]}], ")"}], "\[NotEqual]", "0"}], " ", "\[And]", 
     "\[Ellipsis]"}]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     RowBox[{"\[And]", " ", 
      RowBox[{
       RowBox[{
        SubscriptBox["g", 
         RowBox[{"n", "-", "1"}]], "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["x", 
          RowBox[{"n", "-", "1"}]]}], ")"}], "\[NotEqual]", "0"}], " ", 
      "\[And]", " ", 
      SubscriptBox["x", "n"]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["r", "n"], "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", 
         RowBox[{"n", "-", "1"}]]}], ")"}], " ", "\[And]", "  ", 
      RowBox[{
       RowBox[{
        SubscriptBox["g", "n"], "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", "0"}]}]}], ","}]}], 
  TraditionalForm]}], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(2)"}]]}, {None, None}},
 TextAlignment->Center,
 CellTags->{"GeneralComplexSolution", "b:0.0"},
 CellID->136556618],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " are the free variables of the system, each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 " is a polynomial, each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "i"], TraditionalForm]], "InlineMath"],
 " is an algebraic function expressed using radicals or ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects, and any terms of the conjunction (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData:>"GeneralComplexSolution"],
 ") may be absent. Each ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "i"], "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", 
      RowBox[{"i", "-", "1"}]]}], ")"}], TraditionalForm]], "InlineMath"],
 " is well defined, that is, no denominators or leading terms of ",
 StyleBox["Root", "MR"],
 " objects in ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "i"], TraditionalForm]], "InlineMath"],
 " become zero for any ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", 
      RowBox[{"i", "-", "1"}]]}], ")"}], TraditionalForm]], "InlineMath"],
 " satisfying the preceding terms of the conjunction (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData:>"GeneralComplexSolution"],
 ")."
}], "Text",
 CellTags->"b:0.0",
 CellID->8410713],

Cell[TextData[{
 "This solves the system (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData:>"Complex1"],
 ")."
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->237750176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[Equal]", 
     SuperscriptBox["z", "2"]}], "&&", 
    RowBox[{
     SubscriptBox["\[Exists]", "t"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[ForAll]", "u"], 
        RowBox[{
         RowBox[{"t", " ", "x"}], "\[NotEqual]", 
         RowBox[{
          RowBox[{"u", " ", "y", " ", "z"}], "+", "7"}]}]}], "||", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], " ", "t"}], "\[Equal]", 
        RowBox[{
         RowBox[{"2", " ", "z"}], "+", "1"}]}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[1]:=",
 CellID->122593157],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "x"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", "x"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"\[ImaginaryI]", " ", "x"}]}]}], ")"}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "\[Equal]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}]]}]}], "||", 
      RowBox[{"z", "\[Equal]", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}]]}]}], ")"}], "&&", 
    RowBox[{"x", "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], ")"}]}]], "Output",
 ImageSize->{502, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[1]=",
 CellID->390816834]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " can eliminate quantifiers from arbitrary complex polynomial systems. If no \
variables are specified, the result is a logical combination of terms"
}], "Text",
 CellTags->"b:0.0",
 CellID->340462317],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", 
    RowBox[{"0", "  ", "and", "  ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], "\[NotEqual]", "0"}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.0",
 CellID->273437329],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " are polynomials, and each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " is a free variable of the system. With variables specified in the input, \
",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " gives the same answer as ",
 StyleBox["Reduce", "MR"],
 ". "
}], "Text",
 CellTags->"b:0.0",
 CellID->139558513],

Cell[TextData[{
 "This eliminates quantifiers from the system (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData:>"Complex1"],
 ")."
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->609600025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", 
    SuperscriptBox["z", "2"]}], "&&", 
   RowBox[{
    SubscriptBox["\[Exists]", "t"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[ForAll]", "u"], 
       RowBox[{
        RowBox[{"t", " ", "x"}], "\[NotEqual]", 
        RowBox[{
         RowBox[{"u", " ", "y", " ", "z"}], "+", "7"}]}]}], "||", 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], " ", "t"}], "\[Equal]", 
       RowBox[{
        RowBox[{"2", " ", "z"}], "+", "1"}]}]}], ")"}]}]}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[2]:=",
 CellID->27783491],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", "z"}], "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", "z"}], "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "y"}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "z"}]}], "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "y"}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "z"}]}], "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "-", 
      SuperscriptBox["z", "2"]}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"y", "-", "z"}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{"y", "+", "z"}], "\[NotEqual]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{472, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[2]=",
 CellID->937920616]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " can handle arbitrary complex polynomial systems giving instances of \
complex solutions, or an empty list for systems that have no solutions. If \
the number of instances requested is more than one, the instances are \
randomly generated from the full solution of the system, and therefore they \
may depend on the value of the ",
 Cell[BoxData["RandomSeed"], "InlineFormula"],
 " option. If one instance is requested, a faster algorithm that produces one \
instance is used, and the instance returned is always the same."
}], "Text",
 CellTags->"b:0.0",
 CellID->74100314],

Cell[TextData[{
 "This finds a solution for the system (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData:>"Complex1"],
 ")."
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->135036826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[Equal]", 
     SuperscriptBox["z", "2"]}], "&&", 
    RowBox[{
     SubscriptBox["\[Exists]", "t"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[ForAll]", "u"], 
        RowBox[{
         RowBox[{"t", " ", "x"}], "\[NotEqual]", 
         RowBox[{
          RowBox[{"u", " ", "y", " ", "z"}], "+", "7"}]}]}], "||", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], " ", "t"}], "\[Equal]", 
        RowBox[{
         RowBox[{"2", " ", "z"}], "+", "1"}]}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[3]:=",
 CellID->27486418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "0"}], ",", 
    RowBox[{"z", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[3]=",
 CellID->195779055]
}, Open  ]],

Cell[TextData[{
 "The main tool used in solving complex polynomial systems is the Gr\
\[ODoubleDot]bner basis algorithm [",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"BW"],
 "], which is available in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as the ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"b:0.0",
 CellID->27312213]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gr\[ODoubleDot]bner Bases", "Section",
 CellTags->"GroebnerBasis",
 CellID->138375135],

Cell[CellGroupData[{

Cell["Theory", "Subsection",
 CellTags->"b:0.1.0",
 CellID->143442327],

Cell[TextData[{
 "This section gives a very brief introduction to the theory of Gr\
\[ODoubleDot]bner bases. It presents only the properties that are necessary \
to describe the algorithms used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in solving complex polynomial systems. For a more complete presentation \
see, for example, [",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"BW"],
 ", ",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"CLS"],
 "]. Note that what [",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"CLS"],
 "] calls a monomial, [",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"BW"],
 "] calls a term, and vice versa. This tutorial uses the terminology of [",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"BW"],
 "]."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->45515852],

Cell[TextData[{
 "A ",
 "monomial",
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " is an expression of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     SubscriptBox["x", "1"], 
     SubscriptBox["e", "1"]], 
    SuperscriptBox[
     SubscriptBox["\[Ellipsis]x", "n"], 
     SubscriptBox["e", "n"]]}], TraditionalForm]], "InlineMath"],
 " with non\[Hyphen]negative integers ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->809364157],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"M", "=", 
    RowBox[{"M", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 " be the set of all monomials in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 ". A ",
 "monomial order",
 " is a linear order ",
 Cell[BoxData[
  FormBox["\[PrecedesSlantEqual]", TraditionalForm]], "InlineMath"],
 " on ",
 Cell[BoxData[
  FormBox["M", TraditionalForm]], "InlineMath"],
 ",",
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[PrecedesSlantEqual]", "t"}], TraditionalForm]], 
  "InlineMath"],
 " for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", "M"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", "1"], "\[PrecedesSlantEqual]", 
    SubscriptBox["t", "2"]}], TraditionalForm]], "InlineMath"],
 " implies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["t", "1"], "s"}], "\[PrecedesSlantEqual]", 
    RowBox[{
     SubscriptBox["t", "2"], "s"}]}], TraditionalForm]], "InlineMath"],
 " for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", "1"], ",", 
    SubscriptBox["t", "2"], ",", 
    RowBox[{"s", " ", "\[Element]", " ", "M"}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->95853517],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " be a field, the domain of integers, or the domain of univariate \
polynomials over a field. Let ",
 Cell[BoxData[
  FormBox[
   StyleBox["Quot",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["Rem",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " ",
 "be functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["R", "2"], "\[LongRightArrow]", "R"}], TraditionalForm]], 
  "InlineMath"],
 " defined as follows. If ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is a field, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["Quot",
      FontSlant->"Italic"], "(", 
     RowBox[{"a", ",", "b"}], ")"}], "=", 
    RowBox[{"a", "/", "b"}]}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["Rem",
      FontSlant->"Italic"], "(", 
     RowBox[{"a", ",", "b"}], ")"}], "=", "0"}], TraditionalForm]], 
  "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is the domain of integers, ",
 Cell[BoxData[
  FormBox[
   StyleBox["Quot",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["Rem",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " are the integer quotient and remainder functions, with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    RowBox[{"|", "b", "|", 
     RowBox[{
      RowBox[{"/", "2"}], "<", 
      RowBox[{
       StyleBox["Rem",
        FontSlant->"Italic"], "(", 
       RowBox[{"a", ",", "b"}], ")"}], "\[LessEqual]"}], "|", "b", "|", 
     RowBox[{"/", "2"}]}]}], TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is the domain of univariate polynomials over a field, ",
 Cell[BoxData[
  FormBox[
   StyleBox["Quot",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["Rem",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " are the polynomial quotient and remainder functions."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->350947462],

Cell[TextData[{
 "A product ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{"a", " ", "m"}]}], TraditionalForm]], "InlineMath"],
 ", where",
 " a ",
 "is a nonzero element of",
 " ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " ",
 "and",
 " ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " ",
 "is a monomial, is called a ",
 "term",
 "."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->102932712],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox["\[PrecedesSlantEqual]", TraditionalForm]], "InlineMath"],
 " be a monomial order on ",
 Cell[BoxData[
  FormBox["M", TraditionalForm]], "InlineMath"],
 ", and let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "\[Element]", 
    RowBox[{
     RowBox[{"R", "[", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], "]"}], "\\", 
     RowBox[{"{", "0", "}"}]}]}], TraditionalForm]], "InlineMath"],
 ". The leading monomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LM",
     FontSlant->"Italic"], "(", "f", ")"}], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " is the ",
 Cell[BoxData[
  FormBox["\[PrecedesSlantEqual]", TraditionalForm]], "InlineMath"],
 "-largest monomial appearing in ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", the leading coefficient ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LC",
     FontSlant->"Italic"], "(", "f", ")"}], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " is the coefficient at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LM",
     FontSlant->"Italic"], "(", "f", ")"}], TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", and the leading term ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", "f", ")"}], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " is the product ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["LC",
      FontSlant->"Italic"], "(", "f", ")"}], 
    RowBox[{
     StyleBox["LM",
      FontSlant->"Italic"], "(", "f", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->115687632],

Cell[TextData[{
 "A Gr\[ODoubleDot]bner basis of an ideal ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 " ",
 "in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "[", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], "]"}], TraditionalForm]], "InlineMath"],
 ", with respect to a monomial order ",
 Cell[BoxData[
  FormBox["\[PrecedesSlantEqual]", TraditionalForm]], "InlineMath"],
 ", is a finite set ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " of polynomials, such that for each",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "\[Element]", "I"}], TraditionalForm]], "InlineMath"],
 ",",
 " there exists ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "\[Element]", "G"}], TraditionalForm]], "InlineMath"],
 ",",
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", "g", ")"}], TraditionalForm]], "InlineMath"],
 " divides ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", "f", ")"}], TraditionalForm]], "InlineMath"],
 ".",
 " Every ideal ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 " has a Gr\[ODoubleDot]bner basis (see [",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"BW"],
 "] for a proof)."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->469904506],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "\[Element]", 
    RowBox[{
     RowBox[{"R", "[", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], "]"}], "\\", 
     RowBox[{"{", "0", "}"}]}]}], TraditionalForm]], "InlineMath"],
 ", and let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Element]", 
    RowBox[{"R", "[", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], "]"}]}], TraditionalForm]], "InlineMath"],
 " be a monomial. A term ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{"a", " ", "m"}]}], TraditionalForm]], "InlineMath"],
 " is reducible modulo ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ", if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LM",
     FontSlant->"Italic"], "(", "p", ")"}], TraditionalForm]], "InlineMath"],
 " divides ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[NotEqual]", 
    RowBox[{
     StyleBox["Rem",
      FontSlant->"Italic"], "(", 
     RowBox[{"a", ",", 
      RowBox[{
       StyleBox["LC",
        FontSlant->"Italic"], "(", "p", ")"}]}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " ",
 "is reducible modulo ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ", the reduction of ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " ",
 "modulo ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " is the polynomial"
}], "Text",
 CellTags->"b:0.1.0",
 CellID->359221891],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    StyleBox["Red",
     FontSlant->"Italic"], "(", 
    RowBox[{"t", ",", " ", "p"}], ")"}], " ", "=", " ", 
   RowBox[{"t", " ", "-", " ", 
    RowBox[{
     RowBox[{
      StyleBox["Quot",
       FontSlant->"Italic"], "(", 
      RowBox[{"a", ",", " ", 
       RowBox[{
        StyleBox["LC",
         FontSlant->"Italic"], "(", "p", ")"}]}], ")"}], " ", 
     FractionBox["m", 
      RowBox[{
       StyleBox["LM",
        FontSlant->"Italic"], "(", "p", ")"}]], 
     RowBox[{"p", "."}]}]}]}], TraditionalForm]], "DisplayMath",
 CellTags->"b:0.1.0",
 CellID->243375792],

Cell[TextData[{
 "Note that if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["Rem",
      FontSlant->"Italic"], "(", 
     RowBox[{"a", ",", 
      RowBox[{
       StyleBox["LC",
        FontSlant->"Italic"], "(", "p", ")"}]}], ")"}], "\[NotEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["LT",
      FontSlant->"Italic"], "(", 
     RowBox[{
      StyleBox["Red",
       FontSlant->"Italic"], "(", 
      RowBox[{"t", ",", "p"}], ")"}], ")"}], "=", 
    RowBox[{
     RowBox[{
      StyleBox["Rem",
       FontSlant->"Italic"], "(", 
      RowBox[{"a", ",", 
       RowBox[{
        StyleBox["LC",
         FontSlant->"Italic"], "(", "p", ")"}]}], ")"}], "m"}]}], 
   TraditionalForm]], "InlineMath"],
 ";",
 " otherwise, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["LM",
      FontSlant->"Italic"], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["Red",
        FontSlant->"Italic"], 
       RowBox[{"(", 
        RowBox[{"t", ",", "p"}], ")"}]}], ")"}]}], "\[PrecedesSlantEqual]", 
    "m"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->717872190],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "\[Element]", 
    RowBox[{"R", "[", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], "]"}]}], TraditionalForm]], "InlineMath"],
 ", and let ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 " be an ordered finite subset of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"R", "[", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], "]"}], "\\", 
    RowBox[{"{", "0", "}"}]}], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " is reducible modulo ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " contains a term reducible modulo an element of ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 ".",
 " The reduction ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Red", "(", 
    RowBox[{"f", ",", "P"}], ")"}], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " modulo ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 " is defined by the following procedure. While the set ",
 Cell[BoxData[
  FormBox[
   StyleBox["RT",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " of terms of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " reducible modulo an element of ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 " is not empty, take the term ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    StyleBox["RT",
     FontSlant->"Italic"]}], TraditionalForm]], "InlineMath"],
 " with the ",
 Cell[BoxData[
  FormBox["\[PrecedesSlantEqual]", TraditionalForm]], "InlineMath"],
 "-largest monomial, take the first ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "\[Element]", "P"}], TraditionalForm]], "InlineMath"],
 ", such that ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " is reducible modulo ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ", and replace the term ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["Red",
     FontSlant->"Italic"], "(", 
    RowBox[{"t", ",", "p"}], ")"}], TraditionalForm]], "InlineMath"],
 ". Note that the monomials of terms ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " chosen in subsequent steps of the procedure form a ",
 Cell[BoxData[
  FormBox["\[PrecedesSlantEqual]", TraditionalForm]], "InlineMath"],
 "-descending chain, and each monomial can appear at most ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " times, where ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " is the number of elements of ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 ",",
 " hence the procedure terminates."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->74043315],

Cell[TextData[{
 "A Gr\[ODoubleDot]bner basis ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " is semi-reduced if for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "\[Element]", "G"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " is not reducible modulo ",
 Cell[BoxData[
  FormBox[
   RowBox[{"G", "\\", 
    RowBox[{"{", "g", "}"}]}], TraditionalForm]], "InlineMath"],
 ", and if ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is the domain of integers, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["LC",
      FontSlant->"Italic"], "(", "g", ")"}], ">", "0"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->16067485],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " returns semi-reduced Gr\[ODoubleDot]bner bases. In the following \
discussion, all Gr\[ODoubleDot]bner bases are assumed to be semi-reduced. \
Note that this is not the same as reduced Gr\[ODoubleDot]bner bases defined \
in the literature, since here the basis polynomials are not required to be \
monic. For a fixed monomial order, every ideal has a unique reduced Gr\
\[ODoubleDot]bner basis. Semi-reduced Gr\[ODoubleDot]bner bases defined here \
are only unique up to multiplication by invertible elements of ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " ",
 "(see ",
 ButtonBox["Property 2",
  BaseStyle->"Hyperlink",
  ButtonData:>"GBProperty2"],
 "). "
}], "Text",
 CellTags->"b:0.1.0",
 CellID->40516630],

Cell[TextData[{
 StyleBox["Property 1",
  FontWeight->"Bold"],
 ": Let ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " be a Gr\[ODoubleDot]bner basis of an ideal ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 " ",
 "in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "[", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], "]"}], TraditionalForm]], "InlineMath"],
 ", and let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "\[Element]", 
    RowBox[{"R", "[", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], "]"}]}], TraditionalForm]], "InlineMath"],
 ". Then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "\[Element]", "I"}], TraditionalForm]], "InlineMath"],
 " iff ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["Red",
      FontSlant->"Italic"], "(", 
     RowBox[{"f", ",", "G"}], ")"}], "=", "0"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellTags->{"GBProperty1", "b:0.1.0"},
 CellID->101329384],

Cell["This is a simple consequence of the definitions.", "Text",
 CellTags->"b:0.1.0",
 CellID->76039018],

Cell[TextData[{
 StyleBox["Property 2",
  FontWeight->"Bold"],
 ": Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"G", "=", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["g", "1"], ",", 
      SubscriptBox["\[Ellipsis]g", "k"]}], "}"}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"H", "=", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["h", "1"], ",", 
      SubscriptBox["\[Ellipsis]h", "m"]}], "}"}]}], TraditionalForm]], 
  "InlineMath"],
 " be two Gr\[ODoubleDot]bner bases of an ideal ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 " with respect to the same monomial order ",
 Cell[BoxData[
  FormBox["\[PrecedesSlantEqual]", TraditionalForm]], "InlineMath"],
 ", and suppose that elements of ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 " are ordered by their leading monomials. Then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", "m"}], TraditionalForm]], "InlineMath"],
 ", and for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", "k"}], TraditionalForm]],
   "InlineMath"],
 ", if ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is the domain of integers, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "i"], "=", 
    SubscriptBox["h", "i"]}], TraditionalForm]], "InlineMath"],
 "; otherwise, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "i"], "=", 
    RowBox[{
     SubscriptBox["c", "i"], " ", 
     SubscriptBox["h", "i"]}]}], TraditionalForm]], "InlineMath"],
 " for some invertible element ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellTags->{"GBProperty2", "b:0.1.0"},
 CellID->251743588],

Cell[TextData[{
 StyleBox["Proof:",
  FontSlant->"Italic"],
 " If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["LM",
      FontSlant->"Italic"], "(", "f", ")"}], "=", 
    RowBox[{
     StyleBox["LM",
      FontSlant->"Italic"], "(", "g", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", "f", ")"}], TraditionalForm]], "InlineMath"],
 " is reducible modulo ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", "g", ")"}], TraditionalForm]], "InlineMath"],
 " is reducible modulo ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ". Hence the leading monomials of the elements of a Gr\[ODoubleDot]bner \
basis are all different. Without loss of generality, assume ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "\[LessEqual]", "m"}], TraditionalForm]], "InlineMath"],
 ". For induction, fix ",
 Cell[BoxData[
  FormBox[
   RowBox[{"j", "\[LessEqual]", "k"}], TraditionalForm]], "InlineMath"],
 " and suppose that for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "<", "j"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "i"], "=", 
    RowBox[{
     SubscriptBox["c", "i"], " ", 
     SubscriptBox["h", "i"]}]}], TraditionalForm]], "InlineMath"],
 " for some invertible element ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is the domain of integers, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "i"], "=", "1"}], TraditionalForm]], "InlineMath"],
 ". Without loss of generality, assume ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["LM",
      FontSlant->"Italic"], "(", 
     SubscriptBox["g", "j"], ")"}], "\[PrecedesSlantEqual]", 
    RowBox[{
     StyleBox["LM",
      FontSlant->"Italic"], "(", 
     SubscriptBox["h", "j"], ")"}]}], TraditionalForm]], "InlineMath"],
 ". Since ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "j"], TraditionalForm]], "InlineMath"],
 " belongs to ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ", there exists ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", 
    SubscriptBox["h", "i"], ")"}], TraditionalForm]], "InlineMath"],
 " divides ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", 
    SubscriptBox["g", "j"], ")"}], TraditionalForm]], "InlineMath"],
 ". Then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["LM",
      FontSlant->"Italic"], "(", 
     SubscriptBox["h", "i"], ")"}], "\[PrecedesSlantEqual]", 
    RowBox[{
     StyleBox["LM",
      FontSlant->"Italic"], "(", 
     SubscriptBox["g", "j"], ")"}]}], TraditionalForm]], "InlineMath"],
 ", and so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "\[LessEqual]", "j"}], TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "<", "j"}], TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "j"], TraditionalForm]], "InlineMath"],
 " would be reducible modulo ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "i"], TraditionalForm]], "InlineMath"],
 " and also modulo ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "i"], "=", 
    RowBox[{
     SubscriptBox["c", "i"], " ", 
     SubscriptBox["h", "i"]}]}], TraditionalForm]], "InlineMath"],
 ", which is impossible, since ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " is semi-reduced. Hence ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "=", "j"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["LM",
      FontSlant->"Italic"], "(", 
     SubscriptBox["g", "j"], ")"}], "=", 
    RowBox[{
     StyleBox["LM",
      FontSlant->"Italic"], "(", 
     SubscriptBox["h", "j"], ")"}]}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", 
    SubscriptBox["h", "j"], ")"}], TraditionalForm]], "InlineMath"],
 " divides ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", 
    SubscriptBox["g", "j"], ")"}], TraditionalForm]], "InlineMath"],
 ". Similarly, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", 
    SubscriptBox["g", "j"], ")"}], TraditionalForm]], "InlineMath"],
 " divides ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", 
    SubscriptBox["h", "j"], ")"}], TraditionalForm]], "InlineMath"],
 ". Therefore, there exists an invertible element ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "j"], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 ", such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["LT",
      FontSlant->"Italic"], "(", 
     SubscriptBox["g", "j"], ")"}], "=", 
    RowBox[{
     SubscriptBox["c", "j"], 
     RowBox[{
      StyleBox["LT",
       FontSlant->"Italic"], "(", 
      SubscriptBox["h", "j"], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is the domain of integers, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LC",
     FontSlant->"Italic"], "(", 
    SubscriptBox["g", "j"], ")"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LC",
     FontSlant->"Italic"], "(", 
    SubscriptBox["h", "j"], ")"}], TraditionalForm]], "InlineMath"],
 " are positive, and so ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "j"], "=", "1"}], TraditionalForm]], "InlineMath"],
 ". Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["c", "j"], 
      SubscriptBox["h", "j"]}], "-", 
     SubscriptBox["g", "j"]}]}], TraditionalForm]], "InlineMath"],
 ". Suppose ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "\[NotEqual]", "0"}], TraditionalForm]], "InlineMath"],
 ". Since ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " belongs to ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"LT", 
    RowBox[{"(", "r", ")"}]}], TraditionalForm]], "InlineMath"],
 " ",
 "must be divisible by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", 
    SubscriptBox["g", "i"], ")"}], TraditionalForm]], "InlineMath"],
 ", for some ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "<", "j"}], TraditionalForm]], "InlineMath"],
 ". Let ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineMath"],
 " be the coefficients at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LM",
     FontSlant->"Italic"], "(", "r", ")"}], TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "j"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "j"], TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is a field, the term ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", " ", 
    RowBox[{
     StyleBox["LM",
      FontSlant->"Italic"], "(", "r", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "j"], TraditionalForm]], "InlineMath"],
 " is reducible modulo ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 ", which contradicts the assumption that ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " is semi-reduced. If ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is the domain of univariate polynomials over a field,"
}], "Text",
 CellTags->"b:0.1.0",
 CellID->7064830],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    StyleBox["deg",
     FontSlant->"Italic"], "(", 
    RowBox[{
     StyleBox["LC",
      FontSlant->"Italic"], "(", 
     SubscriptBox["g", "i"], ")"}], ")"}], "\[LessEqual]", 
   RowBox[{
    StyleBox["deg",
     FontSlant->"Italic"], "(", 
    RowBox[{
     StyleBox["LC",
      FontSlant->"Italic"], "(", "r", ")"}], ")"}], "\[LessEqual]", 
   RowBox[{
    StyleBox["max",
     FontSlant->"Italic"], "(", 
    RowBox[{
     RowBox[{
      StyleBox["deg",
       FontSlant->"Italic"], "(", "\[Alpha]", ")"}], ",", 
     RowBox[{
      StyleBox["deg",
       FontSlant->"Italic"], "(", "\[Beta]", ")"}]}], ")"}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.1.0",
 CellID->43249874],

Cell[TextData[{
 "and so either ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "j"], TraditionalForm]], "InlineMath"],
 " is reducible modulo ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 ", or ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "j"], TraditionalForm]], "InlineMath"],
 " is reducible modulo ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["h", "i"], "=", 
    RowBox[{
     SubscriptBox["c", "i"], 
     SubscriptBox["g", "i"]}]}], TraditionalForm]], "InlineMath"],
 ", which contradicts the assumption that ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 " are semi-reduced. Finally, let ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " be the domain of integers. Since neither ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "j"], TraditionalForm]], "InlineMath"],
 " is reducible modulo ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 " nor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "j"], TraditionalForm]], "InlineMath"],
 " is reducible modulo ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["h", "i"], "=", 
    SubscriptBox["g", "i"]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       StyleBox["LC",
        FontSlant->"Italic"], "(", 
       SubscriptBox["g", "i"], ")"}]}], "/", "2"}], "<", "\[Alpha]", 
    "\[LessEqual]", 
    RowBox[{
     RowBox[{
      StyleBox["LC",
       FontSlant->"Italic"], "(", 
      SubscriptBox["g", "i"], ")"}], "/", "2"}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       StyleBox["LC",
        FontSlant->"Italic"], "(", 
       SubscriptBox["g", "i"], ")"}]}], "/", "2"}], "<", " ", "\[Beta]", 
    "\[LessEqual]", 
    RowBox[{
     RowBox[{
      StyleBox["LC",
       FontSlant->"Italic"], "(", 
      SubscriptBox["g", "i"], ")"}], "/", "2"}]}], TraditionalForm]], 
  "InlineMath"],
 ". Hence ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       StyleBox["LC",
        FontSlant->"Italic"], "(", 
       SubscriptBox["g", "i"], ")"}]}], "<", 
     RowBox[{
      StyleBox["LC",
       FontSlant->"Italic"], "(", "r", ")"}]}], "=", 
    RowBox[{
     RowBox[{"\[Beta]", "-", "\[Alpha]"}], "<", 
     RowBox[{
      StyleBox["LC",
       FontSlant->"Italic"], "(", 
      SubscriptBox["g", "i"], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", which is impossible, since ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", "r", ")"}], TraditionalForm]], "InlineMath"],
 " ",
 "is divisible by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["LT",
     FontSlant->"Italic"], "(", 
    SubscriptBox["g", "i"], ")"}], TraditionalForm]], "InlineMath"],
 ". Therefore ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", and so ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "j"], "=", 
    RowBox[{
     SubscriptBox["c", "j"], " ", 
     SubscriptBox["h", "j"]}]}], TraditionalForm]], "InlineMath"],
 ". By induction on ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ", for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"j", "\[LessEqual]", "k"}], TraditionalForm]], "InlineMath"],
 ",",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "j"], "=", 
    RowBox[{
     SubscriptBox["c", "j"], " ", 
     SubscriptBox["h", "j"]}]}], TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "<", "m"}], TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", 
    RowBox[{"k", "+", "1"}]], TraditionalForm]], "InlineMath"],
 " would be reducible modulo some ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "j"], TraditionalForm]], "InlineMath"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"j", "\[LessEqual]", "k"}], TraditionalForm]], "InlineMath"],
 ",",
 " and hence ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", 
    RowBox[{"k", "+", "1"}]], TraditionalForm]], "InlineMath"],
 " would be reducible modulo ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["h", "j"], "=", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["c", "j"], 
      RowBox[{"-", "1"}]], 
     SubscriptBox["g", "j"]}]}], TraditionalForm]], "InlineMath"],
 ". Therefore ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", "m"}], TraditionalForm]], "InlineMath"],
 ", which completes the proof of ",
 ButtonBox["Property 2.",
  BaseStyle->"Hyperlink",
  ButtonData:>"GBProperty2"]
}], "Text",
 CellTags->"b:0.1.0",
 CellID->267330306],

Cell[TextData[{
 StyleBox["Property 3",
  FontWeight->"Bold"],
 ": Let ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 " be an ideal in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "[", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], "]"}], TraditionalForm]], "InlineMath"],
 ", let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "\[Element]", 
    RowBox[{"R", "[", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], "]"}]}], TraditionalForm]], "InlineMath"],
 ", and let ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " be a Gr\[ODoubleDot]bner basis of the ideal ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"<", "I"}], ",", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"y", " ", "f"}]}], ">"}]}], TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "[", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"], ",", "y"}], "]"}], TraditionalForm]], 
  "InlineMath"],
 ". Then ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "belongs to the radical of ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 " iff ",
 Cell[BoxData[
  FormBox[
   RowBox[{"G", "=", 
    RowBox[{"{", "c", "}"}]}], TraditionalForm]], "InlineMath"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "for an invertible element ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->{"GBProperty3", "b:0.1.0"},
 CellID->116059195],

Cell[TextData[{
 "If an ideal contains invertible elements of ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 ",",
 " ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " always returns ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", "1", "}"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->81054669],

Cell[TextData[{
 StyleBox["Proof:",
  FontSlant->"Italic"],
 " ",
 "Note first that"
}], "Text",
 CellTags->"b:0.1.0",
 CellID->372338942],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     SuperscriptBox["y", 
      SuperscriptBox["2", "k"]], 
     SuperscriptBox["f", 
      SuperscriptBox["2", "k"]]}]}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"y", " ", "f"}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"y", " ", "f"}]}], ")"}], 
    RowBox[{"\[Ellipsis]", "(", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["y", 
        SuperscriptBox["2", 
         RowBox[{"k", "-", "1"}]]], 
       SuperscriptBox["f", 
        SuperscriptBox["2", 
         RowBox[{"k", "-", "1"}]]]}]}], ")"}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.1.0",
 CellID->64785049],

Cell[TextData[{
 "belongs to the ideal ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"J", "=", 
     RowBox[{"<", "I"}]}], ",", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"y", " ", "f"}]}], ">"}]}], TraditionalForm]], "InlineMath"],
 " for any non\[Hyphen]negative integer ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 ". Hence, if ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " belongs to the radical of ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ", then 1 belongs to ",
 Cell[BoxData[
  FormBox["J", TraditionalForm]], "InlineMath"],
 ". Since ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " is a Gr\[ODoubleDot]bner basis of ",
 Cell[BoxData[
  FormBox["J", TraditionalForm]], "InlineMath"],
 ", it must contain an element ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " whose leading coefficient divides 1. Hence ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " is an invertible element of ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 ". Since ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " is semi-reduced and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " divides any term, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"G", "=", 
    RowBox[{"{", "c", "}"}]}], TraditionalForm]], "InlineMath"],
 ". Now suppose that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"G", "=", 
    RowBox[{"{", "c", "}"}]}], TraditionalForm]], "InlineMath"],
 " ",
 "for an invertible element ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 ". Then 1 belongs to ",
 Cell[BoxData[
  FormBox["J", TraditionalForm]], "InlineMath"],
 ", and so "
}], "Text",
 CellTags->"b:0.1.0",
 CellID->188019864],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"1", "=", 
    RowBox[{
     SubscriptBox["a", "0"], "+", 
     RowBox[{
      SubscriptBox["a", "1"], "y"}], "+", "\[Ellipsis]", "+", 
     RowBox[{
      SubscriptBox["a", "m"], 
      SuperscriptBox["y", "m"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"y", " ", "f"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["b", "0"], "+", 
        RowBox[{
         SubscriptBox["b", "1"], "y"}], "+", "\[Ellipsis]", "+", 
        RowBox[{
         SubscriptBox["b", 
          RowBox[{"m", "-", "1"}]], 
         SuperscriptBox["y", 
          RowBox[{"m", "-", "1"}]]}]}], ")"}]}]}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.1.0",
 CellID->306918598],

Cell[TextData[{
 "where each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "i"], TraditionalForm]], "InlineMath"],
 " belongs to ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ", and each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "i"], TraditionalForm]], "InlineMath"],
 " belongs to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "[", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], "]"}], TraditionalForm]], "InlineMath"],
 ". Hence comparing coefficients at powers of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " leads to the following equations modulo ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ": ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "0"], "\[Congruent]", "1"}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "i"], "\[Congruent]", 
    RowBox[{
     SubscriptBox["b", 
      RowBox[{"i", "-", "1"}]], "f"}]}], TraditionalForm]], "InlineMath"],
 ", for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", 
    RowBox[{"m", "-", "1"}]}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["b", 
      RowBox[{"m", "-", "1"}]], "f"}], "\[Congruent]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". Then, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "i"], "\[Congruent]", 
    SuperscriptBox["f", "i"]}], TraditionalForm]], "InlineMath"],
 ", for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "i", "\[LessEqual]", 
    RowBox[{"m", "-", "1"}]}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["f", "m"], "\[Congruent]", "0"}], TraditionalForm]], 
  "InlineMath"],
 " modulo ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ". Therefore, ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " belongs to the radical of ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ", which completes the proof of ",
 ButtonBox["Property 3",
  BaseStyle->"Hyperlink",
  ButtonData:>"GBProperty3"],
 "."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->133913109],

Cell["\<\
The following more technical property is important for solving complex \
polynomial systems.\
\>", "Text",
 CellTags->"b:0.1.0",
 CellID->625037811],

Cell[TextData[{
 StyleBox["Property 4",
  FontWeight->"Bold"],
 ": Let ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " be a Gr\[ODoubleDot]bner basis of an ideal ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalC]", "[", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"], ",", "y"}], "]"}], TraditionalForm]], 
  "InlineMath"],
 " with a monomial order that makes monomials containing ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " greater than monomials not containing ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", let ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " be the element of ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " with the lowest positive degree ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["c",
     FontSlant->"Italic"], "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " be the leading coefficient of ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", and let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["h", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["h", "s"]}], "}"}], TraditionalForm]], "InlineMath"],
 " be all elements of ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " that do not depend on ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". Then for any polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "\[Element]", "I"}], TraditionalForm]], "InlineMath"],
 " and any point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", " ", 
     RowBox[{
      SubscriptBox["a", 
       RowBox[{"n", ","}]], "b"}]}], ")"}], TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["c",
      FontSlant->"Italic"], "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[NotEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["h", "i"], "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "=", "0"}], TraditionalForm]], 
  "InlineMath"],
 ", for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", "s"}], TraditionalForm]],
   "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"h", "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"], ",", "b"}], ")"}], "=", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"p", "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"], ",", "b"}], ")"}], "=", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->{"GBProperty4", "b:0.1.0"},
 CellID->63440976],

Cell[TextData[{
 StyleBox["Proof:",
  FontSlant->"Italic"],
 " Consider the pseudoremainder ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " of the division of ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " as polynomials in ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellTags->"b:0.1.0",
 CellID->63896074],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"c", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], "e"], 
    RowBox[{"p", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", "y"}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"q", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"], ",", "y"}], ")"}], " ", 
     RowBox[{"h", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"], ",", "y"}], ")"}]}], "+", 
    RowBox[{"r", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", "y"}], ")"}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(1)"}]]}, {None, None}},
 CellTags->{"ComplQuantElim5", "b:0.1.0"},
 CellID->49796222],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " belong to ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ", so does ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 ". By ",
 ButtonBox["Property 1, ",
  BaseStyle->"Hyperlink",
  ButtonData:>"GBProperty1"],
 "reduction of ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " must yield zero. Since the degree of ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " is less than ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " cannot be reduced by any of the elements of ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " that depend on ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". Hence"
}], "Text",
 CellTags->"b:0.1.0",
 CellID->221361483],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"r", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"], ",", "y"}], ")"}], "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["p", "1"], "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"], ",", "y"}], ")"}], 
     RowBox[{
      SubscriptBox["h", "1"], "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], "+", "\[Ellipsis]", "+", 
    RowBox[{
     RowBox[{
      SubscriptBox["p", "s"], "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"], ",", "y"}], ")"}], 
     RowBox[{
      SubscriptBox["h", "s"], "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}]}]}], TraditionalForm]], "DisplayMath",\

 CellTags->"b:0.1.0",
 CellID->252555401],

Cell[TextData[{
 "and so ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"r", "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"], ",", "b"}], ")"}], "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["c",
      FontSlant->"Italic"], "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[NotEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim5"],
 ") implies that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"p", "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"], ",", "b"}], ")"}], "=", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", which completes the proof of ",
 ButtonBox["Property 4",
  BaseStyle->"Hyperlink",
  ButtonData:>"GBProperty4"],
 "."
}], "Text",
 CellTags->"b:0.1.0",
 CellID->556834848]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function GroebnerBasis"
}], "Subsection",
 CellTags->"b:0.1.1",
 CellID->358199088],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " finds semi-reduced Gr\[ODoubleDot]bner bases. This section describes ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " options used in the solving of complex polynomial systems."
}], "Text",
 CellTags->"b:0.1.1",
 CellID->38773286],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"CoefficientDomain", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the type of objects assumed to be coefficients", "TableText"]},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method used to compute the basis", "TableText"]},
   {"MonomialOrder", "Lexicographic", Cell[
    "the criterion used for ordering monomials", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.1.1",
 CellID->219123469],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " options used in the solving of complex polynomial systems. "
}], "Caption",
 CellTags->"b:0.1.1",
 CellID->25528258],

Cell[CellGroupData[{

Cell["CoefficientDomain", "Subsubsection",
 CellTags->"b:0.1.1",
 CellID->207435377],

Cell[TextData[{
 "This option specifies the domain ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " of coefficients",
 ".",
 " With the default ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " setting, the coefficient domain is the field generated by numeric \
coefficients present in the input. "
}], "Text",
 CellTags->"b:0.1.1",
 CellID->12500363],

Cell[BoxData[GridBox[{
   {
    StyleBox[
     ButtonBox["Integers",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integers"], "MR"], Cell[
    "the domain of integers", "TableText"]},
   {
    RowBox[{
     StyleBox["InexactNumbers", "MR"], 
     StyleBox["[", "MR"], 
     StyleBox["prec", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "inexact numbers with precision ",
     Cell[BoxData[
      StyleBox["prec", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Polynomials", "MR"], 
     StyleBox["[", "MR"], 
     StyleBox["x", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "the domain of polynomials in ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    StyleBox["RationalFunctions", "MR"], Cell[TextData[{
     "the field of rational functions in variables not on the variable list \
given to ",
     Cell[BoxData[
      ButtonBox["GroebnerBasis",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"]
    }], "TableText"]},
   {
    StyleBox[
     ButtonBox["Rationals",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rationals"], "MR"], Cell[
    "the field of rational numbers", "TableText"]}
  }]], "DefinitionBox",
 CellID->48038517],

Cell[TextData[{
 "Available settings for ",
 Cell[BoxData["CoefficientDomain"], "InlineFormula"],
 "."
}], "Caption",
 CellID->545849752],

Cell[TextData[{
 "Note that the coefficient domain ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " also depends on the setting of the ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 ". With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Modulus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Modulus"], "->", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 ", for a prime number ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ", the coefficient domain is the field ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[DoubleStruckCapitalZ]", "p"], TraditionalForm]], 
  "InlineMath"],
 ", or the field of rational functions over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[DoubleStruckCapitalZ]", "p"], TraditionalForm]], 
  "InlineMath"],
 " if ",
 Cell[BoxData[
  RowBox[{"CoefficientDomain", "->", "RationalFunctions"}]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1.1",
 CellID->137749525]
}, Open  ]],

Cell[CellGroupData[{

Cell["Method", "Subsubsection",
 CellTags->"b:0.1.1",
 CellID->249536440],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " normally uses a variant of the Buchberger algorithm. Another algorithm \
available is the Gr\[ODoubleDot]bner walk, which computes a \
Gr\[ODoubleDot]bner basis in an easier monomial order and then transforms it \
to the required harder monomial order. This is often faster than directly \
computing a Gr\[ODoubleDot]bner basis in the required order, especially if \
the input polynomials are known to be a Gr\[ODoubleDot]bner basis for the \
easier order. With the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " setting, ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " uses the Gr\[ODoubleDot]bner walk for the default ",
 Cell[BoxData[
  RowBox[{"CoefficientDomain", "->", 
   ButtonBox["Rationals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationals"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"MonomialOrder", "->", "Lexicographic"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1.1",
 CellID->777232220],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GroebnerBasis",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GroebnerBasis"], "[", 
     RowBox[{
      StyleBox["polys", "TI"], ",", 
      StyleBox["vars", "TI"], ",", 
      RowBox[{
       ButtonBox["Method",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Method"], "->", 
       RowBox[{"{", 
        RowBox[{"\"\<GroebnerWalk\>\"", ",", 
         RowBox[{"\"\<InitialMonomialOrder\>\"", "->", 
          SubscriptBox[
           StyleBox["order", "TI"], 
           StyleBox["1", "TR"]]}]}], "}"}]}], ",", 
      RowBox[{"MonomialOrder", "->", 
       SubscriptBox[
        StyleBox["order", "TI"], 
        StyleBox["2", "TR"]]}]}], "]"}], Cell[TextData[{
     "find a Gr\[ODoubleDot]bner basis in ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["order", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and use the Gr\[ODoubleDot]bner walk algorithm to transform it to a Gr\
\[ODoubleDot]bner basis in ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["order", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.68], {
      Scaled[0.32]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->"GBWalk",
 CellID->64503502],

Cell["\<\
Transforming Gr\[ODoubleDot]bner bases using the Gr\[ODoubleDot]bner walk \
algorithm.\
\>", "Caption",
 CellID->520967710]
}, Open  ]],

Cell[CellGroupData[{

Cell["MonomialOrder", "Subsubsection",
 CellTags->"b:0.1.1",
 CellID->337648130],

Cell[TextData[{
 "This option specifies the monomial order. The value can be either one of \
the named monomial orders or a weight matrix. The following table gives \
conditions for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     SubscriptBox["x", "1"], 
     SubscriptBox["d", "1"]], 
    SuperscriptBox[
     SubscriptBox["\[Ellipsis]x", "n"], 
     SubscriptBox["d", "n"]]}], TraditionalForm]], "InlineMath"],
 "\[PrecedesSlantEqual]",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "1"], 
      SubscriptBox["e", "1"]], 
     SuperscriptBox[
      SubscriptBox["\[Ellipsis]x", "n"], 
      SubscriptBox["e", "n"]]}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.1.1",
 CellID->426805126],

Cell[BoxData[GridBox[{
   {"Lexicographic", Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubscriptBox["d", "1"], "\[Equal]", 
        SubscriptBox["e", "1"]}], "\[And]", "\[Ellipsis]", "\[And]", 
       RowBox[{
        SubscriptBox["d", 
         RowBox[{"i", "-", "1"}]], "\[Equal]", 
        SubscriptBox["e", 
         RowBox[{"i", "-", "1"}]]}]}], TraditionalForm]], "InlineMath"]], 
     "TableText"]},
   {"DegreeLexicographic", Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["d", "1"], "+", "\[Ellipsis]", "+", 
         SubscriptBox["d", "n"]}], "<", 
        RowBox[{
         SubscriptBox["e", "1"], "+", "\[Ellipsis]", "+", 
         SubscriptBox["e", "n"]}]}], "\[Or]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["d", "1"], "+", "\[Ellipsis]", "+", 
           SubscriptBox["d", "n"]}], "\[Equal]", 
          RowBox[{
           SubscriptBox["e", "1"], "+", "\[Ellipsis]", "+", 
           SubscriptBox["e", "n"]}]}], "\[And]", 
         RowBox[{
          SubscriptBox["d", "1"], "\[Equal]", 
          SubscriptBox["e", "1"]}], "\[And]", "\[Ellipsis]", "\[And]", 
         RowBox[{
          SubscriptBox["d", 
           RowBox[{"i", "-", "1"}]], "\[Equal]", 
          SubscriptBox["e", 
           RowBox[{"i", "-", "1"}]]}], "\[And]", 
         RowBox[{
          SubscriptBox["d", "i"], "<", 
          SubscriptBox["e", "i"]}]}], ")"}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"]},
   {"DegreeReverseLexicographic", Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["d", "1"], "+", "\[Ellipsis]", "+", 
         SubscriptBox["d", "n"]}], "<", 
        RowBox[{
         SubscriptBox["e", "1"], "+", "\[Ellipsis]", "+", 
         SubscriptBox["e", "n"]}]}], "\[Or]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["d", "1"], "+", "\[Ellipsis]", "+", 
           SubscriptBox["d", "n"]}], "\[Equal]", 
          RowBox[{
           SubscriptBox["e", "1"], "+", "\[Ellipsis]", "+", 
           SubscriptBox["e", "n"]}]}], "\[And]", 
         RowBox[{
          SubscriptBox["d", "n"], "\[Equal]", 
          SubscriptBox["e", "n"]}], "\[And]", "\[Ellipsis]", "\[And]", 
         RowBox[{
          SubscriptBox["d", 
           RowBox[{"i", "+", "1"}]], "\[Equal]", 
          SubscriptBox["e", 
           RowBox[{"i", "+", "1"}]]}], "\[And]", 
         RowBox[{
          SubscriptBox["d", "i"], "<", 
          SubscriptBox["e", "i"]}]}], ")"}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.1.1",
 CellID->249023081],

Cell["Monomial orders. ", "Caption",
 CellTags->"b:0.1.1",
 CellID->477494064],

Cell[TextData[{
 "Quantifier elimination needs an order in which monomials containing \
quantifier variables are greater than monomials not containing quantifier \
variables. The ",
 Cell[BoxData["Lexicographic"], "InlineFormula"],
 " order satisfies this condition, but the following ",
 Cell[BoxData["EliminationOrder"], "InlineFormula"],
 " usually leads to faster computations."
}], "Text",
 CellTags->"b:0.1.1",
 CellID->9441429],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FormBox[
     RowBox[{
      RowBox[{
       SubscriptBox["m", "1"], "(", "X", ")"}], 
      RowBox[{
       SubscriptBox["n", "1"], "(", "Y", ")"}]}],
     TraditionalForm], "\[PrecedesSlantEqual]", 
    RowBox[{
     RowBox[{
      SubscriptBox["m", "2"], "(", "X", ")"}], 
     RowBox[{
      RowBox[{
       SubscriptBox["n", "2"], "(", "Y", ")"}], "\[DoubleLongLeftRightArrow]",
       " ", 
      RowBox[{"d", "(", 
       RowBox[{
        SubscriptBox["n", "1"], "(", "Y", ")"}], ")"}]}]}], "<", 
    RowBox[{"d", "(", 
     RowBox[{
      SubscriptBox["n", "2"], "(", "Y", ")"}], ")"}]}], "\[Or]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"d", "(", 
        RowBox[{
         SubscriptBox["n", "1"], "(", "Y", ")"}], ")"}], "\[Equal]", 
       RowBox[{"d", "(", 
        RowBox[{
         SubscriptBox["n", "2"], "(", "Y", ")"}], ")"}]}], "\[And]", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["m", "1"], "(", "X", ")"}], 
        RowBox[{
         SubscriptBox["n", "1"], "(", "Y", ")"}]}], 
       SubscriptBox["\[PrecedesSlantEqual]", "DRL"], 
       RowBox[{
        RowBox[{
         SubscriptBox["m", "2"], "(", "X", ")"}], 
        RowBox[{
         SubscriptBox["n", "2"], "(", "Y", ")"}]}]}]}], ","}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.1.1",
 CellID->2799146],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " denotes total degree, ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "InlineMath"],
 " denotes free variables, ",
 Cell[BoxData[
  FormBox["Y", TraditionalForm]], "InlineMath"],
 " denotes quantifier variables, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["m", "i"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 " are monomials, and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[PrecedesSlantEqual]", "DRL"], TraditionalForm]], 
  "InlineMath"],
 " denotes the ",
 Cell[BoxData["DegreeReverseLexicographic"], "InlineFormula"],
 " order."
}], "Text",
 CellTags->"b:0.1.1",
 CellID->203628926],

Cell[TextData[{
 "Using ",
 Cell[BoxData["EliminationOrder"], "InlineFormula"],
 " requires the ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " syntax with elimination variables specified."
}], "Text",
 CellTags->"b:0.1.1",
 CellID->407136694],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["GroebnerBasis", "MR"], 
      StyleBox["[", "MR"], 
      RowBox[{
       StyleBox["polys", "TI"], 
       StyleBox[",", "TI"], 
       StyleBox[" ", "TI"], 
       StyleBox["xvars", "TI"], 
       StyleBox[",", "TI"], 
       StyleBox[" ", "TI"], 
       StyleBox["yvars", "TI"], ",", " ", 
       StyleBox[
        RowBox[{"MonomialOrder", "->", "EliminationOrder"}], "MR"]}], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      "find a Gr\[ODoubleDot]bner basis in ",
      Cell[BoxData["EliminationOrder"], "InlineFormula"],
      " "
     }], "TableText"]}
   }], TextForm]], "DefinitionBox",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {{
      Scaled[0.5]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"ElimOrder", "b:0.1.1"},
 CellID->29856636],

Cell["\<\
Gr\[ODoubleDot]bner basis in elimination order.\
\>", "Caption",
 CellTags->"b:0.1.1",
 CellID->669910966],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  RowBox[{"MonomialOrder", "->", "EliminationOrder"}]], "InlineFormula"],
 " drops the polynomials that contain ",
 Cell[BoxData[
  FormBox[
   StyleBox["yvars",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " from the result, returning only basis polynomials in ",
 Cell[BoxData[
  FormBox[
   StyleBox["xvars",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 ". To get all basis polynomials, the value of the system option ",
 Cell[BoxData["EliminateFromGroebnerBasis"], "InlineFormula"],
 " from the ",
 Cell[BoxData["GroebnerBasisOptions"], "InlineFormula"],
 " group must be changed. (",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " changes the option locally in the quantifier elimination algorithm.) The \
option value can be changed with"
}], "Text",
 CellTags->{"b:0.1.1", "GBElim"},
 CellID->664865967],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetSystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetSystemOptions"], "[", 
   RowBox[{"\"\<GroebnerBasisOptions\>\"", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<EliminateFromGroebnerBasis\>\"", "->", 
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Program",
 CellTags->"b:0.1.1",
 CellID->16612748],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<EliminateFromGroebnerBasis\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether ",
     Cell[BoxData[
      ButtonBox["GroebnerBasis",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      RowBox[{"MonomialOrder", "->", "EliminationOrder"}]], "InlineFormula"],
     " should remove polynomials containing elimination variables"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.1.1",
 CellID->81337346],

Cell[TextData[{
 "System option ",
 Cell[BoxData["EliminateFromGroebnerBasis"], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:0.1.1",
 CellID->17926163],

Cell[TextData[{
 "This eliminates ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Exists]", "y"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubsuperscriptBox["x", "1", "2"], "+", 
        SubsuperscriptBox["x", "2", "2"], "-", 
        RowBox[{
         SubscriptBox["x", "1"], 
         SubscriptBox["x", "2"], "y"}]}], "\[Equal]", "1"}], "\[And]", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["x", "1", "2"], "+", 
        SubsuperscriptBox["x", "2", "2"], "+", 
        RowBox[{
         SubscriptBox["x", "1"], 
         SubscriptBox["x", "2"], "y"}], "+", "1"}], "\[Equal]", "0"}]}], 
     ")"}]}], TraditionalForm]], "InlineMath"],
 ". The answer is a polynomial whose zeros are the Zariski closure of the \
projection of the solution set of the two original equations on the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"]}], ")"}], TraditionalForm]], "InlineMath"],
 " plane."
}], "MathCaption",
 CellTags->"b:0.1.1",
 CellID->17431108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["x", "1", "2"], "+", 
      SubsuperscriptBox["x", "2", "2"], "-", 
      RowBox[{
       SubscriptBox["x", "1"], 
       SubscriptBox["x", "2"], "y"}], "-", "1"}], ",", 
     RowBox[{
      SubsuperscriptBox["x", "1", "2"], "+", 
      SubsuperscriptBox["x", "2", "2"], "+", 
      RowBox[{
       SubscriptBox["x", "1"], 
       SubscriptBox["x", "2"], "y"}], "+", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"]}], "}"}], ",", 
   RowBox[{"{", "y", "}"}], ",", 
   RowBox[{"MonomialOrder", "\[Rule]", "EliminationOrder"}]}], "]"}]], "Input",\

 CellTags->"b:0.1.1",
 CellLabel->"In[4]:=",
 CellID->369080181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubsuperscriptBox["x", "1", "2"], "+", 
   SubsuperscriptBox["x", "2", "2"]}], "}"}]], "Output",
 ImageSize->{56, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1.1",
 CellLabel->"Out[4]=",
 CellID->126593186]
}, Open  ]],

Cell[TextData[{
 "The exact description of the projection of the solution set on the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"]}], ")"}], TraditionalForm]], "InlineMath"],
 " plane depends on all basis polynomials. Note that the second basis \
polynomial cannot be zero if ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "1"], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 " are zero."
}], "MathCaption",
 CellTags->"b:0.1.1",
 CellID->328968578],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<GroebnerBasisOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<EliminateFromGroebnerBasis\>\"", "\[Rule]", "False"}], 
     "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["x", "1", "2"], "+", 
      SubsuperscriptBox["x", "2", "2"], "-", 
      RowBox[{
       SubscriptBox["x", "1"], 
       SubscriptBox["x", "2"], "y"}], "-", "1"}], ",", 
     RowBox[{
      SubsuperscriptBox["x", "1", "2"], "+", 
      SubsuperscriptBox["x", "2", "2"], "+", 
      RowBox[{
       SubscriptBox["x", "1"], 
       SubscriptBox["x", "2"], "y"}], "+", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"]}], "}"}], ",", 
   RowBox[{"{", "y", "}"}], ",", 
   RowBox[{"MonomialOrder", "\[Rule]", "EliminationOrder"}]}], 
  "]"}]}], "Input",
 CellTags->"b:0.1.1",
 CellLabel->"In[5]:=",
 CellID->245813959],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["x", "1", "2"], "+", 
    SubsuperscriptBox["x", "2", "2"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"y", " ", 
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "2"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["x", "1"]}], "+", 
    RowBox[{"y", " ", 
     SubsuperscriptBox["x", "2", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{191, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1.1",
 CellLabel->"Out[6]=",
 CellID->187452025]
}, Open  ]],

Cell["This resets the system option to its default value.", "MathCaption",
 CellTags->"b:0.1.1",
 CellID->577953394],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<GroebnerBasisOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<EliminateFromGroebnerBasis\>\"", "\[Rule]", "True"}], 
     "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:0.1.1",
 CellLabel->"In[7]:=",
 CellID->174463567],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " gives the exact description of the projection of the solution set on the \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"]}], ")"}], TraditionalForm]], "InlineMath"],
 " plane."
}], "MathCaption",
 CellTags->"b:0.1.1",
 CellID->355570436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   SubscriptBox["\[Exists]", "y"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubsuperscriptBox["x", "1", "2"], "+", 
       SubsuperscriptBox["x", "2", "2"], "-", 
       RowBox[{
        SubscriptBox["x", "1"], 
        SubscriptBox["x", "2"], "y"}]}], "\[Equal]", "1"}], "\[And]", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["x", "1", "2"], "+", 
       SubsuperscriptBox["x", "2", "2"], "+", 
       RowBox[{
        SubscriptBox["x", "1"], 
        SubscriptBox["x", "2"], "y"}], "+", "1"}], "\[Equal]", "0"}]}], 
    ")"}]}], "]"}]], "Input",
 CellTags->"b:0.1.1",
 CellLabel->"In[8]:=",
 CellID->507576972],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubsuperscriptBox["x", "1", "2"], "+", 
    SubsuperscriptBox["x", "2", "2"]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   SubscriptBox["x", "2"], "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1.1",
 CellLabel->"Out[8]=",
 CellID->201531761]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Decision Problems", "Section",
 CellTags->"b:0.2",
 CellID->47132662],

Cell["\<\
A decision problem is a system with all variables existentially quantified, \
that is, a system of the form\
\>", "Text",
 CellTags->"b:0.2",
 CellID->108914437],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Exists]", 
     SubscriptBox["x", "1"]], 
    RowBox[{
     SubscriptBox["\[Exists]", 
      SubscriptBox["x", "2"]], 
     RowBox[{"\[Ellipsis]", 
      RowBox[{
       SubscriptBox["\[Exists]", 
        SubscriptBox["x", "n"]], 
       RowBox[{"\[CapitalPhi]", "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["x", "n"]}], ")"}]}]}]}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.2",
 CellID->69115330],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " are all variables in ",
 Cell[BoxData[
  FormBox["\[CapitalPhi]", TraditionalForm]], "InlineMath"],
 ". Solving a decision problem means deciding whether it is equivalent to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", that is, deciding whether the quantifier-free system of polynomial \
equations and inequations ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " has solutions."
}], "Text",
 CellTags->"b:0.2",
 CellID->342414202],

Cell["\<\
Solving this decision problem proves that a quadratic equation with a zero \
determinant cannot have two different roots.\
\>", "MathCaption",
 CellTags->"b:0.2",
 CellID->240968237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   SubscriptBox["\[Exists]", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "x", ",", "y"}], "}"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        SuperscriptBox["y", "2"]}], "+", 
       RowBox[{"b", " ", "y"}], "+", "c"}], "\[Equal]", "0"}], "&&", 
     RowBox[{"x", "\[NotEqual]", "y"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}], "\[Equal]", "0"}], "&&", 
     RowBox[{"a", "\[NotEqual]", "0"}]}], ")"}]}], "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[9]:=",
 CellID->169223809],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[9]=",
 CellID->43644218]
}, Open  ]],

Cell["Given the identities", "Text",
 CellTags->"b:0.2",
 CellID->14091805],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Exists]", "x"], 
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{
       SubscriptBox["\[CapitalPhi]", "1"], "\[Or]", "\[Ellipsis]", "\[Or]", 
       " ", 
       SubscriptBox["\[CapitalPhi]", 
        RowBox[{"n", " "}]]}], ")"}], " ", "\[DoubleLongLeftRightArrow]", " ",
      
     RowBox[{
      SubscriptBox["\[Exists]", "x"], 
      SubscriptBox["\[CapitalPhi]", "1"]}]}]}], "\[Or]", "\[Ellipsis]", 
   "\[Or]", " ", 
   RowBox[{
    SubscriptBox["\[Exists]", "x"], 
    SubscriptBox["\[CapitalPhi]", 
     RowBox[{"n", " "}]]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["g", "1"], "\[NotEqual]", "0"}], "\[And]", "\[Ellipsis]", 
   "\[And]", 
   RowBox[{
    SubscriptBox["g", "k"], "\[NotEqual]", 
    RowBox[{
     RowBox[{"0", " ", "\[DoubleLongLeftRightArrow]", " ", 
      SubscriptBox["g", "1"]}], "\[CenterDot]", "\[Ellipsis]", "\[CenterDot]",
      
     SubscriptBox["g", "k"]}], "\[NotEqual]", "0", " "}]}], 
  TraditionalForm]}], "DisplayMath",
 CellTags->"b:0.2",
 CellID->61012584],

Cell["\<\
solving any decision problem can be reduced to solving a finite number of \
decision problems of the form\
\>", "Text",
 CellTags->"b:0.2",
 CellID->710124903],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Exists]", 
     SubscriptBox["x", "1"]], 
    RowBox[{
     SubscriptBox["\[Exists]", 
      SubscriptBox["x", "2"]], 
     RowBox[{"\[Ellipsis]", 
      RowBox[{
       SubscriptBox["\[Exists]", 
        SubscriptBox["x", "n"]], 
       RowBox[{
        RowBox[{
         SubscriptBox["f", "1"], "(", 
         RowBox[{
          SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
          SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}]}]}]}]}], 
   "\[And]", "\[Ellipsis]", "\[And]", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "k"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", " ", 
   RowBox[{
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", "0."}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.2",
 CellID->818573573],

Cell[TextData[{
 "By Hilbert\[CloseCurlyQuote]s Nullstellensatz and ",
 ButtonBox["Property 3",
  BaseStyle->"Hyperlink",
  ButtonData->"GBProperty3"],
 " of Gr\[ODoubleDot]bner bases"
}], "Text",
 CellTags->"b:0.2",
 CellID->133759324],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["f", "1"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", 
   "\[Ellipsis]", "\[And]", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "k"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", " ", 
   RowBox[{
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", "0"}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.2",
 CellID->77397878],

Cell["has complex solutions iff ", "Text",
 CellTags->"b:0.2",
 CellID->77306916],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox["GroebnerBasis", "MR"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["f", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["f", "k"], ",", 
      RowBox[{"1", "-", 
       RowBox[{"g", " ", "z"}]}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", " ", "z"}], "}"}]}], "]"}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.2",
 CellID->420278043],

Cell["with an arbitrary monomial order, is different than {1}. ", "Text",
 CellTags->"b:0.2",
 CellID->149107566],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "==", "2"}], " ", "\[And]", 
    RowBox[{"x", "==", "y"}], " ", "\[And]", 
    RowBox[{"x", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}], TraditionalForm]], "InlineMath"],
 " has complex solutions."
}], "MathCaption",
 CellTags->"b:0.2",
 CellID->209792017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "-", "2"}], ",", 
     RowBox[{"x", "-", "y"}], ",", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], " ", "z"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[10]:=",
 CellID->48625499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "y"}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}]}], "}"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[10]=",
 CellID->20587251]
}, Open  ]],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "==", "2"}], " ", "\[And]", 
    RowBox[{"x", "==", "y"}], " ", "\[And]", 
    RowBox[{
     SuperscriptBox["x", "2"], "\[NotEqual]", "1"}]}], TraditionalForm]], 
  "InlineMath"],
 " has no complex solutions."
}], "MathCaption",
 CellTags->"b:0.2",
 CellID->263162280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "-", "2"}], ",", 
     RowBox[{"x", "-", "y"}], ",", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "-", "1"}], ")"}], " ", "z"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[11]:=",
 CellID->115414983],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[11]=",
 CellID->206826770]
}, Open  ]],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " solves a decision problem, the monomial order used by the ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " computation is ",
 Cell[BoxData[
  RowBox[{"MonomialOrder", "->", "EliminationOrder"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", "z", "}"}], TraditionalForm]], "InlineMath"],
 " specified as the elimination variable list. This setting corresponds to \
the monomial ordering in which monomials containing ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " are greater than those that do not contain ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ", and the ordering of monomials not containing ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " is degree reverse lexicographic. If there is no inequation condition, \
there is no need to introduce ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ", and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses ",
 Cell[BoxData[
  RowBox[{"MonomialOrder", "->", "DegreeReverseLexicographic"}]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.2",
 CellID->196079508]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quantifier Elimination", "Section",
 CellTags->{"ComplexQuantifierElimination", "b:0.3"},
 CellID->793673109],

Cell[TextData[{
 "For any complex polynomial system there exists an equivalent \
quantifier-free complex polynomial system. This follows from Chevalley\
\[CloseCurlyQuote]s theorem, which states that a projection of a \
quasi-algebraically constructible set (a solution set of a quantifier-free \
system of polynomial equations and inequations) is a quasi-algebraically \
constructible set [",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"L"],
 "]. Quantifier elimination",
 " ",
 "is the procedure of finding a quantifier-free complex polynomial system \
equivalent to a given complex polynomial system. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", quantifier elimination for complex polynomial systems is done by ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ". It is also used by ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " as the first step in solving or finding instances of solutions of complex \
polynomial systems."
}], "Text",
 CellTags->"b:0.3",
 CellID->82738331],

Cell["\<\
Eliminating quantifiers from this system gives a condition for quadratic \
equations to have at least two different zeros.\
\>", "MathCaption",
 CellTags->"b:0.3",
 CellID->149637743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   SubscriptBox["\[Exists]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        SuperscriptBox["y", "2"]}], "+", 
       RowBox[{"b", " ", "y"}], "+", "c"}], "\[Equal]", "0"}], "&&", 
     RowBox[{"x", "\[NotEqual]", "y"}]}], ")"}]}], "]"}]], "Input",
 CellTags->"b:0.3",
 CellLabel->"In[12]:=",
 CellID->246904907],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}]}], ")"}], "||",
   
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{313, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.3",
 CellLabel->"Out[12]=",
 CellID->55931807]
}, Open  ]],

Cell[TextData[{
 "For complex polynomial systems ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the following quantifier elimination method. Given the identities"
}], "Text",
 CellTags->"b:0.3",
 CellID->136906628],

Cell[BoxData[{
 FormBox[
  RowBox[{
   SubscriptBox["\[ForAll]", "x"], 
   RowBox[{"\[CapitalPhi]", " ", "\[DoubleLongLeftRightArrow]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Exists]", "x"], 
       RowBox[{"\[Not]", "\[CapitalPhi]"}]}], ")"}]}]}]}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Exists]", "x"], 
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{
       SubscriptBox["\[CapitalPhi]", "1"], "\[Or]", "\[Ellipsis]", "\[Or]", 
       " ", 
       SubscriptBox["\[CapitalPhi]", 
        RowBox[{"n", " "}]]}], ")"}], " ", "\[DoubleLongLeftRightArrow]", " ",
      
     RowBox[{
      SubscriptBox["\[Exists]", "x"], 
      SubscriptBox["\[CapitalPhi]", "1"]}]}]}], "\[Or]", "\[Ellipsis]", 
   "\[Or]", " ", 
   RowBox[{
    SubscriptBox["\[Exists]", "x"], 
    SubscriptBox["\[CapitalPhi]", 
     RowBox[{"n", " "}]]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["g", "1"], "\[NotEqual]", "0"}], "\[And]", "\[Ellipsis]", 
    "\[And]", 
    RowBox[{
     SubscriptBox["g", "k"], "\[NotEqual]", 
     RowBox[{
      RowBox[{"0", " ", "\[DoubleLongLeftRightArrow]", " ", 
       SubscriptBox["g", "1"]}], "\[CenterDot]", "\[Ellipsis]", 
      "\[CenterDot]", 
      SubscriptBox["g", "k"]}], "\[NotEqual]", "0"}]}], ","}], 
  TraditionalForm]}], "DisplayMath",
 CellTags->"b:0.3",
 CellID->22516810],

Cell["\<\
eliminating quantifiers from any complex polynomial system can be reduced to \
a finite number of single existential quantifier eliminations from systems of \
the form\
\>", "Text",
 CellTags->"b:0.3",
 CellID->719618623],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Exists]", "y"], 
    RowBox[{
     RowBox[{
      SubscriptBox["f", "1"], "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"], ",", "y"}], ")"}], "\[Equal]", "0"}]}], 
   "\[And]", "\[Ellipsis]", "\[And]", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "k"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", "y"}], ")"}], "\[Equal]", "0"}], "\[And]", 
   " ", 
   RowBox[{
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", "y"}], ")"}], "\[NotEqual]", "0."}]}], 
  TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(1)"}]]}, {None, None}},
 CellTags->{"ComplQuantElim1", "b:0.3"},
 CellID->164605557],

Cell[TextData[{
 "To eliminate the quantifier from (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim1"],
 "), ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " first computes the Gr\[ODoubleDot]bner basis of equations"
}], "Text",
 CellTags->"b:0.3",
 CellID->341799182],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox["G",
    FontSlant->"Italic"], "=", 
   RowBox[{
    StyleBox["GroebnerBasis", "MR"], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["f", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["f", "k"]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"], ",", "y"}], "}"}]}], "]"}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.3",
 CellID->369396772],

Cell[TextData[{
 "with a monomial order that makes monomials containing ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " greater than monomials not containing ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellTags->"b:0.3",
 CellID->448465053],

Cell[TextData[{
 "The monomial order used is ",
 Cell[BoxData[
  ButtonBox["EliminationOrder",
   BaseStyle->"Hyperlink",
   ButtonData->"ElimOrder"]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", "y", "}"}], TraditionalForm]], "InlineMath"],
 " specified as the elimination variable list and ",
 ButtonBox["all basis polynomials kept",
  BaseStyle->"Hyperlink",
  ButtonData->"GBElim"],
 "."
}], "Text",
 CellTags->"b:0.3",
 CellID->256393426],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " contains no polynomials that depend on ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", then a quantifier-free system equivalent to (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim1"],
 ") can be obtained by equating all elements of ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " to zero, and asserting that at least one coefficient of ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " as a polynomial in ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " is not equal to zero. Otherwise let ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " be the element of ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " with the lowest positive degree ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["c",
     FontSlant->"Italic"], "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " be the leading coefficient of ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", and let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["h", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["h", "s"]}], "}"}], TraditionalForm]], "InlineMath"],
 " be all elements of ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " that do not depend on ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". Now (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim1"],
 ") can be split into a disjunction of two systems"
}], "Text",
 CellTags->"b:0.3",
 CellID->4567508],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", "y"], 
     RowBox[{
      RowBox[{
       StyleBox["c",
        FontSlant->"Italic"], "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}]}], "\[And]", 
    RowBox[{
     RowBox[{
      SubscriptBox["f", "1"], "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"], ",", "y"}], ")"}], "\[Equal]", "0"}], "\[And]",
     "\[Ellipsis]", "\[And]", 
    RowBox[{
     RowBox[{
      SubscriptBox["f", "k"], "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"], ",", "y"}], ")"}], "\[Equal]", "0"}], "\[And]",
     " ", 
    RowBox[{
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"], ",", "y"}], ")"}], "\[NotEqual]", "0"}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(2)"}]]}, {None, None}},
 CellTags->{"ComplQuantElim2", "b:0.3"},
 CellID->69712841],

Cell["and", "Text",
 CellTags->"b:0.3",
 CellID->289069035],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Exists]", "y"], 
    RowBox[{
     RowBox[{
      StyleBox["c",
       FontSlant->"Italic"], "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", " ", "0"}]}], "\[And]",
    " ", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "1"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", "y"}], ")"}], "\[Equal]", "0"}], "\[And]", 
   "\[Ellipsis]", "\[And]", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "k"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", "y"}], ")"}], "\[Equal]", "0"}], "\[And]", 
   " ", 
   RowBox[{
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", "y"}], ")"}], "\[NotEqual]", "0."}]}], 
  TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(3)"}]]}, {None, None}},
 CellTags->{"ComplQuantElim3", "b:0.3"},
 CellID->598413124],

Cell[TextData[{
 "To eliminate the quantifier from (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim2"],
 "), the quantifier elimination procedure is called recursively. Since the \
ideal generated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"c", ",", 
     SubscriptBox["f", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["f", "k"]}], "}"}], TraditionalForm]], "InlineMath"],
 " strictly contains the ideal generated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["f", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["f", "k"]}], "}"}], TraditionalForm]], "InlineMath"],
 ", the Noetherian property of polynomial rings guarantees finiteness of the \
recursion."
}], "Text",
 CellTags->"b:0.3",
 CellID->693896399],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " belongs to the radical of the ideal generated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["f", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["f", "k"]}], "}"}], TraditionalForm]], "InlineMath"],
 ", which is exactly when 1 belongs to"
}], "Text",
 CellTags->"b:0.3",
 CellID->41916580],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox["GroebnerBasis", "MR"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["h", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["h", "s"], ",", 
      RowBox[{"1", "-", 
       RowBox[{"c", " ", "z"}]}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", " ", "z"}], "}"}]}], "]"}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.3",
 CellID->512637847],

Cell[TextData[{
 "(",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim3"],
 ") is equivalent to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". Otherwise let"
}], "Text",
 CellTags->"b:0.3",
 CellID->718534176],

Cell[BoxData[
 FormBox[
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["r", 
        RowBox[{"d", "-", "1"}]], "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", "n"]}], ")"}], 
      SuperscriptBox["y", 
       RowBox[{"d", "-", "1"}]]}], "+", "\[Ellipsis]", "+", 
     RowBox[{
      SubscriptBox["r", "0"], "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], "\[Equal]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"c", "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["x", "n"]}], ")"}], "e"], 
      SuperscriptBox[
       RowBox[{"g", "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["x", "n"], ",", "y"}], ")"}], "d"]}], "-", 
     RowBox[{
      RowBox[{"q", "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", "n"], ",", "y"}], ")"}], " ", 
      RowBox[{"h", "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", "n"], ",", "y"}], ")"}]}]}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.3",
 CellID->118920921],

Cell[TextData[{
 "be the pseudoremainder of the division of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["g", "d"], TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " as polynomials in ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". Then (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim3"],
 ") is equivalent to the quantifier-free system"
}], "Text",
 CellTags->"b:0.3",
 CellID->405475917],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["c",
      FontSlant->"Italic"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", " ", "0"}], "\[And]", 
   " ", 
   RowBox[{
    RowBox[{
     SubscriptBox["h", "1"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", 
   "\[Ellipsis]", "\[And]", 
   RowBox[{
    RowBox[{
     SubscriptBox["h", "s"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["r", 
         RowBox[{"d", "-", "1"}]], "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", "0"}], " ", "\[Or]", 
      "\[Ellipsis]", "\[Or]", 
      RowBox[{
       RowBox[{
        SubscriptBox["r", "0"], "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", "0"}]}], ")"}], 
    "."}]}], TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(4)"}]]}, {None, None}},
 CellTags->{"ComplQuantElim4", "b:0.3"},
 CellID->5546503],

Cell[TextData[{
 "To show that (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim3"],
 ") implies (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim4"],
 "), suppose that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["a", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " satisfies (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim3"],
 "). Then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["c",
      FontSlant->"Italic"], "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[NotEqual]", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 " and there exists ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", such that"
}], "Text",
 CellTags->"b:0.3",
 CellID->242099882],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["f", "1"], "(", 
      RowBox[{
       SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "n"], ",", "b"}], ")"}], "\[Equal]", "0"}], "\[And]",
     "\[Ellipsis]", "\[And]", 
    RowBox[{
     RowBox[{
      SubscriptBox["f", "k"], "(", 
      RowBox[{
       SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "n"], ",", "b"}], ")"}], "\[Equal]", "0"}], "\[And]",
     " ", 
    RowBox[{
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "n"], ",", "b"}], ")"}], "\[NotEqual]", "0."}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.3",
 CellID->228341539],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["h", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["h", "s"]}], "}"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " belong to the ideal generated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["f", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["f", "k"]}], "}"}], TraditionalForm]], "InlineMath"],
 ","
}], "Text",
 CellTags->"b:0.3",
 CellID->137362455],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["h", "1"], "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", 
   "\[Ellipsis]", "\[And]", 
   RowBox[{
    RowBox[{
     SubscriptBox["h", "s"], "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[Equal]", "0"}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.3",
 CellID->137172770],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"h", "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"], ",", "b"}], ")"}], "\[Equal]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". Hence"
}], "Text",
 CellTags->"b:0.3",
 CellID->473412355],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"r", "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"], ",", "b"}], ")"}], "\[Equal]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["r", 
        RowBox[{"d", "-", "1"}]], "(", 
       RowBox[{
        SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["a", "n"]}], ")"}], 
      SuperscriptBox["b", 
       RowBox[{"d", "-", "1"}]]}], "+", "\[Ellipsis]", "+", 
     RowBox[{
      SubscriptBox["r", "0"], "(", 
      RowBox[{
       SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "n"]}], ")"}]}], "\[Equal]", " ", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"c", "(", 
       RowBox[{
        SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["a", "n"]}], ")"}], "e"], 
     SuperscriptBox[
      RowBox[{"g", "(", 
       RowBox[{
        SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["a", "n"], ",", "b"}], ")"}], "d"]}], "\[NotEqual]", " ",
     "0"}], ","}], TraditionalForm]], "DisplayMath",
 CellTags->"b:0.3",
 CellID->437690631],

Cell["which implies that", "Text",
 CellTags->"b:0.3",
 CellID->406555534],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["r", 
      RowBox[{"d", "-", "1"}]], "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[NotEqual]", "0"}], " ", "\[Or]", 
   "\[Ellipsis]", "\[Or]", 
   RowBox[{
    RowBox[{
     SubscriptBox["r", "0"], "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[NotEqual]", "0"}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.3",
 CellID->77823390],

Cell[TextData[{
 "To show that (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim4"],
 ") implies (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim3"],
 "), suppose that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["a", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " satisfies (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim4"],
 "). Then"
}], "Text",
 CellTags->"b:0.3",
 CellID->181178939],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"r", "(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"], ",", "y"}], ")"}], "\[Equal]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["r", 
       RowBox[{"d", "-", "1"}]], "(", 
      RowBox[{
       SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "n"]}], ")"}], 
     SuperscriptBox["y", 
      RowBox[{"d", "-", "1"}]]}], "+", "\[Ellipsis]", "+", 
    RowBox[{
     SubscriptBox["r", "0"], "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}]}], "\[Equal]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"c", "(", 
       RowBox[{
        SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["a", "n"]}], ")"}], "e"], 
     SuperscriptBox[
      RowBox[{"g", "(", 
       RowBox[{
        SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["a", "n"], ",", "y"}], ")"}], "d"]}], "-", 
    RowBox[{
     RowBox[{"q", "(", 
      RowBox[{
       SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "n"], ",", "y"}], ")"}], " ", 
     RowBox[{
      RowBox[{"h", "(", 
       RowBox[{
        SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["a", "n"], ",", "y"}], ")"}], "."}]}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.3",
 CellID->230447882],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", "(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"], ",", "y"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a polynomial of degree ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"], ",", "y"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a nonzero polynomial of degree less than ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", there is a root ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", "(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"], ",", "y"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"y", "-", "b"}], ")"}], "m"], TraditionalForm]], "InlineMath"],
 " divides ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", "(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"], ",", "y"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " but not ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"], ",", "y"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " for some ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", "m", "\[LessEqual]", "d"}], TraditionalForm]],
   "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"], ",", "b"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " was zero, then ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"y", "-", "b"}], ")"}], "m"], TraditionalForm]], "InlineMath"],
 " would divide ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"], ",", "y"}], ")"}], "d"], TraditionalForm]], 
  "InlineMath"],
 ", which is impossible because it would imply that ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"y", "-", "b"}], ")"}], "m"], TraditionalForm]], "InlineMath"],
 " divides ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"], ",", "y"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ". Therefore ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"], ",", "b"}], ")"}], "\[NotEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". ",
 ButtonBox["Property 4",
  BaseStyle->"Hyperlink",
  ButtonData->"GBProperty4"],
 " shows that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"p", "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"], ",", "b"}], ")"}], "\[Equal]", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 " for any polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "\[Element]", "G"}], TraditionalForm]], "InlineMath"],
 ". Since ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " is a Gr\[ODoubleDot]bner basis of the ideal generated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["f", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["f", "k"]}], "}"}], TraditionalForm]], "InlineMath"],
 ","
}], "Text",
 CellTags->"b:0.3",
 CellID->370242061],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["f", "1"], "(", 
       RowBox[{
        SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["a", "n"], ",", "b"}], ")"}], "\[Equal]", "0"}], 
     "\[And]", "\[Ellipsis]", "\[And]", 
     RowBox[{
      RowBox[{
       SubscriptBox["f", "k"], "(", 
       RowBox[{
        SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["a", "n"], ",", "b"}], ")"}], "\[Equal]", "0"}]}], 
    ","}]}], TraditionalForm]], "DisplayMath",
 CellTags->"b:0.3",
 CellID->277121168],

Cell["\<\
which completes the proof of correctness of the quantifier elimination \
algorithm.\
\>", "Text",
 CellTags->"b:0.3",
 CellID->5450433],

Cell[TextData[{
 "This eliminates the quantifier from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", "y"], 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["x", "1", "2"], "+", 
       SubsuperscriptBox["x", "2", "2"], "+", 
       SuperscriptBox["y", "2"]}], "==", "1"}]}], "\[And]", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "1"], "+", 
      SubscriptBox["x", "2"]}], "==", "y"}]}], TraditionalForm]], 
  "InlineMath"],
 ". Here ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "=", "1"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", "=", 
    RowBox[{
     RowBox[{"-", "y"}], "+", 
     SubscriptBox["x", "1"], "+", 
     SubscriptBox["x", "2"]}]}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 ". Since ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " is a nonzero constant, (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim2"],
 ") is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " and the equivalent quantifier-free system is given by (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim4"],
 "). Since ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " is a nonzero constant, (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQuantElim4"],
 ") becomes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["x", "1", "2"]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["x", "1"], " ", 
      SubscriptBox["x", "2"]}], "-", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["x", "2", "2"]}]}], "\[Equal]", "0"}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:0.3",
 CellID->134957362],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<GroebnerBasisOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<EliminateFromGroebnerBasis\>\"", "\[Rule]", "False"}], 
     "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["x", "1", "2"], "+", 
      SubsuperscriptBox["x", "2", "2"], "+", 
      SuperscriptBox["y", "2"], "-", "1"}], ",", 
     RowBox[{
      SubscriptBox["x", "1"], "+", 
      SubscriptBox["x", "2"], "-", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"]}], "}"}], ",", 
   RowBox[{"{", "y", "}"}], ",", 
   RowBox[{"MonomialOrder", "\[Rule]", "EliminationOrder"}]}], 
  "]"}]}], "Input",
 CellTags->"b:0.3",
 CellLabel->"In[13]:=",
 CellID->49912483],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     SubsuperscriptBox["x", "1", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubsuperscriptBox["x", "2", "2"]}]}], ",", 
   RowBox[{"y", "-", 
    SubscriptBox["x", "1"], "-", 
    SubscriptBox["x", "2"]}]}], "}"}]], "Output",
 ImageSize->{222, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.3",
 CellLabel->"Out[14]=",
 CellID->294171584]
}, Open  ]],

Cell["This resets the system option to its default value.", "MathCaption",
 CellTags->"b:0.3",
 CellID->56187135],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<GroebnerBasisOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<EliminateFromGroebnerBasis\>\"", "\[Rule]", "True"}], 
     "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:0.3",
 CellLabel->"In[15]:=",
 CellID->66949442]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arbitrary Complex Polynomial Systems", "Section",
 CellID->934984887],

Cell[CellGroupData[{

Cell["FindInstance", "Subsection",
 CellTags->"b:0.4.0",
 CellID->805204536],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " can handle arbitrary complex polynomial systems giving instances of \
complex solutions, or an empty list for systems that have no solutions. If \
the number of instances requested is more than one, the instances are \
randomly generated from the full solution of the system given by ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". If one instance is requested, a faster algorithm that produces one \
instance is used. Here is a description of the algorithm used to find a \
single instance, or prove that a system has no solutions."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->43785031],

Cell[TextData[{
 "If the system contains general quantifiers (",
 Cell[BoxData[
  FormBox["\[ForAll]", TraditionalForm]], "InlineMath"],
 "), the ",
 ButtonBox["quantifier elimination",
  BaseStyle->"Hyperlink",
  ButtonData->"ComplexQuantifierElimination"],
 " algorithm is used to eliminate the innermost quantifiers until the system \
contains only existential quantifiers (",
 Cell[BoxData[
  FormBox["\[Exists]", TraditionalForm]], "InlineMath"],
 ") or is quantifier-free. Note that"
}], "Text",
 CellTags->"b:0.4.0",
 CellID->64894745],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[Exists]", 
    SubscriptBox["x", "1"]], 
   RowBox[{
    SubscriptBox["\[Exists]", 
     SubscriptBox["x", "2"]], 
    RowBox[{"\[Ellipsis]", 
     RowBox[{
      SubscriptBox["\[Exists]", 
       SubscriptBox["x", "n"]], 
      RowBox[{"\[CapitalPhi]", "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", "n"], ",", 
        SubscriptBox["y", "1"], ",", "\[Ellipsis]", ",", " ", 
        SubscriptBox["y", "m"]}], ")"}]}]}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(1)"}]]}, {None, None}},
 CellTags->{"ComplFI1", "b:0.4.0"},
 CellID->180736027],

Cell[TextData[{
 "has solutions if and only if ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"\[CapitalPhi]", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", 
      SubscriptBox["y", "1"], ",", "\[Ellipsis]", ",", " ", 
      SubscriptBox["y", "m"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 " has solutions, and if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"], ",", 
     SubscriptBox["b", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["b", "m"]}], ")"}], TraditionalForm]], "InlineMath"],
 " is a solution of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"], ",", 
     SubscriptBox["y", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["y", "m"]}], ")"}], TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["b", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["b", "m"]}], ")"}], TraditionalForm]], "InlineMath"],
 " is a solution of (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplFI1"],
 "). Hence to find instances of solutions of systems containing only \
existential quantifiers it is enough to be able to find instances of \
quantifier-free systems. Moreover, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " is a solution of"
}], "Text",
 CellTags->"b:0.4.0",
 CellID->159181068],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "1"], "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], ")"}], "\[Or]", "\[Ellipsis]", "\[Or]", 
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "m"], "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], ")"}]}], TraditionalForm]], "DisplayMath",
 CellTags->"b:0.4.0",
 CellID->110151702],

Cell[TextData[{
 "if and only if it is a solution of one of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "i"], "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", "m"}], TraditionalForm]],
   "InlineMath"],
 ", so it is enough to show how to find instances of solutions of"
}], "Text",
 CellTags->"b:0.4.0",
 CellID->312821970],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["f", "1"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", 
   "\[Ellipsis]", "\[And]", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "k"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", " ", 
   RowBox[{
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", "0."}]}], 
  TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(2)"}]]}, {None, None}},
 CellTags->{"ComplFI2", "b:0.4.0"},
 CellID->287456835],

Cell[TextData[{
 "First compute the ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["f", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["f", "k"], ",", 
     RowBox[{"1", "-", 
      RowBox[{"g", " ", "z"}]}]}], "}"}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  RowBox[{"MonomialOrder", "->", "EliminationOrder"}]], "InlineFormula"],
 ", eliminating the polynomials that depend on ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " (if there is no inequation condition, ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " is the ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["f", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["f", "k"]}], "}"}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  RowBox[{"MonomialOrder", "->", "DegreeReverseLexicographic"}]], 
  "InlineFormula"],
 "). If ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " contains 1, there are no solutions. Otherwise, compute a subset ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 " of the highest cardinality among subsets strongly independent modulo the \
ideal generated by ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " with respect to the degree reverse lexicographic order ([",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"BW"],
 "], Section 9.3). Reorder ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 " so that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"S", "\[Equal]", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", 
       RowBox[{"n", "-", "d", "+", "1"}]], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], "}"}]}], TraditionalForm]], "InlineMath"],
 ", and compute the lexicographic order ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 " of the ideal generated by ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 ". To compute ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the ",
 ButtonBox["Gr\[ODoubleDot]bner walk",
  BaseStyle->"Hyperlink",
  ButtonData->"GBWalk"],
 " algorithm."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->369534153],

Cell[TextData[{
 "For each of the variables ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", 
    RowBox[{"n", "-", "d"}]}], TraditionalForm]], "InlineMath"],
 ", select the polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["h", "i"], "\[Element]", "H"}], TraditionalForm]], 
  "InlineMath"],
 " with the smallest leading monomial among elements of ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 " that depend on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " and not on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", 
      RowBox[{"i", "-", "1"}]]}], "}"}], TraditionalForm]], "InlineMath"],
 ". Let ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " be the leading coefficient of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "i"], TraditionalForm]], "InlineMath"],
 " as a polynomial in ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " depends on a variable that is not in ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]], "InlineMath"],
 ",",
 " replace ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 " with the lexicographic order Gr\[ODoubleDot]bner basis of the ideal \
generated by ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 ". The following shows that this operation keeps ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]], "InlineMath"],
 " strongly independent modulo the ideal generated by ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 ". Hence, possibly after a finite (by the Noetherian property of polynomial \
rings) number of extensions of ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 ", the leading coefficient ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "i"], TraditionalForm]], "InlineMath"],
 " depends only on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", 
      RowBox[{"n", "-", "d", "+", "1"}]], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 ", for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", 
    RowBox[{"n", "-", "d"}]}], TraditionalForm]], "InlineMath"],
 ". For the set of polynomials ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 ", ",
 "let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "P", ")"}], TraditionalForm]], "InlineMath"],
 " be the set of common zeros of elements of ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 ". ",
 "Both ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "G", ")"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "H", ")"}], TraditionalForm]], "InlineMath"],
 " have dimension ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Z", "(", "H", ")"}], "\[Subset]", 
    RowBox[{"Z", "(", "G", ")"}]}], TraditionalForm]], "InlineMath"],
 ", hence any ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 "-dimensional irreducible component of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "H", ")"}], TraditionalForm]], "InlineMath"],
 " is also a component of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "G", ")"}], TraditionalForm]], "InlineMath"],
 ". Since ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " does not vanish on any irreducible component of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "G", ")"}], TraditionalForm]], "InlineMath"],
 ", it does not vanish on any ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 "-dimensional irreducible component of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "H", ")"}], TraditionalForm]], "InlineMath"],
 ". ",
 "Therefore, the Gr\[ODoubleDot]bner basis of ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " contains a polynomial ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " depending only on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", 
      RowBox[{"n", "-", "d", "+", "1"}]], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 ". Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", 
    RowBox[{"t", " ", 
     SubscriptBox["c", "1"], 
     SubscriptBox["\[Ellipsis]c", 
      RowBox[{"n", "-", "d"}]]}]}], TraditionalForm]], "InlineMath"],
 ". To find a solution of (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplFI2"],
 "), pick its last ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", 
      RowBox[{"n", "-", "d", "+", "1"}]], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 " so that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"p", "(", 
     RowBox[{
      SubscriptBox["a", 
       RowBox[{"n", "-", "d", "+", "1"}]], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[NotEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". For all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", 
    RowBox[{"n", "-", "d"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["c", "i"], "(", 
     RowBox[{
      SubscriptBox["a", 
       RowBox[{"n", "-", "d", "+", "1"}]], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[NotEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", and so by ",
 ButtonBox["Property 4",
  BaseStyle->"Hyperlink",
  ButtonData->"GBProperty4"],
 " if ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "i"], TraditionalForm]], "InlineMath"],
 ", for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"i", "=", 
     RowBox[{"n", "-", "d"}]}], ",", "\[Ellipsis]", ",", " ", "1"}], 
   TraditionalForm]], "InlineMath"],
 ", is chosen to be the first root of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["h", "i"], "(", 
    RowBox[{
     SubscriptBox["x", "i"], ",", 
     SubscriptBox["a", 
      RowBox[{"i", "+", "1"}]], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["a", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[Element]", 
    RowBox[{"Z", "(", "H", ")"}], "\[Subset]", 
    RowBox[{"Z", "(", "G", ")"}]}], TraditionalForm]], "InlineMath"],
 ". Moreover, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[NotEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", because otherwise ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " would belong to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", 
    RowBox[{"H", "\[Union]", 
     RowBox[{"{", "g", "}"}]}], ")"}], TraditionalForm]], "InlineMath"],
 ", which would imply that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"t", "(", 
     RowBox[{
      SubscriptBox["a", 
       RowBox[{"n", "-", "d", "+", "1"}]], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "n"]}], ")"}], "\[Equal]", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", which is impossible since ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " divides ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->76539571],

Cell[TextData[{
 "To prove the correctness of the aforementioned algorithm, it must be shown \
that extending ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " that depend on a variable not in ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]], "InlineMath"],
 " preserves strong independence of ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]], "InlineMath"],
 " modulo the ideal generated by ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 ". Suppose for some ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", 
    RowBox[{"n", "-", "d"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " depends on a variable, which is not in ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]], "InlineMath"],
 ". Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["I", 
     RowBox[{"i", "+", "1"}]], "\[Subset]", 
    RowBox[{"\[DoubleStruckCapitalC]", "[", 
     RowBox[{
      SubscriptBox["x", 
       RowBox[{"i", "+", "1"}]], ",", "\[Ellipsis]", ",", " ", 
      SubscriptBox["x", "n"]}], "]"}]}], TraditionalForm]], "InlineMath"],
 " denote the ideal generated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"H", "\[Intersection]", 
    RowBox[{"\[DoubleStruckCapitalC]", "[", 
     RowBox[{
      SubscriptBox["x", 
       RowBox[{"i", "+", "1"}]], ",", "\[Ellipsis]", ",", " ", 
      SubscriptBox["x", "n"]}], "]"}]}], TraditionalForm]], "InlineMath"],
 ", and let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["J", 
     RowBox[{"i", "+", "1"}]], "\[Subset]", 
    RowBox[{"\[DoubleStruckCapitalC]", "[", 
     RowBox[{
      SubscriptBox["x", 
       RowBox[{"i", "+", "1"}]], ",", "\[Ellipsis]", ",", " ", 
      SubscriptBox["x", "n"]}], "]"}]}], TraditionalForm]], "InlineMath"],
 " denote the ideal generated by ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", 
    RowBox[{"i", "+", "1"}]], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 ". Then ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["J", 
    RowBox[{"i", "+", "1"}]], TraditionalForm]], "InlineMath"],
 " does not contain nonzero elements of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalC]", "[", 
    RowBox[{
     SubscriptBox["x", 
      RowBox[{"n", "-", "d", "+", "1"}]], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["x", "n"]}], "]"}], TraditionalForm]], "InlineMath"],
 ". To prove this, suppose that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"r", "\[Equal]", 
     RowBox[{
      RowBox[{"p", " ", 
       SubscriptBox["c", "i"]}], "+", "q"}]}], "\[Element]", 
    RowBox[{
     SubscriptBox["J", 
      RowBox[{"i", "+", "1"}]], "\[Intersection]", 
     RowBox[{
      RowBox[{"\[DoubleStruckCapitalC]", "[", 
       RowBox[{
        SubscriptBox["x", 
         RowBox[{"n", "-", "d", "+", "1"}]], ",", "\[Ellipsis]", ",", " ", 
        SubscriptBox["x", "n"]}], "]"}], "\\", 
      RowBox[{"{", "0", "}"}]}]}]}], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "\[Element]", 
    RowBox[{"\[DoubleStruckCapitalC]", "[", 
     RowBox[{
      SubscriptBox["x", 
       RowBox[{"i", "+", "1"}]], ",", "\[Ellipsis]", ",", " ", 
      SubscriptBox["x", "n"]}], "]"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "\[Element]", 
    SubscriptBox["I", 
     RowBox[{"i", "+", "1"}]]}], TraditionalForm]], "InlineMath"],
 ". Then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["h", "i"], "\[Equal]", " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["c", "i"], 
      SuperscriptBox[
       SubscriptBox["x", "i"], "k"]}], "+", "t"}]}], TraditionalForm]], 
  "InlineMath"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["deg", 
      SubscriptBox["x", "i"]], "(", "t", ")"}], "<", "k"}], TraditionalForm]],
   "InlineMath"],
 ", and"
}], "Text",
 CellTags->"b:0.4.0",
 CellID->112816986],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"p", " ", 
    SubscriptBox["h", "i"]}], "\[Equal]", 
   RowBox[{
    RowBox[{"p", " ", 
     SubscriptBox["c", "i"], 
     SuperscriptBox[
      SubscriptBox["x", "i"], "k"]}], "+", 
    RowBox[{"p", " ", "t"}]}], "\[Equal]", 
   RowBox[{
    RowBox[{"r", " ", 
     SuperscriptBox[
      SubscriptBox["x", "i"], "k"]}], "-", 
    RowBox[{"q", " ", 
     SuperscriptBox[
      SubscriptBox["x", "i"], "k"]}], "+", 
    RowBox[{"p", " ", "t"}]}]}], TraditionalForm]], "DisplayMath",
 CellTags->"b:0.4.0",
 CellID->70817737],

Cell[TextData[{
 "belongs to the ideal generated by ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 ", and so does ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "i"], "=", " ", 
    RowBox[{
     RowBox[{"r", " ", 
      SuperscriptBox[
       SubscriptBox["x", "i"], "k"]}], "+", 
     RowBox[{"p", " ", "t"}]}]}], TraditionalForm]], "InlineMath"],
 ". This contradicts the choice of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "i"], TraditionalForm]], "InlineMath"],
 " since the leading monomial of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 " depends on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " and is strictly smaller than the leading monomial of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "i"], TraditionalForm]], "InlineMath"],
 ". Therefore, the projection of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", 
    SubscriptBox["J", 
     RowBox[{"i", "+", "1"}]], ")"}], TraditionalForm]], "InlineMath"],
 " on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["A", "d"], "=", 
    SubscriptBox[
     RowBox[{"(", 
      SuperscriptBox["\[DoubleStruckCapitalC]", "d"], ")"}], 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", 
        RowBox[{"n", "-", "d", "+", "1"}]], ",", "\[Ellipsis]", ",", " ", 
       SubscriptBox["x", "n"]}], "}"}]]}], TraditionalForm]], "InlineMath"],
 " is dense in ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "d"], TraditionalForm]], "InlineMath"],
 ", and so, since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", 
    SubscriptBox["I", 
     RowBox[{"i", "+", "1"}]], ")"}], TraditionalForm]], "InlineMath"],
 " has dimension ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " must be zero on some irreducible component ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", 
    RowBox[{"i", "+", "1"}]], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", 
    SubscriptBox["I", 
     RowBox[{"i", "+", "1"}]], ")"}], TraditionalForm]], "InlineMath"],
 " whose projection on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "d"], TraditionalForm]], "InlineMath"],
 " is dense in ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "d"], TraditionalForm]], "InlineMath"],
 ". Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", 
    SubscriptBox["I", 
     RowBox[{"i", "+", "1"}]], ")"}], TraditionalForm]], "InlineMath"],
 " is the Zariski closure of the projection of the ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 "-dimensional set ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "H", ")"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", 
    RowBox[{"i", "+", "1"}]], TraditionalForm]], "InlineMath"],
 " is contained in the Zariski closure of the projection of an irreducible \
component ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 " ",
 "of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "H", ")"}], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Z", "(", 
     SubscriptBox["c", "i"], ")"}], "\[Intersection]", "C"}], 
   TraditionalForm]], "InlineMath"],
 " has dimension ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", hence ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " is zero on ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 ", and the projection of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 " on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "d"], TraditionalForm]], "InlineMath"],
 " is dense in ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "d"], TraditionalForm]], "InlineMath"],
 ", which proves that ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]], "InlineMath"],
 " is strongly independent modulo the ideal generated by ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->752227],

Cell[TextData[{
 "Here is an example in which ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 " ",
 "needs to be extended. Here ",
 Cell[BoxData[
  FormBox[
   RowBox[{"S", "\[Equal]", 
    RowBox[{"{", 
     SubscriptBox["x", "3"], "}"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["h", "1"], "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["x", "2"], "-", 
       SubscriptBox["x", "3"]}], ")"}], " ", 
     SubscriptBox["x", "1"]}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "1"], "\[Equal]", 
    RowBox[{
     SubscriptBox["x", "2"], "-", 
     SubscriptBox["x", "3"]}]}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["I", "2"], "\[Equal]", "<", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["x", "2"], "-", 
        SubscriptBox["x", "3"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["x", "2"], "-", 
       RowBox[{"2", " ", 
        SubscriptBox["x", "3"]}]}], ")"}]}], ">"}], TraditionalForm]], 
  "InlineMath"],
 ". ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "1"], TraditionalForm]], "InlineMath"],
 " is zero on one of the two one-dimensional components of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "2"], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:0.4.0",
 CellID->490482397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["x", "2"], "-", 
         SubscriptBox["x", "3"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["x", "2"], "-", 
        RowBox[{"2", " ", 
         SubscriptBox["x", "3"]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["x", "2"], "-", 
        SubscriptBox["x", "3"]}], ")"}], " ", 
      SubscriptBox["x", "1"]}], ",", 
     RowBox[{
      SubsuperscriptBox["x", "1", "2"], "-", 
      SubscriptBox["x", "1"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"], ",", 
     SubscriptBox["x", "3"]}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.4.0",
 CellLabel->"In[16]:=",
 CellID->74406493],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["x", "2", "3"], "-", 
    RowBox[{"4", " ", 
     SubsuperscriptBox["x", "2", "2"], " ", 
     SubscriptBox["x", "3"]}], "+", 
    RowBox[{"5", " ", 
     SubscriptBox["x", "2"], " ", 
     SubsuperscriptBox["x", "3", "2"]}], "-", 
    RowBox[{"2", " ", 
     SubsuperscriptBox["x", "3", "3"]}]}], ",", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "2"]}], "-", 
    RowBox[{
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["x", "1"]}], "+", 
    SubsuperscriptBox["x", "1", "2"]}]}], "}"}]], "Output",
 ImageSize->{304, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.0",
 CellLabel->"Out[16]=",
 CellID->78656386]
}, Open  ]],

Cell[TextData[{
 "Extending ",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "1"], " "}], TraditionalForm]], "InlineMath"],
 " results in all ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " depending on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "3"], TraditionalForm]], "InlineMath"],
 " only (in fact even constant) while preserving the strong independence of \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    SubscriptBox["x", "3"], "}"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:0.4.0",
 CellID->390674739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["x", "2", "3"], "-", 
      RowBox[{"4", " ", 
       SubsuperscriptBox["x", "2", "2"], " ", 
       SubscriptBox["x", "3"]}], "+", 
      RowBox[{"5", " ", 
       SubscriptBox["x", "2"], " ", 
       SubsuperscriptBox["x", "3", "2"]}], "-", 
      RowBox[{"2", " ", 
       SubsuperscriptBox["x", "3", "3"]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "1"], " ", 
       SubscriptBox["x", "2"]}], "-", 
      RowBox[{
       SubscriptBox["x", "1"], " ", 
       SubscriptBox["x", "3"]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["x", "1"]}], "+", 
      SubsuperscriptBox["x", "1", "2"]}], ",", 
     RowBox[{
      SubscriptBox["x", "2"], "-", 
      SubscriptBox["x", "3"]}]}], " ", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"], ",", 
     SubscriptBox["x", "3"]}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.4.0",
 CellLabel->"In[17]:=",
 CellID->126211027],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["x", "2"], "-", 
    SubscriptBox["x", "3"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["x", "1"]}], "+", 
    SubsuperscriptBox["x", "1", "2"]}]}], "}"}]], "Output",
 ImageSize->{113, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.0",
 CellLabel->"Out[17]=",
 CellID->431461227]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reduce", "Subsection",
 CellTags->"b:0.4.1",
 CellID->47730150],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can solve arbitrary complex polynomial systems. As the first step, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " uses the ",
 ButtonBox["quantifier elimination",
  BaseStyle->"Hyperlink",
  ButtonData->"ComplexQuantifierElimination"],
 " algorithm to eliminate the quantifiers. If the obtained quantifier-free \
system is a disjunction, each term of the disjunction is solved separately, \
and the solution is given as a disjunction of the solutions of the terms. \
Thus, the problem is reduced to solving quantifier-free systems of the form"
}], "Text",
 CellTags->"b:0.4.1",
 CellID->4413481],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["f", "1"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", 
   "\[Ellipsis]", "\[And]", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "k"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", " ", 
   RowBox[{
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", "0."}]}], 
  TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(3)"}]]}, {None, None}},
 CellTags->{"ComplQFReduce1", "b:0.4.1"},
 CellID->147136247],

Cell[TextData[{
 "First compute the ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["f", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["f", "k"], ",", 
     RowBox[{"1", "-", 
      RowBox[{"g", " ", "z"}]}]}], "}"}], TraditionalForm]], "InlineMath"],
 " with variable order ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"z", ",", " ", 
     SubscriptBox["x", "n"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "1"]}], "}"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  RowBox[{"MonomialOrder", "->", "Lexicographic"}]], "InlineFormula"],
 ", and select the polynomials that do not depend on ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ". Then the solution set of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"G", "\[Equal]", "0"}], "\[And]", " ", 
    RowBox[{
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", "0"}]}], 
   TraditionalForm]], "InlineMath"],
 " is equal to the solution set of (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQFReduce1"],
 ") and ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " does not vanish on any component of the zero set ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "G", ")"}], TraditionalForm]], "InlineMath"],
 " ",
 "of ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 ". ",
 "If ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " contains 1, (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQFReduce1"],
 ") has no solutions. Otherwise for each ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", "n"}], TraditionalForm]],
   "InlineMath"],
 ", such that the set ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["G", "i"], TraditionalForm]], "InlineMath"],
 " of elements of ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " depending on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " and not on any ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "j"], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"j", ">", "i"}], TraditionalForm]], "InlineMath"],
 " is not empty, select an element ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "i"], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["G", "i"], TraditionalForm]], "InlineMath"],
 " with the lowest positive degree in ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 ". If one of the leading coefficients ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "i"], TraditionalForm]], "InlineMath"],
 " is zero on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "G", ")"}], TraditionalForm]], "InlineMath"],
 ", that is, it belongs to the radical of the ideal generated by ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 ", replace ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " by the lexicographic Gr\[ODoubleDot]bner basis of the ideal generated by \
",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 ". Now split the system into"
}], "Text",
 CellTags->"b:0.4.1",
 CellID->42891942],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["c", 
       SubscriptBox["i", "1"]], "\[Equal]", "0"}], "\[And]", 
     RowBox[{"G", "\[Equal]", "0"}], "\[And]", " ", 
     RowBox[{"g", "\[NotEqual]", "0"}]}], ")"}], "\[Or]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["c", 
       SubscriptBox["i", "2"]], "\[Equal]", "0"}], "\[And]", 
     RowBox[{"G", "\[Equal]", "0"}], "\[And]", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["c", 
        SubscriptBox["i", "1"]], "g"}], "\[NotEqual]", "0"}]}], ")"}], 
   "\[Or]", "\[Ellipsis]", "\[Or]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["c", 
       SubscriptBox["i", "s"]], "\[Equal]", "0"}], "\[And]", 
     RowBox[{"G", "\[Equal]", "0"}], "\[And]", 
     RowBox[{
      RowBox[{
       SubscriptBox["c", 
        SubscriptBox["i", "1"]], 
       SubscriptBox["\[Ellipsis]c", 
        SubscriptBox["i", 
         RowBox[{"s", "-", "1"}]]], " ", "g"}], "\[NotEqual]", "0"}]}], ")"}],
    "\[Or]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"G", "\[Equal]", "0"}], "\[And]", 
      RowBox[{
       RowBox[{
        SubscriptBox["c", 
         SubscriptBox["i", "1"]], 
        SubscriptBox["\[Ellipsis]c", 
         SubscriptBox["i", "s"]], " ", "g"}], "\[NotEqual]", "0"}]}], ")"}], 
    "."}]}], TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(4)"}]]}, {None, None}},
 CellTags->{"ComplQFReduce2", "b:0.4.1"},
 CellID->12234468],

Cell[TextData[{
 "and call the solving procedure recursively on all but the last term of the \
disjunction (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData:>"ComplQFReduce2"],
 "). Note that the algebraic set ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["c", 
      SubscriptBox["i", "j"]], "\[Equal]", "0"}], "\[And]", 
    RowBox[{"G", "\[Equal]", "0"}]}], TraditionalForm]], "InlineMath"],
 " is strictly contained in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"G", "\[Equal]", "0"}], TraditionalForm]], "InlineMath"],
 ", so the recursion is finite. If the product of all the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " belongs to the radical of the ideal generated by ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 ",",
 " the last term has no solutions. Otherwise, by ",
 ButtonBox["Property 4",
  BaseStyle->"Hyperlink",
  ButtonData->"GBProperty4"],
 ", the solution set of the last term is equal to"
}], "Text",
 CellTags->"b:0.4.1",
 CellID->383312115],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["c", 
      SubscriptBox["i", "1"]], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", 
       RowBox[{
        SubscriptBox["i", "1"], "-", "1"}]]}], ")"}], "\[NotEqual]", "0"}], 
   "\[And]", 
   RowBox[{
    StyleBox["Roots", "MR"], "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["h", 
       SubscriptBox["i", "1"]], "\[Equal]", "0"}], ",", 
     SubscriptBox["x", 
      SubscriptBox["i", "1"]]}], "]"}], "\[And]", "\[Ellipsis]", "\[And]", 
   RowBox[{
    RowBox[{
     SubscriptBox["c", 
      SubscriptBox["i", "s"]], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", 
       RowBox[{
        SubscriptBox["i", "s"], "-", "1"}]]}], ")"}], "\[NotEqual]", "0"}], 
   "\[And]", 
   RowBox[{
    StyleBox["Roots", "MR"], "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["h", 
       SubscriptBox["i", "s"]], "\[Equal]", "0"}], ",", 
     SubscriptBox["x", 
      SubscriptBox["i", "s"]]}], "]"}], "\[And]", 
   RowBox[{
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", "0"}]}], 
  TraditionalForm]], "DisplayMath",
 CellMargins->{{66, 27}, {7, 7}},
 CellTags->"b:0.4.1",
 CellID->437745],

Cell[TextData[{
 "The conditions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", 
     SubscriptBox["i", "j"]], "\[NotEqual]", "0"}], TraditionalForm]], 
  "InlineMath"],
 " guarantee that all the solutions (represented as radicals or ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects) given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    ButtonBox["Roots",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Roots"], "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["h", 
       SubscriptBox["i", "j"]], "\[Equal]", "0"}], ",", 
     SubscriptBox["x", 
      SubscriptBox["i", "j"]]}], "]"}], TraditionalForm]], "InlineMath"],
 " are well defined. ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " performs several operations in order to simplify the inequation conditions \
returned, like removing multiple factors, removing factors common with \
earlier inequation conditions, reducing modulo the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", 
    SubscriptBox["i", "j"]], TraditionalForm]], "InlineMath"],
 ", and removing factors that are nonzero on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Z", "(", "G", ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.4.1",
 CellID->375870]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options", "Section",
 CellID->163780876],

Cell[CellGroupData[{

Cell["Options for Reduce, Resolve, and FindInstance", "Subsection",
 CellTags->"b:0.5.0",
 CellID->804567386],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions for solving complex polynomial systems have a number of options \
that control the way they operate. This section gives a summary of these \
options."
}], "Text",
 CellTags->"b:0.5.0",
 CellID->110467185],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"Backsubstitution", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether the solutions given by ",
     Cell[BoxData[
      ButtonBox["Reduce",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Resolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
     " with specified variables should be unwound by backsubstitution"
    }], "TableText"]},
   {
    ButtonBox["Cubics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cubics"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the Cardano formulas should be used to express solutions of cubics\
\>", "TableText"]},
   {
    ButtonBox["Quartics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Quartics"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the Cardano formulas should be used to express solutions of quartics\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.5.0",
 CellID->532547471],

Cell[TextData[{
 "Options of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " affecting the behavior of complex polynomial systems."
}], "Caption",
 CellTags->"b:0.5.0",
 CellID->135821432],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], "\[Infinity]", Cell[
    TextData[{
     "the working precision to be used in computations, with the default \
settings of system options; the value of working precision affects only calls \
to ",
     Cell[BoxData[
      ButtonBox["Roots",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Roots"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.5.0",
 CellID->230187574],

Cell[TextData[{
 "Options of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " affecting the behavior of complex polynomial systems."
}], "Caption",
 CellTags->"b:0.5.0",
 CellID->134658611],

Cell[CellGroupData[{

Cell["Backsubstitution", "Subsubsection",
 CellTags->"b:0.5.0",
 CellID->534299437],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " may use variables appearing earlier in the variable list to express \
solutions for variables appearing later in the variable list."
}], "MathCaption",
 CellTags->"b:0.5.0",
 CellID->49107805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "5"], "-", 
      RowBox[{"3", " ", "x"}], "+", "7"}], "\[Equal]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.5.0",
 CellLabel->"In[18]:=",
 CellID->47693454],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"7", "-", 
         RowBox[{"3", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"7", "-", 
         RowBox[{"3", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"7", "-", 
         RowBox[{"3", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"7", "-", 
         RowBox[{"3", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"7", "-", 
         RowBox[{"3", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}]}], ")"}], "&&",
   
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}]}], "||", 
    RowBox[{"y", "\[Equal]", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{414, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.0",
 CellLabel->"Out[18]=",
 CellID->120362649]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Backsubstitution", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " uses backsubstitution to eliminate variables from the right-hand sides of \
the equations."
}], "MathCaption",
 CellTags->"b:0.5.0",
 CellID->562047429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "5"], "-", 
      RowBox[{"3", " ", "x"}], "+", "7"}], "\[Equal]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Backsubstitution", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.5.0",
 CellLabel->"In[19]:=",
 CellID->91622],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{451, 448},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.0",
 CellLabel->"Out[19]=",
 CellID->675005616]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cubics and Quartics", "Subsubsection",
 CellTags->"b:0.5.0",
 CellID->916560033],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " does not use the Cardano formulas for solving cubics or quartics."
}], "MathCaption",
 CellTags->"b:0.5.0",
 CellID->22995033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", " ", "x"}], "+", "7"}], "\[Equal]", "0"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellTags->"b:0.5.0",
 CellLabel->"In[20]:=",
 CellID->220100868],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"7", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"7", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"7", "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}]}]], "Output",
 ImageSize->{555, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.0",
 CellLabel->"Out[20]=",
 CellID->727821508]
}, Open  ]],

Cell[TextData[{
 "Setting the options ",
 Cell[BoxData[
  ButtonBox["Cubics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cubics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Quartics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quartics"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to use the Cardano formulas for solving cubics and quartics."
}], "MathCaption",
 CellTags->"b:0.5.0",
 CellID->156420963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", " ", "x"}], "+", "7"}], "\[Equal]", "0"}], ",", " ", "x", 
   ",", " ", 
   RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.5.0",
 CellLabel->"In[21]:=",
 CellID->58867455],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", 
        RowBox[{"7", "-", 
         RowBox[{"3", " ", 
          SqrtBox["5"]}]}]], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"7", "-", 
         RowBox[{"3", " ", 
          SqrtBox["5"]}]}], ")"}]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"7", "-", 
          RowBox[{"3", " ", 
           SqrtBox["5"]}]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "+", 
    FractionBox[
     RowBox[{"1", "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"2", "/", "3"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"7", "-", 
         RowBox[{"3", " ", 
          SqrtBox["5"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"7", "-", 
          RowBox[{"3", " ", 
           SqrtBox["5"]}]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "+", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"2", "/", "3"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"7", "-", 
         RowBox[{"3", " ", 
          SqrtBox["5"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]]}]}]}]], "Output",
 ImageSize->{374, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.0",
 CellLabel->"Out[21]=",
 CellID->350610691]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["WorkingPrecision", "Subsubsection",
 CellTags->"b:0.5.0",
 CellID->869227976],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " set to a finite number, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " uses numeric methods to find polynomial roots."
}], "MathCaption",
 CellTags->"b:0.5.0",
 CellID->162562523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", " ", "x"}], "+", "7"}], "\[Equal]", "0"}], ",", " ", "x", 
   ",", " ", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellTags->"b:0.5.0",
 CellLabel->"In[22]:=",
 CellID->318749219],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
   "-", "2.42598875736162212607641804353295788251`20.01383185703354"}]}], "||",
   
  RowBox[{"x", "\[Equal]", 
   RowBox[{
   "1.21299437868081106303820902176647894125`19.761044306700306", "-", 
    RowBox[{
    "1.18914510810655089078181065598302524433`19.752420372071693", " ", 
     "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
   "1.21299437868081106303820902176647894125`19.761044306700306", "+", 
    RowBox[{
    "1.18914510810655089078181065598302524433`19.752420372071693", " ", 
     "\[ImaginaryI]"}]}]}]}]], "Output",
 ImageSize->{561, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.0",
 CellLabel->"Out[22]=",
 CellID->43878235]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The ReduceOptions group of system options", "Subsection",
 CellTags->"b:0.5.1",
 CellID->167657003],

Cell[TextData[{
 "Here are the system options from the ",
 Cell[BoxData["ReduceOptions"], "InlineFormula"],
 " group that may affect the behavior of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " for complex polynomial systems. The options can be set with"
}], "Text",
 CellTags->"b:0.5.1",
 CellID->218482819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetSystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetSystemOptions"], "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"option\", \"TI\"]\)\!\(\*
StyleBox[\" \", \"TI\"]\)\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "->", 
      StyleBox["value", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Program",
 CellTags->"b:0.5.1",
 CellID->422400505],

Cell[TextData[{
 "This sets the option ",
 Cell[BoxData["FinitePrecisionGB"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.5.1",
 CellID->133051656],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<FinitePrecisionGB\>\"", "\[Rule]", "True"}], "}"}]}], "]"}],
   ";"}]], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[23]:=",
 CellID->346370944],

Cell[TextData[{
 "This checks the value of ",
 Cell[BoxData["FinitePrecisionGB"], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.5.1",
 CellID->6683350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<FinitePrecisionGB\>\"", "/.", 
  RowBox[{"(", 
   RowBox[{"\"\<ReduceOptions\>\"", "/.", 
    RowBox[{"SystemOptions", "[", "]"}]}], ")"}]}]], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[24]:=",
 CellID->38559548],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.1",
 CellLabel->"Out[24]=",
 CellID->352979638]
}, Open  ]],

Cell[TextData[{
 "This sets the option ",
 Cell[BoxData["FinitePrecisionGB"], "InlineFormula"],
 " back to the default value ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.5.1",
 CellID->290204304],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<FinitePrecisionGB\>\"", "\[Rule]", "False"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[25]:=",
 CellID->563530338],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<FinitePrecisionGB\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether finite values of working precision should be used in calls to ",
     
     Cell[BoxData[
      ButtonBox["GroebnerBasis",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"]
    }], "TableText"]},
   {"\"\<ReorderVariables\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether ",
     Cell[BoxData[
      ButtonBox["Reduce",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Resolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
     " are allowed to reorder the specified variables"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.5.1",
 CellID->138207434],

Cell[TextData[{
 Cell[BoxData["ReduceOptions"], "InlineFormula"],
 " group options that affect the behavior of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " for complex polynomial systems."
}], "Caption",
 CellTags->"b:0.5.1",
 CellID->308678426],

Cell[CellGroupData[{

Cell["FinitePrecisionGB", "Subsubsection",
 CellTags->"b:0.5.1",
 CellID->379056828],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  RowBox[{"CoefficientDomain", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ". This means that even with ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " set to a finite number ",
 Cell[BoxData[
  FormBox[
   StyleBox["prec",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 ", if the input is exact ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " uses exact computations."
}], "MathCaption",
 CellTags->"b:0.5.1",
 CellID->162655316],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "123", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "0"}], "2"], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", "0"}], "3"], 
     RowBox[{
      RowBox[{"RandomInteger", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["10", "100"]}], ",", 
         SuperscriptBox["10", "100"]}], "}"}], "]"}], " ", 
      SuperscriptBox["x", "i"], " ", 
      SuperscriptBox["y", "j"]}]}]}]}], ";", 
  RowBox[{"g", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "0"}], "3"], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", "0"}], "2"], 
     RowBox[{
      RowBox[{"RandomInteger", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["10", "100"]}], ",", 
         SuperscriptBox["10", "100"]}], "}"}], "]"}], " ", 
      SuperscriptBox["x", "i"], " ", 
      SuperscriptBox["y", "j"]}]}]}]}], ";"}], "\n", 
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["a", "1"], "=", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "\[Equal]", "0"}], "&&", 
       RowBox[{"g", "\[Equal]", "0"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "100"}], ",", 
      RowBox[{"Backsubstitution", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "]"}]}], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[26]:=",
 CellID->84186630],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.481`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.1",
 CellLabel->"Out[28]=",
 CellID->97328426]
}, Open  ]],

Cell[TextData[{
 "Setting the system option ",
 Cell[BoxData[
  RowBox[{"\"\<FinitePrecisionGB\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " use ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  RowBox[{"CoefficientDomain", "->", 
   RowBox[{"InexactNumbers", "[", 
    StyleBox["prec", "TI"], "]"}]}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.5.1",
 CellID->723830391],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<FinitePrecisionGB\>\"", "\[Rule]", "True"}], "}"}]}], "]"}],
   ";"}], "\n", 
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["a", "2"], "=", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "\[Equal]", "0"}], "&&", 
       RowBox[{"g", "\[Equal]", "0"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "100"}], ",", 
      RowBox[{"Backsubstitution", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "]"}]}], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[29]:=",
 CellID->43750448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.25000000000000006`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.1",
 CellLabel->"Out[30]=",
 CellID->648262201]
}, Open  ]],

Cell[TextData[{
 "Using finite precision may significantly improve the speed of ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " computations. However, the numeric computations may fail due to loss of \
precision, or give incorrect answers. They usually give less precise results \
than exact ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " computations followed by numeric root finding."
}], "MathCaption",
 CellTags->"b:0.5.1",
 CellID->102977779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["a", "1"], ",", 
    SubscriptBox["a", "2"]}], "}"}]}]], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[31]:=",
 CellID->97069423],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"90.72671888867391`", ",", "48.258317137087616`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.1",
 CellLabel->"Out[31]=",
 CellID->829969076]
}, Open  ]],

Cell["This shows that the results are equal up to their precision.", \
"MathCaption",
 CellTags->"b:0.5.1",
 CellID->42314769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sort", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "/.", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"ToRules", "[", 
      SubscriptBox["a", "1"], "]"}], "}"}]}], "]"}], "-", 
  RowBox[{"Sort", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "/.", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"ToRules", "[", 
      SubscriptBox["a", "2"], "]"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[32]:=",
 CellID->190539109],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{452, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.1",
 CellLabel->"Out[32]=",
 CellID->188859369]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<FinitePrecisionGB\>\"", "\[Rule]", "False"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[33]:=",
 CellID->52362266]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReorderVariables", "Subsubsection",
 CellTags->"b:0.5.1",
 CellID->98929011],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " is not allowed to reorder the specified variables. Variables appearing \
earlier in the variable list may be used to express solutions for variables \
appearing later in the variable list, but not vice versa."
}], "MathCaption",
 CellTags->"b:0.5.1",
 CellID->635299211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "3"], "+", 
      RowBox[{"3", " ", "z"}], "-", 
      RowBox[{"2", " ", "y"}], "+", "1"}], "\[Equal]", "x"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "-", "7"}], "\[Equal]", "y"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[34]:=",
 CellID->587657385],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "21"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "10"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SqrtBox["3"]}]}], "||", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "21"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "3"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "2"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"699", "+", 
           RowBox[{"2", " ", "x"}], "-", 
           SuperscriptBox["x", "2"], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"244", "-", 
              RowBox[{"4", " ", "x"}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{"23", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"699", "+", 
           RowBox[{"2", " ", "x"}], "-", 
           SuperscriptBox["x", "2"], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"244", "-", 
              RowBox[{"4", " ", "x"}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{"23", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"699", "+", 
           RowBox[{"2", " ", "x"}], "-", 
           SuperscriptBox["x", "2"], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"244", "-", 
              RowBox[{"4", " ", "x"}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{"23", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}]}], ")"}], "&&",
     
    RowBox[{
     RowBox[{
      RowBox[{"-", "21"}], "+", "x"}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     FractionBox[
      RowBox[{"72", "-", 
       RowBox[{"2", " ", "x"}], "+", 
       RowBox[{"13", " ", "y"}], "+", 
       SuperscriptBox["y", "2"]}], 
      RowBox[{
       RowBox[{"-", "21"}], "+", "x"}]]}]}], ")"}]}]], "Output",
 ImageSize->{498, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.1",
 CellLabel->"Out[34]=",
 CellID->35083699]
}, Open  ]],

Cell[TextData[{
 "Setting the system option ",
 Cell[BoxData[
  RowBox[{"\"\<ReorderVariables\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to pick a variable order that makes the equations easier to solve."
}], "MathCaption",
 CellTags->"b:0.5.1",
 CellID->282795960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ReorderVariables\>\"", "\[Rule]", "True"}], "}"}]}], "]"}], 
  ";", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["z", "3"], "+", 
       RowBox[{"3", " ", "z"}], "-", 
       RowBox[{"2", " ", "y"}], "+", "1"}], "\[Equal]", "x"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["z", "2"], "-", "7"}], "\[Equal]", "y"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[35]:=",
 CellID->188790613],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "7"}], "+", 
    SuperscriptBox["z", "2"]}]}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"15", "+", 
    RowBox[{"3", " ", "z"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    SuperscriptBox["z", "3"]}]}]}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.1",
 CellLabel->"Out[35]=",
 CellID->113313394]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ReorderVariables\>\"", "\[Rule]", "False"}], "}"}]}], "]"}],
   ";"}]], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[36]:=",
 CellID->24410703]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Section",
 CellMargins->{{27, 27}, {20, 18}},
 CellTags->{"t:29", "c:29", "b:0.6"},
 CellID->89793884],

Cell[TextData[{
 "[1] T. Becker and V. Weispfenning, ",
 StyleBox["Gr\[ODoubleDot]bner Bases",
  FontSlant->"Italic"],
 ", New York: Springer-Verlag, 1993."
}], "DisplayMath",
 CellTags->{"BW", "b:0.6"},
 CellID->174911420],

Cell[TextData[{
 "[2] D. Cox, J. Little, and D. O'Shea, ",
 StyleBox["Ideals, Varieties, and Algorithms",
  FontSlant->"Italic"],
 ", New York: Springer-Verlag, 1996."
}], "DisplayMath",
 CellTags->{"CLS", "b:0.6"},
 CellID->543617109],

Cell[TextData[{
 "[3] S. \[CapitalLSlash]ojasiewicz, ",
 StyleBox["Introduction to Complex Analytic Geometry",
  FontSlant->"Italic"],
 ", New York: Springer-Verlag, 1991."
}], "DisplayMath",
 CellTags->{"L", "b:0.6"},
 CellID->551706795],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->620241697],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "TutorialMoreAbout",
 CellID->41792741],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "TutorialMoreAbout",
 CellID->491741950],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "TutorialMoreAbout",
 CellID->431890435],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "TutorialMoreAbout",
 CellID->529168822]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->660206149],

Cell[TextData[ButtonBox["Solving Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingEquations"]], "RelatedTutorials",
 CellID->27763821],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/Inequalities-SymbolicMathematics"]], "RelatedTutorials",
 CellID->44163066],

Cell[TextData[ButtonBox["Generic and Non\[Hyphen]Generic Solutions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GenericAndNonGenericSolutions"]], "RelatedTutorials",
 CellID->9553489],

Cell[TextData[ButtonBox["Equations and Inequalities over Domains",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EquationsAndInequalitiesOverDomains"]], "RelatedTutorials",\

 CellID->202769951],

Cell[TextData[ButtonBox["Solving Logical Combinations of Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]], \
"RelatedTutorials",
 CellID->544696413],

Cell[TextData[ButtonBox["The Representation of Solution Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheRepresentationOfSolutionSets"]], "RelatedTutorials",
 CellID->764341847],

Cell[TextData[ButtonBox["Quantifiers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Quantifiers"]], "RelatedTutorials",
 CellID->229816863]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Complex Polynomial Systems - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 21.8270500}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The Mathematica functions Reduce, Resolve, and FindInstance allow you to \
solve a wide variety of problems that can be expressed in terms of equations \
and inequalities. The functions use a collection of algorithms applicable to \
classes of problems satisfying particular properties, as well as a set of \
heuristics that attempt to reduce the given problem to a sequence of problems \
that can be solved using the algorithms. This tutorial describes the \
algorithms used to solve the class of problems known as complex polynomial \
systems. It characterizes the structure of the returned answers and describes \
the options that affect various aspects of the methods involved. A complex \
polynomial system is an expression constructed with polynomial equations and \
inequations combined using logical connectives and quantifiers", 
    "synonyms" -> {}, "title" -> "Complex Polynomial Systems", "type" -> 
    "Tutorial", "uri" -> "tutorial/ComplexPolynomialSystems"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:3"->{
  Cell[4342, 110, 86, 2, 70, "Section",
   CellTags->{"t:3", "c:3", "b:0.0"},
   CellID->73712623]},
 "c:3"->{
  Cell[4342, 110, 86, 2, 70, "Section",
   CellTags->{"t:3", "c:3", "b:0.0"},
   CellID->73712623]},
 "b:0.0"->{
  Cell[4342, 110, 86, 2, 70, "Section",
   CellTags->{"t:3", "c:3", "b:0.0"},
   CellID->73712623],
  Cell[4431, 114, 1144, 30, 70, "Text",
   CellTags->"b:0.0",
   CellID->142044117],
  Cell[5578, 146, 163, 5, 70, "Text",
   CellTags->"b:0.0",
   CellID->60612736],
  Cell[5744, 153, 763, 23, 70, "DisplayMath",
   CellTags->"b:0.0",
   CellID->646880285],
  Cell[6510, 178, 104, 2, 70, "Text",
   CellTags->"b:0.0",
   CellID->9470698],
  Cell[6617, 182, 719, 21, 70, "DisplayMath",
   CellTags->"b:0.0",
   CellID->92176511],
  Cell[7339, 205, 980, 37, 70, "Text",
   CellTags->"b:0.0",
   CellID->321261601],
  Cell[8322, 244, 355, 13, 70, "Text",
   CellTags->"b:0.0",
   CellID->9009455],
  Cell[8680, 259, 837, 29, 70, "DisplayMath",
   CellTags->{"Complex1", "b:0.0"},
   CellID->403973843],
  Cell[9520, 290, 584, 23, 70, "Text",
   CellTags->"b:0.0",
   CellID->107843165],
  Cell[10107, 315, 137, 4, 70, "Text",
   CellTags->"b:0.0",
   CellID->14769913],
  Cell[10247, 321, 684, 23, 70, "DisplayMath",
   CellTags->{"PNF", "b:0.0"},
   CellID->545791106],
  Cell[10934, 346, 688, 24, 70, "Text",
   CellTags->"b:0.0",
   CellID->337844267],
  Cell[11625, 372, 161, 5, 70, "Text",
   CellTags->"b:0.0",
   CellID->928012757],
  Cell[11789, 379, 691, 21, 70, "DisplayMath",
   CellTags->{"DNF", "b:0.0"},
   CellID->348193030],
  Cell[12483, 402, 250, 9, 70, "Text",
   CellTags->"b:0.0",
   CellID->112672566],
  Cell[12736, 413, 656, 20, 70, "Text",
   CellTags->"b:0.0",
   CellID->336911978],
  Cell[13395, 435, 483, 15, 70, "DisplayMath",
   CellTags->"b:0.0",
   CellID->602828466],
  Cell[13881, 452, 183, 5, 70, "Text",
   CellTags->"b:0.0",
   CellID->443188525],
  Cell[14067, 459, 479, 15, 70, "Text",
   CellTags->"b:0.0",
   CellID->332287509],
  Cell[14549, 476, 1802, 58, 70, "DisplayMath",
   CellTags->{"GeneralComplexSolution", "b:0.0"},
   CellID->136556618],
  Cell[16354, 536, 1630, 54, 70, "Text",
   CellTags->"b:0.0",
   CellID->8410713],
  Cell[17987, 592, 178, 8, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->237750176],
  Cell[18190, 604, 830, 28, 70, "Input",
   CellTags->"b:0.0",
   CellID->122593157],
  Cell[19023, 634, 1713, 59, 98, "Output",
   CellTags->"b:0.0",
   CellID->390816834],
  Cell[20751, 696, 335, 9, 70, "Text",
   CellTags->"b:0.0",
   CellID->340462317],
  Cell[21089, 707, 472, 15, 70, "DisplayMath",
   CellTags->"b:0.0",
   CellID->273437329],
  Cell[21564, 724, 597, 22, 70, "Text",
   CellTags->"b:0.0",
   CellID->139558513],
  Cell[22164, 748, 199, 8, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->609600025],
  Cell[22388, 760, 727, 25, 70, "Input",
   CellTags->"b:0.0",
   CellID->27783491],
  Cell[23118, 787, 1593, 54, 75, "Output",
   CellTags->"b:0.0",
   CellID->937920616],
  Cell[24726, 844, 719, 15, 70, "Text",
   CellTags->"b:0.0",
   CellID->74100314],
  Cell[25448, 861, 192, 8, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->135036826],
  Cell[25665, 873, 835, 28, 70, "Input",
   CellTags->"b:0.0",
   CellID->27486418],
  Cell[26503, 903, 351, 12, 36, "Output",
   CellTags->"b:0.0",
   CellID->195779055],
  Cell[26869, 918, 472, 17, 70, "Text",
   CellTags->"b:0.0",
   CellID->27312213]},
 "Complex1"->{
  Cell[8680, 259, 837, 29, 70, "DisplayMath",
   CellTags->{"Complex1", "b:0.0"},
   CellID->403973843]},
 "PNF"->{
  Cell[10247, 321, 684, 23, 70, "DisplayMath",
   CellTags->{"PNF", "b:0.0"},
   CellID->545791106]},
 "DNF"->{
  Cell[11789, 379, 691, 21, 70, "DisplayMath",
   CellTags->{"DNF", "b:0.0"},
   CellID->348193030]},
 "GeneralComplexSolution"->{
  Cell[14549, 476, 1802, 58, 70, "DisplayMath",
   CellTags->{"GeneralComplexSolution", "b:0.0"},
   CellID->136556618]},
 "GroebnerBasis"->{
  Cell[27378, 940, 92, 2, 70, "Section",
   CellTags->"GroebnerBasis",
   CellID->138375135]},
 "b:0.1.0"->{
  Cell[27495, 946, 70, 2, 70, "Subsection",
   CellTags->"b:0.1.0",
   CellID->143442327],
  Cell[27568, 950, 856, 30, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->45515852],
  Cell[28427, 982, 668, 26, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->809364157],
  Cell[29098, 1010, 1530, 58, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->95853517],
  Cell[30631, 1070, 2279, 84, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->350947462],
  Cell[32913, 1156, 451, 23, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->102932712],
  Cell[33367, 1181, 1955, 73, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->115687632],
  Cell[35325, 1256, 1376, 52, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->469904506],
  Cell[36704, 1310, 1707, 65, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->359221891],
  Cell[38414, 1377, 621, 22, 70, "DisplayMath",
   CellTags->"b:0.1.0",
   CellID->243375792],
  Cell[39038, 1401, 1220, 51, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->717872190],
  Cell[40261, 1454, 3163, 107, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->74043315],
  Cell[43427, 1563, 791, 30, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->16067485],
  Cell[44221, 1595, 956, 26, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->40516630],
  Cell[45180, 1623, 1079, 41, 70, "Text",
   CellTags->{"GBProperty1", "b:0.1.0"},
   CellID->101329384],
  Cell[46262, 1666, 105, 2, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->76039018],
  Cell[46370, 1670, 1912, 69, 70, "Text",
   CellTags->{"GBProperty2", "b:0.1.0"},
   CellID->251743588],
  Cell[48285, 1741, 8341, 314, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->7064830],
  Cell[56629, 2057, 743, 28, 70, "DisplayMath",
   CellTags->"b:0.1.0",
   CellID->43249874],
  Cell[57375, 2087, 4850, 186, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->267330306],
  Cell[62228, 2275, 1718, 64, 70, "Text",
   CellTags->{"GBProperty3", "b:0.1.0"},
   CellID->116059195],
  Cell[63949, 2341, 436, 17, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->81054669],
  Cell[64388, 2360, 138, 7, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->372338942],
  Cell[64529, 2369, 728, 27, 70, "DisplayMath",
   CellTags->"b:0.1.0",
   CellID->64785049],
  Cell[65260, 2398, 1882, 66, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->188019864],
  Cell[67145, 2466, 777, 27, 70, "DisplayMath",
   CellTags->"b:0.1.0",
   CellID->306918598],
  Cell[67925, 2495, 2295, 85, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->133913109],
  Cell[70223, 2582, 158, 5, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->625037811],
  Cell[70384, 2589, 3465, 123, 70, "Text",
   CellTags->{"GBProperty4", "b:0.1.0"},
   CellID->63440976],
  Cell[73852, 2714, 467, 18, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->63896074],
  Cell[74322, 2734, 1047, 33, 70, "DisplayMath",
   CellTags->{"ComplQuantElim5", "b:0.1.0"},
   CellID->49796222],
  Cell[75372, 2769, 1169, 44, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->221361483],
  Cell[76544, 2815, 1003, 32, 70, "DisplayMath",
   CellTags->"b:0.1.0",
   CellID->252555401],
  Cell[77550, 2849, 1058, 41, 70, "Text",
   CellTags->"b:0.1.0",
   CellID->556834848]},
 "GBProperty1"->{
  Cell[45180, 1623, 1079, 41, 70, "Text",
   CellTags->{"GBProperty1", "b:0.1.0"},
   CellID->101329384]},
 "GBProperty2"->{
  Cell[46370, 1670, 1912, 69, 70, "Text",
   CellTags->{"GBProperty2", "b:0.1.0"},
   CellID->251743588]},
 "GBProperty3"->{
  Cell[62228, 2275, 1718, 64, 70, "Text",
   CellTags->{"GBProperty3", "b:0.1.0"},
   CellID->116059195]},
 "GBProperty4"->{
  Cell[70384, 2589, 3465, 123, 70, "Text",
   CellTags->{"GBProperty4", "b:0.1.0"},
   CellID->63440976]},
 "ComplQuantElim5"->{
  Cell[74322, 2734, 1047, 33, 70, "DisplayMath",
   CellTags->{"ComplQuantElim5", "b:0.1.0"},
   CellID->49796222]},
 "b:0.1.1"->{
  Cell[78645, 2895, 151, 6, 70, "Subsection",
   CellTags->"b:0.1.1",
   CellID->358199088],
  Cell[78799, 2903, 537, 17, 70, "Text",
   CellTags->"b:0.1.1",
   CellID->38773286],
  Cell[79339, 2922, 910, 24, 70, "DefinitionBox3Col",
   CellTags->"b:0.1.1",
   CellID->219123469],
  Cell[80252, 2948, 264, 8, 70, "Caption",
   CellTags->"b:0.1.1",
   CellID->25528258],
  Cell[80541, 2960, 84, 2, 70, "Subsubsection",
   CellTags->"b:0.1.1",
   CellID->207435377],
  Cell[80628, 2964, 449, 15, 70, "Text",
   CellTags->"b:0.1.1",
   CellID->12500363],
  Cell[82531, 3033, 1165, 41, 70, "Text",
   CellTags->"b:0.1.1",
   CellID->137749525],
  Cell[83733, 3079, 73, 2, 70, "Subsubsection",
   CellTags->"b:0.1.1",
   CellID->249536440],
  Cell[83809, 3083, 1628, 47, 70, "Text",
   CellTags->"b:0.1.1",
   CellID->777232220],
  Cell[86996, 3184, 80, 2, 70, "Subsubsection",
   CellTags->"b:0.1.1",
   CellID->337648130],
  Cell[87079, 3188, 787, 27, 70, "Text",
   CellTags->"b:0.1.1",
   CellID->426805126],
  Cell[87869, 3217, 2776, 77, 70, "DefinitionBox",
   CellTags->"b:0.1.1",
   CellID->249023081],
  Cell[90648, 3296, 78, 2, 70, "Caption",
   CellTags->"b:0.1.1",
   CellID->477494064],
  Cell[90729, 3300, 434, 10, 70, "Text",
   CellTags->"b:0.1.1",
   CellID->9441429],
  Cell[91166, 3312, 1410, 48, 70, "DisplayMath",
   CellTags->"b:0.1.1",
   CellID->2799146],
  Cell[92579, 3362, 779, 28, 70, "Text",
   CellTags->"b:0.1.1",
   CellID->203628926],
  Cell[93361, 3392, 330, 11, 70, "Text",
   CellTags->"b:0.1.1",
   CellID->407136694],
  Cell[93694, 3405, 864, 26, 70, "DefinitionBox",
   CellTags->{"ElimOrder", "b:0.1.1"},
   CellID->29856636],
  Cell[94561, 3433, 116, 4, 70, "Caption",
   CellTags->"b:0.1.1",
   CellID->669910966],
  Cell[94680, 3439, 1035, 30, 70, "Text",
   CellTags->{"b:0.1.1", "GBElim"},
   CellID->664865967],
  Cell[95718, 3471, 466, 15, 70, "Program",
   CellTags->"b:0.1.1",
   CellID->16612748],
  Cell[96187, 3488, 862, 23, 70, "DefinitionBox3Col",
   CellTags->"b:0.1.1",
   CellID->81337346],
  Cell[97052, 3513, 158, 6, 70, "Caption",
   CellTags->"b:0.1.1",
   CellID->17926163],
  Cell[97213, 3521, 1149, 37, 70, "MathCaption",
   CellTags->"b:0.1.1",
   CellID->17431108],
  Cell[98387, 3562, 803, 26, 70, "Input",
   CellTags->"b:0.1.1",
   CellID->369080181],
  Cell[99193, 3590, 291, 10, 39, "Output",
   CellTags->"b:0.1.1",
   CellID->126593186],
  Cell[99499, 3603, 612, 20, 70, "MathCaption",
   CellTags->"b:0.1.1",
   CellID->328968578],
  Cell[100136, 3627, 1034, 32, 70, "Input",
   CellTags->"b:0.1.1",
   CellID->245813959],
  Cell[101173, 3661, 566, 20, 39, "Output",
   CellTags->"b:0.1.1",
   CellID->187452025],
  Cell[101754, 3684, 116, 2, 70, "MathCaption",
   CellTags->"b:0.1.1",
   CellID->577953394],
  Cell[101873, 3688, 308, 9, 70, "Input",
   CellTags->"b:0.1.1",
   CellID->174463567],
  Cell[102184, 3699, 448, 16, 70, "MathCaption",
   CellTags->"b:0.1.1",
   CellID->355570436],
  Cell[102657, 3719, 699, 23, 70, "Input",
   CellTags->"b:0.1.1",
   CellID->507576972],
  Cell[103359, 3744, 382, 13, 36, "Output",
   CellTags->"b:0.1.1",
   CellID->201531761]},
 "GBWalk"->{
  Cell[85440, 3132, 1383, 41, 70, "DefinitionBox",
   CellTags->"GBWalk",
   CellID->64503502]},
 "ElimOrder"->{
  Cell[93694, 3405, 864, 26, 70, "DefinitionBox",
   CellTags->{"ElimOrder", "b:0.1.1"},
   CellID->29856636]},
 "GBElim"->{
  Cell[94680, 3439, 1035, 30, 70, "Text",
   CellTags->{"b:0.1.1", "GBElim"},
   CellID->664865967]},
 "b:0.2"->{
  Cell[103814, 3765, 75, 2, 70, "Section",
   CellTags->"b:0.2",
   CellID->47132662],
  Cell[103892, 3769, 171, 5, 70, "Text",
   CellTags->"b:0.2",
   CellID->108914437],
  Cell[104066, 3776, 544, 19, 70, "DisplayMath",
   CellTags->"b:0.2",
   CellID->69115330],
  Cell[104613, 3797, 971, 31, 70, "Text",
   CellTags->"b:0.2",
   CellID->342414202],
  Cell[105587, 3830, 192, 5, 70, "MathCaption",
   CellTags->"b:0.2",
   CellID->240968237],
  Cell[105804, 3839, 846, 26, 70, "Input",
   CellTags->"b:0.2",
   CellID->169223809],
  Cell[106653, 3867, 181, 6, 36, "Output",
   CellTags->"b:0.2",
   CellID->43644218],
  Cell[106849, 3876, 75, 2, 70, "Text",
   CellTags->"b:0.2",
   CellID->14091805],
  Cell[106927, 3880, 1125, 35, 70, "DisplayMath",
   CellTags->"b:0.2",
   CellID->61012584],
  Cell[108055, 3917, 169, 5, 70, "Text",
   CellTags->"b:0.2",
   CellID->710124903],
  Cell[108227, 3924, 1007, 33, 70, "DisplayMath",
   CellTags->"b:0.2",
   CellID->818573573],
  Cell[109237, 3959, 236, 8, 70, "Text",
   CellTags->"b:0.2",
   CellID->133759324],
  Cell[109476, 3969, 710, 23, 70, "DisplayMath",
   CellTags->"b:0.2",
   CellID->77397878],
  Cell[110189, 3994, 81, 2, 70, "Text",
   CellTags->"b:0.2",
   CellID->77306916],
  Cell[110273, 3998, 519, 17, 70, "DisplayMath",
   CellTags->"b:0.2",
   CellID->420278043],
  Cell[110795, 4017, 113, 2, 70, "Text",
   CellTags->"b:0.2",
   CellID->149107566],
  Cell[110911, 4021, 430, 15, 70, "MathCaption",
   CellTags->"b:0.2",
   CellID->209792017],
  Cell[111366, 4040, 498, 17, 70, "Input",
   CellTags->"b:0.2",
   CellID->48625499],
  Cell[111867, 4059, 391, 15, 36, "Output",
   CellTags->"b:0.2",
   CellID->20587251],
  Cell[112273, 4077, 442, 16, 70, "MathCaption",
   CellTags->"b:0.2",
   CellID->263162280],
  Cell[112740, 4097, 534, 19, 70, "Input",
   CellTags->"b:0.2",
   CellID->115414983],
  Cell[113277, 4118, 201, 7, 36, "Output",
   CellTags->"b:0.2",
   CellID->206826770],
  Cell[113493, 4128, 1304, 40, 70, "Text",
   CellTags->"b:0.2",
   CellID->196079508]},
 "ComplexQuantifierElimination"->{
  Cell[114834, 4173, 115, 2, 70, "Section",
   CellTags->{"ComplexQuantifierElimination", "b:0.3"},
   CellID->793673109]},
 "b:0.3"->{
  Cell[114834, 4173, 115, 2, 70, "Section",
   CellTags->{"ComplexQuantifierElimination", "b:0.3"},
   CellID->793673109],
  Cell[114952, 4177, 1289, 35, 70, "Text",
   CellTags->"b:0.3",
   CellID->82738331],
  Cell[116244, 4214, 193, 5, 70, "MathCaption",
   CellTags->"b:0.3",
   CellID->149637743],
  Cell[116462, 4223, 633, 21, 70, "Input",
   CellTags->"b:0.3",
   CellID->246904907],
  Cell[117098, 4246, 592, 21, 39, "Output",
   CellTags->"b:0.3",
   CellID->55931807],
  Cell[117705, 4270, 227, 7, 70, "Text",
   CellTags->"b:0.3",
   CellID->136906628],
  Cell[117935, 4279, 1477, 46, 70, "DisplayMath",
   CellTags->"b:0.3",
   CellID->22516810],
  Cell[119415, 4327, 231, 6, 70, "Text",
   CellTags->"b:0.3",
   CellID->719618623],
  Cell[119649, 4335, 936, 30, 70, "DisplayMath",
   CellTags->{"ComplQuantElim1", "b:0.3"},
   CellID->164605557],
  Cell[120588, 4367, 301, 11, 70, "Text",
   CellTags->"b:0.3",
   CellID->341799182],
  Cell[120892, 4380, 522, 18, 70, "DisplayMath",
   CellTags->"b:0.3",
   CellID->369396772],
  Cell[121417, 4400, 304, 10, 70, "Text",
   CellTags->"b:0.3",
   CellID->448465053],
  Cell[121724, 4412, 471, 17, 70, "Text",
   CellTags->"b:0.3",
   CellID->256393426],
  Cell[122198, 4431, 2010, 67, 70, "Text",
   CellTags->"b:0.3",
   CellID->4567508],
  Cell[124211, 4500, 1199, 38, 70, "DisplayMath",
   CellTags->{"ComplQuantElim2", "b:0.3"},
   CellID->69712841],
  Cell[125413, 4540, 59, 2, 70, "Text",
   CellTags->"b:0.3",
   CellID->289069035],
  Cell[125475, 4544, 1171, 38, 70, "DisplayMath",
   CellTags->{"ComplQuantElim3", "b:0.3"},
   CellID->598413124],
  Cell[126649, 4584, 805, 24, 70, "Text",
   CellTags->"b:0.3",
   CellID->693896399],
  Cell[127457, 4610, 421, 14, 70, "Text",
   CellTags->"b:0.3",
   CellID->41916580],
  Cell[127881, 4626, 519, 17, 70, "DisplayMath",
   CellTags->"b:0.3",
   CellID->512637847],
  Cell[128403, 4645, 305, 13, 70, "Text",
   CellTags->"b:0.3",
   CellID->718534176],
  Cell[128711, 4660, 1345, 42, 70, "DisplayMath",
   CellTags->"b:0.3",
   CellID->118920921],
  Cell[130059, 4704, 502, 18, 70, "Text",
   CellTags->"b:0.3",
   CellID->405475917],
  Cell[130564, 4724, 1461, 47, 70, "DisplayMath",
   CellTags->{"ComplQuantElim4", "b:0.3"},
   CellID->5546503],
  Cell[132028, 4773, 949, 37, 70, "Text",
   CellTags->"b:0.3",
   CellID->242099882],
  Cell[132980, 4812, 784, 25, 70, "DisplayMath",
   CellTags->"b:0.3",
   CellID->228341539],
  Cell[133767, 4839, 572, 21, 70, "Text",
   CellTags->"b:0.3",
   CellID->137362455],
  Cell[134342, 4862, 529, 18, 70, "DisplayMath",
   CellTags->"b:0.3",
   CellID->137172770],
  Cell[134874, 4882, 324, 13, 70, "Text",
   CellTags->"b:0.3",
   CellID->473412355],
  Cell[135201, 4897, 1173, 36, 70, "DisplayMath",
   CellTags->"b:0.3",
   CellID->437690631],
  Cell[136377, 4935, 74, 2, 70, "Text",
   CellTags->"b:0.3",
   CellID->406555534],
  Cell[136454, 4939, 564, 19, 70, "DisplayMath",
   CellTags->"b:0.3",
   CellID->77823390],
  Cell[137021, 4960, 567, 23, 70, "Text",
   CellTags->"b:0.3",
   CellID->181178939],
  Cell[137591, 4985, 1466, 46, 70, "DisplayMath",
   CellTags->"b:0.3",
   CellID->230447882],
  Cell[139060, 5033, 3812, 137, 70, "Text",
   CellTags->"b:0.3",
   CellID->370242061],
  Cell[142875, 5172, 616, 20, 70, "DisplayMath",
   CellTags->"b:0.3",
   CellID->277121168],
  Cell[143494, 5194, 145, 5, 70, "Text",
   CellTags->"b:0.3",
   CellID->5450433],
  Cell[143642, 5201, 1958, 73, 70, "MathCaption",
   CellTags->"b:0.3",
   CellID->134957362],
  Cell[145625, 5278, 868, 27, 70, "Input",
   CellTags->"b:0.3",
   CellID->49912483],
  Cell[146496, 5307, 576, 20, 39, "Output",
   CellTags->"b:0.3",
   CellID->294171584],
  Cell[147087, 5330, 113, 2, 70, "MathCaption",
   CellTags->"b:0.3",
   CellID->56187135],
  Cell[147203, 5334, 306, 9, 70, "Input",
   CellTags->"b:0.3",
   CellID->66949442]},
 "ComplQuantElim1"->{
  Cell[119649, 4335, 936, 30, 70, "DisplayMath",
   CellTags->{"ComplQuantElim1", "b:0.3"},
   CellID->164605557]},
 "ComplQuantElim2"->{
  Cell[124211, 4500, 1199, 38, 70, "DisplayMath",
   CellTags->{"ComplQuantElim2", "b:0.3"},
   CellID->69712841]},
 "ComplQuantElim3"->{
  Cell[125475, 4544, 1171, 38, 70, "DisplayMath",
   CellTags->{"ComplQuantElim3", "b:0.3"},
   CellID->598413124]},
 "ComplQuantElim4"->{
  Cell[130564, 4724, 1461, 47, 70, "DisplayMath",
   CellTags->{"ComplQuantElim4", "b:0.3"},
   CellID->5546503]},
 "b:0.4.0"->{
  Cell[147646, 5353, 76, 2, 70, "Subsection",
   CellTags->"b:0.4.0",
   CellID->805204536],
  Cell[147725, 5357, 806, 18, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->43785031],
  Cell[148534, 5377, 542, 15, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->64894745],
  Cell[149079, 5394, 742, 24, 70, "DisplayMath",
   CellTags->{"ComplFI1", "b:0.4.0"},
   CellID->180736027],
  Cell[149824, 5420, 1714, 52, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->159181068],
  Cell[151541, 5474, 474, 14, 70, "DisplayMath",
   CellTags->"b:0.4.0",
   CellID->110151702],
  Cell[152018, 5490, 546, 17, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->312821970],
  Cell[152567, 5509, 840, 27, 70, "DisplayMath",
   CellTags->{"ComplFI2", "b:0.4.0"},
   CellID->287456835],
  Cell[153410, 5538, 3085, 104, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->369534153],
  Cell[156498, 5644, 8454, 290, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->76539571],
  Cell[164955, 5936, 4175, 138, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->112816986],
  Cell[169133, 6076, 569, 20, 70, "DisplayMath",
   CellTags->"b:0.4.0",
   CellID->70817737],
  Cell[169705, 6098, 4295, 153, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->752227],
  Cell[174003, 6253, 1530, 58, 70, "MathCaption",
   CellTags->"b:0.4.0",
   CellID->490482397],
  Cell[175558, 6315, 908, 32, 70, "Input",
   CellTags->"b:0.4.0",
   CellID->74406493],
  Cell[176469, 6349, 841, 29, 39, "Output",
   CellTags->"b:0.4.0",
   CellID->78656386],
  Cell[177325, 6381, 683, 26, 70, "MathCaption",
   CellTags->"b:0.4.0",
   CellID->390674739],
  Cell[178033, 6411, 1088, 36, 70, "Input",
   CellTags->"b:0.4.0",
   CellID->126211027],
  Cell[179124, 6449, 402, 15, 39, "Output",
   CellTags->"b:0.4.0",
   CellID->431461227]},
 "ComplFI1"->{
  Cell[149079, 5394, 742, 24, 70, "DisplayMath",
   CellTags->{"ComplFI1", "b:0.4.0"},
   CellID->180736027]},
 "ComplFI2"->{
  Cell[152567, 5509, 840, 27, 70, "DisplayMath",
   CellTags->{"ComplFI2", "b:0.4.0"},
   CellID->287456835]},
 "b:0.4.1"->{
  Cell[179575, 6470, 69, 2, 70, "Subsection",
   CellTags->"b:0.4.1",
   CellID->47730150],
  Cell[179647, 6474, 803, 20, 70, "Text",
   CellTags->"b:0.4.1",
   CellID->4413481],
  Cell[180453, 6496, 846, 27, 70, "DisplayMath",
   CellTags->{"ComplQFReduce1", "b:0.4.1"},
   CellID->147136247],
  Cell[181302, 6525, 3751, 130, 70, "Text",
   CellTags->"b:0.4.1",
   CellID->42891942],
  Cell[185056, 6657, 1572, 51, 70, "DisplayMath",
   CellTags->{"ComplQFReduce2", "b:0.4.1"},
   CellID->12234468],
  Cell[186631, 6710, 1140, 36, 70, "Text",
   CellTags->"b:0.4.1",
   CellID->383312115],
  Cell[187774, 6748, 1375, 47, 70, "DisplayMath",
   CellTags->"b:0.4.1",
   CellID->437745],
  Cell[189152, 6797, 1377, 45, 70, "Text",
   CellTags->"b:0.4.1",
   CellID->375870]},
 "ComplQFReduce1"->{
  Cell[180453, 6496, 846, 27, 70, "DisplayMath",
   CellTags->{"ComplQFReduce1", "b:0.4.1"},
   CellID->147136247]},
 "ComplQFReduce2"->{
  Cell[185056, 6657, 1572, 51, 70, "DisplayMath",
   CellTags->{"ComplQFReduce2", "b:0.4.1"},
   CellID->12234468]},
 "b:0.5.0"->{
  Cell[190649, 6853, 109, 2, 70, "Subsection",
   CellTags->"b:0.5.0",
   CellID->804567386],
  Cell[190761, 6857, 291, 9, 70, "Text",
   CellTags->"b:0.5.0",
   CellID->110467185],
  Cell[191055, 6868, 1469, 43, 70, "DefinitionBox3Col",
   CellTags->"b:0.5.0",
   CellID->532547471],
  Cell[192527, 6913, 388, 14, 70, "Caption",
   CellTags->"b:0.5.0",
   CellID->135821432],
  Cell[192918, 6929, 817, 22, 70, "DefinitionBox3Col",
   CellTags->"b:0.5.0",
   CellID->230187574],
  Cell[193738, 6953, 523, 19, 70, "Caption",
   CellTags->"b:0.5.0",
   CellID->134658611],
  Cell[194286, 6976, 83, 2, 70, "Subsubsection",
   CellTags->"b:0.5.0",
   CellID->534299437],
  Cell[194372, 6980, 343, 10, 70, "MathCaption",
   CellTags->"b:0.5.0",
   CellID->49107805],
  Cell[194740, 6994, 458, 16, 70, "Input",
   CellTags->"b:0.5.0",
   CellID->47693454],
  Cell[195201, 7012, 1657, 56, 89, "Output",
   CellTags->"b:0.5.0",
   CellID->120362649],
  Cell[196873, 7071, 456, 16, 70, "MathCaption",
   CellTags->"b:0.5.0",
   CellID->562047429],
  Cell[197354, 7091, 513, 17, 30, "Input",
   CellTags->"b:0.5.0",
   CellID->91622],
  Cell[197870, 7110, 4298, 75, 469, "Output",
   Evaluatable->False,
   CellTags->"b:0.5.0",
   CellID->675005616],
  Cell[202217, 7191, 86, 2, 70, "Subsubsection",
   CellTags->"b:0.5.0",
   CellID->916560033],
  Cell[202306, 7195, 276, 9, 70, "MathCaption",
   CellTags->"b:0.5.0",
   CellID->22995033],
  Cell[202607, 7208, 275, 10, 70, "Input",
   CellTags->"b:0.5.0",
   CellID->220100868],
  Cell[202885, 7220, 828, 28, 39, "Output",
   CellTags->"b:0.5.0",
   CellID->727821508],
  Cell[203728, 7251, 658, 24, 70, "MathCaption",
   CellTags->"b:0.5.0",
   CellID->156420963],
  Cell[204411, 7279, 328, 11, 70, "Input",
   CellTags->"b:0.5.0",
   CellID->58867455],
  Cell[204742, 7292, 2357, 86, 153, "Output",
   CellTags->"b:0.5.0",
   CellID->350610691],
  Cell[207148, 7384, 83, 2, 70, "Subsubsection",
   CellTags->"b:0.5.0",
   CellID->869227976],
  Cell[207234, 7388, 417, 14, 70, "MathCaption",
   CellTags->"b:0.5.0",
   CellID->162562523],
  Cell[207676, 7406, 337, 11, 70, "Input",
   CellTags->"b:0.5.0",
   CellID->318749219],
  Cell[208016, 7419, 772, 23, 54, "Output",
   CellTags->"b:0.5.0",
   CellID->43878235]},
 "b:0.5.1"->{
  Cell[208849, 7449, 105, 2, 70, "Subsection",
   CellTags->"b:0.5.1",
   CellID->167657003],
  Cell[208957, 7453, 646, 21, 70, "Text",
   CellTags->"b:0.5.1",
   CellID->218482819],
  Cell[209606, 7476, 478, 16, 70, "Program",
   CellTags->"b:0.5.1",
   CellID->422400505],
  Cell[210087, 7494, 281, 11, 70, "MathCaption",
   CellTags->"b:0.5.1",
   CellID->133051656],
  Cell[210371, 7507, 290, 9, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->346370944],
  Cell[210664, 7518, 163, 6, 70, "MathCaption",
   CellTags->"b:0.5.1",
   CellID->6683350],
  Cell[210852, 7528, 244, 7, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->38559548],
  Cell[211099, 7537, 184, 6, 36, "Output",
   CellTags->"b:0.5.1",
   CellID->352979638],
  Cell[211298, 7546, 306, 11, 70, "MathCaption",
   CellTags->"b:0.5.1",
   CellID->290204304],
  Cell[211607, 7559, 292, 9, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->563530338],
  Cell[211902, 7570, 1251, 36, 70, "DefinitionBox3Col",
   CellTags->"b:0.5.1",
   CellID->138207434],
  Cell[213156, 7608, 583, 20, 70, "Caption",
   CellTags->"b:0.5.1",
   CellID->308678426],
  Cell[213764, 7632, 84, 2, 70, "Subsubsection",
   CellTags->"b:0.5.1",
   CellID->379056828],
  Cell[213851, 7636, 1013, 35, 70, "MathCaption",
   CellTags->"b:0.5.1",
   CellID->162655316],
  Cell[214889, 7675, 1601, 52, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->84186630],
  Cell[216493, 7729, 233, 8, 36, "Output",
   CellTags->"b:0.5.1",
   CellID->97328426],
  Cell[216741, 7740, 695, 25, 70, "MathCaption",
   CellTags->"b:0.5.1",
   CellID->723830391],
  Cell[217461, 7769, 738, 23, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->43750448],
  Cell[218202, 7794, 248, 8, 36, "Output",
   CellTags->"b:0.5.1",
   CellID->648262201],
  Cell[218465, 7805, 622, 16, 70, "MathCaption",
   CellTags->"b:0.5.1",
   CellID->102977779],
  Cell[219112, 7825, 218, 8, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->97069423],
  Cell[219333, 7835, 264, 9, 36, "Output",
   CellTags->"b:0.5.1",
   CellID->829969076],
  Cell[219612, 7847, 126, 3, 70, "MathCaption",
   CellTags->"b:0.5.1",
   CellID->42314769],
  Cell[219763, 7854, 547, 18, 28, "Input",
   CellTags->"b:0.5.1",
   CellID->190539109],
  Cell[220313, 7874, 2342, 43, 248, "Output",
   Evaluatable->False,
   CellTags->"b:0.5.1",
   CellID->188859369],
  Cell[222670, 7920, 291, 9, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->52362266],
  Cell[222998, 7934, 82, 2, 70, "Subsubsection",
   CellTags->"b:0.5.1",
   CellID->98929011],
  Cell[223083, 7938, 421, 11, 70, "MathCaption",
   CellTags->"b:0.5.1",
   CellID->635299211],
  Cell[223529, 7953, 478, 16, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->587657385],
  Cell[224010, 7971, 2754, 85, 145, "Output",
   CellTags->"b:0.5.1",
   CellID->35083699],
  Cell[226779, 8059, 467, 15, 70, "MathCaption",
   CellTags->"b:0.5.1",
   CellID->282795960],
  Cell[227271, 8078, 692, 22, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->188790613],
  Cell[227966, 8102, 483, 17, 36, "Output",
   CellTags->"b:0.5.1",
   CellID->113313394],
  Cell[228464, 8122, 289, 9, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->24410703]},
 "t:29"->{
  Cell[228814, 8138, 122, 3, 70, "Section",
   CellTags->{"t:29", "c:29", "b:0.6"},
   CellID->89793884]},
 "c:29"->{
  Cell[228814, 8138, 122, 3, 70, "Section",
   CellTags->{"t:29", "c:29", "b:0.6"},
   CellID->89793884]},
 "b:0.6"->{
  Cell[228814, 8138, 122, 3, 70, "Section",
   CellTags->{"t:29", "c:29", "b:0.6"},
   CellID->89793884],
  Cell[228939, 8143, 223, 7, 70, "DisplayMath",
   CellTags->{"BW", "b:0.6"},
   CellID->174911420],
  Cell[229165, 8152, 235, 7, 70, "DisplayMath",
   CellTags->{"CLS", "b:0.6"},
   CellID->543617109],
  Cell[229403, 8161, 238, 7, 70, "DisplayMath",
   CellTags->{"L", "b:0.6"},
   CellID->551706795]},
 "BW"->{
  Cell[228939, 8143, 223, 7, 70, "DisplayMath",
   CellTags->{"BW", "b:0.6"},
   CellID->174911420]},
 "CLS"->{
  Cell[229165, 8152, 235, 7, 70, "DisplayMath",
   CellTags->{"CLS", "b:0.6"},
   CellID->543617109]},
 "L"->{
  Cell[229403, 8161, 238, 7, 70, "DisplayMath",
   CellTags->{"L", "b:0.6"},
   CellID->551706795]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:3", 233860, 8290},
 {"c:3", 233971, 8294},
 {"b:0.0", 234084, 8298},
 {"Complex1", 237294, 8407},
 {"PNF", 237410, 8411},
 {"DNF", 237522, 8415},
 {"GeneralComplexSolution", 237653, 8419},
 {"GroebnerBasis", 237795, 8423},
 {"b:0.1.0", 237904, 8427},
 {"GBProperty1", 241053, 8530},
 {"GBProperty2", 241178, 8534},
 {"GBProperty3", 241303, 8538},
 {"GBProperty4", 241428, 8542},
 {"ComplQuantElim5", 241557, 8546},
 {"b:0.1.1", 241688, 8550},
 {"GBWalk", 244846, 8653},
 {"ElimOrder", 244959, 8657},
 {"GBElim", 245084, 8661},
 {"b:0.2", 245198, 8665},
 {"ComplexQuantifierElimination", 247284, 8735},
 {"b:0.3", 247420, 8739},
 {"ComplQuantElim1", 251330, 8866},
 {"ComplQuantElim2", 251468, 8870},
 {"ComplQuantElim3", 251606, 8874},
 {"ComplQuantElim4", 251745, 8878},
 {"b:0.4.0", 251874, 8882},
 {"ComplFI1", 253663, 8940},
 {"ComplFI2", 253789, 8944},
 {"b:0.4.1", 253914, 8948},
 {"ComplQFReduce1", 254708, 8973},
 {"ComplQFReduce2", 254846, 8977},
 {"b:0.5.0", 254977, 8981},
 {"b:0.5.1", 257254, 9055},
 {"t:29", 260424, 9159},
 {"c:29", 260542, 9163},
 {"b:0.6", 260661, 9167},
 {"BW", 261080, 9180},
 {"CLS", 261192, 9184},
 {"L", 261303, 9188}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3631, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4256, 105, 61, 1, 70, "Title",
 CellID->7121304],
Cell[CellGroupData[{
Cell[4342, 110, 86, 2, 70, "Section",
 CellTags->{"t:3", "c:3", "b:0.0"},
 CellID->73712623],
Cell[4431, 114, 1144, 30, 70, "Text",
 CellTags->"b:0.0",
 CellID->142044117],
Cell[5578, 146, 163, 5, 70, "Text",
 CellTags->"b:0.0",
 CellID->60612736],
Cell[5744, 153, 763, 23, 70, "DisplayMath",
 CellTags->"b:0.0",
 CellID->646880285],
Cell[6510, 178, 104, 2, 70, "Text",
 CellTags->"b:0.0",
 CellID->9470698],
Cell[6617, 182, 719, 21, 70, "DisplayMath",
 CellTags->"b:0.0",
 CellID->92176511],
Cell[7339, 205, 980, 37, 70, "Text",
 CellTags->"b:0.0",
 CellID->321261601],
Cell[8322, 244, 355, 13, 70, "Text",
 CellTags->"b:0.0",
 CellID->9009455],
Cell[8680, 259, 837, 29, 70, "DisplayMath",
 CellTags->{"Complex1", "b:0.0"},
 CellID->403973843],
Cell[9520, 290, 584, 23, 70, "Text",
 CellTags->"b:0.0",
 CellID->107843165],
Cell[10107, 315, 137, 4, 70, "Text",
 CellTags->"b:0.0",
 CellID->14769913],
Cell[10247, 321, 684, 23, 70, "DisplayMath",
 CellTags->{"PNF", "b:0.0"},
 CellID->545791106],
Cell[10934, 346, 688, 24, 70, "Text",
 CellTags->"b:0.0",
 CellID->337844267],
Cell[11625, 372, 161, 5, 70, "Text",
 CellTags->"b:0.0",
 CellID->928012757],
Cell[11789, 379, 691, 21, 70, "DisplayMath",
 CellTags->{"DNF", "b:0.0"},
 CellID->348193030],
Cell[12483, 402, 250, 9, 70, "Text",
 CellTags->"b:0.0",
 CellID->112672566],
Cell[12736, 413, 656, 20, 70, "Text",
 CellTags->"b:0.0",
 CellID->336911978],
Cell[13395, 435, 483, 15, 70, "DisplayMath",
 CellTags->"b:0.0",
 CellID->602828466],
Cell[13881, 452, 183, 5, 70, "Text",
 CellTags->"b:0.0",
 CellID->443188525],
Cell[14067, 459, 479, 15, 70, "Text",
 CellTags->"b:0.0",
 CellID->332287509],
Cell[14549, 476, 1802, 58, 70, "DisplayMath",
 CellTags->{"GeneralComplexSolution", "b:0.0"},
 CellID->136556618],
Cell[16354, 536, 1630, 54, 70, "Text",
 CellTags->"b:0.0",
 CellID->8410713],
Cell[17987, 592, 178, 8, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->237750176],
Cell[CellGroupData[{
Cell[18190, 604, 830, 28, 70, "Input",
 CellTags->"b:0.0",
 CellID->122593157],
Cell[19023, 634, 1713, 59, 98, "Output",
 CellTags->"b:0.0",
 CellID->390816834]
}, Open  ]],
Cell[20751, 696, 335, 9, 70, "Text",
 CellTags->"b:0.0",
 CellID->340462317],
Cell[21089, 707, 472, 15, 70, "DisplayMath",
 CellTags->"b:0.0",
 CellID->273437329],
Cell[21564, 724, 597, 22, 70, "Text",
 CellTags->"b:0.0",
 CellID->139558513],
Cell[22164, 748, 199, 8, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->609600025],
Cell[CellGroupData[{
Cell[22388, 760, 727, 25, 70, "Input",
 CellTags->"b:0.0",
 CellID->27783491],
Cell[23118, 787, 1593, 54, 75, "Output",
 CellTags->"b:0.0",
 CellID->937920616]
}, Open  ]],
Cell[24726, 844, 719, 15, 70, "Text",
 CellTags->"b:0.0",
 CellID->74100314],
Cell[25448, 861, 192, 8, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->135036826],
Cell[CellGroupData[{
Cell[25665, 873, 835, 28, 70, "Input",
 CellTags->"b:0.0",
 CellID->27486418],
Cell[26503, 903, 351, 12, 36, "Output",
 CellTags->"b:0.0",
 CellID->195779055]
}, Open  ]],
Cell[26869, 918, 472, 17, 70, "Text",
 CellTags->"b:0.0",
 CellID->27312213]
}, Open  ]],
Cell[CellGroupData[{
Cell[27378, 940, 92, 2, 70, "Section",
 CellTags->"GroebnerBasis",
 CellID->138375135],
Cell[CellGroupData[{
Cell[27495, 946, 70, 2, 70, "Subsection",
 CellTags->"b:0.1.0",
 CellID->143442327],
Cell[27568, 950, 856, 30, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->45515852],
Cell[28427, 982, 668, 26, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->809364157],
Cell[29098, 1010, 1530, 58, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->95853517],
Cell[30631, 1070, 2279, 84, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->350947462],
Cell[32913, 1156, 451, 23, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->102932712],
Cell[33367, 1181, 1955, 73, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->115687632],
Cell[35325, 1256, 1376, 52, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->469904506],
Cell[36704, 1310, 1707, 65, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->359221891],
Cell[38414, 1377, 621, 22, 70, "DisplayMath",
 CellTags->"b:0.1.0",
 CellID->243375792],
Cell[39038, 1401, 1220, 51, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->717872190],
Cell[40261, 1454, 3163, 107, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->74043315],
Cell[43427, 1563, 791, 30, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->16067485],
Cell[44221, 1595, 956, 26, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->40516630],
Cell[45180, 1623, 1079, 41, 70, "Text",
 CellTags->{"GBProperty1", "b:0.1.0"},
 CellID->101329384],
Cell[46262, 1666, 105, 2, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->76039018],
Cell[46370, 1670, 1912, 69, 70, "Text",
 CellTags->{"GBProperty2", "b:0.1.0"},
 CellID->251743588],
Cell[48285, 1741, 8341, 314, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->7064830],
Cell[56629, 2057, 743, 28, 70, "DisplayMath",
 CellTags->"b:0.1.0",
 CellID->43249874],
Cell[57375, 2087, 4850, 186, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->267330306],
Cell[62228, 2275, 1718, 64, 70, "Text",
 CellTags->{"GBProperty3", "b:0.1.0"},
 CellID->116059195],
Cell[63949, 2341, 436, 17, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->81054669],
Cell[64388, 2360, 138, 7, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->372338942],
Cell[64529, 2369, 728, 27, 70, "DisplayMath",
 CellTags->"b:0.1.0",
 CellID->64785049],
Cell[65260, 2398, 1882, 66, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->188019864],
Cell[67145, 2466, 777, 27, 70, "DisplayMath",
 CellTags->"b:0.1.0",
 CellID->306918598],
Cell[67925, 2495, 2295, 85, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->133913109],
Cell[70223, 2582, 158, 5, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->625037811],
Cell[70384, 2589, 3465, 123, 70, "Text",
 CellTags->{"GBProperty4", "b:0.1.0"},
 CellID->63440976],
Cell[73852, 2714, 467, 18, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->63896074],
Cell[74322, 2734, 1047, 33, 70, "DisplayMath",
 CellTags->{"ComplQuantElim5", "b:0.1.0"},
 CellID->49796222],
Cell[75372, 2769, 1169, 44, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->221361483],
Cell[76544, 2815, 1003, 32, 70, "DisplayMath",
 CellTags->"b:0.1.0",
 CellID->252555401],
Cell[77550, 2849, 1058, 41, 70, "Text",
 CellTags->"b:0.1.0",
 CellID->556834848]
}, Open  ]],
Cell[CellGroupData[{
Cell[78645, 2895, 151, 6, 70, "Subsection",
 CellTags->"b:0.1.1",
 CellID->358199088],
Cell[78799, 2903, 537, 17, 70, "Text",
 CellTags->"b:0.1.1",
 CellID->38773286],
Cell[79339, 2922, 910, 24, 70, "DefinitionBox3Col",
 CellTags->"b:0.1.1",
 CellID->219123469],
Cell[80252, 2948, 264, 8, 70, "Caption",
 CellTags->"b:0.1.1",
 CellID->25528258],
Cell[CellGroupData[{
Cell[80541, 2960, 84, 2, 70, "Subsubsection",
 CellTags->"b:0.1.1",
 CellID->207435377],
Cell[80628, 2964, 449, 15, 70, "Text",
 CellTags->"b:0.1.1",
 CellID->12500363],
Cell[81080, 2981, 1308, 43, 70, "DefinitionBox",
 CellID->48038517],
Cell[82391, 3026, 137, 5, 70, "Caption",
 CellID->545849752],
Cell[82531, 3033, 1165, 41, 70, "Text",
 CellTags->"b:0.1.1",
 CellID->137749525]
}, Open  ]],
Cell[CellGroupData[{
Cell[83733, 3079, 73, 2, 70, "Subsubsection",
 CellTags->"b:0.1.1",
 CellID->249536440],
Cell[83809, 3083, 1628, 47, 70, "Text",
 CellTags->"b:0.1.1",
 CellID->777232220],
Cell[85440, 3132, 1383, 41, 70, "DefinitionBox",
 CellTags->"GBWalk",
 CellID->64503502],
Cell[86826, 3175, 133, 4, 70, "Caption",
 CellID->520967710]
}, Open  ]],
Cell[CellGroupData[{
Cell[86996, 3184, 80, 2, 70, "Subsubsection",
 CellTags->"b:0.1.1",
 CellID->337648130],
Cell[87079, 3188, 787, 27, 70, "Text",
 CellTags->"b:0.1.1",
 CellID->426805126],
Cell[87869, 3217, 2776, 77, 70, "DefinitionBox",
 CellTags->"b:0.1.1",
 CellID->249023081],
Cell[90648, 3296, 78, 2, 70, "Caption",
 CellTags->"b:0.1.1",
 CellID->477494064],
Cell[90729, 3300, 434, 10, 70, "Text",
 CellTags->"b:0.1.1",
 CellID->9441429],
Cell[91166, 3312, 1410, 48, 70, "DisplayMath",
 CellTags->"b:0.1.1",
 CellID->2799146],
Cell[92579, 3362, 779, 28, 70, "Text",
 CellTags->"b:0.1.1",
 CellID->203628926],
Cell[93361, 3392, 330, 11, 70, "Text",
 CellTags->"b:0.1.1",
 CellID->407136694],
Cell[93694, 3405, 864, 26, 70, "DefinitionBox",
 CellTags->{"ElimOrder", "b:0.1.1"},
 CellID->29856636],
Cell[94561, 3433, 116, 4, 70, "Caption",
 CellTags->"b:0.1.1",
 CellID->669910966],
Cell[94680, 3439, 1035, 30, 70, "Text",
 CellTags->{"b:0.1.1", "GBElim"},
 CellID->664865967],
Cell[95718, 3471, 466, 15, 70, "Program",
 CellTags->"b:0.1.1",
 CellID->16612748],
Cell[96187, 3488, 862, 23, 70, "DefinitionBox3Col",
 CellTags->"b:0.1.1",
 CellID->81337346],
Cell[97052, 3513, 158, 6, 70, "Caption",
 CellTags->"b:0.1.1",
 CellID->17926163],
Cell[97213, 3521, 1149, 37, 70, "MathCaption",
 CellTags->"b:0.1.1",
 CellID->17431108],
Cell[CellGroupData[{
Cell[98387, 3562, 803, 26, 70, "Input",
 CellTags->"b:0.1.1",
 CellID->369080181],
Cell[99193, 3590, 291, 10, 39, "Output",
 CellTags->"b:0.1.1",
 CellID->126593186]
}, Open  ]],
Cell[99499, 3603, 612, 20, 70, "MathCaption",
 CellTags->"b:0.1.1",
 CellID->328968578],
Cell[CellGroupData[{
Cell[100136, 3627, 1034, 32, 70, "Input",
 CellTags->"b:0.1.1",
 CellID->245813959],
Cell[101173, 3661, 566, 20, 39, "Output",
 CellTags->"b:0.1.1",
 CellID->187452025]
}, Open  ]],
Cell[101754, 3684, 116, 2, 70, "MathCaption",
 CellTags->"b:0.1.1",
 CellID->577953394],
Cell[101873, 3688, 308, 9, 70, "Input",
 CellTags->"b:0.1.1",
 CellID->174463567],
Cell[102184, 3699, 448, 16, 70, "MathCaption",
 CellTags->"b:0.1.1",
 CellID->355570436],
Cell[CellGroupData[{
Cell[102657, 3719, 699, 23, 70, "Input",
 CellTags->"b:0.1.1",
 CellID->507576972],
Cell[103359, 3744, 382, 13, 36, "Output",
 CellTags->"b:0.1.1",
 CellID->201531761]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[103814, 3765, 75, 2, 70, "Section",
 CellTags->"b:0.2",
 CellID->47132662],
Cell[103892, 3769, 171, 5, 70, "Text",
 CellTags->"b:0.2",
 CellID->108914437],
Cell[104066, 3776, 544, 19, 70, "DisplayMath",
 CellTags->"b:0.2",
 CellID->69115330],
Cell[104613, 3797, 971, 31, 70, "Text",
 CellTags->"b:0.2",
 CellID->342414202],
Cell[105587, 3830, 192, 5, 70, "MathCaption",
 CellTags->"b:0.2",
 CellID->240968237],
Cell[CellGroupData[{
Cell[105804, 3839, 846, 26, 70, "Input",
 CellTags->"b:0.2",
 CellID->169223809],
Cell[106653, 3867, 181, 6, 36, "Output",
 CellTags->"b:0.2",
 CellID->43644218]
}, Open  ]],
Cell[106849, 3876, 75, 2, 70, "Text",
 CellTags->"b:0.2",
 CellID->14091805],
Cell[106927, 3880, 1125, 35, 70, "DisplayMath",
 CellTags->"b:0.2",
 CellID->61012584],
Cell[108055, 3917, 169, 5, 70, "Text",
 CellTags->"b:0.2",
 CellID->710124903],
Cell[108227, 3924, 1007, 33, 70, "DisplayMath",
 CellTags->"b:0.2",
 CellID->818573573],
Cell[109237, 3959, 236, 8, 70, "Text",
 CellTags->"b:0.2",
 CellID->133759324],
Cell[109476, 3969, 710, 23, 70, "DisplayMath",
 CellTags->"b:0.2",
 CellID->77397878],
Cell[110189, 3994, 81, 2, 70, "Text",
 CellTags->"b:0.2",
 CellID->77306916],
Cell[110273, 3998, 519, 17, 70, "DisplayMath",
 CellTags->"b:0.2",
 CellID->420278043],
Cell[110795, 4017, 113, 2, 70, "Text",
 CellTags->"b:0.2",
 CellID->149107566],
Cell[110911, 4021, 430, 15, 70, "MathCaption",
 CellTags->"b:0.2",
 CellID->209792017],
Cell[CellGroupData[{
Cell[111366, 4040, 498, 17, 70, "Input",
 CellTags->"b:0.2",
 CellID->48625499],
Cell[111867, 4059, 391, 15, 36, "Output",
 CellTags->"b:0.2",
 CellID->20587251]
}, Open  ]],
Cell[112273, 4077, 442, 16, 70, "MathCaption",
 CellTags->"b:0.2",
 CellID->263162280],
Cell[CellGroupData[{
Cell[112740, 4097, 534, 19, 70, "Input",
 CellTags->"b:0.2",
 CellID->115414983],
Cell[113277, 4118, 201, 7, 36, "Output",
 CellTags->"b:0.2",
 CellID->206826770]
}, Open  ]],
Cell[113493, 4128, 1304, 40, 70, "Text",
 CellTags->"b:0.2",
 CellID->196079508]
}, Open  ]],
Cell[CellGroupData[{
Cell[114834, 4173, 115, 2, 70, "Section",
 CellTags->{"ComplexQuantifierElimination", "b:0.3"},
 CellID->793673109],
Cell[114952, 4177, 1289, 35, 70, "Text",
 CellTags->"b:0.3",
 CellID->82738331],
Cell[116244, 4214, 193, 5, 70, "MathCaption",
 CellTags->"b:0.3",
 CellID->149637743],
Cell[CellGroupData[{
Cell[116462, 4223, 633, 21, 70, "Input",
 CellTags->"b:0.3",
 CellID->246904907],
Cell[117098, 4246, 592, 21, 39, "Output",
 CellTags->"b:0.3",
 CellID->55931807]
}, Open  ]],
Cell[117705, 4270, 227, 7, 70, "Text",
 CellTags->"b:0.3",
 CellID->136906628],
Cell[117935, 4279, 1477, 46, 70, "DisplayMath",
 CellTags->"b:0.3",
 CellID->22516810],
Cell[119415, 4327, 231, 6, 70, "Text",
 CellTags->"b:0.3",
 CellID->719618623],
Cell[119649, 4335, 936, 30, 70, "DisplayMath",
 CellTags->{"ComplQuantElim1", "b:0.3"},
 CellID->164605557],
Cell[120588, 4367, 301, 11, 70, "Text",
 CellTags->"b:0.3",
 CellID->341799182],
Cell[120892, 4380, 522, 18, 70, "DisplayMath",
 CellTags->"b:0.3",
 CellID->369396772],
Cell[121417, 4400, 304, 10, 70, "Text",
 CellTags->"b:0.3",
 CellID->448465053],
Cell[121724, 4412, 471, 17, 70, "Text",
 CellTags->"b:0.3",
 CellID->256393426],
Cell[122198, 4431, 2010, 67, 70, "Text",
 CellTags->"b:0.3",
 CellID->4567508],
Cell[124211, 4500, 1199, 38, 70, "DisplayMath",
 CellTags->{"ComplQuantElim2", "b:0.3"},
 CellID->69712841],
Cell[125413, 4540, 59, 2, 70, "Text",
 CellTags->"b:0.3",
 CellID->289069035],
Cell[125475, 4544, 1171, 38, 70, "DisplayMath",
 CellTags->{"ComplQuantElim3", "b:0.3"},
 CellID->598413124],
Cell[126649, 4584, 805, 24, 70, "Text",
 CellTags->"b:0.3",
 CellID->693896399],
Cell[127457, 4610, 421, 14, 70, "Text",
 CellTags->"b:0.3",
 CellID->41916580],
Cell[127881, 4626, 519, 17, 70, "DisplayMath",
 CellTags->"b:0.3",
 CellID->512637847],
Cell[128403, 4645, 305, 13, 70, "Text",
 CellTags->"b:0.3",
 CellID->718534176],
Cell[128711, 4660, 1345, 42, 70, "DisplayMath",
 CellTags->"b:0.3",
 CellID->118920921],
Cell[130059, 4704, 502, 18, 70, "Text",
 CellTags->"b:0.3",
 CellID->405475917],
Cell[130564, 4724, 1461, 47, 70, "DisplayMath",
 CellTags->{"ComplQuantElim4", "b:0.3"},
 CellID->5546503],
Cell[132028, 4773, 949, 37, 70, "Text",
 CellTags->"b:0.3",
 CellID->242099882],
Cell[132980, 4812, 784, 25, 70, "DisplayMath",
 CellTags->"b:0.3",
 CellID->228341539],
Cell[133767, 4839, 572, 21, 70, "Text",
 CellTags->"b:0.3",
 CellID->137362455],
Cell[134342, 4862, 529, 18, 70, "DisplayMath",
 CellTags->"b:0.3",
 CellID->137172770],
Cell[134874, 4882, 324, 13, 70, "Text",
 CellTags->"b:0.3",
 CellID->473412355],
Cell[135201, 4897, 1173, 36, 70, "DisplayMath",
 CellTags->"b:0.3",
 CellID->437690631],
Cell[136377, 4935, 74, 2, 70, "Text",
 CellTags->"b:0.3",
 CellID->406555534],
Cell[136454, 4939, 564, 19, 70, "DisplayMath",
 CellTags->"b:0.3",
 CellID->77823390],
Cell[137021, 4960, 567, 23, 70, "Text",
 CellTags->"b:0.3",
 CellID->181178939],
Cell[137591, 4985, 1466, 46, 70, "DisplayMath",
 CellTags->"b:0.3",
 CellID->230447882],
Cell[139060, 5033, 3812, 137, 70, "Text",
 CellTags->"b:0.3",
 CellID->370242061],
Cell[142875, 5172, 616, 20, 70, "DisplayMath",
 CellTags->"b:0.3",
 CellID->277121168],
Cell[143494, 5194, 145, 5, 70, "Text",
 CellTags->"b:0.3",
 CellID->5450433],
Cell[143642, 5201, 1958, 73, 70, "MathCaption",
 CellTags->"b:0.3",
 CellID->134957362],
Cell[CellGroupData[{
Cell[145625, 5278, 868, 27, 70, "Input",
 CellTags->"b:0.3",
 CellID->49912483],
Cell[146496, 5307, 576, 20, 39, "Output",
 CellTags->"b:0.3",
 CellID->294171584]
}, Open  ]],
Cell[147087, 5330, 113, 2, 70, "MathCaption",
 CellTags->"b:0.3",
 CellID->56187135],
Cell[147203, 5334, 306, 9, 70, "Input",
 CellTags->"b:0.3",
 CellID->66949442]
}, Open  ]],
Cell[CellGroupData[{
Cell[147546, 5348, 75, 1, 70, "Section",
 CellID->934984887],
Cell[CellGroupData[{
Cell[147646, 5353, 76, 2, 70, "Subsection",
 CellTags->"b:0.4.0",
 CellID->805204536],
Cell[147725, 5357, 806, 18, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->43785031],
Cell[148534, 5377, 542, 15, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->64894745],
Cell[149079, 5394, 742, 24, 70, "DisplayMath",
 CellTags->{"ComplFI1", "b:0.4.0"},
 CellID->180736027],
Cell[149824, 5420, 1714, 52, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->159181068],
Cell[151541, 5474, 474, 14, 70, "DisplayMath",
 CellTags->"b:0.4.0",
 CellID->110151702],
Cell[152018, 5490, 546, 17, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->312821970],
Cell[152567, 5509, 840, 27, 70, "DisplayMath",
 CellTags->{"ComplFI2", "b:0.4.0"},
 CellID->287456835],
Cell[153410, 5538, 3085, 104, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->369534153],
Cell[156498, 5644, 8454, 290, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->76539571],
Cell[164955, 5936, 4175, 138, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->112816986],
Cell[169133, 6076, 569, 20, 70, "DisplayMath",
 CellTags->"b:0.4.0",
 CellID->70817737],
Cell[169705, 6098, 4295, 153, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->752227],
Cell[174003, 6253, 1530, 58, 70, "MathCaption",
 CellTags->"b:0.4.0",
 CellID->490482397],
Cell[CellGroupData[{
Cell[175558, 6315, 908, 32, 70, "Input",
 CellTags->"b:0.4.0",
 CellID->74406493],
Cell[176469, 6349, 841, 29, 39, "Output",
 CellTags->"b:0.4.0",
 CellID->78656386]
}, Open  ]],
Cell[177325, 6381, 683, 26, 70, "MathCaption",
 CellTags->"b:0.4.0",
 CellID->390674739],
Cell[CellGroupData[{
Cell[178033, 6411, 1088, 36, 70, "Input",
 CellTags->"b:0.4.0",
 CellID->126211027],
Cell[179124, 6449, 402, 15, 39, "Output",
 CellTags->"b:0.4.0",
 CellID->431461227]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[179575, 6470, 69, 2, 70, "Subsection",
 CellTags->"b:0.4.1",
 CellID->47730150],
Cell[179647, 6474, 803, 20, 70, "Text",
 CellTags->"b:0.4.1",
 CellID->4413481],
Cell[180453, 6496, 846, 27, 70, "DisplayMath",
 CellTags->{"ComplQFReduce1", "b:0.4.1"},
 CellID->147136247],
Cell[181302, 6525, 3751, 130, 70, "Text",
 CellTags->"b:0.4.1",
 CellID->42891942],
Cell[185056, 6657, 1572, 51, 70, "DisplayMath",
 CellTags->{"ComplQFReduce2", "b:0.4.1"},
 CellID->12234468],
Cell[186631, 6710, 1140, 36, 70, "Text",
 CellTags->"b:0.4.1",
 CellID->383312115],
Cell[187774, 6748, 1375, 47, 70, "DisplayMath",
 CellTags->"b:0.4.1",
 CellID->437745],
Cell[189152, 6797, 1377, 45, 70, "Text",
 CellTags->"b:0.4.1",
 CellID->375870]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[190578, 6848, 46, 1, 70, "Section",
 CellID->163780876],
Cell[CellGroupData[{
Cell[190649, 6853, 109, 2, 70, "Subsection",
 CellTags->"b:0.5.0",
 CellID->804567386],
Cell[190761, 6857, 291, 9, 70, "Text",
 CellTags->"b:0.5.0",
 CellID->110467185],
Cell[191055, 6868, 1469, 43, 70, "DefinitionBox3Col",
 CellTags->"b:0.5.0",
 CellID->532547471],
Cell[192527, 6913, 388, 14, 70, "Caption",
 CellTags->"b:0.5.0",
 CellID->135821432],
Cell[192918, 6929, 817, 22, 70, "DefinitionBox3Col",
 CellTags->"b:0.5.0",
 CellID->230187574],
Cell[193738, 6953, 523, 19, 70, "Caption",
 CellTags->"b:0.5.0",
 CellID->134658611],
Cell[CellGroupData[{
Cell[194286, 6976, 83, 2, 70, "Subsubsection",
 CellTags->"b:0.5.0",
 CellID->534299437],
Cell[194372, 6980, 343, 10, 70, "MathCaption",
 CellTags->"b:0.5.0",
 CellID->49107805],
Cell[CellGroupData[{
Cell[194740, 6994, 458, 16, 70, "Input",
 CellTags->"b:0.5.0",
 CellID->47693454],
Cell[195201, 7012, 1657, 56, 89, "Output",
 CellTags->"b:0.5.0",
 CellID->120362649]
}, Open  ]],
Cell[196873, 7071, 456, 16, 70, "MathCaption",
 CellTags->"b:0.5.0",
 CellID->562047429],
Cell[CellGroupData[{
Cell[197354, 7091, 513, 17, 30, "Input",
 CellTags->"b:0.5.0",
 CellID->91622],
Cell[197870, 7110, 4298, 75, 469, "Output",
 Evaluatable->False,
 CellTags->"b:0.5.0",
 CellID->675005616]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[202217, 7191, 86, 2, 70, "Subsubsection",
 CellTags->"b:0.5.0",
 CellID->916560033],
Cell[202306, 7195, 276, 9, 70, "MathCaption",
 CellTags->"b:0.5.0",
 CellID->22995033],
Cell[CellGroupData[{
Cell[202607, 7208, 275, 10, 70, "Input",
 CellTags->"b:0.5.0",
 CellID->220100868],
Cell[202885, 7220, 828, 28, 39, "Output",
 CellTags->"b:0.5.0",
 CellID->727821508]
}, Open  ]],
Cell[203728, 7251, 658, 24, 70, "MathCaption",
 CellTags->"b:0.5.0",
 CellID->156420963],
Cell[CellGroupData[{
Cell[204411, 7279, 328, 11, 70, "Input",
 CellTags->"b:0.5.0",
 CellID->58867455],
Cell[204742, 7292, 2357, 86, 153, "Output",
 CellTags->"b:0.5.0",
 CellID->350610691]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[207148, 7384, 83, 2, 70, "Subsubsection",
 CellTags->"b:0.5.0",
 CellID->869227976],
Cell[207234, 7388, 417, 14, 70, "MathCaption",
 CellTags->"b:0.5.0",
 CellID->162562523],
Cell[CellGroupData[{
Cell[207676, 7406, 337, 11, 70, "Input",
 CellTags->"b:0.5.0",
 CellID->318749219],
Cell[208016, 7419, 772, 23, 54, "Output",
 CellTags->"b:0.5.0",
 CellID->43878235]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[208849, 7449, 105, 2, 70, "Subsection",
 CellTags->"b:0.5.1",
 CellID->167657003],
Cell[208957, 7453, 646, 21, 70, "Text",
 CellTags->"b:0.5.1",
 CellID->218482819],
Cell[209606, 7476, 478, 16, 70, "Program",
 CellTags->"b:0.5.1",
 CellID->422400505],
Cell[210087, 7494, 281, 11, 70, "MathCaption",
 CellTags->"b:0.5.1",
 CellID->133051656],
Cell[210371, 7507, 290, 9, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->346370944],
Cell[210664, 7518, 163, 6, 70, "MathCaption",
 CellTags->"b:0.5.1",
 CellID->6683350],
Cell[CellGroupData[{
Cell[210852, 7528, 244, 7, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->38559548],
Cell[211099, 7537, 184, 6, 36, "Output",
 CellTags->"b:0.5.1",
 CellID->352979638]
}, Open  ]],
Cell[211298, 7546, 306, 11, 70, "MathCaption",
 CellTags->"b:0.5.1",
 CellID->290204304],
Cell[211607, 7559, 292, 9, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->563530338],
Cell[211902, 7570, 1251, 36, 70, "DefinitionBox3Col",
 CellTags->"b:0.5.1",
 CellID->138207434],
Cell[213156, 7608, 583, 20, 70, "Caption",
 CellTags->"b:0.5.1",
 CellID->308678426],
Cell[CellGroupData[{
Cell[213764, 7632, 84, 2, 70, "Subsubsection",
 CellTags->"b:0.5.1",
 CellID->379056828],
Cell[213851, 7636, 1013, 35, 70, "MathCaption",
 CellTags->"b:0.5.1",
 CellID->162655316],
Cell[CellGroupData[{
Cell[214889, 7675, 1601, 52, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->84186630],
Cell[216493, 7729, 233, 8, 36, "Output",
 CellTags->"b:0.5.1",
 CellID->97328426]
}, Open  ]],
Cell[216741, 7740, 695, 25, 70, "MathCaption",
 CellTags->"b:0.5.1",
 CellID->723830391],
Cell[CellGroupData[{
Cell[217461, 7769, 738, 23, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->43750448],
Cell[218202, 7794, 248, 8, 36, "Output",
 CellTags->"b:0.5.1",
 CellID->648262201]
}, Open  ]],
Cell[218465, 7805, 622, 16, 70, "MathCaption",
 CellTags->"b:0.5.1",
 CellID->102977779],
Cell[CellGroupData[{
Cell[219112, 7825, 218, 8, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->97069423],
Cell[219333, 7835, 264, 9, 36, "Output",
 CellTags->"b:0.5.1",
 CellID->829969076]
}, Open  ]],
Cell[219612, 7847, 126, 3, 70, "MathCaption",
 CellTags->"b:0.5.1",
 CellID->42314769],
Cell[CellGroupData[{
Cell[219763, 7854, 547, 18, 28, "Input",
 CellTags->"b:0.5.1",
 CellID->190539109],
Cell[220313, 7874, 2342, 43, 248, "Output",
 Evaluatable->False,
 CellTags->"b:0.5.1",
 CellID->188859369]
}, Open  ]],
Cell[222670, 7920, 291, 9, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->52362266]
}, Open  ]],
Cell[CellGroupData[{
Cell[222998, 7934, 82, 2, 70, "Subsubsection",
 CellTags->"b:0.5.1",
 CellID->98929011],
Cell[223083, 7938, 421, 11, 70, "MathCaption",
 CellTags->"b:0.5.1",
 CellID->635299211],
Cell[CellGroupData[{
Cell[223529, 7953, 478, 16, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->587657385],
Cell[224010, 7971, 2754, 85, 145, "Output",
 CellTags->"b:0.5.1",
 CellID->35083699]
}, Open  ]],
Cell[226779, 8059, 467, 15, 70, "MathCaption",
 CellTags->"b:0.5.1",
 CellID->282795960],
Cell[CellGroupData[{
Cell[227271, 8078, 692, 22, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->188790613],
Cell[227966, 8102, 483, 17, 36, "Output",
 CellTags->"b:0.5.1",
 CellID->113313394]
}, Open  ]],
Cell[228464, 8122, 289, 9, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->24410703]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[228814, 8138, 122, 3, 70, "Section",
 CellTags->{"t:29", "c:29", "b:0.6"},
 CellID->89793884],
Cell[228939, 8143, 223, 7, 70, "DisplayMath",
 CellTags->{"BW", "b:0.6"},
 CellID->174911420],
Cell[229165, 8152, 235, 7, 70, "DisplayMath",
 CellTags->{"CLS", "b:0.6"},
 CellID->543617109],
Cell[229403, 8161, 238, 7, 70, "DisplayMath",
 CellTags->{"L", "b:0.6"},
 CellID->551706795],
Cell[CellGroupData[{
Cell[229666, 8172, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->620241697],
Cell[229735, 8175, 163, 3, 70, "TutorialMoreAbout",
 CellID->41792741],
Cell[229901, 8180, 151, 3, 70, "TutorialMoreAbout",
 CellID->491741950],
Cell[230055, 8185, 155, 3, 70, "TutorialMoreAbout",
 CellID->431890435],
Cell[230213, 8190, 155, 3, 70, "TutorialMoreAbout",
 CellID->529168822]
}, Open  ]],
Cell[CellGroupData[{
Cell[230405, 8198, 72, 1, 70, "RelatedTutorialsSection",
 CellID->660206149],
Cell[230480, 8201, 154, 3, 70, "RelatedTutorials",
 CellID->27763821],
Cell[230637, 8206, 168, 4, 70, "RelatedTutorials",
 CellID->44163066],
Cell[230808, 8212, 193, 4, 70, "RelatedTutorials",
 CellID->9553489],
Cell[231004, 8218, 201, 5, 70, "RelatedTutorials",
 CellID->202769951],
Cell[231208, 8225, 205, 5, 70, "RelatedTutorials",
 CellID->544696413],
Cell[231416, 8232, 191, 4, 70, "RelatedTutorials",
 CellID->764341847],
Cell[231610, 8238, 144, 3, 70, "RelatedTutorials",
 CellID->229816863]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[231793, 8246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

