(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17474,        630]
NotebookOptionsPosition[     12695,        483]
NotebookOutlinePosition[     15485,        555]
CellTagsIndexPosition[     15394,        549]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series, Limits and Residues" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SeriesLimitsAndResiduesOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Series, Limits and Residues\"\>"}, "\<\"related tutorials\"\>",
        
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ComposeSeries" :> 
          Documentation`HelpLookup["paclet:ref/ComposeSeries"], 
          "InverseSeries" :> 
          Documentation`HelpLookup["paclet:ref/InverseSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ComposeSeries\"\>", 
       2->"\<\"InverseSeries\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Composition and Inversion of Power Series", "Title",
 CellTags->{"S3.6.4", "4.1"},
 CellID->31107],

Cell[TextData[{
 "When you manipulate power series, it is sometimes convenient to think of \
the series as representing ",
 StyleBox["functions",
  FontSlant->"Italic"],
 ", which you can, for example, compose or invert. "
}], "Text",
 CellID->30191],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ComposeSeries",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ComposeSeries"], "[", 
     SubscriptBox[
      StyleBox["series", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["series", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "compose power series", "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseSeries",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseSeries"], "[", 
     StyleBox["series", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell["invert a power series", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18007],

Cell["Composition and inversion of power series. ", "Caption",
 CellID->11337],

Cell[TextData[{
 "Here is the power series for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " to order ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "5"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->15457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12287],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{204, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2069242835]
}, Open  ]],

Cell[TextData[{
 "This replaces the variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " in the power series for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " by a power series for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->10383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14945],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "8"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "15"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 0, 
    Rational[-1, 8], 
    Rational[-1, 15]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{166, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->951471114]
}, Open  ]],

Cell[TextData[{
 "The result is the power series for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", 
    RowBox[{"sin", "(", "x", ")"}], ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->32209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9758],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "8"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "15"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 0, 
    Rational[-1, 8], 
    Rational[-1, 15]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{166, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->609715584]
}, Open  ]],

Cell[TextData[{
 "If you have a power series for a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "y", ")"}], TraditionalForm]], "InlineMath"],
 ", then it is often possible to get a power series approximation to the \
solution for ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " in the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "y", ")"}], "=", "x"}], TraditionalForm]], 
  "InlineMath"],
 ". This power series effectively gives the inverse function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["f", 
     RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{
      SuperscriptBox["f", 
       RowBox[{"-", "1"}]], "(", "x", ")"}], ")"}], "=", "x"}], 
   TraditionalForm]], "InlineMath"],
 ". The operation of finding the power series for an inverse function is \
sometimes known as ",
 StyleBox["reversion",
  FontSlant->"Italic"],
 " of power series."
}], "Text",
 CellID->18588],

Cell[TextData[{
 "Here is the series for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", "y", ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->6422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "y", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24946],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"y", "-", 
   FractionBox[
    SuperscriptBox["y", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["y", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "y", "]"}], "6"],
    SeriesData[$CellContext`y, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`y, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120]}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{125, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2064761054]
}, Open  ]],

Cell[TextData[{
 "Inverting the series gives the series for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["sin", 
     RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->13030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseSeries", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->16413],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[3, 40]}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{126, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->564907440]
}, Open  ]],

Cell[TextData[{
 "This agrees with the direct series for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["sin", 
     RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->602693870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->126584454],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[3, 40]}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{126, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1968641466]
}, Open  ]],

Cell["\<\
Composing the series with its inverse gives the identity function.\
\>", "MathCaption",
 CellID->900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{"%", ",", "%%%"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->32591],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"y", "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "y", "]"}], "6"],
    SeriesData[$CellContext`y, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`y, 0, {1}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->830217436]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->537321117],

Cell[TextData[ButtonBox["Series, Limits and Residues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Composition and Inversion of Power Series - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Series, Limits and Residues", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OperationsOnPowerSeries"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ConvertingPowerSeriesToNormalExpressions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 22.6551962}", "context" -> "", 
    "keywords" -> {
     "ComposeSeries", "compose series", "InverseFunctions", "InverseSeries", 
      "inverse series", "power series", "reversion of power series"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When you manipulate power series, it is sometimes convenient to think of \
the series as representing functions, which you can, for example, compose or \
invert. Composition and inversion of power series. Here is the power series \
for exp(x) to order x^5. ", "synonyms" -> {"3.6.4"}, "title" -> 
    "Composition and Inversion of Power Series", "type" -> "Tutorial", "uri" -> 
    "tutorial/CompositionAndInversionOfPowerSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.6.4"->{
  Cell[1980, 62, 104, 2, 70, "Title",
   CellTags->{"S3.6.4", "4.1"},
   CellID->31107]},
 "4.1"->{
  Cell[1980, 62, 104, 2, 70, "Title",
   CellTags->{"S3.6.4", "4.1"},
   CellID->31107]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.6.4", 15181, 538},
 {"4.1", 15281, 542}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1355, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1980, 62, 104, 2, 70, "Title",
 CellTags->{"S3.6.4", "4.1"},
 CellID->31107],
Cell[2087, 66, 250, 7, 70, "Text",
 CellID->30191],
Cell[2340, 75, 1119, 32, 70, "DefinitionBox",
 CellID->18007],
Cell[3462, 109, 78, 1, 70, "Caption",
 CellID->11337],
Cell[3543, 112, 289, 11, 70, "MathCaption",
 CellID->15457],
Cell[CellGroupData[{
Cell[3857, 127, 211, 7, 28, "Input",
 CellID->12287],
Cell[4071, 136, 754, 26, 54, "Output",
 CellID->2069242835]
}, Open  ]],
Cell[4840, 165, 400, 14, 70, "MathCaption",
 CellID->10383],
Cell[CellGroupData[{
Cell[5265, 183, 283, 9, 28, "Input",
 CellID->14945],
Cell[5551, 194, 675, 23, 54, "Output",
 CellID->951471114]
}, Open  ]],
Cell[6241, 220, 223, 8, 70, "MathCaption",
 CellID->32209],
Cell[CellGroupData[{
Cell[6489, 232, 242, 8, 70, "Input",
 CellID->9758],
Cell[6734, 242, 675, 23, 54, "Output",
 CellID->609715584]
}, Open  ]],
Cell[7424, 268, 1070, 36, 70, "Text",
 CellID->18588],
Cell[8497, 306, 178, 7, 70, "MathCaption",
 CellID->6422],
Cell[CellGroupData[{
Cell[8700, 317, 211, 7, 70, "Input",
 CellID->24946],
Cell[8914, 326, 588, 20, 54, "Output",
 CellID->2064761054]
}, Open  ]],
Cell[9517, 349, 245, 9, 70, "MathCaption",
 CellID->13030],
Cell[CellGroupData[{
Cell[9787, 362, 128, 4, 70, "Input",
 CellID->16413],
Cell[9918, 368, 610, 21, 54, "Output",
 CellID->564907440]
}, Open  ]],
Cell[10543, 392, 246, 9, 70, "MathCaption",
 CellID->602693870],
Cell[CellGroupData[{
Cell[10814, 405, 218, 7, 70, "Input",
 CellID->126584454],
Cell[11035, 414, 611, 21, 54, "Output",
 CellID->1968641466]
}, Open  ]],
Cell[11661, 438, 111, 3, 70, "MathCaption",
 CellID->900],
Cell[CellGroupData[{
Cell[11797, 445, 130, 4, 70, "Input",
 CellID->32591],
Cell[11930, 451, 417, 14, 36, "Output",
 CellID->830217436]
}, Open  ]],
Cell[CellGroupData[{
Cell[12384, 470, 72, 1, 70, "RelatedTutorialsSection",
 CellID->537321117],
Cell[12459, 473, 182, 4, 70, "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],
Cell[12668, 481, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

