(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    422473,       8754]
NotebookOptionsPosition[    407345,       8269]
NotebookOutlinePosition[    411890,       8382]
CellTagsIndexPosition[    411583,       8370]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Constrained Optimization" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ConstrainedOptimizationOverview"], 
         "Linear Programming" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ConstrainedOptimizationLinearProgramming"], 
         "Numerical Nonlinear Global Optimization" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ConstrainedOptimizationGlobalNumerical"], 
         "Exact Global Optimization" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ConstrainedOptimizationExact"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Constrained Optimization\"\>", 
      2->"\<\"Linear Programming\"\>", 
      3->"\<\"Numerical Nonlinear Global Optimization\"\>", 
      4->"\<\"Exact Global Optimization\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Nonlinear Local Optimization", "Title",
 CellID->85183321],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellID->469184158],

Cell[TextData[{
 "Numerical algorithms for constrained nonlinear optimization can be broadly \
categorized into gradient-based methods and direct search methods. Gradient \
search methods uses first derivatives (gradients) or second derivatives \
(Hessians) information. Examples are the SQP (sequential quadratic \
programming) method, the augmented Lagrangian method, and the (nonlinear) \
interior point method. ",
 StyleBox["Direct search methods",
  FontColor->GrayLevel[0]],
 " do not use derivative information. Examples are Nelder\[Dash]Mead, genetic \
algorithm and differential evolution, and simulated annealing. Direct search \
methods tend to converge more slowly, but can be more tolerant to the \
presence of noise in the function and constraints."
}], "Text",
 CellID->289642637],

Cell[TextData[{
 "Typically, algorithms only build up a local model of the problems. \
Furthermore, to ensure convergence of the iterative process, many such \
algorithms insist on a certain decrease of the objective function or of a \
merit function which is a combination of the objective and constraints. Such \
algorithms will, if convergent, only find local optimum, and are called local \
optimization algorithms. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " local optimization problems can be solved using ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 "."
}], "Text",
 CellID->65223348],

Cell[TextData[{
 "Global optimization",
 " ",
 "algorithms",
 ", on the other hand, attempt to find the global optimum, typically by \
allowing decrease as well as increase of the objective/merit",
 " ",
 "function. Such algorithms are usually computationally more expensive. \
Global optimization problems can be solved exactly using ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " or numerically using ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 "."
}], "Text",
 CellID->166790006],

Cell["This solves a nonlinear programming problem,", "Text",
 CellID->303464556],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{"Min", "     ", "x"}], "-", "y"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"s", ".", "t"}], "   ", "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"2", " ", "x", " ", "y"}], "-", 
    SuperscriptBox["y", "2"]}], "\[GreaterEqual]", 
   RowBox[{"-", "1"}]}], TraditionalForm]}], "DisplayMath",
 CellID->401358986],

Cell[TextData[{
 "using ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 ",",
 "which gives an exact solution."
}], "Text",
 CellID->73215332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"2", " ", "x", " ", "y"}], "-", 
       SuperscriptBox["y", "2"]}], "\[GreaterEqual]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213704],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->434225361]
}, Open  ]],

Cell[TextData[{
 "This solves the same problem numerically. ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " returns a machine-number solution."
}], "Text",
 CellID->109220874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"2", " ", "x", " ", "y"}], "-", 
       SuperscriptBox["y", "2"]}], "\[GreaterEqual]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38568035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.9999999999999994`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "3.5751374783506185`*^-17"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0.9999999999999994`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{234, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->199547764]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " numerically finds a local minimum. In this example the local minimum found \
is also a global minimum."
}], "Text",
 CellID->583307620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"2", " ", "x", " ", "y"}], "-", 
       SuperscriptBox["y", "2"]}], "\[GreaterEqual]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7703726],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.000000810766966`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2.7830123428585406`*^-17"}], ",", 
     RowBox[{"y", "\[Rule]", "1.000000810766966`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{226, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->411160828]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The FindMinimum function", "Section",
 CellID->73716527],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " solves local unconstrained and constrained optimization problems. This \
document only covers the constrained optimization case. See \"",
 ButtonBox["Unconstrained Optimization\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UnconstrainedOptimizationOverview"],
 " for details of ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " for unconstrained optimization."
}], "Text",
 CellID->16081535],

Cell[TextData[{
 "This solves a nonlinear programming problem,\n",
 Cell[BoxData[{
  FormBox[
   RowBox[{"Min", "     ", "-", " ", 
    FractionBox["100", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "2"], "+", "1"}]], "-", 
    FractionBox["200", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"y", "+", "2"}], ")"}], "2"], "+", "1"}]]}], 
   TraditionalForm], "\n", 
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"s", ".", "t"}], "                   ", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["y", "2"]}], ">", "3"}], TraditionalForm]}], 
  "InlineMath"],
 "\nusing ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->358089548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FormBox[
      RowBox[{
       RowBox[{"-", " ", 
        FractionBox["100", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"y", "-", "1"}], ")"}], "2"], "+", "1"}]]}], "-", 
       FractionBox["200", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"y", "+", "2"}], ")"}], "2"], "+", "1"}]]}],
      TraditionalForm], ",", 
     FormBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], ">", "3"}],
      TraditionalForm]}], " ", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->83250509],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "207.15989698200872`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.994861334736008`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1.9922920021040138`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{271, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->27717002]
}, Open  ]],

Cell[TextData[{
 "This provides ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " with a starting value of ",
 Cell[BoxData["2"], "InlineFormula"],
 " for ",
 Cell[BoxData["x"], "InlineFormula"],
 ", but uses the default starting point for ",
 Cell[BoxData["y"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->525779614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FormBox[
      RowBox[{
       RowBox[{"-", " ", 
        FractionBox["100", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"y", "-", "1"}], ")"}], "2"], "+", "1"}]]}], "-", 
       FractionBox["200", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"y", "+", "2"}], ")"}], "2"], "+", "1"}]]}],
      TraditionalForm], ",", 
     FormBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], ">", "3"}],
      TraditionalForm]}], " ", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}], ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->551050557],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "103.06261052078153`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.2303719117773388`"}], ",", 
     RowBox[{"y", "\[Rule]", "1.2190918583675474`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->68607961]
}, Open  ]],

Cell[TextData[{
 "The above solution point is actually a local minimum. ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " only attempts to find a local minimum."
}], "Text",
 CellID->129275445],

Cell["\<\
This contour plot of the feasible region illustrates the local and global \
minima.\
\>", "MathCaption",
 CellID->668365059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", " ", 
     FractionBox["100", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"y", "-", "1"}], ")"}], "2"], "+", "1"}]]}], "-", 
    FractionBox["200", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"y", "+", "2"}], ")"}], "2"], "+", "1"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#1", "^", "2"}], "+", 
        RowBox[{"#2", "^", "2"}]}], ">", "3"}], "&"}], ")"}]}], ",", 
   RowBox[{"Contours", "\[Rule]", "10"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", ".02", "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<global minimum\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", ".995"}], ",", 
           RowBox[{"-", "2.092"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".995"}], ",", 
          RowBox[{"-", "1.992"}]}], "}"}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<local minimum\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0.5304", ",", "1.2191"}], "}"}]}], "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1.2304", ",", "1.2191"}], "}"}], "]"}]}], "}"}], ")"}]}], 
   ",", 
   RowBox[{"ContourLabels", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->423568925],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJycvQdUVMf7P7y7wGIvaGLvvaCxYfdi7yX2SKyx9x6NUWxRsbfYE6Ni7707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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNls1PnFUUxt9hYGZgYF5mhkgHExMT03ZVQyIaqAv/gvpBF7qQqgvThWKN
pcRUjXytTNQm3dRd9+4gEpM2wSJE6wblY8oMldpiY1G7EEw0ZeHz63kWLk7u
ee8999xzz3mec9/H33jnpdGWJEl2JFlJR5okI5Kf9fGmxmJPkky1JsmMvn/M
JMmLkicLSXJMsp+Jke/rcnJF40Rr2I10J0lXKWxuFGM9J/k6Db/4/EDjeckX
0vu1dkL7j2gs5JJkWnOTkguS7733UFuS9EpW5PORdq1Jn87Gvue992Y1STYl
37TH3Aueb2hPTWNd4z3FtisZ0Pevsu1UnHuaf1CMOHolG96PzVgx9p6Szed5
5UjxXVJczUqSbEm+lF2X7lFTrrYVz6dtMbekPW9p/X3535T+rubHtPeo9KGO
iJ18juisZjZyvKbvVclJSV3n7kvmHduB5HImYnxgfVHjjvVrxZgnfvaSd/JG
/vatT+jcSclvst/S97KkKX2wI9aYx36hJc4FB8wT09VsnMWedX3POk7yQQ0P
t8TdLlnnfOJ4SrjKdYY+73tteH5VuRmoRi6oLfNzmagXtUKnzjPO1XX7ZS/5
WPTdiQmdu4DBFcd34Jxc8xojfsF1Sylw+Jpq9E+X8KWa1XTWJ7nALTr45izu
DhY4K5uP72Vjtt/zxMz9wMmYMUI+iAduDGeiDnXXYsD72XuuGDgDM+SqrTNy
QS3y+ajHbcV5XjE3pf+teI/3xBocKeTD9ohrsJEJHs6as79r71+ViAFufVUI
P5OuO3W+o/WdSqxNqyZ5YfpeW+D3z0pgeNY1oe7w44Q5Qu3mfB7463cMq/Lx
UxrY33SPIC7Gq84JvOlMgzt90h+VvpcNzjWcz2OuDXV5WKdC4PdKWX4kp3X/
Wxp/kXyWjxqddp02NHejHHsX/4eFZ3XWGc335QP/6+YeXCRW4iSmm+blD4qr
z7GR+5Fy5H+mGn2THP7bFX7xSbz0rD37XXfeyMua9TnjHJ2aNzxXMy/rzum6
69jrvGL/nXrYaCmwwRycWzOvOR98PqFY3ksDIz3Sm7K/mA2MHPa+uv3i835b
2ObMpwPnq1GK/exN0+AtnB3U3YckNfdjRrgK9ukLnAHH6On0c+rA20AtyCPn
cda25url4B75Bner5muv+zZ4/LYca4+Voo+DPXr9QnvgmX5fzAUPXpX9c93R
08D+3S7jPxuxks9iGvWjdvvm27zxRq+B+/TzJfd/fINl/I8XA4vkm/7X6r7X
bx6SW3iZNzcv+m3Az33Fs1sJDvAWHPd7QN+CS9T87Uq8H2ARznI/1sE+9eVc
7s39wRi9Yasadvj+w/5fVw4+TCN23uqV9rgbPWfLODuj9bvVWNvV+FEab2Cj
Gm8k/sHygs9q+mzioWY145x7DPkdedjn3MeIA85zF765I7ntNUfQJ3TOx9V4
DwfthxrRnwb9BmFbs/263y1siOWQ/w0a5tK8x5z1Z+T76Wr8O+z47Vj2u3zU
NQOj034/7ghrt8vx5i+4fqfcV+np1Ah79GH3pXH38CX/N2B/Ng0eXrDtpP3X
bEP+pzw/bB6DJbhMv6EnwhWwXCxFbomf3nbZbyLrOfs7Z5/42HbvgjNgnByO
22bJGBg3Dk6Wg+fc81Z3cJLajglHZyuBHWpHTulR9OypapwxqbE9De6S6wXz
hV7Q9L8jcdx0DLyP9Gn6RE77RithV0jDF3b8xzX9L/eKYnu5HH19yHggD/8B
Eq6GMA==
         "],
         VertexColors->None], 
        PolygonBox[{{4577, 4575, 1177, 1935}, {4578, 3962, 1546, 1936}, {3934,
          5151, 2690, 990}, {3595, 5132, 2619, 488}, {3586, 4191, 1544, 
         1155}, {4749, 4750, 2128, 2127}, {4447, 3573, 1799, 1800}, {5084, 
         5085, 2497, 731}, {4705, 3577, 1818, 2073}, {3963, 3612, 1028, 
         1178}, {4330, 5098, 2518, 565}, {4845, 4846, 2237, 729}, {4992, 3846,
          987, 2398}, {4836, 4834, 731, 2230}, {3699, 4921, 2329, 1425}, {
         4995, 3848, 989, 991}, {4844, 4843, 339, 2237}, {3576, 4705, 2073, 
         2072}, {3965, 4051, 1393, 1547}, {4718, 4717, 729, 987}, {3962, 3964,
          1178, 1546}, {3865, 3956, 1169, 1518}, {4828, 4703, 709, 2220}, {
         4548, 3851, 990, 1513}, {4464, 4299, 710, 1818}, {3966, 4749, 2127, 
         2518}, {3612, 3853, 991, 1028}, {3575, 4576, 1935, 1653}, {5083, 
         5082, 499, 2497}, {3955, 4447, 1800, 1169}, {3596, 4320, 1675, 
         499}, {4191, 3587, 1156, 1544}, {3803, 3695, 1422, 916}, {4918, 3699,
          1425, 2326}, {3587, 4835, 2230, 1156}, {4920, 4993, 2398, 901}, {
         3695, 4827, 2220, 1422}, {3597, 4725, 2095, 500}, {4446, 4296, 704, 
         1799}, {3867, 3865, 1518, 1011}, {4703, 4704, 2072, 709}, {4917, 
         4919, 2326, 900}, {5132, 3855, 900, 2619}, {4922, 4920, 901, 2329}, {
         4331, 3614, 565, 957}, {4299, 4441, 1795, 710}, {4440, 4540, 1896, 
         1795}, {4750, 4193, 1547, 2128}, {4724, 3952, 2512, 2095}, {3849, 
         4996, 1513, 989}, {4042, 4043, 1011, 714}, {3694, 4436, 916, 704}, {
         4567, 4566, 500, 1675}, {5151, 3933, 488, 2690}, {3558, 4025, 1155, 
         339}, {4050, 3575, 1653, 1393}, {4541, 4331, 957, 1896}, {4575, 4579,
          1936, 1177}, {5094, 4042, 714, 2512}},
         VertexColors->None]}]}, 
     {RGBColor[0.351696445360048, 0.158738354972524, 0.611332216314427], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmVtw1dUVxs85OSc5Jyc5l5wEkItWAjLhqbaiSJ0qttPS6kutnWkFJOBD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlltsVGUQx79ut9vult1z9pyi2CYKpsSkT6KCAYkWNVGUF5EHjW2FkiiY
tmJvlpQi0ErFECBgAyEawWgwkcSEqKCBorTRgraaYgW6C+XaYqncogHe/E3+
PEwy35n55vbN/OdMq357YV3EOdcFRaGNgXMlKeeK+bigwLmV8DV8K4XfB/2R
dO5L37mXYs7l5Th3Lu3cWWgX/KZ8506gu4w7B7hfmetcBL6wyLlZCecG0Rnl
/k10erBVkedcvudcR+hcddy5LPpVnBPQ+9hqIKAhbL8DlXDugF6BfxVqxv9j
+FiO/ZPYG4nIZzHnCexl4srhKLpbOK/g3MT9n7H9C9SH7BB0GPlt7vTie5B4
CuCvId8C34mPLLYzUC+69xLzfuS/JZVbBTQT28f5Nhn7RdAYupehMnT7uVNK
7o3Yu4nuJmrQiKwJehj5ZvIr5G459TyDvzF0fM43kB9BPhdaA/8e9BP8U1A3
8R5LK5en8fdPoDeytzkMHUJ2MK3adBH/anyPE+NH8J/g7zyyC2m91Q7OK+Dn
EuP5hGq6FnsB9sa5X469Efg5xFeD7qfEd5vcFweqxWe852TkF5Fv5u6zfGvH
1yR8PkovLSG+Qfjj0MdR9UgW/WfQGSLfndh7hLszoK+RXeK8DlmBp7uL44ql
HX/zChTTJM6X0Pkd2UZ8tnI+j/wb5N9Cw2n1jPXKBiiT1pvaW37I+STnv6D1
8J3QOHevBqrdGPaH0V2E3CGbIKYz8HvJuZRPM2J3exP/S+Pq0WnwD4TqhTsW
I7n8DW2LqeYbkHVCo8jftJzgq6AezuWcJwLFYL67ud8GvzrQ21/mWy3xvEwM
K9Hv5nwR2YVAs2Q518HHiKmf83TOV+ytOWexPRzX7NYGktkMNxHbVOtH6v8g
8e2H/85T7V/jjfbibys6TyIrz1dvVnqaRevRq/Dz6ZeWQmafeJLoV6GTH1NP
t9nb+eo1e/PnffWI9ca1PMXW7Mu3xdibFgbY7Nfjb5unHCx2m+EX4RdAZfC7
cxX7TF+zajmUcC4mnqaEZuw6snZfb7UzptlZF6iXbYbinnrMesswx2YtndJs
2cy9xd3lvmbXMMBys56xXrEcM9w9BbWQ2xHutxheYONH7m5F/xjnslC8vdks
+MdDYcNARFj0eqi3N0xqJZ5VnmZxOvJ/U3oDq/3BXM3SfeRXn9BM1RPLKWI6
HREmZtAtQl6dEEbtQbaIb9mYMLqD2Cqgrwo0Q2Yr6cmX2TyBvRHutEY1E9cD
9aD1nuVktm0mbBbMx6hhqSfsWkaOq5CNBpplw+D8lGbOZq02T7Nwf0pYZDOR
tlllnrY79Vg/8gHooZgwwHbFG9i/J6Kd0Qk/ANVgawo6e7A1NdSsGSbZLrkS
aHZsp9TDxw0jcoTB2VAYYdjQExfWLw2FnYb5X2D7c0/Ytgtag2wtNCWumbLZ
PQrti2uGLbbvPe0ui/Fd+BYoEhVGVOK/KtDb9SCvw18f+TXEhCmGHYWeet0w
xLCgGpoXFybYLvE87QLbKXOQzQ7VOxbTdvgdoXaz9cAQ/J+hZuOHuGp5w1fv
W00T2KvF3q1c1cTe+qx/Fzujmp1i5AdyNEPPYetcSrWwHjKsHQ7V64a5DZ52
mu2yLu4sQXYL/baocjBsqElptxpGNOCr0VcvWI360F/oCWuspnkpYbZhtb1x
FfwT2MgkVDOz/UEo7DQf66ltZyAssZwq0a9ICxttpzfbbkwLm2wnvcDd+aH+
VQxDhgO9kb2NzYTl/qunXrYa2C68k9Rus51osfyXVK4Wk83+6VC9ZBgwaPs/
VO2tp2f76lnrVdtx/wNluVjW
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.439013242983594, 0.310558684828736, 0.734066538350124], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXmQ1cURx3+7+/bt2/fcd7J4plg0LkY0RqIVJAFSyBFI0LiLGlMgIkXk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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwll3uQjXUYx3+79pw9u5xz3vMeCjGFGYRmKjVUMzQpoova1XWUS7NN7pci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         "],
         VertexColors->None], PolygonBox[{{3910, 5214, 3356, 1859, 1095}},
         VertexColors->None]}]}, 
     {RGBColor[0.52633004060714, 0.462379014684948, 0.856800860385821], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuU1VUVx3/M487cO3Pv797fJZM/1IWouPqDkodlrbBCMdLEB5gJshIH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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlleMVVUUhvfMZWYY5N5z7rk0H0RhaPoAKsRoTEAjRUBB6gMQI1WKMEqV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         "],
         VertexColors->None], 
        PolygonBox[{{4632, 5205, 3363, 3364, 1996}, {5203, 4641, 2010, 3375, 
         3336}},
         VertexColors->None]}]}, 
     {RGBColor[0.600454483083963, 0.586425463411737, 0.910333874924813], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuMVVcVxs/cO3PvzMB9nqFgNTSECmhMhUIaKS/bRprYWh4qCigi0MaW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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslFUUhi/TzkzRznzffIMiLhACETSGRQiKlCISayI7KgbQiIBGBArI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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.664652533736004, 0.689573867511973, 0.911797392746981], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmWuUllUVx5+5vvPO5b09sERAKrMERBQwEIHKC5cBJUHlKtlCCwVCQbwu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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mwV2MYx9+7/36595zfOec2mWQ3KkNut5Q2dHOFLJWhupVpFFGJVstY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         "],
         VertexColors->None], 
        PolygonBox[{{3578, 4040, 3315, 3268, 419}, {4287, 3567, 377, 3278, 
         3338}, {3930, 4133, 1476, 3399, 3293}, {4138, 4137, 3321, 3171, 
         858}, {4535, 4287, 3338, 3277, 1891}, {5206, 5139, 2653, 3422, 
         3387}, {5204, 3521, 1747, 3345, 3344}},
         VertexColors->None]}]}, 
     {RGBColor[0.728850584388045, 0.792722271612209, 0.91326091056915], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXmQVNUVxt9093RPz0x3T3cPYGUDFVKCsggMi4lhERQFBgQEVFxiDOAS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twVdUVxndyc+8lMfeenHvDY1pbsJAZoQRQHgVGLFgigQACkRgeCkMp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         "],
         VertexColors->None], 
        PolygonBox[{{3633, 4764, 2150, 3378, 3233}, {3634, 4765, 2151, 3381, 
         3234}, {5209, 5200, 375, 2583, 3412}},
         VertexColors->None]}]}, 
     {RGBColor[0.789948100743355, 0.856107525207983, 0.901792963346722], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmwVdWVhs99073v3nfn11EEVERQJhE1QEIERVAETTvCQ0QF49gJatrq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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmH2QzecVx59d3Ht33Xt/93fv1kjEKhXvS7zEaoSShHhN0WIVKUs0pJOk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         "],
         VertexColors->None], PolygonBox[{{3908, 5113, 2570, 3257, 3280}},
         VertexColors->None]}]}, 
     {RGBColor[0.847602307419111, 0.875333666883608, 0.875963930421799], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmQ1dWVxv+9vff67a8fZSmg0jhB6WZxKiyRNMbWmAgBBDNEUSqKLBKX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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uUllUVxs/wMTPfzLzf973v982S+2VsMSqD0FpxMW6CrZWAwwxShJRL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         "],
         VertexColors->None], 
        PolygonBox[{{5202, 4506, 1858, 3352, 3270}, {5111, 5199, 3105, 3403, 
         2558}, {4245, 4246, 1360, 3312, 3331}},
         VertexColors->None]}]}, 
     {RGBColor[0.905256514094867, 0.894559808559234, 0.850134897496877], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmM1VcVx+8MvHnz5q2z2MTAsFkaE6AM2CKR0lZAaJsItayhhSqSgi0w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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllW1olnUUxo+Pz7Pn2XY/z/28jCA2evmgCc6UyJSy1G3lC6XiyxQ0P8g+
RKQm+MGKFgllOQ0qt8LFZqRO3ZqWpdVaH5KIglB7ASNIqS9BJYZNMgz6XVwf
Dvz/9znnOud/znXOffumrSu3ZCJiG5JFohaRKUcczEV8W4h4pRKxF+lCdVc+
Yg+6norPc+siXk8i5iPH0DdMijiH7tVSRNPkiOewKVQjymD+AtYUvp1PI75C
JrDdQowHEmPI90kwDhUj/sb+n/qIbu794A1gvwDbDvCOYvsnMoP7OfQzmyLe
IKcOcvkSaS85R+X2WZ1z2QXGeJ1zmko+P4LX2BjxM3gzOB8hXj94zRRgEdh9
yE3kMwL+MLo52PSSzz5kN9hHwbwf33vAbMF2JXIW28+RKvnsR/8E5w0NxnoI
ac8aU74tYIznjNGLrg3ZgX0T+vbE33RWTR/lvDEx9hDyHfUZxn81sW/Fpr/k
mIo1jfddI99Bvs3k/F+937oQfUOj36zazuNb62TXeKhoH9n2gP8X57mpsa7w
7Tj1OoE8Q//Woa+vuqfq5afk/xr+l/H5FdsW9G8XjSHf7dzznHNIC/Y/gfER
5zr8W6nHgGrK2x5MXOsS7xnkbW9V3OuN+KxGtyoxN87IBl2CPFVwTz8E75T6
B1Yz9p34r0MCXScx1vL2LiRLXm1824zuCPVppf43cx/T+/n2DuezxBzh/H3R
tV2FzR/E+r3iXG7jPkpt3k3di/eyru2d4C3KuMYD+KZgnMD2Y/BGeWsb+mcL
ruG94g4+V+nXenzexLYbebxgDs9G/zUYL6BbkfGs3FDPJ3lm1pT9Rr1N37o4
/1B0riX8r1KLg0XXfoKaTHA/XPQs/ct9Lfbvg7km5xo9Ri7LkEeItQS7WcSf
yntf5L4YOc63nrK5vh6X66l7rl5rZpZg/0nVs/d0xr3NV/129XiI+Idqnq09
xG8UFhgrNFuaOWLfzX0Z9x3UZHbqbzqrph/ge7Jm7qnHsj0gTufsIy7sRKbl
zYnzcKUz8W7QzKm2DeQznneNvyH3KVXP/kVybi6bA+q9ZlLc6Evda3HkFFin
E9fnCzBHyGVfyVzTThAX+srmljih3h8oejbEgbTmnaRdpB2oWZmeuveamfmp
e6TeaGY7Es+EZkE74fmKd7J2sd6oXXNL4lnQzhGXrmNzI2NOHSP+0tS7VztC
u1McETe0Q4e5j6Tmrnb6IOeXkUtZ1/QOsKZXXJtdGXP3dM2zKg7/hq4H+zHs
e4nRTy33V80VzZD+HYdr7rX+IQ/jv7zJXO7OeHcvTlxL7XBxQTtWu1Wc0JyO
Jq6lavpS6pnVrCrH3alzUOwL9eauYghbPVpe8huUuzjcy71QM9e0g8bIdWnJ
XNWMnUyNKSzNxH2pZ0izox35P9bg6hU=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{409, 442, 357}, {1074, 813, 125}, {3900, 5108, 1074}, {
         5138, 3739, 810}, {3896, 5105, 1069}, {1069, 809, 115}, {5105, 3489, 
         1069}, {495, 442, 409}, {442, 358, 357}, {1460, 1076, 813}, {3743, 
         5110, 816}, {124, 809, 125}, {1458, 1073, 809}, {409, 357, 137}, {
         5110, 3495, 816}, {137, 813, 138}, {1462, 816, 138}, {5109, 3903, 
         1076}, {357, 358, 124}, {5108, 3493, 1074}, {125, 357, 124}, {357, 
         125, 137}, {442, 495, 136}, {3492, 5107, 1073}, {1069, 1458, 809}, {
         810, 1457, 115}, {1073, 1459, 125}, {1459, 1074, 125}, {442, 520, 
         358}, {813, 137, 125}, {520, 442, 136}, {1074, 1460, 813}, {1076, 
         1462, 138}, {813, 1076, 138}, {1457, 1069, 115}, {809, 1073, 125}, {
         5107, 3899, 1073}, {3494, 5109, 1076}, {3738, 5138, 810}, {809, 124, 
         115}},
         VertexColors->None], 
        PolygonBox[{{3899, 3741, 1459, 1073}, {3739, 3737, 1457, 810}, {3903, 
         3742, 1462, 1076}, {3741, 3900, 1074, 1459}, {4113, 3494, 1076, 
         1460}, {4112, 3492, 1073, 1458}, {3489, 4112, 1458, 1069}, {3737, 
         3896, 1069, 1457}, {3742, 3743, 816, 1462}, {3493, 4113, 1460, 
         1074}},
         VertexColors->None]}]}}, {{}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{3495, 5110, 3743, 3742, 3903, 5109, 3494, 4113, 3493, 5108, 
        3900, 3741, 3899, 5107, 3492, 4112, 3489, 5105, 3896, 3737, 3739, 
        5138, 3738}],
       RowBox[{"-", "20"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{3466, 3971, 3979, 4584, 3978, 4019, 4018, 4183, 4184, 4182, 
        4181, 4017, 4200, 3580, 4041, 4049, 4048}],
       RowBox[{"-", "40"}]], 
      TooltipBox[
       LineBox[{3473, 4601, 5181, 3642, 4777, 3643, 3883, 5102, 3474, 4089, 
        3718, 5032, 3885, 5029, 5031, 5030, 4098, 4864, 4481, 4482, 4364, 
        4366, 4365, 4487, 3729, 4560, 3914, 4266, 4267, 3539, 4139, 3540, 
        4268, 4016, 3541, 4196, 3998, 4507, 4508, 4255, 4587, 4588, 3989, 
        3990, 3752, 4205, 3976, 3977, 3999, 4000, 3892, 5147, 3893, 3631, 
        4207, 3630, 5185, 4057, 4646, 4645, 3533, 5174, 4395, 4391, 3663, 
        4389, 3662, 4390, 3632, 4762, 4763, 4343, 4342, 3515, 4123, 4124, 
        3753, 4234, 4235, 3503, 3485, 4062, 3487}],
       RowBox[{"-", "40"}]], 
      TooltipBox[
       LineBox[{3496, 4618, 4222, 4248, 5166, 4247, 5167, 3518, 4794, 3657, 
        4793, 3658, 4795, 3530, 3637, 5111, 5199, 3660, 5198, 5224}],
       RowBox[{"-", "40"}]], 
      TooltipBox[
       LineBox[{4870, 4871, 4869, 3733, 4872, 3731, 4107, 3894, 5035, 3895, 
        5036, 3732, 5045, 5046, 5042, 5044, 5043, 4110, 4873, 4783, 4784, 
        4782, 3650, 5047, 5048, 4614, 4615, 3486, 4111, 3488, 4617, 4616, 
        4880, 4879, 3651, 4236, 4491, 4492, 4494, 4493, 4505, 4011, 4012, 
        3970, 4014, 4013, 4246, 4245, 5207, 5220}],
       RowBox[{"-", "40"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{3467, 4067, 4592, 4591, 4590, 3878, 5026, 3877, 4172, 3547, 
        5123, 3920, 3744, 4475, 3712, 4473, 3711, 4474, 5182, 3644, 4778, 
        4779, 4354, 4353, 4855, 4478, 4479, 4359, 4361, 4360, 4484, 5067, 
        5068, 5066, 5070, 5069, 3798, 4925, 3800, 4923, 3799, 4924, 3935, 
        5152, 3936, 3822, 4208, 4026, 4027, 3925, 4185, 3560, 4028, 3825, 
        5130, 3574, 4161, 3889, 3686, 5125, 3563, 4761, 3628, 4759, 3627, 
        4760, 3928, 5071, 5072, 4928, 4930, 4929, 3734, 4877, 4878, 4874, 
        4876, 4875, 4886, 3761, 4010, 3524, 4198, 3525, 5192, 5227}],
       RowBox[{"-", "60"}]], 
      TooltipBox[
       LineBox[{3471, 4600, 4219, 4274, 4273, 3552, 4176, 4177, 3904, 4619, 
        4620, 4621, 3472, 4143, 3480, 3996, 4195, 4194, 3784, 4097, 4096, 
        4863, 3724, 4480, 5183, 3648, 4781, 3649, 4363, 3728, 4485, 4486, 
        5163, 5165, 5164, 3512, 4631, 4585, 4586, 4499, 4501, 4500, 4506, 
        5202, 5226}],
       RowBox[{"-", "60"}]], 
      TooltipBox[
       LineBox[{3543, 4647, 3544, 5175, 5176, 5120, 4377, 4374, 4376, 5104, 
        4375, 4503, 4502, 4884, 3755, 4883, 3754, 4125, 3538, 4393, 4394, 
        4392, 3671, 4806, 3516, 4009, 3656, 4636, 4637, 4638, 3659, 4250, 
        4249, 4253, 4254, 4252, 4251, 5218}],
       RowBox[{"-", "60"}]], 
      TooltipBox[
       LineBox[{4472, 4448, 3564, 5127, 5128, 5126, 4285, 4238, 4239, 3505, 
        3491, 4517, 3776, 4516, 3777, 4127, 4126, 4504, 4346, 4347, 4344, 
        3636, 4345, 3675, 4225, 4224, 4223, 4349, 4348, 4556, 4129, 4651, 
        4650, 4649, 3778, 4059, 4058, 4624, 4623, 4785, 4241, 4270, 4269, 
        3546, 4456, 4457, 4455, 4459, 4458, 3606, 4453, 4454, 4452, 4832, 
        4831, 4066, 3507, 4622, 4240, 4323, 4322, 3604, 4450, 4451, 4449, 
        4830, 3697, 4648, 3545, 5122, 4382, 5121, 4383, 4799, 4798, 3661, 
        5184, 4514, 3771, 4513, 3772, 4515, 3770, 4510, 4512, 4511, 4128, 
        3517, 4888, 4889, 4887, 4891, 4890, 3527, 4640, 3638, 5217}],
       RowBox[{"-", "60"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{3992, 3993, 3672, 4854, 3714, 4853, 3713, 4082, 4654, 4653, 
        4652, 4901, 4900, 3639, 4770, 4772, 4771, 3991, 4091, 3615, 4052, 
        4271, 4272, 4140, 4141, 3774, 4898, 3773, 4899, 4953, 4952, 4909, 
        4910, 4908, 4912, 4911, 3726, 4483, 3725, 4865, 3502, 3481, 4531, 
        3483, 5103, 4530, 4221, 3621, 4819, 4820, 4817, 3682, 4818, 3937, 
        5078, 5080, 5079, 3823, 4186, 4029, 4030, 3926, 4187, 3561, 4031, 
        3826, 4589, 4297, 4298, 4105, 3730, 4866, 4868, 4867, 3687, 4002, 
        4001, 4204, 3629, 4056, 4256, 3768, 5118, 3534, 4109, 3735, 5137, 
        3736, 3535, 5119, 3769, 4509, 4764, 3633, 5225}],
       RowBox[{"-", "80"}]], 
      TooltipBox[
       LineBox[{4053, 4809, 3468, 4598, 4597, 4665, 4664, 3551, 3931, 5150, 
        3932, 3881, 3882, 5101, 3470, 4402, 4403, 4401, 4400, 4220, 3620, 
        4405, 4406, 4404, 3679, 3820, 5129, 3570, 4697, 5189, 3787, 4907, 
        4669, 4670, 4118, 3557, 4672, 4671, 4680, 4679, 3559, 4681, 4682, 
        4628, 4629, 3510, 4630, 3511, 5113, 3908, 5211}],
       RowBox[{"-", "80"}]], 
      TooltipBox[
       LineBox[{5210, 3909, 4557, 4559, 4558, 3529, 4800, 4385, 4386, 4769, 
        4768, 3635, 3670, 5135, 3669, 3497, 3916, 5148, 3917, 3915, 5062, 
        3918, 5059, 5061, 5060, 3542, 4114, 5053, 3901, 5052, 3902, 4006, 
        3506, 3667, 4802, 4804, 4803, 3666, 4258, 4259, 4260, 4427, 4426, 
        4439, 4424, 4425, 4423, 4422, 4257, 3665, 3740, 5106, 3490, 3504, 
        3906, 3905, 4210, 4036, 4037, 4564, 4563, 3566, 5178, 4420, 5177, 
        4421, 4419, 4438, 4437, 4825, 4379, 4380, 4378, 4381, 5171, 5173, 
        5172, 3528, 4805, 4766, 4767, 4765, 3634, 5212}],
       RowBox[{"-", "80"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{3549, 4661, 3678, 4808, 3677, 4068, 4596, 4595, 3880, 5027, 
        3715, 4946, 4947, 4943, 4945, 4944, 3550, 4536, 4537, 4477, 3716, 
        4476, 3717, 5195, 5196, 4226, 5160, 5161, 5162, 3469, 4599, 3478, 
        3995, 3969, 4165, 4164, 3723, 4984, 3842, 4983, 3841, 4021, 4020, 
        4950, 3819, 4695, 4696, 3569, 4095, 4555, 4522, 4523, 4275, 4668, 
        3556, 4117, 4882, 3748, 4497, 3749, 4498, 3888, 4371, 3653, 4243, 
        4372, 4373, 3655, 5216}],
       RowBox[{"-", "100"}]], 
      TooltipBox[
       LineBox[{3617, 4084, 3618, 4397, 3674, 4396, 3673, 4217, 4216, 4215, 
        3616, 4332, 3640, 4968, 3836, 4709, 4710, 4711, 4162, 4708, 4707, 
        4967, 3835, 5191, 4744, 3607, 4857, 3720, 4856, 3719, 4090, 3582, 
        4356, 5112, 4357, 4355, 4603, 4604, 4605, 4602, 3884, 5028, 3788, 
        4276, 4673, 4674, 4115, 4881, 3746, 4495, 3747, 4496, 3886, 4524, 
        3789, 4277, 4675, 4676, 4119, 4120, 3750, 4231, 4232, 4233, 4613, 
        3484, 4073, 4074, 3891, 5033, 3890, 5034, 3943, 3946, 5154, 3945, 
        4192, 3944, 4583, 3973, 4581, 3972, 4582, 4188, 4150, 4151, 3974, 
        4045, 3588, 4998, 4549, 4550, 4488, 4490, 4489, 3664, 5040, 5041, 
        5037, 5039, 5038, 5056, 3911, 5058, 3913, 5057, 3912, 4180, 3759, 
        4885, 5188, 3760, 5187, 5139, 5206, 5228}],
       RowBox[{"-", "100"}]], 
      TooltipBox[
       LineBox[{5209, 5200, 5201, 4040, 3578, 4199, 4015, 4178, 4179, 3983, 
        4209, 4034, 4035, 3929, 5050, 3897, 5049, 3898, 5051, 4237, 4033, 
        3565, 4189, 4684, 4683, 4286, 4562, 4561, 4262, 4261, 3567, 4287, 
        4535, 4534, 4132, 4133, 3930, 5208, 5223}],
       RowBox[{"-", "100"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{5213, 5204, 3521, 5169, 5170, 5168, 4370, 4369, 4418, 4417, 
        4821, 4411, 4412, 4410, 4414, 4413, 3603, 4102, 4103, 3887, 4610, 
        4611, 4612, 4072, 3479, 3501, 4230, 4229, 3645, 4460, 3701, 4833, 
        3700, 5186, 4662, 4663, 4519, 3782, 4518, 3783, 4520, 4860, 4156, 
        3814, 4173, 3813, 4155, 4071, 4433, 3690, 4432, 3691, 4434, 3641, 
        4350, 4352, 4351, 4462, 3548, 4942, 3811, 4941, 3812, 4088, 5197, 
        4087, 4167, 5090, 3947, 5089, 3948, 5091, 3780, 4902, 3781, 4658, 
        4659, 4660, 4077, 4657, 4656, 4655, 3921, 5063, 3779, 4957, 3830, 
        4954, 4956, 4955, 4085, 4083, 3579, 4706, 4300, 3829, 4061, 4060, 
        4975, 3838, 4974, 4977, 4976, 3837, 4972, 4973, 4969, 4971, 4970, 
        5012, 3475, 4607, 4606, 4859, 4858, 3721, 4981, 4982, 4978, 4980, 
        4979, 4358, 4334, 4335, 4333, 3619, 4525, 3790, 4278, 4280, 4116, 
        3745, 4528, 3792, 4526, 3791, 4527, 3821, 4539, 5190, 3793, 4913, 
        3794, 4122, 5124, 4121, 4678, 4677, 4914, 4916, 4915, 4295, 4294, 
        3571, 4104, 3572, 4699, 4698, 3824, 4951, 4284, 4055, 3624, 4106, 
        3623, 4054, 3654, 4892, 3763, 4634, 4635, 3522, 4108, 3523, 4894, 
        3764, 4893, 3765, 4138, 4137, 5215}],
       RowBox[{"-", "120"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{5219, 4388, 4387, 4801, 4064, 3509, 4627, 4626, 3907, 5054, 
        3757, 4966, 3834, 4964, 3833, 4965, 3864, 5010, 3862, 5009, 3863, 
        5011, 3861, 5096, 3954, 5095, 3953, 4081, 3555, 4024, 3818, 4293, 
        4693, 4694, 4099, 3568, 4292, 4291, 4811, 4812, 4813, 4810, 4521, 
        4903, 4904, 4666, 4667, 3554, 4094, 4170, 4171, 3984, 3986, 5159, 
        3985, 3609, 3957, 5157, 3958, 3871, 5013, 3870, 5014, 3585, 4471, 
        3584, 4308, 4307, 3703, 4070, 4069, 4430, 4431, 4429, 4428, 4774, 
        4776, 4775, 4773, 4321, 4726, 4399, 3676, 4807, 4398, 4443, 4442, 
        4829, 3498, 4594, 4593, 4218, 3879, 5087, 3939, 5086, 3938, 3941, 
        5153, 3940, 4163, 3775, 4142, 3919, 4544, 3840, 4306, 4712, 4713, 
        4157, 4305, 4304, 4303, 3839, 4003, 3499, 3476, 3994, 3683, 4279, 
        4281, 4282, 3702, 4461, 5133, 3646, 4780, 3647, 4362, 3727, 4415, 
        3684, 4283, 4545, 4991, 3845, 4309, 4310, 4166, 3844, 4989, 4990, 
        4986, 4988, 4987, 5088, 4569, 4546, 4547, 4927, 4926, 3801, 4244, 
        4532, 5114, 3513, 4533, 3514, 4789, 4790, 4788, 4792, 4791, 3526, 
        4639, 4797, 4796, 5055, 4136, 3531, 4644, 4643, 3766, 5222}],
       RowBox[{"-", "140"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{5214, 3910, 5203, 4641, 4642, 4134, 4135, 3762, 5115, 3519, 
        4384, 3520, 5117, 4367, 5116, 4368, 4787, 4786, 3652, 5134, 4416, 
        3685, 4408, 3680, 4407, 3681, 4409, 4714, 4715, 4100, 4101, 3843, 
        4174, 4175, 3997, 3482, 4985, 3477, 4609, 4608, 4862, 4861, 3722, 
        4147, 4148, 3980, 3982, 5158, 3981, 3553, 3923, 5149, 3924, 3968, 
        4580, 3967, 4753, 4752, 4751, 5020, 5019, 4727, 4841, 3709, 5136, 
        4732, 3599, 4730, 4731, 4728, 4729, 3598, 3710, 4851, 4852, 4814, 
        4816, 4815, 3613, 5024, 5025, 5021, 5023, 5022, 4144, 4756, 4755, 
        4754, 3876, 4093, 4092, 4086, 4690, 4689, 4948, 3815, 5141, 4315, 
        4720, 4316, 5143, 3817, 4538, 4288, 4289, 4158, 4692, 4691, 4949, 
        3816, 5142, 4326, 4327, 3608, 4169, 4746, 4745, 4328, 3869, 4044, 
        3583, 5006, 3859, 5005, 3860, 5007, 3856, 5004, 3858, 5002, 3857, 
        5003, 3961, 5018, 3874, 5017, 3875, 5092, 3951, 5155, 3950, 4573, 
        5194, 4572, 4318, 4552, 4551, 4312, 4311, 3706, 4463, 3797, 4529, 
        4075, 4076, 3927, 4032, 3562, 4837, 4467, 4468, 4338, 4758, 3622, 
        4339, 4685, 4341, 3626, 4340, 3625, 4932, 4933, 4686, 4687, 4688, 
        4130, 4131, 3805, 4197, 4007, 4008, 3806, 4633, 4632, 5205, 3758, 
        5221}],
       RowBox[{"-", "160"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{4824, 3689, 4822, 3688, 4823, 3532, 3767, 4895, 4897, 4896, 
        3751, 4154, 3807, 4206, 4004, 4005, 3808, 4934, 3809, 4935, 3668, 
        4263, 4264, 3536, 4265, 3537, 4937, 4938, 4936, 4940, 4939, 3810, 
        5076, 5077, 5073, 5075, 5074, 4065, 4063, 3508, 4625, 4242, 3756, 
        3828, 5144, 3827, 4702, 4701, 4826, 4700, 4740, 4739, 3602, 4737, 
        4738, 4735, 4736, 3601, 4849, 3600, 4734, 4733, 4848, 4847, 3704, 
        4906, 3786, 4905, 3785, 4435, 3693, 4290, 4444, 4445, 3696, 4039, 
        4038, 4159, 3692, 5193, 4078, 4317, 4469, 4470, 4325, 4324, 3605, 
        4168, 4743, 4742, 4741, 3868, 3949, 3594, 4723, 3593, 4722, 4721, 
        4840, 4839, 3698, 4201, 4202, 4080, 4079, 3592, 4571, 3591, 4047, 
        4212, 4211, 3873, 3960, 3959, 3500, 4574, 4228, 4227, 4336, 4757, 
        4337, 4302, 4301, 3581, 4145, 4146, 3854, 4203, 4022, 4023, 3922, 
        5064, 5065, 4999, 5001, 5000, 3831, 4961, 4962, 4958, 4960, 4959, 
        5008, 4553, 4554, 4542, 4963, 3832, 4543, 3796, 4149, 3872, 4213, 
        4214, 3988, 5099, 3987, 5100, 3610, 5097, 3611, 4748, 4747, 5016, 
        5015, 4314, 4313, 4466, 4465, 4565, 4570, 3589, 4046, 3975, 4153, 
        4152, 4931, 3804, 4838, 3708, 4719, 3590, 4824}],
       RowBox[{"-", "180"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{3867, 3865, 3956, 5156, 3955, 4447, 3573, 5179, 4446, 4296, 
        3694, 4436, 3802, 5140, 3803, 3695, 4827, 4828, 4703, 4704, 3576, 
        4705, 3577, 5180, 4464, 4299, 4441, 4440, 4540, 4541, 4331, 3614, 
        4329, 4330, 5098, 3966, 4749, 4750, 4193, 3965, 4051, 4050, 3575, 
        4576, 4577, 4575, 4579, 4578, 3962, 3964, 3963, 3612, 3853, 5145, 
        3852, 4995, 3848, 4994, 3849, 4996, 3847, 4548, 3851, 4997, 3850, 
        3934, 5151, 3933, 4160, 3595, 5132, 3855, 3795, 4917, 4919, 4918, 
        3699, 4921, 4922, 4920, 4993, 4992, 3846, 4718, 4717, 4716, 3705, 
        4845, 4846, 4842, 4844, 4843, 4850, 3558, 4025, 3942, 5131, 3586, 
        4191, 3587, 4835, 4836, 4834, 3707, 5084, 5085, 5081, 5083, 5082, 
        5093, 3596, 4320, 4319, 4567, 4566, 4568, 4190, 3597, 4725, 4724, 
        3952, 5094, 4042, 4043, 3866, 5146, 3867}],
       RowBox[{"-", "200"}]]}, {}, {}}, {InsetBox[
      RowBox[{"-", "200"}], 5229], InsetBox[
      RowBox[{"-", "180"}], 5230], InsetBox[
      RowBox[{"-", "160"}], 5231], InsetBox[
      RowBox[{"-", "140"}], 5232], InsetBox[
      RowBox[{"-", "120"}], 5233], InsetBox[
      RowBox[{"-", "100"}], 5234], InsetBox[
      RowBox[{"-", "100"}], 5235], InsetBox[
      RowBox[{"-", "100"}], 5236], InsetBox[
      RowBox[{"-", "80"}], 5237], InsetBox[
      RowBox[{"-", "80"}], 5238], InsetBox[
      RowBox[{"-", "80"}], 5239], InsetBox[
      RowBox[{"-", "60"}], 5240], InsetBox[
      RowBox[{"-", "60"}], 5241], InsetBox[
      RowBox[{"-", "60"}], 5242], InsetBox[
      RowBox[{"-", "60"}], 5243], InsetBox[
      RowBox[{"-", "40"}], 5244], InsetBox[
      RowBox[{"-", "40"}], 5245], InsetBox[
      RowBox[{"-", "40"}], 5246], InsetBox[
      RowBox[{"-", "40"}], 5247], InsetBox[
      RowBox[{"-", "20"}], 5248]}}],
  AspectRatio->1,
  Epilog->{
    RGBColor[1, 0, 0], 
    PointSize[0.02], 
    InsetBox[
     FormBox["\"global minimum\"", TraditionalForm], {-0.995, -2.092}], 
    PointBox[{-0.995, -1.992}], 
    InsetBox[
     FormBox["\"local minimum\"", TraditionalForm], {0.5304, 1.2191}], 
    PointBox[{1.2304, 1.2191}]},
  Frame->True,
  FrameTicks->True,
  ImageMargins->0.,
  ImageSize->Automatic,
  Method->{},
  PlotRange->{{-3, 2}, {-3, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->446066285]
}, Open  ]],

Cell["\<\
This is a 3D visualization of the function in its feasible region.\
\>", "MathCaption",
 CellID->688017386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", " ", 
        FractionBox["100", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"y", "-", "1"}], ")"}], "2"], "+", "1"}]]}], "-", 
       FractionBox["200", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"y", "+", "2"}], ")"}], "2"], "+", "1"}]]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "4"}], ",", "3"}], "}"}], ",", 
      RowBox[{"RegionFunction", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"#1", "^", "2"}], "+", 
           RowBox[{"#2", "^", "2"}]}], ">", "3"}], "&"}], ")"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", ".02", "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<Global minimum\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", ".995"}], ",", 
           RowBox[{"-", "2.092"}], ",", 
           RowBox[{"-", "230"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".995"}], ",", 
          RowBox[{"-", "2.092"}], ",", 
          RowBox[{"-", "207"}]}], "}"}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<Local minimum\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0.5304", ",", "1.2191", ",", 
           RowBox[{"-", "93.4"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1.23", ",", "1.22", ",", 
          RowBox[{"-", "103."}]}], "}"}], "]"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->33096686],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFnHd8HMeV58cTAJESlZNt2ZZ9a3vlXa59692729vLt7e+28+OsixZVqJE
SpREimISM0WKlJhzEkkxmBEkkXPOkQCRc06TMMg5zO+jq/eqejBoDCTb98fh
U+hQ3VVd71uvXr2qrh7rojVLlyxftOb9dxY9+ZtViz5e+v47q5/85xWrRJTp
OwaDIVr873ncII6/Fkf8Hw1AXPDZ7qOtSVwD/xl+9g2xH4itWUQ+ovZGtf85
X/3QJ43YGr6vO/9L3i/T5fyA2BjF6V1qL+9arrvrXnXVYJKZ0TbwG1PcLTYm
XQrtOf4lM5inYw2cnu43e5+8ZMkSJcmvvPLSlXnqSTJn/V1r/JSc7zTLO2Xs
L3m3UuW0gM4s3usqv7/h/QqV3/3fcM8yVS8P+JRIE3sh3/G+epLZD+cZKXTX
f8GpraoMj/vsvz3Vv85i/LCfOnpMl5e+hE/NkdeDqiw//Jb0fzlH+vtUWZ70
IwvlO5cMC/zUrz4Pi64MP58jr/mqDD/VpQ/Qpf/ZjFqYB5928K2pXvLD/Oe6
lIG6lFwew/Mq5ULd3foWRalJrO9yqmdV6X7l5xlGJbOvlfiuVzaTsjC+eeuf
PU933exHp1k7+fl09TH13L/X5TRfl0ovFeul4d/qSqtp8L//s3L7hSqTvsSa
TfyPulzv1kuriazONXq/1t23QJXyP/mhR/FaXXzPb2rNkv4XXep7dPc96eXs
X6v/uy79Al36H3kJa3aaLv7TH5XqH1Sq3+juvld3N1sHw79Tef+LH4koXub5
dypP67fk+QO++zE/NexPg/XPvE93/Qm/uT2iyvK8LvX9uvu4z+VYs08bpz9K
/ZCKf+GPyuURn1iDj4V9WZf6AV1qqUWPqrs1u/o7XaoHdam+OyOVVhOv/VGp
9LQ0X+JNXeqHdPdJy/AjReUtP3cbFUSjausGrm06W/wNJTNo9T6jHfDTmQ7d
9g7tRXLOXjkNeuJ63WHSLLO+x3lTy80iIk7dUdEUodm7b86LSJi+lnfRnvP+
WjqNLP/Xch+g9vfq7rlbdz5fy4uKQBROFkEGI5XONF2+R7+1fPq7DZavtbvk
A1VaGTvnucV77ucuPuQa854rCQwBvjH/D/H68sx4EnFiXTtRBIug5Cuz1mr9
E9J8MKMf7f0zSfkwMX79/50TySD+hGTi4FihuOF4oeRwvAgCl8EsNiYdM02r
ZJud50PQt0X7EjX4YfigXvKvVWf97SX+Vk0jsuwYyhbje2eA93zmcyy6eK4d
P+WZcR/R4PtMRwuhCJqPaQQLQTCNtAk8UUg4ZdC1OB+tk1aM/RuLl9wMfv5t
oOyFeDQlstWTNc+hdyZlb2ZrsvkbGZpnktFiAnT3anlQmZXl4vMAqW1S88T2
yG2Yj96GkeEZGOIxRsd2OEAcnODgxaanxvKyJF5/b0bf8O3kAnS6ed8cxL6J
aqDfc8woJRVC9ksHC3CIg8FIG9PhAirK4dviUPAwCR58rwDBLdLsK7/mr0ht
8fUU59QTn3PfkbQmq9Gnh9Hktaj4u3z2LA9lpXWQPvLyOMzsq0lmr7T78ynF
AbE1io3poDgwSwIiWmyNQny2GUcIgBBeHNPWdExsAqQ2qObEje5hnUx/AokZ
9a5nsVCRNZhXLVz8+cLF4ujiwsVk4SxKFuOeXFGivbnYm0dBxO7Lw/48GIWI
JiEbS3FIyBcoxDqshSMsqCYcS2U+/g0azT6jHH8F+Gry3PpMz71bJ81f0eYu
K4vxwcLFWxYuPrBw8Rk+DVu42KSkMu7MUb6SOPkiB7tyRCa0Me/Owe5ckMDi
LiEyk7FIeffneWtU1CZLbPZKzDVZwFosaR67PVN7Z8s6HzN7D23v62Xr5XvK
R763Fi5es3Dxdk3EqwsXc5+0PVs+a3sW21uyjoYAcfIZhx1ZlPXObJg+p/u+
yPb15w0mIf+eHJafpDeY9uViX54kfiCPtVjKfThfSyflNgQeLYCQXQRfwQ16
ydnKeH3Ie3TS8byBWUr32sLFogItzH9zJjZlUNicgS0ZMomJDixb0rFVhAx8
moFtGVLVDYE7MrEzi8LnWZAS7hJboxDOKKQzWIRo+7iK9+dyrZJsXi2mLIR4
slpZNotXNtkUDfq2KOtTG2FKM6n9+dauyY/MP9V0cmOm0PwNGVifjnVplP6T
VKxN5d7NYP4kBetSsZ6DcUOqGFpuTJ1+xuY0bOEkn6ZjWzqB2J6BzzJgFCC4
nMRBVLyRMJh2Z0NWs0HO2wgU+zkwB2Gl8nCQq1fQMAoSJsHAeLRA3q5GFg/r
6vXe6dbrE2vC7FY7e5bMl8aPlQ01zNuYhXUZdMuaNKxKxaoUrEzGiiSsSJQJ
jCsS5J0Prkqk21YnYk0i1iZhXTLWJ2NDCiShzanEZmsaJJvt6QSGbUCmqi0B
RSDZky3bfA78EpE4FBHvWHgOGjyn4J3N1s9efjuV+3VUntCozN+ciw3ZWJeJ
NelYmYoVKViehA8TKNF7sdC8fsOji6MoanEklkTi3Sgsjcb70fggBstiKP6j
WKyIw8p4rIrHmgSsTcS6JIrfmIJNKSBiqep5gtUODoLW55mkRLuyiJa4JhSI
aZm9tAQrSUZgOsxB2gYfP1pvD+j+u/5M3dHPRj/ubX87CrGtAFvyiJW0a8uS
fO2cl9ODz172PHfF8/xVzwvXPC9ew0vX6bZXb+L3t/D6LbwZgkWheCeMIpdG
4oMoLIvGRzHcXg3z1idhQxI2JhOzLSnYyupG+pUu5N5B1skXGj+blCyQoGl/
+9kMkZIZSckCD+XBC+9Ivq+90WzILL9GkpsmA5+xiMWg60npyoM6bt5Z84C9
Jdh1B5Le5lzP+iyPtBBTjko46r29SSDyujzJPT0hvQ3nevMO9oZt6flyudtw
D9372Bu3sCgEi0Pxbjjej8CHkVgejRWsdqvjsCYenyRgfSI2JmFTMmEjq5WG
bWmQ5Hayqkk7bpLNkngZ95GmKVqsacwrwJeXhPXITLkVqXnTpGZdM81J6iEd
KW0e1WA+WolDFdhfhj0lUhtMrs5CVVvMaAGaW2QVI8s1Ge/uuemuP9tdcLA7
eqv7/AoXNcLnOzW9ZsqPWA95rCfw9Fk8cwEvXMJvr1BRXg/ColtYEor3wvBB
BJZFUuTHMVgVizVxM1iyCIb5O5jh52zjvsjk5poFL0jJUSreNEfv/L2vPZvF
SWqbNhemvccywv98i56dNmdssJyqxYkaHKvC4QrPgTKP8jwOFbaKXU1bofSf
F8BZBXsd2hpRTyBx2ya24zGu7qCuhrPu2wfccZ+6Lq90cmrywwO4mp/+Es+c
o9K+cgWvXcdbN/FOMN4NwdIw6VYa7pa8xNGWZGxNwaeprHtpkNy4Rr6gnliC
I2oMTnBj70rQMgqlm9UXzkFLmzfg8Yu4X3sLaJh/oVFZgTN1OF2HUzUecXyi
YuRUeZeyUIYH+x0lU13lcInWV4OOejQ30VNK2pFLqjMa4ei65mw801V4wJW4
zXl9tePYe3aDHNlx+/mRdcukdResB2E9SQ974QJevozXruHNILx9E0tCKPLD
CHwUiY+jsToWa4VGxWM9dyebkyAJbUslPKJpCkIingwaq5X0Hix7uTMQePbn
qB4zV7ZN06E8zX49BP9z1zwG5VGjdtWfP6x/gxegMTRdbcHlFlxqFk/9Q5Oo
g4sa0z/U9XNNsvGst1XY7KU9jlJ6cFclnNWwCcVqQEMzxRS1I4twjoTbXVcd
jWecRQecKZ85b611GKa13fB9629IDa1rx63bYd0N6yGIxvrMGbx4Hq9cwmtX
Ceo7N+n5H4RhGUNdGY01sfgkThHdlITNms5tT9X4iZbqRbqbfDTqIywSqT+q
03p3v1+7P8/bSv/4GQEZ9V0dZ++s1o020TMFteG6CK0URGRQi+dG86jU00cL
2usbHDVOV0Wfq4JydFfDVQNHHToalM6Wt+F2OzI6EU8a6rriaDrtLD7kTNvp
DF1PnL3vt6z/0ml9tVuyude6F9YjePokXjiLly/i95fxxjW8fYO74xB8GIaP
IgjyatUj3ycU9lMfhRVR0hQSXQ2w9PNIa9kWmhRggzYCmraC+tl92aL170BM
fxJpme57OtLyySEd3nxDOqGdh3Z4JOXHUjrdOZ2dpXbSWpe7drC7ZqK7hnW6
Fs462BrQxqyrW1HajvwOpNs8cYTbednRdMZZetiZ8bm0l14rFGB9jRqK9RNY
t8D6OZmKuyj+fqHDyyPwcRSxXRuLdXHsHiZik2YVpA5/xqOOnekwUodj9mrx
nizZoomwRRI+kKtZA70PGPinaKzP+ROanYiwwRhhh+bZGcyJjklxnO3sLXI5
2erfh+56dDXA2YjOJrRyh1LZhuIOYUmRZpuKZUxXnE1nXGVHXMzoXq2/esK6
BtZNsO6AdT+ePornTuHFr/DKRbx2GW9dY887GB+EYnk4Po7EKtHmY6jNi/gN
CdiUCGFIt/ropYgXhpTts1k1eeFLCz9VqKTycjSNFLJolvOuP4XRDF3zvt0x
R9oQZUe0AzEOGGOdcgZkQZILKV1I76Lup8A9WNrdU9vjJBq97YN9LVN9rFK9
TVJH74OjBR2tFFXXjooO3LEhx4ZU+2SMYzCEkjWdJd8me3eXvF31RA+Teu0k
gOLk2ZN48SxeuYDXLimAS+cAuJEBSm/7M+6ivd6NbNK7Z/jVWkctzaZh9lh9
us/507XtcU0Wk8An6MU5ZRM2PJHsRqob6d3I7EZuD91c3Dta1TvQ0NdDHPvt
gwOdEwNtnn7m1tuC7la4+Li9nbY1nSizodCObAeSnRMxzoEQl7QIFce7cve6
6dDreZqs6zQrcR+31PXx8OqZ1/6JC94+W/KSfQzJJZgRLzX2n5OTxds3++uT
tb7aO3Ywx9gR60CcA/FKsx4RsYJLmuDSg+xe5PXSo0r6p8r7J2sHRpsHBsWp
e9A9OOgcG7RPDVIfjL4O9LbD3Q5nh9S4BWi0odqOUgduO4UrjWTXRGxXfyhR
aT7nrjzRnX+g26BKwim+Z91DvbM4evFLvHIOr13Em1fwDo/s3g/GslDuNYRl
iybLJiIlwY0aQWncFME0GMntMSnX0CCn9omhwaJ8w+y57JqcBtLHTo8hYmyI
tTMxhyT2eHLX9Mgwqxc5AlofbvdTZNmAp2pwqn5wsnVoRJz2DA8MDfeMDrkn
hqi9YcCOPjt6bOiyw2Hn/O9BgwPVTpS6UNCFTDeS3eNxhMp5jfSy8hRttVUF
hoeeP4nfnsXvL+DNS3j7GpYEsSsTgmVhWCF5xczg5dU4g1EQ45Zh8VU4bkOk
ciY1BNF8Gx8PRlsBINuktq7D39s0KH9Hkeuk7OPsRI59vLukFZPkMnog4OX2
Ib9fyvbDyiFP7ZCnYdjTNjxB8EZGBkcGRkb6x4d7KftBNwa60OdCjwtdLjiY
aAtZMFR1ocSNAtbhFALWH97rCOojfqdp+32tTPPf+AMWXcHi63iPnUBSMx97
xr3QAuH+SQUTJzTw0MYeXm4intCpEYhPbyqZke7QMj/ZNn1XrvizWFovJu2G
YBZrQ5xNWa35kphooESsG1k9St0K+lE0IG3uE+2j1Cv0jI4PjI6OjI6MjwxN
jQwwsV7096CvG93dcHWzKetBMx9U9qCkB/m9og7E6Whcf39Ev+MGeRlVZykt
rZgJpNwflTq1hocdpFYJ2JBIzVAOZzdrswNbUzGblYFdO2mPJScSivtsmhv2
48nKESulsHwLNx9mHYjtnJ5FNyU6kOQUFkh5bAvS3WTzs3tI2QS3wgHcGaQs
KoZRM4yGEbSMomNMefrfHRmbHBsbnxyl9ovhIQwOor8ffX3oJk2CrQ9tfWjq
Qx2flnCWWQRuJG6gL2LQcZMMZs35Icrsx1q7vX9FJLlpq3j8tobHbyJ2Hc8L
CJw0QaXhFPGCKGuiWVKUSse+m0n2DiTmPKVl+jeEprm1bobH4fUu50W3Ezz5
F29Dgh1E0IEUpyIYIDRP7HJ6pjVPpqwcRu0IGkbRMsYERU8xjv5xDI97JM2H
MTKG4VEMDqN/CL1D6B5kiANoG0DTAGr5tGQIt4nXROrQcPxwb+SwI3i49doI
PeOnXh94VYxit5bZfZIg9dMkqRE4I2ni3bLdqtHFzN5VkbMo/Zvvl5zGZe6Z
OW3lJbfQgFj2/xU3O5IdyvqlszXPZmeDY+4V2MSubAgCW42GrZ2xucbRO4HB
Cc/IuGd83KN6hpFJQRKDY+gfRe8olcA5jM5htA2jiclXjkg2npzR8bTRwfjR
nuhRZ9ho641RbWWo9B/WMDLamteKQe69At46no5f79U9H/VT8y1MULZdyUhr
YQvm5DZ7fkXfagN92Blj2kWBBL84MeDsRIJNljYwzQVfeMIjKehTrfMnFUOo
Hkb9CJpH0SbRTaB7AgMTnuEJz+g4WULPuAdjHm6+UxicRD8NM9A1CscYOsfQ
OobGcdSOo3Kcbi4c9+SMj6WNDyaO98SOOyLGWm+Nayt/pX1ZxfRWCvNnXiU2
ptV8TiCNAqTBJFFypZPEpIAmL0Ampn9TIIndo/PS9D2pd8bT2zqZaLQY51sE
uth2xHUocJLO3alOpLuQ0YUsN3K6kdeDAnbn7vSjdACCnWzPjzWOqhI7xuGe
QN+Eh1RvgphNMjyMejDCCNlSomcCXROwT6BjEq2TaJxC7ZTMa56ncMqTOzWW
MTmQPNkdP+mImmgLnagLmqKL9NZ6Ph3ctyoWgh1NLXMDlvZvA49UN8sJF80p
JjH989KP9KdXmkW0IFKEVkS1qjpTcDqUxHclccsUfNKc9OSsLmS7vS3z54JP
yQDKB1E1hFruEkSsaJm2cYiW2U2EMDSBUSY05SU0DAwxnj6gewouD+wedHjQ
6kGTB3XMr5ST5HlGszwDqZ7uRI89ZqotnOnwmtnHxcG7EVAhHO+FY2k4z/hF
YlkUlkdhRTQ+jsFKNn9k+OKxzse125qszJqemdHLzGurTOFNCG9GBM3ECV4G
s8AV3YqYNgh1km0voRNJNiTbkeIgVEKbMruUds273YuiPpT0o2wAlYOoGULd
MD28dVSbGyFYogOY0PqNiXHP1BjTGgHRGpS8H0C3R0eLUFV5UEYHEwWekRxP
f7rHneSxxXlaIynS8Lda7b92E2/cEk94U2wC3rqFt4P5PUYozR5/EIF5sldI
1Ky9/t2lDxflg8iyCiqCSVQLvFC8RBIZSoodqQwlQ/MsAnO5XxRc7jCXcuYi
r/2kaQQCjLA3DjZTPeO0HRrH6DgmxuEhDYLEQlaoHx5uqb5Y6LTeg2qPpxyT
xXR1ONfTl+npSvHYEtDKL2totTKP4Z65gOf+QC8kXr6CV6/htSC8eQOLbuKd
W3g3GO+HYhlrlRxR0dA9FuvjsDEeczN62F8rJCiSk0F5+W1sidqpsUktSNZY
yTvuF40tx408dtDJGPWhlFmJY6FD9aIzG0HbCDrZQHeNyVweHxrD6BjGxzA1
BomKOA1AovJwVhIVHTQB9fBUY7ICEyV0aTAfvdkeVxrX4q9VbXPOD1mP0Uy7
9TSePYcXLtJk+6tX8Po1LLqBJbe46YVpo4IoQrUuFhvivJ7rbE6P+OEkrQ7p
USti2xgPE0rsQFKn0qx0JzJdyHYhtwv5TKewR7W1n1aRb4SGITQPM5sRONhm
94yhj/VJ+FVjo5gYxZQEMwRi0wdPDzw8WoCD49vgaYKnHpM1mKjEWCmGeZlw
D09ddaaiVb5y/aXyJr3vuUzWLZOqV+MZjFnfI+gpPKoYe7+cClCit5HoCSw6
exNPZTiQ5ZyW+3Y3ing+prSPtkLymkHUD6FpCK3D6GDxnKNwkw+EAaYwMoox
jp8SYg9iqh9TfaQSQnKPi8XuBEnejMkGjNdirAojZRgs1nTWmYPODLTy/MFf
q16E5wEssl+0LvJYXx+1vjks73/Aun7Sut1j3UtXrcfxzJc0t/i7i3iDX/69
ewPvB2N5KFaEY1Uk1kZBvhrzR8nvN1OExUtK9qpCSVJsSLUhzU6PyPThpWxt
cQ9Ke1Hep87n1w2gcVB168JHdIygawQ9I+gbwcCIsrtjQ5gYxOQAE+vFlCDG
w3GPXenKZDPGGzFWh5FqDFWgv1Qj5shDRxZaeEj3lCIW6K1p62JYX5+yvjom
qBGipeNyHtK6nYkdwrPH8NIp/O4cXr/EdjkI79/EshCsCMOqCI2Yfs2NJObv
fYfsjxLaVXNK6VSk0lmObG3cEljgRmE37vBYt6wXFX2o6lfXftw0iNYhdAzB
PgzXMNzD6GFTPMjbkUGMDmC8H5N9mGRSpG1OTPETJtox3oLRRozUYagGA5U8
9GG7YytAey6a5Ywnr89TKzS1tfTais1vXlNv8K5Mna+dq9kYfev7DlPSv6vw
2qBARalDo2RjStIC5fGkU6Ebd7oZUQ/Ke9W1xxsH0DKI9kF0CkRDcLKn0zOE
viEMsJ4N92OkD6O9GOPWO96FcSfG7RjnaZ+RFgw3YbBelaK7Eq4y2LkXa8tH
k3yXwyOwP2JFuEl3Pmu9OrfdJbx6VzLQr6qelftDcpXvpm3wLve1vgmDtvrX
+s4UxXykrlp30sFzh2W+bNu/VtaREnwcitXhyuHwXz/fV9aRZzXIp09spzpJ
5mpROWbYkeVANjuo+V243YUirhnZi1b2oroXtWwjxci5dYDrhmvCOYiuQXQP
oHeA5ipIiftkqodG3BhxYcSBETuGOzHcTlcHmrgu69Bdi64qOCrQWUoxLYVo
LEBdrld3ZzH2Q1Nbke1bJ965GAt81mJ/a538QDLducOnToRleQtcOR6Dz9Js
63pVV0/vpasvHcfvztDB25fw7lU6+OgWVoZiTTiXxX+d/MCfLX5U1o2sWmos
NnjrJZerhloMW82SbpR1o7wHompqelEnq6Zf1VdHP2z9cPbD1Q93P3r60Ms3
9PWgn2cyB10YdNCU8EAn+pXdv7u7Ee56uGrhrIGtEu3laGWz0lCI2oI/qV5m
tRkeAXgbyLd9jTB/9tcI5w7jwBeqajhl4NNLNKslK+WD6fZBZs+6S11+5ZT6
aiFwyWWKWn4DHwdjdRg+ieD60c/EyPrRf9M77VeldCCV3ghS1WTyG5kcB9WO
XAMgaueOmyaERe1U9KCqh2uH3eumPrTwBF5HH83kOfrg7IWLL7nZivW40dOF
Xid6Hei1oacTPe2qfc5zNcHZQKtdbLXoqEZrBZrLKE39nel5IX/fe3hJm2XT
kHXgz4b9cV82hH+FS0fVlw2LVqh7re/51ozJukarGZnndH8itzy/OOvbX30N
/EgXyz4SJRUVkNbJbcOGLLuqlTynajZFXSh2o9SNclEByn49UMd8G3vR3IvW
XrT3oqMXnRzp6IaTO1hXF83sdznR5UCXTZu/dbbxTU307ryzHu21aKtBSyUa
y1HPFVBd7Ldl8Epfzeb6xPNI+cciQdR5XDuBswdx8Ats28qe/xq8tQK/W47n
l+HpZey8fATrSljXwroB1k8p5rk9ePEgXjmK107h7a8o5v0rWH4dH9/EqmCs
DcX6CG3sqV/FL6k+6Y8qdbqpTFX1BgJrth25DgisBUy2yIXiLjW7WOFGVTdq
ulGr+D7W1IOWHlUB7d3odMPmhp0Nld0JhwMOdl3snbC1w9aGzhae5GikJTat
dWiuQVO16vtNVaWoKPbO15nUNxdmzef72qBGQj7aSzc/GXcRN0/jwlHSvd07
sZWZfrAWb6/G71fityvx3EomuBbPrsczm/HMp3h+J8W8fACvHsUbJ/H2Gbx7
gWKWX8PHN7A6GJ8IoOHYxC6if540y671rZKdoJjRiUzWzRyGmO8giPJqsQsl
XSjrgoBY6Ua1GzVu1LmVp9LoRrMbLW60dqGtC+0udDgVlwc6bOjoRHs72tvQ
1oLWZippcwMa69FQS8d11aipRFUFHZdznyq/aRWl+6FWOlPCJYSx3hjups1D
L23GS9vw0g68vItif38IbxzDolNYchZLL+BD9phXBmHNLawLxcZwbI7CpzHQ
9Os74oA4SBb/xp9u0UR5uheJjZFoPuADhU7cEUBcKHOhXDDpordp4kINb+u6
0NCFRheaXGh2ocWJFm1cP6/FhpZOtHSgpR0tbWhuQRMDqW9Qd1hqalFTg6pq
VFSivGLaSlIBn9S0/g4vgpYp7g46jXNHcfwA9u2h2E3bseZTLN+C9zbhnc14
awsMD+ssl2UWg7/wx4DGWOkdzKBT6YFgkGdHPjeLQgfuOFHsRImmJRUuVPJY
stqFGifqnKgXQc3uz2u00xtvMmidaOxAYzsa29DQgvpmbTxW04DqelTVobIW
FTUor0YpDxPusHJo7yB+QmX7mYio4gmrnFDaRl3CTWHjT+HMURw5iN0SxedY
swMrtuPD7XjvM4p5eyfe/gJv78Hb+/EOv0p/7yTeP40Pz2H5RXx8Gat52cb6
YGwMw+YIbI3Cthh8xlMZgbOo6X99gqixhtwlgGV1IpvXkOTZFLDbyuoHFjtQ
4kCZE+VOVPCcQyVpSLVD+lI1dtTaKNTxsKCuA7XtqG1DbStq2QJVN6GKFwRW
NKCiHuV1KKtFaQ2Kq1FUNf2ljZoAp3b+F1rJfloUg5xwpPKkTchFXD2L86dw
8hgOMY3te7FpN9btwqpdWLEbyxjj0n1YegBLD2PpUXzA6y2Xf4UVF7DyElZf
xVp+n74xBJvDsDUC26KwPQY74jR7HjCL2s98bI+BFmWltYPUrIORdSKnE7k2
pVEFdghqRXbcsaPYjhI7Su0os6vZoEo7Km2oEqET1SLIZWbGqjb15rqyBRXN
KGfXvawBpfUoEaEOxbUoqlGcCqroKhWFv9F5ioBnojwZRXHIiUQaa1f4Fdy4
iEtnceZLHD+Bg0cp8rOD2HoQGw/gkwNYc5BiVhzGiqNYcRwrTmLFaYpZdQGr
/4C1V7DuOjbcwMZgivw0HNsi8Vk0dsbi83jsStBYzW6X+l8qmf6SKr2diGVq
s/UBRI3VJd+GAhtuC4JForXddcemOjjxV2pDaSfKOlEu2nO5SHpveTstYJRX
y1tR3oLyZpQ1o7QJJaxhxQ24U4+iOvW92O0aFFRTfB5v5S+lkF/QkIeaLJSn
oSgRuTFI5/48MgjBV3D1Is6fw+kzOPYlRe45gZ3Hse0YthzDpuPYcIIi157C
2tNYexZrz2Etd2brr2DDNWy8gc23sFVUwjydDTPOYvXUXK3RktFOoLI6kN2B
HI2YJb8TBZ1K9kLyIYo6pc2700Hr50o6YCxRYwxLCS8NLW5BiQhkr4qFUpnu
NKKoYdoS31VQh4Ja5ItQg7waNk6Mia3rg+Kgib8XrspBWQYKk5Ebj/RoJPIw
OCQI16/i8iWcv4gvz+MY93Z7zuB+1uTPmOfnMfgiDrvisScRe5OwT3uPYZ7F
4hdz+UtpbUgXFW7MoPeIme3Iakd2O3K0ObS8DlpeKUJBB2530MpWgtNOS4mV
jS5qQ1ErBzZFRc0obEZREwqbcLtR8p6fX4+8Og61yK1FjghMI5u3P9Z0+J6W
MjSwz1SRi5JM3E5FTiLSYpHE3VtYCG7ckG/1v7/vPHafxxfnsfMCdlykq9su
YdtlfHoVn17DNjZB24PxWSh2hGFnBD6Pwhc82b8nHnsTsY9h7U/BgVStrZlm
MfsrX7tEepDaConLmKEsiiWLgeQwsVxikifI5aur5oI2FLSqYCxokbkUNKOg
iQK/r8wT+mLKq6dccsXWmFMnzgWg7Fpk1coEPIKgT05aqtFUiYYy1Bajij8w
vZONgnRkpyA9EUlxkvZPgoJx+SYuBOHsdZy6SrcdvowDl7HvMvZcxi6eb915
FTuvY2cQdt7EzlvYyQvkPw/HF5HYFYXdMdgTi738gnF/Eg4k40AKDqbiUBoO
pytgvrxm/7KR9z1HSisENtYVY7o4sGS0IpMtTFYbsknzcjRaudymxDavFaa8
FhjzmuUqqdxGGHMaZH7Z9cgmTlnKApkz2GkUWxEoZnqdUnMdGqtRX4naMlSX
oJyJFeYgPxPZ6fKeJ+K4XwqNxM1wXAvFpWCcv4UzvO76RBCOBuFQEA4EYV8Q
9nLk7lvYHYzdIdgdit3cTvdEYU809sZiXxz2xWN/olxXbIG2uloeKD/7b+ay
3/OSW5DSglQOaSK0Ip15ZLZq9imrFVktFLJbpI0Re2OOMD7m7OZpm27KFnY6
ILsBWTKwamXKOURjhqCWXqc8uTrIQFce85ajgc18fR2UH16G8hKUFqHotvJ2
H0tLQ1IK4hIRxfCCoxEUiSvhuBiGr1iPvgzByRAcD8aRYBwKwUGO3B+G/eHY
H4H9kdgXJR1qw/xDKayfaTiShqPpOJqBY5k4rq0CM87QsV/60zGSJKkZIiQ3
wygIGgU/flub3kLa1oKMZhWYWWazarmZTchspEB4xNaY2SDadQOlqVc00+sJ
j8GSVqdsZR3SFLyHvFpW24yaJtSw2a+uVY56WTlKSnGnWN7zYHYuMrKRmoHE
NMQmI4rfF4XE42YsrkXjUhQuROIcf+90OgKnInAiAsci5Nqcew/F4RA3xEOJ
OJyEw8k4koIjqTjKC6yPSWDMzHgiWxbOu9REcvsVZr5VMgpYBlOyV2eMKc1q
7NyMVDpMI51Ka5rWKWN6E8zpjfKu9AakN2ij3LR6pEpcgalaixQHIloGKg7N
HMpvLCtaUNmMyiZUsp9aUceOGHv1xeUy9X35Rcjhz4/Tc5GShYQMxKYhKhXh
3LndSkRQPK7G4VIsLsaqL8ECTsTgBL/YPxaLo3E4Gg/jEeFEWY7wgOBoMo6m
4Kiw9MZjAprpGJswwcxgPEGrW09mT0vKnoSX3N/60Tj5/WBiE5K0kMykTClN
yhNLbUKq/DzHLPam1AZJXXAyp9TLGkqpgwy82kXsTeKqMU1hzZCp+SvDeSXc
2EuFF9aE0kb2WdlhLa5RdbCgoAx5Jci9gyy2cGn5SM5FQhZiMhCVjnDWk1sp
6kvDeRfZu/wqHmficToeX8bjVAJOJsjWcUIAm388CceTcSwZx7lxHk/D8XSc
ECEDJzJ5vaT2WySS0q/nsv3xjUigliU2xkRxYEn00akkEWFOVjol9sk04k1u
0N5/s1LR1kIb6vST61RicZAkdC1ZtUqxp1uMxHZeav30E4TCZnALz2pCdhP1
NGKzQFzI01T/NjsrwlMp4oKR+8a+bWGtYntPQSXyK5BbhpwSZBUjowhpDDkp
H/G5iMlGlPz+w7DgRiqCUnEtBVeScSkZF1ldzyXhqyScTcJpETjGYDqVAuNJ
+ijqZJpWVqqZ+TNs3d/NxTSuEfHEVGz4i2vB1ZzYIH8bJale3pNYj0QikljH
ZbOIvTFJ0UpStLg9CmQpDUhl2yWUbxoYM5M1kduEPA4GYz5VWQErZ0EDCtR7
qXuUf8vjppwKZJcjsxQZJUi7gxT2bxMKFKOIbISxbb+ZgaB0XE/H1TRcTsMl
9sIupOJ8Ks5ROz1LfM54+ZDO0RyQ2cvn731smnz326BuNsYJHYpvkLFiL4Mx
oUH+Xl+CaoEJmjaZEhQZsedD2pgT66b1yCi4GlkVJS8RJZCleW2g7EOyqFay
ladyX24DcjVVzK1jp7cGwvnPrkIWT2FklCO9DKklSClW+dwfW4DofETmISIX
YTkIYbN0IwvXM3EtE1cycDkDl3gF5oV0nJdf1twL33XS+t9S9K6Gi2lADHVt
sarQcfXeUYopTmlNfD3iSTNoY473kT8gXnV6Yi8D27MEFStQURCMkrTmqv2R
ZpFVM2odhuhfMylO+SMGUxY/hzxdY5YwaAGZ1cioQjojSitHSpla95lQjHhe
dBFTiKjbiChAeD5C8xDCL9pu5CAoG9ezcTWL7ZNGRX4h+B/8UaGSR9dDBlOM
LI8lVuxjlT6IPR2yrLFKVhkngjFOeJtxsn3RscEcp8FROsWWXcAgu0S2n/tK
kqpe84bFrXels/cqtuk1SK9GWhVSK5FSKdvLPYllSChFfAliixHD4kcWIuI2
wgoQWoDgfNySv0Nwn5JX/hrDP8ylBVH1iFKVbYxWUop9DAkXI2Uxib0xRg08
xF4GqeexXFba8qFJiC2EjlMZsZokaEHqBWsE2XJlu2WdU89XS0HY7FpqVTwK
TKmGCMlVyjbdk1iBxHK6EF+GuFLEliCmGNHFiGQO4YUIK5zRAuRvuul/91Nb
F2owRdYhioPBFKWKrJ3P4FGLaBI/WkptEnvmYfLyMBgVEa8OxE9bkGkpE7mX
4sMkcX+SENKcVO1jVRKEks+Lr0A8SxlbhphSRJciqgSRxYhQVoF/A3KJ+tbf
8I/QrbgzRdQhkgMLyHoVWQtzlKpBsZeB+wexJ3nkF3nRWuXSSWyt1Gi+Ig7i
tWBMUDkl1EAGqQsJLEk81VZcpWgzFaRCLEh0GaJK+S6tZuRvRf7nubQyohYR
Wn9riuDy0NYoNuZISZr2XIrIGshgjJIlob0hMIorTVUd16FWZaJUtfAqrjFW
pIqTKU1x1dRqudeKrUKskCJGSGGKLkdUubceFygZ5G+L6n/HVdMuS7gqXzjL
EqG1mAjWbNpaIpS7JqOk5Y1UcVIkoZeyZAHRNar91UAGtiUx1aKEVTBGVylN
rURUhTzU+kZ+H2D4r3ORDqtBGGUdJp9jCVfPF3s6NIbL+EA/ZTXqymqOkqUy
R6sXXlFViCJtoI05qnJaz+9WZeM5L8N/89FgljG0BjJIfQ7jR9I2IEw+waQr
pSlc00FxEMFB6ApdiGCdpK0xslp+/yL2xkjFK7LKK818VSb5i9b/g8vi5aV8
fLMqkylUliMgTEkaVj1dg1pceDXCSZ3EhtNGqHixj6DHi41JPZcq5q/5uf+T
thbf51K+gSEqj1CVh9jToTF0Ot7kU5Yw7xtHWTDaGsXGSAUyhbPQ4QqB9r2L
/M30f/L7fFNwteIbwvnR1hIieXKUT5nMqkwmsTeGVqkarYIM2i/e0BN5jGD4
X6r2tRWSluBqmUbsZWDS2lPEPsQrXQhLQtuAkCrvl8KUN3s98veLZ0ljuUVP
CPaxu+ZgBUPs6dAYLEtqCVbll/HqGYHqGf/I+f1vv88w3qpSxG5xGWlruSVz
5Sifp9HTtXxJE7itGv7PLA1kq3JTlUjkIQPT0XKUD+PDAFVK1mT+nWSNMl8W
+XBWN+Wzae8bb1TxWi7/zLn860xZxfUbVdqv1dzkR9OWyqh9aUZp+Tea5e8+
z/iV/oAb6pk3KiGC99fG6aan+Zan9VaL7rhR6f2tfbqTf8PZ8MwsWlpulPy3
fM+zmF6RSrfybyjzb0CTSK/LQn3n/wLzIshE\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->828546970]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options for FindMinimum", "Subsection",
 CellID->396232162],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " accepts these options."
}], "Text",
 CellID->3902796],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["AccuracyGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AccuracyGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the accuracy sought", "TableText"]},
   {
    ButtonBox["Compiled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Compiled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether the function and constraints should automatically be compiled\
\>", "TableText"]},
   {
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "expression to evaluate whenever ",
     StyleBox["f", "TI"],
     " is evaluated"
    }], "TableText"]},
   {"Gradient", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the list of gradient functions ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["D", "MR"], "[", 
         RowBox[{
          StyleBox["f", "TI"], ",", 
          StyleBox["x", "TI"], "]", ",", 
          RowBox[{
           StyleBox["D", "MR"], "[", 
           RowBox[{
            StyleBox["f", "TI"], ",", 
            StyleBox["y", "TI"]}], "]"}], ",", 
          StyleBox["\[Ellipsis]", "TR",
           FontSize->10]}]}]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "maximum number of iterations to use", "TableText"]},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use", "TableText"]},
   {
    ButtonBox["PrecisionGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrecisionGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the precision sought", "TableText"]},
   {
    ButtonBox["StepMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StepMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate whenever a step is taken", "TableText"]},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the precision used in internal computations", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->418523506],

Cell[BoxData[""], "Input",
 CellID->832328712],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option specifies the method to use to solve the optimization problem. \
Currently, the only method available for constrained optimization is the ",
 ButtonBox["interior point algorithm.",
  BaseStyle->"Hyperlink",
  ButtonData->"interior point algorithm"]
}], "Text",
 CellID->167853318],

Cell["\<\
This specifies that the interior point method should be used.\
\>", "MathCaption",
 CellTags->"b:0.2.1",
 CellID->117718009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], " ", "+", " ", 
      SuperscriptBox["y", "2"]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
       RowBox[{"2", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"y", "-", "1"}], ")"}], "2"]}]}], " ", ">", " ", "5"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<InteriorPoint\>\""}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->741406091],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.14923897078500575`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.15095891732107203`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.355598616513416`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->8522603]
}, Open  ]],

Cell["", "Text",
 CellID->399254837],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 " specifies the maximum number of iterations that should be used. When \
machine precision is used for constrained optimization, the default ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MaxIterations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxIterations"], "->", "500"}]], 
  "InlineFormula"],
 " is used."
}], "Text",
 CellID->87871122],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["StepMonitor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StepMonitor"]], "InlineFormula"],
 " is specified, it is evaluated once every iterative step in the interior \
point algorithm. On the other hand, ",
 Cell[BoxData[
  ButtonBox["EvaluationMonitor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluationMonitor"]], "InlineFormula"],
 ", when specified, is evaluated every time a function or equality or \
inequality constraints are evaluated."
}], "Text",
 CellID->631575790],

Cell[TextData[{
 "This demonstrates that 19 iterations are not sufficient to solve the \
following problem to the default tolerance. It collects points visited \
through the use of ",
 Cell[BoxData[
  ButtonBox["StepMonitor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StepMonitor"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.2.1",
 CellID->455952803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"Reap", "[", 
    RowBox[{
     RowBox[{"sol", "=", 
      RowBox[{"FindMinimum", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          FormBox[
           RowBox[{
            RowBox[{"-", " ", 
             FractionBox["100", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"y", "-", "1"}], ")"}], "2"], "+", "1"}]]}], "-", 
            FractionBox["200", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"y", "+", "2"}], ")"}], "2"], "+", "1"}]]}],
           TraditionalForm], ",", 
          FormBox[
           RowBox[{
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}], ">", "3"}],
           TraditionalForm]}], " ", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "1.5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
        RowBox[{"MaxIterations", "\[Rule]", "19"}], ",", " ", 
        RowBox[{"StepMonitor", "\[RuleDelayed]", " ", 
         RowBox[{"(", 
          RowBox[{"Sow", "[", 
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], "]"}], ")"}]}]}], "]"}]}], ";"}], 
    "]"}]}], ";", " ", "sol"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->541813507],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"eit\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The algorithm does not converge to \
the tolerance of \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(4.806217383937354`*^-6\\)\
\\!\\(\\*StyleBox[\\\"\\\\\\\" in \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(19\\)\\!\
\\(\\*StyleBox[\\\"\\\\\\\" iterations. The best estimated solution, with \
{feasibility residual, KKT residual, complementary residual} of \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\({0.00030547793739526754`, 0.017330383318553164`, \
1.1484045252538722`*^-12}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\", is \
returned.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/FindMinimum\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellLabel->"During evaluation of In[9]:=",
 CellID->75949714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "207.15989660077344`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.9948180049924225`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1.9922972888813955`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->371786669]
}, Open  ]],

Cell[TextData[{
 "The points visited are shown using ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 ". The starting point is blue, the rest yellow."
}], "MathCaption",
 CellTags->"b:0.2.1",
 CellID->656288743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", " ", 
     FractionBox["100", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"y", "-", "1"}], ")"}], "2"], "+", "1"}]]}], "-", 
    FractionBox["200", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"y", "+", "2"}], ")"}], "2"], "+", "1"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "2"}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#1", "^", "2"}], "+", 
        RowBox[{"#2", "^", "2"}]}], ">", "3"}], "&"}], ")"}]}], ",", 
   RowBox[{"Contours", "\[Rule]", "10"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", ".01", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"pts", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}], ",", "Yellow", ",", 
       " ", 
       RowBox[{"Point", "/@", " ", 
        RowBox[{"pts", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ",", "Blue", ",", 
       RowBox[{"PointSize", "[", ".02", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"pts", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], 
     ")"}]}], ",", 
   RowBox[{"ContourLabels", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->214909321],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxsnXmgTdXbx8+999zJPBSFSFEapFSoaB8lpTQQEjKngYwlGgwpEhJJRSRJ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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlj+MVFUUxu/szrzdefP3zbw3a7muf2IDuwxbWKidid3uEoUSYgFbKIbl
jzEBVgMCVhYuFv5psVFQMbaWdhorTQyJosaI2iigQFC+X843obi5d84997vf
Pd85582Dz7+06+BUSukbjWmNm92Ujhcp/VpLabmR0qCV0pzmt/KUXqiH/boO
PCbbwVrYT8rele2Q1nlHOPXYxx+fc5q3spTO2P5mFnsH2ildaYf/iuyFMH6r
xd6LvgufljD3a17UvAS+fIdeDzqBe9Z3YX/UPv/msZ439hn7gLO9E3dxftFr
5rH3GDs0rsl+XncPFYc1YdQbYQd/7LPTto29/l8xfE0xzOXf7qX0xCjec1G2
DzU2sogHnOF0qp/SGxqbWn8h+y/CWDP/jHuly2ojYgSfUvMPsh/X+g/h/a5x
MQvbj7ajCb/RBRx4w60j2zMzKS2Yc92Yr+j+Y4Pg+bNso0bgEHc0JX5f6Z5e
L3hyD/jc87Tw+q3IF96GpnXZT8j3Uhn5Qgy32pFPfwln3A+ftmLT1ZhpRTzw
RaMHZCtHEfdC80/9wCcG260LvFrOt458dhcRq1d1z2Y78hHbhW7YH9b6oSLe
x1n2C+ctOrDeyOM8NjBYoyM5vOn15SxqompEfg2dY8QBjuzBd24Uv3nHyG8Z
N1Pa65gTD+JCXqFf1gg98DvvWD0ivpeKyImxc5L3kx/YTtSintCNuuHswFpU
5tKZijwgx4kt+9y9W1wG8BqFfpM3E4sjecSC2L5XpfSOxlYeNTd0npdegz90
LbImR54cRZ4s2A/7VecndmqCnIM3Z0vHkNweuB7Hevef8tnXCLxTrpGn4NwL
TdhfKsKHvP48u38n87zxSsfhTh6xJs5oyxvRtEKjXmjxpfC+E25D+HuaEas1
58Zh+1OX1BX4dZ3boTPVVPBAX9bHhHG0ijPUxRHHE93ARrtdqo8a53XPejv6
HXZqC87oxh45R02uGn84FXp3XS//6f67RfQPesxH7jOl84C37+xH7dV9jj3i
zCiMM7I/tV9ZD9ZoT6+f9OT95sl63fVOLR5wP6cHcD9r3rpufziDw/1rfg9v
wbblbwk1Dj6cwMzd/6+L+40iNG4Phd2Ls+iMbd59i1jB/Ybq/t0qOO9sRu1R
Y+h8swhN6dOpF5rSfz5oRg9a7kcewJ1znEdTzvP7mmPytjlzJ/U/Z33G9j+t
nnq2H7l6WvP7VZwhr+jFcH9dPrO9yF9qcsF68R3mDfD/R/PL8nvcOT7bcu61
ghu8LiuXPivjDdiWzYF85xw+3/ej59JvyeEZf1+e1bnnyjgz6z3w4U69Tfrf
OX+zqJ/MfQwdthWhBffAib3Jd4L4EJN91hrbVX+nbuVRk+DRl6dboeGs7myO
4jd1dss+h8Vxo4z4kVPoQ+5Rm4dcX3cV46/F+3YeOs+5rsEAi/eSTyvun38X
UcPEin6OD/3tiusR/MUicg7+t80HHHopmqE78x7rR49ecX3tdZ4TqyX/Z6An
fVzGN5J8+1TrTzQuNKP3fOv+Q+8BE2z2+P+E/6r/I8B/xfisJzzIn3vdvv9b

         "],
         VertexColors->None], 
        PolygonBox[{{3841, 4593, 1715, 2353}, {3859, 4560, 1684, 1160}, {4311,
          4147, 1028, 1029}, {4593, 3842, 1861, 1715}, {5530, 4228, 2710, 
         2708}, {4605, 4389, 1509, 1727}, {5628, 4304, 2811, 2809}, {3858, 
         5299, 2471, 1159}, {5203, 5204, 2356, 2355}, {4233, 5721, 3042, 
         1151}, {5205, 4595, 533, 2356}, {4727, 4313, 2820, 1848}, {4303, 
         5628, 2809, 2810}, {5493, 3839, 522, 2675}, {4525, 4215, 2676, 
         1650}, {4232, 4388, 1508, 380}, {5234, 4322, 2829, 2391}, {3851, 
         4555, 1679, 1320}, {3842, 5650, 2832, 1861}, {4146, 4526, 1650, 
         1028}, {3848, 4596, 1718, 1864}, {4304, 4588, 1710, 2811}, {4397, 
         4398, 1361, 531}, {5654, 5653, 593, 2835}, {4555, 3852, 1133, 
         1679}, {4726, 3830, 487, 1133}, {4316, 5643, 2822, 2824}, {4313, 
         5203, 2355, 2820}, {4587, 3831, 1848, 1710}, {4226, 4558, 1151, 
         1150}, {3863, 5235, 2391, 593}, {5651, 5649, 1332, 2832}, {5721, 
         4232, 380, 3042}, {5646, 5645, 81, 2823}, {4387, 5640, 2819, 1508}, {
         5531, 5532, 2708, 487}, {5297, 3851, 1320, 2470}, {4215, 5492, 2674, 
         2676}, {3840, 4740, 1160, 522}, {5655, 5656, 2835, 1332}, {5641, 
         5201, 1302, 2819}, {4560, 3858, 1159, 1684}, {5300, 5296, 756, 
         2471}, {5201, 5202, 2353, 1302}, {3750, 5629, 2810, 81}, {4597, 4316,
          2824, 1718}, {4527, 4148, 1029, 1509}, {4400, 4399, 531, 1376}, {
         4322, 4741, 1864, 2829}, {5492, 4214, 2675, 2674}, {4401, 4402, 1376,
          533}, {5533, 4226, 1150, 2710}, {4398, 4606, 1727, 1361}, {5295, 
         5298, 2470, 756}, {5643, 4315, 2823, 2822}},
         VertexColors->None]}]}, 
     {RGBColor[0.351594100579226, 0.158560405038418, 0.611188358344026], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmM1dUVx3/zZnnz3gzzlnkzIMMqpZCqMAN1KGvtCIikUUprccCFDluD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnuwjWUUxl/nnG2fvQ/723ufb28iykg1qdxKZUgjDtM0NKLQjKSkqRkS
juFQmuQSJ4063fVHhRmEOEIxcim3iWm6TvdSp0K5UyL9np4/1sxa31rvWut9
11rP+tqMHDtwTEkI4TWoDLojF0LTYgipihCKjUNYitxQCOH7dAjjkI/mQzgC
RY1C2JoMYRL86UwIB5FbJ0I4CT+VM72w7Yp+cjaE7vibi79bCPAHcmf0R7Dd
hs1HyMty9v0WVBdhg88tnN0G3RuHsBp9e5LsncIGfjmURR6Jv86cP4Zcz9nx
0F3wm6Dp8C2hFytDmI/NM9g+UB5CDfw87jOT+wzF3+PYnifnm4nVD/uhxJuE
fiL6UZwZizwGmgs/MOXYK3KOpRyWku+N5Bs4vx/am/WddJcS7rgD22uQJyDP
hWrwPRl6EH+TifEx+jiy7zr0PfD1HjQ7aZ+n0bfk/ZrxfqOI9wS+eiDXIlch
V3C/X7HfiO030OsZfxPfgL9hse+ku3QjxufwSeK14uxu5Erlj7/5+OvDtxi+
OVRAvpb8q/OuoWp3HT7vhj+R8d368a0JsTqQ42Hkb5OudRN8titxzU+hKyL3
R7eefHYiJyLnMg+5Hf4vzTvX0UnbFvARV/jMSexPQK3x14YY3Ynfkfe7nLe7
km9t0V0CzSGXvsg3ob8efYe07/gjvv8mx33Ufg3+vkD/JdQCXxdAZ9DdzvlM
I9v8lfOb66176k7YfgddBr+usXutS9Zn1XOlkd9Ad6+CZhFvZt65nW/sWTiV
8dtpJo7y/veQ3zDyqy11L0yDpqTdEyFyT6oXe3NmEHwt/gbobbEvQ3+cb2vR
9+XbHOQf0K+Gr4f6aPaQy+C3424B+oPIm5HX8ebdiHUD1LLUb9SA7gC0CX2O
bw+T3zhosOpDPgewXQwtxPantLHgE/Q7UsaElfDTiFHBfd/g2/3U7gz+LsbX
rU08i8t4n4nlnsm3Nc+xbdUjyn125NroDs3hJ8SezeElnt16zteUe4Y1i4vI
4dW0Z/Jp+FqoBfGqOHNVzjVRLf6kRq8UjEnCojrOnEP/b866fiXGgpGxsUWY
sAX5GPLvyBuQlxN7KTQ84TsszhgjhY07EsbCD7F/N2VM7Al/OG/sulB4Veke
Uu9Ucz4it72cXyB8JP5B+EOaiYQxdB+25wr2rW+FyBghbFBN7ov8xnrbPZw/
lHdMxXqfmL/lXVPVUpggLH0uMlYLUwdjOyg2VquHnorcY+qtJHSW+FeT8z9J
v/ks5Bl59+II3vsFdL9kjaWjoY45Y7qwXBiwMe8ZUO8Lw+ZkjVnCKs1os8iY
ICwYQs7lyE9i3yXhGb+T3IbExoaL+PYI/PjYtrLZBb8H2pxyD79DPmuhrqXu
4TcLxmRhsXpkIfIM4k8v85urV1eph1Lu2Xr4NbGxT9+eR/8B8oaUa9qeXK/I
+W3U07tjz5xmTTkIS4TxwnZhSkb4B7VNeIemsI2Q0xXGkM84vyQy9u6CmsKP
it272nFn4Q/wbVGpa7BTsxa71sppRMEYLOwVhryE7Qneb1WZZ6C64JnVrGqH
dYbvVPAsCTM75Ywhwg7t4Kno0sgPlRmDtAtUc9VaO2Ei+uqsd6125JKCMULY
IExopN2F3FH9r/2UN6YLy3tBA9DdFpvvQH7HY2OgsE8zJuzdHhubhMHD4R8j
xtS0cyoWvZO0i7QTdNetBc+m7ryO2q+v9K5XD6zEX7ucZ1s792VhRcGzrx5I
4au86F2hnFWrr7PeLapZJXK+6LtEFZ79FZWeXWGAajml4N2tmj4qfOQNatLO
WbxqrNrqm7D32cizKQz+FF3/2G8hDG2Gv/3Ez1V45/6c9YxptrTz/9cVnYts
0vBfZT0bwvhWyA1Z7yrtiKqcd4CwXz2kfwVhjrBG/wz/ARZwTqw=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.438363735751029, 0.309429367160478, 0.733153577361909], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHtwnFUZxr9cNrubbLKbfLuhF0qBpsy0UIY2pE2hFFrGC3K1rRTRKcpt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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmeMlVUQhg9ctsLdW77vLiwdQRIwGIorvSwkKlJEJICIqBSVLlIFgShG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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.525133370922831, 0.460298329282537, 0.855118796379792], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2QV2UVxy+7v/3tb1/Yvb/f3bu4AvJm0CIhBIuOAqkwNSlUEiq+ICgC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlleMllUQhg9b/91ld7/9v/2W3gRBShAU0NCkRUNTQZrSUUC6cEFRARGk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         "],
         VertexColors->None], 
        PolygonBox[{{5751, 4419, 957, 3533, 3496}, {5756, 5770, 3603, 1798, 
         239}},
         VertexColors->None]}]}, 
     {RGBColor[0.599172362955353, 0.584365453118782, 0.910304646534865], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuMVeUVxQ8zc+/cuTPM3HvPPSPF0oS0ATQYqfaR2LRQBayAohUfwFDB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsVVUQx0/b19u+19J377t9ZVFMigrFlBBFMNEIKhQNEhYhSkuRliKE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         "],
         VertexColors->None], 
        PolygonBox[{{3777, 5753, 3581, 3590, 1800}, {5756, 4996, 2131, 3610, 
         3602}},
         VertexColors->None]}]}, 
     {RGBColor[0.662968122596409, 0.68686748750303, 0.911758993361056], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuw1VUVx3/3dV73cc7vnHsucLUpxSlR0VA0n3gZXioqTfgCBCZeCsm9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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQ1WMYx9/dbc9l65zf+Z3Lbm2M6wipRC5FaadsN9WMSrUkRJG1Wwlp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         "],
         VertexColors->None], 
        PolygonBox[{{5752, 3786, 714, 3510, 3505}, {3979, 5755, 3596, 3600, 
         1974}},
         VertexColors->None]}]}, 
     {RGBColor[0.726763882237466, 0.789369521887277, 0.913213340187247], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmguwllW5x99939+3v/uFc0RFAUERw4N5ptS47RQ8JMomrh5RQDGO3GpK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twVdUVxk9yQ5J75d5z70lurKAgIFTerdAWRR6JFlBIiRQCQRKQl0Dk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         "],
         VertexColors->None], 
        PolygonBox[{{5264, 5265, 3643, 3635, 200}, {5759, 4099, 2563, 3665, 
         3663}, {4100, 5759, 3663, 3666, 2564}, {5675, 5763, 3445, 255, 
         2886}, {4679, 5754, 3592, 3593, 1803}},
         VertexColors->None]}]}, 
     {RGBColor[0.787712815953649, 0.855362117291888, 0.902794368929399], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmUlcWxx+/M5c7cmblz9zsIcWFAMJq4RI1BJaKiEY2sKi4MKKBiwBjz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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUVdUVxu+8N8zMG3z33tdGVARpYwGUqMtFFhhpKqIEMyooNTYkEJUU
jSLFQVCMGqI0EUwkQVkqTZEAIkiNkeYgIA51UIxi1ygygpDf5+cfe72zzy5n
n3PP+fber9lNd1bdkQiCoFdREBTzG2aCYEEYBAXGtzUIgiFREHSvCIKXGgZB
DYpjc+ihk0X/6rIgGBAHQQS9mwyCS3HwOeNkNgjWlQTBzdiPxNeb6SBYhHzW
SUGwGdkWaD/ydqzxA/qt8XmkNAjmov8Y441aH//98X8qa50CLcL3dmgdst0E
V1MeBDvRX4psWcaxVrNGC+JN4H8N/iczl0T2RexY1kNXIl+Bj0XsZS70IHsr
w98OZH2I8zb4OmJ4Gl+9iPcxdB+FxhBrdcpnsR7/Lzf0mfyNcSU+byL+G6Ey
1vuE9Vax/pv4PCkfBDn4hsT7Pvt5G/170J+D7nNQE/iz4Qcz3ofNfaw1KvRZ
NSaeNdAf4AfCryfe+9BvLH/46ohNBeOXsW+F7T5i/ivyCuhudHsjr2Z8GTE/
R6xtkZ8Nfw60VnuHZhLfU9B2xo+yvxvxNQgax/gN5qqwrY+8dg0+hsDvxz6J
rypi+oSzOoT8a/RfI6ZdyP4B1et8Wf8iziOH/4+RfcN59GUv7aCFnGd3/H2N
/UR8NmVuGjo9+R2Zti/5vBDbC6D2fPsQfhb73Z3xt9Sd+Aj7o8hfRX8ZdC7f
8hp0ruC8W0Fz8fd35BOx3YzNdvTvhR8AfwvxTWP8BOvvYc3N+HsNfhz7WYB8
PtSEtU6HdrGf09lzNf5GQx8S/7Psvwp/10D/LPWbaYV9JXSMWI5CXYnlXvyV
832a4f9yzqZ71nd5Mf4aoFsMHcR/Lfrb8H0CeQ3+9hPvl8iewcdS9vJf4rmc
WJaiMx/dBvgcgO+xFb4n+kZNkA1lvA75VGgD8g/x8Rj+hrNea3yfz9wd8J9g
PwXZr+EfwPdYaBy24/Gxnb0dYT/n4nsR64/We+B7/Qz7Zsw1Z7wD+2r2/mJs
LOgFPRH6DuvungZNxf9m+FOKvMbjsme961m/D9QG+w/gv2dcD81H/wXoEHuZ
lXIsD+BneOCYNoWOSbE0wmfA2g04+CdZexUxfo7t3shndRBqg+44qB92VzT0
W1qd9t70pirhx4b+ljozYdWGtL+NMGsS8SWxD7BN8z12p31HdTd1X97TXWD9
Or7P/cQzIvQZaO+643cwvjP0WxKG9EL3W+hL9I9hX0L85+G/Cv+r0InhQ+FV
iTF1CeP96O9Ev2vC70TfWN9W72UVspXQ8/hagk4946PQYcbHmRtP/A9CIWf7
e+K7ivM/Cl9T5rmbIp+RzkaYWOD8KqBurH+I9d9hrdfhX2K/dez/APdvJ/43
4j+Dv99GxgRhwQ7sL0beEZoR+E7r278HP7vEd6Bbxhgu7E4ydy/jFtDyMr/5
4Yxv5ezqAs+dQL+N8ChhTK3M+Mx11hcV+7uOThtLtIceyK+DCuimSjxeiE5N
A8+NgA/13pS78NFXWJP229AdE5Yugq5KGlP1dutj5xK94Z7Yj2TuK+I5yvq/
gp8TGuszyOfi67u088lidHZz3vughZx1ET7H5415+na3c6b9kC3H/17OszE6
HXL+5vrWwvi28M/BX1nmNzI0co5SbtqKzh6+xS7o3WLnxDTxLCGeiexlEzGs
DX3mOusadKbgKw+l8DcD/khkjBe2H8amnni+g5oQ60bWq9LbLtiXMLgL8XeF
mhH7GcJndJciX8jas4jnI/z9mbmxxc6hS5DNwMcC5POhH3T/hAHItuB/KeNl
yhfEN0c5iP2+Hjv394OastYZ0GHG30KH8PcRdAH++8KvxvZ61nw9YYxqjm4L
qB7ZEWhk1jlTufJiaBi6TyM/OemcV8RaJfgrKnfNIWybzJmh8iPGKXdeFjk2
5dAI3RgqK7fOZOLdHhsbJrCHHeieh7wS+RjW6IL9eZFz7XTsn8L3qcSzC93m
2LfJGpOFxZ9Cz4a+U7pLE4g/jewkaHrCd/iXsTFE2KEzmIzuFKiWcWWRa68D
kWsp1WDKvc8wd3Opc/Am4h2X990TZi7A38LYd0NvtLvuHv47EP9FgWuplpFz
t2qqt7DfAs3AdiZ0BrrNoAL6E9hvHfF3gm8PfxprNmStWuZ6EFud9pN3TaRa
SG/wY3w9RPxrA+fw/+lbFoxl1+n95vxm9VbPRD6a8YHQb0UYNSrjNbVWV/iW
+B7D3N1FvgOTiH8q1B/5iISxNQvVJo2xk9B9IuNcspa5UtY+oRgYJ8r9luah
v6HYb+oR/N/FN53NG2+P7F+hv5m+le7wsZwxUtgojB0Nvw9+T5Hf8F6NoaZF
frPfsFaG+LZh2xvalnONotrkF4FrjzQxlZa7Bvkd+s8SQxXyvfDdiK2j3gPy
QfjsiHwe/m5A/qTyRdY1pmpL1dwvxM7ZytXC8APKXVBVsXPMCnyvzLv2mZBw
bZyMfTbCtMex3RAb+0bh71LGy4WJjC8sdy04P3ZuVI78OeO2+GhZ7jdxKeNu
BecW3bHWsd+s3moj+ESFMVzYrZz7fcE5SLlHOU1YKUwQFggzhVWb4VenjFkr
kT+SMzYoJ6tWGxO6dlfN9g3+arOuTZWD72e9ERXO9xvTrj3m6s2kXINMQvZm
5PywHvky1ZrQ86qXkH+l/Ei8DxBvxNxQZMPyxk5hYDnxlOd99/UNb4mNocLO
gfB9iOcG5joVu0dYzHhfwbWq3rTuzv6Mc7nu0K3IR2WNZYPQXxUbM4WVA6Df
4HsIVI1+j1LfLb0pvSXdsUN5Y5Sw6QAxdILfCq1j3Crp2nk1/OKUa2hh9Vvw
a1PG7CyxZQrutYSByoW3FLwX5cR26PYmnrOIpQybwWnnROVC5fSm6DYp+G4L
M1TbLteZp1zjxvg7lnVuuIq5mbFziHKHcoxySfOC74pyyt3YNsHmWvT7od8b
24i5D1j/ZOaOC+84vzxnt5W5T3PuWVRrrICaR65JVYvqzcjXvLxrT/lsDJ/P
utbVm5vCeD70p1JjymTGrSJjS13CvcN6aFjSPcQi5F0i50b1eMLOdyKfvTBU
WDCKuR5lxoQd6g2yxl71lE8yngZ1LnLO0NqF2L2eYigj1lTevY8wVtj1eMa1
sDDsZPQbZY0V6gl7Mv4h57OIsJ8B/1TWvfjAUvdu50S+2+rhzozc46q3VQ6Z
w1p/jLzXW9WzI5uYda95F7SH8fjItY56xL1ZvxG9DdVAAWsfZ6550j3O4Kxz
pHLjCXy+iP9poWsTvUFhmzBG2CKMuxb7zrFzQSXUGfkl0JnFzjnbsr6Dunvq
sYer/w9dK57P+WVix6xYlQOETe1j94rCqOmh/9PQfxmqAecy/kvOb0s5QLX6
W6FzrWr20yPfQd099YDrIq+ptXQHxkTuCdUL6o6/z/jfzO1iXJty7ZGInWtU
g1yNrG3WtYB6tk2MN2ZdK6hn+g/j2yPX2qphluJvCdQzMCYdRj4z+qlXJd6D
edd4qu205n720gGdz1PuIdUbz8i791ePvCXvHlO9pd58X2w/YG53yv8ZvIrs
UOheVpg/hNgHF1z7KIe8EXmP2ptsXkH3HfXHZY5xU949rnpbYfZn8J/mXTtI
R3cjoftZ+tMdQVYCv6PUGPU2/OzI/2Wox+5OPDU51yLqOWZi/3TWd1lvRtj8
Zej/DoTRV1S4hlbtrP9wLmZ8ScbYpxpLWHFYMaWMGfcwPivyXdd/BpcLvwvO
fbpz1cjbRc6V66Bm8Lsy7rVUs+qsH84ai3XmMfKZGedqYdQ5xF6L/UNJ93Bn
C5/QeS/lOfVeO0P/N6AebBjyoTnnduWMh7Bdhc4rKWP2WsZr8v6vTnOz9XbQ
T5QZY/Tfjnr+H3t96Ab4NVn3nqqhu8R+Y3pbwvBJ6PaPvDf9Z6D/6h7JuFbR
f3bqJYS5wlr1FMcjY4ywRWsejNzjq7fXmepb6j8w/felb6r/Ehtk/F+c/lNU
LfhZztismlC13BfC85Rruj2Re3z19poryjlnKFfoznycd02oWlBnqN6xQ8bY
oh6yW945VLlTPcz/ARTe9FY=
         "],
         VertexColors->None], PolygonBox[{{5749, 4681, 711, 3504, 3492}},
         VertexColors->None]}]}, 
     {RGBColor[0.84500573799762, 0.874467780169583, 0.877127191195757], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3mYlcWVxr976e57b9/uu/S93fF5ooBJRCbikknUiBA1oogmihDRiIng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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHeYVdUVxe/UN29mXn9vJBEpURR7UGGkGDCICCiIhBgD9kQQ/VBAAogS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         "],
         VertexColors->None], PolygonBox[{{4488, 3778, 3427, 3621, 1619}},
         VertexColors->None]}]}, 
     {RGBColor[0.902298660041591, 0.893573443047278, 0.851460013462114], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnuQ1tV5x3+7y768u/su7+6+u4uCKF46sBLxglxNUkqaiIqMMWnEqbYV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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ds1GUYx186rteWu+vd9UeMBAVBQVAgEVrAlahRJICIiv8p4ECCiGwV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         "],
         VertexColors->None], PolygonBox[{{4803, 5758, 3638, 3637, 654}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlM1L1GEQx2db2GzXdl3l18kC0ajEyDwUYbdOFnXoonTIqEuHykMv0K2I
TuvqIVNTTIMigkDrWGkKhdubppn/gIfoItGhrn0/zUgdHp75zW9evvOdmafh
bM/JS5vM7LZOWmexYPY1Mbuuj8ac2VC1Wd78HtbZKrlPd3+123SmzLab2+zQ
uVft32+zbvNGd1POY9VLP591f3zLutd0BqRfU5xWAenSva7TLHk84hADm76U
yxOSp4TxRZ3ZzSqzuazHmQ3bcsScDXnDj7wToUd3R/KIdKM6LZLvV7k8pntG
Nr2Sp7NuX5J8Ne31jYR9JeVxiDkp3gZrzDpksyxsKzqVqB3eqB8//PfKfkH2
nxKPSeze/+ITGw7f6//HxOsjT39ghhs4In8p6kYPB3PBFX2BS3pyo8p50m97
pbzjwnlauS4WzR6qcaekbxO+/TnX0wf6IVPrTrvumOQnKdcTe1et2W6dbxnX
o8sH7s7Iu5B4DWBaTZwXOHmqwJOSjyjuoaiFXv/MOVZm7NZmz03eadlfKP7D
cthcPxe9gTf88CfmPuFq1fmRcbwNm7yWReVcSnymfuvfr4zXzpyiYybn9f9d
4v2vxCzCPf2ZiVzwXA7eqed7zucaW+qhT/QdPBv7Mh9z27PF7Gjae8ycjcQ8
NMt2T87nB1zUT43DIvVM0XcHv47wxbY5dmqgxjml9hPbnK/usKUfLbFfXdEn
9Pjz74piP67xmTku36mC52FeN/o5IeG87Npjv+ktmJnroZht+sL80JvGqKU+
doqawQAnO6NH3E1h8yFxHGB4VnAcYPjCfkj/IGajKXzhjVztwUNj1IKuLfSf
E3/L6Gkl8X2jdzMF5wh+rin2ir7bMx6TmsD/Wu/KwVqfkenYffaLPgzmHXO3
5NWi7xTv0Mt4i6iXWGBYj51lfu7m3Qd7OD5X9BqZq1K8M3A8lndfYjHT1AvP
TTFLl2XzSP0qmc/efMwt7xa54Zk5/YvbvI4DUQtzig98LgvvUp37MP998VY3
xO6z0+XQgR9czwMbPFMjXI3Ge8j3HyLC1YM=
         "],
         VertexColors->None], 
        PolygonBox[{{5580, 5579, 148, 2753}, {5551, 5552, 2177, 835}, {4246, 
         5668, 2858, 841}, {5671, 3744, 59, 2866}, {5668, 3736, 28, 2858}, {
         3748, 5055, 1783, 90}, {5588, 5587, 161, 2760}, {5666, 4244, 835, 
         2853}, {3734, 5666, 2853, 28}, {3762, 5074, 2206, 59}, {4451, 4015, 
         841, 842}, {3909, 4030, 863, 1923}, {4648, 4461, 90, 1767}, {5051, 
         3733, 12, 2177}, {4656, 4467, 139, 1776}, {5585, 5584, 889, 2757}, {
         4263, 5583, 2757, 148}, {5581, 5582, 2753, 885}, {4662, 4661, 1782, 
         1783}, {4469, 4470, 1595, 161}, {4261, 5575, 2750, 139}, {4255, 5671,
          2866, 862}, {5589, 5590, 2760, 889}, {4661, 3909, 1923, 1782}, {
         5577, 5576, 885, 2750}, {3905, 4017, 842, 2415}, {5073, 3905, 2415, 
         2206}, {4460, 4028, 862, 863}},
         VertexColors->None]}]}}, {{}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{4052, 4470, 4469, 5587, 5588, 5586, 5590, 5589, 4047, 5584, 
        5585, 5583, 4263, 4468, 5579, 5580, 5578, 5582, 5581, 4046, 5576, 
        5577, 5575, 4261, 4467, 4656, 4655}],
       RowBox[{"-", "20"}]], 
      TooltipBox[
       LineBox[{4566, 4447, 3733, 5051, 5050, 5552, 5551, 4012, 4244, 5666, 
        3734, 4448, 3736, 5668, 4246, 4015, 4451, 4016, 5709, 4017, 3905, 
        5073, 5074, 3762, 3741, 4456, 3744, 5671, 4255, 4028, 4460, 4029, 
        5710, 4030, 3909, 4661, 4662, 4663, 5055, 3748, 4461, 4648, 4647}],
       RowBox[{"-", "20"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{3757, 3769, 4668, 4393, 3812, 4584, 3813, 5685, 4289, 5127, 
        5126, 5388, 5387, 4050, 4903, 4051, 4904, 4666, 4665, 3913, 4794, 
        5069, 3755, 5086, 5085, 5084, 4071, 5367, 4070, 5420, 4151, 5418, 
        4150, 5419, 3754, 5083, 5082, 5081, 4067, 4483, 4482, 5167, 5166, 
        5165, 4149, 5417, 4654, 4777, 5251, 4778, 4687, 5728, 4686, 5729, 
        3793, 4806, 4807, 4380, 4379, 4604, 3794, 5282, 5283, 5281, 3950, 
        4809, 4810, 4775, 3893, 4774, 3894, 4776, 5095, 5094, 3921, 3753, 
        5672, 3892, 5745, 5748, 5747, 5746, 3927, 5104, 5105, 3943, 3790, 
        5121, 5731, 3891, 5250, 5058, 5059, 5572, 5571, 3752, 4361, 4337, 
        5726, 4336, 4612, 4066, 5664, 4347, 5663, 4346, 5093, 5092, 5091, 
        5370, 5369, 5057, 5056, 4035, 5346, 3912, 5257, 3911, 5732, 4901, 
        4032, 5341, 4790, 4791, 4789, 4900, 4899, 5340, 4459, 4986, 4987, 
        4985, 4254, 4988, 4023, 4455, 3740, 5670, 4250, 3904, 5254, 5255, 
        4889, 4888, 5336, 4450, 5554, 5555, 5553, 5557, 5556, 4011, 5549, 
        5550, 5548, 4243, 4446, 4471, 4472, 4265, 4991, 4264, 4992, 4473, 
        3804, 5616, 5617, 5615, 4294, 5618, 4240, 4565, 4241, 5723, 4242, 
        3959, 5288, 5289, 4817, 4816, 3871, 4629, 5049}],
       RowBox[{"-", "40"}]], 
      TooltipBox[
       LineBox[{3895, 4414, 3922, 5260, 5261, 5102, 5103, 3775, 5280, 3776, 
        4076, 5373, 4077, 4489, 4488, 3778, 5757, 5771}],
       RowBox[{"-", "40"}]], 
      TooltipBox[
       LineBox[{4358, 4359, 3970, 4432, 4299, 5622, 5624, 5623, 4176, 4616, 
        4391, 4392, 5024, 5023, 3811, 4528, 4529, 4329, 4603, 4362, 4363, 
        4330, 5062, 5061, 5060, 4258, 5573, 4040, 5574, 4259, 5063, 5064, 
        5065, 4465, 5067, 5066, 5352, 4043, 4671, 4672, 4090, 3785, 4091, 
        5111, 5112, 4103, 3792, 4466, 4044, 4045, 3942, 4804, 4803, 5758, 
        5761}],
       RowBox[{"-", "40"}]], 
      TooltipBox[
       LineBox[{4410, 4445, 4407, 4920, 4921, 4919, 4105, 4505, 4504, 4690, 
        4689, 4688, 3872, 5239, 4779, 3899, 5700, 3898, 4109, 5683, 3805, 
        4449, 4013, 5708, 4014, 3951, 4107, 5681, 3802, 4507, 3803, 5682, 
        4108, 3896, 5699, 3897, 3866, 5237, 3867, 4750, 5122, 5123, 4502, 
        4503, 4104, 4918, 5386, 5385, 3731, 4425, 4627, 4626}],
       RowBox[{"-", "40"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{5764, 5676, 3938, 3773, 3915, 5703, 3914, 4357, 4356, 4994, 
        4267, 4993, 4266, 5591, 4577, 5116, 5115, 4684, 4998, 4997, 4354, 
        4570, 5153, 5152, 5151, 4283, 4699, 3809, 4478, 5142, 5141, 5140, 
        4125, 5444, 5445, 5443, 4168, 4820, 4821, 4767, 3878, 4766, 3879, 
        4768, 5139, 4406, 3876, 4610, 3875, 5695, 4345, 3961, 4163, 5687, 
        3817, 4538, 4539, 4165, 5436, 4164, 3806, 4508, 5136, 5135, 4694, 
        4116, 4245, 5667, 3735, 5291, 5292, 5290, 5294, 5293, 3870, 5238, 
        3869, 5706, 4815, 4947, 4946, 5435, 3759, 4366, 4338, 4537, 4536, 
        4055, 5393, 5394, 5390, 5392, 5391, 5461, 3758, 3732, 5665, 4657, 
        4628, 3868, 5285, 3953, 5284, 3952, 4632, 4631, 4630, 4752, 4751, 
        4780, 4113, 5716, 4114, 4110, 4112, 5715, 4111, 4189, 3737, 5669, 
        4019, 4018, 4118, 5717, 4117, 4782, 4757, 4758, 4755, 3877, 4756, 
        3955, 5286, 3956, 5287, 3880, 5240, 5241, 5076, 5075, 3763, 3742, 
        5406, 5407, 5405, 5409, 5408, 4058, 5356, 5357, 5077, 5078, 3764, 
        3745, 5303, 5304, 5302, 5306, 5305, 3883, 4769, 3882, 4770, 4826, 
        4825, 5620, 5621, 5455, 4174, 5454, 4175, 5608, 5609, 5003, 4286, 
        5607, 3810, 4390, 4177, 5688, 3823, 4464, 4036, 5711, 4037, 3972, 
        5308, 5310, 5309, 3889, 5248, 3888, 5249, 3931, 5266, 3932, 5267, 
        3890, 4651, 4652, 4653, 3920, 5351, 4042, 5350, 4041, 5779}],
       RowBox[{"-", "60"}]], 
      TooltipBox[
       LineBox[{5776, 5259, 5749, 4681, 3784, 5674, 3937, 3935, 5269, 3936, 
        5270, 3789, 4578, 4271, 4272, 5673, 3779, 4420, 3780, 5595, 5596, 
        5594, 4276, 4573, 4572, 4989, 4260, 4916, 4094, 4685, 5117, 5118, 
        4484, 5366, 4068, 4908, 4069, 4909, 4262, 4990, 4574, 4575, 4300, 
        5625, 5627, 5626, 3798, 5311, 3799, 5125, 5124, 3958, 4413, 4412, 
        4424, 5072, 5071, 5070, 4054, 5353, 4053, 5423, 4153, 5421, 4152, 
        5422, 4179, 5313, 3975, 5312, 5315, 5314, 3945, 5273, 3944, 5704, 
        4805, 5705, 3946, 5735, 5088, 5089, 5368, 4072, 4746, 5226, 5227, 
        4856, 4857, 4855, 5325, 5324, 3795, 4863, 4864, 4862, 4866, 4865, 
        3856, 4860, 4861, 4859, 5327, 5326, 4423, 3768, 5087, 4667, 4745, 
        4744, 5225, 5224, 4854, 3996, 4853, 3995, 4382, 4381, 5389, 4106, 
        5130, 5131, 3801, 4506, 3800, 5128, 5129, 5096, 5371, 5097, 5098, 
        4487, 5101, 5100, 5099, 4073, 4270, 3771, 5271, 5778}],
       RowBox[{"-", "60"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{5760, 5754, 4679, 4680, 4274, 4378, 4377, 4615, 4257, 4571, 
        4355, 4335, 5725, 4334, 4611, 4065, 5713, 4349, 4907, 4491, 4084, 
        4625, 4083, 5567, 5568, 5566, 4253, 4906, 4057, 4905, 5355, 5354, 
        4477, 3808, 5440, 5441, 5439, 4167, 5442, 4166, 5009, 4298, 5008, 
        4297, 4429, 3964, 5476, 4196, 5186, 5187, 5188, 4197, 4733, 4732, 
        4731, 4124, 4923, 4279, 5599, 5601, 5600, 4199, 5477, 4200, 5478, 
        4198, 5012, 4308, 5011, 5635, 5634, 4426, 4437, 3760, 4367, 4621, 
        4620, 3901, 4415, 5185, 5184, 5329, 5328, 4870, 4818, 3960, 4819, 
        5168, 4950, 4162, 4948, 4161, 4949, 4474, 5134, 5133, 5132, 4115, 
        5463, 4185, 5462, 4184, 4971, 4970, 4658, 3900, 4781, 3874, 4753, 
        3873, 4754, 4812, 4811, 3738, 4634, 4633, 4760, 4759, 4783, 4764, 
        4765, 4761, 4763, 4762, 4813, 4814, 4640, 4639, 4638, 3881, 4787, 
        3906, 4659, 4660, 5560, 4252, 5559, 4251, 5410, 4139, 5154, 5155, 
        5156, 4479, 5359, 4060, 5358, 4061, 5360, 4256, 5307, 3967, 5157, 
        5158, 5330, 4004, 5196, 5197, 4737, 5702, 3910, 4792, 4793, 4664, 
        3766, 3749, 4433, 3751, 4360, 4331, 4607, 3884, 4411, 5164, 4710, 
        5698, 3887, 4773, 4649, 4650, 3930, 5349, 4039, 5347, 4038, 5348, 
        4088, 5714, 4089, 3934, 5268, 3933, 5762}],
       RowBox[{"-", "80"}]], 
      TooltipBox[
       LineBox[{5766, 5384, 4099, 5759, 4100, 4499, 4498, 3788, 5678, 4275, 
        4999, 4801, 3928, 4800, 3929, 4802, 4917, 4102, 5679, 3791, 4500, 
        4501, 4278, 5597, 4277, 5598, 3756, 5279, 5275, 5276, 5274, 3947, 
        5277, 3826, 4808, 3949, 5278, 3948, 5736, 4831, 3974, 4828, 3973, 
        4827, 4830, 4829, 3825, 4543, 3824, 5172, 5171, 4178, 5456, 4364, 
        4365, 3767, 4269, 4268, 5006, 4288, 5004, 4287, 5005, 3787, 4097, 
        5382, 4098, 5383, 4095, 4497, 5120, 5119, 4096, 5381, 5068, 5252, 
        5253, 5106, 5775}],
       RowBox[{"-", "80"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{5763, 5675, 5752, 3786, 5677, 3939, 3926, 4049, 5712, 4048, 
        4192, 3816, 5686, 3981, 4101, 3980, 3815, 4008, 5707, 4009, 3979, 
        5755, 4835, 4834, 4887, 5335, 5774}],
       RowBox[{"-", "100"}]], 
      TooltipBox[
       LineBox[{5769, 4494, 3783, 5110, 5109, 5593, 5592, 4087, 4492, 4085, 
        4602, 4086, 4493, 4063, 4915, 4082, 5378, 4081, 5737, 4937, 5404, 
        5403, 4430, 4431, 4201, 5189, 5190, 5743, 5191, 4202, 5740, 5192, 
        3835, 4310, 4309, 5033, 4332, 5030, 5032, 5031, 4581, 4515, 4516, 
        4204, 5479, 4203, 5480, 4454, 4453, 3819, 4713, 4190, 5180, 5181, 
        5182, 4546, 3827, 5178, 5179, 5169, 5170, 3818, 5437, 5438, 4296, 
        5619, 4295, 4586, 4122, 5395, 5738, 4123, 5396, 5138, 4439, 5744, 
        3998, 4384, 4383, 4512, 3963, 5558, 4249, 5052, 5053, 4509, 4120, 
        4576, 4121, 4510, 4056, 4475, 5137, 4696, 4119, 4922, 4247, 4452, 
        4020, 5467, 4186, 5464, 5466, 5465, 4416, 4867, 3796, 4692, 4691, 
        3954, 4409, 4408, 3761, 3739, 4351, 3957, 4693, 4868, 5680, 3797, 
        4869, 4417, 5469, 5470, 5468, 4188, 5471, 4187, 4545, 5177, 4724, 
        5718, 4140, 4938, 4706, 4480, 5742, 4059, 4941, 4142, 4939, 4141, 
        4940, 4171, 5448, 5450, 5449, 3969, 4520, 4385, 4386, 4005, 4442, 
        5160, 5159, 4284, 5605, 4143, 4608, 4609, 4396, 3822, 4542, 4462, 
        4463, 4434, 3971, 5043, 4709, 5696, 5697, 5242, 5243, 3886, 4772, 
        3885, 4771, 3916, 4797, 3917, 4798, 4799, 5727, 3774, 3925, 5264, 
        5265, 5777}],
       RowBox[{"-", "100"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{5765, 4373, 3923, 5262, 3924, 5263, 3919, 5258, 3918, 5733, 
        5090, 3770, 5428, 5429, 5427, 5431, 5430, 4158, 5490, 5491, 5487, 
        5489, 5488, 5638, 5639, 4975, 4210, 4974, 4211, 4976, 5343, 5342, 
        4212, 5485, 5637, 5636, 4591, 4592, 4519, 4518, 4583, 4521, 3838, 
        5195, 5194, 4213, 5486, 4031, 4788, 3908, 5256, 3907, 5701, 4873, 
        4002, 4708, 4707, 4705, 3968, 4890, 4024, 4641, 5054, 4371, 4370, 
        4972, 4193, 4728, 4729, 3833, 4540, 3834, 4730, 4350, 4548, 4547, 
        4579, 5026, 5027, 5025, 5029, 5028, 4305, 4306, 5690, 3832, 5010, 
        4982, 4983, 4981, 4248, 4984, 4368, 4369, 3991, 4850, 3992, 4851, 
        3962, 4695, 4697, 4698, 4001, 4785, 3902, 4784, 3903, 4786, 4980, 
        5534, 5535, 5228, 5229, 3857, 4511, 4580, 4513, 4514, 4590, 4589, 
        5631, 4307, 5630, 5633, 5632, 4194, 5474, 4195, 5475, 4022, 4635, 
        4636, 4637, 4209, 4353, 4352, 4567, 4208, 4550, 4026, 4934, 4136, 
        4933, 4135, 5402, 3807, 4936, 4137, 4935, 4138, 4458, 4457, 4568, 
        4569, 4273, 5374, 5375, 5376, 4554, 4374, 4375, 4341, 4614, 4342, 
        4613, 4064, 4601, 5021, 5022, 4912, 4080, 4911, 4079, 4913, 4914, 
        4677, 4678, 3782, 4486, 5768}],
       RowBox[{"-", "120"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{5770, 5756, 4996, 4485, 3781, 5108, 5107, 4078, 5377, 4376, 
        5496, 4216, 5211, 5212, 5213, 4490, 4562, 4234, 4617, 4235, 5545, 
        5544, 4343, 5662, 4403, 4344, 5722, 4236, 4618, 4619, 4564, 4563, 
        4553, 3846, 4823, 4824, 4822, 3966, 5301, 4427, 4428, 4133, 4704, 
        4931, 4932, 4134, 5604, 4282, 5603, 4281, 4582, 4129, 4517, 4130, 
        5399, 5401, 5400, 3999, 4871, 4000, 4872, 5222, 5223, 4556, 4557, 
        4224, 5527, 4223, 5528, 3743, 5562, 5563, 5561, 5565, 5564, 4220, 
        5525, 5526, 5522, 5524, 5523, 3836, 5482, 5483, 5481, 4207, 5484, 
        4205, 4549, 5193, 4734, 4206, 4973, 4643, 4642, 4025, 4891, 4021, 
        4954, 4955, 4951, 4953, 4952, 4418, 5446, 5447, 4959, 4961, 4960, 
        4169, 4957, 4958, 4956, 4170, 5014, 4321, 4747, 4748, 4559, 4229, 
        5539, 4230, 5536, 5538, 5537, 3837, 5510, 5511, 5509, 5513, 5512, 
        4218, 5507, 5508, 5504, 5506, 5505, 5657, 5658, 5547, 4237, 5546, 
        4238, 5648, 4320, 5013, 4319, 5217, 5216, 5215, 5515, 5514, 4736, 
        4735, 4003, 4874, 4285, 5611, 4291, 5414, 5415, 5416, 4585, 5613, 
        4292, 5612, 4293, 5614, 4159, 5720, 4945, 5719, 4033, 5345, 4034, 
        4902, 5174, 5173, 4180, 5457, 4967, 5244, 5247, 5246, 5245, 4675, 
        4676, 3777, 5753, 4995, 5772}],
       RowBox[{"-", "140"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{5767, 5750, 4622, 5751, 4419, 4682, 4683, 4495, 4496, 4093, 
        5379, 4092, 5380, 3747, 3765, 5080, 5079, 5365, 5364, 4062, 4965, 
        4966, 4962, 4964, 4963, 3814, 5459, 5460, 4968, 4183, 4969, 4181, 
        4544, 5176, 5175, 4182, 5458, 4644, 4898, 4027, 5339, 5338, 4897, 
        5337, 4930, 4132, 4928, 4131, 4929, 5150, 5000, 5002, 5684, 5001, 
        3984, 4720, 4721, 4722, 4886, 4885, 5529, 4225, 5520, 4221, 5519, 
        4222, 5521, 4126, 4926, 4127, 4701, 4702, 4703, 4440, 5144, 5143, 
        4700, 4925, 4924, 3982, 4716, 4877, 4878, 4880, 4879, 3820, 4715, 
        4714, 4837, 4836, 4372, 4895, 4896, 4892, 4894, 4893, 4977, 4978, 
        4719, 4718, 4717, 3983, 5397, 5398, 5145, 5146, 5147, 4441, 5149, 
        5148, 5602, 4280, 5724, 4927, 4128, 5453, 4173, 5451, 4172, 5452, 
        3821, 4883, 4884, 4882, 4881, 4723, 3985, 5412, 5413, 5161, 5163, 
        5162, 5739, 4144, 5411, 4145, 4942, 5344, 4944, 4155, 4943, 4154, 
        5007, 4290, 4711, 4712, 4532, 4157, 4533, 4534, 4339, 5042, 4340, 
        5039, 5041, 5040, 3772, 4404, 4405, 4328, 5019, 5020, 5017, 5018, 
        5773}],
       RowBox[{"-", "160"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{5332, 5198, 5199, 5200, 4738, 4739, 4645, 4646, 3746, 4875, 
        4839, 4840, 4838, 4842, 5730, 4841, 5046, 5045, 5047, 5048, 4444, 
        4443, 4541, 5035, 5036, 5034, 5038, 5037, 4317, 4318, 5691, 3849, 
        5647, 5498, 5499, 5497, 5501, 5500, 3850, 5214, 5503, 5502, 4006, 
        5333, 4007, 5334, 3847, 4535, 4160, 5432, 5434, 5433, 3994, 5321, 
        5323, 5322, 3977, 4832, 3976, 4833, 5113, 5114, 4435, 5316, 3986, 
        4843, 3987, 4844, 5183, 4847, 3989, 4845, 3988, 4846, 4849, 4848, 
        5318, 3990, 5317, 5320, 5319, 3941, 5272, 3940, 5734, 4858, 3997, 
        4395, 4394, 4624, 3978, 4436, 4749, 3865, 5661, 4326, 5660, 4327, 
        4600, 4599, 5659, 4324, 5015, 4325, 5016, 4239, 5044, 4348, 4910, 
        5372, 4074, 4623, 4075, 4422, 4421, 4674, 4673, 5642, 4314, 5206, 
        5207, 5208, 4552, 3845, 5210, 5209, 5495, 5494, 5610, 5542, 5543, 
        5232, 5233, 3861, 4561, 3860, 5231, 5230, 5541, 5540, 4010, 4670, 
        4669, 4795, 4796, 4743, 4742, 3854, 4531, 4156, 5424, 5426, 5425, 
        3864, 5236, 5741, 4219, 5516, 5218, 5219, 4530, 3853, 5221, 5220, 
        5518, 5517, 4979, 4725, 3993, 4852, 5570, 5569, 5362, 5363, 5361, 
        5473, 5472, 4191, 3828, 5689, 4302, 4301, 4523, 4522, 5606, 5331, 
        5332}],
       RowBox[{"-", "180"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{5694, 4231, 4740, 3840, 4481, 3839, 5493, 4214, 5492, 4215, 
        4525, 4524, 4526, 4146, 4594, 4147, 4311, 4312, 4551, 4148, 4527, 
        4389, 4605, 4606, 4398, 4397, 3843, 4876, 4399, 4400, 4333, 4402, 
        4401, 3844, 4595, 5205, 5204, 5203, 4313, 4727, 3831, 4587, 4588, 
        4304, 5628, 4303, 5629, 3750, 4438, 5645, 5646, 5644, 4315, 5643, 
        4316, 4597, 4596, 3848, 4741, 4322, 5234, 5235, 3863, 4598, 3862, 
        5653, 5654, 5652, 5656, 5655, 4323, 5649, 5651, 5650, 3842, 4593, 
        3841, 5202, 5201, 5641, 5640, 4387, 4388, 4232, 5721, 4233, 4227, 
        5693, 3855, 4558, 4226, 5533, 4228, 5530, 5532, 5531, 3829, 4476, 
        3830, 4726, 4217, 5692, 3852, 4555, 3851, 5297, 5298, 5295, 3965, 
        5296, 5300, 5299, 3858, 4560, 3859, 5694}],
       RowBox[{"-", "200"}]]}, {}, {}}, {InsetBox[
      RowBox[{"-", "200"}], 5780], InsetBox[
      RowBox[{"-", "180"}], 5781], InsetBox[
      RowBox[{"-", "160"}], 5782], InsetBox[
      RowBox[{"-", "140"}], 5783], InsetBox[
      RowBox[{"-", "120"}], 5784], InsetBox[
      RowBox[{"-", "100"}], 5785], InsetBox[
      RowBox[{"-", "100"}], 5786], InsetBox[
      RowBox[{"-", "80"}], 5787], InsetBox[
      RowBox[{"-", "80"}], 5788], InsetBox[
      RowBox[{"-", "60"}], 5789], InsetBox[
      RowBox[{"-", "60"}], 5790], InsetBox[
      RowBox[{"-", "40"}], 5791], InsetBox[
      RowBox[{"-", "40"}], 5792], InsetBox[
      RowBox[{"-", "40"}], 5793], InsetBox[
      RowBox[{"-", "40"}], 5794], InsetBox[
      RowBox[{"-", "20"}], 5795], InsetBox[
      RowBox[{"-", "20"}], 5796]}}],
  AspectRatio->1,
  Epilog->{
    RGBColor[1, 0, 0], 
    PointSize[0.01], 
    LineBox[{{1.5, -1.}, {
     0.915285414731388, -1.76870405932276}, {-0.1669016991642, \
-2.22297179954139}, {-0.588259205975854, -2.0339401197923}, \
{-0.590049015347253, -2.03264087683282}, {-0.590516172208879, \
-2.03258842177175}, {-0.591412715783515, -2.03250939924184}, \
{-0.593185508727094, -2.03235324631789}, {-0.596670434823995, \
-2.03204582020853}, {-0.60344031524992, -2.03144683731284}, \
{-0.616303014012674, -2.03030228473078}, {-0.639761213178166, \
-2.02819272799389}, {-0.67964766463889, -2.02453864895679}, \
{-0.740447745397389, -2.01880145917251}, {-0.81982965633147, \
-2.01099643893711}, {-0.903410369631181, -2.00236880295801}, \
{-0.966232981857011, -1.99555466526582}, {-0.991658489368944, \
-1.99266987017011}, {-0.994818004992422, -1.9922972888814}}], 
    RGBColor[1, 1, 0], {
     PointBox[{1.5, -1.}], 
     PointBox[{0.915285414731388, -1.76870405932276}], 
     PointBox[{-0.1669016991642, -2.22297179954139}], 
     PointBox[{-0.588259205975854, -2.0339401197923}], 
     PointBox[{-0.590049015347253, -2.03264087683282}], 
     PointBox[{-0.590516172208879, -2.03258842177175}], 
     PointBox[{-0.591412715783515, -2.03250939924184}], 
     PointBox[{-0.593185508727094, -2.03235324631789}], 
     PointBox[{-0.596670434823995, -2.03204582020853}], 
     PointBox[{-0.60344031524992, -2.03144683731284}], 
     PointBox[{-0.616303014012674, -2.03030228473078}], 
     PointBox[{-0.639761213178166, -2.02819272799389}], 
     PointBox[{-0.67964766463889, -2.02453864895679}], 
     PointBox[{-0.740447745397389, -2.01880145917251}], 
     PointBox[{-0.81982965633147, -2.01099643893711}], 
     PointBox[{-0.903410369631181, -2.00236880295801}], 
     PointBox[{-0.966232981857011, -1.99555466526582}], 
     PointBox[{-0.991658489368944, -1.99266987017011}], 
     PointBox[{-0.994818004992422, -1.9922972888814}]}, 
    RGBColor[0, 0, 1], 
    PointSize[0.02], 
    PointBox[{1.5, -1.}]},
  Frame->True,
  FrameTicks->True,
  ImageMargins->0.,
  ImageSize->Automatic,
  Method->{},
  PlotRange->{{-3, 3}, {-4, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->517922011]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "->", 
   StyleBox["prec", "TI"]}]], "InlineFormula"],
 " specifies that all the calculation in ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " is to be carried out at precision ",
 Cell[BoxData[
  StyleBox["prec", "TI"]], "InlineFormula"],
 ". By default, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["prec", "TI"], " ", "=", 
   ButtonBox["MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MachinePrecision"]}]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  RowBox[{
   StyleBox["prec", "TI"], " ", ">", " ", 
   ButtonBox["MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MachinePrecision"]}]], "InlineFormula"],
 ",",
 " a fixed precision of ",
 Cell[BoxData[
  StyleBox["prec", "TI"]], "InlineFormula"],
 " is used through the computation."
}], "Text",
 CellID->38230157],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " options are used in the following way. By default, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AccuracyGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccuracyGoal"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", and is set to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["prec", "TI"], "/", "3"}]], "InlineFormula"],
 ".",
 "By default, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrecisionGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrecisionGoal"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " and is set to ",
 Cell[BoxData[
  RowBox[{"-", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AccuracyGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccuracyGoal"], "->", 
   StyleBox["ga", "TI"]}]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AccuracyGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccuracyGoal"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]}], ",", " ", 
     StyleBox["ga", "TI"]}], "}"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->358638282],

Cell[TextData[{
 "Suppose ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AccuracyGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccuracyGoal"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["ga", "TI"]}], "}"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrecisionGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrecisionGoal"], "->", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " attempts to drive the residual, which is a combination of the feasibility \
and the satisfaction of the KKT (Karush\[Dash]Kuhn\[Dash]Tucker) and \
complementary conditions, to be less than or equal to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["tol", "TI"], "=", 
   SuperscriptBox["10", 
    RowBox[{"-", 
     StyleBox["ga", "TI"]}]]}]], "InlineFormula"],
 ". In addition, it requires the difference between the current and next \
iterative point, ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["x", "TI"], "+"]], "InlineFormula"],
 ", to satisfy ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     SuperscriptBox["x", "+"], "-", "x"}], "||", 
    RowBox[{"<=", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "a"}]], "+", 
      SuperscriptBox["10", 
       RowBox[{"-", "p"}]]}]}], "||", "x", "||"}], TraditionalForm]], 
  "InlineMath"],
 ", before terminating."
}], "Text",
 CellID->356579338],

Cell[TextData[{
 "This computes a solution using a ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " of 100."
}], "MathCaption",
 CellTags->"b:0.2.1",
 CellID->156944844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"FindMinimum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FormBox[
       RowBox[{
        RowBox[{"-", " ", 
         FractionBox["100", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "1"}], ")"}], "2"], "+", "1"}]]}], "-", 
        FractionBox["200", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"y", "+", "2"}], ")"}], "2"], "+", "1"}]]}],
       TraditionalForm], ",", 
      FormBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ">", "3"}],
       TraditionalForm]}], " ", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->190472588],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "-", "207.\
159896982008728501759331690034192005030005069590083134583700521416258515589708\
4005034822593961078589130961036491967`100."}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
      "-", "0.9948613347360094014956553845944468031990304363229825717098561180\
647581982908158877161292969329515965818627128976779`100."}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
      "-", "1.9922920021040141022434830768916702049447785592615484931630228240\
356715336019034943007530032732885749147717976182732`100."}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{579, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->157222145]
}, Open  ]],

Cell[TextData[{
 "The exact optimal value is computed using ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 ", and compared with the result of ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.2.1",
 CellID->90894111],

Cell[BoxData[
 RowBox[{
  RowBox[{"solExact", "=", 
   RowBox[{"Minimize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FormBox[
        RowBox[{
         RowBox[{"-", " ", 
          FractionBox["100", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"y", "-", "1"}], ")"}], "2"], "+", "1"}]]}], "-", 
         FractionBox["200", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "+", "2"}], ")"}], "2"], "+", "1"}]]}],
        TraditionalForm], ",", 
       FormBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ">", "3"}],
        TraditionalForm]}], " ", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->589714726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sol", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "-", 
  RowBox[{"solExact", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->758821354],

Cell[BoxData["8.58739616875135385265051019885731672419419776`27.\
617555812615326*^-71"], "Output",
 ImageSize->{241, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->87445977]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples of FindMinimum", "Section",
 CellID->804055587],

Cell[CellGroupData[{

Cell["Finding a global minimum", "Subsection",
 CellID->92384034],

Cell[TextData[{
 "If a global minimum is needed, ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " should be used. However since each run of ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " tends to be faster than ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 ", sometimes it may be more efficient to use ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 ", particularly for relatively large problems with a few local minima. ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " attempts to find a local minimum, therefore it will terminate if a local \
minimum is found."
}], "Text",
 CellID->654543307],

Cell[TextData[{
 "This shows a function with multiple minima within the feasible region of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", "10"}], "\[LessEqual]", "x", "\[LessEqual]", "10"}]], 
  "InlineFormula"],
 "."
}], "MathCaption",
 CellID->435952806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{".5", " ", "x"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->117478811],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->506710115]
}, Open  ]],

Cell[TextData[{
 "With the automatic starting point, ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " converges to a local minimum."
}], "MathCaption",
 CellID->217991463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      RowBox[{".5", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], "<=", "x", "<=", "10"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->423100040],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.9132229549810338`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2.094395024882865`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{173, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->625661101]
}, Open  ]],

Cell[TextData[{
 "If the user has some knowledge of the problem, a better starting point can \
be given to ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->255153148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      RowBox[{".5", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], "<=", "x", "<=", "10"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}]}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->823716126],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5.054815608570826`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "8.377580316261021`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->310530621]
}, Open  ]],

Cell["Alternatively, the user can tighten the constraints.", "MathCaption",
 CellID->47465889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      RowBox[{".5", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "10"}], "<=", "x", "<=", "10"}], "&&", " ", 
      RowBox[{"x", " ", "<", " ", 
       RowBox[{"-", "5"}]}]}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->425978146],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5.054815608570443`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "8.377579465720231`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->277310375]
}, Open  ]],

Cell["\<\
Finally, multiple starting points can be used and the best resulting minimum \
selected.\
\>", "MathCaption",
 CellID->731286755],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "7919", "]"}], ";"}], "\n", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], "+", 
        RowBox[{".5", " ", "x"}]}], ",", 
       RowBox[{
        RowBox[{"-", "10"}], "<=", "x", "<=", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10"}], ",", "10"}], "}"}], "]"}]}], "}"}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"{", "10", "}"}]}], "]"}]}], "Input",
 CellLabel->"In[18]:=",
 CellID->378762536],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.913222954981028`"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "2.094394963496442`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5.054815608570802`"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "8.377580158721315`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5.054815608570826`"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "8.377580321027247`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5.054815608570829`"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "8.377580365015884`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.9132229549810362`"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "2.0943950831124503`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5.0548156085708245`"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "8.377580297163393`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2283696986087569`", ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", "4.1887901970076316`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.228369698608761`", ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", "4.188790303537936`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2283696986087569`", ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", "4.188790212368145`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.455979101346592`", ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", "9.999999374067603`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{545, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->101360392]
}, Open  ]],

Cell[TextData[{
 "Multiple starting points can also be done more systematically via ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 ", ",
 "using the ",
 Cell[BoxData["\"\<RandomSearch\>\""], "InlineFormula"],
 " method with an interior point as the post-processor."
}], "MathCaption",
 CellID->755928725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      RowBox[{".5", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], "<=", "x", "<=", "10"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<RandomSearch\>\"", ",", 
      RowBox[{"\"\<PostProcess\>\"", "\[Rule]", "\"\<InteriorPoint\>\""}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->738377250],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5.05481560857083`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "8.377580409896938`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1400975415]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["An application example", "Subsection",
 CellID->609426104],

Cell["\<\
A powerful tool in managing investments is to spread the risk by investing in \
assets that have few or no correlations. For example, if asset A goes up 20% \
one year and is down 10% the next, asset B goes down 10% one year and is up \
20% the next, and up years for A are down years for B, then holding both in \
equal amounts would result in a 10% increase every year, without any risk. In \
reality such assets are rarely available, but the concept remains a useful \
one.\
\>", "Text",
 CellID->317442549],

Cell["\<\
In this example, the aim is to find the optimal asset allocation so as to \
minimize the risk, and achieve a preset level of return, by investing in a \
spread of stocks, bonds, and gold.\
\>", "Text",
 CellID->341559375],

Cell[TextData[{
 "Here are the historical return of various assets between 1973 to 1994. For \
example, in 1973, S&P 500 lost ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", "0.852"}], "=", 
   RowBox[{"14.8", "%"}]}]], "InlineFormula"],
 ", while gold appreciated by 67.7%."
}], "Text",
 CellID->1491598396],

Cell["", "Text",
 CellID->283189999],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\"\<3m Tbill\>\"",
       HoldForm], 
      TagBox["\"\<long Tbond\>\"",
       HoldForm], 
      TagBox["\"\<SP500\>\"",
       HoldForm], 
      TagBox["\"\<Wilt.5000\>\"",
       HoldForm], 
      TagBox["\"\<Corp. Bond\>\"",
       HoldForm], 
      TagBox["\"\<NASDQ\>\"",
       HoldForm], 
      TagBox["\"\<EAFE\>\"",
       HoldForm], 
      TagBox["\"\<Gold\>\"",
       HoldForm]},
     {
      TagBox["1973",
       HoldForm], "1.075`", "0.942`", "0.852`", "0.815`", "0.698`", "1.023`", 
      "0.851`", "1.677`"},
     {
      TagBox["1974",
       HoldForm], "1.084`", "1.02`", "0.735`", "0.716`", "0.662`", "1.002`", 
      "0.768`", "1.722`"},
     {
      TagBox["1975",
       HoldForm], "1.061`", "1.056`", "1.371`", "1.385`", "1.318`", "0.123`", 
      "1.354`", "0.76`"},
     {
      TagBox["1976",
       HoldForm], "1.052`", "1.175`", "1.236`", "1.266`", "1.28`", "1.156`", 
      "1.025`", "0.96`"},
     {
      TagBox["1977",
       HoldForm], "1.055`", "1.002`", "0.926`", "0.974`", "1.093`", "1.03`", 
      "1.181`", "1.2`"},
     {
      TagBox["1978",
       HoldForm], "1.077`", "0.982`", "1.064`", "1.093`", "1.146`", "1.012`", 
      "1.326`", "1.295`"},
     {
      TagBox["1979",
       HoldForm], "1.109`", "0.978`", "1.184`", "1.256`", "1.307`", "1.023`", 
      "1.048`", "2.212`"},
     {
      TagBox["1980",
       HoldForm], "1.127`", "0.947`", "1.323`", "1.337`", "1.367`", "1.031`", 
      "1.226`", "1.296`"},
     {
      TagBox["1981",
       HoldForm], "1.156`", "1.003`", "0.949`", "0.963`", "0.99`", "1.073`", 
      "0.977`", "0.688`"},
     {
      TagBox["1982",
       HoldForm], "1.117`", "1.465`", "1.215`", "1.187`", "1.213`", "1.311`", 
      "0.981`", "1.084`"},
     {
      TagBox["1983",
       HoldForm], "1.092`", "0.985`", "1.224`", "1.235`", "1.217`", "1.08`", 
      "1.237`", "0.872`"},
     {
      TagBox["1984",
       HoldForm], "1.103`", "1.159`", "1.061`", "1.03`", "0.903`", "1.15`", 
      "1.074`", "0.825`"},
     {
      TagBox["1985",
       HoldForm], "1.08`", "1.366`", "1.316`", "1.326`", "1.333`", "1.213`", 
      "1.562`", "1.006`"},
     {
      TagBox["1986",
       HoldForm], "1.063`", "1.309`", "1.186`", "1.161`", "1.086`", "1.156`", 
      "1.694`", "1.216`"},
     {
      TagBox["1987",
       HoldForm], "1.061`", "0.925`", "1.052`", "1.023`", "0.959`", "1.023`", 
      "1.246`", "1.244`"},
     {
      TagBox["1988",
       HoldForm], "1.071`", "1.086`", "1.165`", "1.179`", "1.165`", "1.076`", 
      "1.283`", "0.861`"},
     {
      TagBox["1989",
       HoldForm], "1.087`", "1.212`", "1.316`", "1.292`", "1.204`", "1.142`", 
      "1.105`", "0.977`"},
     {
      TagBox["1990",
       HoldForm], "1.08`", "1.054`", "0.968`", "0.938`", "0.83`", "1.083`", 
      "0.766`", "0.922`"},
     {
      TagBox["1991",
       HoldForm], "1.057`", "1.193`", "1.304`", "1.342`", "1.594`", "1.161`", 
      "1.121`", "0.958`"},
     {
      TagBox["1992",
       HoldForm], "1.036`", "1.079`", "1.076`", "1.09`", "1.174`", "1.076`", 
      "0.878`", "0.926`"},
     {
      TagBox["1993",
       HoldForm], "1.031`", "1.217`", "1.1`", "1.113`", "1.162`", "1.11`", 
      "1.326`", "1.146`"},
     {
      TagBox["1994",
       HoldForm], "1.045`", "0.889`", "1.012`", "0.999`", "0.968`", "0.965`", 
      "1.078`", "0.99`"},
     {"average", "1.078", "1.093", "1.120", "1.124", "1.121", "1.046", 
      "1.141", "1.130"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {
       False, True, False, False, False, False, False, False, False, False, 
        False, False, False, False, False, False, False, False, False, False, 
        False, False, False, {True}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$, 
    TableHeadings -> {{1973, 1974, 1975, 1976, 1977, 1978, 1979, 1980, 1981, 
      1982, 1983, 1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 
      1994}, {"3m Tbill", "long Tbond", "SP500", "Wilt.5000", "Corp. Bond", 
       "NASDQ", "EAFE", "Gold"}}]]]], "Text",
 FontFamily->"Times New Roman",
 CellID->950025626],

Cell["This is the annual return data.", "MathCaption",
 CellID->82223291],

Cell[BoxData[
 RowBox[{
  RowBox[{"R", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1.075`", ",", "1.084`", ",", "1.061`", ",", "1.052`", ",", "1.055`", 
       ",", "1.077`", ",", "1.109`", ",", "1.127`", ",", "1.156`", ",", 
       "1.117`", ",", "1.092`", ",", "1.103`", ",", "1.08`", ",", "1.063`", 
       ",", "1.061`", ",", "1.071`", ",", "1.087`", ",", "1.08`", ",", 
       "1.057`", ",", "1.036`", ",", "1.031`", ",", "1.045`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.942`", ",", "1.02`", ",", "1.056`", ",", "1.175`", ",", "1.002`", 
       ",", "0.982`", ",", "0.978`", ",", "0.947`", ",", "1.003`", ",", 
       "1.465`", ",", "0.985`", ",", "1.159`", ",", "1.366`", ",", "1.309`", 
       ",", "0.925`", ",", "1.086`", ",", "1.212`", ",", "1.054`", ",", 
       "1.193`", ",", "1.079`", ",", "1.217`", ",", "0.889`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.852`", ",", "0.735`", ",", "1.371`", ",", "1.236`", ",", "0.926`", 
       ",", "1.064`", ",", "1.184`", ",", "1.323`", ",", "0.949`", ",", 
       "1.215`", ",", "1.224`", ",", "1.061`", ",", "1.316`", ",", "1.186`", 
       ",", "1.052`", ",", "1.165`", ",", "1.316`", ",", "0.968`", ",", 
       "1.304`", ",", "1.076`", ",", "1.1`", ",", "1.012`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.815`", ",", "0.716`", ",", "1.385`", ",", "1.266`", ",", "0.974`", 
       ",", "1.093`", ",", "1.256`", ",", "1.337`", ",", "0.963`", ",", 
       "1.187`", ",", "1.235`", ",", "1.03`", ",", "1.326`", ",", "1.161`", 
       ",", "1.023`", ",", "1.179`", ",", "1.292`", ",", "0.938`", ",", 
       "1.342`", ",", "1.09`", ",", "1.113`", ",", "0.999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.698`", ",", "0.662`", ",", "1.318`", ",", "1.28`", ",", "1.093`", 
       ",", "1.146`", ",", "1.307`", ",", "1.367`", ",", "0.99`", ",", 
       "1.213`", ",", "1.217`", ",", "0.903`", ",", "1.333`", ",", "1.086`", 
       ",", "0.959`", ",", "1.165`", ",", "1.204`", ",", "0.83`", ",", 
       "1.594`", ",", "1.174`", ",", "1.162`", ",", "0.968`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.023`", ",", "1.002`", ",", "0.123`", ",", "1.156`", ",", "1.03`", 
       ",", "1.012`", ",", "1.023`", ",", "1.031`", ",", "1.073`", ",", 
       "1.311`", ",", "1.08`", ",", "1.15`", ",", "1.213`", ",", "1.156`", 
       ",", "1.023`", ",", "1.076`", ",", "1.142`", ",", "1.083`", ",", 
       "1.161`", ",", "1.076`", ",", "1.11`", ",", "0.965`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.851`", ",", "0.768`", ",", "1.354`", ",", "1.025`", ",", "1.181`", 
       ",", "1.326`", ",", "1.048`", ",", "1.226`", ",", "0.977`", ",", 
       "0.981`", ",", "1.237`", ",", "1.074`", ",", "1.562`", ",", "1.694`", 
       ",", "1.246`", ",", "1.283`", ",", "1.105`", ",", "0.766`", ",", 
       "1.121`", ",", "0.878`", ",", "1.326`", ",", "1.078`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.677`", ",", "1.722`", ",", "0.76`", ",", "0.96`", ",", "1.2`", ",", 
       "1.295`", ",", "2.212`", ",", "1.296`", ",", "0.688`", ",", "1.084`", 
       ",", "0.872`", ",", "0.825`", ",", "1.006`", ",", "1.216`", ",", 
       "1.244`", ",", "0.861`", ",", "0.977`", ",", "0.922`", ",", "0.958`", 
       ",", "0.926`", ",", "1.146`", ",", "0.99`"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->281723545],

Cell["\<\
Here are the expected returns over this 22-year period for the eight assets.\
\>", "MathCaption",
 CellID->281469995],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", ",", "nyear"}], "}"}], "=", 
   RowBox[{"Dimensions", "[", "R", "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->153203716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ER", "=", 
  RowBox[{"Mean", "[", 
   RowBox[{"Transpose", "@", "R"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->446438878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0781363636363634`", ",", "1.0929090909090908`", ",", 
   "1.1197727272727274`", ",", "1.1236363636363635`", ",", 
   "1.1213181818181819`", ",", "1.0463181818181817`", ",", 
   "1.1412272727272728`", ",", "1.1289545454545453`"}], "}"}]], "Output",
 ImageSize->{489, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->636888960]
}, Open  ]],

Cell["\<\
Here is the covariant matrix, which measures how the assets correlates to \
each other.\
\>", "MathCaption",
 CellID->144037048],

Cell[BoxData[
 RowBox[{
  RowBox[{"Covariants", "=", 
   RowBox[{"Covariance", "[", 
    RowBox[{"Transpose", "[", "R", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->563381096],

Cell[TextData[{
 "This finds the optimal asset allocation by minimizing the standard \
deviation of an allocation, subject to the constraints that the total \
allocation is 100% (",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Total", "[", 
    StyleBox["vars", "TI"], "]"}], "\[Equal]", "1"}]], "InlineFormula"],
 "), the expected return is over 12% (",
 Cell[BoxData[
  RowBox[{
   RowBox[{"vars", ".", "ER"}], "\[GreaterEqual]", "1.12"}]], 
  "InlineFormula"],
 "), and the variables must be non\[Hyphen]negative, thus each asset is \
allocated a non\[Hyphen]negative percentage (thus no shorting). The resulting \
optimal asset allocation suggests 15.5% in 3-month treasury bill, 20.3% in \
gold, and the rest in stocks, with a resulting standard deviation of 0.0126."
}], "MathCaption",
 CellID->163935546],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vars", " ", "=", " ", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"x", ",", "#"}], "]"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<3m T-bill\>\"", ",", "\"\<long T-bond\>\"", ",", "\"\<SP500\>\"", 
       ",", "\"\<Wiltshire 5000\>\"", ",", "\"\<Corporate Bond\>\"", ",", 
       "\"\<NASDQ\>\"", ",", "\"\<EAFE\>\"", ",", "\"\<Gold\>\""}], "}"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vars", " ", "=", " ", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"x", ",", "#"}], "]"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<3m T-bill\>\"", ",", "\"\<long T-bond\>\"", ",", "\"\<SP500\>\"", 
       ",", "\"\<Wiltshire 5000\>\"", ",", "\"\<Corporate Bond\>\"", ",", 
       "\"\<NASDQ\>\"", ",", "\"\<EAFE\>\"", ",", "\"\<Gold\>\""}], "}"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"vars", ".", "Covariants", ".", "vars"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Total", "[", "vars", "]"}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"vars", ".", "ER"}], "\[GreaterEqual]", "1.12"}], "&&", 
      RowBox[{"Apply", "[", 
       RowBox[{"And", ",", 
        RowBox[{"Thread", "[", 
         RowBox[{"Greater", "[", 
          RowBox[{"vars", ",", "0"}], "]"}], "]"}]}], "]"}]}]}], "}"}], ",", 
   "vars"}], "]"}]}], "Input",
 CellLabel->"In[18]:=",
 CellID->475457553],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.012623465098544243`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "\<\"3m T-bill\"\>"], "\[Rule]", 
      "0.15463210271081942`"}], ",", 
     RowBox[{
      SubscriptBox["x", "\<\"long T-bond\"\>"], "\[Rule]", 
      "0.01956452533243481`"}], ",", 
     RowBox[{
      SubscriptBox["x", "\<\"SP500\"\>"], "\[Rule]", "0.35443437276978995`"}],
      ",", 
     RowBox[{
      SubscriptBox["x", "\<\"Wiltshire 5000\"\>"], "\[Rule]", 
      "0.02382486066725388`"}], ",", 
     RowBox[{
      SubscriptBox["x", "\<\"Corporate Bond\"\>"], "\[Rule]", 
      "0.00013377469554407418`"}], ",", 
     RowBox[{
      SubscriptBox["x", "\<\"NASDQ\"\>"], "\[Rule]", 
      "0.000030919070214958244`"}], ",", 
     RowBox[{
      SubscriptBox["x", "\<\"EAFE\"\>"], "\[Rule]", "0.2439602608711854`"}], 
     ",", 
     RowBox[{
      SubscriptBox["x", "\<\"Gold\"\>"], "\[Rule]", 
      "0.20341918388275748`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{479, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->1848091402]
}, Open  ]],

Cell["\<\
This trades less return for smaller volatility by asking for an expected \
return of 10%. Now we have 55.5% in 3-month treasurury bill, 10.3% in gold, \
and the rest in stocks.\
\>", "MathCaption",
 CellID->41451921],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vars", " ", "=", " ", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"x", ",", "#"}], "]"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<3m T-bill\>\"", ",", "\"\<long T-bond\>\"", ",", "\"\<SP500\>\"", 
       ",", "\"\<Wiltshire 5000\>\"", ",", "\"\<Corporate Bond\>\"", ",", 
       "\"\<NASDQ\>\"", ",", "\"\<EAFE\>\"", ",", "\"\<Gold\>\""}], "}"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"vars", ".", "Covariants", ".", "vars"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Total", "[", "vars", "]"}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"vars", ".", "ER"}], "\[GreaterEqual]", "1.10"}], "&&", 
      RowBox[{"Apply", "[", 
       RowBox[{"And", ",", 
        RowBox[{"Thread", "[", 
         RowBox[{"Greater", "[", 
          RowBox[{"vars", ",", "0"}], "]"}], "]"}]}], "]"}]}]}], "}"}], ",", 
   "vars"}], "]"}]}], "Input",
 CellLabel->"In[16]:=",
 CellID->785622369],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.003659952418126092`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "\<\"3m T-bill\"\>"], "\[Rule]", 
      "0.5551717356419097`"}], ",", 
     RowBox[{
      SubscriptBox["x", "\<\"long T-bond\"\>"], "\[Rule]", 
      "0.024420470952289913`"}], ",", 
     RowBox[{
      SubscriptBox["x", "\<\"SP500\"\>"], "\[Rule]", "0.15670102319033416`"}],
      ",", 
     RowBox[{
      SubscriptBox["x", "\<\"Wiltshire 5000\"\>"], "\[Rule]", 
      "0.02238117464320886`"}], ",", 
     RowBox[{
      SubscriptBox["x", "\<\"Corporate Bond\"\>"], "\[Rule]", 
      "0.00017453951525811951`"}], ",", 
     RowBox[{
      SubscriptBox["x", "\<\"NASDQ\"\>"], "\[Rule]", 
      "0.000029302123266280495`"}], ",", 
     RowBox[{
      SubscriptBox["x", "\<\"EAFE\"\>"], "\[Rule]", "0.13858992037806986`"}], 
     ",", 
     RowBox[{
      SubscriptBox["x", "\<\"Gold\"\>"], "\[Rule]", 
      "0.10253183355566317`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{472, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->1667470526]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Limitations of the interior point method", "Subsection",
 CellID->417182119],

Cell[TextData[{
 "The implementation of the interior point method in ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " requires first and second derivatives of the objective and constraints. \
Symbolic derivatives are first attempted, and if they fail, finite difference \
will be used to calculate the derivatives. If the function or constraints are \
not smooth, particularly if the first derivative at the optimal point is not \
continuous, the interior point method may experience difficulty in \
converging."
}], "Text",
 CellID->219360895],

Cell["\<\
This shows that interior point method has difficulty in minimizing this \
nonsmooth function.\
\>", "MathCaption",
 CellID->102721021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"x", "-", "3"}], "]"}], ",", 
     RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "5"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->9075955],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"eit\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The algorithm does not converge to \
the tolerance of \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(4.806217383937354`*^-6\\)\
\\!\\(\\*StyleBox[\\\"\\\\\\\" in \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(500\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" iterations. The \
best estimated solution, with {feasibility residual, KKT residual, \
complementary residual} of \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\({4.54827422634314`*^-6, 0.04024668354109382`, \
2.274137113220318`*^-6}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\", is \
returned.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/FindMinimum\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellLabel->"During evaluation of In[29]:=",
 CellID->421277893],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8.717590878504211`*^-6", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.9999912824091215`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{200, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->559687620]
}, Open  ]],

Cell["\<\
This is somewhat similar to the difficulty experienced by an unconstrained \
Newton's method.\
\>", "MathCaption",
 CellID->141977083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Abs", "[", 
     RowBox[{"x", "-", "3"}], "]"}], "}"}], ",", 
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "Newton"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->538477959],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"lstol\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The line search decreased the step \
size to within tolerance specified by AccuracyGoal and PrecisionGoal but was \
unable to find a sufficient decrease in the function.  You may need more than \
\\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(MachinePrecision\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" digits \
of working precision to meet these tolerances.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/FindMinimum\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellLabel->"During evaluation of In[30]:=",
 CellID->579238285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8.063586022011293`*^-6", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.999991936413978`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{200, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->437337571]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical algorithms for constrained local optimization", "Section",
 CellTags->"Algorithms for",
 CellID->442312913],

Cell[CellGroupData[{

Cell["The interior point algorithm", "Subsection",
 CellTags->"interior point algorithm",
 CellID->2552526],

Cell["\<\
The interior point algorithm solves a constrained optimization by combining \
constraints and the objective function through the use of the barrier \
function. Specifically, the general constrained optimization problem is first \
converted to the standard form\
\>", "Text",
 CellID->149349736],

Cell[BoxData[{
 RowBox[{"Min", " ", "f", 
  RowBox[{"(", "x", ")"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"s", ".", "t", ".", "h"}], 
    RowBox[{"(", "x", ")"}]}], "=", "0"}], ",", 
  RowBox[{"x", "\[GreaterEqual]", "0."}]}]}], "NumberedEquation",
 CellID->578718612],

Cell["\<\
The non-negative constraints are then replaced by adding a barrier term to \
the objective function\
\>", "Text",
 CellID->26014154],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Min", "  ", 
   SubscriptBox["\[Psi]", "\[Mu]"], 
   RowBox[{"(", "x", ")"}]}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"f", 
    RowBox[{"(", "x", ")"}]}], " ", "-", " ", 
   RowBox[{"\[Mu]", " ", 
    RowBox[{
     SubscriptBox["\[Sum]", "i"], 
     RowBox[{"ln", 
      RowBox[{"(", 
       SubscriptBox["x", "i"], ")"}]}]}]}]}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"s", ".", "t", ".", " ", "h"}], 
    RowBox[{"(", "x", ")"}]}], " ", "=", " ", "0"}], ","}]}], "DisplayMath",
 CellID->179898937],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["\[Mu]", "TR"], ">", "0"}]], "InlineFormula"],
 " is a barrier parameter."
}], "Text",
 CellID->733184435],

Cell[TextData[{
 "The necessary Karush\[Dash]Kuhn\[Dash]Tucker (KKT) condition (assuming, for \
example, that the gradient of ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " is linearly independent) is "
}], "Text",
 CellID->5482757],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Del]", 
     SubscriptBox["\[Psi]", "\[Mu]"]}], 
    RowBox[{"(", "x", ")"}]}], " ", "-", " ", 
   RowBox[{
    SuperscriptBox["y", "T"], "A", 
    RowBox[{"(", "x", ")"}]}]}], "=", " ", "0"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"h", 
    RowBox[{"(", "x", ")"}]}], " ", "=", " ", "0"}], ","}]}], "DisplayMath",
 CellID->35380565],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", 
     RowBox[{"(", "x", ")"}]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Del]", 
         SubscriptBox["h", "1"]}], 
        RowBox[{"(", "x", ")"}]}], ",", 
       RowBox[{
        RowBox[{"\[Del]", 
         SubscriptBox["h", "2"]}], 
        RowBox[{"(", "x", ")"}]}], ",", "\[Ellipsis]", ",", 
       RowBox[{
        RowBox[{"\[Del]", 
         SubscriptBox["h", "m"]}], 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "T"]}], TraditionalForm]], 
  "InlineMath"],
 " is of dimension ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". Or"
}], "Text",
 CellID->1511032800],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"g", 
    RowBox[{"(", "x", ")"}]}], " ", "-", " ", 
   RowBox[{
    SuperscriptBox["\[Mu]X", 
     RowBox[{"-", "1"}]], "e"}], " ", "-", " ", 
   RowBox[{
    SuperscriptBox["y", "T"], " ", "A", 
    RowBox[{"(", "x", ")"}]}]}], "=", " ", "0"}], "\n", 
 RowBox[{
  RowBox[{"h", 
   RowBox[{"(", "x", ")"}]}], " ", "=", " ", "0"}]}], "DisplayMath",
 CellID->72929750],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  StyleBox["X", "TI"]], "InlineFormula"],
 " is a diagonal matrix, with the diagonal element ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], "\[Element]", 
   StyleBox["I", "TI"]}]], "InlineFormula"],
 ", or ",
 Cell[BoxData["0"], "InlineFormula"],
 ". Introducing dual variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"\[Mu]", " ", 
     SuperscriptBox["X", 
      RowBox[{"-", "1"}]], "e"}]}], TraditionalForm]], "InlineMath"],
 ", then"
}], "Text",
 CellID->1188750153],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"g", 
    RowBox[{"(", "x", ")"}]}], " ", "-", " ", "z", " ", "-", " ", 
   RowBox[{
    SuperscriptBox["y", "T"], "A", 
    RowBox[{"(", "x", ")"}]}]}], " ", "=", " ", "0"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"h", 
    RowBox[{"(", "x", ")"}]}], " ", "=", " ", "0"}], 
  "                                              "}], "\n", 
 RowBox[{
  RowBox[{"Z", " ", "X", " ", "e"}], " ", "=", " ", 
  RowBox[{"\[Mu]", " ", 
   RowBox[{"e", "."}]}]}]}], "NumberedEquation",
 CellTags->"KKTeq",
 CellID->305514034],

Cell[TextData[{
 "This nonlinear system can be solved with Newton's method. Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"L", "(", 
     RowBox[{"x", ",", " ", "y"}], ")"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], " ", "-", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"h", "(", "x", ")"}], "T"], " ", "y"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"H", "(", 
     RowBox[{"x", ",", "y"}], ")"}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Del]", "2"], 
      RowBox[{"L", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Del]", "2"], 
       RowBox[{"f", "(", "x", ")"}]}], " ", "-", 
      RowBox[{
       SubscriptBox[
        SuperscriptBox["\[Sum]", "m"], 
        RowBox[{"i", "=", "1"}]], 
       RowBox[{
        SubscriptBox["y", "i"], " ", 
        RowBox[{
         SuperscriptBox["\[Del]", "2"], 
         RowBox[{
          SubscriptBox["h", "i"], "(", "x", ")"}], " "}]}]}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 "; the Jacobi matrix of the above system (",
 
 CounterBox["NumberedEquation", "KKTeq"],
 ") is"
}], "Text",
 CellID->15158561],

Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{
   FormBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", GridBox[{
         {
          RowBox[{"H", "(", 
           RowBox[{"x", ",", "y"}], ")"}], 
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"A", "(", "x", ")"}], "T"]}], 
          RowBox[{"-", "I"}]},
         {
          RowBox[{"-", 
           RowBox[{"A", "(", "x", ")"}]}], "0", "0"},
         {"Z", "0", "X"}
        }], ")"}], 
      RowBox[{"(", GridBox[{
         {"\[Delta]x"},
         {"\[Delta]y"},
         {"\[Delta]z"}
        }], ")"}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", GridBox[{
          {
           RowBox[{
            RowBox[{"g", "(", "x", ")"}], "-", "z", "-", 
            RowBox[{
             SuperscriptBox["y", "T"], 
             RowBox[{"A", "(", "x", ")"}], " "}]}]},
          {
           RowBox[{"-", 
            RowBox[{"h", "(", "x", ")"}]}]},
          {
           RowBox[{
            RowBox[{"Z", " ", "X", " ", "e"}], " ", "-", " ", 
            RowBox[{"\[Mu]", " ", "e"}]}]}
         }], ")"}]}], " ", "=", 
      RowBox[{"-", " ", 
       RowBox[{"(", GridBox[{
          {
           SubscriptBox["d", "\[Psi]"]},
          {
           RowBox[{"-", 
            SubscriptBox["d", "h"]}]},
          {
           SubscriptBox["d", "xz"]}
         }], ")"}]}]}]}],
    TraditionalForm], "."}]}]], "DisplayMath",
 CellTags->"NewtonSystem",
 CellID->136203660],

Cell[TextData[{
 "Eliminating ",
 Cell[BoxData[
  FormBox["\[Delta]z", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]z", " ", "=", " ", 
    RowBox[{"-", 
     RowBox[{
      SuperscriptBox["X", 
       RowBox[{"-", "1"}]], "(", 
      RowBox[{
       RowBox[{"Z", " ", "\[Delta]x"}], " ", "+", " ", 
       SubscriptBox["d", "xz"]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"H", "(", 
         RowBox[{"x", ",", "y"}], ")"}], "+", 
        RowBox[{
         SuperscriptBox["X", 
          RowBox[{"-", "1"}]], "Z"}]}], ")"}], " ", 
      SubscriptBox["\[Delta]", "x"]}], " ", "-", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"A", "(", "x", ")"}], "T"], "\[Delta]y"}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["d", "\[Psi]"]}], " ", "-", " ", 
     RowBox[{
      SuperscriptBox["X", 
       RowBox[{"-", "1"}]], 
      SubscriptBox["d", "xz"]}]}]}], TraditionalForm]], "InlineMath"],
 ", thus"
}], "Text",
 CellID->661712079],

Cell[BoxData[
 RowBox[{"\n", 
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", GridBox[{
        {
         RowBox[{
          RowBox[{"H", "(", 
           RowBox[{"x", ",", "y"}], ")"}], "+", 
          RowBox[{
           SuperscriptBox["X", 
            RowBox[{"-", "1"}]], "Z"}]}], 
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"A", "(", "x", ")"}], "T"]}]},
        {
         RowBox[{"-", 
          RowBox[{"A", "(", "x", ")"}]}], "0"}
       }], ")"}], 
     RowBox[{"(", GridBox[{
        {"\[Delta]x"},
        {"\[Delta]y"}
       }], ")"}]}], " ", "=", 
    RowBox[{
     RowBox[{"-", " ", 
      RowBox[{"(", GridBox[{
         {
          RowBox[{
           SubscriptBox["d", "\[Psi]"], " ", "+", " ", 
           RowBox[{
            SuperscriptBox["X", 
             RowBox[{"-", "1"}]], 
            SubscriptBox["d", "xz"]}]}]},
         {
          RowBox[{"-", 
           SubscriptBox["d", "h"]}]}
        }], ")"}]}], " ", "=", " ", 
     RowBox[{"-", 
      RowBox[{"(", GridBox[{
         {
          RowBox[{
           RowBox[{"g", "(", "x", ")"}], " ", "-", " ", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"A", "(", "x", ")"}], "T"], "y"}], " ", "-", " ", 
           RowBox[{"\[Mu]", " ", 
            SuperscriptBox["X", 
             RowBox[{"-", "1"}]], "e"}]}]},
         {
          RowBox[{"-", 
           RowBox[{"h", "(", "x", ")"}]}]}
        }], ")"}]}]}]}],
   TraditionalForm], " "}]], "NumberedEquation",
 CellTags->"ReducedSystem",
 CellID->126679068],

Cell["\<\
Thus the nonlinear constrained problem can be solved iteratively by \
\>", "Text",
 CellID->869933366],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["x", "TI"], ":=", 
   RowBox[{
    StyleBox["x", "TI"], "+", 
    StyleBox["\[Delta]x", "TI"]}]}], ",", 
  RowBox[{
   StyleBox["y", "TI"], ":=", 
   RowBox[{
    StyleBox["y", "TI"], "+", 
    StyleBox["\[Delta]y", "TI"]}]}], ",", 
  RowBox[{
   StyleBox["z", "TI"], ":=", 
   RowBox[{
    StyleBox["z", "TI"], "+", 
    StyleBox["\[Delta]z", "TI"]}]}]}]], "InlineFormula"]], "NumberedEquation",\

 CellTags->"Iterate",
 CellID->288363465],

Cell[TextData[{
 "with the search direction ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"\[Delta]x", ",", "\[Delta]y", ",", "\[Delta]z"}], "}"}], 
   TraditionalForm]], "InlineMath"],
 " given by solving the above Jacobi system (",
 
 CounterBox["NumberedEquation", "ReducedSystem"],
 ")."
}], "Text",
 CellID->515274567],

Cell["\<\
To ensure convergence, you need to have some measure of success. One way of \
doing this is to use a merit function, such as the following augmented \
Langrangian merit function.\
\>", "Text",
 CellID->146049677],

Cell[CellGroupData[{

Cell["Augmented Langrangian merit function", "Subsubsection",
 CellID->889704420],

Cell["This defines an augmented Langrangian merit function", "Text",
 CellID->575936050],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Phi]", 
    RowBox[{"(", 
     RowBox[{"x", ",", "\[Beta]"}], ")"}]}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"f", 
      RowBox[{"(", "x", ")"}]}], "-", 
     RowBox[{"\[Mu]", 
      RowBox[{
       SubscriptBox["\[Sum]", "i"], 
       RowBox[{"ln", 
        RowBox[{"(", 
         SubscriptBox["x", "i"], ")"}]}]}]}], "-", 
     RowBox[{"h", 
      SuperscriptBox[
       RowBox[{"(", "x", ")"}], "T"], "\[Lambda]"}], " ", "+", " ", 
     "\[Beta]"}], "||", 
    RowBox[{"h", 
     RowBox[{"(", "x", ")"}]}], 
    SuperscriptBox["||", "2"]}]}]], "InlineFormula"],
 "."
}], "NumberedEquation",
 CellTags->"MeritFunction",
 CellID->4963919],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Mu]", ">", "0"}], TraditionalForm]], "InlineMath"],
 " is the barrier parameter and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Beta]", ">", "0"}], TraditionalForm]], "InlineMath"],
 " a penalty parameter. It can be proved that if the matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"N", 
     RowBox[{"(", 
      RowBox[{"x", ",", "y"}], ")"}]}], "=", 
    RowBox[{
     RowBox[{"H", 
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["X", 
       RowBox[{"-", "1"}]], "Z"}]}]}], TraditionalForm]], "InlineMath"],
 " is positive definite, then either the search direction given by (",
 
 CounterBox["NumberedEquation", "Iterate"],
 ") is a decent direction for the above merit function (",
 
 CounterBox["NumberedEquation", "MeritFunction"],
 "), or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "\[Mu]"}], "}"}], TraditionalForm]],
   "InlineMath"],
 " satisfied the KKT condition (",
 
 CounterBox["NumberedEquation", "KKTeq"],
 "). A line search is performed along the search direction, with the initial \
step length chosen to be as close to 1 as possible, while maintaining the \
positive constraints. A backtracking procedure is then used until the Armijo \
condition is satisfied on the merit function, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Phi]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "+", "t\[Delta]x"}], ",", "\[Beta]"}], ")"}]}], 
    "\[LessEqual]", " ", 
    RowBox[{
     RowBox[{"\[Phi]", 
      RowBox[{"(", 
       RowBox[{"x", ",", "\[Beta]"}], ")"}]}], "+", 
     RowBox[{"\[Gamma]", " ", "t", " ", 
      RowBox[{"\[Del]", "\[Phi]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", ",", "\[Beta]"}], ")"}], "T"], "\[Delta]x"}]}]}], 
   TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Gamma]", "\[Element]", 
     RowBox[{"(", 
      RowBox[{"0", ",", 
       RowBox[{"1", "/", "2"}]}]}]}], "]"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->29970301]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Convergence tolerance", "Subsubsection",
 CellID->100030294],

Cell[TextData[{
 "The convergence criterion for the interior point algorithm is \n",
 Cell[BoxData[
  RowBox[{"   ", 
   FormBox[
    RowBox[{"||", 
     RowBox[{
      RowBox[{"g", "(", "x", ")"}], " ", "-", " ", "z", " ", "-", " ", 
      RowBox[{
       SuperscriptBox["y", "T"], 
       RowBox[{"A", "(", "x", ")"}]}]}], "||", " ", 
     RowBox[{"+", " ", 
      RowBox[{"||", 
       RowBox[{"h", "(", "x", ")"}], "||", " ", 
       RowBox[{"+", " ", 
        RowBox[{"||", 
         RowBox[{
          RowBox[{"Z", " ", "X", " ", "e"}], " ", "-", " ", 
          RowBox[{"\[Mu]", " ", "e"}]}], "||", 
         RowBox[{"\[LessEqual]", " ", "tol"}]}]}]}]}]}],
    TraditionalForm]}]], "Text"],
 "\nwith ",
 Cell[BoxData["tol"], "InlineFormula"],
 " set, by default, to ",
 Cell[BoxData[
  SuperscriptBox["10", 
   RowBox[{
    RowBox[{"-", "MachinePrecision"}], "/", "3"}]]], "InlineFormula"],
 "."
}], "Text",
 CellID->452047157],

Cell["", "Text",
 CellID->91172314]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->972440725],

Cell[TextData[ButtonBox["Constrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->1633042],

Cell[TextData[ButtonBox["Linear Programming",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming"]], \
"RelatedTutorials",
 CellID->282186215],

Cell[TextData[ButtonBox["Numerical Nonlinear Global Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationGlobalNumerical"]], \
"RelatedTutorials",
 CellID->125693634],

Cell[TextData[ButtonBox["Exact Global Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact"]], "RelatedTutorials",
 CellID->140984286]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Nonlinear Local Optimization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 34.3742462}", "context" -> "", 
    "keywords" -> {
     "constrained optimization", "nonlinear programming", 
      "local optimization", "nonlinear interior point"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Numerical algorithms for constrained nonlinear optimization can be \
broadly categorized into gradient-based methods and direct search methods. \
Gradient search methods uses first derivatives (gradients) or second \
derivatives (Hessians) information. Examples are the SQP (sequential \
quadratic programming) method, the augmented Lagrangian method, and the \
(nonlinear) interior point method. Direct search methods do not use \
derivative information. Examples are Nelder-Mead, genetic algorithm and \
differential evolution, and simulated annealing. Direct search methods tend \
to converge more slowly, but can be more tolerant to the presence of noise in \
the function and constraints. Typically, algorithms only build up a local \
model of the problems. Furthermore, to ensure convergence of the iterative \
process, many such algorithms insist on a certain decrease of the objective \
function or of a merit function which is a combination of the objective and \
constraints. Such algorithms will, if convergent, only find local optimum, \
and are called local optimization algorithms. In Mathematica local \
optimization problems can be solved using FindMinimum. Global optimization \
algorithms, on the other hand, attempt to find the global optimum, typically \
by allowing decrease as well as increase of the objective/merit function. \
Such algorithms are usually computationally more expensive. Global \
optimization problems can be solved exactly using Minimize or numerically \
using NMinimize.", "synonyms" -> {}, "title" -> 
    "Numerical Nonlinear Local Optimization", "type" -> "Tutorial", "uri" -> 
    "tutorial/ConstrainedOptimizationLocalNumerical"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:0.2.1"->{
  Cell[180044, 3397, 134, 4, 70, "MathCaption",
   CellTags->"b:0.2.1",
   CellID->117718009],
  Cell[182375, 3482, 374, 11, 70, "MathCaption",
   CellTags->"b:0.2.1",
   CellID->455952803],
  Cell[185824, 3584, 291, 9, 70, "MathCaption",
   CellTags->"b:0.2.1",
   CellID->656288743],
  Cell[354200, 6503, 261, 9, 70, "MathCaption",
   CellTags->"b:0.2.1",
   CellID->156944844],
  Cell[356392, 6579, 410, 14, 70, "MathCaption",
   CellTags->"b:0.2.1",
   CellID->90894111]},
 "Algorithms for"->{
  Cell[390754, 7643, 123, 2, 70, "Section",
   CellTags->"Algorithms for",
   CellID->442312913]},
 "interior point algorithm"->{
  Cell[390902, 7649, 107, 2, 70, "Subsection",
   CellTags->"interior point algorithm",
   CellID->2552526]},
 "KKTeq"->{
  Cell[395063, 7812, 559, 18, 70, "NumberedEquation",
   CellTags->"KKTeq",
   CellID->305514034]},
 "NewtonSystem"->{
  Cell[396890, 7878, 1469, 53, 70, "DisplayMath",
   CellTags->"NewtonSystem",
   CellID->136203660]},
 "ReducedSystem"->{
  Cell[399510, 7977, 1552, 55, 70, "NumberedEquation",
   CellTags->"ReducedSystem",
   CellID->126679068]},
 "Iterate"->{
  Cell[401180, 8039, 501, 19, 70, "NumberedEquation",
   CellTags->"Iterate",
   CellID->288363465]},
 "MeritFunction"->{
  Cell[402444, 8089, 711, 26, 70, "NumberedEquation",
   CellTags->"MeritFunction",
   CellID->4963919]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:0.2.1", 410217, 8323},
 {"Algorithms for", 410715, 8339},
 {"interior point algorithm", 410845, 8343},
 {"KKTeq", 410967, 8347},
 {"NewtonSystem", 411086, 8351},
 {"ReducedSystem", 411209, 8355},
 {"Iterate", 411332, 8359},
 {"MeritFunction", 411454, 8363}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1225, 27, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1850, 54, 74, 1, 70, "Title",
 CellID->85183321],
Cell[CellGroupData[{
Cell[1949, 59, 51, 1, 70, "Section",
 CellID->469184158],
Cell[2003, 62, 795, 14, 70, "Text",
 CellID->289642637],
Cell[2801, 78, 689, 16, 70, "Text",
 CellID->65223348],
Cell[3493, 96, 641, 20, 70, "Text",
 CellID->166790006],
Cell[4137, 118, 80, 1, 70, "Text",
 CellID->303464556],
Cell[4220, 121, 420, 13, 70, "DisplayMath",
 CellID->401358986],
Cell[4643, 136, 216, 9, 70, "Text",
 CellID->73215332],
Cell[CellGroupData[{
Cell[4884, 149, 496, 17, 30, "Input",
 CellID->213704],
Cell[5383, 168, 336, 12, 36, "Output",
 CellID->434225361]
}, Open  ]],
Cell[5734, 183, 254, 8, 70, "Text",
 CellID->109220874],
Cell[CellGroupData[{
Cell[6013, 195, 499, 17, 70, "Input",
 CellID->38568035],
Cell[6515, 214, 420, 14, 39, "Output",
 CellID->199547764]
}, Open  ]],
Cell[6950, 231, 279, 8, 70, "Text",
 CellID->583307620],
Cell[CellGroupData[{
Cell[7254, 243, 500, 17, 70, "Input",
 CellID->7703726],
Cell[7757, 262, 396, 13, 39, "Output",
 CellID->411160828]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8202, 281, 62, 1, 70, "Section",
 CellID->73716527],
Cell[8267, 284, 626, 17, 70, "Text",
 CellID->16081535],
Cell[8896, 303, 1048, 37, 70, "MathCaption",
 CellID->358089548],
Cell[CellGroupData[{
Cell[9969, 344, 996, 34, 70, "Input",
 CellID->83250509],
Cell[10968, 380, 432, 14, 36, "Output",
 CellID->27717002]
}, Open  ]],
Cell[11415, 397, 405, 14, 70, "MathCaption",
 CellID->525779614],
Cell[CellGroupData[{
Cell[11845, 415, 1050, 36, 70, "Input",
 CellID->551050557],
Cell[12898, 453, 392, 13, 36, "Output",
 CellID->68607961]
}, Open  ]],
Cell[13305, 469, 274, 8, 70, "Text",
 CellID->129275445],
Cell[13582, 479, 134, 4, 70, "MathCaption",
 CellID->668365059],
Cell[CellGroupData[{
Cell[13741, 487, 1973, 61, 70, "Input",
 CellID->423568925],
Cell[15717, 550, 142328, 2374, 70, "Output",
 CellID->446066285]
}, Open  ]],
Cell[158060, 2927, 117, 3, 70, "MathCaption",
 CellID->688017386],
Cell[CellGroupData[{
Cell[158202, 2934, 2214, 66, 127, "Input",
 CellID->33096686],
Cell[160419, 3002, 15683, 261, 158, "Output",
 Evaluatable->False,
 CellID->828546970]
}, Open  ]],
Cell[CellGroupData[{
Cell[176139, 3268, 65, 1, 70, "Subsection",
 CellID->396232162],
Cell[176207, 3271, 197, 7, 70, "Text",
 CellID->3902796],
Cell[176407, 3280, 3152, 98, 70, "DefinitionBox3Col",
 CellID->418523506],
Cell[179562, 3380, 46, 1, 70, "Input",
 CellID->832328712],
Cell[179611, 3383, 430, 12, 70, "Text",
 CellID->167853318],
Cell[180044, 3397, 134, 4, 70, "MathCaption",
 CellTags->"b:0.2.1",
 CellID->117718009],
Cell[CellGroupData[{
Cell[180203, 3405, 655, 22, 70, "Input",
 CellID->741406091],
Cell[180861, 3429, 414, 13, 36, "Output",
 CellID->8522603]
}, Open  ]],
Cell[181290, 3445, 36, 1, 70, "Text",
 CellID->399254837],
Cell[181329, 3448, 494, 15, 70, "Text",
 CellID->87871122],
Cell[181826, 3465, 546, 15, 70, "Text",
 CellID->631575790],
Cell[182375, 3482, 374, 11, 70, "MathCaption",
 CellTags->"b:0.2.1",
 CellID->455952803],
Cell[CellGroupData[{
Cell[182774, 3497, 1715, 51, 70, "Input",
 CellID->541813507],
Cell[184492, 3550, 880, 15, 70, "Message",
 CellID->75949714],
Cell[185375, 3567, 434, 14, 36, "Output",
 CellID->371786669]
}, Open  ]],
Cell[185824, 3584, 291, 9, 70, "MathCaption",
 CellTags->"b:0.2.1",
 CellID->656288743],
Cell[CellGroupData[{
Cell[186140, 3597, 1847, 57, 70, "Input",
 CellID->214909321],
Cell[187990, 3656, 161855, 2687, 70, "Output",
 CellID->517922011]
}, Open  ]],
Cell[349860, 6346, 1042, 35, 70, "Text",
 CellID->38230157],
Cell[350905, 6383, 1694, 61, 70, "Text",
 CellID->358638282],
Cell[352602, 6446, 1595, 55, 70, "Text",
 CellID->356579338],
Cell[354200, 6503, 261, 9, 70, "MathCaption",
 CellTags->"b:0.2.1",
 CellID->156944844],
Cell[CellGroupData[{
Cell[354486, 6516, 1112, 36, 70, "Input",
 CellID->190472588],
Cell[355601, 6554, 776, 22, 122, "Output",
 CellID->157222145]
}, Open  ]],
Cell[356392, 6579, 410, 14, 70, "MathCaption",
 CellTags->"b:0.2.1",
 CellID->90894111],
Cell[356805, 6595, 1106, 36, 70, "Input",
 CellID->589714726],
Cell[CellGroupData[{
Cell[357936, 6635, 206, 7, 70, "Input",
 CellID->758821354],
Cell[358145, 6644, 230, 6, 36, "Output",
 CellID->87445977]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[358436, 6657, 62, 1, 70, "Section",
 CellID->804055587],
Cell[CellGroupData[{
Cell[358523, 6662, 65, 1, 70, "Subsection",
 CellID->92384034],
Cell[358591, 6665, 1255, 39, 70, "Text",
 CellID->654543307],
Cell[359849, 6706, 254, 8, 70, "MathCaption",
 CellID->435952806],
Cell[CellGroupData[{
Cell[360128, 6718, 288, 10, 28, "Input",
 CellID->117478811],
Cell[360419, 6730, 2389, 43, 129, "Output",
 Evaluatable->False,
 CellID->506710115]
}, Open  ]],
Cell[362823, 6776, 253, 8, 70, "MathCaption",
 CellID->217991463],
Cell[CellGroupData[{
Cell[363101, 6788, 354, 12, 70, "Input",
 CellID->423100040],
Cell[363458, 6802, 335, 11, 36, "Output",
 CellID->625661101]
}, Open  ]],
Cell[363808, 6816, 278, 9, 70, "MathCaption",
 CellID->255153148],
Cell[CellGroupData[{
Cell[364111, 6829, 427, 15, 70, "Input",
 CellID->823716126],
Cell[364541, 6846, 334, 11, 36, "Output",
 CellID->310530621]
}, Open  ]],
Cell[364890, 6860, 94, 1, 70, "MathCaption",
 CellID->47465889],
Cell[CellGroupData[{
Cell[365009, 6865, 448, 15, 70, "Input",
 CellID->425978146],
Cell[365460, 6882, 334, 11, 36, "Output",
 CellID->277310375]
}, Open  ]],
Cell[365809, 6896, 139, 4, 70, "MathCaption",
 CellID->731286755],
Cell[CellGroupData[{
Cell[365973, 6904, 716, 24, 70, "Input",
 CellID->378762536],
Cell[366692, 6930, 1978, 60, 88, "Output",
 CellID->101360392]
}, Open  ]],
Cell[368685, 6993, 382, 11, 70, "MathCaption",
 CellID->755928725],
Cell[CellGroupData[{
Cell[369092, 7008, 543, 17, 70, "Input",
 CellID->738377250],
Cell[369638, 7027, 333, 11, 36, "Output",
 CellID->1400975415]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[370020, 7044, 64, 1, 70, "Subsection",
 CellID->609426104],
Cell[370087, 7047, 520, 9, 70, "Text",
 CellID->317442549],
Cell[370610, 7058, 231, 5, 70, "Text",
 CellID->341559375],
Cell[370844, 7065, 310, 9, 70, "Text",
 CellID->1491598396],
Cell[371157, 7076, 36, 1, 70, "Text",
 CellID->283189999],
Cell[371196, 7079, 4706, 138, 70, "Text",
 CellID->950025626],
Cell[375905, 7219, 73, 1, 70, "MathCaption",
 CellID->82223291],
Cell[375981, 7222, 3429, 63, 70, "Input",
 CellID->281723545],
Cell[379413, 7287, 127, 3, 70, "MathCaption",
 CellID->281469995],
Cell[379543, 7292, 201, 7, 70, "Input",
 CellID->153203716],
Cell[CellGroupData[{
Cell[379769, 7303, 156, 5, 70, "Input",
 CellID->446438878],
Cell[379928, 7310, 423, 11, 36, "Output",
 CellID->636888960]
}, Open  ]],
Cell[380366, 7324, 138, 4, 70, "MathCaption",
 CellID->144037048],
Cell[380507, 7330, 196, 6, 70, "Input",
 CellID->563381096],
Cell[380706, 7338, 804, 18, 70, "MathCaption",
 CellID->163935546],
Cell[CellGroupData[{
Cell[381535, 7360, 1575, 44, 70, "Input",
 CellID->475457553],
Cell[383113, 7406, 1133, 33, 73, "Output",
 CellID->1848091402]
}, Open  ]],
Cell[384261, 7442, 226, 5, 70, "MathCaption",
 CellID->41451921],
Cell[CellGroupData[{
Cell[384512, 7451, 1103, 31, 70, "Input",
 CellID->785622369],
Cell[385618, 7484, 1134, 33, 73, "Output",
 CellID->1667470526]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[386801, 7523, 82, 1, 70, "Subsection",
 CellID->417182119],
Cell[386886, 7526, 626, 13, 70, "Text",
 CellID->219360895],
Cell[387515, 7541, 144, 4, 70, "MathCaption",
 CellID->102721021],
Cell[CellGroupData[{
Cell[387684, 7549, 320, 10, 70, "Input",
 CellID->9075955],
Cell[388007, 7561, 880, 16, 70, "Message",
 CellID->421277893],
Cell[388890, 7579, 301, 10, 39, "Output",
 CellID->559687620]
}, Open  ]],
Cell[389206, 7592, 144, 4, 70, "MathCaption",
 CellID->141977083],
Cell[CellGroupData[{
Cell[389375, 7600, 287, 9, 70, "Input",
 CellID->538477959],
Cell[389665, 7611, 725, 13, 70, "Message",
 CellID->579238285],
Cell[390393, 7626, 300, 10, 39, "Output",
 CellID->437337571]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[390754, 7643, 123, 2, 70, "Section",
 CellTags->"Algorithms for",
 CellID->442312913],
Cell[CellGroupData[{
Cell[390902, 7649, 107, 2, 70, "Subsection",
 CellTags->"interior point algorithm",
 CellID->2552526],
Cell[391012, 7653, 304, 6, 70, "Text",
 CellID->149349736],
Cell[391319, 7661, 285, 9, 70, "NumberedEquation",
 CellID->578718612],
Cell[391607, 7672, 142, 4, 70, "Text",
 CellID->26014154],
Cell[391752, 7678, 551, 19, 70, "DisplayMath",
 CellID->179898937],
Cell[392306, 7699, 171, 7, 70, "Text",
 CellID->733184435],
Cell[392480, 7708, 248, 7, 70, "Text",
 CellID->5482757],
Cell[392731, 7717, 397, 14, 70, "DisplayMath",
 CellID->35380565],
Cell[393131, 7733, 792, 31, 70, "Text",
 CellID->1511032800],
Cell[393926, 7766, 414, 14, 70, "DisplayMath",
 CellID->72929750],
Cell[394343, 7782, 717, 28, 70, "Text",
 CellID->1188750153],
Cell[395063, 7812, 559, 18, 70, "NumberedEquation",
 CellTags->"KKTeq",
 CellID->305514034],
Cell[395625, 7832, 1262, 44, 70, "Text",
 CellID->15158561],
Cell[396890, 7878, 1469, 53, 70, "DisplayMath",
 CellTags->"NewtonSystem",
 CellID->136203660],
Cell[398362, 7933, 1145, 42, 70, "Text",
 CellID->661712079],
Cell[399510, 7977, 1552, 55, 70, "NumberedEquation",
 CellTags->"ReducedSystem",
 CellID->126679068],
Cell[401065, 8034, 112, 3, 70, "Text",
 CellID->869933366],
Cell[401180, 8039, 501, 19, 70, "NumberedEquation",
 CellTags->"Iterate",
 CellID->288363465],
Cell[401684, 8060, 335, 12, 70, "Text",
 CellID->515274567],
Cell[402022, 8074, 222, 5, 70, "Text",
 CellID->146049677],
Cell[CellGroupData[{
Cell[402269, 8083, 81, 1, 70, "Subsubsection",
 CellID->889704420],
Cell[402353, 8086, 88, 1, 70, "Text",
 CellID->575936050],
Cell[402444, 8089, 711, 26, 70, "NumberedEquation",
 CellTags->"MeritFunction",
 CellID->4963919],
Cell[403158, 8117, 2164, 71, 70, "Text",
 CellID->29970301]
}, Open  ]],
Cell[CellGroupData[{
Cell[405359, 8193, 67, 1, 70, "Subsubsection",
 CellID->100030294],
Cell[405429, 8196, 934, 30, 70, "Text",
 CellID->452047157],
Cell[406366, 8228, 35, 1, 70, "Text",
 CellID->91172314]
}, Open  ]],
Cell[CellGroupData[{
Cell[406438, 8234, 72, 1, 70, "RelatedTutorialsSection",
 CellID->972440725],
Cell[406513, 8237, 178, 4, 70, "RelatedTutorials",
 CellID->1633042],
Cell[406694, 8243, 185, 5, 70, "RelatedTutorials",
 CellID->282186215],
Cell[406882, 8250, 204, 5, 70, "RelatedTutorials",
 CellID->125693634],
Cell[407089, 8257, 178, 4, 70, "RelatedTutorials",
 CellID->140984286]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[407318, 8267, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

