(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28321,       1002]
NotebookOptionsPosition[     22821,        818]
NotebookOutlinePosition[     25198,        883]
CellTagsIndexPosition[     25107,        877]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Manipulating Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apply" :> Documentation`HelpLookup["paclet:ref/Apply"], 
          "Array" :> Documentation`HelpLookup["paclet:ref/Array"], "Cases" :> 
          Documentation`HelpLookup["paclet:ref/Cases"], "List" :> 
          Documentation`HelpLookup["paclet:ref/List"], "Map" :> 
          Documentation`HelpLookup["paclet:ref/Map"], "MapIndexed" :> 
          Documentation`HelpLookup["paclet:ref/MapIndexed"], "NestList" :> 
          Documentation`HelpLookup["paclet:ref/NestList"], "Normal" :> 
          Documentation`HelpLookup["paclet:ref/Normal"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"], "Pick" :> 
          Documentation`HelpLookup["paclet:ref/Pick"], "Range" :> 
          Documentation`HelpLookup["paclet:ref/Range"], "Reap" :> 
          Documentation`HelpLookup["paclet:ref/Reap"], "Select" :> 
          Documentation`HelpLookup["paclet:ref/Select"], "Sow" :> 
          Documentation`HelpLookup["paclet:ref/Sow"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "TakeWhile" :> 
          Documentation`HelpLookup["paclet:ref/TakeWhile"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Apply\"\>", 2->"\<\"Array\"\>", 
       3->"\<\"Cases\"\>", 4->"\<\"List\"\>", 5->"\<\"Map\"\>", 
       6->"\<\"MapIndexed\"\>", 7->"\<\"NestList\"\>", 8->"\<\"Normal\"\>", 
       9->"\<\"Part\"\>", 10->"\<\"Pick\"\>", 11->"\<\"Range\"\>", 
       12->"\<\"Reap\"\>", 13->"\<\"Select\"\>", 14->"\<\"Sow\"\>", 
       15->"\<\"SparseArray\"\>", 16->"\<\"Table\"\>", 
       17->"\<\"TakeWhile\"\>", 18->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Constructing Lists", "Title",
 CellTags->{"S2.4.1", "1.1"},
 CellID->28009],

Cell[TextData[{
 "Lists are widely used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and there are many ways to construct them."
}], "Text",
 CellID->27157],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Range",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Range"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the list ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "\[Ellipsis]", ",", "n"}], 
        "}"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "the values of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " from ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Array"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the list ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "[", "1", "]"}], ",", 
         RowBox[{"f", "[", "2", "]"}], ",", "\[Ellipsis]", ",", 
         RowBox[{"f", "[", "n", "]"}]}], "}"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NestList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NestList"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", "x", "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"f", "[", "x", "]"}], "]"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     " with up to ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " nestings"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Normal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Normal"], "[", 
     RowBox[{
      ButtonBox["SparseArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SparseArray"], "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["n", "TI"]}], "]"}], "]"}], Cell[TextData[{
     "a length ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " list with element ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["i", "k"], TraditionalForm]], "InlineMath"],
     " being ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["v", "k"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Apply",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Apply"], "[", 
     ButtonBox["List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/List"], ",", 
     StyleBox["f", "TI"], "[", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", "]"}], Cell[TextData[{
     "the list ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["e", "1"], ",", 
         SubscriptBox["e", "2"], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.45], {
      Scaled[0.55]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->20472],

Cell["Some explicit ways to construct lists. ", "Caption",
 CellID->23622],

Cell["This gives a table of the first five powers of two. ", "MathCaption",
 CellID->18538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"2", "^", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->12292],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "8", ",", "16", ",", "32"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->6038]
}, Open  ]],

Cell["Here is another way to get the same result. ", "MathCaption",
 CellID->24179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", "#"}], "&"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->18190],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "8", ",", "16", ",", "32"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->29657]
}, Open  ]],

Cell["This gives a similar list. ", "MathCaption",
 CellID->7958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "#"}], "&"}], ",", "1", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32"}], 
  "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->19815]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " lets you specify values at particular positions. "
}], "MathCaption",
 CellID->22888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "->", "x"}], ",", 
      RowBox[{"4", "->", "y"}]}], "}"}], ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->19156],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "x", ",", "y", ",", "0"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->11511]
}, Open  ]],

Cell["You can also use patterns to specify values. ", "MathCaption",
 CellID->16202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i_", "->", 
      RowBox[{"2", "^", "i"}]}], "}"}], ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->2634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "8", ",", "16", ",", "32"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->24272]
}, Open  ]],

Cell["\<\
Often you will know in advance how long a list is supposed to be, and how \
each of its elements should be generated. And often you may get one list from \
another. \
\>", "Text",
 CellID->20055],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["list", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "the values of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " taking on values from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Map",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Map"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " to each element of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MapIndexed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MapIndexed"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      FormBox[
       RowBox[{"f", "[", 
        StyleBox["elem", "TI"], ",", "{", "i", "}", "]"}], TraditionalForm]], 
      "InlineMath"],
     " for the ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Cases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cases"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "give elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " that match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Select",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Select"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["test", "TI"], "]"}], Cell[TextData[{
     "select elements for which ",
     Cell[BoxData[
      RowBox[{
       StyleBox["test", "TI"], "[", 
       StyleBox["elem", "TI"], "]"}]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Pick",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pick"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["sel", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "pick out elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " for which the corresponding elements of ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"],
     " match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TakeWhile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TakeWhile"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["test", "TI"]}], "]"}], Cell[TextData[{
     "gives elements ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
     " from the beginning of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " as long as ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["test", "TI"], "[", 
        SubscriptBox["e", "i"], "]"}], TraditionalForm]], "InlineMath"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["list", "TI"], "[", "[", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]", "]", Cell["or", "TableText"], 
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give a list of the specified parts of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20328],

Cell["Constructing lists from other lists. ", "Caption",
 CellID->22646],

Cell["This selects elements less than 5. ", "MathCaption",
 CellID->26362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "7", ",", "4", ",", "10", ",", "2"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"#", "<", "5"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177654569]
}, Open  ]],

Cell["\<\
This takes elements up to the first element that is not less than 5. \
\>", "MathCaption",
 CellID->346543740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "7", ",", "4", ",", "10", ",", "2"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"#", "<", "5"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->461972662],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->778190267]
}, Open  ]],

Cell["This explicitly gives numbered parts. ", "MathCaption",
 CellID->28433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "4"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->29869],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "a", ",", "d"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->20142]
}, Open  ]],

Cell[TextData[{
 "This picks out elements indicated by a ",
 Cell[BoxData["1"], "InlineFormula"],
 " in the second list. "
}], "MathCaption",
 CellID->23844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pick", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "1"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->1416],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->21881]
}, Open  ]],

Cell[TextData[{
 "Sometimes you may want to accumulate a list of results during the execution \
of a program. You can do this using ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->31998],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sow"], "[", 
     StyleBox["val", "TI"], "]"}], Cell[TextData[{
     "sow the value ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " for the nearest enclosing ",
     Cell[BoxData[
      ButtonBox["Reap",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reap"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Reap",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reap"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", returning also a list of values sown by ",
     Cell[BoxData[
      ButtonBox["Sow",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sow"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10322],

Cell[TextData[{
 "Using ",
 StyleBox["Sow", "MR"],
 " and ",
 StyleBox["Reap", "MR"],
 ". "
}], "Caption",
 CellID->18651],

Cell["This program iteratively squares a number. ", "MathCaption",
 CellID->10021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "^", "2"}], "&"}], ",", "2", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->5699],

Cell[BoxData["18446744073709551616"], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->3557]
}, Open  ]],

Cell["\<\
This does the same computation, but accumulating a list of intermediate \
results above 1000. \
\>", "MathCaption",
 CellID->28476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Nest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"#", ">", "1000"}], ",", 
         RowBox[{"Sow", "[", "#", "]"}]}], "]"}], ";", 
       RowBox[{"#", "^", "2"}]}], ")"}], "&"}], ",", "2", ",", "6"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->27892],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"18446744073709551616", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"65536", ",", "4294967296"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{335, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->24389]
}, Open  ]],

Cell[TextData[{
 "An alternative but less efficient approach involves introducing a temporary \
variable, then starting with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["t", "TI"], "=", 
   RowBox[{"{", "}"}]}]], "InlineFormula"],
 ", and successively using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AppendTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppendTo"], "[", 
   RowBox[{
    StyleBox["t", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->5075],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->26126616],

Cell[TextData[ButtonBox["Manipulating Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsOverview"]], "RelatedTutorials",\

 CellID->30468725]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Constructing Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Lists", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/ManipulatingListsOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingListsByTheirIndices"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 36.9055610}", "context" -> "", 
    "keywords" -> {
     "Array", "arrays", "cases", "linked lists", "lists", "Map", "MapIndexed",
       "masking", "Pick", "Range", "Reap", "Select", "Sow", "SparseArray", 
      "Table", "TakeWhile"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Lists are widely used in Mathematica, and there are many ways to \
construct them. Some explicit ways to construct lists. This gives a table of \
the first five powers of two. ", "synonyms" -> {"2.4.1"}, "title" -> 
    "Constructing Lists", "type" -> "Tutorial", "uri" -> 
    "tutorial/ConstructingLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.4.1"->{
  Cell[3368, 80, 81, 2, 70, "Title",
   CellTags->{"S2.4.1", "1.1"},
   CellID->28009]},
 "1.1"->{
  Cell[3368, 80, 81, 2, 70, "Title",
   CellTags->{"S2.4.1", "1.1"},
   CellID->28009]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.4.1", 24896, 866},
 {"1.1", 24995, 870}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2743, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3368, 80, 81, 2, 70, "Title",
 CellTags->{"S2.4.1", "1.1"},
 CellID->28009],
Cell[3452, 84, 170, 6, 70, "Text",
 CellID->27157],
Cell[3625, 92, 4215, 141, 70, "DefinitionBox",
 CellID->20472],
Cell[7843, 235, 74, 1, 70, "Caption",
 CellID->23622],
Cell[7920, 238, 91, 1, 70, "MathCaption",
 CellID->18538],
Cell[CellGroupData[{
Cell[8036, 243, 194, 7, 28, "Input",
 CellID->12292],
Cell[8233, 252, 232, 7, 36, "Output",
 CellID->6038]
}, Open  ]],
Cell[8480, 262, 83, 1, 70, "MathCaption",
 CellID->24179],
Cell[CellGroupData[{
Cell[8588, 267, 165, 6, 28, "Input",
 CellID->18190],
Cell[8756, 275, 233, 7, 36, "Output",
 CellID->29657]
}, Open  ]],
Cell[9004, 285, 65, 1, 70, "MathCaption",
 CellID->7958],
Cell[CellGroupData[{
Cell[9094, 290, 172, 6, 70, "Input",
 CellID->6191],
Cell[9269, 298, 246, 8, 36, "Output",
 CellID->19815]
}, Open  ]],
Cell[9530, 309, 229, 7, 70, "MathCaption",
 CellID->22888],
Cell[CellGroupData[{
Cell[9784, 320, 268, 9, 70, "Input",
 CellID->19156],
Cell[10055, 331, 230, 7, 36, "Output",
 CellID->11511]
}, Open  ]],
Cell[10300, 341, 84, 1, 70, "MathCaption",
 CellID->16202],
Cell[CellGroupData[{
Cell[10409, 346, 240, 8, 70, "Input",
 CellID->2634],
Cell[10652, 356, 233, 7, 36, "Output",
 CellID->24272]
}, Open  ]],
Cell[10900, 366, 205, 5, 70, "Text",
 CellID->20055],
Cell[11108, 373, 5215, 172, 70, "DefinitionBox",
 CellID->20328],
Cell[16326, 547, 72, 1, 70, "Caption",
 CellID->22646],
Cell[16401, 550, 74, 1, 70, "MathCaption",
 CellID->26362],
Cell[CellGroupData[{
Cell[16500, 555, 258, 9, 70, "Input",
 CellID->4886],
Cell[16761, 566, 223, 7, 36, "Output",
 CellID->177654569]
}, Open  ]],
Cell[16999, 576, 120, 3, 70, "MathCaption",
 CellID->346543740],
Cell[CellGroupData[{
Cell[17144, 583, 266, 9, 70, "Input",
 CellID->461972662],
Cell[17413, 594, 203, 7, 36, "Output",
 CellID->778190267]
}, Open  ]],
Cell[17631, 604, 77, 1, 70, "MathCaption",
 CellID->28433],
Cell[CellGroupData[{
Cell[17733, 609, 243, 8, 70, "Input",
 CellID->29869],
Cell[17979, 619, 210, 7, 36, "Output",
 CellID->20142]
}, Open  ]],
Cell[18204, 629, 157, 5, 70, "MathCaption",
 CellID->23844],
Cell[CellGroupData[{
Cell[18386, 638, 270, 9, 70, "Input",
 CellID->1416],
Cell[18659, 649, 210, 7, 36, "Output",
 CellID->21881]
}, Open  ]],
Cell[18884, 659, 398, 14, 70, "Text",
 CellID->31998],
Cell[19285, 675, 1215, 39, 70, "DefinitionBox",
 CellID->10322],
Cell[20503, 716, 122, 7, 70, "Caption",
 CellID->18651],
Cell[20628, 725, 82, 1, 70, "MathCaption",
 CellID->10021],
Cell[CellGroupData[{
Cell[20735, 730, 173, 6, 70, "Input",
 CellID->5699],
Cell[20911, 738, 174, 5, 36, "Output",
 CellID->3557]
}, Open  ]],
Cell[21100, 746, 141, 4, 70, "MathCaption",
 CellID->28476],
Cell[CellGroupData[{
Cell[21266, 754, 400, 14, 70, "Input",
 CellID->27892],
Cell[21669, 770, 309, 10, 36, "Output",
 CellID->24389]
}, Open  ]],
Cell[21993, 783, 509, 18, 70, "Text",
 CellID->5075],
Cell[CellGroupData[{
Cell[22527, 805, 71, 1, 70, "RelatedTutorialsSection",
 CellID->26126616],
Cell[22601, 808, 166, 4, 70, "RelatedTutorials",
 CellID->30468725]
}, Open  ]]
}, Open  ]],
Cell[22794, 816, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

