(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25746,        898]
NotebookOptionsPosition[     21379,        750]
NotebookOutlinePosition[     23165,        802]
CellTagsIndexPosition[     23074,        796]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Array" :> Documentation`HelpLookup["paclet:ref/Array"], 
         "ConstantArray" :> 
         Documentation`HelpLookup["paclet:ref/ConstantArray"], 
         "DiagonalMatrix" :> 
         Documentation`HelpLookup["paclet:ref/DiagonalMatrix"], 
         "IdentityMatrix" :> 
         Documentation`HelpLookup["paclet:ref/IdentityMatrix"], "If" :> 
         Documentation`HelpLookup["paclet:ref/If"], "Normal" :> 
         Documentation`HelpLookup["paclet:ref/Normal"], "RandomReal" :> 
         Documentation`HelpLookup["paclet:ref/RandomReal"], "SparseArray" :> 
         Documentation`HelpLookup["paclet:ref/SparseArray"], "Table" :> 
         Documentation`HelpLookup["paclet:ref/Table"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Array\"\>", 2->"\<\"ConstantArray\"\>", 
      3->"\<\"DiagonalMatrix\"\>", 4->"\<\"IdentityMatrix\"\>", 
      5->"\<\"If\"\>", 6->"\<\"Normal\"\>", 7->"\<\"RandomReal\"\>", 
      8->"\<\"SparseArray\"\>", 9->"\<\"Table\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Constructing Matrices", "Title",
 CellTags->{"S3.7.1", "1.1"},
 CellID->10712],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["m", "TI"], "}", ",", "{", 
     StyleBox["j", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "build an ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " matrix where ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " that gives the value of the ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"]}]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Array"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "build an ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " matrix whose ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"]}]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry is ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ConstantArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ConstantArray"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "build an ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " matrix with all entries equal to ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DiagonalMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DiagonalMatrix"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "generate a diagonal matrix with the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " on the diagonal"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IdentityMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IdentityMatrix"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "generate an ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " identity matrix"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Normal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Normal"], "[", 
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "1"], "}", "->", 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "2"], "}", "->", 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "make a matrix with non\[Hyphen]zero values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " at positions ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["k", "TI"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["k", "TI"]]}], "}"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2600],

Cell["Functions for constructing matrices. ", "Caption",
 CellID->2510],

Cell[TextData[{
 "This generates a 2\[Times]2 matrix whose ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], ",", 
   StyleBox["j", "TI"]}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " entry is ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"i", ",", "j"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26869],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79379162]
}, Open  ]],

Cell["Here is another way to produce the same matrix. ", "MathCaption",
 CellID->14688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13401],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->67246733]
}, Open  ]],

Cell["\<\
This creates a 3\[Times]2 matrix of zeros.\
\>", "MathCaption",
 CellID->44934207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstantArray", "[", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->375797557],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->144252300]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiagonalMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiagonalMatrix"]], "InlineFormula"],
 " makes a matrix with zeros everywhere except on the leading diagonal. "
}], "MathCaption",
 CellID->15255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagonalMatrix", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16423],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "b", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->443308911]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IdentityMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IdentityMatrix"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " produces an ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " identity matrix. "
}], "MathCaption",
 CellID->10585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IdentityMatrix", "[", "3", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->431963788]
}, Open  ]],

Cell["\<\
This makes a 3\[Times]4 matrix with two non\[Hyphen]zero values filled in. \
\>", "MathCaption",
 CellID->27088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "->", "a"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "->", "b"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31426],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "a", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "b", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->16325620]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " prints the matrix in a two\[Hyphen]dimensional form. "
}], "MathCaption",
 CellID->23757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->9832],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0"},
     {"0", "0", "a", "0"},
     {"0", "b", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{76, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->307466236]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", 
       StyleBox["m", "TI"], "}"}], ",", 
      RowBox[{"{", 
       StyleBox["n", "TI"], "}"}]}], "]"}], Cell[
    "a matrix of zeros", "TableText"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     ButtonBox["If",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/If"], "[", 
     StyleBox["i", "TI"], ">=", 
     StyleBox["j", "TI"], ",", "1", ",", "0", "]", ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["m", "TI"], "}", ",", "{", 
     StyleBox["j", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["a lower\[Hyphen]triangular matrix", "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       StyleBox[
        RowBox[{"m", ",", "n"}], "TI"], "}"}]}], "]"}], Cell[
    "a matrix with random numerical entries", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4169],

Cell["Constructing special types of matrices. ", "Caption",
 CellID->2154],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"], "[", 
   RowBox[{
    RowBox[{"i", "\[GreaterEqual]", "j"}], ",", 
    RowBox[{"a", "++"}], ",", "0"}], "]"}]], "InlineFormula"],
 " separately for each element, to give a matrix with sequentially increasing \
entries in the lower triangular part. "
}], "MathCaption",
 CellID->3091908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "1"}], ";", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"i", "\[GreaterEqual]", "j"}], ",", 
      RowBox[{"a", "++"}], ",", "0"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->288597276],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22910509]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", "{", "}", ",", "{", 
     StyleBox["n", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell["a zero matrix", "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", "{", 
     StyleBox["i", "TI"], 
     StyleBox["_", "MR"], ",", 
     StyleBox["i", "TI"], 
     StyleBox["_", "MR"], "}", "->", "1", ",", "{", 
     StyleBox["n", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "an ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " identity matrix"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", "{", 
     StyleBox["i", "TI"], 
     StyleBox["_", "MR"], ",", 
     StyleBox["j", "TI"], 
     StyleBox["_", "MR"], "}", "\[ThinSpace]", "/;", "\[ThinSpace]", 
     StyleBox["i", "TI"], "\[ThinSpace]", ">=", "\[ThinSpace]", 
     StyleBox["j", "TI"], "->", "1", ",", "{", 
     StyleBox["n", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["a lower\[Hyphen]triangular matrix", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31329],

Cell[TextData[{
 "Constructing special types of matrices with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->2368],

Cell["\<\
This sets up a general lower\[Hyphen]triangular matrix. \
\>", "MathCaption",
 CellID->28692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
      RowBox[{"i", ">=", "j"}]}], "->", 
     RowBox[{"f", "[", 
      RowBox[{"i", ",", "j"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->21425],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWL1vGjEUN3eQRNdC86FKGdkrtUnUzlWXdsofgaJIyRA1IqhiY2RkZGTM
iDIxMjIyMjIyMjJen7+w87DDGfuAIMHde3738/swP7/zda1xd/tQa9zf1Kp/
6rXHu/ubp+rvv3VQxQVCyAt8v5wTuE/hjn1f0hSu/PcMfiNQfqBSTEfZhxwL
/WfP8QqbpcRGe72eGMXWibA+RfqzwHYHTG61WkKOmXdFdjuZTAaDgdSWiNSr
p6meiiWkP7TYJzvCObLoD2QVxuMxjr7b7QorPAtGiZhyKTMMjkIzniBrjIYr
74Z+ZB3d9hw8l4vFotlsqlzGUsvTuTKzuSJKrnhmD+OV19i74h2bMolWMInb
7TakYDnOshKNRiOMtu1shMbLlg0gFaCW19lg/7fZbGaaBctyXZ54ei9xMCfG
G+KciKuJxXQ21aNWzEtRTJzmWjMbN7rWKhQOjx6WP9/sLNGvq7mZofDcYXiv
YtRuE5sxrrYDFYw5o5WINZ4uCll2GqVUdRw2O12f1S5Bfpi9e37XVuXUr8v7
lXmWkN3cz0yz2pgmsuhduzBXHJpDKl5m8n4zptinbiwxWl0EiR7vXb57JMbD
jIvt84wN++7L/q54ecaG5U+esWEZx4br6hPbPnYuedVp//oQn2hDdxDl1IXJ
93XvD9Mh8JfgTqezFiXLzv6Pyeq8SEeDPnE+n6dv/BM33ZG/iytfTdPptN/v
Szw5O7zUiNMTV/7OuiebV/iVUfuNPTscDg1vmJAk4X/oncbdQ1gXr04EXM+c
8vdQrVHlYQSV3mXuvlIfoIYMQ8yscmZb5Xl7pPsQa57x44yldoc5W/GFfExX
GR2fYeiMLpngB3uan5STwn/09gNP\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{177, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->113031324]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->159700942],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->278027054]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Constructing Matrices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 37.2493198}", "context" -> "", 
    "keywords" -> {
     "Array", "DiagonalMatrix", "diagonal matrix", "IdentityMatrix", 
      "identity matrix", "matrices", "Table", "triangular matrices"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Functions for constructing matrices. This generates a 2x2 matrix whose \
i,j^th entry is a[i,j]. Here is another way to produce the same matrix. ", 
    "synonyms" -> {"3.7.1"}, "title" -> "Constructing Matrices", "type" -> 
    "Tutorial", "uri" -> "tutorial/ConstructingMatrices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.7.1"->{
  Cell[2011, 54, 84, 2, 70, "Title",
   CellTags->{"S3.7.1", "1.1"},
   CellID->10712]},
 "1.1"->{
  Cell[2011, 54, 84, 2, 70, "Title",
   CellTags->{"S3.7.1", "1.1"},
   CellID->10712]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.7.1", 22863, 785},
 {"1.1", 22962, 789}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1386, 27, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2011, 54, 84, 2, 70, "Title",
 CellTags->{"S3.7.1", "1.1"},
 CellID->10712],
Cell[2098, 58, 4966, 164, 70, "DefinitionBox",
 CellID->2600],
Cell[7067, 224, 71, 1, 70, "Caption",
 CellID->2510],
Cell[7141, 227, 432, 17, 70, "MathCaption",
 CellID->21003],
Cell[CellGroupData[{
Cell[7598, 248, 282, 10, 28, "Input",
 CellID->26869],
Cell[7883, 260, 533, 19, 36, "Output",
 CellID->79379162]
}, Open  ]],
Cell[8431, 282, 87, 1, 70, "MathCaption",
 CellID->14688],
Cell[CellGroupData[{
Cell[8543, 287, 169, 6, 28, "Input",
 CellID->13401],
Cell[8715, 295, 533, 19, 36, "Output",
 CellID->67246733]
}, Open  ]],
Cell[9263, 317, 92, 3, 70, "MathCaption",
 CellID->44934207],
Cell[CellGroupData[{
Cell[9380, 324, 181, 6, 28, "Input",
 CellID->375797557],
Cell[9564, 332, 361, 13, 36, "Output",
 CellID->144252300]
}, Open  ]],
Cell[9940, 348, 255, 7, 70, "MathCaption",
 CellID->15255],
Cell[CellGroupData[{
Cell[10220, 359, 163, 5, 70, "Input",
 CellID->16423],
Cell[10386, 366, 391, 13, 36, "Output",
 CellID->443308911]
}, Open  ]],
Cell[10792, 382, 399, 15, 70, "MathCaption",
 CellID->10585],
Cell[CellGroupData[{
Cell[11216, 401, 106, 3, 70, "Input",
 CellID->24182],
Cell[11325, 406, 391, 13, 36, "Output",
 CellID->431963788]
}, Open  ]],
Cell[11731, 422, 122, 3, 70, "MathCaption",
 CellID->27088],
Cell[CellGroupData[{
Cell[11878, 429, 432, 15, 70, "Input",
 CellID->31426],
Cell[12313, 446, 420, 13, 36, "Output",
 CellID->16325620]
}, Open  ]],
Cell[12748, 462, 231, 7, 70, "MathCaption",
 CellID->23757],
Cell[CellGroupData[{
Cell[13004, 473, 101, 3, 70, "Input",
 CellID->9832],
Cell[13108, 478, 740, 23, 78, "Output",
 CellID->307466236]
}, Open  ]],
Cell[13863, 504, 1682, 50, 70, "DefinitionBox",
 CellID->4169],
Cell[15548, 556, 74, 1, 70, "Caption",
 CellID->2154],
Cell[15625, 559, 533, 17, 70, "MathCaption",
 CellID->3091908],
Cell[CellGroupData[{
Cell[16183, 580, 414, 14, 70, "Input",
 CellID->288597276],
Cell[16600, 596, 390, 13, 36, "Output",
 CellID->22910509]
}, Open  ]],
Cell[17005, 612, 1894, 54, 70, "DefinitionBox",
 CellID->31329],
Cell[18902, 668, 224, 8, 70, "Caption",
 CellID->2368],
Cell[19129, 678, 103, 3, 70, "MathCaption",
 CellID->28692],
Cell[CellGroupData[{
Cell[19257, 685, 407, 14, 28, "Input",
 CellID->21425],
Cell[19667, 701, 1106, 22, 78, "Output",
 Evaluatable->False,
 CellID->113031324]
}, Open  ]],
Cell[CellGroupData[{
Cell[20810, 728, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->159700942],
Cell[20911, 731, 414, 13, 70, "TutorialRelatedLinks",
 CellID->278027054]
}, Open  ]]
}, Open  ]],
Cell[21352, 748, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

