(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8498,        291]
NotebookOptionsPosition[      5340,        194]
NotebookOutlinePosition[      7572,        256]
CellTagsIndexPosition[      7483,        250]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/NumbersOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numbers\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"N" :> Documentation`HelpLookup["paclet:ref/N"], "NHoldAll" :> 
          Documentation`HelpLookup["paclet:ref/NHoldAll"], "NHoldFirst" :> 
          Documentation`HelpLookup["paclet:ref/NHoldFirst"], "NHoldRest" :> 
          Documentation`HelpLookup["paclet:ref/NHoldRest"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"N\"\>", 2->"\<\"NHoldAll\"\>", 
       3->"\<\"NHoldFirst\"\>", 4->"\<\"NHoldRest\"\>"}, "\<\"functions\"\>", 
       
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Controlling Numerical Evaluation", "Title",
 CellTags->{"S3.1.9", "9.1"},
 CellID->10195],

Cell[BoxData[GridBox[{
   {
    ButtonBox["NHoldAll",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NHoldAll"], Cell[TextData[{
     "prevent any arguments of a function from being affected by\
\[NonBreakingSpace]",
     Cell[BoxData[
      ButtonBox["N",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/N"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["NHoldFirst",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NHoldFirst"], Cell[
    "prevent the first argument from being affected", "TableText"]},
   {
    ButtonBox["NHoldRest",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NHoldRest"], Cell[
    "prevent all but the first argument from being affected", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32525],

Cell["Attributes for controlling numerical evaluation. ", "Caption",
 CellID->1264],

Cell[TextData[{
 "Usually ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " goes inside functions and gets applied to each of their arguments. "
}], "MathCaption",
 CellID->8260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"2", "/", "3"}], ",", "Pi"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->6202],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"0.6666666666666666`", ",", "3.141592653589793`"}], "]"}]], "Output",\

 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->8116]
}, Open  ]],

Cell[TextData[{
 "This tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " not to apply ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to the first argument of ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5030],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "NHoldFirst"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->20326],

Cell[TextData[{
 "Now the first argument of ",
 Cell[BoxData["f"], "InlineFormula"],
 " is left in its exact form. "
}], "MathCaption",
 CellID->29011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"2", "/", "3"}], ",", "Pi"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->30771],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   FractionBox["2", "3"], ",", "3.141592653589793`"}], "]"}]], "Output",
 ImageSize->{97, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->6411]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->568381710],

Cell[TextData[ButtonBox["Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumbersOverview"]], "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Controlling Numerical Evaluation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numbers", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/NumbersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/IndeterminateAndInfiniteResults"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 43.4838544}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Attributes for controlling numerical evaluation. Usually N goes inside \
functions and gets applied to each of their arguments. This tells Mathematica \
not to apply N to the first argument of f. ", "synonyms" -> {"3.1.9"}, 
    "title" -> "Controlling Numerical Evaluation", "type" -> "Tutorial", 
    "uri" -> "tutorial/ControllingNumericalEvaluation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.1.9"->{
  Cell[2043, 61, 95, 2, 70, "Title",
   CellTags->{"S3.1.9", "9.1"},
   CellID->10195]},
 "9.1"->{
  Cell[2043, 61, 95, 2, 70, "Title",
   CellTags->{"S3.1.9", "9.1"},
   CellID->10195]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.1.9", 7272, 239},
 {"9.1", 7371, 243}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1418, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2043, 61, 95, 2, 70, "Title",
 CellTags->{"S3.1.9", "9.1"},
 CellID->10195],
Cell[2141, 65, 1055, 30, 70, "DefinitionBox",
 CellID->32525],
Cell[3199, 97, 83, 1, 70, "Caption",
 CellID->1264],
Cell[3285, 100, 239, 8, 70, "MathCaption",
 CellID->8260],
Cell[CellGroupData[{
Cell[3549, 112, 171, 6, 28, "Input",
 CellID->6202],
Cell[3723, 120, 242, 8, 36, "Output",
 CellID->8116]
}, Open  ]],
Cell[3980, 131, 313, 13, 70, "MathCaption",
 CellID->5030],
Cell[4296, 146, 138, 4, 70, "Input",
 CellID->20326],
Cell[4437, 152, 151, 5, 70, "MathCaption",
 CellID->29011],
Cell[CellGroupData[{
Cell[4613, 161, 172, 6, 28, "Input",
 CellID->30771],
Cell[4788, 169, 243, 8, 51, "Output",
 CellID->6411]
}, Open  ]],
Cell[CellGroupData[{
Cell[5068, 182, 72, 1, 70, "RelatedTutorialsSection",
 CellID->568381710],
Cell[5143, 185, 143, 3, 70, "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],
Cell[5313, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

