(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16259,        513]
NotebookOptionsPosition[     11830,        381]
NotebookOutlinePosition[     14626,        452]
CellTagsIndexPosition[     14535,        446]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Functions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AccuracyGoal" :> 
          Documentation`HelpLookup["paclet:ref/AccuracyGoal"], 
          "PrecisionGoal" :> 
          Documentation`HelpLookup["paclet:ref/PrecisionGoal"], 
          "WorkingPrecision" :> 
          Documentation`HelpLookup["paclet:ref/WorkingPrecision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AccuracyGoal\"\>", 
       2->"\<\"PrecisionGoal\"\>", 
       3->"\<\"WorkingPrecision\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Controlling the Precision of Results", "Title",
 CellTags->{"S3.9.9", "9.1"},
 CellID->11477],

Cell[TextData[{
 "In doing numerical operations like ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default uses machine numbers. But by setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " you can tell it to use arbitrary\[Hyphen]precision numbers with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]digit precision. "
}], "Text",
 CellID->1200],

Cell["\<\
This does a machine\[Hyphen]precision computation of a numerical integral. \
\>", "MathCaption",
 CellID->26058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6439],

Cell[BoxData["0.43060610312069103`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124065023]
}, Open  ]],

Cell["\<\
This does the computation with 30\[Hyphen]digit arbitrary\[Hyphen]precision \
numbers. \
\>", "MathCaption",
 CellID->12760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "->", "30"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19357],

Cell[BoxData["0.430606103120690604912377355248465786432018068851`30."], \
"Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132675376]
}, Open  ]],

Cell[TextData[{
 "When you give a setting for ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 ", this typically defines an upper limit on the precision of the results \
from a computation. But within this constraint you can tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " how much precision and accuracy you want it to try to get. You should \
realize that for many kinds of numerical operations, increasing precision and \
accuracy goals by only a few digits can greatly increase the computation time \
required. Nevertheless, there are many cases where it is important to ensure \
that high precision and accuracy are obtained. "
}], "Text",
 CellID->6477],

Cell[BoxData[GridBox[{
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], Cell[
    "the number of digits to use for computations", "TableText"]},
   {
    ButtonBox["PrecisionGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrecisionGoal"], Cell[
    "the number of digits of precision to try to get", "TableText"]},
   {
    ButtonBox["AccuracyGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AccuracyGoal"], Cell[
    "the number of digits of accuracy to try to get", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5108],

Cell["Options for controlling precision and accuracy. ", "Caption",
 CellID->21113],

Cell["\<\
This gives a result to 25\[Hyphen]digit precision. \
\>", "MathCaption",
 CellID->14887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "->", "30"}], ",", 
   RowBox[{"PrecisionGoal", "->", "25"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19801],

Cell[BoxData["0.430606103120690604912377355248465786432010027039`30."], \
"Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->159440692]
}, Open  ]],

Cell["\<\
50\[Hyphen]digit precision cannot be achieved with 30\[Hyphen]digit working \
precision. \
\>", "MathCaption",
 CellID->14460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "->", "30"}], ",", 
   RowBox[{"PrecisionGoal", "->", "50"}], ",", " ", 
   RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1839392538],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[7]:=",
 CellID->684252497],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"eincr\"\>"}], ":", 
  " ", "\<\"The global error of the strategy GlobalAdaptive has increased \
more than \\!\\(400\\) times. The global error is expected to decrease \
monotonically after a number of integrand evaluations. Suspect one of the \
following: the difference between the values of PrecisionGoal and \
WorkingPrecision is too small; the integrand is highly oscillatory or it is \
not a (piecewise) smooth function; or the true value of the integral is 0. \
Increasing the value of the GlobalAdaptive option MaxErrorIncreases might \
lead to a convergent numerical integration. NIntegrate obtained \
\\!\\(0.4306061031206906049123773552484657864321926846970047795778889945386244\
0935086147`79.99999999999999\\) and \
\\!\\(5.0389168023978522428584079640683380095800609705541481317302318308282727\
459335312`79.99999999999999*^-40\\) for the integral and error \
estimates.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[7]:=",
 CellID->456787394],

Cell[BoxData["0.430606103120690604912377355248465786432192684697`30."], \
"Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->2119176580]
}, Open  ]],

Cell[TextData[{
 "Giving a particular setting for ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 ", each of the functions for numerical operations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses certain default settings for ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 ". Typical is the case of ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", in which these default settings are equal to half the setting given for \
",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->19405],

Cell[TextData[{
 "The precision and accuracy goals normally apply both to the final results \
returned, and to various norms or error estimates for them. Functions for \
numerical operations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " typically try to refine their results until either the specified precision \
goal or accuracy goal is reached. If the setting for either of these goals is \
",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ", then only the other goal is considered. "
}], "Text",
 CellID->6540],

Cell[TextData[{
 "In doing ordinary numerical evaluation with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically adjusts its internal computations to achieve ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]digit precision in the result. But in doing numerical operations \
on functions, it is in practice usually necessary to specify ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " more explicitly. "
}], "Text",
 CellID->31111],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->6065797],

Cell[TextData[ButtonBox["Numerical Operations on Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], \
"RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Controlling the Precision of Results - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Functions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericalOptimization"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/MonitoringAndSelectingAlgorithms"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 43.9369910}", "context" -> "", 
    "keywords" -> {"AccuracyGoal", "PrecisionGoal", "WorkingPrecision"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "In doing numerical operations like NDSolve and NMinimize, Mathematica by \
default uses machine numbers. But by setting the option WorkingPrecision->n \
you can tell it to use arbitrary-precision numbers with n-digit precision. \
This does a machine-precision computation of a numerical integral. This does \
the computation with 30-digit arbitrary-precision numbers. ", 
    "synonyms" -> {"3.9.9"}, "title" -> 
    "Controlling the Precision of Results", "type" -> "Tutorial", "uri" -> 
    "tutorial/ControllingThePrecisionOfResults"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.9.9"->{
  Cell[2131, 65, 99, 2, 70, "Title",
   CellTags->{"S3.9.9", "9.1"},
   CellID->11477]},
 "9.1"->{
  Cell[2131, 65, 99, 2, 70, "Title",
   CellTags->{"S3.9.9", "9.1"},
   CellID->11477]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.9.9", 14324, 435},
 {"9.1", 14423, 439}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1506, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2131, 65, 99, 2, 70, "Title",
 CellTags->{"S3.9.9", "9.1"},
 CellID->11477],
Cell[2233, 69, 790, 26, 70, "Text",
 CellID->1200],
Cell[3026, 97, 122, 3, 70, "MathCaption",
 CellID->26058],
Cell[CellGroupData[{
Cell[3173, 104, 246, 8, 28, "Input",
 CellID->6439],
Cell[3422, 114, 177, 5, 36, "Output",
 CellID->124065023]
}, Open  ]],
Cell[3614, 122, 134, 4, 70, "MathCaption",
 CellID->12760],
Cell[CellGroupData[{
Cell[3773, 130, 298, 9, 28, "Input",
 CellID->19357],
Cell[4074, 141, 214, 6, 36, "Output",
 CellID->132675376]
}, Open  ]],
Cell[4303, 150, 761, 16, 70, "Text",
 CellID->6477],
Cell[5067, 168, 901, 24, 70, "DefinitionBox",
 CellID->5108],
Cell[5971, 194, 83, 1, 70, "Caption",
 CellID->21113],
Cell[6057, 197, 98, 3, 70, "MathCaption",
 CellID->14887],
Cell[CellGroupData[{
Cell[6180, 204, 346, 10, 70, "Input",
 CellID->19801],
Cell[6529, 216, 214, 6, 36, "Output",
 CellID->159440692]
}, Open  ]],
Cell[6758, 225, 136, 4, 70, "MathCaption",
 CellID->14460],
Cell[CellGroupData[{
Cell[6919, 233, 408, 11, 70, "Input",
 CellID->1839392538],
Cell[7330, 246, 366, 7, 70, "Message",
 CellID->684252497],
Cell[7699, 255, 1033, 17, 70, "Message",
 CellID->456787394],
Cell[8735, 274, 215, 6, 36, "Output",
 CellID->2119176580]
}, Open  ]],
Cell[8965, 283, 996, 32, 70, "Text",
 CellID->19405],
Cell[9964, 317, 600, 15, 70, "Text",
 CellID->6540],
Cell[10567, 334, 913, 29, 70, "Text",
 CellID->31111],
Cell[CellGroupData[{
Cell[11505, 367, 70, 1, 70, "RelatedTutorialsSection",
 CellID->6065797],
Cell[11578, 370, 198, 5, 70, "RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],
Cell[11803, 379, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

