(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14540,        511]
NotebookOptionsPosition[      9669,        364]
NotebookOutlinePosition[     12664,        440]
CellTagsIndexPosition[     12573,        434]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series, Limits and Residues" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SeriesLimitsAndResiduesOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Series, Limits and Residues\"\>"}, "\<\"related tutorials\"\>",
        
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Normal" :> Documentation`HelpLookup["paclet:ref/Normal"], 
          "SeriesCoefficient" :> 
          Documentation`HelpLookup["paclet:ref/SeriesCoefficient"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Normal\"\>", 
       2->"\<\"SeriesCoefficient\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Converting Power Series to Normal Expressions", "Title",
 CellTags->{"S3.6.5", "5.1"},
 CellID->28112],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Normal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Normal"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "convert a power series to a normal expression", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30695],

Cell["Converting power series to normal expressions. ", "Caption",
 CellID->13169],

Cell[TextData[{
 "As discussed, power series in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are represented in a special internal form, which keeps track of such \
attributes as their expansion order. "
}], "Text",
 CellID->23831],

Cell["\<\
For some purposes, you may want to convert power series to normal \
expressions. From a mathematical point of view, this corresponds to \
truncating the power series, and assuming that all higher\[Hyphen]order terms \
are zero. \
\>", "Text",
 CellID->20040],

Cell["This generates a power series, with four terms. ", "MathCaption",
 CellID->26488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"ArcTan", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28685],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "5"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "7"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 3], 0, 
    Rational[1, 5], 0, 
    Rational[-1, 7]}, 1, 9, 1],
  Editable->False]], "Output",
 ImageSize->{145, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->543975360]
}, Open  ]],

Cell["\<\
Squaring the power series gives you another power series, with the \
appropriate number of terms. \
\>", "MathCaption",
 CellID->19497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "^", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2589],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["x", "2"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "4"]}], "3"], "+", 
   FractionBox[
    RowBox[{"23", " ", 
     SuperscriptBox["x", "6"]}], "45"], "-", 
   FractionBox[
    RowBox[{"44", " ", 
     SuperscriptBox["x", "8"]}], "105"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 2, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-2, 3], 0, 
    Rational[23, 45], 0, 
    Rational[-44, 105]}, 2, 10, 1],
  Editable->False]], "Output",
 ImageSize->{200, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1399780714]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " truncates the power series, giving a normal expression. "
}], "MathCaption",
 CellID->15145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19353],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["x", "4"]}], "3"], "+", 
  FractionBox[
   RowBox[{"23", " ", 
    SuperscriptBox["x", "6"]}], "45"], "-", 
  FractionBox[
   RowBox[{"44", " ", 
    SuperscriptBox["x", "8"]}], "105"]}]], "Output",
 ImageSize->{149, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1391216503]
}, Open  ]],

Cell["You can now apply standard algebraic operations. ", "MathCaption",
 CellID->18651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26740],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "315"]}], " ", 
  SuperscriptBox["x", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "315"}], "+", 
    RowBox[{"210", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"161", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"132", " ", 
     SuperscriptBox["x", "6"]}]}], ")"}]}]], "Output",
 ImageSize->{246, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2146055670]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SeriesCoefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SeriesCoefficient"], "[", 
     StyleBox["series", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give the coefficient of the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " order term in a power series"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11258],

Cell["Extracting coefficients of terms in power series. ", "Caption",
 CellID->335],

Cell[TextData[{
 "This gives the coefficient of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "7"], TraditionalForm]], "InlineMath"],
 " in the original power series. "
}], "MathCaption",
 CellID->8759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{"t", ",", "7"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->11192],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", "7"]}]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->295724914]
}, Open  ]],

Cell[TextData[{
 "This gives the coefficient for the term ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "n"], TraditionalForm]], "InlineMath"],
 " in the Taylor expansion of the function ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", 
    SuperscriptBox["x", "2"]], TraditionalForm]], "InlineMath"],
 " about zero. "
}], "MathCaption",
 CellID->231086461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->1610807],

Cell[BoxData[
 FractionBox[
  RowBox[{"KroneckerDelta", "[", 
   RowBox[{"Mod", "[", 
    RowBox[{"n", ",", "2"}], "]"}], "]"}], 
  RowBox[{
   FractionBox["n", "2"], "!"}]]], "Output",
 ImageSize->{181, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->86960125]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->326416637],

Cell[TextData[ButtonBox["Series, Limits and Residues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Converting Power Series to Normal Expressions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Series, Limits and Residues", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CompositionAndInversionOfPowerSeries"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SolvingEquationsInvolvingPowerSeries"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 44.5463816}", "context" -> "", 
    "keywords" -> {
     "coefficients", "normal", "polynomials", "power series", 
      "SeriesCoefficient", "series coefficient", "terms", 
      "truncation of power series"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Converting power series to normal expressions. As discussed, power \
series in Mathematica are represented in a special internal form, which keeps \
track of such attributes as their expansion order. For some purposes, you may \
want to convert power series to normal expressions. From a mathematical point \
of view, this corresponds to truncating the power series, and assuming that \
all higher-order terms are zero. ", "synonyms" -> {"3.6.5"}, "title" -> 
    "Converting Power Series to Normal Expressions", "type" -> "Tutorial", 
    "uri" -> "tutorial/ConvertingPowerSeriesToNormalExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.6.5"->{
  Cell[1960, 61, 108, 2, 70, "Title",
   CellTags->{"S3.6.5", "5.1"},
   CellID->28112]},
 "5.1"->{
  Cell[1960, 61, 108, 2, 70, "Title",
   CellTags->{"S3.6.5", "5.1"},
   CellID->28112]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.6.5", 12360, 423},
 {"5.1", 12460, 427}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1335, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1960, 61, 108, 2, 70, "Title",
 CellTags->{"S3.6.5", "5.1"},
 CellID->28112],
Cell[2071, 65, 564, 16, 70, "DefinitionBox",
 CellID->30695],
Cell[2638, 83, 82, 1, 70, "Caption",
 CellID->13169],
Cell[2723, 86, 241, 7, 70, "Text",
 CellID->23831],
Cell[2967, 95, 268, 6, 70, "Text",
 CellID->20040],
Cell[3238, 103, 87, 1, 70, "MathCaption",
 CellID->26488],
Cell[CellGroupData[{
Cell[3350, 108, 241, 8, 28, "Input",
 CellID->28685],
Cell[3594, 118, 666, 23, 54, "Output",
 CellID->543975360]
}, Open  ]],
Cell[4275, 144, 145, 4, 70, "MathCaption",
 CellID->19497],
Cell[CellGroupData[{
Cell[4445, 152, 87, 3, 28, "Input",
 CellID->2589],
Cell[4535, 157, 783, 27, 54, "Output",
 CellID->1399780714]
}, Open  ]],
Cell[5333, 187, 226, 7, 70, "MathCaption",
 CellID->15145],
Cell[CellGroupData[{
Cell[5584, 198, 98, 3, 70, "Input",
 CellID->19353],
Cell[5685, 203, 444, 16, 54, "Output",
 CellID->1391216503]
}, Open  ]],
Cell[6144, 222, 88, 1, 70, "MathCaption",
 CellID->18651],
Cell[CellGroupData[{
Cell[6257, 227, 98, 3, 70, "Input",
 CellID->26740],
Cell[6358, 232, 509, 18, 51, "Output",
 CellID->2146055670]
}, Open  ]],
Cell[6882, 253, 818, 24, 70, "DefinitionBox",
 CellID->11258],
Cell[7703, 279, 83, 1, 70, "Caption",
 CellID->335],
Cell[7789, 282, 208, 7, 70, "MathCaption",
 CellID->8759],
Cell[CellGroupData[{
Cell[8022, 293, 132, 4, 70, "Input",
 CellID->11192],
Cell[8157, 299, 196, 7, 51, "Output",
 CellID->295724914]
}, Open  ]],
Cell[8368, 309, 366, 12, 70, "MathCaption",
 CellID->231086461],
Cell[CellGroupData[{
Cell[8759, 325, 243, 8, 70, "Input",
 CellID->1610807],
Cell[9005, 335, 316, 11, 58, "Output",
 CellID->86960125]
}, Open  ]],
Cell[CellGroupData[{
Cell[9358, 351, 72, 1, 70, "RelatedTutorialsSection",
 CellID->326416637],
Cell[9433, 354, 182, 4, 70, "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],
Cell[9642, 362, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

