(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    144919,       3225]
NotebookOptionsPosition[    135653,       2926]
NotebookOutlinePosition[    139162,       3008]
CellTagsIndexPosition[    139067,       3002]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnDataOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Data\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListConvolve" :> 
          Documentation`HelpLookup["paclet:ref/ListConvolve"], 
          "ListCorrelate" :> 
          Documentation`HelpLookup["paclet:ref/ListCorrelate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListConvolve\"\>", 
       2->"\<\"ListCorrelate\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Convolutions and Correlations", "Title",
 CellTags->{"S3.8.5", "5.1"},
 CellID->25264],

Cell["\<\
Convolution and correlation are central to many kinds of operations on lists \
of data. They are used in such areas as signal and image processing, \
statistical data analysis, approximations to partial differential equations, \
as well as operations on digit sequences and power series.\
\>", "Text",
 CellID->12181],

Cell[TextData[{
 "In both convolution and correlation the basic idea is to combine a kernel \
list with successive sublists of a list of data. The ",
 StyleBox["convolution",
  FontSlant->"Italic"],
 " of a kernel ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["K", "r"], TraditionalForm]], "InlineMath"],
 " with a list ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", "s"], TraditionalForm]], "InlineMath"],
 " has the general form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", "r",
     LimitsPositioning->True], 
    SubscriptBox["K", "r"], 
    SubscriptBox["u", 
     RowBox[{"s", "-", "r"}]]}], TraditionalForm]], "InlineMath"],
 ", while the ",
 StyleBox["correlation",
  FontSlant->"Italic"],
 " has the general form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", "r",
     LimitsPositioning->True], 
    SubscriptBox["K", "r"], 
    SubscriptBox["u", 
     RowBox[{"s", "+", "r"}]]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->28503],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ListConvolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListConvolve"], "[", 
     StyleBox["kernel", "TI"], ",", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "form the convolution of ",
     Cell[BoxData[
      StyleBox["kernel", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ListCorrelate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListCorrelate"], "[", 
     StyleBox["kernel", "TI"], ",", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "form the correlation of ",
     Cell[BoxData[
      StyleBox["kernel", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3829],

Cell["Convolution and correlation of lists. ", "Caption",
 CellID->23775],

Cell[TextData[{
 "This forms the convolution of the kernel ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]], "InlineFormula"],
 " with a list of data. "
}], "MathCaption",
 CellID->20608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->29292],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"e", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->5997]
}, Open  ]],

Cell["This forms the correlation. ", "MathCaption",
 CellID->17549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->29556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"e", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->25561]
}, Open  ]],

Cell[TextData[{
 "In this case reversing the kernel gives exactly the same result as ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6467],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"e", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->29541]
}, Open  ]],

Cell["This forms successive differences of the data. ", "MathCaption",
 CellID->26129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->31240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}], ",", 
   RowBox[{
    RowBox[{"-", "b"}], "+", "c"}], ",", 
   RowBox[{
    RowBox[{"-", "c"}], "+", "d"}], ",", 
   RowBox[{
    RowBox[{"-", "d"}], "+", "e"}]}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->27813]
}, Open  ]],

Cell[TextData[{
 "In forming sublists to combine with a kernel, there is always an issue of \
what to do at the ends of the list of data. By default, ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 " never form sublists which would \"overhang\" the ends of the list of data. \
This means that the output you get is normally shorter than the original list \
of data. "
}], "Text",
 CellID->29174],

Cell["\<\
With an input list of length 6, the output is in this case of length 4. \
\>", "MathCaption",
 CellID->20601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"Range", "[", "6", "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->6077],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "9", ",", "12", ",", "15"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->20215]
}, Open  ]],

Cell[TextData[{
 "In practice one often wants to get output that is as long as the original \
list of data. To do this requires including sublists that overhang one or \
both ends of the list of data. The additional elements needed to form these \
sublists must be filled in with some kind of \"padding\". By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes copies of the original list to provide the padding, thus effectively \
treating the list as being cyclic. "
}], "Text",
 CellID->8683],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ListCorrelate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListCorrelate"], "[", 
     StyleBox["kernel", "TI"], ",", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "do not allow overhangs on either side (result shorter than\
\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ListCorrelate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListCorrelate"], "[", 
     StyleBox["kernel", "TI"], ",", 
     StyleBox["list", "TI"], ",", "1", "]"}], Cell[TextData[{
     "allow an overhang on the right (result same length \
as\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ListCorrelate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListCorrelate"], "[", 
     StyleBox["kernel", "TI"], ",", 
     StyleBox["list", "TI"], ",", "-", "1", "]"}], Cell[TextData[{
     "allow an overhang on the left (result same length \
as\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ListCorrelate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListCorrelate"], "[", 
     StyleBox["kernel", "TI"], ",", 
     StyleBox["list", "TI"], ",", "{", "-", "1", ",", "1", "}", "]"}], Cell[
    TextData[{
     "allow overhangs on both sides (result longer than ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ListCorrelate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListCorrelate"], "[", 
     StyleBox["kernel", "TI"], ",", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["k", "TI"], 
      StyleBox["L", "TI"]], ",", 
     SubscriptBox[
      StyleBox["k", "TI"], 
      StyleBox["R", "TI"]], "}", "]"}], Cell[
    "allow particular overhangs on left and right", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8213],

Cell["Controlling how the ends of the list of data are treated. ", "Caption",
 CellID->23992],

Cell["The default involves no overhangs. ", "MathCaption",
 CellID->25824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->5601],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->23392]
}, Open  ]],

Cell["\<\
The last term in the last element now comes from the beginning of the list. \
\>", "MathCaption",
 CellID->15759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->2670],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->26428]
}, Open  ]],

Cell["\<\
Now the first term of the first element and the last term of the last element \
both involve wraparound. \
\>", "MathCaption",
 CellID->28027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->4084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->10075]
}, Open  ]],

Cell[TextData[{
 "In the general case ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListCorrelate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListCorrelate"], "[", 
   RowBox[{
    StyleBox["kernel", "TI"], ",", 
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L", "TI"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " is set up so that in the first element of the result, the first element of \
",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " appears multiplied by the element at position ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["k", "L"], TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  StyleBox["kernel", "TI"]], "InlineFormula"],
 ", and in the last element of the result, the last element of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " appears multiplied by the element at position ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["k", "R"], TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  StyleBox["kernel", "TI"]], "InlineFormula"],
 ". The default case in which no overhang is allowed on either side thus \
corresponds to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListCorrelate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListCorrelate"], "[", 
   RowBox[{
    StyleBox["kernel", "TI"], ",", 
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->18786],

Cell[TextData[{
 "With a kernel of length 3, alignments ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "2"}], "}"}]], "InlineFormula"],
 " always make the first and last elements of the result the same. "
}], "MathCaption",
 CellID->15498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->24970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}], "+", 
    RowBox[{"a", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}], "+", 
    RowBox[{"b", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}], "+", 
    RowBox[{"c", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}], "+", 
    RowBox[{"d", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}], "+", 
    RowBox[{"a", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{444, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->6287]
}, Open  ]],

Cell["\<\
For many kinds of data, it is convenient to assume not that the data is \
cyclic, but rather that it is padded at either end by some fixed element, \
often 0, or by some sequence of elements. \
\>", "Text",
 CellID->23847],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ListCorrelate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListCorrelate"], "[", 
     StyleBox["kernel", "TI"], ",", 
     StyleBox["list", "TI"], ",", 
     StyleBox["klist", "TI"], ",", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "pad with element ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ListCorrelate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListCorrelate"], "[", 
     StyleBox["kernel", "TI"], ",", 
     StyleBox["list", "TI"], ",", 
     StyleBox["klist", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["p", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["p", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "pad with cyclic repetitions of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["p", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ListCorrelate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListCorrelate"], "[", 
     StyleBox["kernel", "TI"], ",", 
     StyleBox["list", "TI"], ",", 
     StyleBox["klist", "TI"], ",", 
     StyleBox["list", "TI"], "]"}], Cell[
    "pad with cyclic repetitions of the original data", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32604],

Cell["Controlling the padding for a list of data. ", "Caption",
 CellID->503],

Cell[TextData[{
 "This pads with element ",
 Cell[BoxData["p"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "p"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->22663],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"p", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"p", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->5706]
}, Open  ]],

Cell["A common case is to pad with zero. ", "MathCaption",
 CellID->2363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->9010],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", " ", "y"}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{"d", " ", "x"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->22171]
}, Open  ]],

Cell["\<\
When the padding is indicated by {p,q}, the list {a,b,c} overlays \
{...,p,q,p,q,...} with a p aligned under the a. \
\>", "MathCaption",
 CellID->27489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "q"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->18240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"p", " ", "x"}], "+", 
    RowBox[{"q", " ", "y"}], "+", 
    RowBox[{"a", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"q", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}], "+", 
    RowBox[{"b", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}], "+", 
    RowBox[{"c", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}], "+", 
    RowBox[{"q", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"q", " ", "y"}], "+", 
    RowBox[{"p", " ", "z"}]}]}], "}"}]], "Output",
 ImageSize->{444, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->242267540]
}, Open  ]],

Cell[TextData[{
 "Different choices of kernel allow ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 " to be used for different kinds of computations. "
}], "Text",
 CellID->25542],

Cell["This finds a moving average of data. ", "MathCaption",
 CellID->7619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}], "/", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->171277337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["a", "3"], "+", 
    FractionBox["b", "3"], "+", 
    FractionBox["c", "3"]}], ",", 
   RowBox[{
    FractionBox["b", "3"], "+", 
    FractionBox["c", "3"], "+", 
    FractionBox["d", "3"]}], ",", 
   RowBox[{
    FractionBox["c", "3"], "+", 
    FractionBox["d", "3"], "+", 
    FractionBox["e", "3"]}]}], "}"}]], "Output",
 ImageSize->{217, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->46473649]
}, Open  ]],

Cell["Here is a Gaussian kernel. ", "MathCaption",
 CellID->6704],

Cell[BoxData[
 RowBox[{
  RowBox[{"kern", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"n", "^", "2"}]}], "/", "100"}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"2.", " ", "Pi"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->31818],

Cell["This generates some \"data\". ", "MathCaption",
 CellID->9232],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"1", ",", "x"}], "]"}], "+", 
      RowBox[{"0.2", " ", 
       RowBox[{"RandomReal", "[", "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10", ",", ".1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->750],

Cell["Here is a plot of the data. ", "MathCaption",
 CellID->25205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->4975],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->135387834]
}, Open  ]],

Cell["This convolves the kernel with the data. ", "MathCaption",
 CellID->303],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListConvolve", "[", 
   RowBox[{"kern", ",", "data"}], "]"}], ";"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->107531673],

Cell["The result is a smoothed version of the data. ", "MathCaption",
 CellID->21098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "%", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->29745879],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WN1PVEcUv+y9uysiEvyogALL+lFcQSgx1UJBFASJoNZoNH1oikTrPggW
bWwlSIgxDWlNY2If1MZEo8Y3HzSa+Gpi9MlXn/1H1jszlzkzv3vuuJSmJMxy
7p7fxzkz985lxsYvnTtzfvxScWI8Nzw9fuFcceJibmhqOrzkV3ie9zz8LdZ5
4d+l8C/5+7xUCj9rxOiLWP54D9ir34mh6tHD93t7bxd/esqON/587Q1pdCoE
HxVRjUKNDN8Lx/7eO+w40H83Yhhk9Y+Iofbkicdh1uC+u1OTz/6+9YYdD4/e
t/j2s3xjYkgrZ5d/eRniXr744FXKq+/eftQ8Bwb+SWA4ZDCo2kRutcEwN/sq
8tBvdWVU5pi1CG3Fr64KJoXJhqMQTXPqvtIR6FpWt09yrABsAPGIjFUlArUe
nCgWz1cf4ie1GH6WlVjWsw6/TXQowmF2ljYAczKHGQ8Dqp71070ELur+RuDu
1nMnOpUB9AHodyOwdVurZQi4mwG9h12dA2znmoHLgTWyWsAfjxLcgVgbke9N
gJLrJdD5UVYDVONH1xc/WyAOrN5IZ2nFqUfpwHS2ATTStpNEBHVAfp8xETyu
scy8CraDLUv25Uc9VyUZQLW6je7/PxXkjTh5JmBNYL7VAXlnBTR3Nien0RSt
jTiXb62dzf+aB+92n81qXlYny0WrZzX1J+N2nda9j6r2Y3nL850r2fdrHfQq
a+uV7Ls8VfrcXW9q7YXVtAN60WXNdx982w7OuliNXshqB00XirI6QLuTRU2B
lspaFY5P5K6L+dn/OM7YM6+N4O63XB3JZ93TlctkpDvbvLoV4rUwK6vhe/n0
Cqj/nvdlWTo/A+9OnSXWXTfM/VmW4xuY+92AanOgSHk3sPCoi4Bqs/zuAeUe
iAssJyr3QOxCkZMeiAuWs1/BSSvL+TVk9YETFwreeQ0nLhRlFS2/V8DJNpZj
F2TtBycKJd5I/cUnYQxN2RIde6vdIjnwLsM3+F1QzSBwJ7OIcAbQ5Wl2QfXn
l4AiZweBJb8EFnJ8EFjzuvOp6BVLfF4FVJ6d1TlwlGOzOiFrFBy4UJQ1ys55
k7UWvwLXh4GjiVWaZ5k3sbk7oZZjoOBCUdYxVrHBqqUDajkOHA2s0nWWuY7N
bYNaToFCneUH3yROsUpfOJSolu8lVnHRGcY6iRW7XsA8AxbEkDVPLQi5Rq9h
810XGQpQ7w8OxirITSXeayIsQG9+FPHaODN7mhTm4vmKUlsJavhuWoCunhZx
ramadAKllOhUpjy9VuiJ3OOrlV7SCRVpBHp27TdxnKVW6OUkVJnRc20+r7ZD
1mV2HfKnftugrt8cWeSLslL6HYr0eQ5efwvozziySH/G0t8K+jxHHpRmHVmk
NGspbQYlniMHSnN69rlzvhwozpW1HnPgJBnly38C1b0mrm0Ed/OxNSXXqDbU
CP5UPrvzCpy2hGde88l10X8k2lY9uLwW62Fq8TGnrdWD02s0O6SgDeH5iZEd
6zuenFJ83YGCk1EjJpQ+Z43tJuq8F8/3eL0A+Gsh/t2Bog7UsIo8NgN9qDKw
9CxfsOqUz7/YzievZk0kPTcXkrUT9i7fwfYHyyZ3zuqk/Qo5blgVyaor47sO
5f/Faq4yZlztGCL3JpurnptexSeGeUg5\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->250652029]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 " to handle symbolic as well as numerical data. "
}], "Text",
 CellID->13648],

Cell["This forms the convolution of two symbolic lists. ", "MathCaption",
 CellID->2971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->17864],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", " ", "u"}], ",", 
   RowBox[{
    RowBox[{"b", " ", "u"}], "+", 
    RowBox[{"a", " ", "v"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "u"}], "+", 
    RowBox[{"b", " ", "v"}], "+", 
    RowBox[{"a", " ", "w"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "v"}], "+", 
    RowBox[{"b", " ", "w"}]}], ",", 
   RowBox[{"c", " ", "w"}]}], "}"}]], "Output",
 ImageSize->{267, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->22913]
}, Open  ]],

Cell["\<\
The result corresponds exactly with the coefficients in the expanded form of \
this product of polynomials. \
\>", "MathCaption",
 CellID->11075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"x", "^", "2"}]}]}], ")"}], 
   RowBox[{"(", 
    RowBox[{"u", "+", 
     RowBox[{"v", " ", "x"}], "+", 
     RowBox[{"w", " ", 
      RowBox[{"x", "^", "2"}]}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->21545],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "u"}], "+", 
  RowBox[{"b", " ", "u", " ", "x"}], "+", 
  RowBox[{"a", " ", "v", " ", "x"}], "+", 
  RowBox[{"c", " ", "u", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"b", " ", "v", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"a", " ", "w", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"c", " ", "v", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"b", " ", "w", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"c", " ", "w", " ", 
   SuperscriptBox["x", "4"]}]}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->28712]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 " work on data in any number of dimensions. "
}], "Text",
 CellID->17546],

Cell["This imports image data from a file. ", "MathCaption",
 CellID->18678],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"ReadList", "[", 
    RowBox[{"\"\<ExampleData/fish.data\>\"", ",", "Number", ",", 
     RowBox[{"RecordLists", "->", "True"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->1769],

Cell["Here is the image. ", "MathCaption",
 CellID->15262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", "g", "]"}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->79599589],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->47745085]
}, Open  ]],

Cell["\<\
This convolves the data with a two\[Hyphen]dimensional kernel. \
\>", "MathCaption",
 CellID->28289],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListConvolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "8"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", "g"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->15944],

Cell["This shows the image corresponding to the data. ", "MathCaption",
 CellID->2865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->18540],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->600884978]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->98117341],

Cell[TextData[ButtonBox["Numerical Operations on Data",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnDataOverview"]], "RelatedTutorials",
 CellID->618122]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Convolutions and Correlations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Data", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnDataOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FourierTransforms"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CellularAutomata"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 45.0307690}", "context" -> "", 
    "keywords" -> {
     "banded matrices", "circulant matrix multiplication", 
      "circular partitioning", "convolutions", "correlations", 
      "cyclic partitioning", "dithering", "filtering", 
      "finite difference methods", "FIR filters", "image processing", 
      "kernel", "ListConvolve", "ListCorrelate", "masking", "moving averages",
       "PadLeft", "RotateLeft", "signal processing", "smoothing", "Take", 
      "time series", "Toeplitz matrix multiplication", 
      "wraparound partitioning"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Convolution and correlation are central to many kinds of operations on \
lists of data. They are used in such areas as signal and image processing, \
statistical data analysis, approximations to partial differential equations, \
as well as operations on digit sequences and power series. In both \
convolution and correlation the basic idea is to combine a kernel list with \
successive sublists of a list of data. The convolution of a kernel K_r with a \
list u_s has the general form UnderscriptBox[\\[Sum], r, LimitsPositioning -> \
True]K_ru_s-r, while the correlation has the general form \
UnderscriptBox[\\[Sum], r, LimitsPositioning -> True]K_ru_s+r. Convolution \
and correlation of lists. ", "synonyms" -> {"3.8.5"}, "title" -> 
    "Convolutions and Correlations", "type" -> "Tutorial", "uri" -> 
    "tutorial/ConvolutionsAndCorrelations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.8.5"->{
  Cell[1975, 62, 92, 2, 70, "Title",
   CellTags->{"S3.8.5", "5.1"},
   CellID->25264]},
 "5.1"->{
  Cell[1975, 62, 92, 2, 70, "Title",
   CellTags->{"S3.8.5", "5.1"},
   CellID->25264]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.8.5", 138856, 2991},
 {"5.1", 138955, 2995}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1350, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1975, 62, 92, 2, 70, "Title",
 CellTags->{"S3.8.5", "5.1"},
 CellID->25264],
Cell[2070, 66, 327, 6, 70, "Text",
 CellID->12181],
Cell[2400, 74, 1008, 36, 70, "Text",
 CellID->28503],
Cell[3411, 112, 1182, 37, 70, "DefinitionBox",
 CellID->3829],
Cell[4596, 151, 73, 1, 70, "Caption",
 CellID->23775],
Cell[4672, 154, 207, 7, 70, "MathCaption",
 CellID->20608],
Cell[CellGroupData[{
Cell[4904, 165, 259, 9, 28, "Input",
 CellID->29292],
Cell[5166, 176, 516, 19, 36, "Output",
 CellID->5997]
}, Open  ]],
Cell[5697, 198, 67, 1, 70, "MathCaption",
 CellID->17549],
Cell[CellGroupData[{
Cell[5789, 203, 260, 9, 28, "Input",
 CellID->29556],
Cell[6052, 214, 517, 19, 36, "Output",
 CellID->25561]
}, Open  ]],
Cell[6584, 236, 255, 8, 70, "MathCaption",
 CellID->31627],
Cell[CellGroupData[{
Cell[6864, 248, 259, 9, 70, "Input",
 CellID->6467],
Cell[7126, 259, 517, 19, 36, "Output",
 CellID->29541]
}, Open  ]],
Cell[7658, 281, 86, 1, 70, "MathCaption",
 CellID->26129],
Cell[CellGroupData[{
Cell[7769, 286, 281, 10, 70, "Input",
 CellID->31240],
Cell[8053, 298, 397, 15, 36, "Output",
 CellID->27813]
}, Open  ]],
Cell[8465, 316, 617, 16, 70, "Text",
 CellID->29174],
Cell[9085, 334, 119, 3, 70, "MathCaption",
 CellID->20601],
Cell[CellGroupData[{
Cell[9229, 341, 220, 7, 70, "Input",
 CellID->6077],
Cell[9452, 350, 222, 7, 36, "Output",
 CellID->20215]
}, Open  ]],
Cell[9689, 360, 513, 10, 70, "Text",
 CellID->8683],
Cell[10205, 372, 2464, 76, 70, "DefinitionBox",
 CellID->8213],
Cell[12672, 450, 93, 1, 70, "Caption",
 CellID->23992],
Cell[12768, 453, 74, 1, 70, "MathCaption",
 CellID->25824],
Cell[CellGroupData[{
Cell[12867, 458, 246, 8, 70, "Input",
 CellID->5601],
Cell[13116, 468, 433, 16, 36, "Output",
 CellID->23392]
}, Open  ]],
Cell[13564, 487, 123, 3, 70, "MathCaption",
 CellID->15759],
Cell[CellGroupData[{
Cell[13712, 494, 259, 9, 70, "Input",
 CellID->2670],
Cell[13974, 505, 517, 19, 36, "Output",
 CellID->26428]
}, Open  ]],
Cell[14506, 527, 152, 4, 70, "MathCaption",
 CellID->28027],
Cell[CellGroupData[{
Cell[14683, 535, 326, 11, 70, "Input",
 CellID->4084],
Cell[15012, 548, 601, 22, 36, "Output",
 CellID->10075]
}, Open  ]],
Cell[15628, 573, 1616, 54, 70, "Text",
 CellID->18786],
Cell[17247, 629, 267, 8, 70, "MathCaption",
 CellID->15498],
Cell[CellGroupData[{
Cell[17539, 641, 337, 11, 70, "Input",
 CellID->24970],
Cell[17879, 654, 775, 27, 36, "Output",
 CellID->6287]
}, Open  ]],
Cell[18669, 684, 232, 5, 70, "Text",
 CellID->23847],
Cell[18904, 691, 1731, 51, 70, "DefinitionBox",
 CellID->32604],
Cell[20638, 744, 77, 1, 70, "Caption",
 CellID->503],
Cell[20718, 747, 122, 5, 70, "MathCaption",
 CellID->21221],
Cell[CellGroupData[{
Cell[20865, 756, 338, 11, 70, "Input",
 CellID->22663],
Cell[21206, 769, 601, 22, 36, "Output",
 CellID->5706]
}, Open  ]],
Cell[21822, 794, 73, 1, 70, "MathCaption",
 CellID->2363],
Cell[CellGroupData[{
Cell[21920, 799, 337, 11, 70, "Input",
 CellID->9010],
Cell[22260, 812, 502, 18, 36, "Output",
 CellID->22171]
}, Open  ]],
Cell[22777, 833, 163, 4, 70, "MathCaption",
 CellID->27489],
Cell[CellGroupData[{
Cell[22965, 841, 385, 13, 70, "Input",
 CellID->18240],
Cell[23353, 856, 779, 27, 36, "Output",
 CellID->242267540]
}, Open  ]],
Cell[24147, 886, 401, 13, 70, "Text",
 CellID->25542],
Cell[24551, 901, 75, 1, 70, "MathCaption",
 CellID->7619],
Cell[CellGroupData[{
Cell[24651, 906, 299, 10, 70, "Input",
 CellID->171277337],
Cell[24953, 918, 522, 19, 51, "Output",
 CellID->46473649]
}, Open  ]],
Cell[25490, 940, 65, 1, 70, "MathCaption",
 CellID->6704],
Cell[25558, 943, 464, 16, 70, "Input",
 CellID->31818],
Cell[26025, 961, 68, 1, 70, "MathCaption",
 CellID->9232],
Cell[26096, 964, 402, 14, 70, "Input",
 CellID->750],
Cell[26501, 980, 67, 1, 70, "MathCaption",
 CellID->25205],
Cell[CellGroupData[{
Cell[26593, 985, 104, 3, 28, "Input",
 CellID->4975],
Cell[26700, 990, 2271, 41, 119, "Output",
 Evaluatable->False,
 CellID->135387834]
}, Open  ]],
Cell[28986, 1034, 78, 1, 70, "MathCaption",
 CellID->303],
Cell[29067, 1037, 157, 5, 70, "Input",
 CellID->107531673],
Cell[29227, 1044, 85, 1, 70, "MathCaption",
 CellID->21098],
Cell[CellGroupData[{
Cell[29337, 1049, 104, 3, 28, "Input",
 CellID->29745879],
Cell[29444, 1054, 1893, 35, 126, "Output",
 Evaluatable->False,
 CellID->250652029]
}, Open  ]],
Cell[31352, 1092, 377, 13, 70, "Text",
 CellID->13648],
Cell[31732, 1107, 88, 1, 70, "MathCaption",
 CellID->2971],
Cell[CellGroupData[{
Cell[31845, 1112, 337, 11, 70, "Input",
 CellID->17864],
Cell[32185, 1125, 537, 19, 36, "Output",
 CellID->22913]
}, Open  ]],
Cell[32737, 1147, 155, 4, 70, "MathCaption",
 CellID->11075],
Cell[CellGroupData[{
Cell[32917, 1155, 394, 14, 70, "Input",
 CellID->21545],
Cell[33314, 1171, 686, 21, 36, "Output",
 CellID->28712]
}, Open  ]],
Cell[34015, 1195, 356, 12, 70, "Text",
 CellID->17546],
Cell[34374, 1209, 76, 1, 70, "MathCaption",
 CellID->18678],
Cell[34453, 1212, 250, 7, 70, "Input",
 CellID->1769],
Cell[34706, 1221, 58, 1, 70, "MathCaption",
 CellID->15262],
Cell[CellGroupData[{
Cell[34789, 1226, 137, 4, 28, "Input",
 CellID->79599589],
Cell[34929, 1232, 50257, 828, 201, "Output",
 Evaluatable->False,
 CellID->47745085]
}, Open  ]],
Cell[85201, 2063, 110, 3, 70, "MathCaption",
 CellID->28289],
Cell[85314, 2068, 430, 15, 70, "Input",
 CellID->15944],
Cell[85747, 2085, 86, 1, 70, "MathCaption",
 CellID->2865],
Cell[CellGroupData[{
Cell[85858, 2090, 134, 4, 28, "Input",
 CellID->18540],
Cell[85995, 2096, 49310, 812, 201, "Output",
 Evaluatable->False,
 CellID->600884978]
}, Open  ]],
Cell[CellGroupData[{
Cell[135342, 2913, 71, 1, 70, "RelatedTutorialsSection",
 CellID->98117341],
Cell[135416, 2916, 183, 4, 70, "RelatedTutorials",
 CellID->618122]
}, Open  ]]
}, Open  ]],
Cell[135626, 2924, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

