(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47081,       1504]
NotebookOptionsPosition[     39498,       1256]
NotebookOutlinePosition[     42318,       1329]
CellTagsIndexPosition[     42225,       1323]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnDataOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Data\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindFit" :> Documentation`HelpLookup["paclet:ref/FindFit"], 
          "Fit" :> Documentation`HelpLookup["paclet:ref/Fit"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FindFit\"\>", 
       2->"\<\"Fit\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Curve Fitting", "Title",
 CellTags->{"S3.8.2", "2.1"},
 CellID->19037],

Cell[TextData[{
 "There are many situations where one wants to find a formula that best fits \
a given set of data. One way to do this in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is to use ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->6410],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Fit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fit"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["fun", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["fun", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "find a linear combination of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["fun", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " that best fits the values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31461],

Cell["Basic linear fitting. ", "Caption",
 CellID->6234],

Cell["Here is a table of the first 20 primes. ", "MathCaption",
 CellID->12508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fp", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Prime", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "20"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "5", ",", "7", ",", "11", ",", "13", ",", "17", ",", 
   "19", ",", "23", ",", "29", ",", "31", ",", "37", ",", "41", ",", "43", 
   ",", "47", ",", "53", ",", "59", ",", "61", ",", "67", ",", "71"}], 
  "}"}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->424150084]
}, Open  ]],

Cell["\<\
Here is a plot of this \[OpenCurlyDoubleQuote]data\[CloseCurlyDoubleQuote]. \
\>", "MathCaption",
 CellID->6493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gp", "=", 
  RowBox[{"ListPlot", "[", "fp", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1515],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, {
     7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 37.}, {13.,
      41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 61.}, {19., 
     67.}, {20., 71.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 20.}, {0., 71.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128780232]
}, Open  ]],

Cell[TextData[{
 "This gives a linear fit to the list of primes. The result is the best \
linear combination of the functions ",
 Cell[BoxData["1"], "InlineFormula"],
 " and ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->24937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"fp", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28869],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "7.6736842105263126`"}], "+", 
  RowBox[{"3.773684210526316`", " ", "x"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1156394647]
}, Open  ]],

Cell["Here is a plot of the fit. ", "MathCaption",
 CellID->14700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13971],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWGuIVVUUPjP33KkMo+yhWFOjM5M9rKwsK6Z3apb2sNRKy243cyYfM+pV
TE20UjOzh4Kphf2x6PXDSIzAIBIiIRIiISoIg7AfSZD0YyA4fXutvffZe591
Z84cjC4z59x179rfXnt93157nTulUuucs6BS66pWWiYurvR0dlWXtEzoXoyP
Sg1RFO3F//xhEd4neEf/e5MEd/c6WF1L6jt6RbvFT0fiosw2fW/EvRH3EdqO
YhqmX+rT2PEqWUxlXShgR3Fq8zjX44LALknfl9m2V0JRaWhQ93RVaqauzj2b
Xz5w7NjfbSc8lhYRQYhDx/vxnsOPznwf16j1hMcywrHrZ0RxEpXx5vjxXmQF
uTly5E/CVt+054si9dDj2nLN7eIQbnz4+9+rT3y0Y/vB3t5/mgOPtnyxlN1Y
1NyUySZ3XF/MNBo5xwjhnd2HQM/Br39t1t+0JqmmzQ4wI1y7lITad+MsE/7R
o38tre1bueIzKPFN0e8ksg98+QuCQCjRTi/KUwgFtCFdoA2p2y6iDDKZhRNn
dhv5qc/fM1mUY8zEDBsx4w/Bx3lG/Id20/88f392H9yHHMeQGHMMdoYEHu2B
HVbQcJ/Uj0Op5oxEaxtSwFY79O1vr4lxUhQxakH3wk82rP8CGn1F9DuL7E/3
/aDr2GZvtnMSrVFbWjaJKEMTrVGgsEY3ejjDyR/54ZCjF0WU4U7Ma9fsR8zr
Rb/zyP58/896X60jL/8UM6dXWd/PNyvhvCHU58md61ZfVUmumD/9+AcSsnXL
V4BcWxCJK/yHH3yHdWA10ZoB4JRMZYyRJiSL9/TqgpFwbWYVv73rG/C3agBI
ti9QusRwrrkreUApZcVU1VDho2gs11Pm/RmR94sd3qHYaLmnsUsNw5A7a3WZ
iDI6o9Wa6Hd5ojU7Y9q7WE60xJttjMk911O8WSSiXEk2xgNFabWHvNz+yij0
apNBBIXQEOBCTl0T39xrf3yOTfRO4l4JSZlfUBnXks19jsr5PBrm9ipRHRRl
jjNZAifY1Cqg3ONd+3rCQeWwnM3VuZH7AkmhHQGfT+XWZ0eG6ydFrm8yXOu6
VPUUc4vRpz3vKyLKrUaffN5jwGzR73azHt5u0WPebOMzMc8SUSYE+pzJ/ATZ
UPc7fX2CjIcLcTnJaNOeTDMK4dxNdnpyTc/wmVV7rHU52XBhz7UHk2L74x7D
llXm1EKruS9Q5/11eZjqM4uyea/I7APk53YmUzyFTHP45GN5sogzPcPXXaLf
Qw4fqlJM8mZ7xGTcVoKJIgrpT+10hMQn0XjRb5aJHk5wxTLvkBgMcjfbrAWJ
47XcVpD3xwP10a4lCC4fDpRVXcVXHVqIm7VmA51kNOvOXDWKw7K5/7gxyad8
F2UO2Wnv0ZETQ2VxrlEg9x1I5w395N6dudPo0jJ8naeUpzPMjhMVMC/D5TWi
34JAl2O92bodXfJarhJRejJRjxH9FmWivyKpt5Nrzgq477ksKVI7lpKd9sOj
c6Moc5nJgO07LikUxXKzGkgbyQTgRQV0uSJga5SHYecVdbnK6NJy2W512Rj5
HZc757MZbltFblc73PKhO9LTEj0HeL8LtIg4z5HNvwtgB/IThUV5wfCBzc1V
ollEoace7xeXc0W/DWTzyYI5+Smrbt+j7htNHrEIPmGGsXPObsu1XyI77YmG
FkbaZLJvn+DOHhCWMunpVj+7cV98ZmJ2Z//afJVsVHtkUmlzyAC0+bph1T6d
nJ5Lm1syLJ8msrzVZMc2hIM9VW3LaPNUEeeNQJuDPJQdvjYR1skiyk4TtX1G
bhL93iKbTyHV9ZS92XbRtwgVCydAEUP+zZs/jRr+BWznwqs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->165786467]
}, Open  ]],

Cell["Here is the fit superimposed on the original data. ", "MathCaption",
 CellID->15117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", "gp"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->16215],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->417872950]
}, Open  ]],

Cell["This gives a quadratic fit to the data. ", "MathCaption",
 CellID->7815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"fp", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->18330],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.9236842105262966`"}], "+", 
  RowBox[{"2.205502392344496`", " ", "x"}], "+", 
  RowBox[{"0.07467532467532471`", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->2144133330]
}, Open  ]],

Cell["Here is a plot of the quadratic fit. ", "MathCaption",
 CellID->30212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->29288],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx38803kcwPFp2Tmsm3N+ZGWz2Jj5MSuk9H239dPQrIb0aMeEwikurpqu
HkVFya6T/Iil0HHonH6501Z+hLLlx0PFpGTrByqS65wfu09/vB6vx9NOslcY
tQCHwwWivrzoZwmBvatwjSmxkL67dV7Z3EP1D6EexH6tUhXMZM8r9fcVx6nU
DGyRg4yZETqvLLqbRTGk5mPaS80Xz72dU8b7Jv/wmVKBGTWPPhSbzCl7Znbn
jFPqMc5tD9FAwIzyK81LxjtKO2YZesU8Xv1ZWfJAnjhK6cNIKd/A4J1xZc21
DE286wgW2svrGbxdq4zBuvLHkiYxq5Uvv6Y1jWIJOqfh6zXT2HhwIoszMYsZ
26UxnnvjQHcodumWpwQ4S3rILAnHQ+rlTKlv/yKQaLYp8R0EUAx4nmocNIfE
ljTJXoYxlLOsfuwNtobafaZbrTcTodTX0JhfsARKpHEj7iEkyBbwDzIqqXBM
Phv0acwM3vcVro0apQGu5wU0HDKHmjqH3A8sB6Dvjz6wjWkBe9IcBfIqBmin
LgSb3LGEziUe6+4RmeCniz18LtEaUvmelF3XWBColTnb2toAowQz8RG6wUiT
5GhbNRl+6Rmu7HnrDq5mj5fyvl8KFvgXDK6/BxhjUxEDk7aQuSHKmlvEgY3v
wj7TRFSItw2edzRbAU8bdxmEsewgvJjXT073hBunmsXUKTtY4SC2Yb/ygmjD
5BdqNQ36jBIjyuNWQmSS9IZpwTKghwRNH3vmA24xzmr/CHuwttgbPhWwGh59
yzJJXukAsY69Mi+tL/xdc6yQhaeDTfyJMmkUBlIDpqDjGR1OGLdoB08AGA8c
2pRwnQG3qMT8tLC1oCu3y5GnOoLV+BPvTzQu5DguXlgvcoKy0zHaYj0XZAXR
rRFUJsT8mbD8ZicPwnJ2qk1fM0GrKMu7cGkd/LuubFqucAaPdtuouPT1MKzj
Hmg8yQKrPX2XpndugMu+bLIqwgUaJIRZkv9GqE5PNotxcYUZq/Pm6S6b4KQo
ko+fcoU4nwniYeJmWDFQUnFS5QYKjS7sJt4P8pwKq1V8dxBzfcT5Y35w5G5W
Hr/eHd4/6lwsGuNDAFlU9sCeDV1vBGfUI/6wNqF1h1kGG/oXqcQ+mgCQL5HY
d0yxwdu2DFs1HAj2TVdzA3d4wBBuDalrYAvIXBqZ3QoPkM2VapbHCiB6cmFX
O5MDeRdzsxgfBSCp/UjNyObAkO+7/aeTgqDtgdHxhlkOkPX5XhH6IIjnDcna
kc+LnR2TkEkN9cWPkV/bNFkfRw6tjv1rHNmy0vC/UuTX2R0T9nMcyKU9aXiD
TBDJwrOQ2am/8/bhhMB7brVGPM8BRdfi4CMGQngVMs6PQ97QkbJRhpzZ2bb9
APJvy/q9S5C77x1MPof86U0duQlZUqqpuo9cp6obIiwQwtE9crKbngPNem3C
WWT7lz85rUbubb0aLkduCxN4bUZWjO0T/oFM8jfYGolsE2Dp2Y0sd43MvID8
T0z1nAVeCNyrq/JKkdssr3ygI7+ifFdei5xCkw95Ibuatdx7iLxdUNmyHbk7
o+jRU+TspPpbscgpC1Ke6ZCLJ9QVUmQbaeDoR+R01UjhGWTFJH1aj7yeQDxb
hPw/4Wwxew==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  Method->{},
  PlotRange->{{0, 20}, {-1.923683310321226, 72.05649138709948}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->95859370]
}, Open  ]],

Cell["\<\
This shows the fit superimposed on the original data. The quadratic fit is \
better than the linear one. \
\>", "MathCaption",
 CellID->1954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", "gp"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->16085],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx38803kcwPFp2Tmsm3N+ZGWz2Jj5MSuk9H239dPQrIb0aMeEwikurpqu
HkVFya6T/Iil0HHonH6501Z+hLLlx0PFpGTrByqS65wfu09/vB6vx9NOslcY
tQCHwwWivrzoZwmBvatwjSmxkL67dV7Z3EP1D6EexH6tUhXMZM8r9fcVx6nU
DGyRg4yZETqvLLqbRTGk5mPaS80Xz72dU8b7Jv/wmVKBGTWPPhSbzCl7Znbn
jFPqMc5tD9FAwIzyK81LxjtKO2YZesU8Xv1ZWfJAnjhK6cNIKd/A4J1xZc21
DE286wgW2svrGbxdq4zBuvLHkiYxq5Uvv6Y1jWIJOqfh6zXT2HhwIoszMYsZ
26UxnnvjQHcodumWpwQ4S3rILAnHQ+rlTKlv/yKQaLYp8R0EUAx4nmocNIfE
ljTJXoYxlLOsfuwNtobafaZbrTcTodTX0JhfsARKpHEj7iEkyBbwDzIqqXBM
Phv0acwM3vcVro0apQGu5wU0HDKHmjqH3A8sB6Dvjz6wjWkBe9IcBfIqBmin
LgSb3LGEziUe6+4RmeCniz18LtEaUvmelF3XWBColTnb2toAowQz8RG6wUiT
5GhbNRl+6Rmu7HnrDq5mj5fyvl8KFvgXDK6/BxhjUxEDk7aQuSHKmlvEgY3v
wj7TRFSItw2edzRbAU8bdxmEsewgvJjXT073hBunmsXUKTtY4SC2Yb/ygmjD
5BdqNQ36jBIjyuNWQmSS9IZpwTKghwRNH3vmA24xzmr/CHuwttgbPhWwGh59
yzJJXukAsY69Mi+tL/xdc6yQhaeDTfyJMmkUBlIDpqDjGR1OGLdoB08AGA8c
2pRwnQG3qMT8tLC1oCu3y5GnOoLV+BPvTzQu5DguXlgvcoKy0zHaYj0XZAXR
rRFUJsT8mbD8ZicPwnJ2qk1fM0GrKMu7cGkd/LuubFqucAaPdtuouPT1MKzj
Hmg8yQKrPX2XpndugMu+bLIqwgUaJIRZkv9GqE5PNotxcYUZq/Pm6S6b4KQo
ko+fcoU4nwniYeJmWDFQUnFS5QYKjS7sJt4P8pwKq1V8dxBzfcT5Y35w5G5W
Hr/eHd4/6lwsGuNDAFlU9sCeDV1vBGfUI/6wNqF1h1kGG/oXqcQ+mgCQL5HY
d0yxwdu2DFs1HAj2TVdzA3d4wBBuDalrYAvIXBqZ3QoPkM2VapbHCiB6cmFX
O5MDeRdzsxgfBSCp/UjNyObAkO+7/aeTgqDtgdHxhlkOkPX5XhH6IIjnDcna
kc+LnR2TkEkN9cWPkV/bNFkfRw6tjv1rHNmy0vC/UuTX2R0T9nMcyKU9aXiD
TBDJwrOQ2am/8/bhhMB7brVGPM8BRdfi4CMGQngVMs6PQ97QkbJRhpzZ2bb9
APJvy/q9S5C77x1MPof86U0duQlZUqqpuo9cp6obIiwQwtE9crKbngPNem3C
WWT7lz85rUbubb0aLkduCxN4bUZWjO0T/oFM8jfYGolsE2Dp2Y0sd43MvID8
T0z1nAVeCNyrq/JKkdssr3ygI7+ifFdei5xCkw95Ibuatdx7iLxdUNmyHbk7
o+jRU+TspPpbscgpC1Ke6ZCLJ9QVUmQbaeDoR+R01UjhGWTFJH1aj7yeQDxb
hPw/4Wwxew==
      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, {
      7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 37.}, {
      13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 61.}, {
      19., 67.}, {20., 71.}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  Method->{},
  PlotRange->{{0, 20}, {-1.923683310321226, 72.05649138709948}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1159859348]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["f", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[TextData[{
     "data points obtained when a single coordinate takes on values ",
     Cell[BoxData[
      FormBox[
       RowBox[{"1", ",", "2", ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{"{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[TextData[{
     "data points obtained when a single coordinate takes on values ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["x", "1"], ",", 
        SubscriptBox["x", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "data points obtained with values ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["x", "i"], ",", 
        SubscriptBox["y", "i"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     " of a sequence of coordinates"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24484],

Cell["Ways of specifying data. ", "Caption",
 CellID->24774],

Cell[TextData[{
 "If you give data in the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["f", "1"], ",", 
     SubscriptBox["f", "2"], ",", "\[Ellipsis]"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " then ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 " will assume that the successive ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "i"], TraditionalForm]], "InlineMath"],
 " correspond to values of a function at successive integer points ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "\[Ellipsis]"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 ". But you can also give ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 " data that corresponds to the values of a function at arbitrary points, in \
one or more dimensions. "
}], "Text",
 CellID->8380],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Fit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fit"], "[", 
     StyleBox["data", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["fun", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["fun", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "fit to a function of several variables", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29815],

Cell["Multivariate fitting. ", "Caption",
 CellID->25951],

Cell[TextData[{
 "This gives a table of the values of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", "5", "x", "-", "x", "y"}], TraditionalForm]], 
  "InlineMath"],
 ". You need to use ",
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " to get it in the right form for ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", 
       RowBox[{"1", "+", 
        RowBox[{"5", "x"}], "-", 
        RowBox[{"x", " ", "y"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1", ",", "0.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1", ",", "0.4"}], "}"}]}], "]"}], ",", 
   "1"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->18115],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.4`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.8`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", "0.`", ",", "3.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", "0.4`", ",", "2.84`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", "0.8`", ",", "2.6799999999999997`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", "0.`", ",", "5.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", "0.4`", ",", "4.68`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", "0.8`", ",", "4.359999999999999`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{504, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1400054371]
}, Open  ]],

Cell["This produces a fit to a function of two variables. ", "MathCaption",
 CellID->17110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", "y", ",", 
     RowBox[{"x", " ", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->25898],

Cell[BoxData[
 RowBox[{"0.9999999999999988`", "\[InvisibleSpace]", "+", 
  RowBox[{"4.999999999999998`", " ", "x"}], "+", 
  RowBox[{"5.2110793248262`*^-15", " ", "y"}], "-", 
  RowBox[{"1.0000000000000024`", " ", "x", " ", "y"}]}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->744312764]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 " takes a list of functions, and uses a definite and efficient procedure to \
find what linear combination of these functions gives the best \
least\[Hyphen]squares fit to your data. Sometimes, however, you may want to \
find a ",
 StyleBox["nonlinear fit",
  FontSlant->"Italic"],
 " that does not just consist of a linear combination of specified functions. \
You can do this using ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 ", which takes a function of any form, and then searches for values of \
parameters that yield the best fit to your data. "
}], "Text",
 CellID->788],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindFit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindFit"], "[", 
     StyleBox["data", "TI"], ",", 
     StyleBox["form", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["par", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["par", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["x", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "search for values of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["par", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " that make ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " best fit ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FindFit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindFit"], "[", 
     StyleBox["data", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     StyleBox["pars", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "fit multivariate data", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23977],

Cell["Searching for general fits to data. ", "Caption",
 CellID->18132],

Cell["\<\
This fits the list of primes to a simple linear combination of terms. \
\>", "MathCaption",
 CellID->29956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindFit", "[", 
  RowBox[{"fp", ",", 
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"Exp", "[", "x", "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->28689],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", 
    RowBox[{"-", "6.789320684083264`"}]}], ",", 
   RowBox[{"b", "\[Rule]", "3.643085217883317`"}], ",", 
   RowBox[{"c", "\[Rule]", "1.2688291461510137`*^-8"}]}], "}"}]], "Output",
 ImageSize->{300, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1954223662]
}, Open  ]],

Cell[TextData[{
 "The result is the same as from ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"fp", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     RowBox[{"Exp", "[", "x", "]"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->12941],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "6.789320684083264`"}], "+", 
  RowBox[{"1.2688291461510137`*^-8", " ", 
   SuperscriptBox["\[ExponentialE]", "x"]}], "+", 
  RowBox[{"3.643085217883317`", " ", "x"}]}]], "Output",
 ImageSize->{246, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1997034516]
}, Open  ]],

Cell[TextData[{
 "This fits to a nonlinear form, which cannot be handled by ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindFit", "[", 
  RowBox[{"fp", ",", 
   RowBox[{"a", " ", "x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->21363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "1.4207557242233555`"}], ",", 
   RowBox[{"b", "\[Rule]", "1.655581377626135`"}], ",", 
   RowBox[{"c", "\[Rule]", "0.5346453120672511`"}]}], "}"}]], "Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->179895895]
}, Open  ]],

Cell[TextData[{
 "By default, both ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " produce ",
 StyleBox["least\[Hyphen]squares",
  FontSlant->"Italic"],
 " fits, which are defined to minimize the quantity ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Chi]", "2"], "=", 
    UnderscriptBox["\[Sum]", "i",
     LimitsPositioning->True], "\[VerticalSeparator]", 
    SubscriptBox["r", "i"], 
    SuperscriptBox["\[VerticalSeparator]", "2"]}], TraditionalForm]], 
  "InlineMath"],
 ", where the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "i"], TraditionalForm]], "InlineMath"],
 " are residuals giving the difference between each original data point and \
its fitted value. One can, however, also consider fits based on other norms. \
If you set the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NormFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormFunction"], "->", 
   StyleBox["u", "TI"]}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " will attempt to find the fit that minimizes the quantity ",
 Cell[BoxData[
  RowBox[{
   StyleBox["u", "TI"], "[", 
   StyleBox["r", "TI"], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " is the list of residuals. The default is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NormFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormFunction"], "->", 
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"]}]], "InlineFormula"],
 ", corresponding to a least\[Hyphen]squares fit."
}], "Text",
 CellID->25184],

Cell[TextData[{
 "This uses the ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 "\[Hyphen]norm, which minimizes the maximum distance between the fit and the \
data. The result is slightly different from least\[Hyphen]squares. "
}], "MathCaption",
 CellID->24778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindFit", "[", 
  RowBox[{"fp", ",", 
   RowBox[{"a", " ", "x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x", ",", 
   RowBox[{"NormFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"#", ",", "Infinity"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->7200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "1.1507695890710887`"}], ",", 
   RowBox[{"b", "\[Rule]", "1.0022987426644`"}], ",", 
   RowBox[{"c", "\[Rule]", "1.0468558066626197`"}]}], "}"}]], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->1236136737]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " works by searching for values of parameters that yield the best fit. \
Sometimes you may have to tell it where to start in doing this search. You \
can do this by giving parameters in the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", 
       SubscriptBox["a", "0"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       SubscriptBox["b", "0"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " also has various options that you can set to control how it does its \
search. "
}], "Text",
 CellID->1885],

Cell[BoxData[GridBox[{
   {
    RowBox[{" ", 
     RowBox[{"FindFit", "[", 
      RowBox[{
       StyleBox["data", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["form", "TI"], ",", 
         StyleBox["cons", "TI"]}], "}"}], ",", 
       StyleBox["pars", "TI"], ",", 
       StyleBox["vars", "TI"]}], "]"}]}], 
    RowBox[{" ", Cell[TextData[{
      "finds a best fit subject to the parameter constraints ",
      Cell[BoxData[
       StyleBox["cons", "TI"]], "InlineFormula"]
     }], "TableText"]}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->305378867],

Cell["Searching for general fits to data. ", "Caption",
 CellID->7913658],

Cell["\<\
This gives a best fit subject to constraints on the parameters.\
\>", "MathCaption",
 CellID->490248505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindFit", "[", 
  RowBox[{"fp", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", "x", " ", 
      RowBox[{"Log", "[", 
       RowBox[{"b", "+", 
        RowBox[{"c", " ", "x"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0", "<=", "a", "<=", "1"}], ",", 
       RowBox[{"0", "<=", "b", "\[LessEqual]", "1"}], ",", 
       RowBox[{"c", "\[GreaterEqual]", "1"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->336942175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.9999999999994137`"}], ",", 
   RowBox[{"b", "\[Rule]", "1.3456916425575542`*^-9"}], ",", 
   RowBox[{"c", "\[Rule]", "1.691449616626619`"}]}], "}"}]], "Output",
 ImageSize->{258, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->960182105]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["NormFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NormFunction"], 
    ButtonBox["Norm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Norm"], Cell["the norm to use", "TableText"]},
   {
    ButtonBox["AccuracyGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AccuracyGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "number of digits of accuracy to try to get", "TableText"]},
   {
    ButtonBox["PrecisionGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrecisionGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "number of digits of precision to try to get", "TableText"]},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "precision to use in internal computations", "TableText"]},
   {
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], "100", Cell[
    "maximum number of iterations to use", "TableText"]},
   {
    ButtonBox["StepMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StepMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate whenever a step is taken", "TableText"]},
   {
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "expression to evaluate whenever ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " is evaluated"
    }], "TableText"]},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["method to use", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21974],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->1071],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->399265702],

Cell[TextData[ButtonBox["Numerical Operations on Data",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnDataOverview"]], "RelatedTutorials",
 CellID->618122]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->354330763],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->120797756],

Cell[TextData[{
 ButtonBox["M215: Applied Statistical Analysis with ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->87210613]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Curve Fitting - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Data", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnDataOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/BasicStatistics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ApproximateFunctionsAndInterpolation"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 51.2965544}", "context" -> "", 
    "keywords" -> {
     "approximate formulas", "approximation of functions", "chi squared", 
      "curves", "FindFit", "Fit", "fits", "fitting of data", 
      "least-squares fits", "linear fits", "models", "nonlinear fitting", 
      "NormFunction", "polynomial fit", "primes", "residuals", 
      "testing models", "trend line"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "There are many situations where one wants to find a formula that best \
fits a given set of data. One way to do this in Mathematica is to use Fit. \
Basic linear fitting. Here is a table of the first 20 primes. ", 
    "synonyms" -> {"3.8.2"}, "title" -> "Curve Fitting", "type" -> "Tutorial",
     "uri" -> "tutorial/CurveFitting"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.8.2"->{
  Cell[1908, 60, 76, 2, 70, "Title",
   CellTags->{"S3.8.2", "2.1"},
   CellID->19037]},
 "2.1"->{
  Cell[1908, 60, 76, 2, 70, "Title",
   CellTags->{"S3.8.2", "2.1"},
   CellID->19037]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.8.2", 42014, 1312},
 {"2.1", 42113, 1316}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1283, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1908, 60, 76, 2, 70, "Title",
 CellTags->{"S3.8.2", "2.1"},
 CellID->19037],
Cell[1987, 64, 347, 12, 70, "Text",
 CellID->6410],
Cell[2337, 78, 1392, 45, 70, "DefinitionBox",
 CellID->31461],
Cell[3732, 125, 56, 1, 70, "Caption",
 CellID->6234],
Cell[3791, 128, 79, 1, 70, "MathCaption",
 CellID->12508],
Cell[CellGroupData[{
Cell[3895, 133, 230, 8, 28, "Input",
 CellID->9961],
Cell[4128, 143, 414, 11, 36, "Output",
 CellID->424150084]
}, Open  ]],
Cell[4557, 157, 122, 3, 70, "MathCaption",
 CellID->6493],
Cell[CellGroupData[{
Cell[4704, 164, 124, 4, 28, "Input",
 CellID->1515],
Cell[4831, 170, 668, 18, 141, "Output",
 CellID->128780232]
}, Open  ]],
Cell[5514, 191, 254, 8, 70, "MathCaption",
 CellID->24937],
Cell[CellGroupData[{
Cell[5793, 203, 178, 6, 70, "Input",
 CellID->28869],
Cell[5974, 211, 258, 8, 36, "Output",
 CellID->1156394647]
}, Open  ]],
Cell[6247, 222, 66, 1, 70, "MathCaption",
 CellID->14700],
Cell[CellGroupData[{
Cell[6338, 227, 179, 6, 28, "Input",
 CellID->13971],
Cell[6520, 235, 2091, 38, 129, "Output",
 Evaluatable->False,
 CellID->165786467]
}, Open  ]],
Cell[8626, 276, 90, 1, 70, "MathCaption",
 CellID->15117],
Cell[CellGroupData[{
Cell[8741, 281, 120, 4, 28, "Input",
 CellID->16215],
Cell[8864, 287, 2441, 44, 129, "Output",
 Evaluatable->False,
 CellID->417872950]
}, Open  ]],
Cell[11320, 334, 78, 1, 70, "MathCaption",
 CellID->7815],
Cell[CellGroupData[{
Cell[11423, 339, 214, 7, 70, "Input",
 CellID->18330],
Cell[11640, 348, 335, 10, 36, "Output",
 CellID->2144133330]
}, Open  ]],
Cell[11990, 361, 76, 1, 70, "MathCaption",
 CellID->30212],
Cell[CellGroupData[{
Cell[12091, 366, 179, 6, 70, "Input",
 CellID->29288],
Cell[12273, 374, 2144, 44, 137, "Output",
 CellID->95859370]
}, Open  ]],
Cell[14432, 421, 151, 4, 70, "MathCaption",
 CellID->1954],
Cell[CellGroupData[{
Cell[14608, 429, 120, 4, 70, "Input",
 CellID->16085],
Cell[14731, 435, 2454, 49, 137, "Output",
 CellID->1159859348]
}, Open  ]],
Cell[17200, 487, 2488, 78, 70, "DefinitionBox",
 CellID->24484],
Cell[19691, 567, 60, 1, 70, "Caption",
 CellID->24774],
Cell[19754, 570, 956, 32, 70, "Text",
 CellID->8380],
Cell[20713, 604, 839, 24, 70, "DefinitionBox",
 CellID->29815],
Cell[21555, 630, 57, 1, 70, "Caption",
 CellID->25951],
Cell[21615, 633, 639, 24, 70, "MathCaption",
 CellID->6541],
Cell[CellGroupData[{
Cell[22279, 661, 498, 16, 70, "Input",
 CellID->18115],
Cell[22780, 679, 910, 26, 54, "Output",
 CellID->1400054371]
}, Open  ]],
Cell[23705, 708, 91, 1, 70, "MathCaption",
 CellID->17110],
Cell[CellGroupData[{
Cell[23821, 713, 273, 9, 70, "Input",
 CellID->25898],
Cell[24097, 724, 375, 9, 36, "Output",
 CellID->744312764]
}, Open  ]],
Cell[24487, 736, 780, 20, 70, "Text",
 CellID->788],
Cell[25270, 758, 1507, 47, 70, "DefinitionBox",
 CellID->23977],
Cell[26780, 807, 71, 1, 70, "Caption",
 CellID->18132],
Cell[26854, 810, 117, 3, 70, "MathCaption",
 CellID->29956],
Cell[CellGroupData[{
Cell[26996, 817, 320, 10, 70, "Input",
 CellID->28689],
Cell[27319, 829, 382, 11, 39, "Output",
 CellID->1954223662]
}, Open  ]],
Cell[27716, 843, 201, 8, 70, "MathCaption",
 CellID->10008],
Cell[CellGroupData[{
Cell[27942, 855, 222, 7, 70, "Input",
 CellID->12941],
Cell[28167, 864, 352, 10, 36, "Output",
 CellID->1997034516]
}, Open  ]],
Cell[28534, 877, 227, 8, 70, "MathCaption",
 CellID->1723],
Cell[CellGroupData[{
Cell[28786, 889, 322, 10, 70, "Input",
 CellID->21363],
Cell[29111, 901, 358, 10, 36, "Output",
 CellID->179895895]
}, Open  ]],
Cell[29484, 914, 1871, 61, 70, "Text",
 CellID->25184],
Cell[31358, 977, 292, 7, 70, "MathCaption",
 CellID->24778],
Cell[CellGroupData[{
Cell[31675, 988, 486, 16, 70, "Input",
 CellID->7200],
Cell[32164, 1006, 357, 10, 36, "Output",
 CellID->1236136737]
}, Open  ]],
Cell[32536, 1019, 863, 27, 70, "Text",
 CellID->1885],
Cell[33402, 1048, 841, 25, 70, "DefinitionBox",
 CellID->305378867],
Cell[34246, 1075, 73, 1, 70, "Caption",
 CellID->7913658],
Cell[34322, 1078, 114, 3, 70, "MathCaption",
 CellID->490248505],
Cell[CellGroupData[{
Cell[34461, 1085, 578, 17, 70, "Input",
 CellID->336942175],
Cell[35042, 1104, 362, 10, 39, "Output",
 CellID->960182105]
}, Open  ]],
Cell[35419, 1117, 2571, 76, 70, "DefinitionBox3Col",
 CellID->21974],
Cell[37993, 1195, 184, 8, 70, "Caption",
 CellID->1071],
Cell[CellGroupData[{
Cell[38202, 1207, 72, 1, 70, "RelatedTutorialsSection",
 CellID->399265702],
Cell[38277, 1210, 183, 4, 70, "RelatedTutorials",
 CellID->618122]
}, Open  ]],
Cell[CellGroupData[{
Cell[38497, 1219, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->354330763],
Cell[38598, 1222, 414, 13, 70, "TutorialRelatedLinks",
 CellID->120797756],
Cell[39015, 1237, 429, 13, 70, "TutorialRelatedLinks",
 CellID->87210613]
}, Open  ]]
}, Open  ]],
Cell[39471, 1254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

