(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    133381,       3036]
NotebookOptionsPosition[    120771,       2599]
NotebookOutlinePosition[    128460,       2840]
CellTagsIndexPosition[    128300,       2832]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Classification of Differential Equations", "Title",
 CellTags->{"classification", "c:3", "b:0.1"},
 CellID->19497],

Cell[TextData[{
 "While differential equations have three basic types\[LongDash]ordinary \
(ODEs), partial (PDEs), or differential-algebraic (DAEs), they can be further \
described by attributes such as order, linearity, and degree. The solution \
method used by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " and the nature of the solutions depend heavily on the class of equation \
being solved."
}], "Text",
 CellTags->"b:0.1",
 CellID->2589],

Cell[TextData[{
 "The ",
 StyleBox["order",
  FontSlant->"Italic"],
 " of a differential equation is the order of the highest derivative in the \
equation. "
}], "Text",
 CellTags->"b:0.1",
 CellID->25990],

Cell["\<\
This is a first-order ODE because its highest derivative is of order 1.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->15145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", 
       RowBox[{"3", 
        RowBox[{"x", "^", "3"}]}], "-", 
       RowBox[{"y", "[", "x", "]"}]}], ")"}], 
     RowBox[{"y", "[", "x", "]"}]}]}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[1]:=",
 CellID->19353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "x"}], "+", 
      SuperscriptBox["x", "3"]}], 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "-", 
      RowBox[{"Log", "[", "x", "]"}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{163, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[1]=",
 CellID->32448870]
}, Open  ]],

Cell["Here is the general solution to a fourth-order ODE.", "MathCaption",
 CellTags->"b:0.1",
 CellID->18651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''''"}], "[", "x", "]"}], "-", 
     RowBox[{"16", "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", " ", 
    RowBox[{"x", "^", "2"}]}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[2]:=",
 CellID->26740],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["x", "2"], "16"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "x"}]], " ", 
      RowBox[{"C", "[", "3", "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "4", "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{425, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[2]=",
 CellID->172541628]
}, Open  ]],

Cell[TextData[{
 "A differential equation is linear if the equation is of the first degree in \
",
 StyleBox["y",
  FontSlant->"Italic"],
 " and its derivatives, and if the coefficients are functions of the \
independent variable."
}], "Text",
 CellTags->"b:0.1",
 CellID->11258],

Cell[TextData[{
 "This is a ",
 StyleBox["nonlinear",
  FontSlant->"Italic"],
 " second-order ODE that represents the motion of a circular pendulum. It is \
nonlinear because ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", 
   RowBox[{
    StyleBox["y", "TI"], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 " is not a linear function of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". The ",
 StyleBox["Solve::ifun", "InlineCode"],
 " warning message appears because ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 " (the inverse of ",
 Cell[BoxData[
  ButtonBox["EllipticF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticF"]], "InlineFormula"],
 ") to find an expression for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
      RowBox[{"3", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"y", "[", "x", "]"}], "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
    "y", ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[3]:=",
 CellID->8759],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:0.1",
 CellLabel->"During evaluation of In[3]:=",
 CellID->56156575],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"JacobiAmplitude", "[", 
         RowBox[{
          RowBox[{
           FractionBox["1", "2"], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"6", "+", 
               RowBox[{"C", "[", "1", "]"}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"x", "+", 
                RowBox[{"C", "[", "2", "]"}]}], ")"}], "2"]}]]}], ",", 
          FractionBox["12", 
           RowBox[{"6", "+", 
            RowBox[{"C", "[", "1", "]"}]}]]}], "]"}]}]}], "]"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"2", " ", 
        RowBox[{"JacobiAmplitude", "[", 
         RowBox[{
          RowBox[{
           FractionBox["1", "2"], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"6", "+", 
               RowBox[{"C", "[", "1", "]"}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"x", "+", 
                RowBox[{"C", "[", "2", "]"}]}], ")"}], "2"]}]]}], ",", 
          FractionBox["12", 
           RowBox[{"6", "+", 
            RowBox[{"C", "[", "1", "]"}]}]]}], "]"}]}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{522, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[3]=",
 CellID->2102549]
}, Open  ]],

Cell[TextData[{
 "This plots the solutions. The discontinuity in the graphs at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"-", "3"}]}], TraditionalForm]], "InlineMath"],
 " results from the choice of inverse functions used by ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->25264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", 
         RowBox[{"-", "1"}]}], ",", " ", 
        RowBox[{
         RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", "3"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", 
         RowBox[{"-", "1"}]}], ",", " ", 
        RowBox[{
         RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", "3"}]}], "}"}]}]}], 
    "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[4]:=",
 CellID->12181],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[4]=",
 CellID->201438890]
}, Open  ]],

Cell[TextData[{
 "It should be noted that sometimes the solutions to fairly simple nonlinear \
equations are only available in implicit form. In these cases, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 StyleBox[" returns ", "TR"],
 "an unevaluated ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " object. "
}], "Text",
 CellTags->"b:0.1",
 CellID->3829],

Cell[TextData[{
 "This nonlinear differential equation only has an implicit solution. The ",
 StyleBox["Solve::tdep", "InlineCode"],
 " messages can be ignored; they appear because ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " cannot find an explicit expression for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " because non-algebraic functions (",
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ") are involved."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->23775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "+", "x", "-", "1"}], ")"}], "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "-", 
     RowBox[{"y", "[", "x", "]"}], "+", 
     RowBox[{"2", "x"}], "+", "3"}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[5]:=",
 CellID->20608],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:0.1",
 CellLabel->"During evaluation of In[5]:=",
 CellID->21680554],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:0.1",
 CellLabel->"During evaluation of In[5]:=",
 CellID->72491161],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["2", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SqrtBox["2"], " ", 
        RowBox[{"ArcTan", "[", 
         FractionBox[
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", "x"}]}], ")"}]}], 
            RowBox[{
             RowBox[{"-", "1"}], "+", "x", "+", 
             RowBox[{"y", "[", "x", "]"}]}]]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"]}]], "]"}]}], "-", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "x", "+", 
             RowBox[{"y", "[", "x", "]"}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{"3", " ", "x"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                FractionBox[
                 RowBox[{"2", "+", 
                  RowBox[{"3", " ", "x"}]}], 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x", "+", 
                  RowBox[{"y", "[", "x", "]"}]}]]}], ")"}]}], 
             RowBox[{
              RowBox[{"-", "1"}], "+", "x", "+", 
              RowBox[{"y", "[", "x", "]"}]}]]}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"3", " ", "x"}]}], ")"}], "2"]], "]"}]}], ")"}]}], 
    "\[Equal]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "+", 
     RowBox[{
      FractionBox["4", "3"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"2", "+", 
        RowBox[{"3", " ", "x"}]}], "]"}]}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{545, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[5]=",
 CellID->485237069]
}, Open  ]],

Cell[TextData[{
 "When the coefficients of a linear ODE do not depend on ",
 StyleBox["x",
  FontSlant->"Italic"],
 ", the ODE is said to have ",
 StyleBox["constant coefficients.",
  FontSlant->"Italic"]
}], "Text",
 CellTags->"b:0.1",
 CellID->29556],

Cell["This is an ODE with constant coefficients.", "MathCaption",
 CellTags->"b:0.1",
 CellID->25561],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'''"}], "[", "x", "]"}], " ", "+", " ", 
    RowBox[{"3", "*", 
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}]}], "-", 
    RowBox[{"25", "*", 
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
    RowBox[{"21", "*", 
     RowBox[{"y", "[", "x", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"eqn", "\[Equal]", "0"}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]}], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[6]:=",
 CellID->31627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "7"}], " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      RowBox[{"C", "[", "2", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]], " ", 
      RowBox[{"C", "[", "3", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{251, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[7]=",
 CellID->46756982]
}, Open  ]],

Cell[TextData[{
 "The previous equation is also ",
 StyleBox["homogeneous",
  FontSlant->"Italic"],
 ": all terms contain ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " or derivatives of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and its right-hand side is zero. Adding a function of the independent \
variable makes the equation ",
 StyleBox["inhomogeneous",
  FontSlant->"Italic"],
 ". The general solution to an inhomogeneous equation with constant \
coefficients is obtained by adding a particular integral to the solution to \
the corresponding homogeneous equation. "
}], "Text",
 CellTags->"b:0.1",
 CellID->29541],

Cell[TextData[{
 "Here, ",
 Cell[BoxData[
  SuperscriptBox["x", "2"]]],
 " is added to the right-hand side of the previous equation, making the new \
equation inhomogeneous. The general solution to this new equation is the \
sum",
 " ",
 "of the previous solution and a particular integral."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->26129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"eqn", "\[Equal]", " ", 
     RowBox[{"x", "^", "2"}]}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[8]:=",
 CellID->31240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{"1124", "+", 
       RowBox[{"1050", " ", "x"}], "+", 
       RowBox[{"441", " ", 
        SuperscriptBox["x", "2"]}]}], "9261"], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "7"}], " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      RowBox[{"C", "[", "2", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]], " ", 
      RowBox[{"C", "[", "3", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{396, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[8]=",
 CellID->390844007]
}, Open  ]],

Cell[TextData[{
 "When the coefficients of an ODE depend on ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", the ODE is said to have ",
 StyleBox["variable coefficients",
  FontSlant->"Italic"],
 ". Since equations with variable coefficients that are ",
 StyleBox["rational functions",
  FontSlant->"Italic"],
 " ",
 StyleBox["of ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " have singularities that are easily classified, there are sophisticated \
algorithms available for solving them."
}], "Text",
 CellTags->"b:0.1",
 CellID->29174],

Cell[TextData[{
 "The coefficients of this equation are rational functions of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->20601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "/", "x"}], ")"}], "-", 
           RowBox[{"(", 
            RowBox[{"3", "/", 
             RowBox[{"(", 
              RowBox[{"16", 
               RowBox[{"x", "^", "2"}]}], ")"}]}], ")"}]}], ")"}], "*", 
         RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "1", "]"}], "\[Equal]", "1"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "1", "]"}], "\[Equal]", "4"}]}], "}"}], ",", 
    
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[9]:=",
 CellID->6077],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "8"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], "-", 
       RowBox[{"2", " ", 
        SqrtBox["x"]}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "11"}], " ", 
        SuperscriptBox["\[ExponentialE]", "4"]}], "+", 
       RowBox[{"19", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"4", " ", 
          SqrtBox["x"]}]]}]}], ")"}], " ", 
     SuperscriptBox["x", 
      RowBox[{"1", "/", "4"}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{285, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[9]=",
 CellID->141135969]
}, Open  ]],

Cell[TextData[{
 "There is a close relationship between functions and differential equations. \
Starting with a function of almost any type, it is possible to construct a \
differential equation satisfied by that function. Conversely, any \
differential equation gives rise to one or more functions, in the form of \
solutions to that equation. In fact, many ",
 StyleBox["special functions ",
  FontSlant->"Italic"],
 StyleBox["from classical analysis have their origins in the solution of",
  FontVariations->{"CompatibilityType"->0}],
 " ",
 StyleBox["differential equations. ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathieu functions",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" are one such class of special functions. ",
  FontVariations->{"CompatibilityType"->0}],
 "Mathieu was interested in studying the vibrations of elliptical membranes. \
The eigenfunctions for the wave equation that describes this motion are \
given",
 " ",
 "by products of Mathieu functions."
}], "Text",
 CellTags->"b:0.1",
 CellID->8683],

Cell["\<\
This linear second-order ODE with rational coefficients has a general \
solution given by Mathieu functions.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->8213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"t", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"t", "+", "1"}], ")"}], "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "t", "]"}]}], "+", 
     RowBox[{"t", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        RowBox[{"6", "*", 
         RowBox[{"t", "^", "2"}]}]}], ")"}], "*", 
      RowBox[{"y", "[", "t", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[10]:=",
 CellID->23992],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"MathieuC", "[", 
       RowBox[{"5", ",", 
        RowBox[{"-", 
         FractionBox["3", "2"]}], ",", 
        RowBox[{"ArcCos", "[", "t", "]"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"MathieuS", "[", 
       RowBox[{"5", ",", 
        RowBox[{"-", 
         FractionBox["3", "2"]}], ",", 
        RowBox[{"ArcCos", "[", "t", "]"}]}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{513, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[10]=",
 CellID->257031284]
}, Open  ]],

Cell[TextData[{
 "The presence of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcCos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCos"], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 " in the previous solution suggests that the equation can be given a simpler \
form using trigonometric functions. This is the form in which these equations \
were introduced by Mathieu in 1868. "
}], "MathCaption",
 CellTags->{"MathieuODE", "b:0.1"},
 CellID->5601],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"2", "x"}], "]"}]}], " ", "+", " ", "5"}], ")"}], 
        RowBox[{"y", "[", "x", "]"}]}]}], " ", "==", " ", "0"}], ",", " ", 
     "y", ",", " ", "x"}], "]"}], " "}],
  FormatType->StandardForm]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[11]:=",
 CellID->23392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"MathieuC", "[", 
         RowBox[{"5", ",", 
          RowBox[{"-", 
           FractionBox["3", "2"]}], ",", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"MathieuS", "[", 
         RowBox[{"5", ",", 
          RowBox[{"-", 
           FractionBox["3", "2"]}], ",", "x"}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{483, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[11]=",
 CellID->459947705]
}, Open  ]],

Cell["\<\
This plots the surface for a particular product of solutions to this \
equation.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->2670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MathieuC", "[", 
     RowBox[{"5", ",", 
      RowBox[{"-", 
       FractionBox["3", "2"]}], ",", "x"}], "]"}], "*", " ", 
    RowBox[{"MathieuS", "[", 
     RowBox[{"5", ",", 
      RowBox[{"-", 
       FractionBox["3", "2"]}], ",", "y"}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[12]:=",
 CellID->26428],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 231},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[12]=",
 CellID->102530603]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["degree",
  FontSlant->"Italic"],
 " of a differential equation is the highest power of the highest-order",
 " ",
 "derivative in the equation. "
}], "Text",
 CellTags->"b:0.1",
 CellID->4084],

Cell["This is a first-order ODE of degree 2.", "MathCaption",
 CellTags->"b:0.1",
 CellID->10075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}], "\[Equal]", 
       RowBox[{"1", "-", 
        RowBox[{"x", "^", "2"}]}]}], ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "2"}]}], "}"}], ",", " ", 
    "y", ",", " ", "x"}], "]"}]}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[13]:=",
 CellID->18786],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "-", 
          RowBox[{"x", " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}]]}], "-", 
          RowBox[{"ArcSin", "[", "x", "]"}]}], ")"}]}]}], "]"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"x", " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}]]}], "+", 
          RowBox[{"ArcSin", "[", "x", "]"}]}], ")"}]}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{342, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[13]=",
 CellID->371756704]
}, Open  ]],

Cell["The higher degree leads to non-uniqueness of the solution.", \
"MathCaption",
 CellTags->"b:0.1",
 CellID->24970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", 
      RowBox[{"sol", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", 
      RowBox[{"sol", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[14]:=",
 CellID->6287],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[14]=",
 CellID->106879693]
}, Open  ]],

Cell[TextData[{
 "The examples in this tutorial have been focused on the classification of \
ODEs. The classification of PDEs is similar but more involved. PDEs can also \
be classified by linearity or nonlinearity, order, degree, and constant or \
variable coefficients. More important is the classification that identifies \
a",
 " ",
 "PDE as hyperbolic, parabolic, or elliptic. These classifications are \
discussed in further detail in \"",
 ButtonBox["Second-Order PDEs\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveSecondOrderPDEs"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->32604],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->364365244],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Classification of Differential Equations - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveIntroduction"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveIntroductionToODEs"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 16.6878294}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "While differential equations have three basic types--ordinary (ODEs), \
partial (PDEs), or differential-algebraic (DAEs), they can be further \
described by attributes such as order, linearity, and degree. The solution \
method used by DSolve and the nature of the solutions depend heavily on the \
class of equation being solved. The order of a differential equation is the \
order of the highest derivative in the equation. This is a first-order ODE \
because its highest derivative is of order 1.", "synonyms" -> {}, "title" -> 
    "Classification of Differential Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveClassificationOfDifferentialEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "classification"->{
  Cell[1280, 43, 120, 2, 70, "Title",
   CellTags->{"classification", "c:3", "b:0.1"},
   CellID->19497]},
 "c:3"->{
  Cell[1280, 43, 120, 2, 70, "Title",
   CellTags->{"classification", "c:3", "b:0.1"},
   CellID->19497]},
 "b:0.1"->{
  Cell[1280, 43, 120, 2, 70, "Title",
   CellTags->{"classification", "c:3", "b:0.1"},
   CellID->19497],
  Cell[1403, 47, 519, 13, 70, "Text",
   CellTags->"b:0.1",
   CellID->2589],
  Cell[1925, 62, 205, 8, 70, "Text",
   CellTags->"b:0.1",
   CellID->25990],
  Cell[2133, 72, 138, 4, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->15145],
  Cell[2296, 80, 610, 21, 28, "Input",
   CellTags->"b:0.1",
   CellID->19353],
  Cell[2909, 103, 474, 17, 56, "Output",
   CellTags->"b:0.1",
   CellID->32448870],
  Cell[3398, 123, 110, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->18651],
  Cell[3533, 129, 386, 13, 28, "Input",
   CellTags->"b:0.1",
   CellID->26740],
  Cell[3922, 144, 935, 31, 54, "Output",
   CellTags->"b:0.1",
   CellID->172541628],
  Cell[4872, 178, 279, 9, 70, "Text",
   CellTags->"b:0.1",
   CellID->11258],
  Cell[5154, 189, 1214, 44, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->335],
  Cell[6393, 237, 396, 14, 70, "Input",
   CellTags->"b:0.1",
   CellID->8759],
  Cell[6792, 253, 516, 10, 70, "Message",
   CellTags->"b:0.1",
   CellID->56156575],
  Cell[7311, 265, 1707, 55, 87, "Output",
   CellTags->"b:0.1",
   CellID->2102549],
  Cell[9033, 323, 421, 14, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->25264],
  Cell[9479, 341, 1063, 36, 47, "Input",
   CellTags->"b:0.1",
   CellID->12181],
  Cell[10545, 379, 7577, 129, 161, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->201438890],
  Cell[18137, 511, 498, 16, 70, "Text",
   CellTags->"b:0.1",
   CellID->3829],
  Cell[18638, 529, 794, 26, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->23775],
  Cell[19457, 559, 498, 16, 70, "Input",
   CellTags->"b:0.1",
   CellID->20608],
  Cell[19958, 577, 482, 10, 70, "Message",
   CellTags->"b:0.1",
   CellID->21680554],
  Cell[20443, 589, 482, 10, 70, "Message",
   CellTags->"b:0.1",
   CellID->72491161],
  Cell[20928, 601, 2186, 69, 142, "Output",
   CellTags->"b:0.1",
   CellID->485237069],
  Cell[23129, 673, 252, 9, 70, "Text",
   CellTags->"b:0.1",
   CellID->29556],
  Cell[23384, 684, 101, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->25561],
  Cell[23510, 690, 623, 21, 70, "Input",
   CellTags->"b:0.1",
   CellID->31627],
  Cell[24136, 713, 698, 23, 39, "Output",
   CellTags->"b:0.1",
   CellID->46756982],
  Cell[24849, 739, 671, 19, 70, "Text",
   CellTags->"b:0.1",
   CellID->29541],
  Cell[25523, 760, 346, 11, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->26129],
  Cell[25894, 775, 278, 9, 70, "Input",
   CellTags->"b:0.1",
   CellID->31240],
  Cell[26175, 786, 867, 28, 54, "Output",
   CellTags->"b:0.1",
   CellID->390844007],
  Cell[27057, 817, 606, 19, 70, "Text",
   CellTags->"b:0.1",
   CellID->29174],
  Cell[27666, 838, 205, 7, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->20601],
  Cell[27896, 849, 918, 30, 70, "Input",
   CellTags->"b:0.1",
   CellID->6077],
  Cell[28817, 881, 817, 28, 52, "Output",
   CellTags->"b:0.1",
   CellID->141135969],
  Cell[29649, 912, 1077, 25, 70, "Text",
   CellTags->"b:0.1",
   CellID->8683],
  Cell[30729, 939, 174, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->8213],
  Cell[30928, 948, 726, 25, 70, "Input",
   CellTags->"b:0.1",
   CellID->23992],
  Cell[31657, 975, 765, 26, 51, "Output",
   CellTags->"b:0.1",
   CellID->257031284],
  Cell[32437, 1004, 470, 13, 70, "MathCaption",
   CellTags->{"MathieuODE", "b:0.1"},
   CellID->5601],
  Cell[32932, 1021, 586, 20, 70, "Input",
   CellTags->"b:0.1",
   CellID->23392],
  Cell[33521, 1043, 773, 26, 51, "Output",
   CellTags->"b:0.1",
   CellID->459947705],
  Cell[34309, 1072, 146, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->2670],
  Cell[34480, 1081, 593, 20, 42, "Input",
   CellTags->"b:0.1",
   CellID->26428],
  Cell[35076, 1103, 78956, 1299, 252, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->102530603],
  Cell[114047, 2405, 227, 9, 70, "Text",
   CellTags->"b:0.1",
   CellID->4084],
  Cell[114277, 2416, 97, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->10075],
  Cell[114399, 2422, 494, 17, 70, "Input",
   CellTags->"b:0.1",
   CellID->18786],
  Cell[114896, 2441, 1098, 38, 84, "Output",
   CellTags->"b:0.1",
   CellID->371756704],
  Cell[116009, 2482, 119, 3, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->24970],
  Cell[116153, 2489, 494, 17, 28, "Input",
   CellTags->"b:0.1",
   CellID->6287],
  Cell[116650, 2508, 3166, 57, 165, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->106879693],
  Cell[119831, 2568, 609, 15, 70, "Text",
   CellTags->"b:0.1",
   CellID->32604]},
 "MathieuODE"->{
  Cell[32437, 1004, 470, 13, 70, "MathCaption",
   CellTags->{"MathieuODE", "b:0.1"},
   CellID->5601]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"classification", 123325, 2654},
 {"c:3", 123442, 2658},
 {"b:0.1", 123561, 2662},
 {"MathieuODE", 128172, 2825}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 120, 2, 70, "Title",
 CellTags->{"classification", "c:3", "b:0.1"},
 CellID->19497],
Cell[1403, 47, 519, 13, 70, "Text",
 CellTags->"b:0.1",
 CellID->2589],
Cell[1925, 62, 205, 8, 70, "Text",
 CellTags->"b:0.1",
 CellID->25990],
Cell[2133, 72, 138, 4, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->15145],
Cell[CellGroupData[{
Cell[2296, 80, 610, 21, 28, "Input",
 CellTags->"b:0.1",
 CellID->19353],
Cell[2909, 103, 474, 17, 56, "Output",
 CellTags->"b:0.1",
 CellID->32448870]
}, Open  ]],
Cell[3398, 123, 110, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->18651],
Cell[CellGroupData[{
Cell[3533, 129, 386, 13, 28, "Input",
 CellTags->"b:0.1",
 CellID->26740],
Cell[3922, 144, 935, 31, 54, "Output",
 CellTags->"b:0.1",
 CellID->172541628]
}, Open  ]],
Cell[4872, 178, 279, 9, 70, "Text",
 CellTags->"b:0.1",
 CellID->11258],
Cell[5154, 189, 1214, 44, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->335],
Cell[CellGroupData[{
Cell[6393, 237, 396, 14, 70, "Input",
 CellTags->"b:0.1",
 CellID->8759],
Cell[6792, 253, 516, 10, 70, "Message",
 CellTags->"b:0.1",
 CellID->56156575],
Cell[7311, 265, 1707, 55, 87, "Output",
 CellTags->"b:0.1",
 CellID->2102549]
}, Open  ]],
Cell[9033, 323, 421, 14, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->25264],
Cell[CellGroupData[{
Cell[9479, 341, 1063, 36, 47, "Input",
 CellTags->"b:0.1",
 CellID->12181],
Cell[10545, 379, 7577, 129, 161, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->201438890]
}, Open  ]],
Cell[18137, 511, 498, 16, 70, "Text",
 CellTags->"b:0.1",
 CellID->3829],
Cell[18638, 529, 794, 26, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->23775],
Cell[CellGroupData[{
Cell[19457, 559, 498, 16, 70, "Input",
 CellTags->"b:0.1",
 CellID->20608],
Cell[19958, 577, 482, 10, 70, "Message",
 CellTags->"b:0.1",
 CellID->21680554],
Cell[20443, 589, 482, 10, 70, "Message",
 CellTags->"b:0.1",
 CellID->72491161],
Cell[20928, 601, 2186, 69, 142, "Output",
 CellTags->"b:0.1",
 CellID->485237069]
}, Open  ]],
Cell[23129, 673, 252, 9, 70, "Text",
 CellTags->"b:0.1",
 CellID->29556],
Cell[23384, 684, 101, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->25561],
Cell[CellGroupData[{
Cell[23510, 690, 623, 21, 70, "Input",
 CellTags->"b:0.1",
 CellID->31627],
Cell[24136, 713, 698, 23, 39, "Output",
 CellTags->"b:0.1",
 CellID->46756982]
}, Open  ]],
Cell[24849, 739, 671, 19, 70, "Text",
 CellTags->"b:0.1",
 CellID->29541],
Cell[25523, 760, 346, 11, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->26129],
Cell[CellGroupData[{
Cell[25894, 775, 278, 9, 70, "Input",
 CellTags->"b:0.1",
 CellID->31240],
Cell[26175, 786, 867, 28, 54, "Output",
 CellTags->"b:0.1",
 CellID->390844007]
}, Open  ]],
Cell[27057, 817, 606, 19, 70, "Text",
 CellTags->"b:0.1",
 CellID->29174],
Cell[27666, 838, 205, 7, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->20601],
Cell[CellGroupData[{
Cell[27896, 849, 918, 30, 70, "Input",
 CellTags->"b:0.1",
 CellID->6077],
Cell[28817, 881, 817, 28, 52, "Output",
 CellTags->"b:0.1",
 CellID->141135969]
}, Open  ]],
Cell[29649, 912, 1077, 25, 70, "Text",
 CellTags->"b:0.1",
 CellID->8683],
Cell[30729, 939, 174, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->8213],
Cell[CellGroupData[{
Cell[30928, 948, 726, 25, 70, "Input",
 CellTags->"b:0.1",
 CellID->23992],
Cell[31657, 975, 765, 26, 51, "Output",
 CellTags->"b:0.1",
 CellID->257031284]
}, Open  ]],
Cell[32437, 1004, 470, 13, 70, "MathCaption",
 CellTags->{"MathieuODE", "b:0.1"},
 CellID->5601],
Cell[CellGroupData[{
Cell[32932, 1021, 586, 20, 70, "Input",
 CellTags->"b:0.1",
 CellID->23392],
Cell[33521, 1043, 773, 26, 51, "Output",
 CellTags->"b:0.1",
 CellID->459947705]
}, Open  ]],
Cell[34309, 1072, 146, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->2670],
Cell[CellGroupData[{
Cell[34480, 1081, 593, 20, 42, "Input",
 CellTags->"b:0.1",
 CellID->26428],
Cell[35076, 1103, 78956, 1299, 252, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->102530603]
}, Open  ]],
Cell[114047, 2405, 227, 9, 70, "Text",
 CellTags->"b:0.1",
 CellID->4084],
Cell[114277, 2416, 97, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->10075],
Cell[CellGroupData[{
Cell[114399, 2422, 494, 17, 70, "Input",
 CellTags->"b:0.1",
 CellID->18786],
Cell[114896, 2441, 1098, 38, 84, "Output",
 CellTags->"b:0.1",
 CellID->371756704]
}, Open  ]],
Cell[116009, 2482, 119, 3, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->24970],
Cell[CellGroupData[{
Cell[116153, 2489, 494, 17, 28, "Input",
 CellTags->"b:0.1",
 CellID->6287],
Cell[116650, 2508, 3166, 57, 165, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->106879693]
}, Open  ]],
Cell[119831, 2568, 609, 15, 70, "Text",
 CellTags->"b:0.1",
 CellID->32604],
Cell[CellGroupData[{
Cell[120465, 2587, 72, 1, 70, "RelatedTutorialsSection",
 CellID->364365244],
Cell[120540, 2590, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[120744, 2597, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

