(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44094,       1358]
NotebookOptionsPosition[     34482,       1036]
NotebookOutlinePosition[     40475,       1218]
CellTagsIndexPosition[     40378,       1212]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Further Examples of Exactly Solvable Higher-Order Equations ", "Title",
 CellTags->{"c:31", "b:1.1.3.4"},
 CellID->25629],

Cell[TextData[{
 "The solutions to many second-order ODEs can be expressed in terms of \
special functions. Solutions to certain higher-order ODEs can also be \
expressed using ",
 Cell[BoxData[
  ButtonBox["AiryAi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAi"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 ", and other special functions."
}], "Text",
 CellTags->"b:1.1.3.4",
 CellID->11224],

Cell["\<\
The solution to this third-order ODE is given by products of Airy functions.\
\>", "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->15748],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"sol1", "=", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'''"}], "[", "x", "]"}], " ", "-", 
       RowBox[{"4", "*", 
        RowBox[{"(", 
         RowBox[{"x", " ", "+", " ", "2"}], ")"}], "*", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}], " ", "-", " ", 
       RowBox[{"2", "*", 
        RowBox[{"y", "[", "x", "]"}]}]}], " ", "==", " ", "0"}], ",", " ", 
     "y", ",", " ", "x"}], "]"}], " "}],
  WindowSize->{979, 689},
  WindowMargins->{{Automatic, -69}, {Automatic, -57}},
  PrintingCopies->1,
  PrintingPageRange->{Automatic, Automatic}]], "Input",
 CellTags->"b:1.1.3.4",
 CellLabel->"In[1]:=",
 CellID->19923],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"AiryAi", "[", 
          RowBox[{"2", "+", "x"}], "]"}], "2"], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        RowBox[{"AiryAi", "[", 
         RowBox[{"2", "+", "x"}], "]"}], " ", 
        RowBox[{"AiryBi", "[", 
         RowBox[{"2", "+", "x"}], "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"AiryBi", "[", 
          RowBox[{"2", "+", "x"}], "]"}], "2"], " ", 
        RowBox[{"C", "[", "3", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{516, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.4",
 CellLabel->"Out[1]=",
 CellID->354359598]
}, Open  ]],

Cell["\<\
The solution to this third-order ODE is given by Bessel functions.\
\>", "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->32257],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"sol2", "=", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "3"}], "*", 
        RowBox[{
         RowBox[{"y", "'''"}], "[", "x", "]"}]}], "+", " ", 
       RowBox[{"3", "*", 
        RowBox[{"x", "^", "2"}], "*", 
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", 
           RowBox[{"x", "^", "3"}]}], "-", 
          RowBox[{"11", "x"}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
       RowBox[{"4", 
        RowBox[{"x", "^", "2"}], "*", 
        RowBox[{"y", "[", "x", "]"}]}]}], " ", "==", " ", "0"}], ",", " ", 
     "y", ",", " ", "x"}], "]"}], " "}],
  WindowSize->{979, 689},
  WindowMargins->{{Automatic, -47}, {Automatic, -62}},
  PrintingCopies->1,
  PrintingPageRange->{Automatic, Automatic}]], "Input",
 CellTags->"b:1.1.3.4",
 CellLabel->"In[2]:=",
 CellID->24766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"BesselJ", "[", 
          RowBox[{
           SqrtBox["3"], ",", "x"}], "]"}], "2"], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        RowBox[{"BesselJ", "[", 
         RowBox[{
          SqrtBox["3"], ",", "x"}], "]"}], " ", 
        RowBox[{"BesselY", "[", 
         RowBox[{
          SqrtBox["3"], ",", "x"}], "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"BesselY", "[", 
          RowBox[{
           SqrtBox["3"], ",", "x"}], "]"}], "2"], " ", 
        RowBox[{"C", "[", "3", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{459, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.4",
 CellLabel->"Out[2]=",
 CellID->18235835]
}, Open  ]],

Cell["\<\
This plot shows the oscillatory behavior of the solutions on different parts \
of the real line.\
\>", "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->14955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "[", "x", "]"}], "/.", "sol1"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"C", "[", "1", "]"}], "\[Rule]", "2"}], ",", 
          RowBox[{
           RowBox[{"C", "[", "2", "]"}], "\[Rule]", "3"}], ",", 
          RowBox[{
           RowBox[{"C", "[", "3", "]"}], "\[Rule]", "1"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}], ",", 
         RowBox[{"-", "4"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", "Red", "}"}]}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "[", "x", "]"}], "/.", "\[InvisibleSpace]", "sol2"}], "/.",
         "\[InvisibleSpace]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"C", "[", "1", "]"}], "\[Rule]", "2"}], ",", 
          RowBox[{
           RowBox[{"C", "[", "2", "]"}], "\[Rule]", "3"}], ",", 
          RowBox[{
           RowBox[{"C", "[", "3", "]"}], "\[Rule]", "1"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2", ",", "10"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dashing", "[", 
           RowBox[{"{", "0.02", "}"}], "]"}], ",", "Blue"}], "}"}]}]}], 
      "]"}]}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "Automatic"}], 
     "}"}]}]}], "]"}]], "Input",
 CellTags->"b:1.1.3.4",
 CellLabel->"In[3]:=",
 CellID->23318],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.4",
 CellLabel->"Out[3]=",
 CellID->129569218]
}, Open  ]],

Cell[TextData[{
 "The solution to this fourth-order linear ODE is expressed in terms of ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->25411],

Cell[BoxData[
 RowBox[{
  RowBox[{"HypergeometricPFQTypeEquation", "=", 
   RowBox[{
    RowBox[{"30", "*", 
     RowBox[{"x", "^", "3"}], "*", 
     RowBox[{
      RowBox[{"y", "''''"}], "[", "x", "]"}]}], "+", 
    RowBox[{"193", "*", 
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{
      RowBox[{"y", "'''"}], "[", "x", "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"219", "*", "x"}], "-", 
       RowBox[{"30", 
        RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"21", "-", 
       RowBox[{"90", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}]}], "-", 
    RowBox[{"30", 
     RowBox[{"y", "[", "x", "]"}]}]}]}], ";"}]], "Input",
 CellTags->"b:1.1.3.4",
 CellLabel->"In[4]:=",
 CellID->21025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol3", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"HypergeometricPFQTypeEquation", "\[Equal]", "0"}], ",", " ", "y",
     ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.3.4",
 CellLabel->"In[5]:=",
 CellID->20355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"2", "/", "3"}]], " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"HypergeometricPFQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"-", 
             FractionBox["1", "3"]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", 
              FractionBox["5", "6"]}], ",", 
             RowBox[{"-", 
              FractionBox["11", "15"]}]}], "}"}], ",", "x"}], "]"}]}], 
        SuperscriptBox["x", 
         RowBox[{"4", "/", "3"}]]], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"2", "/", "5"}]], " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "/", "5"}]], " ", 
        RowBox[{"C", "[", "3", "]"}], " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           FractionBox["7", "5"], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            FractionBox["9", "10"], ",", 
            FractionBox["41", "15"]}], "}"}], ",", "x"}], "]"}]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["x"], " ", 
        RowBox[{"C", "[", "4", "]"}], " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           FractionBox["3", "2"], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            FractionBox["11", "10"], ",", 
            FractionBox["17", "6"]}], "}"}], ",", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            FractionBox["1", "2"], ",", 
            FractionBox["3", "5"], ",", 
            FractionBox["7", "3"]}], "}"}], ",", "x"}], "]"}]}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{488, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.4",
 CellLabel->"Out[5]=",
 CellID->133628982]
}, Open  ]],

Cell["\<\
This verifies that the solution is correct using numerical values.\
\>", "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->22549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HypergeometricPFQTypeEquation", "/.", 
     RowBox[{"sol3", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", " ", 
      RowBox[{"RandomComplex", "[", "]"}]}], "}"}]}], "//", "Simplify"}], "//",
   "Chop"}]], "Input",
 CellTags->"b:1.1.3.4",
 CellLabel->"In[6]:=",
 CellID->9496],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.4",
 CellLabel->"Out[6]=",
 CellID->517561600]
}, Open  ]],

Cell["\<\
As for second-order linear ODEs, there are modern algorithms for solving \
higher-order ODEs with rational coefficients. These algorithms give \
\[OpenCurlyDoubleQuote]rational-exponential\[CloseCurlyDoubleQuote] \
solutions, which are combinations of rational functions and exponentials of \
the integrals of rational functions. These algorithms are combined with \
techniques such as reduction of order to produce a complete solution for the \
given ODE.\
\>", "Text",
 CellTags->"b:1.1.3.4",
 CellID->9515],

Cell["\<\
The general solution to this equation has a rational term and terms that \
depend on Airy functions. The Airy functions come from reducing the order of \
the equation to 2.\
\>", "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->17964],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"6", " ", "-", " ", 
            RowBox[{"24", "*", "x"}], " ", "+", " ", 
            RowBox[{"4", "*", 
             RowBox[{"x", "^", "2"}]}], " ", "-", " ", 
            RowBox[{"10", "*", 
             RowBox[{"x", "^", "3"}]}], " ", "+", " ", 
            RowBox[{"9", "*", 
             RowBox[{"x", "^", "4"}]}], " ", "-", " ", 
            RowBox[{"4", "*", 
             RowBox[{"x", "^", "5"}]}], " ", "+", " ", 
            RowBox[{"x", "^", "6"}]}], ")"}], "*", 
          RowBox[{"y", "[", "x", "]"}]}], ")"}], "/", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], " ", "+", " ", "x"}], ")"}], "^", "4"}], "*",
           
          RowBox[{"x", "^", "2"}]}], ")"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "8"}], " ", "+", " ", 
            RowBox[{"30", "*", "x"}], " ", "-", " ", 
            RowBox[{"10", "*", 
             RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
            RowBox[{"10", "*", 
             RowBox[{"x", "^", "3"}]}], " ", "-", " ", 
            RowBox[{"3", "*", 
             RowBox[{"x", "^", "4"}]}], " ", "-", " ", 
            RowBox[{"2", "*", 
             RowBox[{"x", "^", "5"}]}], " ", "+", " ", 
            RowBox[{"x", "^", "6"}]}], ")"}], "*", 
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", "1", "]"}], "[", "y", "]"}], "[", "x", 
           "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], " ", "+", " ", "x"}], ")"}], "^", "3"}], "*",
           
          RowBox[{"x", "^", "2"}]}], ")"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"4", " ", "-", " ", 
            RowBox[{"16", "*", "x"}], " ", "+", " ", 
            RowBox[{"5", "*", 
             RowBox[{"x", "^", "2"}]}], " ", "-", " ", 
            RowBox[{"2", "*", 
             RowBox[{"x", "^", "3"}]}]}], ")"}], "*", 
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", "2", "]"}], "[", "y", "]"}], "[", "x", 
           "]"}]}], ")"}], "/", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], " ", "+", " ", "x"}], ")"}], "^", "2"}], "*",
           
          RowBox[{"x", "^", "2"}]}], ")"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"4", " ", "-", " ", 
            RowBox[{"x", "^", "2"}]}], ")"}], "*", 
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", "3", "]"}], "[", "y", "]"}], "[", "x", 
           "]"}]}], ")"}], "/", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], " ", "+", " ", "x"}], ")"}], "*", "x"}], 
         ")"}]}]}], " ", "==", " ", "0"}], ",", " ", "y", ",", " ", "x"}], 
    "]"}], " "}],
  WindowSize->{979, 689},
  WindowMargins->{{Automatic, -20}, {-84, Automatic}},
  PrintingCopies->1,
  PrintingPageRange->{Automatic, Automatic}]], "Input",
 CellTags->"b:1.1.3.4",
 CellLabel->"In[7]:=",
 CellID->23342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
         RowBox[{"C", "[", "1", "]"}]}], 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         SuperscriptBox["x", "2"]}]], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
         RowBox[{"AiryAi", "[", "x", "]"}], " ", 
         RowBox[{"C", "[", "2", "]"}]}], 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         SuperscriptBox["x", "2"]}]], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
         RowBox[{"AiryBi", "[", "x", "]"}], " ", 
         RowBox[{"C", "[", "3", "]"}]}], 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         SuperscriptBox["x", "2"]}]]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{565, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.4",
 CellLabel->"Out[7]=",
 CellID->641542383]
}, Open  ]],

Cell[TextData[{
 "The equations considered so far have been homogeneous; that is, with no \
term free of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " or its derivatives. If the given ODE is inhomogeneous, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " applies the method of ",
 StyleBox["variation of parameters",
  FontSlant->"Italic"],
 " to obtain the solution. "
}], "Text",
 CellTags->"b:1.1.3.4",
 CellID->17913],

Cell["\<\
Here is an example of this type. The exponential terms in the solution come \
from the general solution to the homogeneous equation, and the remaining term \
is a particular solution (or particular integral) to the problem.\
\>", "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->16142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'''"}], "[", "x", "]"}], " ", "-", 
      RowBox[{"13", "*", 
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
      RowBox[{"19", "*", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
      RowBox[{"33", "*", 
       RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", "x"}], "]"}]}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.3.4",
 CellLabel->"In[8]:=",
 CellID->31196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]], " ", 
      RowBox[{"C", "[", "2", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"11", " ", "x"}]], " ", 
      RowBox[{"C", "[", "3", "]"}]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"17", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]}], "1625"]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{417, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.4",
 CellLabel->"Out[8]=",
 CellID->8418810]
}, Open  ]],

Cell["This is the general solution to the homogeneous equation.", \
"MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->25072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"generalsolution", " ", "=", " ", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", 
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "'''"}], "[", "x", "]"}], " ", "-", 
        RowBox[{"13", "*", 
         RowBox[{
          RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
        RowBox[{"19", "*", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
        RowBox[{"33", "*", 
         RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", " ", "0"}], ",", " ", 
      RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellTags->"b:1.1.3.4",
 CellLabel->"In[9]:=",
 CellID->20426],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]], " ", 
   RowBox[{"C", "[", "1", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"3", " ", "x"}]], " ", 
   RowBox[{"C", "[", "2", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"11", " ", "x"}]], " ", 
   RowBox[{"C", "[", "3", "]"}]}]}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.4",
 CellLabel->"Out[9]=",
 CellID->574756872]
}, Open  ]],

Cell["\<\
This particular solution is part of the general solution to the inhomogeneous \
equation.\
\>", "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->26173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"particularsolution", " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ")"}], " ", "-", 
   "generalsolution"}]}]], "Input",
 CellTags->"b:1.1.3.4",
 CellLabel->"In[10]:=",
 CellID->24429],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"17", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], "+", 
   RowBox[{"6", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}]}], "1625"]], "Output",
 ImageSize->{152, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.4",
 CellLabel->"Out[10]=",
 CellID->21357030]
}, Open  ]],

Cell["\<\
Thus, the general solution for the inhomogeneous equation is the sum of the \
general solution to the homogeneous equation and a particular integral of the \
ODE.\
\>", "Text",
 CellTags->"b:1.1.3.4",
 CellID->6705],

Cell["\<\
The solution methods for nonlinear ODEs of higher order rely to a great \
extent on reducing the problem to one of lower order.\
\>", "Text",
 CellTags->"b:1.1.3.4",
 CellID->20626],

Cell[TextData[{
 "Here is a nonlinear third-order ODE with no explicit dependence on ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 ". It is solved by reducing the order to 2 using a simple integration."
}], "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->29812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"7", "*", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "*", 
       RowBox[{
        RowBox[{"y", "'''"}], "[", "x", "]"}]}], "-", 
      RowBox[{"11", "*", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "^", "2"}]}]}], "\[Equal]", 
     "0"}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], " "}]], "Input",
 CellTags->"b:1.1.3.4",
 CellLabel->"In[11]:=",
 CellID->19375],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"C", "[", "2", "]"}], 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "x"}], "+", 
           RowBox[{"7", " ", 
            RowBox[{"C", "[", "1", "]"}]}]}], ")"}], 
         RowBox[{"3", "/", "4"}]]}]]}], "+", 
     RowBox[{"C", "[", "3", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{236, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.4",
 CellLabel->"Out[11]=",
 CellID->22091095]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->549680109],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Further Examples of Exactly Solvable Higher-Order Equations  - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveHigherOrderExactEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveIntroductionToSystemsOfODEs"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 20.0629158}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The solutions to many second-order ODEs can be expressed in terms of \
special functions. Solutions to certain higher-order ODEs can also be \
expressed using AiryAi, BesselJ, and other special functions. The solution to \
this third-order ODE is given by products of Airy functions. The solution to \
this third-order ODE is given by Bessel functions.", "synonyms" -> {}, 
    "title" -> "Further Examples of Exactly Solvable Higher-Order Equations ",
     "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveFurtherHigherOrderODEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:31"->{
  Cell[1280, 43, 127, 2, 70, "Title",
   CellTags->{"c:31", "b:1.1.3.4"},
   CellID->25629]},
 "b:1.1.3.4"->{
  Cell[1280, 43, 127, 2, 70, "Title",
   CellTags->{"c:31", "b:1.1.3.4"},
   CellID->25629],
  Cell[1410, 47, 504, 16, 70, "Text",
   CellTags->"b:1.1.3.4",
   CellID->11224],
  Cell[1917, 65, 147, 4, 70, "MathCaption",
   CellTags->"b:1.1.3.4",
   CellID->15748],
  Cell[2089, 73, 741, 23, 28, "Input",
   CellTags->"b:1.1.3.4",
   CellID->19923],
  Cell[2833, 98, 921, 29, 58, "Output",
   CellTags->"b:1.1.3.4",
   CellID->354359598],
  Cell[3769, 130, 137, 4, 70, "MathCaption",
   CellTags->"b:1.1.3.4",
   CellID->32257],
  Cell[3931, 138, 1026, 33, 47, "Input",
   CellTags->"b:1.1.3.4",
   CellID->24766],
  Cell[4960, 173, 1006, 33, 67, "Output",
   CellTags->"b:1.1.3.4",
   CellID->18235835],
  Cell[5981, 209, 167, 5, 70, "MathCaption",
   CellTags->"b:1.1.3.4",
   CellID->14955],
  Cell[6173, 218, 1797, 55, 83, "Input",
   CellTags->"b:1.1.3.4",
   CellID->23318],
  Cell[7973, 275, 8968, 152, 245, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.3.4",
   CellID->129569218],
  Cell[16956, 430, 291, 9, 70, "MathCaption",
   CellTags->"b:1.1.3.4",
   CellID->25411],
  Cell[17250, 441, 871, 30, 70, "Input",
   CellTags->"b:1.1.3.4",
   CellID->21025],
  Cell[18146, 475, 252, 8, 70, "Input",
   CellTags->"b:1.1.3.4",
   CellID->20355],
  Cell[18401, 485, 2364, 72, 150, "Output",
   CellTags->"b:1.1.3.4",
   CellID->133628982],
  Cell[20780, 560, 137, 4, 70, "MathCaption",
   CellTags->"b:1.1.3.4",
   CellID->22549],
  Cell[20942, 568, 390, 13, 70, "Input",
   CellTags->"b:1.1.3.4",
   CellID->9496],
  Cell[21335, 583, 182, 6, 36, "Output",
   CellTags->"b:1.1.3.4",
   CellID->517561600],
  Cell[21532, 592, 519, 10, 70, "Text",
   CellTags->"b:1.1.3.4",
   CellID->9515],
  Cell[22054, 604, 243, 6, 70, "MathCaption",
   CellTags->"b:1.1.3.4",
   CellID->17964],
  Cell[22322, 614, 3572, 104, 70, "Input",
   CellTags->"b:1.1.3.4",
   CellID->23342],
  Cell[25897, 720, 1274, 42, 52, "Output",
   CellTags->"b:1.1.3.4",
   CellID->641542383],
  Cell[27186, 765, 546, 17, 70, "Text",
   CellTags->"b:1.1.3.4",
   CellID->17913],
  Cell[27735, 784, 294, 6, 70, "MathCaption",
   CellTags->"b:1.1.3.4",
   CellID->16142],
  Cell[28054, 794, 653, 21, 70, "Input",
   CellTags->"b:1.1.3.4",
   CellID->31196],
  Cell[28710, 817, 957, 32, 51, "Output",
   CellTags->"b:1.1.3.4",
   CellID->8418810],
  Cell[29682, 852, 122, 3, 70, "MathCaption",
   CellTags->"b:1.1.3.4",
   CellID->25072],
  Cell[29829, 859, 757, 23, 70, "Input",
   CellTags->"b:1.1.3.4",
   CellID->20426],
  Cell[30589, 884, 559, 19, 36, "Output",
   CellTags->"b:1.1.3.4",
   CellID->574756872],
  Cell[31163, 906, 160, 5, 70, "MathCaption",
   CellTags->"b:1.1.3.4",
   CellID->26173],
  Cell[31348, 915, 327, 11, 70, "Input",
   CellTags->"b:1.1.3.4",
   CellID->24429],
  Cell[31678, 928, 394, 14, 51, "Output",
   CellTags->"b:1.1.3.4",
   CellID->21357030],
  Cell[32087, 945, 225, 6, 70, "Text",
   CellTags->"b:1.1.3.4",
   CellID->6705],
  Cell[32315, 953, 191, 5, 70, "Text",
   CellTags->"b:1.1.3.4",
   CellID->20626],
  Cell[32509, 960, 385, 11, 70, "MathCaption",
   CellTags->"b:1.1.3.4",
   CellID->29812],
  Cell[32919, 975, 543, 19, 70, "Input",
   CellTags->"b:1.1.3.4",
   CellID->19375],
  Cell[33465, 996, 674, 23, 54, "Output",
   CellTags->"b:1.1.3.4",
   CellID->22091095]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:31", 36951, 1092},
 {"b:1.1.3.4", 37061, 1096}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 127, 2, 70, "Title",
 CellTags->{"c:31", "b:1.1.3.4"},
 CellID->25629],
Cell[1410, 47, 504, 16, 70, "Text",
 CellTags->"b:1.1.3.4",
 CellID->11224],
Cell[1917, 65, 147, 4, 70, "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->15748],
Cell[CellGroupData[{
Cell[2089, 73, 741, 23, 28, "Input",
 CellTags->"b:1.1.3.4",
 CellID->19923],
Cell[2833, 98, 921, 29, 58, "Output",
 CellTags->"b:1.1.3.4",
 CellID->354359598]
}, Open  ]],
Cell[3769, 130, 137, 4, 70, "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->32257],
Cell[CellGroupData[{
Cell[3931, 138, 1026, 33, 47, "Input",
 CellTags->"b:1.1.3.4",
 CellID->24766],
Cell[4960, 173, 1006, 33, 67, "Output",
 CellTags->"b:1.1.3.4",
 CellID->18235835]
}, Open  ]],
Cell[5981, 209, 167, 5, 70, "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->14955],
Cell[CellGroupData[{
Cell[6173, 218, 1797, 55, 83, "Input",
 CellTags->"b:1.1.3.4",
 CellID->23318],
Cell[7973, 275, 8968, 152, 245, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.3.4",
 CellID->129569218]
}, Open  ]],
Cell[16956, 430, 291, 9, 70, "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->25411],
Cell[17250, 441, 871, 30, 70, "Input",
 CellTags->"b:1.1.3.4",
 CellID->21025],
Cell[CellGroupData[{
Cell[18146, 475, 252, 8, 70, "Input",
 CellTags->"b:1.1.3.4",
 CellID->20355],
Cell[18401, 485, 2364, 72, 150, "Output",
 CellTags->"b:1.1.3.4",
 CellID->133628982]
}, Open  ]],
Cell[20780, 560, 137, 4, 70, "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->22549],
Cell[CellGroupData[{
Cell[20942, 568, 390, 13, 70, "Input",
 CellTags->"b:1.1.3.4",
 CellID->9496],
Cell[21335, 583, 182, 6, 36, "Output",
 CellTags->"b:1.1.3.4",
 CellID->517561600]
}, Open  ]],
Cell[21532, 592, 519, 10, 70, "Text",
 CellTags->"b:1.1.3.4",
 CellID->9515],
Cell[22054, 604, 243, 6, 70, "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->17964],
Cell[CellGroupData[{
Cell[22322, 614, 3572, 104, 70, "Input",
 CellTags->"b:1.1.3.4",
 CellID->23342],
Cell[25897, 720, 1274, 42, 52, "Output",
 CellTags->"b:1.1.3.4",
 CellID->641542383]
}, Open  ]],
Cell[27186, 765, 546, 17, 70, "Text",
 CellTags->"b:1.1.3.4",
 CellID->17913],
Cell[27735, 784, 294, 6, 70, "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->16142],
Cell[CellGroupData[{
Cell[28054, 794, 653, 21, 70, "Input",
 CellTags->"b:1.1.3.4",
 CellID->31196],
Cell[28710, 817, 957, 32, 51, "Output",
 CellTags->"b:1.1.3.4",
 CellID->8418810]
}, Open  ]],
Cell[29682, 852, 122, 3, 70, "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->25072],
Cell[CellGroupData[{
Cell[29829, 859, 757, 23, 70, "Input",
 CellTags->"b:1.1.3.4",
 CellID->20426],
Cell[30589, 884, 559, 19, 36, "Output",
 CellTags->"b:1.1.3.4",
 CellID->574756872]
}, Open  ]],
Cell[31163, 906, 160, 5, 70, "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->26173],
Cell[CellGroupData[{
Cell[31348, 915, 327, 11, 70, "Input",
 CellTags->"b:1.1.3.4",
 CellID->24429],
Cell[31678, 928, 394, 14, 51, "Output",
 CellTags->"b:1.1.3.4",
 CellID->21357030]
}, Open  ]],
Cell[32087, 945, 225, 6, 70, "Text",
 CellTags->"b:1.1.3.4",
 CellID->6705],
Cell[32315, 953, 191, 5, 70, "Text",
 CellTags->"b:1.1.3.4",
 CellID->20626],
Cell[32509, 960, 385, 11, 70, "MathCaption",
 CellTags->"b:1.1.3.4",
 CellID->29812],
Cell[CellGroupData[{
Cell[32919, 975, 543, 19, 70, "Input",
 CellTags->"b:1.1.3.4",
 CellID->19375],
Cell[33465, 996, 674, 23, 54, "Output",
 CellTags->"b:1.1.3.4",
 CellID->22091095]
}, Open  ]],
Cell[CellGroupData[{
Cell[34176, 1024, 72, 1, 70, "RelatedTutorialsSection",
 CellID->549680109],
Cell[34251, 1027, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[34455, 1034, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

