(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16015,        541]
NotebookOptionsPosition[     10412,        369]
NotebookOutlinePosition[     14519,        483]
CellTagsIndexPosition[     14424,        477]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Linear Higher-Order Equations with Constant Coefficients", "Title",
 CellTags->{"c:28", "b:1.1.3.1"},
 CellID->30674],

Cell[TextData[{
 "A linear ODE with ",
 StyleBox["constant coefficients",
  FontSlant->"Italic"],
 " can be easily solved once the roots of the auxiliary equation (or \
characteristic equation) are known. Some examples of this type follow."
}], "Text",
 CellTags->"b:1.1.3.1",
 CellID->2220],

Cell["\<\
The characteristic equation of this ODE has real and distinct roots: 4, 1, \
and 7. Hence the solution is composed entirely of exponential functions.\
\>", "MathCaption",
 CellTags->"b:1.1.3.1",
 CellID->5402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'''"}], "[", "x", "]"}], " ", "-", 
     RowBox[{"4", "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "-", 
     RowBox[{"25", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"28", "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.3.1",
 CellLabel->"In[1]:=",
 CellID->6923],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "4"}], " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      RowBox[{"C", "[", "2", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"7", " ", "x"}]], " ", 
      RowBox[{"C", "[", "3", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{251, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.1",
 CellLabel->"Out[1]=",
 CellID->87204501]
}, Open  ]],

Cell[TextData[{
 "The characteristic equation of this ODE has two pairs of equal roots: -3",
 " ",
 "and -5. The repeated roots give rise to the",
 StyleBox[" basis ",
  FontSlant->"Italic"],
 "of the solutions",
 StyleBox[",",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"3", " ", "x"}]], ",", 
     RowBox[{"x", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]]}], ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"5", " ", "x"}]], ",", 
     RowBox[{"x", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"5", " ", "x"}]]}]}], "}"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.3.1",
 CellID->19369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''''"}], "[", "x", "]"}], " ", "-", 
     RowBox[{"16", "*", 
      RowBox[{
       RowBox[{"y", "'''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"94", "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "-", 
     RowBox[{"240", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{"225", "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.3.1",
 CellLabel->"In[2]:=",
 CellID->3878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]], " ", "x", " ", 
      RowBox[{"C", "[", "2", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"5", " ", "x"}]], " ", 
      RowBox[{"C", "[", "3", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"5", " ", "x"}]], " ", "x", " ", 
      RowBox[{"C", "[", "4", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{336, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.1",
 CellLabel->"Out[2]=",
 CellID->286101443]
}, Open  ]],

Cell[TextData[{
 "The characteristic equation for this ODE has two pairs of roots with \
nonzero imaginary parts: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "+", 
    RowBox[{"4", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "-", 
    RowBox[{"4", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "+", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "-", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath"],
 ". Hence the solution basis can be expressed with trigonometric and",
 " ",
 "exponential functions."
}], "MathCaption",
 CellTags->"b:1.1.3.1",
 CellID->19008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''''"}], "[", "x", "]"}], " ", "-", 
     RowBox[{"10", "*", 
      RowBox[{
       RowBox[{"y", "'''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"54", "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "-", 
     RowBox[{"130", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"125", "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.3.1",
 CellLabel->"In[3]:=",
 CellID->22619],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]], " ", 
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]], " ", 
      RowBox[{"C", "[", "4", "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"4", " ", "x"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]], " ", 
      RowBox[{"C", "[", "3", "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"4", " ", "x"}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{516, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.1",
 CellLabel->"Out[3]=",
 CellID->122136291]
}, Open  ]],

Cell["\<\
Finally, here is an example that combines all the previous kinds of \
solutions.\
\>", "MathCaption",
 CellTags->"b:1.1.3.1",
 CellID->30003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'''''"}], "[", "x", "]"}], " ", "-", 
     RowBox[{"17", "*", 
      RowBox[{
       RowBox[{"y", "''''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"108", "*", 
      RowBox[{
       RowBox[{"y", "'''"}], "[", "x", "]"}]}], "-", 
     RowBox[{"330", "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"488", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "-", 
     RowBox[{"280", "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.3.1",
 CellLabel->"In[4]:=",
 CellID->21945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]], " ", 
      RowBox[{"C", "[", "3", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]], " ", "x", " ", 
      RowBox[{"C", "[", "4", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"7", " ", "x"}]], " ", 
      RowBox[{"C", "[", "5", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]], " ", 
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{479, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.1",
 CellLabel->"Out[4]=",
 CellID->552344891]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->509615713],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear Higher-Order Equations with Constant Coefficients - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveIntroductionToHigherOrderODEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveHigherOrderEulerAndLegendreEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 24.2036468}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A linear ODE with constant coefficients can be easily solved once the \
roots of the auxiliary equation (or characteristic equation) are known. Some \
examples of this type follow. The characteristic equation of this ODE has \
real and distinct roots: 4, 1, and 7. Hence the solution is composed entirely \
of exponential functions. The characteristic equation of this ODE has two \
pairs of equal roots: -3 and -5. The repeated roots give rise to the basis of \
the solutions, {E^3 x,x E^3 x,E^5 x,x E^5 x}.", "synonyms" -> {}, "title" -> 
    "Linear Higher-Order Equations with Constant Coefficients", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/DSolveHigherOrderODEsWithConstantCoefficients"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:28"->{
  Cell[1280, 43, 123, 2, 70, "Title",
   CellTags->{"c:28", "b:1.1.3.1"},
   CellID->30674]},
 "b:1.1.3.1"->{
  Cell[1280, 43, 123, 2, 70, "Title",
   CellTags->{"c:28", "b:1.1.3.1"},
   CellID->30674],
  Cell[1406, 47, 291, 8, 70, "Text",
   CellTags->"b:1.1.3.1",
   CellID->2220],
  Cell[1700, 57, 219, 5, 70, "MathCaption",
   CellTags->"b:1.1.3.1",
   CellID->5402],
  Cell[1944, 66, 552, 18, 28, "Input",
   CellTags->"b:1.1.3.1",
   CellID->6923],
  Cell[2499, 86, 702, 23, 39, "Output",
   CellTags->"b:1.1.3.1",
   CellID->87204501],
  Cell[3216, 112, 782, 27, 70, "MathCaption",
   CellTags->"b:1.1.3.1",
   CellID->19369],
  Cell[4023, 143, 650, 21, 28, "Input",
   CellTags->"b:1.1.3.1",
   CellID->3878],
  Cell[4676, 166, 865, 27, 39, "Output",
   CellTags->"b:1.1.3.1",
   CellID->286101443],
  Cell[5556, 196, 743, 25, 70, "MathCaption",
   CellTags->"b:1.1.3.1",
   CellID->19008],
  Cell[6324, 225, 646, 21, 28, "Input",
   CellTags->"b:1.1.3.1",
   CellID->22619],
  Cell[6973, 248, 1077, 33, 39, "Output",
   CellTags->"b:1.1.3.1",
   CellID->122136291],
  Cell[8065, 284, 151, 5, 70, "MathCaption",
   CellTags->"b:1.1.3.1",
   CellID->30003],
  Cell[8241, 293, 744, 24, 70, "Input",
   CellTags->"b:1.1.3.1",
   CellID->21945],
  Cell[8988, 319, 1081, 33, 39, "Output",
   CellTags->"b:1.1.3.1",
   CellID->552344891]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:28", 13059, 427},
 {"b:1.1.3.1", 13169, 431}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 123, 2, 70, "Title",
 CellTags->{"c:28", "b:1.1.3.1"},
 CellID->30674],
Cell[1406, 47, 291, 8, 70, "Text",
 CellTags->"b:1.1.3.1",
 CellID->2220],
Cell[1700, 57, 219, 5, 70, "MathCaption",
 CellTags->"b:1.1.3.1",
 CellID->5402],
Cell[CellGroupData[{
Cell[1944, 66, 552, 18, 28, "Input",
 CellTags->"b:1.1.3.1",
 CellID->6923],
Cell[2499, 86, 702, 23, 39, "Output",
 CellTags->"b:1.1.3.1",
 CellID->87204501]
}, Open  ]],
Cell[3216, 112, 782, 27, 70, "MathCaption",
 CellTags->"b:1.1.3.1",
 CellID->19369],
Cell[CellGroupData[{
Cell[4023, 143, 650, 21, 28, "Input",
 CellTags->"b:1.1.3.1",
 CellID->3878],
Cell[4676, 166, 865, 27, 39, "Output",
 CellTags->"b:1.1.3.1",
 CellID->286101443]
}, Open  ]],
Cell[5556, 196, 743, 25, 70, "MathCaption",
 CellTags->"b:1.1.3.1",
 CellID->19008],
Cell[CellGroupData[{
Cell[6324, 225, 646, 21, 28, "Input",
 CellTags->"b:1.1.3.1",
 CellID->22619],
Cell[6973, 248, 1077, 33, 39, "Output",
 CellTags->"b:1.1.3.1",
 CellID->122136291]
}, Open  ]],
Cell[8065, 284, 151, 5, 70, "MathCaption",
 CellTags->"b:1.1.3.1",
 CellID->30003],
Cell[CellGroupData[{
Cell[8241, 293, 744, 24, 70, "Input",
 CellTags->"b:1.1.3.1",
 CellID->21945],
Cell[8988, 319, 1081, 33, 39, "Output",
 CellTags->"b:1.1.3.1",
 CellID->552344891]
}, Open  ]],
Cell[CellGroupData[{
Cell[10106, 357, 72, 1, 70, "RelatedTutorialsSection",
 CellID->509615713],
Cell[10181, 360, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[10385, 367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

