(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31409,        758]
NotebookOptionsPosition[     25647,        587]
NotebookOutlinePosition[     29983,        704]
CellTagsIndexPosition[     29855,        697]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Homogeneous Equations", "Title",
 CellTags->{"homogeneousODE", "c:11", "b:1.1.0.2"},
 CellID->26504],

Cell[TextData[{
 "Here is a homogeneous equation in which the total degree of both the \
numerator and the denominator of the right-hand side is 2. The two parts of \
the solution list give branches of the integral curves in the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellTags->"b:1.1.0.2",
 CellID->12392],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"3", 
         RowBox[{
          RowBox[{"y", "[", "x", "]"}], "^", "2"}]}]}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"x", "*", 
       RowBox[{"y", "[", "x", "]"}]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", "y", ",", "x"}], "]"}]}]}], "Input",
 CellTags->"b:1.1.0.2",
 CellLabel->"In[1]:=",
 CellID->32685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       SqrtBox[
        RowBox[{
         FractionBox[
          SuperscriptBox["x", "2"], "2"], "+", 
         RowBox[{
          SuperscriptBox["x", "6"], " ", 
          RowBox[{"C", "[", "1", "]"}]}]}]]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"-", 
        FractionBox[
         SqrtBox[
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["x", "6"], " ", 
            RowBox[{"C", "[", "1", "]"}]}]}]], 
         SqrtBox["2"]]}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{510, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.2",
 CellLabel->"Out[2]=",
 CellID->633498934]
}, Open  ]],

Cell[TextData[{
 "This plots both branches together, showing the complete integral curves ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["2", "TR"]], "\[LongEqual]", 
   RowBox[{
    RowBox[{
     StyleBox[
      RowBox[{
       ButtonBox["C",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/C"], "[", "1", "]"}], "MR"], " ", 
     SuperscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["6", "TR"]]}], "+", 
    FractionBox[
     SuperscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], 
     StyleBox["2", "TR"]]}]}]]],
 " for several values of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.0.2",
 CellID->6698],

Cell[BoxData[
 RowBox[{
  RowBox[{"tab1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", "k"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "3", ",", " ", "0.5"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"b:1.1.0.2",
 CellLabel->"In[3]:=",
 CellID->5589],

Cell[BoxData[
 RowBox[{
  RowBox[{"tab2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", "k"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "3", ",", " ", "0.5"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"b:1.1.0.2",
 CellLabel->"In[4]:=",
 CellID->12722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Join", "[", 
     RowBox[{"tab1", ",", "tab2"}], "]"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1.7"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:1.1.0.2",
 CellLabel->"In[5]:=",
 CellID->5938],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 218},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.2",
 CellLabel->"Out[5]=",
 CellID->365016919]
}, Open  ]],

Cell[TextData[{
 "If an initial condition is specified, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " picks the branch that passes through the initial point. The ",
 StyleBox["DSolve::bvnul", "InlineCode"],
 " message indicates that one branch of the general solution (the lower \
branch in the previous graph) did not give a solution satisfying the given \
initial condition ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["y", "TI"], "[", "1", "]"}], "\[Equal]", "3"}]], 
  "InlineFormula"],
 ". "
}], "MathCaption",
 CellTags->"b:1.1.0.2",
 CellID->6410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eqn", ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "\[Equal]", "3"}]}], "}"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.0.2",
 CellLabel->"In[6]:=",
 CellID->31461],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvnul\"\>"}], ":", 
  " ", "\<\"For some branches of the general solution, the given boundary \
conditions lead to an empty solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/bvnul\\\", ButtonNote -> \
\\\"DSolve::bvnul\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.2",
 CellLabel->"During evaluation of In[6]:=",
 CellID->41362746],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    FractionBox[
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"17", " ", 
        SuperscriptBox["x", "6"]}]}]], 
     SqrtBox["2"]]}], "}"}], "}"}]], "Output",
 ImageSize->{154, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.2",
 CellLabel->"Out[6]=",
 CellID->5344603]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->37347686],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Homogeneous Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveSeparableEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveLinearFirstOrderEquations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 24.5474056}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Here is a homogeneous equation in which the total degree of both the \
numerator and the denominator of the right-hand side is 2. The two parts of \
the solution list give branches of the integral curves in the form y=f(x). \
This plots both branches together, showing the complete integral curves \
y^2==C[1] x^6+FractionBox[SuperscriptBox[StyleBox[x, TI], StyleBox[2, TR]], \
StyleBox[2, TR]] for several values of C[1]. If an initial condition is \
specified, DSolve picks the branch that passes through the initial point. The \
DSolve::bvnul message indicates that one branch of the general solution (the \
lower branch in the previous graph) did not give a solution satisfying the \
given initial condition y[1]==3. ", "synonyms" -> {}, "title" -> 
    "Homogeneous Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveHomogeneousEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "homogeneousODE"->{
  Cell[1280, 43, 106, 2, 70, "Title",
   CellTags->{"homogeneousODE", "c:11", "b:1.1.0.2"},
   CellID->26504]},
 "c:11"->{
  Cell[1280, 43, 106, 2, 70, "Title",
   CellTags->{"homogeneousODE", "c:11", "b:1.1.0.2"},
   CellID->26504]},
 "b:1.1.0.2"->{
  Cell[1280, 43, 106, 2, 70, "Title",
   CellTags->{"homogeneousODE", "c:11", "b:1.1.0.2"},
   CellID->26504],
  Cell[1389, 47, 419, 11, 70, "MathCaption",
   CellTags->"b:1.1.0.2",
   CellID->12392],
  Cell[1833, 62, 626, 22, 47, "Input",
   CellTags->"b:1.1.0.2",
   CellID->32685],
  Cell[2462, 86, 994, 34, 65, "Output",
   CellTags->"b:1.1.0.2",
   CellID->633498934],
  Cell[3471, 123, 817, 31, 70, "MathCaption",
   CellTags->"b:1.1.0.2",
   CellID->6698],
  Cell[4291, 156, 501, 17, 70, "Input",
   CellTags->"b:1.1.0.2",
   CellID->5589],
  Cell[4795, 175, 502, 17, 70, "Input",
   CellTags->"b:1.1.0.2",
   CellID->12722],
  Cell[5322, 196, 309, 10, 28, "Input",
   CellTags->"b:1.1.0.2",
   CellID->5938],
  Cell[5634, 208, 17731, 295, 239, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.0.2",
   CellID->365016919],
  Cell[23380, 506, 638, 19, 70, "MathCaption",
   CellTags->"b:1.1.0.2",
   CellID->6410],
  Cell[24043, 529, 310, 10, 70, "Input",
   CellTags->"b:1.1.0.2",
   CellID->31461],
  Cell[24356, 541, 492, 10, 70, "Message",
   CellTags->"b:1.1.0.2",
   CellID->41362746],
  Cell[24851, 553, 454, 17, 65, "Output",
   CellTags->"b:1.1.0.2",
   CellID->5344603]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"homogeneousODE", 28389, 645},
 {"c:11", 28512, 649},
 {"b:1.1.0.2", 28640, 653}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 106, 2, 70, "Title",
 CellTags->{"homogeneousODE", "c:11", "b:1.1.0.2"},
 CellID->26504],
Cell[1389, 47, 419, 11, 70, "MathCaption",
 CellTags->"b:1.1.0.2",
 CellID->12392],
Cell[CellGroupData[{
Cell[1833, 62, 626, 22, 47, "Input",
 CellTags->"b:1.1.0.2",
 CellID->32685],
Cell[2462, 86, 994, 34, 65, "Output",
 CellTags->"b:1.1.0.2",
 CellID->633498934]
}, Open  ]],
Cell[3471, 123, 817, 31, 70, "MathCaption",
 CellTags->"b:1.1.0.2",
 CellID->6698],
Cell[4291, 156, 501, 17, 70, "Input",
 CellTags->"b:1.1.0.2",
 CellID->5589],
Cell[4795, 175, 502, 17, 70, "Input",
 CellTags->"b:1.1.0.2",
 CellID->12722],
Cell[CellGroupData[{
Cell[5322, 196, 309, 10, 28, "Input",
 CellTags->"b:1.1.0.2",
 CellID->5938],
Cell[5634, 208, 17731, 295, 239, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.0.2",
 CellID->365016919]
}, Open  ]],
Cell[23380, 506, 638, 19, 70, "MathCaption",
 CellTags->"b:1.1.0.2",
 CellID->6410],
Cell[CellGroupData[{
Cell[24043, 529, 310, 10, 70, "Input",
 CellTags->"b:1.1.0.2",
 CellID->31461],
Cell[24356, 541, 492, 10, 70, "Message",
 CellTags->"b:1.1.0.2",
 CellID->41362746],
Cell[24851, 553, 454, 17, 65, "Output",
 CellTags->"b:1.1.0.2",
 CellID->5344603]
}, Open  ]],
Cell[CellGroupData[{
Cell[25342, 575, 71, 1, 70, "RelatedTutorialsSection",
 CellID->37347686],
Cell[25416, 578, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[25620, 585, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

