(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15040,        508]
NotebookOptionsPosition[      9075,        325]
NotebookOutlinePosition[     13536,        449]
CellTagsIndexPosition[     13445,        443]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Differential-Algebraic Equations (DAEs)", "Title",
 CellTags->{"c:43", "b:3.0"},
 CellID->29087],

Cell[TextData[{
 "The systems of equations that govern certain phenomena (in electrical \
circuits, chemical kinetics, etc.) contain a combination of differential \
equations and algebraic equations. The differential equations are responsible \
for the dynamical evolution of the system, while the algebraic equations",
 " ",
 "serve to constrain the solutions to certain manifolds. It is therefore of \
some interest to study the solutions of such ",
 StyleBox["differential-algebraic equations",
  FontSlant->"Italic"],
 " (DAEs)."
}], "Text",
 CellTags->"b:3.0",
 CellID->27681],

Cell[TextData[{
 "Here is a simple example of a DAE. The first equation is an ODE for the \
function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 ", while the second equation constrains the functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 " to lie in a submanifold (a straight line) in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
 " space. "
}], "MathCaption",
 CellTags->"b:3.0",
 CellID->19964],

Cell[BoxData[
 RowBox[{
  RowBox[{"dae", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], " ", "\[Equal]", 
      RowBox[{"y", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], " ", "+", 
       RowBox[{"y", "[", "t", "]"}]}], " ", "\[Equal]", "1"}]}], "}"}]}], 
  ";"}]], "Input",
 CellTags->"b:3.0",
 CellLabel->"In[1]:=",
 CellID->1340],

Cell[TextData[{
 "This discussion will be restricted to ",
 StyleBox["linear DAEs,",
  FontSlant->"Italic"],
 " which are defined as systems of equations of the following type."
}], "Text",
 CellTags->"b:3.0",
 CellID->5686],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"A", ".", 
     RowBox[{
      SuperscriptBox["x", "\[Prime]"], "(", "t", ")"}]}], "+", 
    RowBox[{"B", ".", 
     RowBox[{"x", "(", "t", ")"}]}]}], "\[LongEqual]", "F"}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:3.0",
 CellID->6021],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]], "InlineMath"],
 " are matrix functions of the independent variable ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath"],
 " is a vector function of ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is the vector of unknowns. If the matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is nonsingular (that is, invertible) then this is a system of ODEs. Thus, \
the system is a DAE if the matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is ",
 StyleBox["singular",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:3.0",
 CellID->11662],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "\[LongEqual]", "0"}], TraditionalForm]], "InlineMath"],
 ", then the system is said to be ",
 StyleBox["homogeneous",
  FontSlant->"Italic"],
 ". As for ODEs, the general solution to a DAE is composed of the general \
solution to the corresponding homogeneous problem and a particular solution \
to the inhomogeneous system."
}], "Text",
 CellTags->"b:3.0",
 CellID->14721],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can find the solutions to all DAEs in which the entries of the matrices ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]], "InlineMath"],
 " are constants. Such DAEs are said to have constant coefficients. The \
algorithm used by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is based on decomposing both ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]], "InlineMath"],
 " into a nonsingular and nilpotent part. This decomposition is used to \
calculate a generalized inverse for ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]], "InlineMath"],
 ", which effectively reduces the problem to solving a system of ODEs."
}], "Text",
 CellTags->"b:3.0",
 CellID->6064],

Cell["\<\
It is important to realize that the initial values for a DAE must be \
prescribed carefully to guarantee a solution for the problem. This can be \
seen by considering the following system of equations.\
\>", "Text",
 CellTags->"b:3.0",
 CellID->29309],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["x", "1"], "(", "t", ")"}], "+", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["x", "2"], "\[Prime]",
        MultilineFunction->None], "(", "t", ")"}]}], "\[LongEqual]", "0"}], 
    ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "2"], "(", "t", ")"}], "\[LongEqual]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "1"], "(", "0", ")"}], "\[LongEqual]", "1"}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "2"], "(", "0", ")"}], "\[LongEqual]", "0"}]}], "}"}],
   TraditionalForm]], "DisplayMath",
 CellTags->"b:3.0",
 CellID->29873],

Cell["This gives", "Text",
 CellTags->"b:3.0",
 CellID->17124],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "2"], "(", "t", ")"}], "\[LongEqual]", 
   RowBox[{"0", "\[DoubleLongRightArrow]", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "2"], "\[Prime]",
      MultilineFunction->None], "(", "t", ")"}]}], "\[LongEqual]", 
   RowBox[{"0", "\[DoubleLongRightArrow]", 
    RowBox[{
     SubscriptBox["x", "1"], "(", "t", ")"}]}], "\[LongEqual]", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:3.0",
 CellID->23941],

Cell["Hence the only solution is", "Text",
 CellTags->"b:3.0",
 CellID->32745],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "1"], "(", "t", ")"}], "\[LongEqual]", 
   RowBox[{"0", " ", "and", " ", 
    RowBox[{
     SubscriptBox["x", "2"], "(", "t", ")"}]}], "\[LongEqual]", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:3.0",
 CellID->31762],

Cell[TextData[{
 "But this solution is inconsistent with the initial condition ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "(", "0", ")"}], "\[LongEqual]", "1"}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:3.0",
 CellID->28423],

Cell[TextData[{
 "For examples of DAEs with constant coefficients, which can be solved using \
",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ", ",
 ButtonBox["click here",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveExamplesOfDAEs"],
 "."
}], "Text",
 CellTags->"b:3.0",
 CellID->4806],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->195910137],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Differential-Algebraic Equations (DAEs) - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveSecondOrderPDEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveExamplesOfDAEs"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 26.3443266}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The systems of equations that govern certain phenomena (in electrical \
circuits, chemical kinetics, etc.) contain a combination of differential \
equations and algebraic equations. The differential equations are responsible \
for the dynamical evolution of the system, while the algebraic equations \
serve to constrain the solutions to certain manifolds. It is therefore of \
some interest to study the solutions of such differential-algebraic equations \
(DAEs). Here is a simple example of a DAE. The first equation is an ODE for \
the function x[t], while the second equation constrains the functions x[t] \
and y[t] to lie in a submanifold (a straight line) in {x,y} space. This \
discussion will be restricted to linear DAEs, which are defined as systems of \
equations of the following type.", "synonyms" -> {}, "title" -> 
    "Introduction to Differential-Algebraic Equations DAEs", "type" -> 
    "Tutorial", "uri" -> "tutorial/DSolveIntroductionToDAEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:43"->{
  Cell[1280, 43, 118, 2, 70, "Title",
   CellTags->{"c:43", "b:3.0"},
   CellID->29087]},
 "b:3.0"->{
  Cell[1280, 43, 118, 2, 70, "Title",
   CellTags->{"c:43", "b:3.0"},
   CellID->29087],
  Cell[1401, 47, 581, 13, 70, "Text",
   CellTags->"b:3.0",
   CellID->27681],
  Cell[1985, 62, 681, 22, 70, "MathCaption",
   CellTags->"b:3.0",
   CellID->19964],
  Cell[2669, 86, 455, 16, 70, "Input",
   CellTags->"b:3.0",
   CellID->1340],
  Cell[3127, 104, 224, 7, 70, "Text",
   CellTags->"b:3.0",
   CellID->5686],
  Cell[3354, 113, 304, 11, 70, "DisplayMath",
   CellTags->"b:3.0",
   CellID->6021],
  Cell[3661, 126, 950, 33, 70, "Text",
   CellTags->"b:3.0",
   CellID->11662],
  Cell[4614, 161, 440, 13, 70, "Text",
   CellTags->"b:3.0",
   CellID->14721],
  Cell[5057, 176, 1099, 33, 70, "Text",
   CellTags->"b:3.0",
   CellID->6064],
  Cell[6159, 211, 261, 6, 70, "Text",
   CellTags->"b:3.0",
   CellID->29309],
  Cell[6423, 219, 701, 24, 70, "DisplayMath",
   CellTags->"b:3.0",
   CellID->29873],
  Cell[7127, 245, 62, 2, 70, "Text",
   CellTags->"b:3.0",
   CellID->17124],
  Cell[7192, 249, 498, 15, 70, "DisplayMath",
   CellTags->"b:3.0",
   CellID->23941],
  Cell[7693, 266, 78, 2, 70, "Text",
   CellTags->"b:3.0",
   CellID->32745],
  Cell[7774, 270, 300, 10, 70, "DisplayMath",
   CellTags->"b:3.0",
   CellID->31762],
  Cell[8077, 282, 292, 11, 70, "Text",
   CellTags->"b:3.0",
   CellID->28423],
  Cell[8372, 295, 372, 14, 70, "Text",
   CellTags->"b:3.0",
   CellID->4806]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:43", 11927, 384},
 {"b:3.0", 12029, 388}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 118, 2, 70, "Title",
 CellTags->{"c:43", "b:3.0"},
 CellID->29087],
Cell[1401, 47, 581, 13, 70, "Text",
 CellTags->"b:3.0",
 CellID->27681],
Cell[1985, 62, 681, 22, 70, "MathCaption",
 CellTags->"b:3.0",
 CellID->19964],
Cell[2669, 86, 455, 16, 70, "Input",
 CellTags->"b:3.0",
 CellID->1340],
Cell[3127, 104, 224, 7, 70, "Text",
 CellTags->"b:3.0",
 CellID->5686],
Cell[3354, 113, 304, 11, 70, "DisplayMath",
 CellTags->"b:3.0",
 CellID->6021],
Cell[3661, 126, 950, 33, 70, "Text",
 CellTags->"b:3.0",
 CellID->11662],
Cell[4614, 161, 440, 13, 70, "Text",
 CellTags->"b:3.0",
 CellID->14721],
Cell[5057, 176, 1099, 33, 70, "Text",
 CellTags->"b:3.0",
 CellID->6064],
Cell[6159, 211, 261, 6, 70, "Text",
 CellTags->"b:3.0",
 CellID->29309],
Cell[6423, 219, 701, 24, 70, "DisplayMath",
 CellTags->"b:3.0",
 CellID->29873],
Cell[7127, 245, 62, 2, 70, "Text",
 CellTags->"b:3.0",
 CellID->17124],
Cell[7192, 249, 498, 15, 70, "DisplayMath",
 CellTags->"b:3.0",
 CellID->23941],
Cell[7693, 266, 78, 2, 70, "Text",
 CellTags->"b:3.0",
 CellID->32745],
Cell[7774, 270, 300, 10, 70, "DisplayMath",
 CellTags->"b:3.0",
 CellID->31762],
Cell[8077, 282, 292, 11, 70, "Text",
 CellTags->"b:3.0",
 CellID->28423],
Cell[8372, 295, 372, 14, 70, "Text",
 CellTags->"b:3.0",
 CellID->4806],
Cell[CellGroupData[{
Cell[8769, 313, 72, 1, 70, "RelatedTutorialsSection",
 CellID->195910137],
Cell[8844, 316, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[9048, 323, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

