(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8158,        271]
NotebookOptionsPosition[      4171,        153]
NotebookOutlinePosition[      7384,        242]
CellTagsIndexPosition[      7289,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Overview of Higher-Order ODEs", "Title",
 CellTags->{"c:27.5", "b:1.1.3.0"},
 CellID->12268],

Cell[TextData[{
 "The general form of an ODE with order ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is"
}], "Text",
 CellTags->"b:1.1.3.0",
 CellID->9318],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"F", "(", 
    RowBox[{"x", ",", 
     RowBox[{"y", "(", "x", ")"}], ",", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "(", "x", ")"}], ",", 
     RowBox[{
      SuperscriptBox["y", "\[DoublePrime]",
       MultilineFunction->None], "(", "x", ")"}], ",", "\[Ellipsis]", ",", 
     RowBox[{
      SuperscriptBox["y", 
       RowBox[{"(", "n", ")"}]], "(", "x", ")"}]}], ")"}], "=", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:1.1.3.0",
 CellID->5602],

Cell[TextData[{
 "As in the case of second-order ODEs, such an ODE can be classified as \
linear or nonlinear. The general form of a linear ODE of order ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is"
}], "Text",
 CellTags->"b:1.1.3.0",
 CellID->31907],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["a", "0"], "(", "x", ")"}], 
     RowBox[{
      SuperscriptBox["y", 
       RowBox[{"(", "n", ")"}]], "(", "x", ")"}]}], "+", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "1"], "(", "x", ")"}], 
     RowBox[{
      SuperscriptBox["y", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]], "(", "x", ")"}]}], "+", 
    "\[Ellipsis]", "+", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "n"], "(", "x", ")"}], 
     RowBox[{"y", "(", "x", ")"}]}]}], "=", 
   RowBox[{
    RowBox[{"b", "(", "x", ")"}], "."}]}], TraditionalForm]], "DisplayMath",
 CellTags->"b:1.1.3.0",
 CellID->24307],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " is the zero function, the equation is said to be",
 StyleBox[" homogeneous",
  FontSlant->"Italic"],
 ". This discussion is primarily restricted to that case."
}], "Text",
 CellTags->"b:1.1.3.0",
 CellID->23481],

Cell[TextData[{
 "Many methods for solving linear second-order ODEs can be generalized to \
linear ODEs of order ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is greater than 2. If the order of the ODE is not important, it is simply \
called a linear ODE."
}], "Text",
 CellTags->"b:1.1.3.0",
 CellID->1012],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->58002410],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Overview of Higher-Order ODEs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveNonlinearSecondOrderODEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveHigherOrderODEsWithConstantCoefficients"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 26.6099584}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The general form of an ODE with order n is As in the case of \
second-order ODEs, such an ODE can be classified as linear or nonlinear. The \
general form of a linear ODE of order n is If b(x) is the zero function, the \
equation is said to be homogeneous. This discussion is primarily restricted \
to that case.", "synonyms" -> {}, "title" -> "Overview of Higher-Order ODEs", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveIntroductionToHigherOrderODEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:27.5"->{
  Cell[1280, 43, 98, 2, 70, "Title",
   CellTags->{"c:27.5", "b:1.1.3.0"},
   CellID->12268]},
 "b:1.1.3.0"->{
  Cell[1280, 43, 98, 2, 70, "Title",
   CellTags->{"c:27.5", "b:1.1.3.0"},
   CellID->12268],
  Cell[1381, 47, 180, 7, 70, "Text",
   CellTags->"b:1.1.3.0",
   CellID->9318],
  Cell[1564, 56, 551, 17, 70, "DisplayMath",
   CellTags->"b:1.1.3.0",
   CellID->5602],
  Cell[2118, 75, 278, 8, 70, "Text",
   CellTags->"b:1.1.3.0",
   CellID->31907],
  Cell[2399, 85, 697, 25, 70, "DisplayMath",
   CellTags->"b:1.1.3.0",
   CellID->24307],
  Cell[3099, 112, 331, 11, 70, "Text",
   CellTags->"b:1.1.3.0",
   CellID->23481],
  Cell[3433, 125, 408, 12, 70, "Text",
   CellTags->"b:1.1.3.0",
   CellID->1012]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:27.5", 6551, 207},
 {"b:1.1.3.0", 6662, 211}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 98, 2, 70, "Title",
 CellTags->{"c:27.5", "b:1.1.3.0"},
 CellID->12268],
Cell[1381, 47, 180, 7, 70, "Text",
 CellTags->"b:1.1.3.0",
 CellID->9318],
Cell[1564, 56, 551, 17, 70, "DisplayMath",
 CellTags->"b:1.1.3.0",
 CellID->5602],
Cell[2118, 75, 278, 8, 70, "Text",
 CellTags->"b:1.1.3.0",
 CellID->31907],
Cell[2399, 85, 697, 25, 70, "DisplayMath",
 CellTags->"b:1.1.3.0",
 CellID->24307],
Cell[3099, 112, 331, 11, 70, "Text",
 CellTags->"b:1.1.3.0",
 CellID->23481],
Cell[3433, 125, 408, 12, 70, "Text",
 CellTags->"b:1.1.3.0",
 CellID->1012],
Cell[CellGroupData[{
Cell[3866, 141, 71, 1, 70, "RelatedTutorialsSection",
 CellID->58002410],
Cell[3940, 144, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[4144, 151, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

