(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8614,        270]
NotebookOptionsPosition[      4331,        154]
NotebookOutlinePosition[      7980,        247]
CellTagsIndexPosition[      7853,        240]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Overview of Linear Second-Order ODEs", "Title",
 CellTags->{"ODEwConstCoefs", "c:18.5", "b:1.1.1.0"},
 CellID->21136],

Cell["\<\
Solving linear first-order ODEs is straightforward and only requires the use \
of a suitable integrating factor. In sharp contrast, there are a large number \
of methods available for handling linear second-order ODEs, but the solution \
to the general equation belonging to this class is still not available. \
Therefore the linear case is discussed in detail before moving on to \
nonlinear second-order ODEs.\
\>", "Text",
 CellTags->"b:1.1.1.0",
 CellID->26630],

Cell[TextData[{
 "The general ",
 StyleBox["linear second-order ODE",
  FontSlant->"Italic"],
 " has the form "
}], "Text",
 CellTags->"b:1.1.1.0",
 CellID->24114],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[DoublePrime]",
      MultilineFunction->None], "(", "x", ")"}], "+", 
    RowBox[{
     RowBox[{"P", "(", "x", ")"}], 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "(", "x", ")"}]}], "+", 
    RowBox[{
     RowBox[{"Q", "(", "x", ")"}], 
     RowBox[{"y", "(", "x", ")"}]}]}], "\[LongEqual]", 
   RowBox[{
    RowBox[{"R", "(", "x", ")"}], "."}]}], TraditionalForm]], "DisplayMath",
 CellTags->"b:1.1.1.0",
 CellID->26809],

Cell[TextData[{
 "Here, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " are arbitrary functions of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". The term \"linear\" refers to the fact that the degree of each term in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "\[DoublePrime]",
     MultilineFunction->None], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is 1. (Thus, terms like ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"y", "(", "x", ")"}], "2"], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"y", "(", "x", ")"}], 
    RowBox[{
     SuperscriptBox["y", "\[DoublePrime]",
      MultilineFunction->None], "(", "x", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " would make the equation nonlinear.)"
}], "Text",
 CellTags->"b:1.1.1.0",
 CellID->4084],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->335021163],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Overview of Linear Second-Order ODEs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveChiniEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/\
DSolveLinearSecondOrderEquationsWithConstantCoefficients"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 27.0005934}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Solving linear first-order ODEs is straightforward and only requires the \
use of a suitable integrating factor. In sharp contrast, there are a large \
number of methods available for handling linear second-order ODEs, but the \
solution to the general equation belonging to this class is still not \
available. Therefore the linear case is discussed in detail before moving on \
to nonlinear second-order ODEs. The general linear second-order ODE has the \
form Here, P(x), Q(x) and R(x) are arbitrary functions of x. The term \
\"linear\" refers to the fact that the degree of each term in y(x), y^,(x) \
and y^,,(x) is 1. (Thus, terms like y(x)^2 or y(x)y^,,(x) would make the \
equation nonlinear.)", "synonyms" -> {}, "title" -> 
    "Overview of Linear Second-Order ODEs", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveIntroductionToLinearSecondOrderODEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ODEwConstCoefs"->{
  Cell[1280, 43, 123, 2, 70, "Title",
   CellTags->{"ODEwConstCoefs", "c:18.5", "b:1.1.1.0"},
   CellID->21136]},
 "c:18.5"->{
  Cell[1280, 43, 123, 2, 70, "Title",
   CellTags->{"ODEwConstCoefs", "c:18.5", "b:1.1.1.0"},
   CellID->21136]},
 "b:1.1.1.0"->{
  Cell[1280, 43, 123, 2, 70, "Title",
   CellTags->{"ODEwConstCoefs", "c:18.5", "b:1.1.1.0"},
   CellID->21136],
  Cell[1406, 47, 475, 9, 70, "Text",
   CellTags->"b:1.1.1.0",
   CellID->26630],
  Cell[1884, 58, 163, 7, 70, "Text",
   CellTags->"b:1.1.1.0",
   CellID->24114],
  Cell[2050, 67, 550, 18, 70, "DisplayMath",
   CellTags->"b:1.1.1.0",
   CellID->26809],
  Cell[2603, 87, 1397, 51, 70, "Text",
   CellTags->"b:1.1.1.0",
   CellID->4084]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ODEwConstCoefs", 7122, 213},
 {"c:18.5", 7249, 217},
 {"b:1.1.1.0", 7379, 221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 123, 2, 70, "Title",
 CellTags->{"ODEwConstCoefs", "c:18.5", "b:1.1.1.0"},
 CellID->21136],
Cell[1406, 47, 475, 9, 70, "Text",
 CellTags->"b:1.1.1.0",
 CellID->26630],
Cell[1884, 58, 163, 7, 70, "Text",
 CellTags->"b:1.1.1.0",
 CellID->24114],
Cell[2050, 67, 550, 18, 70, "DisplayMath",
 CellTags->"b:1.1.1.0",
 CellID->26809],
Cell[2603, 87, 1397, 51, 70, "Text",
 CellTags->"b:1.1.1.0",
 CellID->4084],
Cell[CellGroupData[{
Cell[4025, 142, 72, 1, 70, "RelatedTutorialsSection",
 CellID->335021163],
Cell[4100, 145, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[4304, 152, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

