(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9253,        310]
NotebookOptionsPosition[      4817,        178]
NotebookOutlinePosition[      8366,        276]
CellTagsIndexPosition[      8273,        270]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Systems of ODEs", "Title",
 CellTags->{"c:32.5", "b:1.2.0"},
 CellID->7462],

Cell[TextData[{
 "Systems of ODEs are important in various fields of science, such as the \
study of electricity and population biology. Like single ODEs, systems of \
ODEs can classified as",
 StyleBox[" linear ",
  FontSlant->"Italic"],
 "or ",
 StyleBox["nonlinear",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:1.2.0",
 CellID->26633],

Cell["\<\
A system of linear first-order ODEs can be represented in the form\
\>", "Text",
 CellTags->"b:1.2.0",
 CellID->12158],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["X", "\[Prime]",
     MultilineFunction->None], "(", "t", ")"}], "\[LongEqual]", 
   RowBox[{
    RowBox[{"A", "(", "t", ")"}], " ", 
    RowBox[{"X", "(", "t", ")"}], " ", 
    RowBox[{
     FormBox[
      RowBox[{"+", 
       RowBox[{"B", "(", "t", ")"}]}],
      TraditionalForm], "."}]}]}], TraditionalForm]], "DisplayMath",
 CellTags->"b:1.2.0",
 CellID->12022],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is a vector of unknown functions, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is the matrix of the coefficients of the unknown functions, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"B", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is a vector representing the inhomogeneous part of the system."
}], "Text",
 CellTags->"b:1.2.0",
 CellID->1146],

Cell["\<\
In the two-dimensional case, the system can be written more concretely as\
\>", "Text",
 CellTags->"b:1.2.0",
 CellID->18392],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "\[Prime]"], "(", "t", ")"}], "\[LongEqual]", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "(", "t", ")"}], 
     RowBox[{"x", "(", "t", ")"}]}], "+", 
    RowBox[{
     RowBox[{"q", "(", "t", ")"}], 
     RowBox[{"y", "(", "t", ")"}]}], "+", 
    RowBox[{"u", "(", "t", ")"}]}]}], TraditionalForm]], "DisplayMath",
 CellTags->"b:1.2.0",
 CellID->13037],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "\[Prime]"], "(", "t", ")"}], "\[LongEqual]", 
   RowBox[{
    RowBox[{
     RowBox[{"r", "(", "t", ")"}], 
     RowBox[{"x", "(", "t", ")"}]}], "+", 
    RowBox[{
     RowBox[{"s", "(", "t", ")"}], 
     RowBox[{"y", "(", "t", ")"}]}], "+", 
    RowBox[{
     RowBox[{"v", "(", "t", ")"}], "."}]}]}], TraditionalForm]], "DisplayMath",\

 CellTags->"b:1.2.0",
 CellID->3925],

Cell[TextData[{
 "If all the entries of the matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " are constants, then the system is said to be ",
 StyleBox["linear with constant coefficients",
  FontSlant->"Italic"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"B", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is the zero vector, then the system is said to be ",
 StyleBox["homogeneous",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:1.2.0",
 CellID->10647],

Cell["\<\
The important global features of the solutions to linear systems can be \
clarified by considering homogeneous systems of ODEs with constant \
coefficients. \
\>", "Text",
 CellTags->"b:1.2.0",
 CellID->29458],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Systems of ODEs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveFurtherHigherOrderODEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveSystemsOfLinearODEs"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 32.1882262}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Systems of ODEs are important in various fields of science, such as the \
study of electricity and population biology. Like single ODEs, systems of \
ODEs can classified as linear or nonlinear. A system of linear first-order \
ODEs can be represented in the form Here X(t) is a vector of unknown \
functions, A(t) is the matrix of the coefficients of the unknown functions, \
and B(t) is a vector representing the inhomogeneous part of the system.", 
    "synonyms" -> {}, "title" -> "Introduction to Systems of ODEs", "type" -> 
    "Tutorial", "uri" -> "tutorial/DSolveIntroductionToSystemsOfODEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:32.5"->{
  Cell[1280, 43, 97, 2, 70, "Title",
   CellTags->{"c:32.5", "b:1.2.0"},
   CellID->7462]},
 "b:1.2.0"->{
  Cell[1280, 43, 97, 2, 70, "Title",
   CellTags->{"c:32.5", "b:1.2.0"},
   CellID->7462],
  Cell[1380, 47, 348, 12, 70, "Text",
   CellTags->"b:1.2.0",
   CellID->26633],
  Cell[1731, 61, 128, 4, 70, "Text",
   CellTags->"b:1.2.0",
   CellID->12158],
  Cell[1862, 67, 432, 15, 70, "DisplayMath",
   CellTags->"b:1.2.0",
   CellID->12022],
  Cell[2297, 84, 530, 16, 70, "Text",
   CellTags->"b:1.2.0",
   CellID->1146],
  Cell[2830, 102, 135, 4, 70, "Text",
   CellTags->"b:1.2.0",
   CellID->18392],
  Cell[2968, 108, 423, 14, 70, "DisplayMath",
   CellTags->"b:1.2.0",
   CellID->13037],
  Cell[3394, 124, 445, 16, 70, "DisplayMath",
   CellTags->"b:1.2.0",
   CellID->3925],
  Cell[3842, 142, 531, 18, 70, "Text",
   CellTags->"b:1.2.0",
   CellID->10647],
  Cell[4376, 162, 219, 6, 70, "Text",
   CellTags->"b:1.2.0",
   CellID->29458]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:32.5", 7302, 232},
 {"b:1.2.0", 7408, 236}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 97, 2, 70, "Title",
 CellTags->{"c:32.5", "b:1.2.0"},
 CellID->7462],
Cell[1380, 47, 348, 12, 70, "Text",
 CellTags->"b:1.2.0",
 CellID->26633],
Cell[1731, 61, 128, 4, 70, "Text",
 CellTags->"b:1.2.0",
 CellID->12158],
Cell[1862, 67, 432, 15, 70, "DisplayMath",
 CellTags->"b:1.2.0",
 CellID->12022],
Cell[2297, 84, 530, 16, 70, "Text",
 CellTags->"b:1.2.0",
 CellID->1146],
Cell[2830, 102, 135, 4, 70, "Text",
 CellTags->"b:1.2.0",
 CellID->18392],
Cell[2968, 108, 423, 14, 70, "DisplayMath",
 CellTags->"b:1.2.0",
 CellID->13037],
Cell[3394, 124, 445, 16, 70, "DisplayMath",
 CellTags->"b:1.2.0",
 CellID->3925],
Cell[3842, 142, 531, 18, 70, "Text",
 CellTags->"b:1.2.0",
 CellID->10647],
Cell[4376, 162, 219, 6, 70, "Text",
 CellTags->"b:1.2.0",
 CellID->29458],
Cell[4598, 170, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]],
Cell[4790, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

