(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8338,        274]
NotebookOptionsPosition[      4572,        162]
NotebookOutlinePosition[      7600,        246]
CellTagsIndexPosition[      7505,        240]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Inverse Linear Equations", "Title",
 CellTags->{"c:11c", "b:1.1.0.2c"},
 CellID->6602],

Cell[TextData[{
 "It may happen that a given ODE is not linear in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " but can be viewed as a linear ODE in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "(", "y", ")"}], TraditionalForm]], "InlineMath"],
 ". In this case, it is said to be an",
 StyleBox[" inverse linear ",
  FontSlant->"Italic"],
 "ODE."
}], "Text",
 CellTags->"b:1.1.0.2c",
 CellID->30807],

Cell[TextData[{
 "This is a inverse linear ODE. It is constructed by interchanging ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " in an earlier example."
}], "MathCaption",
 CellTags->"b:1.1.0.2c",
 CellID->4098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", " ", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "x"}], "*", 
        RowBox[{"y", "[", "x", "]"}]}], " ", "+", 
       RowBox[{"Exp", "[", 
        RowBox[{"3", "*", 
         RowBox[{"y", "[", "x", "]"}]}], "]"}]}], ")"}]}]}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.0.2c",
 CellLabel->"In[5]:=",
 CellID->27830],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The equations appear to involve the \
variables to be solved for in an essentially non-algebraic way.\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/Solve/tdep\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:1.1.0.2c",
 CellLabel->"During evaluation of In[5]:=",
 CellID->17421],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"x", "\[Equal]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        SuperscriptBox[
         RowBox[{"y", "[", "x", "]"}], "2"]}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["9", "2"]}], "-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"y", "[", "x", "]"}], "2"], "2"]}]], " ", 
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      RowBox[{"Erfi", "[", 
       FractionBox[
        RowBox[{"3", "+", 
         RowBox[{"y", "[", "x", "]"}]}], 
        SqrtBox["2"]], "]"}]}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{394, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.2c",
 CellLabel->"Out[5]=",
 CellID->18716]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->681329187],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inverse Linear Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveLinearFirstOrderEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveBernoulliEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 32.4382326}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "It may happen that a given ODE is not linear in y(x) but can be viewed \
as a linear ODE in x(y). In this case, it is said to be an inverse linear \
ODE. This is a inverse linear ODE. It is constructed by interchanging x and y \
in an earlier example.", "synonyms" -> {}, "title" -> 
    "Inverse Linear Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveInverseLinearEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:11c"->{
  Cell[1280, 43, 92, 2, 70, "Title",
   CellTags->{"c:11c", "b:1.1.0.2c"},
   CellID->6602]},
 "b:1.1.0.2c"->{
  Cell[1280, 43, 92, 2, 70, "Title",
   CellTags->{"c:11c", "b:1.1.0.2c"},
   CellID->6602],
  Cell[1375, 47, 452, 15, 70, "Text",
   CellTags->"b:1.1.0.2c",
   CellID->30807],
  Cell[1830, 64, 309, 10, 70, "MathCaption",
   CellTags->"b:1.1.0.2c",
   CellID->4098],
  Cell[2164, 78, 545, 18, 70, "Input",
   CellTags->"b:1.1.0.2c",
   CellID->27830],
  Cell[2712, 98, 509, 11, 19, "Message",
   CellTags->"b:1.1.0.2c",
   CellID->17421],
  Cell[3224, 111, 1005, 34, 61, "Output",
   CellTags->"b:1.1.0.2c",
   CellID->18716]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:11c", 6843, 214},
 {"b:1.1.0.2c", 6954, 218}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 92, 2, 70, "Title",
 CellTags->{"c:11c", "b:1.1.0.2c"},
 CellID->6602],
Cell[1375, 47, 452, 15, 70, "Text",
 CellTags->"b:1.1.0.2c",
 CellID->30807],
Cell[1830, 64, 309, 10, 70, "MathCaption",
 CellTags->"b:1.1.0.2c",
 CellID->4098],
Cell[CellGroupData[{
Cell[2164, 78, 545, 18, 70, "Input",
 CellTags->"b:1.1.0.2c",
 CellID->27830],
Cell[2712, 98, 509, 11, 19, "Message",
 CellTags->"b:1.1.0.2c",
 CellID->17421],
Cell[3224, 111, 1005, 34, 61, "Output",
 CellTags->"b:1.1.0.2c",
 CellID->18716]
}, Open  ]],
Cell[CellGroupData[{
Cell[4266, 150, 72, 1, 70, "RelatedTutorialsSection",
 CellID->681329187],
Cell[4341, 153, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[4545, 160, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

