(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    129771,       3030]
NotebookOptionsPosition[    114358,       2499]
NotebookOutlinePosition[    123243,       2781]
CellTagsIndexPosition[    123072,       2773]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Linear and Quasi-Linear PDEs", "Title",
 CellTags->{"c:39", "b:2.1.0"},
 CellID->18819],

Cell["\<\
First-order PDEs are usually classified as linear, quasi-linear, or \
nonlinear. The first two types are discussed in this tutorial.\
\>", "Text",
 CellTags->"b:2.1.0",
 CellID->943],

Cell[TextData[{
 "A first-order PDE for an unknown function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]]],
 " is said to be ",
 StyleBox["linear",
  FontSlant->"Italic"],
 " if it can be expressed in the form"
}], "Text",
 CellTags->"b:2.1.0",
 CellID->186949615],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "(", 
      RowBox[{"x", ",", "y"}], ")"}], 
     FractionBox[
      RowBox[{"\[PartialD]", 
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}], 
      RowBox[{"\[PartialD]", "x"}],
      MultilineFunction->None]}], "+", 
    RowBox[{
     RowBox[{"b", "(", 
      RowBox[{"x", ",", "y"}], ")"}], 
     FractionBox[
      RowBox[{"\[PartialD]", 
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}], 
      RowBox[{"\[PartialD]", "y"}],
      MultilineFunction->None]}], "+", 
    RowBox[{
     RowBox[{"c", "(", 
      RowBox[{"x", ",", "y"}], ")"}], 
     RowBox[{"u", "(", 
      RowBox[{"x", ",", "y"}], ")"}]}]}], "\[LongEqual]", 
   RowBox[{
    RowBox[{"d", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "."}]}], TraditionalForm]], "DisplayMath",\

 CellID->174811179],

Cell[TextData[{
 "The PDE",
 " ",
 "is said to be ",
 StyleBox["quasilinear",
  FontSlant->"Italic"],
 " if it can be expressed in the form"
}], "Text",
 CellTags->"b:2.1.0",
 CellID->410553054],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "(", 
      RowBox[{"x", ",", "y", ",", 
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}], ")"}], 
     FractionBox[
      RowBox[{"\[PartialD]", 
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}], 
      RowBox[{"\[PartialD]", "x"}],
      MultilineFunction->None]}], "+", 
    RowBox[{
     RowBox[{"b", "(", 
      RowBox[{"x", ",", "y", ",", 
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}], ")"}], 
     FractionBox[
      RowBox[{"\[PartialD]", 
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}], 
      RowBox[{"\[PartialD]", "y"}],
      MultilineFunction->None]}]}], "\[LongEqual]", 
   RowBox[{
    RowBox[{"c", "(", 
     RowBox[{"x", ",", "y", ",", 
      RowBox[{"u", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}], ")"}], "."}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->145965467],

Cell[TextData[{
 "A PDE",
 " ",
 "which is neither linear nor quasi-linear is said to ",
 StyleBox["nonlinear",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:2.1.0",
 CellID->56714101],

Cell[TextData[{
 "For convenience, the symbols ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " are used throughout this tutorial to denote the unknown function and its \
partial derivatives."
}], "Text",
 CellID->279790733],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"z", " ", "=", " ", 
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}]}], ";", " ", 
   RowBox[{"p", "=", " ", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      RowBox[{"u", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}], 
     RowBox[{"\[PartialD]", "x"}],
     MultilineFunction->None]}], " ", ";", " ", 
   RowBox[{"q", " ", "=", " ", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      RowBox[{"u", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}], 
     RowBox[{"\[PartialD]", "y"}],
     MultilineFunction->None]}], ";"}], TraditionalForm]], "DisplayMath",
 CellID->9569314],

Cell["\<\
Here is a linear homogeneous first-order PDE with constant coefficients. \
\>", "MathCaption",
 CellTags->"b:2.1.0",
 CellID->32611],

Cell[BoxData[
 RowBox[{"z", ":=", 
  RowBox[{"u", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[1]:=",
 CellID->1941],

Cell[BoxData[
 RowBox[{"p", ":=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[2]:=",
 CellID->20289],

Cell[BoxData[
 RowBox[{"q", ":=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[3]:=",
 CellID->8419],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "*", "p"}], "+", 
     RowBox[{"3", "*", "q"}], " ", "+", "z"}], "\[Equal]", "0"}]}], 
  ";"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[4]:=",
 CellID->5565],

Cell[TextData[{
 "The equation is linear because the left-hand side is a linear polynomial in \
",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ". Since there is no term free of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ", or ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ",",
 " the PDE is also homogeneous. "
}], "Text",
 CellTags->"b:2.1.0",
 CellID->3805],

Cell[TextData[{
 "As mentioned earlier, the general solution contains an arbitrary function \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " of the argument ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "y"}], "-", 
      RowBox[{"3", "x"}]}], ")"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:2.1.0",
 CellID->7585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[5]:=",
 CellID->16216],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "x"}], "/", "2"}]], " ", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "x"}], "+", 
           RowBox[{"2", " ", "y"}]}], ")"}]}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{331, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[5]=",
 CellID->305002110]
}, Open  ]],

Cell["This verifies that the solution is correct.", "MathCaption",
 CellTags->"b:2.1.0",
 CellID->1615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[6]:=",
 CellID->2609],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[6]=",
 CellID->200560109]
}, Open  ]],

Cell[TextData[{
 "Particular solutions of the homogeneous PDE are obtained by specifying the \
function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellTags->"b:2.1.0",
 CellID->9166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"particularsolution", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "[", "a_", "]"}], "\[Rule]", " ", 
    RowBox[{"Sin", "[", "a", "]"}]}]}]}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[7]:=",
 CellID->16893],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "x"}], "/", "2"}]], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "x"}], "+", 
      RowBox[{"2", " ", "y"}]}], ")"}]}], "]"}]}]], "Output",
 ImageSize->{152, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[7]=",
 CellID->209934253]
}, Open  ]],

Cell["Here is a plot of the surface for this particular solution.", \
"MathCaption",
 CellTags->"b:2.1.0",
 CellID->13509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"particularsolution", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", " ", 
   RowBox[{"PlotPoints", " ", "\[Rule]", " ", "30"}]}], "]"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[8]:=",
 CellID->30300],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 300},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[8]=",
 CellID->679696298]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox[ButtonBox["transport equation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToPDEs#27918"],
  FontSlant->"Italic"],
 " is a good example of a linear first-order homogeneous PDE with constant \
coefficients. "
}], "Text",
 CellTags->{"TransportEquation", "b:2.1.0"},
 CellID->9573],

Cell[TextData[{
 "In this transport equation, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "=", "1"}], TraditionalForm]], "InlineMath"],
 " for convenience."
}], "MathCaption",
 CellTags->"b:2.1.0",
 CellID->15589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "\[LongEqual]", 
    "0"}], ",", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[9]:=",
 CellID->39698734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "[", 
     RowBox[{
      RowBox[{"-", "x"}], "+", "y"}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[9]=",
 CellID->153569222]
}, Open  ]],

Cell[TextData[{
 "Note that the solution to the transport equation is constant on any \
straight line of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "\[LongEqual]", 
    RowBox[{"x", "+", "\[Alpha]"}]}], TraditionalForm]], "InlineMath"],
 " in the plane. These straight lines are called the ",
 StyleBox["base characteristic curves",
  FontSlant->"Italic"],
 ". The equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "\[LongEqual]", 
    RowBox[{"x", "+", "\[Alpha]"}]}], TraditionalForm]], "InlineMath"],
 " defines a plane in three dimensions. The intersections of these planes \
with the solution surface are called ",
 StyleBox["characteristic curves",
  FontSlant->"Italic"],
 ". Since the characteristic curves are solutions to a system of ODEs, the \
problem of solving the PDE is reduced to that of solving a system of ODEs for \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " is a parameter along the characteristic curves. These ODEs are called \
characteristic ODEs."
}], "Text",
 CellTags->"b:2.1.0",
 CellID->17968],

Cell["\<\
The solution to an inhomogeneous PDE has two components: the general solution \
to the homogeneous PDE and a particular solution to the inhomogeneous PDE.\
\>", "Text",
 CellTags->"b:2.1.0",
 CellID->27358],

Cell["This is a linear inhomogeneous PDE of the first order.", "MathCaption",
 CellTags->"b:2.1.0",
 CellID->26031],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"7", "*", "p"}], "+", 
     RowBox[{"3", "*", "q"}], " ", "+", "z"}], "\[Equal]", 
    RowBox[{"x", "+", "y"}]}]}], ";"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[10]:=",
 CellID->26268],

Cell[TextData[{
 "The first part of the solution, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "10"}], "+", "x", "+", "y"}], TraditionalForm]], 
  "InlineMath"],
 ", is the particular solution to the inhomogeneous PDE. The rest of the \
solution is the general solution to the homogenous equation."
}], "MathCaption",
 CellTags->"b:2.1.0",
 CellID->19426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "/.", 
    RowBox[{
     RowBox[{"DSolve", "[", 
      RowBox[{"eqn", ",", " ", 
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "//", "Expand"}]}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[11]:=",
 CellID->28510],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "10"}], "+", "x", "+", "y", "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "x"}], "/", "7"}]], " ", 
   RowBox[{
    RowBox[{"C", "[", "1", "]"}], "[", 
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", "x"}], "+", 
       RowBox[{"7", " ", "y"}]}], ")"}]}], "]"}]}]}]], "Output",
 ImageSize->{233, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[11]=",
 CellID->73826082]
}, Open  ]],

Cell["Here is a linear homogeneous PDE with variable coefficients.", \
"MathCaption",
 CellTags->"b:2.1.0",
 CellID->30774],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "*", "p"}], "+", 
     RowBox[{
      RowBox[{"E", "^", "x"}], "*", "q"}]}], "\[Equal]", "0"}]}], 
  ";"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[12]:=",
 CellID->8779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[13]:=",
 CellID->30910],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "[", 
       RowBox[{"y", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", "x"}]], " ", 
         RowBox[{"Hypergeometric2F1", "[", 
          RowBox[{
           RowBox[{
            FractionBox["1", "2"], "-", 
            FractionBox["\[ImaginaryI]", "2"]}], ",", "1", ",", 
           RowBox[{
            FractionBox["3", "2"], "-", 
            FractionBox["\[ImaginaryI]", "2"]}], ",", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], "]"}]}]}], 
       "]"}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{580, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[13]=",
 CellID->78066028]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:2.1.0",
 CellID->4182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[14]:=",
 CellID->25391],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[14]=",
 CellID->14256861]
}, Open  ]],

Cell["\<\
Here is a linear inhomogeneous PDE with variable coefficients.\
\>", "MathCaption",
 CellTags->"b:2.1.0",
 CellID->5764],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{"p", "+", 
     RowBox[{"x", "*", "q"}]}], "\[Equal]", 
    RowBox[{"Cos", "[", "x", "]"}]}]}], ";"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[15]:=",
 CellID->874],

Cell[TextData[{
 "The solution is once again composed of the general solution to the \
homogeneous PDE and a particular solution, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ", to the inhomogeneous PDE."
}], "MathCaption",
 CellTags->"b:2.1.0",
 CellID->1364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[16]:=",
 CellID->14902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["x", "2"]}], "+", 
           RowBox[{"2", " ", "y"}]}], ")"}]}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{350, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[16]=",
 CellID->44944930]
}, Open  ]],

Cell[TextData[{
 "Now consider some examples of ",
 StyleBox["first-order quasi-linear PDEs",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellTags->"b:2.1.0",
 CellID->4460],

Cell[TextData[{
 "This PDE is quasi-linear because of the term ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", "2"], TraditionalForm]], "InlineMath"],
 " on the right-hand side."
}], "MathCaption",
 CellTags->"b:2.1.0",
 CellID->474],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{"p", "+", 
     RowBox[{"x", "*", "q"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"z", "^", "2"}], "+", "5"}]}]}], ";"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[17]:=",
 CellID->6972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[18]:=",
 CellID->26821],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.0",
 CellLabel->"During evaluation of In[18]:=",
 CellID->76008123],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       SqrtBox["5"], " ", 
       RowBox[{"Tan", "[", 
        RowBox[{
         RowBox[{
          SqrtBox["5"], " ", "x"}], "+", 
         RowBox[{
          SqrtBox["5"], " ", 
          RowBox[{
           RowBox[{"C", "[", "1", "]"}], "[", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["x", "2"]}], "+", 
              RowBox[{"2", " ", "y"}]}], ")"}]}], "]"}]}]}], "]"}]}]}], 
     "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{431, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[18]=",
 CellID->538797962]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:2.1.0",
 CellID->21577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[19]:=",
 CellID->9789],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[19]=",
 CellID->15787502]
}, Open  ]],

Cell[TextData[{
 StyleBox[ButtonBox["Burgers\[CloseCurlyQuote] equation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToPDEs#27918"],
  FontSlant->"Italic"],
 " is an important example of a quasi-linear PDE. "
}], "MathCaption",
 CellTags->{"BurgersEquation", "b:2.1.0"},
 CellID->30195],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", 
      RowBox[{"u", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}], 
     RowBox[{"\[PartialD]", "x"}]], "+", 
    RowBox[{
     RowBox[{"u", "(", 
      RowBox[{"x", ",", "y"}], ")"}], 
     FractionBox[
      RowBox[{"\[PartialD]", 
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}], 
      RowBox[{"\[PartialD]", "y"}]]}]}], "\[LongEqual]", "0"}], 
  TraditionalForm]], "DisplayMath",
 CellID->83202137],

Cell[" It can be written using the notation introduced earlier. ", \
"MathCaption",
 CellTags->"b:2.1.0",
 CellID->148629792],

Cell[BoxData[
 RowBox[{
  RowBox[{"BurgersEquation", " ", "=", 
   RowBox[{
    RowBox[{"p", "+", 
     RowBox[{"z", " ", "q"}]}], "\[Equal]", "0"}]}], ";"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[20]:=",
 CellID->27594],

Cell[TextData[{
 " The term ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", " ", "q"}], TraditionalForm]], "InlineMath"],
 " makes this equation quasi-linear."
}], "Text",
 CellTags->"b:2.1.0",
 CellID->812273895],

Cell["This solves the equation. ", "MathCaption",
 CellTags->"b:2.1.0",
 CellID->7950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"BurgersEquation", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[21]:=",
 CellID->16343],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"y", "-", 
       RowBox[{"x", " ", 
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}]}]}], "]"}], "\[Equal]", "0"}], ",", 
   
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "]"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[21]=",
 CellID->23771231]
}, Open  ]],

Cell["This verifies the solution to Burgers' equation.", "MathCaption",
 CellTags->"b:2.1.0",
 CellID->2481],

Cell[BoxData[
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"p", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"sol", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", " ", "p"}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[22]:=",
 CellID->1012],

Cell[BoxData[
 RowBox[{
  RowBox[{"q1", "=", 
   RowBox[{"q", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"sol", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "y"}], "]"}], ",", " ", "q"}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[23]:=",
 CellID->11672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p1", "+", 
  RowBox[{"z", "*", "q1"}]}]], "Input",
 CellTags->"b:2.1.0",
 CellLabel->"In[24]:=",
 CellID->23439],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.0",
 CellLabel->"Out[24]=",
 CellID->55424693]
}, Open  ]],

Cell["\<\
A practical consequence of quasi-linearity is the appearance of shocks and \
steepening and breaking of solutions. Thus, although the procedures for \
finding general solutions to linear and quasi-linear PDEs are quite similar, \
there are sharp differences in the nature of the solutions.\
\>", "Text",
 CellTags->"b:2.1.0",
 CellID->5912],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->91273669],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear and Quasi-Linear PDEs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveIntroductionToPDEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveNonlinearFirstOrderPDEs"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 33.4226328}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "First-order PDEs are usually classified as linear, quasi-linear, or \
nonlinear. The first two types are discussed in this tutorial. A first-order \
PDE for an unknown function u(x,y) is said to be linear if it can be \
expressed in the form The PDE is said to be quasilinear if it can be \
expressed in the form", "synonyms" -> {}, "title" -> 
    "Linear and Quasi-Linear PDEs", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveLinearAndQuasiLinearFirstOrderPDEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:39"->{
  Cell[1280, 43, 93, 2, 70, "Title",
   CellTags->{"c:39", "b:2.1.0"},
   CellID->18819]},
 "b:2.1.0"->{
  Cell[1280, 43, 93, 2, 70, "Title",
   CellTags->{"c:39", "b:2.1.0"},
   CellID->18819],
  Cell[1376, 47, 192, 5, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->943],
  Cell[1571, 54, 323, 12, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->186949615],
  Cell[2780, 101, 194, 9, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->410553054],
  Cell[3929, 146, 193, 9, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->56714101],
  Cell[5157, 194, 142, 4, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->32611],
  Cell[5302, 200, 162, 6, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->1941],
  Cell[5467, 208, 219, 8, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->20289],
  Cell[5689, 218, 218, 8, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->8419],
  Cell[5910, 228, 255, 10, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->5565],
  Cell[6168, 240, 644, 24, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->3805],
  Cell[6815, 266, 516, 20, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->7585],
  Cell[7356, 290, 242, 8, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->16216],
  Cell[7601, 300, 778, 27, 51, "Output",
   CellTags->"b:2.1.0",
   CellID->305002110],
  Cell[8394, 330, 103, 2, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->1615],
  Cell[8522, 336, 199, 7, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->2609],
  Cell[8724, 345, 183, 6, 36, "Output",
   CellTags->"b:2.1.0",
   CellID->200560109],
  Cell[8922, 354, 304, 11, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->9166],
  Cell[9251, 369, 429, 14, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->16893],
  Cell[9683, 385, 490, 18, 51, "Output",
   CellTags->"b:2.1.0",
   CellID->209934253],
  Cell[10188, 406, 122, 3, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->13509],
  Cell[10335, 413, 405, 12, 28, "Input",
   CellTags->"b:2.1.0",
   CellID->30300],
  Cell[10743, 427, 87131, 1433, 321, "Output",
   Evaluatable->False,
   CellTags->"b:2.1.0",
   CellID->679696298],
  Cell[97889, 1863, 341, 10, 70, "Text",
   CellTags->{"TransportEquation", "b:2.1.0"},
   CellID->9573],
  Cell[98233, 1875, 214, 8, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->15589],
  Cell[98472, 1887, 564, 20, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->39698734],
  Cell[99039, 1909, 421, 15, 36, "Output",
   CellTags->"b:2.1.0",
   CellID->153569222],
  Cell[99475, 1927, 1374, 40, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->17968],
  Cell[100852, 1969, 216, 5, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->27358],
  Cell[101071, 1976, 115, 2, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->26031],
  Cell[101189, 1980, 279, 10, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->26268],
  Cell[101471, 1992, 368, 11, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->19426],
  Cell[101864, 2007, 483, 16, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->28510],
  Cell[102350, 2025, 591, 21, 51, "Output",
   CellTags->"b:2.1.0",
   CellID->73826082],
  Cell[102956, 2049, 123, 3, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->30774],
  Cell[103082, 2054, 302, 12, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->8779],
  Cell[103409, 2070, 243, 8, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->30910],
  Cell[103655, 2080, 1156, 34, 73, "Output",
   CellTags->"b:2.1.0",
   CellID->78066028],
  Cell[104826, 2117, 87, 2, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->4182],
  Cell[104938, 2123, 201, 7, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->25391],
  Cell[105142, 2132, 183, 6, 36, "Output",
   CellTags->"b:2.1.0",
   CellID->14256861],
  Cell[105340, 2141, 130, 4, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->5764],
  Cell[105473, 2147, 243, 9, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->874],
  Cell[105719, 2158, 379, 12, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->1364],
  Cell[106123, 2174, 243, 8, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->14902],
  Cell[106369, 2184, 717, 25, 51, "Output",
   CellTags->"b:2.1.0",
   CellID->44944930],
  Cell[107101, 2212, 172, 7, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->4460],
  Cell[107276, 2221, 237, 8, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->474],
  Cell[107516, 2231, 263, 10, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->6972],
  Cell[107804, 2245, 243, 8, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->26821],
  Cell[108050, 2255, 519, 10, 70, "Message",
   CellTags->"b:2.1.0",
   CellID->76008123],
  Cell[108572, 2267, 894, 31, 51, "Output",
   CellTags->"b:2.1.0",
   CellID->538797962],
  Cell[109481, 2301, 88, 2, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->21577],
  Cell[109594, 2307, 200, 7, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->9789],
  Cell[109797, 2316, 183, 6, 36, "Output",
   CellTags->"b:2.1.0",
   CellID->15787502],
  Cell[109995, 2325, 313, 8, 70, "MathCaption",
   CellTags->{"BurgersEquation", "b:2.1.0"},
   CellID->30195],
  Cell[110828, 2355, 125, 3, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->148629792],
  Cell[110956, 2360, 230, 8, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->27594],
  Cell[111189, 2370, 210, 8, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->812273895],
  Cell[111402, 2380, 86, 2, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->7950],
  Cell[111513, 2386, 255, 8, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->16343],
  Cell[111771, 2396, 590, 21, 36, "Output",
   CellTags->"b:2.1.0",
   CellID->23771231],
  Cell[112376, 2420, 108, 2, 70, "MathCaption",
   CellTags->"b:2.1.0",
   CellID->2481],
  Cell[112487, 2424, 414, 15, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->1012],
  Cell[112904, 2441, 415, 15, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->11672],
  Cell[113344, 2460, 136, 5, 70, "Input",
   CellTags->"b:2.1.0",
   CellID->23439],
  Cell[113483, 2467, 180, 6, 36, "Output",
   CellTags->"b:2.1.0",
   CellID->55424693],
  Cell[113678, 2476, 350, 7, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->5912]},
 "TransportEquation"->{
  Cell[97889, 1863, 341, 10, 70, "Text",
   CellTags->{"TransportEquation", "b:2.1.0"},
   CellID->9573]},
 "BurgersEquation"->{
  Cell[109995, 2325, 313, 8, 70, "MathCaption",
   CellTags->{"BurgersEquation", "b:2.1.0"},
   CellID->30195]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:39", 116707, 2552},
 {"b:2.1.0", 116812, 2556},
 {"TransportEquation", 122807, 2762},
 {"BurgersEquation", 122936, 2766}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 93, 2, 70, "Title",
 CellTags->{"c:39", "b:2.1.0"},
 CellID->18819],
Cell[1376, 47, 192, 5, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->943],
Cell[1571, 54, 323, 12, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->186949615],
Cell[1897, 68, 880, 31, 70, "DisplayMath",
 CellID->174811179],
Cell[2780, 101, 194, 9, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->410553054],
Cell[2977, 112, 949, 32, 70, "DisplayMath",
 CellID->145965467],
Cell[3929, 146, 193, 9, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->56714101],
Cell[4125, 157, 391, 13, 70, "Text",
 CellID->279790733],
Cell[4519, 172, 635, 20, 70, "DisplayMath",
 CellID->9569314],
Cell[5157, 194, 142, 4, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->32611],
Cell[5302, 200, 162, 6, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->1941],
Cell[5467, 208, 219, 8, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->20289],
Cell[5689, 218, 218, 8, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->8419],
Cell[5910, 228, 255, 10, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->5565],
Cell[6168, 240, 644, 24, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->3805],
Cell[6815, 266, 516, 20, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->7585],
Cell[CellGroupData[{
Cell[7356, 290, 242, 8, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->16216],
Cell[7601, 300, 778, 27, 51, "Output",
 CellTags->"b:2.1.0",
 CellID->305002110]
}, Open  ]],
Cell[8394, 330, 103, 2, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->1615],
Cell[CellGroupData[{
Cell[8522, 336, 199, 7, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->2609],
Cell[8724, 345, 183, 6, 36, "Output",
 CellTags->"b:2.1.0",
 CellID->200560109]
}, Open  ]],
Cell[8922, 354, 304, 11, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->9166],
Cell[CellGroupData[{
Cell[9251, 369, 429, 14, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->16893],
Cell[9683, 385, 490, 18, 51, "Output",
 CellTags->"b:2.1.0",
 CellID->209934253]
}, Open  ]],
Cell[10188, 406, 122, 3, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->13509],
Cell[CellGroupData[{
Cell[10335, 413, 405, 12, 28, "Input",
 CellTags->"b:2.1.0",
 CellID->30300],
Cell[10743, 427, 87131, 1433, 321, "Output",
 Evaluatable->False,
 CellTags->"b:2.1.0",
 CellID->679696298]
}, Open  ]],
Cell[97889, 1863, 341, 10, 70, "Text",
 CellTags->{"TransportEquation", "b:2.1.0"},
 CellID->9573],
Cell[98233, 1875, 214, 8, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->15589],
Cell[CellGroupData[{
Cell[98472, 1887, 564, 20, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->39698734],
Cell[99039, 1909, 421, 15, 36, "Output",
 CellTags->"b:2.1.0",
 CellID->153569222]
}, Open  ]],
Cell[99475, 1927, 1374, 40, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->17968],
Cell[100852, 1969, 216, 5, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->27358],
Cell[101071, 1976, 115, 2, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->26031],
Cell[101189, 1980, 279, 10, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->26268],
Cell[101471, 1992, 368, 11, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->19426],
Cell[CellGroupData[{
Cell[101864, 2007, 483, 16, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->28510],
Cell[102350, 2025, 591, 21, 51, "Output",
 CellTags->"b:2.1.0",
 CellID->73826082]
}, Open  ]],
Cell[102956, 2049, 123, 3, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->30774],
Cell[103082, 2054, 302, 12, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->8779],
Cell[CellGroupData[{
Cell[103409, 2070, 243, 8, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->30910],
Cell[103655, 2080, 1156, 34, 73, "Output",
 CellTags->"b:2.1.0",
 CellID->78066028]
}, Open  ]],
Cell[104826, 2117, 87, 2, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->4182],
Cell[CellGroupData[{
Cell[104938, 2123, 201, 7, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->25391],
Cell[105142, 2132, 183, 6, 36, "Output",
 CellTags->"b:2.1.0",
 CellID->14256861]
}, Open  ]],
Cell[105340, 2141, 130, 4, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->5764],
Cell[105473, 2147, 243, 9, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->874],
Cell[105719, 2158, 379, 12, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->1364],
Cell[CellGroupData[{
Cell[106123, 2174, 243, 8, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->14902],
Cell[106369, 2184, 717, 25, 51, "Output",
 CellTags->"b:2.1.0",
 CellID->44944930]
}, Open  ]],
Cell[107101, 2212, 172, 7, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->4460],
Cell[107276, 2221, 237, 8, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->474],
Cell[107516, 2231, 263, 10, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->6972],
Cell[CellGroupData[{
Cell[107804, 2245, 243, 8, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->26821],
Cell[108050, 2255, 519, 10, 70, "Message",
 CellTags->"b:2.1.0",
 CellID->76008123],
Cell[108572, 2267, 894, 31, 51, "Output",
 CellTags->"b:2.1.0",
 CellID->538797962]
}, Open  ]],
Cell[109481, 2301, 88, 2, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->21577],
Cell[CellGroupData[{
Cell[109594, 2307, 200, 7, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->9789],
Cell[109797, 2316, 183, 6, 36, "Output",
 CellTags->"b:2.1.0",
 CellID->15787502]
}, Open  ]],
Cell[109995, 2325, 313, 8, 70, "MathCaption",
 CellTags->{"BurgersEquation", "b:2.1.0"},
 CellID->30195],
Cell[110311, 2335, 514, 18, 70, "DisplayMath",
 CellID->83202137],
Cell[110828, 2355, 125, 3, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->148629792],
Cell[110956, 2360, 230, 8, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->27594],
Cell[111189, 2370, 210, 8, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->812273895],
Cell[111402, 2380, 86, 2, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->7950],
Cell[CellGroupData[{
Cell[111513, 2386, 255, 8, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->16343],
Cell[111771, 2396, 590, 21, 36, "Output",
 CellTags->"b:2.1.0",
 CellID->23771231]
}, Open  ]],
Cell[112376, 2420, 108, 2, 70, "MathCaption",
 CellTags->"b:2.1.0",
 CellID->2481],
Cell[112487, 2424, 414, 15, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->1012],
Cell[112904, 2441, 415, 15, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->11672],
Cell[CellGroupData[{
Cell[113344, 2460, 136, 5, 70, "Input",
 CellTags->"b:2.1.0",
 CellID->23439],
Cell[113483, 2467, 180, 6, 36, "Output",
 CellTags->"b:2.1.0",
 CellID->55424693]
}, Open  ]],
Cell[113678, 2476, 350, 7, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->5912],
Cell[CellGroupData[{
Cell[114053, 2487, 71, 1, 70, "RelatedTutorialsSection",
 CellID->91273669],
Cell[114127, 2490, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[114331, 2497, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

