(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26430,        832]
NotebookOptionsPosition[     18439,        569]
NotebookOutlinePosition[     23718,        726]
CellTagsIndexPosition[     23590,        719]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Linear Second-Order Equations with Constant Coefficients", "Title",
 CellTags->{"ODEwConstCoefs", "c:19", "b:1.1.1.1"},
 CellID->13877],

Cell[TextData[{
 "The simplest type of linear second-order ODE is one with ",
 StyleBox["constant coefficients",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:1.1.1.1",
 CellID->25770],

Cell["This linear second-order ODE has constant coefficients.", "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", 
      RowBox[{"5", "*", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}], "-", 
      RowBox[{"6", 
       RowBox[{"y", "[", "x", "]"}]}]}], " ", "\[Equal]", "0"}], ",", " ", 
    "y", ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.1.1",
 CellLabel->"In[6]:=",
 CellID->14364],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "6"}], " ", "x"}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{269, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.1",
 CellLabel->"Out[6]=",
 CellID->23698941]
}, Open  ]],

Cell[TextData[{
 "Notice that the general solution is a linear combination of two exponential \
functions. The arbitrary constants ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 " can be varied to produce particular solutions."
}], "Text",
 CellTags->"b:1.1.1.1",
 CellID->16590],

Cell["This is one particular solution to the equation.", "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->8823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", "2"}], ",", " ", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], "\[Rule]", "3"}]}], "}"}]}]}]], "Input",
 CellTags->"b:1.1.1.1",
 CellLabel->"In[7]:=",
 CellID->2237],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "6"}], " ", "x"}]]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["\[ExponentialE]", "x"]}]}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.1",
 CellLabel->"Out[7]=",
 CellID->52719583]
}, Open  ]],

Cell[TextData[{
 "The exponents ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "6"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " in the ",
 StyleBox["basis ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "6"}], "x"}]], ",", 
     SuperscriptBox["\[ExponentialE]", "x"]}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " are obtained by solving the associated quadratic equation. This quadratic \
equation is called the ",
 StyleBox["auxiliary",
  FontSlant->"Italic"],
 " or ",
 StyleBox["characteristic",
  FontSlant->"Italic"],
 " equation."
}], "Text",
 CellTags->"b:1.1.1.1",
 CellID->32179],

Cell["This solves the auxiliary equation.", "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->16595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", "^", "2"}], "+", 
     RowBox[{"5", "m"}], "-", "6"}], "\[Equal]", "0"}], ",", " ", "m"}], 
  "]"}]], "Input",
 CellTags->"b:1.1.1.1",
 CellLabel->"In[8]:=",
 CellID->20169],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m", "\[Rule]", 
     RowBox[{"-", "6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.1",
 CellLabel->"Out[8]=",
 CellID->415744865]
}, Open  ]],

Cell["\<\
The roots are real and distinct in this case. There are two other cases of \
interest: real and equal roots, and imaginary roots.\
\>", "Text",
 CellTags->"b:1.1.1.1",
 CellID->12042],

Cell["This example has real and equal roots.", "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->31310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], " ", "-", " ", 
      RowBox[{"6", " ", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}], " ", "+", 
      RowBox[{"9", 
       RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", "y", 
    ",", " ", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.1.1",
 CellLabel->"In[9]:=",
 CellID->28182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"3", " ", "x"}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"3", " ", "x"}]], " ", "x", " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{281, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.1",
 CellLabel->"Out[9]=",
 CellID->88169169]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", "2"}], ",", " ", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", "3"}]}], 
    "}"}]}]}]], "Input",
 CellTags->"b:1.1.1.1",
 CellLabel->"In[305]:=",
 CellID->7926],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"3", " ", "x"}]]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"3", " ", "x"}]], " ", "x"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.1",
 CellLabel->"Out[305]=",
 CellID->4862720]
}, Open  ]],

Cell["This example has roots with nonzero imaginary parts.", "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->1670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], " ", "-", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], " ", "+", 
      RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "0"}], ",", " ", "y", ",", 
    " ", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.1.1",
 CellLabel->"In[306]:=",
 CellID->32528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"x", "/", "2"}]], " ", 
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{
           SqrtBox["3"], " ", "x"}], "2"], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"x", "/", "2"}]], " ", 
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Sin", "[", 
         FractionBox[
          RowBox[{
           SqrtBox["3"], " ", "x"}], "2"], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{429, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.1",
 CellLabel->"Out[306]=",
 CellID->33529644]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol3", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", "2"}], ",", " ", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", "3"}]}], 
    "}"}]}]}]], "Input",
 CellTags->"b:1.1.1.1",
 CellLabel->"In[307]:=",
 CellID->2258],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"x", "/", "2"}]], " ", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["3"], " ", "x"}], "2"], "]"}]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"x", "/", "2"}]], " ", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["3"], " ", "x"}], "2"], "]"}]}]}]], "Output",
 ImageSize->{234, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.1",
 CellLabel->"Out[307]=",
 CellID->274389975]
}, Open  ]],

Cell["Here is a plot of the three solutions.", "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->9860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"sol1", ",", " ", "sol2", ",", " ", "sol3"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.5"}], ",", " ", "0.5"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:1.1.1.1",
 CellLabel->"In[308]:=",
 CellID->25783],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 233},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.1",
 CellLabel->"Out[308]=",
 CellID->13896727]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->168163389],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear Second-Order Equations with Constant Coefficients - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveIntroductionToLinearSecondOrderODEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveSecondOrderEulerAndLegendreEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 36.8445954}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The simplest type of linear second-order ODE is one with constant \
coefficients. This linear second-order ODE has constant coefficients. Notice \
that the general solution is a linear combination of two exponential \
functions. The arbitrary constants C[1] and C[2] can be varied to produce \
particular solutions.", "synonyms" -> {}, "title" -> 
    "Linear Second-Order Equations with Constant Coefficients", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/DSolveLinearSecondOrderEquationsWithConstantCoefficients"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ODEwConstCoefs"->{
  Cell[1280, 43, 141, 2, 70, "Title",
   CellTags->{"ODEwConstCoefs", "c:19", "b:1.1.1.1"},
   CellID->13877]},
 "c:19"->{
  Cell[1280, 43, 141, 2, 70, "Title",
   CellTags->{"ODEwConstCoefs", "c:19", "b:1.1.1.1"},
   CellID->13877]},
 "b:1.1.1.1"->{
  Cell[1280, 43, 141, 2, 70, "Title",
   CellTags->{"ODEwConstCoefs", "c:19", "b:1.1.1.1"},
   CellID->13877],
  Cell[1424, 47, 193, 7, 70, "Text",
   CellTags->"b:1.1.1.1",
   CellID->25770],
  Cell[1620, 56, 116, 2, 70, "MathCaption",
   CellTags->"b:1.1.1.1",
   CellID->702],
  Cell[1761, 62, 464, 16, 28, "Input",
   CellTags->"b:1.1.1.1",
   CellID->14364],
  Cell[2228, 80, 642, 21, 39, "Output",
   CellTags->"b:1.1.1.1",
   CellID->23698941],
  Cell[2885, 104, 518, 17, 70, "Text",
   CellTags->"b:1.1.1.1",
   CellID->16590],
  Cell[3406, 123, 110, 2, 70, "MathCaption",
   CellTags->"b:1.1.1.1",
   CellID->8823],
  Cell[3541, 129, 443, 15, 28, "Input",
   CellTags->"b:1.1.1.1",
   CellID->2237],
  Cell[3987, 146, 373, 13, 36, "Output",
   CellTags->"b:1.1.1.1",
   CellID->52719583],
  Cell[4375, 162, 770, 30, 70, "Text",
   CellTags->"b:1.1.1.1",
   CellID->32179],
  Cell[5148, 194, 98, 2, 70, "MathCaption",
   CellTags->"b:1.1.1.1",
   CellID->16595],
  Cell[5271, 200, 265, 10, 70, "Input",
   CellTags->"b:1.1.1.1",
   CellID->20169],
  Cell[5539, 212, 359, 13, 36, "Output",
   CellTags->"b:1.1.1.1",
   CellID->415744865],
  Cell[5913, 228, 193, 5, 70, "Text",
   CellTags->"b:1.1.1.1",
   CellID->12042],
  Cell[6109, 235, 101, 2, 70, "MathCaption",
   CellTags->"b:1.1.1.1",
   CellID->31310],
  Cell[6235, 241, 474, 16, 70, "Input",
   CellTags->"b:1.1.1.1",
   CellID->28182],
  Cell[6712, 259, 656, 21, 39, "Output",
   CellTags->"b:1.1.1.1",
   CellID->88169169],
  Cell[7405, 285, 455, 16, 70, "Input",
   CellTags->"b:1.1.1.1",
   CellID->7926],
  Cell[7863, 303, 388, 13, 36, "Output",
   CellTags->"b:1.1.1.1",
   CellID->4862720],
  Cell[8266, 319, 114, 2, 70, "MathCaption",
   CellTags->"b:1.1.1.1",
   CellID->1670],
  Cell[8405, 325, 424, 14, 70, "Input",
   CellTags->"b:1.1.1.1",
   CellID->32528],
  Cell[8832, 341, 903, 30, 56, "Output",
   CellTags->"b:1.1.1.1",
   CellID->33529644],
  Cell[9772, 376, 455, 16, 70, "Input",
   CellTags->"b:1.1.1.1",
   CellID->2258],
  Cell[10230, 394, 593, 21, 56, "Output",
   CellTags->"b:1.1.1.1",
   CellID->274389975],
  Cell[10838, 418, 100, 2, 70, "MathCaption",
   CellTags->"b:1.1.1.1",
   CellID->9860],
  Cell[10963, 424, 317, 10, 28, "Input",
   CellTags->"b:1.1.1.1",
   CellID->25783],
  Cell[11283, 436, 6813, 116, 254, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.1.1",
   CellID->13896727]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ODEwConstCoefs", 20920, 625},
 {"c:19", 21043, 629},
 {"b:1.1.1.1", 21171, 633}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 141, 2, 70, "Title",
 CellTags->{"ODEwConstCoefs", "c:19", "b:1.1.1.1"},
 CellID->13877],
Cell[1424, 47, 193, 7, 70, "Text",
 CellTags->"b:1.1.1.1",
 CellID->25770],
Cell[1620, 56, 116, 2, 70, "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->702],
Cell[CellGroupData[{
Cell[1761, 62, 464, 16, 28, "Input",
 CellTags->"b:1.1.1.1",
 CellID->14364],
Cell[2228, 80, 642, 21, 39, "Output",
 CellTags->"b:1.1.1.1",
 CellID->23698941]
}, Open  ]],
Cell[2885, 104, 518, 17, 70, "Text",
 CellTags->"b:1.1.1.1",
 CellID->16590],
Cell[3406, 123, 110, 2, 70, "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->8823],
Cell[CellGroupData[{
Cell[3541, 129, 443, 15, 28, "Input",
 CellTags->"b:1.1.1.1",
 CellID->2237],
Cell[3987, 146, 373, 13, 36, "Output",
 CellTags->"b:1.1.1.1",
 CellID->52719583]
}, Open  ]],
Cell[4375, 162, 770, 30, 70, "Text",
 CellTags->"b:1.1.1.1",
 CellID->32179],
Cell[5148, 194, 98, 2, 70, "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->16595],
Cell[CellGroupData[{
Cell[5271, 200, 265, 10, 70, "Input",
 CellTags->"b:1.1.1.1",
 CellID->20169],
Cell[5539, 212, 359, 13, 36, "Output",
 CellTags->"b:1.1.1.1",
 CellID->415744865]
}, Open  ]],
Cell[5913, 228, 193, 5, 70, "Text",
 CellTags->"b:1.1.1.1",
 CellID->12042],
Cell[6109, 235, 101, 2, 70, "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->31310],
Cell[CellGroupData[{
Cell[6235, 241, 474, 16, 70, "Input",
 CellTags->"b:1.1.1.1",
 CellID->28182],
Cell[6712, 259, 656, 21, 39, "Output",
 CellTags->"b:1.1.1.1",
 CellID->88169169]
}, Open  ]],
Cell[CellGroupData[{
Cell[7405, 285, 455, 16, 70, "Input",
 CellTags->"b:1.1.1.1",
 CellID->7926],
Cell[7863, 303, 388, 13, 36, "Output",
 CellTags->"b:1.1.1.1",
 CellID->4862720]
}, Open  ]],
Cell[8266, 319, 114, 2, 70, "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->1670],
Cell[CellGroupData[{
Cell[8405, 325, 424, 14, 70, "Input",
 CellTags->"b:1.1.1.1",
 CellID->32528],
Cell[8832, 341, 903, 30, 56, "Output",
 CellTags->"b:1.1.1.1",
 CellID->33529644]
}, Open  ]],
Cell[CellGroupData[{
Cell[9772, 376, 455, 16, 70, "Input",
 CellTags->"b:1.1.1.1",
 CellID->2258],
Cell[10230, 394, 593, 21, 56, "Output",
 CellTags->"b:1.1.1.1",
 CellID->274389975]
}, Open  ]],
Cell[10838, 418, 100, 2, 70, "MathCaption",
 CellTags->"b:1.1.1.1",
 CellID->9860],
Cell[CellGroupData[{
Cell[10963, 424, 317, 10, 28, "Input",
 CellTags->"b:1.1.1.1",
 CellID->25783],
Cell[11283, 436, 6813, 116, 254, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.1.1",
 CellID->13896727]
}, Open  ]],
Cell[CellGroupData[{
Cell[18133, 557, 72, 1, 70, "RelatedTutorialsSection",
 CellID->168163389],
Cell[18208, 560, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[18412, 567, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

