(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30484,        741]
NotebookOptionsPosition[     25034,        571]
NotebookOutlinePosition[     29026,        684]
CellTagsIndexPosition[     28931,        678]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Inhomogeneous Linear Second-Order Equations", "Title",
 CellTags->{"c:25", "b:1.1.1.7"},
 CellID->2742],

Cell[TextData[{
 "If the given second-order ODE is inhomogeneous, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " applies the ",
 StyleBox["method of variation of parameters",
  FontSlant->"Italic"],
 " to return a solution for the problem."
}], "Text",
 CellTags->"b:1.1.1.7",
 CellID->8610],

Cell["\<\
This solves an inhomogeneous linear second-order ODE. The solution is \
composed of two parts: the first part is the general solution to the \
homogeneous equation, and the second part is a particular solution to the \
inhomogeneous equation.\
\>", "MathCaption",
 CellTags->"b:1.1.1.7",
 CellID->4472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], 
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
      RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", 
     RowBox[{"x", "^", "2"}]}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.1.7",
 CellLabel->"In[358]:=",
 CellID->7128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SqrtBox["x"], " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "]"}]}], "+", 
     RowBox[{
      SqrtBox["x"], " ", 
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            SqrtBox["3"], " ", 
            RowBox[{"Log", "[", "x", "]"}]}], "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            SqrtBox["3"], " ", 
            RowBox[{"Log", "[", "x", "]"}]}], "]"}], "2"]}]}], ")"}]}]}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{554, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.7",
 CellLabel->"Out[358]=",
 CellID->291756068]
}, Open  ]],

Cell["\<\
This solves the homogeneous equation, which is an Euler equation.\
\>", "MathCaption",
 CellTags->"b:1.1.1.7",
 CellID->5841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.1.7",
 CellLabel->"In[359]:=",
 CellID->20718],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SqrtBox["x"], " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "]"}]}], "+", 
     RowBox[{
      SqrtBox["x"], " ", 
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{441, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.7",
 CellLabel->"Out[359]=",
 CellID->590958865]
}, Open  ]],

Cell[TextData[{
 "Different particular solutions can be obtained by varying the constants ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 " in the solution. "
}], "MathCaption",
 CellTags->"b:1.1.1.7",
 CellID->14867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"particularsolutions", "=", " ", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", "i"}], ",", " ", 
        RowBox[{
         RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", "j"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "5", ",", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellTags->"b:1.1.1.7",
 CellLabel->"In[360]:=",
 CellID->24865],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{509, 246},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.7",
 CellLabel->"Out[360]=",
 CellID->48750501]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "particularsolutions", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.1", ",", "2"}], "}"}]}], " ", "]"}]], "Input",
 CellTags->"b:1.1.1.7",
 CellLabel->"In[361]:=",
 CellID->9257],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.7",
 CellLabel->"Out[361]=",
 CellID->99022938]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->786603410],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inhomogeneous Linear Second-Order Equations - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/\
DSolveLinearSecondOrderODEsWithNonRationalCoefficients"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveNonlinearSecondOrderODEs"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 37.2196050}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "If the given second-order ODE is inhomogeneous, DSolve applies the \
method of variation of parameters to return a solution for the problem. This \
solves an inhomogeneous linear second-order ODE. The solution is composed of \
two parts: the first part is the general solution to the homogeneous \
equation, and the second part is a particular solution to the inhomogeneous \
equation. This solves the homogeneous equation, which is an Euler equation.", 
    "synonyms" -> {}, "title" -> 
    "Inhomogeneous Linear Second-Order Equations", "type" -> "Tutorial", 
    "uri" -> "tutorial/DSolveLinearSecondOrderInhomogeneousEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:25"->{
  Cell[1280, 43, 109, 2, 70, "Title",
   CellTags->{"c:25", "b:1.1.1.7"},
   CellID->2742]},
 "b:1.1.1.7"->{
  Cell[1280, 43, 109, 2, 70, "Title",
   CellTags->{"c:25", "b:1.1.1.7"},
   CellID->2742],
  Cell[1392, 47, 365, 12, 70, "Text",
   CellTags->"b:1.1.1.7",
   CellID->8610],
  Cell[1760, 61, 312, 7, 70, "MathCaption",
   CellTags->"b:1.1.1.7",
   CellID->4472],
  Cell[2097, 72, 441, 15, 28, "Input",
   CellTags->"b:1.1.1.7",
   CellID->7128],
  Cell[2541, 89, 1437, 48, 82, "Output",
   CellTags->"b:1.1.1.7",
   CellID->291756068],
  Cell[3993, 140, 135, 4, 70, "MathCaption",
   CellTags->"b:1.1.1.7",
   CellID->5841],
  Cell[4153, 148, 382, 13, 28, "Input",
   CellTags->"b:1.1.1.7",
   CellID->20718],
  Cell[4538, 163, 791, 28, 51, "Output",
   CellTags->"b:1.1.1.7",
   CellID->590958865],
  Cell[5344, 194, 455, 16, 70, "MathCaption",
   CellTags->"b:1.1.1.7",
   CellID->14867],
  Cell[5824, 214, 691, 21, 47, "Input",
   CellTags->"b:1.1.1.7",
   CellID->24865],
  Cell[6518, 237, 5845, 100, 267, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.1.7",
   CellID->48750501],
  Cell[12400, 342, 269, 8, 28, "Input",
   CellTags->"b:1.1.1.7",
   CellID->9257],
  Cell[12672, 352, 12019, 202, 244, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.1.7",
   CellID->99022938]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:25", 27607, 629},
 {"b:1.1.1.7", 27716, 633}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 109, 2, 70, "Title",
 CellTags->{"c:25", "b:1.1.1.7"},
 CellID->2742],
Cell[1392, 47, 365, 12, 70, "Text",
 CellTags->"b:1.1.1.7",
 CellID->8610],
Cell[1760, 61, 312, 7, 70, "MathCaption",
 CellTags->"b:1.1.1.7",
 CellID->4472],
Cell[CellGroupData[{
Cell[2097, 72, 441, 15, 28, "Input",
 CellTags->"b:1.1.1.7",
 CellID->7128],
Cell[2541, 89, 1437, 48, 82, "Output",
 CellTags->"b:1.1.1.7",
 CellID->291756068]
}, Open  ]],
Cell[3993, 140, 135, 4, 70, "MathCaption",
 CellTags->"b:1.1.1.7",
 CellID->5841],
Cell[CellGroupData[{
Cell[4153, 148, 382, 13, 28, "Input",
 CellTags->"b:1.1.1.7",
 CellID->20718],
Cell[4538, 163, 791, 28, 51, "Output",
 CellTags->"b:1.1.1.7",
 CellID->590958865]
}, Open  ]],
Cell[5344, 194, 455, 16, 70, "MathCaption",
 CellTags->"b:1.1.1.7",
 CellID->14867],
Cell[CellGroupData[{
Cell[5824, 214, 691, 21, 47, "Input",
 CellTags->"b:1.1.1.7",
 CellID->24865],
Cell[6518, 237, 5845, 100, 267, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.1.7",
 CellID->48750501]
}, Open  ]],
Cell[CellGroupData[{
Cell[12400, 342, 269, 8, 28, "Input",
 CellTags->"b:1.1.1.7",
 CellID->9257],
Cell[12672, 352, 12019, 202, 244, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.1.7",
 CellID->99022938]
}, Open  ]],
Cell[CellGroupData[{
Cell[24728, 559, 72, 1, 70, "RelatedTutorialsSection",
 CellID->786603410],
Cell[24803, 562, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[25007, 569, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

