(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19585,        671]
NotebookOptionsPosition[     13308,        473]
NotebookOutlinePosition[     17728,        599]
CellTagsIndexPosition[     17633,        593]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Equations with Non-Rational Coefficients", "Title",
 CellTags->{"c:24", "b:1.1.1.6"},
 CellID->28614],

Cell[TextData[{
 "The ODEs that arise in practical applications often have non-rational \
coefficients. In such cases, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " attempts to convert the equation into one with rational coefficients using \
a suitable coordinate transformation. "
}], "Text",
 CellTags->"b:1.1.1.6",
 CellID->18598],

Cell[TextData[{
 "Here is an equation that has ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " as a coefficient. It is solved by transforming it to Bessel\
\[CloseCurlyQuote]s equation."
}], "MathCaption",
 CellTags->"b:1.1.1.6",
 CellID->28458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"5", "x"}], "]"}], "*", 
       RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", "y", ",", "x"}], 
   "]"}], " "}]], "Input",
 CellTags->"b:1.1.1.6",
 CellLabel->"In[1]:=",
 CellID->2661],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"BesselI", "[", 
         RowBox[{"0", ",", 
          FractionBox[
           RowBox[{"2", " ", 
            SqrtBox[
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"5", " ", "x"}]]]}], "5"]}], "]"}], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"BesselK", "[", 
         RowBox[{"0", ",", 
          FractionBox[
           RowBox[{"2", " ", 
            SqrtBox[
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"5", " ", "x"}]]]}], "5"]}], "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{510, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.6",
 CellLabel->"Out[1]=",
 CellID->95604359]
}, Open  ]],

Cell[TextData[{
 "This equation (equation 2.437, page 507 of [",
 ButtonBox["K59",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveReferences#21388"],
 "]) has trigonometric coefficients. The solution is given in terms of \
elementary functions."
}], "MathCaption",
 CellTags->"b:1.1.1.6",
 CellID->32756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], "*", 
      RowBox[{"Sin", "[", "x", "]"}], "*", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], " ", "-", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", "*", 
         RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}], " ", "+", " ", "1"}], 
       ")"}], "*", 
      RowBox[{"Cos", "[", "x", "]"}]}], " ", "-", " ", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "*", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "^", "3"}]}]}], " ", "==", " ", "0"}], 
   ",", " ", "y", ",", " ", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.1.6",
 CellLabel->"In[2]:=",
 CellID->20807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], 
         RowBox[{
          RowBox[{"-", 
           FractionBox["3", "2"]}], "-", 
          FractionBox[
           SqrtBox["13"], "2"]}]]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], 
         RowBox[{
          RowBox[{"-", 
           FractionBox["3", "2"]}], "+", 
          FractionBox[
           SqrtBox["13"], "2"]}]]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{410, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.6",
 CellLabel->"Out[2]=",
 CellID->501755109]
}, Open  ]],

Cell[TextData[{
 "Here is an equation with a hyperbolic function in the coefficient of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 ". The solution is given in terms of Legendre functions."
}], "MathCaption",
 CellTags->"b:1.1.1.6",
 CellID->19489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"k", "^", "2"}], " ", "+", " ", 
         RowBox[{"2", "*", 
          RowBox[{
           RowBox[{"Sech", "[", "x", "]"}], "^", "2"}]}]}], ")"}], 
       RowBox[{"y", "[", "x", "]"}]}]}], " ", "==", " ", "0"}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}], " "}]], "Input",
 CellTags->"b:1.1.1.6",
 CellLabel->"In[3]:=",
 CellID->19435],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"LegendreP", "[", 
       RowBox[{"1", ",", 
        RowBox[{"\[ImaginaryI]", " ", "k"}], ",", 
        RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"LegendreQ", "[", 
       RowBox[{"1", ",", 
        RowBox[{"\[ImaginaryI]", " ", "k"}], ",", 
        RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{498, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.6",
 CellLabel->"Out[3]=",
 CellID->343279969]
}, Open  ]],

Cell[TextData[{
 "The solution to this equation is given in terms of ",
 Cell[BoxData[
  ButtonBox["HypergeometricU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricU"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LaguerreL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaguerreL"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.1.6",
 CellID->32075],

Cell[BoxData[
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "d"}], "+", 
       RowBox[{"d", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "b"}], " ", "x"}], "]"}]}], ")"}], "^", "2"}]}]}], 
      ")"}], " ", 
     RowBox[{"y", "[", "x", "]"}]}], " ", "-", 
    RowBox[{"l", " ", 
     RowBox[{"y", "[", "x", "]"}]}]}]}], ";"}]], "Input",
 CellTags->"b:1.1.1.6",
 CellLabel->"In[4]:=",
 CellID->7586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"expr", "\[Equal]", "0"}], ",", "y", ",", " ", "x"}], "]"}], 
  " "}]], "Input",
 CellTags->"b:1.1.1.6",
 CellLabel->"In[5]:=",
 CellID->1386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", 
            SqrtBox["d"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "b"}], " ", "x"}]]}], "+", 
           RowBox[{
            SqrtBox["l"], " ", 
            RowBox[{"Log", "[", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", "b"}], " ", "x"}]], "]"}]}]}], "b"]], " ", 
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"HypergeometricU", "[", 
         RowBox[{
          RowBox[{"-", 
           FractionBox[
            RowBox[{
             RowBox[{"-", "b"}], "+", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", 
              SqrtBox["d"]}], "-", 
             RowBox[{"2", " ", 
              SqrtBox["l"]}]}], 
            RowBox[{"2", " ", "b"}]]}], ",", 
          RowBox[{"1", "+", 
           FractionBox[
            RowBox[{"2", " ", 
             SqrtBox["l"]}], "b"]}], ",", 
          FractionBox[
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            SqrtBox["d"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "b"}], " ", "x"}]]}], "b"]}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", 
            SqrtBox["d"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "b"}], " ", "x"}]]}], "+", 
           RowBox[{
            SqrtBox["l"], " ", 
            RowBox[{"Log", "[", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", "b"}], " ", "x"}]], "]"}]}]}], "b"]], " ", 
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"LaguerreL", "[", 
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"-", "b"}], "+", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", 
             SqrtBox["d"]}], "-", 
            RowBox[{"2", " ", 
             SqrtBox["l"]}]}], 
           RowBox[{"2", " ", "b"}]], ",", 
          FractionBox[
           RowBox[{"2", " ", 
            SqrtBox["l"]}], "b"], ",", 
          FractionBox[
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            SqrtBox["d"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "b"}], " ", "x"}]]}], "b"]}], "]"}]}]}]}], "]"}]}],
    "}"}], "}"}]], "Output",
 ImageSize->{573, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.6",
 CellLabel->"Out[5]=",
 CellID->134713288]
}, Open  ]],

Cell[TextData[{
 "This verifies the solution using random values of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["l", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.1.6",
 CellID->8360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"expr", "/.", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", " ", 
       RowBox[{"RandomComplex", "[", "]"}]}], ",", " ", 
      RowBox[{"b", "\[Rule]", " ", 
       RowBox[{"RandomComplex", "[", "]"}]}], ",", " ", 
      RowBox[{"d", "\[Rule]", " ", 
       RowBox[{"RandomComplex", "[", "]"}]}], ",", " ", 
      RowBox[{"l", "\[Rule]", " ", 
       RowBox[{"RandomComplex", "[", "]"}]}]}], "}"}]}], "//", "Simplify"}], "//",
   "Chop"}]], "Input",
 CellTags->"b:1.1.1.6",
 CellLabel->"In[6]:=",
 CellID->13330],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.6",
 CellLabel->"Out[6]=",
 CellID->81614344]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->847581911],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Equations with Non-Rational Coefficients - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/\
DSolveLinearSecondOrderODEsWithRationalCoefficients"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveLinearSecondOrderInhomogeneousEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 37.6883670}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The ODEs that arise in practical applications often have non-rational \
coefficients. In such cases, DSolve attempts to convert the equation into one \
with rational coefficients using a suitable coordinate transformation. Here \
is an equation that has Exp[x] as a coefficient. It is solved by transforming \
it to Bessel's equation. This equation (equation 2.437, page 507 of [K59]) \
has trigonometric coefficients. The solution is given in terms of elementary \
functions.", "synonyms" -> {}, "title" -> 
    "Equations with Non-Rational Coefficients", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveLinearSecondOrderODEsWithNonRationalCoefficients"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:24"->{
  Cell[1280, 43, 107, 2, 70, "Title",
   CellTags->{"c:24", "b:1.1.1.6"},
   CellID->28614]},
 "b:1.1.1.6"->{
  Cell[1280, 43, 107, 2, 70, "Title",
   CellTags->{"c:24", "b:1.1.1.6"},
   CellID->28614],
  Cell[1390, 47, 408, 11, 70, "Text",
   CellTags->"b:1.1.1.6",
   CellID->18598],
  Cell[1801, 60, 363, 12, 70, "MathCaption",
   CellTags->"b:1.1.1.6",
   CellID->28458],
  Cell[2189, 76, 404, 15, 28, "Input",
   CellTags->"b:1.1.1.6",
   CellID->2661],
  Cell[2596, 93, 982, 31, 61, "Output",
   CellTags->"b:1.1.1.6",
   CellID->95604359],
  Cell[3593, 127, 315, 9, 70, "MathCaption",
   CellTags->"b:1.1.1.6",
   CellID->32756],
  Cell[3933, 140, 862, 28, 65, "Input",
   CellTags->"b:1.1.1.6",
   CellID->20807],
  Cell[4798, 170, 907, 31, 57, "Output",
   CellTags->"b:1.1.1.6",
   CellID->501755109],
  Cell[5720, 204, 300, 8, 70, "MathCaption",
   CellTags->"b:1.1.1.6",
   CellID->19489],
  Cell[6045, 216, 595, 19, 28, "Input",
   CellTags->"b:1.1.1.6",
   CellID->19435],
  Cell[6643, 237, 744, 24, 36, "Output",
   CellTags->"b:1.1.1.6",
   CellID->343279969],
  Cell[7402, 264, 399, 14, 70, "MathCaption",
   CellTags->"b:1.1.1.6",
   CellID->32075],
  Cell[7804, 280, 637, 23, 70, "Input",
   CellTags->"b:1.1.1.6",
   CellID->7586],
  Cell[8466, 307, 228, 8, 70, "Input",
   CellTags->"b:1.1.1.6",
   CellID->1386],
  Cell[8697, 317, 2968, 88, 137, "Output",
   CellTags->"b:1.1.1.6",
   CellID->134713288],
  Cell[11680, 408, 414, 16, 70, "MathCaption",
   CellTags->"b:1.1.1.6",
   CellID->8360],
  Cell[12119, 428, 662, 20, 70, "Input",
   CellTags->"b:1.1.1.6",
   CellID->13330],
  Cell[12784, 450, 181, 6, 36, "Output",
   CellTags->"b:1.1.1.6",
   CellID->81614344]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:24", 15916, 531},
 {"b:1.1.1.6", 16026, 535}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 107, 2, 70, "Title",
 CellTags->{"c:24", "b:1.1.1.6"},
 CellID->28614],
Cell[1390, 47, 408, 11, 70, "Text",
 CellTags->"b:1.1.1.6",
 CellID->18598],
Cell[1801, 60, 363, 12, 70, "MathCaption",
 CellTags->"b:1.1.1.6",
 CellID->28458],
Cell[CellGroupData[{
Cell[2189, 76, 404, 15, 28, "Input",
 CellTags->"b:1.1.1.6",
 CellID->2661],
Cell[2596, 93, 982, 31, 61, "Output",
 CellTags->"b:1.1.1.6",
 CellID->95604359]
}, Open  ]],
Cell[3593, 127, 315, 9, 70, "MathCaption",
 CellTags->"b:1.1.1.6",
 CellID->32756],
Cell[CellGroupData[{
Cell[3933, 140, 862, 28, 65, "Input",
 CellTags->"b:1.1.1.6",
 CellID->20807],
Cell[4798, 170, 907, 31, 57, "Output",
 CellTags->"b:1.1.1.6",
 CellID->501755109]
}, Open  ]],
Cell[5720, 204, 300, 8, 70, "MathCaption",
 CellTags->"b:1.1.1.6",
 CellID->19489],
Cell[CellGroupData[{
Cell[6045, 216, 595, 19, 28, "Input",
 CellTags->"b:1.1.1.6",
 CellID->19435],
Cell[6643, 237, 744, 24, 36, "Output",
 CellTags->"b:1.1.1.6",
 CellID->343279969]
}, Open  ]],
Cell[7402, 264, 399, 14, 70, "MathCaption",
 CellTags->"b:1.1.1.6",
 CellID->32075],
Cell[7804, 280, 637, 23, 70, "Input",
 CellTags->"b:1.1.1.6",
 CellID->7586],
Cell[CellGroupData[{
Cell[8466, 307, 228, 8, 70, "Input",
 CellTags->"b:1.1.1.6",
 CellID->1386],
Cell[8697, 317, 2968, 88, 137, "Output",
 CellTags->"b:1.1.1.6",
 CellID->134713288]
}, Open  ]],
Cell[11680, 408, 414, 16, 70, "MathCaption",
 CellTags->"b:1.1.1.6",
 CellID->8360],
Cell[CellGroupData[{
Cell[12119, 428, 662, 20, 70, "Input",
 CellTags->"b:1.1.1.6",
 CellID->13330],
Cell[12784, 450, 181, 6, 36, "Output",
 CellTags->"b:1.1.1.6",
 CellID->81614344]
}, Open  ]],
Cell[CellGroupData[{
Cell[13002, 461, 72, 1, 70, "RelatedTutorialsSection",
 CellID->847581911],
Cell[13077, 464, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[13281, 471, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

