(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16023,        562]
NotebookOptionsPosition[     10598,        381]
NotebookOutlinePosition[     12020,        420]
CellTagsIndexPosition[     11977,        417]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA OVERVIEW", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Differential Equation Solving with DSolve", "TOCDocumentTitle",
 CellID->942062912],

Cell[TextData[ButtonBox["Introduction to Differential Equation Solving with \
DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveIntroduction"]], "TOCChapter",
 CellID->24464],

Cell[TextData[ButtonBox["Classification of Differential Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveClassificationOfDifferentialEquations"]], \
"TOCChapter",
 CellID->18467],

Cell[CellGroupData[{

Cell["Ordinary Differential Equations (ODEs)", "TOCChapter",
 CellID->401953607],

Cell[TextData[ButtonBox["Overview of ODEs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveIntroductionToODEs"]], "TOCSection",
 CellID->28145],

Cell[CellGroupData[{

Cell["First-Order ODEs", "TOCSection",
 CellID->19895],

Cell[TextData[ButtonBox["Straight Integration",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveStraightIntegration"]], "TOCSubsection",
 CellID->21726],

Cell[TextData[ButtonBox["Separable Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveSeparableEquations"]], "TOCSubsection",
 CellID->26962],

Cell[TextData[ButtonBox["Homogeneous Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveHomogeneousEquations"]], "TOCSubsection",
 CellID->23281],

Cell[TextData[ButtonBox["Linear Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveLinearFirstOrderEquations"]], "TOCSubsection",
 CellID->9961],

Cell[TextData[ButtonBox["Inverse Linear Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveInverseLinearEquations"]], "TOCSubsection",\

 CellID->2995],

Cell[TextData[ButtonBox["Bernoulli Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveBernoulliEquations"]], "TOCSubsection",
 CellID->4827],

Cell[TextData[ButtonBox["Riccati Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveRiccatiEquations"]], "TOCSubsection",
 CellID->32391],

Cell[TextData[ButtonBox["Exact Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveExactEquations"]], "TOCSubsection",
 CellID->3902],

Cell[TextData[ButtonBox["Clairaut Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveClairautEquations"]], "TOCSubsection",
 CellID->292],

Cell[TextData[ButtonBox["Abel Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveAbelEquations"]], "TOCSubsection",
 CellID->17421],

Cell[TextData[ButtonBox["Chini Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveChiniEquations"]], "TOCSubsection",
 CellID->19718]
}, Open  ]],

Cell[CellGroupData[{

Cell["Linear Second-Order ODEs", "TOCSection",
 CellID->26299],

Cell[TextData[ButtonBox["Overview of Linear Second-Order ODEs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveIntroductionToLinearSecondOrderODEs"]], \
"TOCSubsection",
 CellID->1869],

Cell[TextData[ButtonBox["Equations with Constant Coefficients",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveLinearSecondOrderEquationsWithConstantCoefficients"]]\
, "TOCSubsection",
 CellID->14771],

Cell[TextData[ButtonBox["Euler and Legendre Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveSecondOrderEulerAndLegendreEquations"]], \
"TOCSubsection",
 CellID->19912],

Cell[TextData[ButtonBox["Exact Linear Second-Order Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveExactLinearSecondOrderODEs"]], "TOCSubsection",
 CellID->17035],

Cell[TextData[ButtonBox["Equations with Solutions Involving Special \
Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveLinearSecondOrderSpecialFunctionODEs"]], \
"TOCSubsection",
 CellID->28703],

Cell[TextData[ButtonBox["Equations with Rational Coefficients",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveLinearSecondOrderODEsWithRationalCoefficients"]], \
"TOCSubsection",
 CellID->17673],

Cell[TextData[ButtonBox["Equations with Non-Rational Coefficients",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveLinearSecondOrderODEsWithNonRationalCoefficients"]], \
"TOCSubsection",
 CellID->7711],

Cell[TextData[ButtonBox["Inhomogeneous Linear Second-Order Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveLinearSecondOrderInhomogeneousEquations"]], \
"TOCSubsection",
 CellID->25547]
}, Open  ]],

Cell[TextData[ButtonBox["Nonlinear Second-Order ODEs ",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveNonlinearSecondOrderODEs"]], "TOCSection",\

 CellID->23811],

Cell[CellGroupData[{

Cell["Higher-Order ODEs", "TOCSection",
 CellID->30333],

Cell[TextData[ButtonBox["Overview of Higher-Order ODEs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveIntroductionToHigherOrderODEs"]], "TOCSubsection",
 CellID->4664],

Cell[TextData[ButtonBox["Equations with Constant Coefficients",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveHigherOrderODEsWithConstantCoefficients"]], \
"TOCSubsection",
 CellID->32757],

Cell[TextData[ButtonBox["Euler and Legendre Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveHigherOrderEulerAndLegendreEquations"]], \
"TOCSubsection",
 CellID->12859],

Cell[TextData[ButtonBox["Exact Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveHigherOrderExactEquations"]], "TOCSubsection",
 CellID->9741],

Cell[TextData[ButtonBox["Other Types of Higher-Order ODEs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveFurtherHigherOrderODEs"]], "TOCSubsection",\

 CellID->778]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systems of ODEs", "TOCSection",
 CellID->6868],

Cell[TextData[ButtonBox["Introduction to Systems of ODEs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveIntroductionToSystemsOfODEs"]], "TOCSubsection",
 CellID->27644],

Cell[TextData[ButtonBox["Linear Systems of ODEs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveSystemsOfLinearODEs"]], "TOCSubsection",
 CellID->3035],

Cell[TextData[ButtonBox["Nonlinear Systems of ODEs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveSystemsOfNonlinearODEs"]], "TOCSubsection",\

 CellID->288]
}, Open  ]],

Cell[TextData[ButtonBox["Nonlinear ODEs with Lie Symmetries",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveLieSymmetryMethods"]], "TOCSection",
 CellID->8942]
}, Open  ]],

Cell[CellGroupData[{

Cell["Partial Differential Equations (PDEs)", "TOCChapter",
 CellID->22190],

Cell[TextData[ButtonBox["Introduction to PDEs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveIntroductionToPDEs"]], "TOCSection",
 CellID->27446],

Cell[CellGroupData[{

Cell["First-Order PDEs", "TOCSection",
 CellID->24370],

Cell[TextData[ButtonBox["Linear and Quasi-Linear PDEs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveLinearAndQuasiLinearFirstOrderPDEs"]], \
"TOCSubsection",
 CellID->15006],

Cell[TextData[ButtonBox["Nonlinear PDEs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveNonlinearFirstOrderPDEs"]], "TOCSubsection",
 CellID->9040]
}, Open  ]],

Cell[TextData[ButtonBox["Second-Order PDEs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveSecondOrderPDEs"]], "TOCSection",
 CellID->23805]
}, Open  ]],

Cell[CellGroupData[{

Cell["Differential-Algebraic Equations (DAEs)", "TOCChapter",
 CellID->745247920],

Cell[TextData[ButtonBox["Introduction to DAEs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveIntroductionToDAEs"]], "TOCSection",
 CellID->6334],

Cell[TextData[ButtonBox["Examples of DAEs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveExamplesOfDAEs"]], "TOCSection",
 CellID->22648]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initial and Boundary Value Problems", "TOCChapter",
 CellID->485888982],

Cell[TextData[ButtonBox["Introduction to Initial and Boundary Value Problems",
 
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveIntroductionToBVPs"]], "TOCSection",
 CellID->19169],

Cell[TextData[ButtonBox["Linear IVPs and BVPs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveLinearBVPs"]], "TOCSection",
 CellID->6729],

Cell[TextData[ButtonBox["Nonlinear IVPs and BVPs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveNonlinearBVPs"]], "TOCSection",
 CellID->31101],

Cell[TextData[ButtonBox["IVPs with Piecewise Coefficients",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolvePiecewiseBVPs"]], "TOCSection",
 CellID->3548]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Working with DSolve\[LongDash]A User\[CloseCurlyQuote]s Guide\
\>", "TOCChapter",
 CellID->470679011],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WorkingWithDSolveIntroduction"]], "TOCSection",
 CellID->11478],

Cell[TextData[ButtonBox["Setting Up the Problem",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveSettingUpTheProblem"]], "TOCSection",
 CellID->12623],

Cell[TextData[ButtonBox["Verification of the Solution",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveSolutionVerification"]], "TOCSection",
 CellID->19954],

Cell[TextData[ButtonBox["Plotting the Solution",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolvePlottingTheSolution"]], "TOCSection",
 CellID->11840],

Cell[TextData[ButtonBox["Generated Parameters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveGeneratedParametersOption"]], "TOCSection",\

 CellID->7376],

Cell[TextData[ButtonBox["Symbolic Parameters and Inexact Quantities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/DSolveSymbolicAndInexactQuantities"]], "TOCSection",
 CellID->26308],

Cell[TextData[ButtonBox["Is the Problem Well-Posed?",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveWellPosedness"]], "TOCSection",
 CellID->32439]
}, Open  ]],

Cell[TextData[ButtonBox["References",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveReferences"]], "TOCChapter",
 CellID->2108166046],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Differential Equation Solving with DSolve - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 42.7041204}", "context" -> "`", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Overview", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Introduction to Differential Equation Solving with DSolve Classification \
of Differential Equations Ordinary Differential Equations (ODEs)", 
    "synonyms" -> {}, "title" -> "Differential Equation Solving with DSolve", 
    "type" -> "Overview", "uri" -> "tutorial/DSolveOverview"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[704, 27, 89, 1, 70, "TOCDocumentTitle",
 CellID->942062912],
Cell[796, 30, 189, 4, 70, "TOCChapter",
 CellID->24464],
Cell[988, 36, 200, 5, 70, "TOCChapter",
 CellID->18467],
Cell[CellGroupData[{
Cell[1213, 45, 80, 1, 70, "TOCChapter",
 CellID->401953607],
Cell[1296, 48, 152, 3, 70, "TOCSection",
 CellID->28145],
Cell[CellGroupData[{
Cell[1473, 55, 54, 1, 70, "TOCSection",
 CellID->19895],
Cell[1530, 58, 160, 3, 70, "TOCSubsection",
 CellID->21726],
Cell[1693, 63, 158, 3, 70, "TOCSubsection",
 CellID->26962],
Cell[1854, 68, 162, 3, 70, "TOCSubsection",
 CellID->23281],
Cell[2019, 73, 164, 4, 70, "TOCSubsection",
 CellID->9961],
Cell[2186, 79, 168, 4, 70, "TOCSubsection",
 CellID->2995],
Cell[2357, 85, 157, 3, 70, "TOCSubsection",
 CellID->4827],
Cell[2517, 90, 154, 3, 70, "TOCSubsection",
 CellID->32391],
Cell[2674, 95, 149, 3, 70, "TOCSubsection",
 CellID->3902],
Cell[2826, 100, 154, 3, 70, "TOCSubsection",
 CellID->292],
Cell[2983, 105, 148, 3, 70, "TOCSubsection",
 CellID->17421],
Cell[3134, 110, 150, 3, 70, "TOCSubsection",
 CellID->19718]
}, Open  ]],
Cell[CellGroupData[{
Cell[3321, 118, 62, 1, 70, "TOCSection",
 CellID->26299],
Cell[3386, 121, 196, 5, 70, "TOCSubsection",
 CellID->1869],
Cell[3585, 128, 212, 5, 70, "TOCSubsection",
 CellID->14771],
Cell[3800, 135, 190, 5, 70, "TOCSubsection",
 CellID->19912],
Cell[3993, 142, 185, 4, 70, "TOCSubsection",
 CellID->17035],
Cell[4181, 148, 216, 6, 70, "TOCSubsection",
 CellID->28703],
Cell[4400, 156, 207, 5, 70, "TOCSubsection",
 CellID->17673],
Cell[4610, 163, 213, 5, 70, "TOCSubsection",
 CellID->7711],
Cell[4826, 170, 208, 5, 70, "TOCSubsection",
 CellID->25547]
}, Open  ]],
Cell[5049, 178, 172, 4, 70, "TOCSection",
 CellID->23811],
Cell[CellGroupData[{
Cell[5246, 186, 55, 1, 70, "TOCSection",
 CellID->30333],
Cell[5304, 189, 181, 4, 70, "TOCSubsection",
 CellID->4664],
Cell[5488, 195, 201, 5, 70, "TOCSubsection",
 CellID->32757],
Cell[5692, 202, 190, 5, 70, "TOCSubsection",
 CellID->12859],
Cell[5885, 209, 163, 4, 70, "TOCSubsection",
 CellID->9741],
Cell[6051, 215, 175, 4, 70, "TOCSubsection",
 CellID->778]
}, Open  ]],
Cell[CellGroupData[{
Cell[6263, 224, 52, 1, 70, "TOCSection",
 CellID->6868],
Cell[6318, 227, 182, 4, 70, "TOCSubsection",
 CellID->27644],
Cell[6503, 233, 161, 3, 70, "TOCSubsection",
 CellID->3035],
Cell[6667, 238, 168, 4, 70, "TOCSubsection",
 CellID->288]
}, Open  ]],
Cell[6850, 245, 169, 3, 70, "TOCSection",
 CellID->8942]
}, Open  ]],
Cell[CellGroupData[{
Cell[7056, 253, 75, 1, 70, "TOCChapter",
 CellID->22190],
Cell[7134, 256, 156, 3, 70, "TOCSection",
 CellID->27446],
Cell[CellGroupData[{
Cell[7315, 263, 54, 1, 70, "TOCSection",
 CellID->24370],
Cell[7372, 266, 188, 5, 70, "TOCSubsection",
 CellID->15006],
Cell[7563, 273, 160, 4, 70, "TOCSubsection",
 CellID->9040]
}, Open  ]],
Cell[7738, 280, 150, 3, 70, "TOCSection",
 CellID->23805]
}, Open  ]],
Cell[CellGroupData[{
Cell[7925, 288, 81, 1, 70, "TOCChapter",
 CellID->745247920],
Cell[8009, 291, 155, 3, 70, "TOCSection",
 CellID->6334],
Cell[8167, 296, 148, 3, 70, "TOCSection",
 CellID->22648]
}, Open  ]],
Cell[CellGroupData[{
Cell[8352, 304, 77, 1, 70, "TOCChapter",
 CellID->485888982],
Cell[8432, 307, 189, 4, 70, "TOCSection",
 CellID->19169],
Cell[8624, 313, 147, 3, 70, "TOCSection",
 CellID->6729],
Cell[8774, 318, 154, 3, 70, "TOCSection",
 CellID->31101],
Cell[8931, 323, 162, 3, 70, "TOCSection",
 CellID->3548]
}, Open  ]],
Cell[CellGroupData[{
Cell[9130, 331, 111, 3, 70, "TOCChapter",
 CellID->470679011],
Cell[9244, 336, 153, 3, 70, "TOCSection",
 CellID->11478],
Cell[9400, 341, 159, 3, 70, "TOCSection",
 CellID->12623],
Cell[9562, 346, 166, 3, 70, "TOCSection",
 CellID->19954],
Cell[9731, 351, 158, 3, 70, "TOCSection",
 CellID->11840],
Cell[9892, 356, 164, 4, 70, "TOCSection",
 CellID->7376],
Cell[10059, 362, 191, 4, 70, "TOCSection",
 CellID->26308],
Cell[10253, 368, 157, 3, 70, "TOCSection",
 CellID->32439]
}, Open  ]],
Cell[10425, 374, 143, 3, 70, "TOCChapter",
 CellID->2108166046],
Cell[10571, 379, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

