(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    271826,       5341]
NotebookOptionsPosition[    260194,       4940]
NotebookOutlinePosition[    267235,       5156]
CellTagsIndexPosition[    267140,       5150]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Plotting the Solution", "Title",
 CellTags->{"c:54", "b:5.3"},
 CellID->3989],

Cell[TextData[{
 "A plot of the solution given by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can give useful information about the nature of the solution, for \
instance, whether it is oscillatory in nature. It can also serve as a means \
of solution verification if the shape of the graph is known from theory or \
from plotting the vector field associated with the differential equation. A \
few examples that use different ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics functions follow."
}], "Text",
 CellTags->"b:5.3",
 CellID->9320],

Cell["\<\
Here is the general solution to a linear first-order equation.\
\>", "MathCaption",
 CellTags->"b:5.3",
 CellID->23165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], " ", "+", 
      RowBox[{"x", "*", 
       RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", "^", "2"}], "]"}]}], ",", "y", ",", " ", "x"}], 
   "]"}]}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[1]:=",
 CellID->15431],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["x", "2"], "2"]}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["x", "2"], "2"]}]], " ", 
        SqrtBox[
         FractionBox["\[Pi]", "10"]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox[
            RowBox[{"1", "+", 
             RowBox[{"2", " ", "\[ImaginaryI]"}]}]], " ", 
           RowBox[{"Erfi", "[", 
            RowBox[{
             SqrtBox[
              RowBox[{
               FractionBox["1", "2"], "-", "\[ImaginaryI]"}]], " ", "x"}], 
            "]"}]}], "+", 
          RowBox[{
           SqrtBox[
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "\[ImaginaryI]"}]}]], " ", 
           RowBox[{"Erfi", "[", 
            RowBox[{
             SqrtBox[
              RowBox[{
               FractionBox["1", "2"], "+", "\[ImaginaryI]"}]], " ", "x"}], 
            "]"}]}]}], ")"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{556, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[1]=",
 CellID->527049100]
}, Open  ]],

Cell[TextData[{
 "The solution can be plotted for specific values of the constant ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ". The use of ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " reduces the time taken by ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " and can also help in cases where the solution has discontinuities."
}], "MathCaption",
 CellTags->"b:5.3",
 CellID->11293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "/.", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], " ", "\[Rule]", " ", "1"}], "}"}]}], 
    "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "7"}], ",", " ", "7"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}]}], "]"}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[2]:=",
 CellID->17206],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydWjuoZWcV3jn7ce69uXfeGbWRdBY22sQqiRgnyWSM8RUTEYtxEGYKE41j
o4022mijjYGQFEkEE4uIISJEEANiQAyIAVFBIkgsEgSDxYBw/P7/W//61l5n
H8N4mHtm73+v57ce/2Ofey9evfyFL168euXSxZvveuTily5fufSVm+98+BEM
9Td0Xfc8/r78zg7XG1zVv+c3G/zP78/ge9Xxf/vuC039dA/W0ZNG84709MZ6
/+c/vWH3E74GPD6T6E7beOY/Y3JPVi0nyvegp113NtEf1PtfvPiXB+7/4Xe/
81K3F553C3rPpOdZ/+ktjdWGqqcMr7aeH7cnXW8iCxX+KhLjx+978s03/33p
8z8mJJW1X9IZ7m9K94f1/tq1/3z7W7/82Qt/7MaI6YKt26hVysm9fu21f144
/8TTT71S0Rpf/s3fvnr1BVw++8zvv/+9X3f7Sf+pdJ9jUD0dwAz76OlQ5bo+
fEPlTmzLd29I1tx59AcvV1LLhW6A4J889ypCDCzXVTbshEJcvv76vzD+f9pM
a+n22LT1uIHIV37395q9Xf/WW9cAfrncN0uZnSfn/oBsrPTghIhqZr2HFuAL
B4JHwB8ykbEYrh5NniP4QD38GrfwojwIhzwQ1MxYLWZCzZkRcCEBhZJ8hP6X
fvXXr3/t5yYTxly5/BzEms/IM5O1SsgxZtXmHlG1UeY0AgdNjYua4JehRxrY
AU2o2IpGN8BpkACzhx/66djyBte4NAtpkftiFrEYGsqrhs74xOO/BUDIaUhF
SKwjbXeYo4o67PjmN17cQr3YAAUwnIEyW2kQUIL4OtIjd0CBb8V2orv84BoR
HpsHEVPzCyrP3fEYkDN82MuK3/V+oN/0tg+IsWpZaShlCIAuUBaf4ygzE0aa
Pq92wxHmIQ29JibE9HOf/RENZWVkBNkzgTOEwhbW3uQViQ8ghRtE0uNE2AxJ
jlL+0KoEPFBNih5XyIJSNZ5b0De7B04lNn1AE1bhAQA19IAjpBIW9m5GHMph
AmloBUEicuBCqHHJC1o0+Sg+rNaaeVBJixgXR3IdEVFsDhKaZ0NM+U08Yz9Q
h6r102oMmokmsELYyF1tGekNLvFdtNJ3xpZZ3DfUkSal7knBjEdCvPqHfwRc
B4QCJUqbSEnBDCpH6C9bTT/HkYzqANmDifMkvWVu0FuXYNmqijxo94Zrn7pC
nhHOLmbjuklBykiLIlmlTo7mpjWl7XEIgJjKP5JG+UN8WGnkqSN7vHafMEbN
o5A/IM5pvsMF0hyRoz7PlRjt0XEmM0cn76NzX7b6q/oC69EjZEijiSNHhLT6
Sp/ulyNBU3HJgrRICHmPt0WGiDuy+NDi7XFaRgwcN1vb1NFjngUsHFy4tQ5l
qLm6YO6Iw3FcsHls6qqmNKyuczW0CSOwAHZYJBAouk81HF1jiL56NDtfYTo6
ZcQ7TMl7Lqp4X3KL90PD2FYeeY3p97MYcqYtK52d9HY/vM3zfM/olayjfbw3
Zb6SwQXSbMZv1Ut6ziOOijowRnhdx/dJRNURuTLrVYrjrE4MMawqzWoBE53J
4JGmjXuxi2/3PAabQlctJsxExW2kdlxGtBe88ZmPSWkouAUWhVxpGXXV0Nii
YFmxl+hvaiiHKBWrpxAt6fG0Nz3Ci9FxPZu2lmL2+4rCVqFV2glSyNau4xrQ
mTetG7JLVptsVscI0IqzEWMSevBARFnptMO7tfV+xib3TsbG107+gNhrfiEG
FKXYuA7DWtj73oA+7ohFmBsTPfmV3bTT8du0ZR5XMM5nDYnrBHKHrm/rMJbA
qmELBsSszeI9UEWB+UrcsoHaSvvrm6doeFBqMaJMzhocgUCI5XTNEWY28yPZ
HXYsEcVVQoHPNTetU+b67sZWDRn1MylqfaJnVD2DbY/h+m2HMszzK45aHnKn
R69ZRxzvm70YwT+tYuBSWesScVqBINgpgs+NYNS6iqEu1Ux6JDCeyxJiy8ym
xe4ng0XvZjlFz4mq+tWUUOJzrQjWiyhzSlSt5P7iezFD2Z/b5Mj9MLUQz2FH
puECycPtQd/qiFltupBe4Cm2E+ETbXS2V0VE4XTZaVMTHkKo1v5tXUxkqiT1
eobZsKALwk51zefq8cvYzVdjvm4OfG0vUk0nSIYYI058hhY5Oy/zrtTOp9pz
0153Mt276yhILP5jy2M4TpTpu2eITdzrFNcpVTOfa8Ys972f2jHGskp0XjWx
ygfmF6vAT24QrAKKnyGYX++qfr2nYWje0wtirZ1FXplOqRr8LMR6xHIEd88U
9EY9jfKhDKgV299bbX1fyGwgj2f7iS/PEHuLcrNdmnFY/Y7qps2/e602AFSp
GNrz/joKS+ychdaoBwwJtf0Us2zN6ZZ5tt6vz2fzMPPmlqr91sUMcWrTpupY
1pZiOnmH8hSO2rT+yf1rPz1f1qZ1G88wibzyLOpSNuUZ6WAxG7Mu9Yuqy844
aOEHqp7bUnasko2+vw7xKGpOJ2QpH3QoCJiEBI3ylfWUrz7IUyWtdcdFP1Rl
e80eszdqyesD5fSNScqyFlnxIUmdfKvtlXCUfFiW5jOASbu9knpl2G6cstKc
t3WCrS5xR5DFTgj7YHjJiaOUE8uy9JyyPrixGrKZ8ViK+LIUWUwpn0gIDpYn
p1JkIrXikfeVp1J2RS7hvszFis1csneZSx0rcuW1SuZShkUuRWuZ6/ZbH7V7
cn2yjuaTFXHVNwy952H34cAluwvXyhGX5ZFanXJZh1CKXOqny1x6HrnyPJ25
ZAu57jH7I3XdVdb3B34YvfUmgtLUYSjtfIU/vgvx1ers7CTLUQbvkuPzetid
+9ugEMW35Z+daKY3K6H+zu2QM3tTZXWyLEuzyP+S1UY4Z2R0KEnzwrlZzNbN
lpHLWRds2ag5kXyfqqP5rHGuraxi76zU95dv7bZmkrUTPyfawatiE94jhxwJ
tKP3i5lc5UGkjesQ0arTR9p4Ftm5DeoN0be41xKtOnWk9cyY0araSPvpioO8
aHRaEQS6gIzewKrPRonKtSZREYh00tPotE6KdNoBNTr11EinXGl06qKke6CO
2vFN1/Zy4rsrUNnGyKnULSNVOHfEH+dFdchIybyQPM13kcoOBJxKWEYqRl1U
miUjlb3Mcyr9toBU9fcZPc8ly+XxgE6mKmfRpDqWcvTuQFXOzfk5lrIzUpXT
iihLeRmpCL6oNINEKgZSVMo0UpXu07dzx3j+2YWTZevGRyHuknAhcfLcIHZG
n8GtPo4arib3uuVYxP3XHNblz1+HnEJwmGJwPfyVwmaEwxSl65ZjR+qHKY7n
PUIrm3tnUbECJJdWAuTy3xrZGvkwxS5R2QnLYcpwUfkvEMx67tPUGe6RPPOR
Th0kbLbpWHWkU81v09GRg5TF23TsLqRTRW/TcS1IOs0+gW70WDFVbd+kfLmQ
0Nn4aQ0p1b8vLEk1zPeSR4u0doZLWnX3QDs57aa9f/GTG+tEH9lBTWRJrd68
i5p9fkpWB+p1pOb5WEEvny+LQ/1H82V+83nvPF8tC8mVd/iqhWWuSrWOv0Hg
WVCpwY/u5ph8l7hpb9bvW6TmCSdsBzWgwhrsY4t0RARSrSaXqR6c4cQ7/rqw
u+G/kN8qXg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[2]=",
 CellID->10715922]
}, Open  ]],

Cell["\<\
Here is the plot for a linear second-order ODE with initial values prescribed \
at 0.\
\>", "MathCaption",
 CellTags->"b:5.3",
 CellID->16948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "/", 
        RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", 
       RowBox[{
        RowBox[{"-", "4"}], "*", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "x"}], "/", "4"}], "]"}]}]}], ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", 
       RowBox[{"1", "/", "2"}]}]}], "}"}], ",", "y", ",", "x"}], 
   "]"}]}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[3]:=",
 CellID->2206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"BesselJ", "[", 
           RowBox[{"0", ",", 
            RowBox[{"16", " ", 
             SqrtBox[
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"-", "x"}], "/", "4"}]]]}]}], "]"}], " ", 
          RowBox[{"BesselY", "[", 
           RowBox[{"0", ",", "16"}], "]"}]}], "-", 
         RowBox[{
          RowBox[{"BesselJ", "[", 
           RowBox[{"0", ",", "16"}], "]"}], " ", 
          RowBox[{"BesselY", "[", 
           RowBox[{"0", ",", 
            RowBox[{"16", " ", 
             SqrtBox[
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"-", "x"}], "/", "4"}]]]}]}], "]"}]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"BesselJ", "[", 
           RowBox[{"1", ",", "16"}], "]"}], " ", 
          RowBox[{"BesselY", "[", 
           RowBox[{"0", ",", 
            RowBox[{"16", " ", 
             SqrtBox[
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"-", "x"}], "/", "4"}]]]}]}], "]"}]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"BesselJ", "[", 
           RowBox[{"0", ",", 
            RowBox[{"16", " ", 
             SqrtBox[
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"-", "x"}], "/", "4"}]]]}]}], "]"}], " ", 
          RowBox[{"BesselY", "[", 
           RowBox[{"1", ",", "16"}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"BesselJ", "[", 
             RowBox[{"1", ",", "16"}], "]"}], " ", 
            RowBox[{"BesselY", "[", 
             RowBox[{"0", ",", "16"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"BesselJ", "[", 
             RowBox[{"0", ",", "16"}], "]"}], " ", 
            RowBox[{"BesselY", "[", 
             RowBox[{"1", ",", "16"}], "]"}]}]}], ")"}]}], ")"}]}]}], "]"}]}],
    "}"}], "}"}]], "Output",
 ImageSize->{593, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[3]=",
 CellID->73909756]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[4]:=",
 CellID->18166],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[4]=",
 CellID->551627976]
}, Open  ]],

Cell["\<\
This nonlinear equation has two solutions that can be plotted on the same \
graph.\
\>", "MathCaption",
 CellTags->"b:5.3",
 CellID->16697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}], "\[Equal]", 
       RowBox[{"x", "-", 
        RowBox[{"x", "^", "3"}]}]}], ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", " ", 
    "y", ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[5]:=",
 CellID->31020],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"5", " ", 
          SqrtBox["x"], " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"]}]]}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SqrtBox["x"], " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}]]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["x", 
            RowBox[{"3", "/", "2"}]], " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}]], " ", 
           SqrtBox[
            RowBox[{"x", "-", 
             SuperscriptBox["x", "3"]}]]}], "+", 
          RowBox[{"4", " ", 
           SqrtBox[
            RowBox[{"x", "-", 
             SuperscriptBox["x", "3"]}]], " ", 
           RowBox[{"EllipticE", "[", 
            RowBox[{
             RowBox[{"ArcSin", "[", 
              SqrtBox["x"], "]"}], ",", 
             RowBox[{"-", "1"}]}], "]"}]}], "-", 
          RowBox[{"4", " ", 
           SqrtBox[
            RowBox[{"x", "-", 
             SuperscriptBox["x", "3"]}]], " ", 
           RowBox[{"EllipticF", "[", 
            RowBox[{
             RowBox[{"ArcSin", "[", 
              SqrtBox["x"], "]"}], ",", 
             RowBox[{"-", "1"}]}], "]"}]}]}], ")"}]}]}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"5", " ", 
          SqrtBox["x"], " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"]}]]}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SqrtBox["x"], " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}]]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["x", 
            RowBox[{"3", "/", "2"}]], " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}]], " ", 
           SqrtBox[
            RowBox[{"x", "-", 
             SuperscriptBox["x", "3"]}]]}], "-", 
          RowBox[{"4", " ", 
           SqrtBox[
            RowBox[{"x", "-", 
             SuperscriptBox["x", "3"]}]], " ", 
           RowBox[{"EllipticE", "[", 
            RowBox[{
             RowBox[{"ArcSin", "[", 
              SqrtBox["x"], "]"}], ",", 
             RowBox[{"-", "1"}]}], "]"}]}], "+", 
          RowBox[{"4", " ", 
           SqrtBox[
            RowBox[{"x", "-", 
             SuperscriptBox["x", "3"]}]], " ", 
           RowBox[{"EllipticF", "[", 
            RowBox[{
             RowBox[{"ArcSin", "[", 
              SqrtBox["x"], "]"}], ",", 
             RowBox[{"-", "1"}]}], "]"}]}]}], ")"}]}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{588, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[5]=",
 CellID->563202646]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "100"}], ",", 
     RowBox[{"9", "/", "10"}]}], "}"}]}], "]"}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[6]:=",
 CellID->15529],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVmw2UVVUVxy9v5r03I7CgKNNqBcuWhVqurFYf2DgiiRApyxLN0AxIG1oK
gmCJLhRFUMM0SGMSIYVg8VENgRg1JkESJIEiCAHJh/K1YsIgqElq+p297z1z
7337wmMWrlWzhjvv47/3/p//3vvcc857XD5oVN2NtwwaNXTIoG6XjRx0a93Q
Ibd16z18JC9VtAuCdnVBEGw6I+BxC4/kX+eWlpagwj2SH/lztXsQnPp33BuX
8DfH34oYMnDP+Vcbfy/vvYSInoale5g7wXsfcA8qmw8f3da4dsWk+Y33PF00
ufYUXOvzIMinOF5UgiikfJQiKkteqS0D8173p7hr1abVUxcvGDxpRt8x0N7Y
8MLBnfuDctmnudWYcSvLZFQO5nRhfWDLG+vnLVsyqr6+ZgTXdbMaeSVoXybr
YgrxOTtuLCsXt4m9y62rji7C+UjTIapj2YQ5M/uPRe+VkxvQPuh0yjhH0Wyu
FWWOolOkL5o21D0KV6pi85LVsA/eWSbXUq+lNZvNNp/yX05VSOaLx5rf2r58
Pf03e8B9KExd79uwQyumhHU0RxRiPHKGzrWx1+O4yK46yi0aLR0znS7iShcd
2tsUnGlGdpdPiBUYqlhVpi7gzgiC92dafcw9KJAbRjZ34ERGSRExxG6ZFh8V
C+oMUbTsSCsN/sFMi3PFAioQYjA0F4NheB/KtPhw0oLhIwVT4Tli0THM0HWu
jUrs0887neD9/3e8VJerU2YC+krnXB4jV5A7SV95MyP/ayN+u/Gigqu+uJwI
nJ5F2qZmn9Tzy07wfg9hs3vtVvpNe0HZVKVw556SaJ9uCecDpgG6e9Gwx+hV
Sukzpnd3ebdYMO+smf5LZhDmAyYguvvCTAuZ8wtAcA2cOQdTZpCLMi1E6QI0
mAagBDHEgGTPTIsOYhHvCqYSRPx8psVpkjLmNb2datZVLxMvfVeAtirFrKZz
VF9vERlUxsaLQvyqQl/M9N0uxp6E63gJ1d+0+I8wZ3CeObUbfMnEvhWxZr5H
eMRU1leZ6H9GusOcewrMmetJ9TUm+qjw0L5Ryu5e+VUTezipnq/q60z0m5GC
CBdX8AYT3VSiHkEINdhE/0VYw1TvZ6F6N5rYfREPZIAEkmh3fNNE7xHPkKA2
8Izibh38rUR9vC4YXtfuJrpbwd1i+tsRywZ9AwGNPtxEvxbVs8+GW8+ONLFb
W8Ie1qqAr2ZjlIneHPGgdJAAA62Kb5voVyMeWp1cXVWMMbGvxKrT9xQ87jLR
LyV5aHWSnLtN9Npkl4Q87jWxL0Z6MDH5LoHHeBO9Kqo3nZ10PsN4YiLTK2Px
/XQUPGR6XBHFZ0Dx+JNM9LJYfCTDAPkwfsRE/yZZ7/BwFTfZxP46o95/YKKX
RvWuTRfW+w9N7BLBUpG+7l3X/cjELkqyoPSVxTQT3ZBUwxOZIWjdauuPtetO
3+N/VlI1Tq2n1ckJdhCVKV/zY9Udn3tnle3NHS7MjqrezwLafXMML9GOKD2q
2VGm9NYYzg3z2jSqmSWZdPfNn7bJ149bWus+numfl+Qu2iulR/ZkMvvaC0j+
C7NWnhDufp8RZvcZEztVPPu+0T0JgZ410Y8lc62dQwn/ykRL9yXub5rT50z0
I1EF+NWQ3t+WmehJkSKpldAKE/1QUpEwmys91kFlXkusSFWJVabH8TF0fEX5
ookeJ2hdf2qPqG5rTfTYJFrXnuj2som+MwO9wUR/JwO9yUSPzkBvMdEjY5rE
0X820cMtBUHvMNE3C1oz6NEo+LqJrnOXop4ykuxpvUZrOt3ZzJ5E1mVFVNRV
rJ5K+I1RsN/0PTjqAYqZIeoiBGJNJvqGqL9QUHuA1kHQN030wCRv2NBiiOju
OIdNi6+IhT+FSuyTj5oWV8Vi+DO28AToX6bFlVaMUM1/mxaXHyeGA+RMqy+I
FRgWGuk4DmDvPHuLFQqhExkk19jiIYpVbVq5U62ginLDvzIkNeRIj5YcpINp
J7u5Cn9CGeQo9KCCRzGenRMV1iMWiUohjD8q5EWHf5cZ6VPyHNWpTOCtkcKT
Zwc6w7T8uESks1CBuwU6oj6hoRxGtE/O5AysGt8AkQIZ62tG0Gm44QbiKsrB
upm23cUWBUCCx4qwjBXm5CXKxdmmrZyxVXpbKOeQKKjkAU8ZB6Ed8BzTWj9R
QCdYa+S4NS5x7IDnm9aiYHtkUbmQFwcMG8WgruGjvMpZZHh7j37SZ1HW3VtO
BtqjgY7Px9A7Aa9QCm7V7MCfFedpr7JEOO4aQ/b5HYmBIwoEp9DHO+1AJFKp
csQi1Z5MpIJ/hR+iMBPkcBdUaBR+gxxxgiKReEKx8S4JIZibSZ3VpScRz60I
g+LwmvEjez0w/urJY6+fVj9u0ZP3P7OwYWOQW7d2d1DR1HQktHCXPm1UTRCF
w4eb8cnvT2atmzF9zcOTVuSGD1sUVF7Zf2ZtTf3QuobRo5bkeCOoALNz58Eo
6iVtjOpOeoMOGzfsW71qF275Jdz1A+cSbMjgBQTjlecatwFw8Bp1UsYqUeaR
9lu3HFC/4+5phDtOce2d8q7A5USspBvkk672DNF7gJBqwGNeQQDUEvgFpgeZ
HU6DOrF0YP36zrhmwOw7xyz15g74EdNa5ofqvXsPrVi+3VtDf+KEZaQ+4t7d
tJWTwmq4P7tkMymE+KW9puEBP4wmYm2f58vcUN3cfAyC4FHLitvVtJVZoSoV
Fw8UU5jB95l2koEqYsKufupqJE7bvcfbObMLLTyyzp+3HoIO38WMUxvZoemU
ySvhx9iwY2Bayy32J2u9xA7dsGNcqEEaEYTEhs1nf4ooZ4tFcogeFA1NREgC
Q1sgVaZVP7FiIAwHEXRoUMSPQCpNqyvESscGRwhCMxarnWklZ4hFBm/EOmZa
DDhOnGbT4tpkDCRHCxRBuuCIaSFnhEX0RmBkRjdSjDU+gkOmxdfdpUCxwAQ+
SgkJD5roIYJWRmQE/4yE8RxIVNlNwgKW6IEqyhtGjF3PCUv8Do3xBqtqhiPd
bVrIOWCB0DpMehRKiL/LRN8qaBqTwSE81OkQhrHdRN8maESgRVQT+hn0NhN9
e6QJoDj6Tyb6jhI0TOD9qom+K0LDRHnrKF8x0XdHvHWUaEICkPAlE31vpAkp
VAURnBT80UTfH6HRW3tf0X9IZP6BZFZ82n9v+pQddYG3NesYYEY7vGCiHxY0
IQlMN2jtQWi5iX5U0FqDDA05tK6fN9FTBI2wWteaQ542mujHYznEMS1GEIgt
NdH17pKnw6DrWyGwz0bk3C6vcoDFArtgsYmdHulBcChAhCKB1EJBZ68w3fMK
Y0XxVKQBBYkAyKDVI+d8JSuU9Hc20t7k5C6P4Fpd4agXmL7Sa5D06eOcElXc
3XSu6Sv9HRn3vlsJzomppRkm1Yxudtle4s9lHHnEpqgYHd3gRjfL9HXitZyc
4eXpmkTWn1JwGWu2hclK8HPKdLNuFkfVq3MKrURD0YRPmGip0zxNqX3P1S2d
602s1L/rZxxqz2lFPm6iG5P15rtoiol+vqW1i/xEEXzfxP42xoPhKQ8Cfc9E
/y7GQ2dN1eO7Hu3AMoPl/fwX6vCg6XF1iQ46m0ww0Wui+Dqb+HzcZ6LXxfKh
U6CrlXEm9uWSutCaH2uiNyRrOuxY+/MlOenL+2kbC7fCuMPEyn3QzcQE9/MK
pG430XKPTcwbLs/2p22vRTpDRO8IWm8jTPTOiEeq3oYl8vxGss7C+DebHvdk
xB9qovdnxL/JRB8o4cH8EHzDxP41xoOpSMsCHoNM9N8iHoTXFYhWxddM9N/N
qrA/i/6HWRXXmthmqyp4an/rVFbUBV8VOt8y4C+baLmE86lfJugJpInNxfok
Pm9dkagMh9Tvv/g5y2vXL9O37FQKXj+/yuqTaSE7onCmac1870x8Ryv7FE6v
TIvOsQqIrxwuzrToYo2bpzWZFqfHxq0rV81vj0yLM5M59qtX+5TBXeQEsnUF
69eknxQLYwVU8g3k9J3UXbqKV13Dxle6elZxsmsXdzkr6ZGpQkd2vunReagM
Ws+w3Ity4lBgJkppc16mh/jazBpl96R23mN306PjYq083OW8pCfdcFIbZ5+0
J9Ej3ItqzehO6iwdR2wllP7eqKX6BVE96U4LhxBEwq6Z9SR1404dkEL39K37
bfv8xV2kPovaf37PTZ+4Nap9tu4uchJTZKy0Xnwn7fbI9lm+u8gnB607az2c
CmO9I9NKzhiLZMjHah1Xx0wrOWutAuPHpYcDkKQbWj8Riczk213h2YDu+vUW
Z3+73V3kE54KPecT40zk2/H/F4J2/wWcLJmR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[6]=",
 CellID->421314032]
}, Open  ]],

Cell["The solution to this Abel ODE is given in implicit form.", "MathCaption",
 CellTags->"b:5.3",
 CellID->30109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", 
       SuperscriptBox[
        RowBox[{"y", "[", "x", "]"}], "2"]}], "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"y", "[", "x", "]"}], "3"], "x"]}]}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[7]:=",
 CellID->17984],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way.\"\>"}]], "Message", "MSG",
 CellTags->"b:5.3",
 CellLabel->"During evaluation of In[7]:=",
 CellID->603560234],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "5"}], " ", "x"}], "\[Equal]", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", "x"}], "+", 
           FractionBox["1", 
            RowBox[{"y", "[", "x", "]"}]]}], ")"}], "2"]}]]}], 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"C", "[", "1", "]"}]}], "+", 
      RowBox[{
       SqrtBox[
        RowBox[{"2", " ", "\[Pi]"}]], " ", 
       RowBox[{"Erfi", "[", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "5"}], " ", "x"}], "+", 
          FractionBox["1", 
           RowBox[{"y", "[", "x", "]"}]]}], 
         SqrtBox["2"]], "]"}]}]}]]}], ",", 
   RowBox[{"y", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{318, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[7]=",
 CellID->26969210]
}, Open  ]],

Cell[TextData[{
 "A contour plot can be used to study the nature of the solution. Each \
contour line corresponds to a solution to the ODE for a fixed value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellTags->"b:5.3",
 CellID->21617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"C", "[", "1", "]"}], "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"sol", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
       RowBox[{"C", "[", "1", "]"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], " ", "\[Rule]", " ", "y"}], 
    "}"}]}]}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[8]:=",
 CellID->4015],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "5"}], " ", "x"}], "+", 
          FractionBox["1", "y"]}], ")"}], "2"]}]]}], "+", 
    RowBox[{"5", " ", 
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]], " ", "x", " ", 
     RowBox[{"Erfi", "[", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "5"}], " ", "x"}], "+", 
        FractionBox["1", "y"]}], 
       SqrtBox["2"]], "]"}]}]}], 
   RowBox[{"10", " ", "x"}]]}]], "Output",
 ImageSize->{236, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[8]=",
 CellID->127224169]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{"expr", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.4"}], ",", 
     RowBox[{"-", "0.1"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1.", ",", "1.8"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[9]:=",
 CellID->3684],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxsnQV0VbnahnF3d4oM7jDoQHBngOJapLi7O0xxdwZ3dymVQJEqdUXK4A5H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   "], {{{}, 
     {RGBColor[0.3362452151259855, 0.13187283843201542`, 0.589613643038628], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl0lsVWUUx793H03fu688XEFhpdGCicbEKLQFKpPBKBQRhVI6CGUQEqO2
xbUuDJOJIdHwCm0MNC7akgil7YIU+hhWQiuDOygzrTuNcdWWwfPj/F9w8eWe
e+75znfG//nuS01frvsiCiFsS4SQtOeQPW/ZOmf0e+kQxotDmGMflsUhvFIS
Qr19K7PnzEwI/xp/o20+bbxek79u74NFIVyz5+LIdaFn3rQQ6mwNGW9VKoQX
U/7eY+9TJvMpcvZeautt431g+veb/lF7r7fVZ/oump7NJjdW7HROtvG+Mu1y
8K8Hl//DnodNftLWI6NXZEP4IXZf9unc88Y/Kxlo9OAzMmcS7tep4LpXin/H
eIO2+oyfMV5J2mMyKj7yM4r9W97oF4pdBh7fJ7QX2zkL+8eNd9/W0+Bxfb/E
Y1th9GtGX7KYVkZuE/q/nx7CG+bLq7a32uSGTU9N5H43TnPfC3EhJvhxRnFI
ms5bWc9VPuH+43tDwm3GlzX2bbWtWqNnFXke8QWbyCWyNy2HbSZ/I+U68rIf
XzptfWZrdpHLk/dyW/NtNRq/IvJYkPdm7E77Wf1pp28a3RJ5HSK/KPIz0L/Q
6KNGjxjdYXS76oxa6rZ11+iD9lygs3bY2mXrqslvSLvdl+3bz2ZXh61howcs
Hv22mu3bbns/lvB+eGx7ttpzyJ7fWtyWlfgeztyimNxLuD1NCd9LHq8Y/1DK
/TgtPcj/rrxTu/3BYzzH9NVGzmsTv0E2PDH6Lcvzcjt7Inh/UAv0CHHPqX7a
FX/yWFXkvUXcL6hnqIFxk//T1st2Zn3kNX9WfZePPEebIq/PQcWQ+E8F9+2o
/IA3JP7DhNu5Xf7zHR/nCxMeqRfgE0N03FPuBsyvpMX8eLHniLxhL360K9cd
yh/8riKvbWqc+IAv5Ih+PKJa+sRkPk95bi+Z7rWxx7hdNYnOJovZh0nvl3cU
5yvKD3aSU2JLXIndddNzwPTMAlOM/jH2GH5jOfk16/UArhyY7vhAfW1QHqkt
vlNvS612amKndyaeY9Vl03Ey9j6uTLrt7ON9jXrwo9jl4GF7tewnHj1F3u9g
FDEiPvCOi08frC92fAab09Mcn2uMt6HYa2lu2ml8pL5qxAdXqmUD39eLD5Yc
Vn5Pml29WY/7ksjjTK/9ZrzXM34euAFmgC1bjL8u6/GJeJpvPaZ3ucVno9Ej
puOC8Rsz7l+57V2rObM38tjssXW7UL/B8SzKOKaVpd0ffMFe3vF9IO34Mpby
2rwpLO0yme5iPxcf2cu+ep2Bj0uSLsf5LeJzLvvg5xLeO8yAyeA2l8mGUfUi
MejRWcjzPK5zm7X3lOrwgbBiSn1BX/8y3Wdwver9jubIoGjqf2as2Nl5OfOz
NO04NCYaDAnMVZO5mnTc4Tmp2X1N9HdF/g5NfzwUFoFt48J26DH1zgPJgAPo
TmSkP/a84uND+YWeTumhH8H7YeE/zxHNsn7RfAeTsI24VcdeW9TVX/b829ab
af8OLyfZCeXiRMq/M4e/MtnKjOMoNbRZMWzN+qyl9pFHFrwih+SyVzWATvTT
x/My3svw+Iaex8I7MARsYGbQ//R7h3AM3TOkv0R2kdO2lOesIulYPaBaHdIM
ntKMhkb/Dum8pvkO5j6z02zrjF3P/tjxizoEG8EWMKYr5U/qmb46pJ7YIew9
r7lxRPGhJ8rUF3s0e/jOO/gCJrRpttLXP8WOleAkMYLPPvxqUn7BMWhklpvs
u1mfjdz7+rLeN9xvwLXCnW1SuDM34zjSr/5dotrolP3gD3eBI4o5tuV0V+Ee
xf0DPcx75iVnEW/sw7aPs27Ts1md8txM6D68UjM3rzsGeSkX3avZVy6a3uQs
+rpV59KnCyTTqHsG9xt6AVytlG1VmnHgDPP8ke5R50RTw+yrkkyH5OmvxeJv
E0YukkytcKZWc5v5t11xA7vpa7C2QnhLnXQJo7C9Ur4wx7mHcTeq070OnKQ2
S1Wrs0U36O6wVfMVHt/wpU5YShzAp5zijMws7SWHm5XHVt3bic/CjNc3td1s
uWrJPv+v4El86I+d6hF8Qj9+laq3qHtm1EXNqXb1wFX9QzCfLwr3tgmvwPLZ
sg082yJMyys39MI/Zldc4nOYO9e4/OpOeUyJJ3GFpgepwVWynbN2K3f4uk/1
wFlfRz4XuIMd/N9dulUyx7QXTJ7UXnqZejmn+hkR3oKrz2ohcpzMKR7EB/x4
Kgyhljp0x6aPb6iX8btd9QaWDGs+LxGugBtDksnrHnJQ/cLsbVYtUaeL5G+p
6mJK8nlhy13lBV+IwQPNmiHJTMnHOvUF+SbvhfztVP2s1syr1ey6r1lG/1fp
X4WYt6pPiXOLemdUNrN3l+zhnHbF54nuluO6Y9/WXnLEfxX1khfmZ/Q/yOzY
pPjv1b2mTzORs4gTc5R5XJjFDYoVeWnQueS6Xj1YmPfsvS0+GECtdQv3xyVD
TTJnB4TJYGaPfOd7v/7F6MFu8Ud0j6pRL/YoP/PVz406t072rMj4PCAmPUYv
jX0WUS+X5XO58AbMPBH73b3wb1S4p4wqVmDqXdlDTv8D/5tmpg==
         "],
         VertexColors->None], 
        PolygonBox[{{3827, 2854, 180, 2390}, {2737, 2641, 845, 847}, {2580, 
         3080, 1448, 1116}, {3098, 2637, 1033, 1467}, {3508, 2874, 791, 
         1878}, {3652, 3651, 794, 2022}, {2648, 3788, 2217, 717}, {2642, 2735,
          844, 846}, {3759, 2943, 1180, 1182}, {2738, 2623, 824, 848}, {2875, 
         2816, 976, 1050}, {3731, 3697, 2080, 2123}, {2910, 2801, 1450, 
         1118}, {3788, 2945, 825, 2217}, {3115, 3509, 1879, 1482}, {3698, 
         3696, 1048, 2080}, {3585, 2741, 1963, 1961}, {3764, 2579, 1341, 
         2161}, {2698, 2622, 823, 791}, {2818, 3098, 1467, 978}, {2727, 2819, 
         978, 1412}, {3145, 3146, 1244, 1011}, {2640, 2875, 1050, 844}, {3108,
          3109, 1011, 348}, {2815, 3782, 2200, 824}, {3466, 3467, 1832, 
         794}, {3763, 3765, 2161, 1244}, {2606, 2580, 1116, 1832}, {3509, 
         3508, 1878, 1879}, {3782, 2611, 249, 2200}, {3587, 2649, 717, 
         1963}, {2945, 2986, 1364, 825}, {3761, 3759, 1182, 2156}, {2622, 
         2738, 848, 823}, {3493, 3492, 348, 1808}, {2817, 2727, 1412, 976}, {
         2624, 3760, 2156, 1364}, {3082, 2802, 1451, 1450}, {3666, 3667, 2022,
          180}, {2736, 2642, 846, 845}, {2873, 3699, 1482, 1048}, {3810, 2883,
          803, 2279}, {3823, 3493, 1808, 2353}, {2707, 2737, 847, 803}, {3137,
          3136, 715, 1180}, {2882, 3810, 2279, 249}, {3080, 2582, 1118, 
         1448}, {2579, 3731, 2123, 1341}, {2740, 3585, 1961, 1962}, {3011, 
         3010, 407, 1033}, {2855, 3827, 2390, 715}, {3793, 3822, 2353, 
         2223}, {3010, 3586, 1962, 407}},
         VertexColors->None]}]}, 
     {RGBColor[0.42190364537795644`, 0.28080971529604626`, 0.710016929115884],
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnmQVcUVxu9bBh7vvhnKLJqIgoiKgg64YUWjbK7sDJtLGa2UpQgoqIkK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmtolmUYx+/tfef79hzeQdAs/BBaZrQymtmJ1L1Lo60kt4lNO0dUTiud
Ja1cKwOd002oUJIsluugH6blaqEdzT5UUDad85COoBpBWkYf7Gi/P/8PF9zX
cx3u6/i/n/H3PdrwSGkIYT2UhUajEJriEObCbCkL4eEkhJXQuDEhxNBdyPYU
QujKhzCQCeFS+C/ge+B/wNFZ6I7Fx93Yb8V+B+evkL+JfAryKvij6LThayKU
cI6h4WCbQXTXoHMavh+bLmTdiXUncN/ZyI6nIazOhbAdfg78l9j0onsF/gfR
fZlvy7Fvwaab+D6BHiSWk9BMdGugPmxH8bGecxabTejPwkcjulfB70e3CD/E
XQehtpx15iJfh001shpoQuKaqVZ7oAvhi/C/4/8z+BF0K7H5HH4E/QrOExPL
9kIR51ORa/m+bGLXVLVciHwY+Z/c38P9T5DPc/DfJs5NPVmMbg3yQXSXUr+j
3HcCf+fi62vu+yXyN523Ev9w6m86t+PzEPa7oPuxfxYa5HwzOkfwvQL+49jf
dFYNf0O2GfuN2G6APkV2GFqJ7CFoEufbkG8mlmzWsg+hB8qs8yKyG1QDZJvI
8WDiHJVbMzEtRv4B8nLi/x55D/wf3NmI/MqMZ+M65OdlPSOXw58D3QlfSTzH
yDWjmqA7mPdszka+q8QzekS9hWYhX4HPM/j+B6qDfyPnWa1Hv6rUM7scX7OR
DxF7O3fkkB3C/ils6+DnwT+NzgD670H7OFerH8hbsWnl/CSU4LsZegX9roJn
p4o7D+NrCKrN2OcpdJ+PPOuq8VT8daI/XbvAfX2c2/nWDL8Q2obuf6ljbx1j
X6/zrZixzyL8M+gvQvdYmXdPMSo27eABbFdFngXN+L34vyh278qxKeH8Hd/2
5V3TDvTXpN49zVg9sgT76/H3F/aX4X8y9HPWM18auyfqhXpwLfwS+PPhx0Mt
nJdCO4K/vYCv/fADefegMzImCAuasH9butCCEtdAuakmqoVy1OxVJ85VM9gE
XwN/HL4Hfhr8a8RfJNZ70L818cxp1k6g04u/iyPPonJYh25X6tkaRz47hU/o
tGC7RDuF7gG+7c675u8g2wlVZD0TiyJjqLBTMyzsaYT+zhmDlKt2QrugnDWb
r0aeDc3oat0HTUNWm3Uu85VD1jkJi4RZwiphUgPnx6C2rDFsA+cO6Kcy96ga
222xa6EadmsfC8bCVdCW1DOrWVWN+pGXFoxFjRljWy/ympwx7oxigV4i/m/g
5+N7gTAg652pJN5r4MdmvbOapRAbqzVT86Qbe7e7iOdX5CehH0t9R21izBRW
jpYZ24VBwh5hvHK7IDH2Ksfd8F2xeylM6yh4Z7WrquFHsd8EvQXCpAy2d8Df
iKwXvh/9dwvurWYyH3nGNdvaYb19FXzbG/wGCnv05umtEwZNhl9LfJNy1pkj
LBcmozud/KYm/qazMFuz8xY2fSWeoUtivxl6K/RNtZ0RefZV4z7O/6bGLmHW
SOoZ1WzqTexM3VP1UjHU4G9K5N4Ic9cWPFOaJWFKQ8E7r13XTKpXywreTfXs
dGqMEbboDSqP/GborVCPu9G9PfbbOTPvXOtjY6FyLmI/I/XbJEy8RVibGkv1
xmRU78izpZl+HNubIs+C3gDtWl3i3mvnro6NicJC7Viq+UzcO/2zLIu949pt
7YD+DbZH/vfQP4J6rZgVq3r+P2s2NJU=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5075620756299274, 0.4297465921600771, 0.83042021519314], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmQldWVx7/X7/V73d973yOAYFLl1Aw0TAmWZNhEAZ1JJoGmURCcOIqO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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllslVUUhf9y23sv/3AJIAESjAI1AQwYVAoqgyhqZSiCioAxGIwBZEqY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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5854364023199783, 0.5622955864494348, 0.9099915089397155], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgnU3uOZxt/3+959G9vMlEgksZWs6JQISYhYTscwoeOMUUsSYqkkKBIJ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3dwVVUQxm/Ie7nktmEUCyooWCiCQIJKCUEdSiyIQ3HGMnalSSgqCYKC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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6484151692211533, 0.6634849408313407, 0.9114272308478091], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgm0ldV1x7/33n13+O79LsN7gIBMhizBgMxEwRjBIEkgQ9PYYMQBATPY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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3m0j3Uexx/3d3/P73efjQjFvaHIEtcWhbYZIbntOSGlrrSeISdMM7iU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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7113939361223283, 0.7646742952132467, 0.9128629527559027], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG2wlVUVx8/h3POcc57zPA/gJIiCwox50ZBrWgKNzmBmCGmjSc4ogXhB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtllls1VUQxv/Q3tt7/8sFVHahYCCKguCDCEYTFBWoYNAHEpYKtCwqhEoJ
RFAQ1ITVKFJbjJEAIvumkfIAiFLACsKDqEQja6LI0qIRLJVFf18+HyaZ78xy
5syZmXM6l5Q9N6VpEAQ7oHzoYBwEo8Mg6J8OgglQJhcES8GFeUGwvSAIpsLn
WKuGH4Y8SoKgLXgPeCY6f2Bfjs5VnL6NvDy2jXSbQcXSZa1VE2wzQdAC+46s
7cd+DfLbwZ3AB8Bv4u9nbJuzthrZx9AtbFdFQTAgFQRV4O7aXzrEnoDrI9tI
dxk6I9AfDl2Db4R6oP8QdAj5F1ANsn2KGfuOWoOfif0t4l/C/l3R3crak8iq
oc3wzyMfQ3yPg3PIXwFPx/cqcCvwLPAM8Drwp+iXggfCD4DaIm8DXcd/BtyA
LEPMx9lrM3gEZ0+DfwDnkZ9dyAtY28Z+eeSsC7Yx8pPIu3Fh40LvId+DoGmx
c65cN4e+Q34e/aXEU47NOnyF4L3gcfgfBe4U+S5C6Cz8IWx2st8SdB6AP87a
XPha7MvAI7HJoFvHGb4Bn0G+GPkLyCuQjQGX5DvHN4nlOvQyskpwLfKVUD22
K/DRDt3h4KaZ/+8wcU2pllai3zJxTagW1oJfR3cOdDbPd7oZ2ZTIvoYQ83Dw
KPabiPxc2r7bR86l9lgQO+fKdSfoZOQcK7cL8Lca/TLWZhB/L9Ucsr/xWYqs
Hz6L4RuyQdCHWJsgLwO/pnqGD9j/z6xrRrVyC5sKZO9D3dO+08vwh0P3xhLo
VfAsqGXaPnbAfw7dh7si8DX8fUs85fjKU8zqLdYuwN8GzUV3HmvFqi1oPHu/
yNpb7HUlbd+zdWdp77E3dsyKVTaj4ScqBvTrwAtj50i56Zz2XnWRe0l79lb/
I9+a8pmukq+dsWOtyXp2qEfUG5oha5Cvz7nW3iCnm5BNid2rj2kmIEtyrh3N
lOXYHwtdqy8h/yz2mnj1UB14T+jaXAzeBt4C/djUParY2kO7U47xHLFPD52/
d6ES+O2xa1c2F4h5GDn4CxmioDd8X+hw2jWsXLZO3MvK6RH8HY1cz7qjwcQ+
JOdZop68hOwi9CCyueCe2PeC+il/7NcM/uHQtbUtZV+/R45NPr+HPwa1wH5s
yr3XC/2hKfegzlbFfkMzPuMlYvtQMZO796D98AcSz1LNsFPYd8OmFt2F0Fpw
FrpcYJ93I2sBZan/g+Br7NUYuterwafRrc+6lxaBq2Pfue5aM7wD+E7ohEoq
5dhHxp61OkOGWLKJe0Uzbz38Bmgg+zeyx73sNS927WoGf4RsReLcqMenI5sR
u9b1phyA/zr226Q3qTv282PP7nnY3ySuCYln61PgK+BRiWeh7kS13izxrFbN
TwZPAt8AvwMeCy6J3btl4L74r4wdq3KkWfZv7LdH9xWRixiar/iRN0e2KHbv
KCePqFfw/wznndbEs6k+du1qRnWEL4yduxTyX8nfb9BUcAPnrcS2SjOfWvwF
/TnwNdDkAs/Q2fBfQZPA58GtiKU1tDztGbUL2W5oNPKeWtN7i/9UxjX+HrhP
6L17ovNo7JgVq2ag3gLNLM0qvQnqpTjxbFZPdWCv46FrvQLcBnwXeFDKf4Kj
OcegvTeyZxdkN7KeTUXoLEdeCU3Md03rbW9kv4q033j5asx6NslnJbgaf8+y
3z26L/1V0D+l3k55Vt6I/dYovq74PhH6LdcMPIPsdOxeVM9fVD0hn5DnNywf
33mJc68cVoXuMfWW7rhz5DdTb2UMtU9cQ6qdDcgrwMsSx6Y7K8z5zDqr/jT6
61yOnCv9eQ5FnvGa7brzi1n3nHrtSsq9fSTn3KnHx8H3QB7m+03SXQ7WeVK+
01rFG/tvoDPdj3x8zr0sm/6hZ4JmgXrwQuQz6Sz6I5TCf5DzW6g7+Sd2T6gX
dCf7Ev859NdQDSr3Y0LPKt2BYukQeZYopk3oPxG6N4rQ35L4zdZbrZ74MvEd
6u5Uw8Wh3wi9DapZ/X12h/576g+0Nuc3RW9Jqf4PoXOmXGnGarYtTVzLmnGF
4I2J99af5Wlso8i9pD+Q/m53JP5b6A+nWflJzr41Mxs0S0O//ao5/e3aJb5r
/fGK0B2Uc+/pD6e/6k/o1BT4z/ofgsR5jg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7731758462370231, 0.8505144252426692, 0.9093069183353945], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lktsVVUUhk+5Pbe955x71YnyMFEH1kAxOlAEHRAjISTGIqU8paClJVJo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllUtoV1cQxk8S/9f87z33gpsataBuBLWgQk21m1IMUhAVJfEdI4kJEklS
xOqm0HbRZVu1jSY+Nq7EN4oKojsfVDEYFDeCj9ZHRE3rI9GKNf4+vsXAzPlm
5p4z883cyc1dSzsrQwgbkVHIUAzhehpCR1UI80shLCpC2J2HMGd0CK+QsVkI
KzgL1fjik6DXg69APwL+mPiLxLdgdxL/CPsCdjP2POxe4mdydg19Oh98UQbD
/h/7U9KWyHUT/634b+asEawFCUkIWzgbBR5y67s568L3OPh89HpkHFg79s/g
B7Bnof/DN74gVx/SjX+p8F03gD8Bj9gnsVuJ+Q57Ez7LwcYgjejnyLkWvJ9C
7cG3lTc08P565Dn+g8g7cjcRX4e+EHmKfQ/5F/0qOdqrnLMZ/QhndYnvfJVc
j5Df8O3EpzL3m/W+XvBh7v4n+Lcl16AafGvq2uzD7sVeXLg3p7DXZ76j7hYr
CAHfz9k3+O8Ff0fu/5AXla75RfTt5GtVLHIM+zXx35d9R+lHo3ujsy70zuha
DCgH+ntkGng3/rfJ9Trz/dSDS9gD0b0XJ85i95JzCfdbif1Z7pzKdZ74ZWA1
xI/wng9ID/YupJK3LCbmPr4NSCOxP+Lfgu/OwphyjscelzrXW3wOkf8g8h59
AflqwbqJn544Zxv+X2Iv4X7t8HEX+EvyzeWtU6usiyPihs42g1fl5p56Iq61
YQ8lfu9K9EH8aoI5MYB+i2/8gP4gsf6Es9qSzy4Rfzm69jeowfjUM6LZUI4d
6g8yFXwa0oS+Lnq2NKNXMnNI3FEPNKunsZtKntmHme+su4pjy3nPbOyKCtf4
gbiHfA72KzKI/hypJddP5LxcmGPi1h7qO4dvz0W+xvcu+J3MPVUvVyF/YZ9P
PQvi/DxiOzjbxHu+IuZv9LrUvfgFux/9bfSu0Rv28r08c27N2AewkWhuibMz
0DuI2VjyDnlW9oxrtoeQM8T+Hl0rvfET8k1Ozf9zfHNK9A7T7tKdGrnf+uh9
85SYN+gvo++yQ/skMyfFRe28P8ASzk4k5tBE9NWFd484pt00tvC3NMOr0Cdk
5qJi1EvtIO0e9XRN6h6o9uqZdmlDbq5opx4GO5SZm6+QauVOXWvNbBv5Ruee
bb1Bbynn3g2yD2TeCdoF4ngf8dcKc1s7bVH0N5RbO0u7oiL37lHNJqSusWqr
nquWb8qulXD14l70LKonWeEeq7faqZrVZeR7mHhmJ+G/JXq3imPabcPRtRZH
t2H3ZOaKONmTm4Pinv4h2n01uXe7dsxHuaHohg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8297350533504113, 0.8693754137415413, 0.8839684442331475], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VUtIlVEQPl69x+7/uLRLcRX00FoFiT3c1VKNfHSlh0makJkR7YteLlOT
QDMKWgW1alGBEUFZBJEGVw20B2U+QDDKvEFhfV/ftJh7zp0z55uZb+bMv/bI
ydrOhHOuD5IPuZnn3Dwkwn4ZPy9D58qwb8H+EORX0rmZlHNFgXNp6HO4NAxd
B+5cha4XNuuh24J1AXbFsHnkneuCzTL0PdBvhd1G6PqwfwD8Zpz95jmkxMlP
IpavDO6cwboO6zzwxkPFSf+ToWI4XuDcsQLFTh9dFs8FL8yvSLAemGOhsGqx
r4uEvRl+NsWKcQ3ON0TKJwdZTAr/BX76YVNR6Fwe1luwWwZmJe7s9PLFvK9Y
7tWIswryEfs7sL0LaUgqz1KvXMoRfyat/4sp8UWuyPdySpwv4CwBqcC+Gue7
IafgawI4byGnkXM37KchI4inCbp2yGxCMeQs/j+r5Hs0oTuMhTi0qTG7JDC6
gZ/NV91KAsVzDv4vedWF3DJf4ifTqjfzJfesQQzMBvBTD/kMu5U86VmXfzlb
DIy9weJvhd/boTAu4063V72area0J381ke6wtme9atcJ/1PsM9i8x/oh0lkM
++uIr6NAvUw/zJd1rbR6NRlP5G3CYmGcw8CcjZRzn1dMjOc19N8jxUdOznv5
ZY9ctH2XnXHfmFY/0Sf7psb64QlwpiPdp67a9M+gn4mE9bBQftkD9wqFSf5H
YfMDNr1ed9hjjL/KcFjrIvjcl9a7zJoN9awb68fctwNjG2Tc3lyv5Ui+c2bz
Dud7I+VXiHq2RerFlgLxylozfubG/gng5HGgeLNYk7gz6MUra0Buu+w9E/8a
zmvSymMHsNtC1YE+Bq3nGXPW+u0ozgfT6hP2BnuavbcE/ST8DUB3PxQuMZkb
42S8S8AfgU2PFx/khbyxT31avboH64C98W+wz0WqwX7oDkDmvGZHufUlZ9Oc
1Yj3HXA/2byZsXqxDsWhOM0AozHWGWfYXEpzjBzXxeKZGMyLOFz5nznOweZ5
oP7ivCAeY+Ac8rFmEXm74bUvha4MMuQ1D4as9idgvysWpx02M2N7o3yr3PfD
picU5ytWN34LyH2rvdOfULwJ9D44ew4G4pO88l1xT67JEeMZw3kQKz5yzHlK
nqdCzR3eWw3dq0C9n7H82Cf8ThCTNuSZ3JC3/xxxPpAnnpGrZsR2ONL3pN2+
OczlC3RPA30T/gJ9Ifna
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtIVVEUhrdX75H2PefSMDGCBqXWNLGyWdMy0UypMEkUirKiedHLYVpN
rKSa9IBmQS+KCNKaRBZoBdmDLHUg9DINatD38ztYsNZea/3rvZfvPtDUkwsh
bILKoKk0hGeFECrhTyUhPIohfObtGPyt8hDasxC6kHPIM9BtbIegvXl00F34
Wnyq0XUgN2M/uSiEInjfkJehW4xwD6wa3r6A1cPbDEkcx2cCeTg6tmJW4b8a
egg/VxrCSvTXoA3Iw+BFdIexn8P/Em/viD8OjZY65proHJVbFfpf+B7k7Tv2
fch5/EfQ12F7EXkMfop8a7E/Ag2gb8NnHr6u3LVW8/Ygcc2KPYu+P3EOH+Gb
oFbiH+XtOfofyKcT13wVfr/yQ66H7qP/kNq2F7yNYA8oh5xtWoWlHgoffStF
LUE/X+oen0V/LnWvV/DWhu3S6PnJJ0Euzzwv5ZeDL8nM/8XnClh/hJG4J0+j
Z6De90KDxOvCZg/Lsa/Mu/A4elayaUfeDt50Yryd6O5g/4lcRnKelWpWrZrZ
NL1twX4CHpPQp96lno1m1o1vPfJbsN5AT6J7oNpPYFOBvq3o2asHc+B1po6t
fZLvTWxa8saYl29qnWawFj4ruJbX6F+B/3NhPuqBdr8D+V/ePRyJrlH4mvF1
9OtT53a5JIQLyOtSY3WCOQ7/PvWua6d3ZN55xVePbhSMIV/1VLvxInoXlcMg
uunUvZf/79Qz0mzO8NaNPBq9q5rpZGof2Z5ErozOSblUBO/619S9E8aqzDun
XdNNNdDLLUXvtma2C9ttC/1WDxrgN0OHStzTRvih6FiqUbczC53P+4ZqMt+s
blU3koCdL3o3NXPdUuNCf3RTzfBbU9+abkaxX0bXqhy0y7Hov0fz6CdWX8G7
pRvRXzQWffvqx3/TZbR3
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8862942604637994, 0.8882364022404134, 0.8586299701309004], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2766, 3313, 875}, {3418, 3166, 876}, {3173, 3422, 888}, {
         3602, 3603, 1978}, {1391, 1978, 876}, {3294, 2745, 854}, {3159, 2755,
          865}, {3371, 3367, 1722}, {2967, 3588, 1342}, {2590, 3419, 1349}, {
         3293, 3292, 1662}, {979, 1373, 256}, {1713, 1413, 852}, {3363, 3362, 
         1712}, {2588, 3416, 1346}, {2997, 2612, 256}, {1520, 1372, 2}, {3313,
          2764, 875}, {1413, 1342, 852}, {3154, 3295, 1520}, {3298, 2750, 
         864}, {3605, 3604, 1979}, {2535, 3029, 2}, {3600, 2590, 1349}, {3415,
          3159, 865}, {3594, 2588, 1346}, {2753, 3799, 865}, {2670, 3300, 
         1388}, {2743, 3798, 853}, {1373, 1415, 854}, {1372, 1520, 854}, {
         3410, 2820, 979}, {1722, 1373, 854}, {3216, 3215, 1574}, {1979, 1349,
          876}, {1521, 1520, 2}, {3156, 3155, 1521}, {3408, 3409, 852}, {3036,
          3035, 1413}, {2765, 3772, 875}, {1712, 1373, 979}, {1415, 1372, 
         854}, {1574, 1713, 852}, {3798, 2744, 853}, {2745, 3370, 854}, {2752,
          3298, 864}, {3367, 3369, 1722}, {3166, 2767, 876}, {2751, 3771, 
         864}, {2820, 3361, 979}, {1373, 1722, 256}, {1574, 979, 256}, {3012, 
         2997, 256}, {3799, 2754, 865}, {2773, 3173, 888}, {2742, 3408, 
         852}, {1662, 1388, 853}, {979, 1574, 852}, {1429, 1391, 888}, {1342, 
         1761, 853}, {2534, 3411, 1761}, {3316, 2675, 1391}, {3772, 2544, 
         875}, {3301, 2672, 1389}, {3771, 2541, 864}, {2675, 3338, 1391}, {
         3368, 3012, 256}, {2672, 3315, 1389}},
         VertexColors->None], 
        PolygonBox[{{3411, 3153, 853, 1761}, {3215, 2821, 1713, 1574}, {2544, 
         3014, 1389, 875}, {2750, 3594, 1346, 864}, {3604, 2975, 1349, 
         1979}, {2755, 3301, 1389, 865}, {2767, 3316, 1391, 876}, {3029, 3156,
          1521, 2}, {2744, 2967, 1342, 853}, {2754, 2971, 1346, 865}, {3603, 
         3601, 876, 1978}, {2541, 3013, 1388, 864}, {3588, 2742, 852, 1342}, {
         3295, 3294, 854, 1520}, {3361, 3363, 1712, 979}, {3409, 3410, 979, 
         852}, {2612, 3216, 1574, 256}, {3056, 3016, 1391, 1429}, {3153, 3293,
          1662, 853}, {3338, 2773, 888, 1391}, {3300, 2752, 864, 1388}, {2821,
          3036, 1413, 1713}, {2584, 2534, 1761, 1342}, {2975, 2765, 875, 
         1349}, {3362, 2651, 1373, 1712}, {2651, 3037, 1415, 1373}, {3013, 
         2743, 853, 1388}, {2971, 2751, 864, 1346}, {3419, 3418, 876, 1349}, {
         3292, 2670, 1388, 1662}, {3370, 3371, 1722, 854}, {2764, 3600, 1349, 
         875}, {3315, 2766, 875, 1389}, {3601, 3605, 1979, 876}, {3155, 3154, 
         1520, 1521}, {3016, 3602, 1978, 1391}, {3416, 3415, 865, 1346}, {
         3037, 2650, 1372, 1415}, {3035, 2584, 1342, 1413}, {3014, 2753, 865, 
         1389}, {3369, 3368, 256, 1722}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2530, 2516, 747}, {2967, 2744, 742}, {2516, 2522, 747}, {
         2971, 2754, 747}, {2517, 2524, 751}, {2514, 2529, 26}, {1711, 2029, 
         1}, {1759, 1964, 742}, {2510, 2513, 13}, {2765, 2975, 751}, {3605, 
         3601, 1977}, {3013, 2541, 13}, {3601, 3603, 1977}, {2513, 2526, 
         13}, {2029, 1760, 1}, {2742, 3588, 1964}, {3014, 2544, 26}, {3363, 
         3361, 1711}, {2527, 2515, 742}, {1760, 1759, 1}, {2515, 2532, 742}, {
         2511, 2514, 26}, {2975, 3604, 751}, {3410, 3409, 1760}, {3602, 3016, 
         40}, {2753, 3014, 26}, {2520, 2517, 751}, {3016, 3056, 40}, {2743, 
         3013, 13}, {3037, 2651, 718}, {2651, 3362, 718}, {2751, 2971, 747}, {
         2650, 3037, 718}, {2533, 2519, 1759}},
         VertexColors->None], 
        PolygonBox[{{3588, 2967, 742, 1964}, {2523, 2510, 13, 2169}, {2754, 
         3799, 2243, 747}, {3603, 3602, 40, 1977}, {2529, 2531, 2243, 26}, {
         2528, 2527, 742, 2242}, {2744, 3798, 2242, 742}, {2526, 2528, 2242, 
         13}, {2525, 2511, 26, 2170}, {3409, 3408, 1759, 1760}, {3362, 3363, 
         1711, 718}, {2532, 2533, 1759, 742}, {2522, 2523, 2169, 747}, {2512, 
         2521, 1977, 40}, {2521, 2520, 751, 1977}, {2524, 2525, 2170, 751}, {
         2544, 3772, 2170, 26}, {3361, 2820, 2029, 1711}, {2519, 2518, 1, 
         1759}, {3408, 2742, 1964, 1759}, {2531, 2530, 747, 2243}, {3772, 
         2765, 751, 2170}, {3771, 2751, 747, 2169}, {3604, 3605, 1977, 751}, {
         2820, 3410, 1760, 2029}, {3799, 2753, 26, 2243}, {3798, 2743, 13, 
         2242}, {2541, 3771, 2169, 13}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2650, 3037, 2651, 3362, 3363, 3361, 2820, 3410, 3409, 3408, 
         2742, 3588, 2967, 2744, 3798, 2743, 3013, 2541, 3771, 2751, 2971, 
         2754, 3799, 2753, 3014, 2544, 3772, 2765, 2975, 3604, 3605, 3601, 
         3603, 3602, 3016, 3056}],
        "4.5`"],
       Annotation[#, 4.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2535, 3029, 3156, 3155, 3154, 3295, 3294, 2745, 3370, 3371, 
         3367, 3369, 3368, 3012, 2997, 2612, 3216, 3215, 2821, 3036, 3035, 
         2584, 2534, 3411, 3153, 3293, 3292, 2670, 3300, 2752, 3298, 2750, 
         3594, 2588, 3416, 3415, 3159, 2755, 3301, 2672, 3315, 2766, 3313, 
         2764, 3600, 2590, 3419, 3418, 3166, 2767, 3316, 2675, 3338, 2773, 
         3173, 3422}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2537, 3030, 2536, 3413, 3412, 3590, 3589, 2709, 3217, 3218, 
         3219, 2999, 2613, 3671, 2840, 3670, 2841, 3672, 2839, 3110, 3238, 
         3237, 2925, 3395, 2968, 2960, 2959, 3044, 2652, 2998, 3482, 3662, 
         3663, 3481, 3783, 3480, 3160, 3152, 2756, 3302, 2972, 3304, 2758, 
         3299, 2757, 3303, 3015, 3168, 3167, 3158, 2768, 3317, 2976, 3320, 
         2769, 3314, 3319, 3318, 3017, 2550, 3171, 3165, 3330, 3329, 2978, 
         3334, 3335, 3174, 2772, 3333, 3023, 3060, 2779}],
        "3.5`"],
       Annotation[#, 3.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2543, 3121, 2540, 2587, 2970, 3129, 3128, 2829, 3740, 2917, 
         3739, 2916, 2984, 2983, 3130, 2918, 3131, 2987, 2988, 3150, 3149, 
         3140}],
        "3.5`"],
       Annotation[#, 3.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2538, 3414, 3157, 3297, 3296, 2669, 3119, 3120, 2969, 2586, 
         2539, 3040, 2542, 3417, 3164, 3310, 3309, 2749, 3042, 2762, 3311, 
         2763, 3312, 2674, 3189, 3190, 2592, 2549, 3053, 3054, 2778, 3344, 
         2777}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2557, 3430, 3178, 3353, 3352, 2679, 3336, 3337, 3172, 3421, 
         2551, 2593, 3606, 3607, 3328, 3332, 3331, 2676, 3045, 3046, 3019, 
         3018, 2552, 3020, 3324, 3325, 3323, 3327, 3326, 2977, 3321, 3322, 
         3169, 3170, 2545, 3365, 3246, 3828, 3247, 3245, 2658, 3248, 2671, 
         3675, 2847, 3498, 3499, 2628, 3043, 3595, 3596, 3305, 3826, 2711, 
         3564, 3483, 3789, 3790, 3515, 3516, 2653, 3243, 3182, 3183, 3372, 
         2585, 2842, 3673, 2843, 3674, 2822, 3220, 3221, 2614, 3086, 3099, 
         3735, 3736, 3734, 2915, 3737, 2746, 3038, 2747, 3591, 2748, 3592, 
         2705, 3269, 3271, 3270, 2655, 3244, 2654}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2563, 3435, 3180, 3355, 3354, 2682, 3350, 3351, 3177, 3429, 
         2556, 2596, 3615, 3616, 3347, 3349, 3348, 2680, 3342, 3343, 3175, 
         3423, 2553, 2594, 3608, 3609, 3339, 3341, 3340, 2677, 3047, 3048, 
         3022, 3021, 2554, 3366, 3252, 3253, 3251, 3255, 3829, 3254, 3261, 
         3677, 2848, 3676, 2849, 3050, 3049, 2770, 3800, 2771, 2712, 3250, 
         2659, 3249, 2660, 3522, 3523, 3454, 3744, 3784, 2926, 3500, 3501, 
         3502, 3132, 3133, 2928, 3745, 2927, 3746, 2618, 3087, 3486, 3485, 
         3484, 2830, 3710, 3711, 3161, 3162, 3163, 3027, 3028, 3000, 2656, 
         3139, 2657, 3520, 3521, 3453, 3657, 3658, 2823, 2824, 2807, 3208, 
         3209, 3210, 3088, 3100, 3101, 2956, 3103, 3102, 2615, 3738, 2616, 
         3474, 3473, 2825, 2982, 2608, 3031, 2609, 2809, 2808, 3685, 2862, 
         3683, 2861, 3684, 3001, 3574, 2723, 3573, 2724, 3575, 2643, 3510, 
         2710, 3563, 3475, 3476, 2863, 3479, 3478, 3477, 2827, 3659, 2826, 
         3751, 3752, 3748, 3750, 3749, 3113, 3039, 2627, 3497, 3496, 2844, 
         3222, 2617, 3089, 3111, 2845, 3148, 2846, 3384, 3385, 3382, 2912, 
         3732, 3383, 3373, 3374, 3661, 3660, 2828, 3364, 3593, 3308, 2760, 
         3306, 2759, 3307, 3041, 2761, 3597, 3599, 3598, 2673, 3186, 3187, 
         3188, 3420, 2548, 3051, 3052, 2776, 3612, 2775, 3613, 3055, 3614, 
         3345, 3346, 3525, 3524, 2681, 3262, 2780, 3620, 2781, 3621, 2685, 
         3194, 3195, 3196, 3439, 3263, 2689, 3200, 3201, 2602, 2566, 3266, 
         3267, 3206, 3207, 2604, 2571, 3071, 2574}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV02lMz3EcwPEf44Hb2NgQyhWhxCOpsE7H2oynphzRA2oTtkh0zOZ+YITk
EXMfM8qxsfUgeeDabMKWmc1QErHJ9fo+ePf+nN99f79f/9iCTcs29oqiqK8/
ffpHUfGgKEoaHEWJKJcn8HRsUC9Cb7UpAbV4TMY0TEWZeizHodDsevztF0WT
1LsHRNEPDMWJgVF0EnUYjnhkms1CBnKQjUVmF+Oe8/45p8XcbdxBI9Y59y5v
4ZVmJpq9Yu8qMtW+ykepj8YXteNq9Xw6xPYeq69VaxAXowSJeuPU4uxOwBAc
VT+GWgzDeKSYK9SbG56TZ6slB+SzMRY9ztmrdkA8gn/JR/JvzuQsVNv94B5V
3OUZM/idPJPnIMnuOXPnMQ15duepbzazBaX4rjZdLzW8r/Be+RTycUQ/jbdy
Om/jJE5Gm3gW59qP56noFhdwk16MuDXs4JJ8Pm/nBXyBLyLP/RpwC8vNt6s1
u8Nnfsgd6u2o1dullmO3grO5BFmolxdxXfg/C3fnFPO3uAE3cRuNqNE/jG/e
1XV5D+c7fxUq5bvxwm4V55orUF+NNegKe1iKav0lXMM/w7cO9zXTgmZsd8Yj
buMZem95JlfwDs9Vjp3YbKYU98UPUBW+KRLM9ccfZ//FJ3Gq/Y+cxpGZdH5i
9yke4zmeYYF6K7/CS+yx85o7eAx36u8TvxHv5yZnfeEY+Ve9g+L34kOcLe/k
svBM4RvJV+CM+CwWhu8tvxx+O6jENVzFDfwHjV6Qtw==
         "]],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2790, 3073, 3025, 3640, 2789, 3639, 3642, 3641, 2981, 3637, 
         3638, 3446, 3447, 3448, 2837, 3635, 2787, 3634, 2788, 3636, 2979, 
         3633, 2786, 3441, 3442, 3443, 2836, 3519, 2665, 3518, 2666, 3526, 
         3527, 3455, 3781, 2989, 2631, 3134, 3507, 3506, 3505, 2930, 3747, 
         3235, 3792, 3236, 3233, 3234, 3179, 3193, 3774, 2560, 2598, 2853, 
         3679, 3680, 3664, 2833, 3093, 3092, 3105, 2834, 3388, 2923, 3230, 
         3489, 2620, 3124, 3380, 3359, 3360, 3212, 3471, 3472, 3096, 3097, 
         2814, 3143, 2813, 2951, 2962, 2963, 2938, 3814, 2939, 2937, 2941, 
         3815, 2940, 2635, 2732, 3797, 2733, 2663, 3176, 3191, 3192, 3406, 
         2595, 2935, 3753, 3754, 3705, 3707, 3706, 2867, 3689, 3690, 3686, 
         3688, 3687, 2634, 2731, 3578, 3579, 3517, 2664, 3694, 3695, 3691, 
         3693, 3692, 2561, 3818, 3276, 3817, 3277, 3275, 2715, 3278, 3514, 
         3513, 2739, 3584, 3232, 3231, 3280, 3279, 3381, 3401, 2630, 3240, 
         3239, 3390, 3389, 2985, 2955, 3806, 2835, 3144, 2964, 2965, 2946, 
         3438, 3437, 3436, 2894, 3065, 3064, 2782, 3801, 2783, 2687, 3456, 
         3457, 2601, 2565, 3066, 2569, 3775, 2901, 3068, 3067, 3643, 3644, 
         3533, 2691, 3532, 2692, 3534, 2792, 3802, 2793, 2693, 3458, 3459, 
         3460, 2576, 3544, 2695, 3461, 3462, 2605, 2577, 3077, 3078, 2909, 
         3728, 3730, 3729, 3079, 3653, 3553, 3554, 3552, 3556, 3555, 3654, 
         3559, 3560, 3558, 3562, 3561, 3656, 2803}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3009, 3033, 3005, 3006, 2958, 3008, 3007, 3026, 3403, 3404, 
         3402, 2934, 3405, 2905, 2906, 3777, 2575, 3032, 3002, 3003, 2957, 
         3151, 2668, 3004, 2690, 2933, 2632, 3127, 2902, 2903, 2720, 3571, 
         2721, 3572, 2667, 3181, 3202, 3203, 3281, 3282, 2716, 3568, 2717, 
         3569, 2706, 3213, 3214, 2610, 3291, 3024, 3392, 3393, 3391, 2924, 
         3394, 2895, 3125, 2896, 3812, 2897, 2645, 3135, 2646, 2942, 2994, 
         2995, 2870, 3809, 2871, 2869, 3722, 3723, 3719, 3721, 3720, 2567, 
         3288, 3289, 3285, 2725, 3284, 2726, 2729, 3796, 2728, 2636, 2858, 
         3807, 2859, 2806, 3117, 3118, 2954, 2980, 2600, 3709, 3377, 3286, 
         3287, 3577, 3576, 2730, 3582, 3583, 3580, 2734, 3581, 2638, 3819, 
         3290, 3283, 2719, 3570, 2718, 3725, 2900, 3724, 2899, 3126, 2898, 
         2932, 3813, 2931, 2621, 3490, 3491, 3449, 3450, 2568, 3665, 2572, 
         2966, 2952, 3107, 3106, 2791, 2904, 3776, 2573, 3074, 3075, 2908, 
         3726, 2907, 3727, 3076, 3648, 3541, 3542, 3540, 2694, 3543, 2796, 
         3803, 2797, 2699, 3463, 3464, 3465, 2578, 3550, 3551, 3468, 3469, 
         2607, 2581, 3081, 2583, 3779, 2911, 3084, 3083, 3085}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2802, 3082, 2801, 2910, 3778, 2582, 3080, 2580, 2606, 3467, 
         3466, 2702, 3651, 3652, 3650, 3667, 3666, 3681, 2854, 3827, 2855, 
         2647, 3136, 3137, 2944, 3758, 2943, 3759, 3761, 3760, 2624, 2986, 
         2945, 3788, 2648, 3138, 2649, 3587, 2741, 3585, 2740, 3586, 3010, 
         3011, 2860, 3785, 2637, 3098, 2818, 3805, 2819, 2727, 2817, 3804, 
         2816, 2875, 2640, 3786, 2735, 2642, 2736, 3787, 2641, 2737, 2707, 
         3795, 2708, 2883, 3810, 2882, 2611, 3782, 2815, 2722, 2623, 2738, 
         2622, 2698, 3794, 2697, 2874, 3508, 3509, 3115, 2872, 3699, 2873, 
         3696, 3698, 3697, 3731, 2579, 3764, 3765, 3763, 2953, 3146, 3145, 
         2838, 3109, 3108, 2625, 3492, 3493, 3823, 3822, 3793}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{-0.4, -0.1}, {1., 1.8}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[9]=",
 CellID->75038455]
}, Open  ]],

Cell[TextData[{
 "Here is the plot of the solutions to a system of two linear ODEs. The ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " is required because the solution is fairly complicated."
}], "MathCaption",
 CellTags->"b:5.3",
 CellID->17906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], "+", 
        RowBox[{"t", "*", 
         RowBox[{"y", "[", "t", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"2", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "t", "]"}]}], " ", "-", 
        RowBox[{"3", 
         RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "3"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[10]:=",
 CellID->25928],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["3", 
            RowBox[{"1", "/", "3"}]], " ", 
           RowBox[{"AiryAiPrime", "[", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", 
                FractionBox["3", "2"]}], ")"}], 
              RowBox[{"1", "/", "3"}]], " ", "t"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            FractionBox["1", "3"], "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["3", 
            RowBox[{"5", "/", "6"}]], " ", 
           RowBox[{"AiryBiPrime", "[", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", 
                FractionBox["3", "2"]}], ")"}], 
              RowBox[{"1", "/", "3"}]], " ", "t"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            FractionBox["1", "3"], "]"}]}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"1", "/", "3"}]], " ", 
           SuperscriptBox["2", 
            RowBox[{"2", "/", "3"}]], " ", 
           RowBox[{"AiryAiPrime", "[", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", 
                FractionBox["3", "2"]}], ")"}], 
              RowBox[{"1", "/", "3"}]], " ", "t"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            FractionBox["2", "3"], "]"}]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"1", "/", "3"}]], " ", 
           SuperscriptBox["2", 
            RowBox[{"2", "/", "3"}]], " ", 
           SqrtBox["3"], " ", 
           RowBox[{"AiryBiPrime", "[", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", 
                FractionBox["3", "2"]}], ")"}], 
              RowBox[{"1", "/", "3"}]], " ", "t"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            FractionBox["2", "3"], "]"}]}]}], ")"}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"2", "/", "3"}]], " ", 
           SuperscriptBox["2", 
            RowBox[{"1", "/", "3"}]], " ", 
           RowBox[{"AiryAi", "[", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", 
                FractionBox["3", "2"]}], ")"}], 
              RowBox[{"1", "/", "3"}]], " ", "t"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            FractionBox["1", "3"], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"2", "/", "3"}]], " ", 
           SuperscriptBox["2", 
            RowBox[{"1", "/", "3"}]], " ", 
           SqrtBox["3"], " ", 
           RowBox[{"AiryBi", "[", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", 
                FractionBox["3", "2"]}], ")"}], 
              RowBox[{"1", "/", "3"}]], " ", "t"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            FractionBox["1", "3"], "]"}]}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["3", 
            RowBox[{"2", "/", "3"}]], " ", 
           RowBox[{"AiryAi", "[", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", 
                FractionBox["3", "2"]}], ")"}], 
              RowBox[{"1", "/", "3"}]], " ", "t"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            FractionBox["2", "3"], "]"}]}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["3", 
            RowBox[{"1", "/", "6"}]], " ", 
           RowBox[{"AiryBi", "[", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", 
                FractionBox["3", "2"]}], ")"}], 
              RowBox[{"1", "/", "3"}]], " ", "t"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            FractionBox["2", "3"], "]"}]}]}], ")"}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{570, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[10]=",
 CellID->143741239]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", " ", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", "sol"}], "]"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1"}], ",", "10"}], "}"}], ",", " ", 
   RowBox[{"WorkingPrecision", " ", "\[Rule]", " ", "20"}]}], "]"}]], "Input",\

 CellTags->"b:5.3",
 CellLabel->"In[11]:=",
 CellID->28118],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[11]=",
 CellID->88075883]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " function can be used to trace the solution curve ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", 
     RowBox[{"y", "[", "t", "]"}]}], "}"}], TraditionalForm]], "InlineMath"],
 " in the plane."
}], "MathCaption",
 CellTags->"b:5.3",
 CellID->15199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", "sol"}], "]"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1"}], ",", "7"}], "}"}], ",", " ", 
   RowBox[{"WorkingPrecision", " ", "\[Rule]", " ", "20"}]}], "]"}]], "Input",\

 CellTags->"b:5.3",
 CellLabel->"In[12]:=",
 CellID->11785],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 253},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[12]=",
 CellID->718140921]
}, Open  ]],

Cell["Here is the plot for the solution to a DAE. ", "MathCaption",
 CellTags->"b:5.3",
 CellID->19199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"3", "*", 
         RowBox[{"y", "[", "t", "]"}]}]}], " ", "\[Equal]", " ", 
       RowBox[{"UnitStep", "[", "t", "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], "-", 
        RowBox[{"5", "*", 
         RowBox[{"y", "[", "t", "]"}]}]}], "\[Equal]", 
       RowBox[{"t", "^", "2"}]}], ",", " ", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
    " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[13]:=",
 CellID->12420],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "96"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "430"}], "-", 
          RowBox[{"90", " ", "t"}], "+", 
          RowBox[{"177", " ", 
           SuperscriptBox["t", "2"]}], "+", 
          RowBox[{"526", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{
             SqrtBox[
              FractionBox["3", "5"]], " ", "t"}], "]"}]}], "+", 
          RowBox[{"62", " ", 
           SqrtBox["15"], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             SqrtBox[
              FractionBox["3", "5"]], " ", "t"}], "]"}]}], "-", 
          RowBox[{"160", " ", 
           RowBox[{"UnitStep", "[", 
            RowBox[{"-", "t"}], "]"}]}], "+", 
          RowBox[{"160", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{
             SqrtBox[
              FractionBox["3", "5"]], " ", "t"}], "]"}], " ", 
           RowBox[{"UnitStep", "[", 
            RowBox[{"-", "t"}], "]"}]}]}], ")"}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "480"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "430"}], "-", 
          RowBox[{"90", " ", "t"}], "+", 
          RowBox[{"81", " ", 
           SuperscriptBox["t", "2"]}], "+", 
          RowBox[{"526", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{
             SqrtBox[
              FractionBox["3", "5"]], " ", "t"}], "]"}]}], "+", 
          RowBox[{"62", " ", 
           SqrtBox["15"], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             SqrtBox[
              FractionBox["3", "5"]], " ", "t"}], "]"}]}], "-", 
          RowBox[{"160", " ", 
           RowBox[{"UnitStep", "[", 
            RowBox[{"-", "t"}], "]"}]}], "+", 
          RowBox[{"160", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{
             SqrtBox[
              FractionBox["3", "5"]], " ", "t"}], "]"}], " ", 
           RowBox[{"UnitStep", "[", 
            RowBox[{"-", "t"}], "]"}]}]}], ")"}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{541, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[13]=",
 CellID->375997990]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}], ",", " ", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], "-", 
        RowBox[{"5", "*", 
         RowBox[{"y", "[", "t", "]"}]}]}]}], "}"}], "/.", "sol"}], "]"}], ",",
    " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[14]:=",
 CellID->18271],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[14]=",
 CellID->118802028]
}, Open  ]],

Cell["Here is the general solution to a linear PDE.", "MathCaption",
 CellTags->"b:5.3",
 CellID->27415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "+", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}], "\[Equal]", 
     RowBox[{"Exp", "[", "x", "]"}]}], ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[15]:=",
 CellID->6085],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["x", "3"]}], "+", 
           RowBox[{"3", " ", "y"}]}], ")"}]}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{321, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[15]=",
 CellID->49199284]
}, Open  ]],

Cell[TextData[{
 "Here is a plot of the solution surface for a particular choice of the \
arbitrary function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:5.3",
 CellID->3580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "y"}], "]"}], "/.", "sol"}], "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "[", "t_", "]"}], "\[Rule]", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"3", "*", "t"}], "]"}]}], "}"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Mesh", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellTags->"b:5.3",
 CellLabel->"In[16]:=",
 CellID->1331],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 299},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.3",
 CellLabel->"Out[16]=",
 CellID->6343060]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->211781956],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Plotting the Solution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveSolutionVerification"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveGeneratedParametersOption"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 44.7041716}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A plot of the solution given by DSolve can give useful information about \
the nature of the solution, for instance, whether it is oscillatory in \
nature. It can also serve as a means of solution verification if the shape of \
the graph is known from theory or from plotting the vector field associated \
with the differential equation. A few examples that use different Mathematica \
graphics functions follow. Here is the general solution to a linear \
first-order equation. The solution can be plotted for specific values of the \
constant C[1] using Plot. The use of Evaluate reduces the time taken by Plot \
and can also help in cases where the solution has discontinuities.", 
    "synonyms" -> {}, "title" -> "Plotting the Solution", "type" -> 
    "Tutorial", "uri" -> "tutorial/DSolvePlottingTheSolution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:54"->{
  Cell[1280, 43, 83, 2, 70, "Title",
   CellTags->{"c:54", "b:5.3"},
   CellID->3989]},
 "b:5.3"->{
  Cell[1280, 43, 83, 2, 70, "Title",
   CellTags->{"c:54", "b:5.3"},
   CellID->3989],
  Cell[1366, 47, 633, 16, 70, "Text",
   CellTags->"b:5.3",
   CellID->9320],
  Cell[2002, 65, 129, 4, 70, "MathCaption",
   CellTags->"b:5.3",
   CellID->23165],
  Cell[2156, 73, 434, 15, 28, "Input",
   CellTags->"b:5.3",
   CellID->15431],
  Cell[2593, 90, 1522, 49, 85, "Output",
   CellTags->"b:5.3",
   CellID->527049100],
  Cell[4130, 142, 749, 25, 70, "MathCaption",
   CellTags->"b:5.3",
   CellID->11293],
  Cell[4904, 171, 529, 17, 28, "Input",
   CellTags->"b:5.3",
   CellID->17206],
  Cell[5436, 190, 3904, 69, 134, "Output",
   Evaluatable->False,
   CellTags->"b:5.3",
   CellID->10715922],
  Cell[9355, 262, 152, 5, 70, "MathCaption",
   CellTags->"b:5.3",
   CellID->16948],
  Cell[9532, 271, 742, 25, 70, "Input",
   CellTags->"b:5.3",
   CellID->2206],
  Cell[10277, 298, 2386, 70, 128, "Output",
   CellTags->"b:5.3",
   CellID->73909756],
  Cell[12700, 373, 299, 10, 28, "Input",
   CellTags->"b:5.3",
   CellID->18166],
  Cell[13002, 385, 2872, 52, 130, "Output",
   Evaluatable->False,
   CellTags->"b:5.3",
   CellID->551627976],
  Cell[15889, 440, 149, 5, 70, "MathCaption",
   CellTags->"b:5.3",
   CellID->16697],
  Cell[16063, 449, 498, 17, 70, "Input",
   CellTags->"b:5.3",
   CellID->31020],
  Cell[16564, 468, 3190, 102, 170, "Output",
   CellTags->"b:5.3",
   CellID->563202646],
  Cell[19791, 575, 353, 12, 28, "Input",
   CellTags->"b:5.3",
   CellID->15529],
  Cell[20147, 589, 4600, 80, 236, "Output",
   Evaluatable->False,
   CellTags->"b:5.3",
   CellID->421314032],
  Cell[24762, 672, 115, 2, 70, "MathCaption",
   CellTags->"b:5.3",
   CellID->30109],
  Cell[24902, 678, 564, 19, 70, "Input",
   CellTags->"b:5.3",
   CellID->17984],
  Cell[25469, 699, 297, 7, 70, "Message",
   CellTags->"b:5.3",
   CellID->603560234],
  Cell[25769, 708, 1102, 38, 92, "Output",
   CellTags->"b:5.3",
   CellID->26969210],
  Cell[26886, 749, 359, 11, 70, "MathCaption",
   CellTags->"b:5.3",
   CellID->21617],
  Cell[27270, 764, 510, 18, 70, "Input",
   CellTags->"b:5.3",
   CellID->4015],
  Cell[27783, 784, 836, 30, 79, "Output",
   CellTags->"b:5.3",
   CellID->127224169],
  Cell[28656, 819, 335, 11, 70, "Input",
   CellTags->"b:5.3",
   CellID->3684],
  Cell[28994, 832, 104171, 1733, 70, "Output",
   CellTags->"b:5.3",
   CellID->75038455],
  Cell[133180, 2568, 467, 14, 70, "MathCaption",
   CellTags->"b:5.3",
   CellID->17906],
  Cell[133672, 2586, 860, 27, 70, "Input",
   CellTags->"b:5.3",
   CellID->25928],
  Cell[134535, 2615, 4890, 141, 229, "Output",
   CellTags->"b:5.3",
   CellID->143741239],
  Cell[139462, 2761, 491, 17, 28, "Input",
   CellTags->"b:5.3",
   CellID->28118],
  Cell[139956, 2780, 13189, 221, 244, "Output",
   Evaluatable->False,
   CellTags->"b:5.3",
   CellID->88075883],
  Cell[153160, 3004, 458, 16, 70, "MathCaption",
   CellTags->"b:5.3",
   CellID->15199],
  Cell[153643, 3024, 495, 17, 28, "Input",
   CellTags->"b:5.3",
   CellID->11785],
  Cell[154141, 3043, 9851, 166, 274, "Output",
   Evaluatable->False,
   CellTags->"b:5.3",
   CellID->718140921],
  Cell[164007, 3212, 103, 2, 70, "MathCaption",
   CellTags->"b:5.3",
   CellID->19199],
  Cell[164135, 3218, 917, 29, 70, "Input",
   CellTags->"b:5.3",
   CellID->12420],
  Cell[165055, 3249, 2485, 76, 192, "Output",
   CellTags->"b:5.3",
   CellID->375997990],
  Cell[167577, 3330, 553, 19, 28, "Input",
   CellTags->"b:5.3",
   CellID->18271],
  Cell[168133, 3351, 7928, 135, 245, "Output",
   Evaluatable->False,
   CellTags->"b:5.3",
   CellID->118802028],
  Cell[176076, 3489, 104, 2, 70, "MathCaption",
   CellTags->"b:5.3",
   CellID->27415],
  Cell[176205, 3495, 636, 21, 70, "Input",
   CellTags->"b:5.3",
   CellID->6085],
  Cell[176844, 3518, 723, 25, 51, "Output",
   CellTags->"b:5.3",
   CellID->49199284],
  Cell[177582, 3546, 306, 11, 70, "MathCaption",
   CellTags->"b:5.3",
   CellID->3580],
  Cell[177913, 3561, 789, 25, 47, "Input",
   CellTags->"b:5.3",
   CellID->1331],
  Cell[178705, 3588, 81146, 1335, 320, "Output",
   Evaluatable->False,
   CellTags->"b:5.3",
   CellID->6343060]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:54", 262886, 4997},
 {"b:5.3", 262986, 5001}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 83, 2, 70, "Title",
 CellTags->{"c:54", "b:5.3"},
 CellID->3989],
Cell[1366, 47, 633, 16, 70, "Text",
 CellTags->"b:5.3",
 CellID->9320],
Cell[2002, 65, 129, 4, 70, "MathCaption",
 CellTags->"b:5.3",
 CellID->23165],
Cell[CellGroupData[{
Cell[2156, 73, 434, 15, 28, "Input",
 CellTags->"b:5.3",
 CellID->15431],
Cell[2593, 90, 1522, 49, 85, "Output",
 CellTags->"b:5.3",
 CellID->527049100]
}, Open  ]],
Cell[4130, 142, 749, 25, 70, "MathCaption",
 CellTags->"b:5.3",
 CellID->11293],
Cell[CellGroupData[{
Cell[4904, 171, 529, 17, 28, "Input",
 CellTags->"b:5.3",
 CellID->17206],
Cell[5436, 190, 3904, 69, 134, "Output",
 Evaluatable->False,
 CellTags->"b:5.3",
 CellID->10715922]
}, Open  ]],
Cell[9355, 262, 152, 5, 70, "MathCaption",
 CellTags->"b:5.3",
 CellID->16948],
Cell[CellGroupData[{
Cell[9532, 271, 742, 25, 70, "Input",
 CellTags->"b:5.3",
 CellID->2206],
Cell[10277, 298, 2386, 70, 128, "Output",
 CellTags->"b:5.3",
 CellID->73909756]
}, Open  ]],
Cell[CellGroupData[{
Cell[12700, 373, 299, 10, 28, "Input",
 CellTags->"b:5.3",
 CellID->18166],
Cell[13002, 385, 2872, 52, 130, "Output",
 Evaluatable->False,
 CellTags->"b:5.3",
 CellID->551627976]
}, Open  ]],
Cell[15889, 440, 149, 5, 70, "MathCaption",
 CellTags->"b:5.3",
 CellID->16697],
Cell[CellGroupData[{
Cell[16063, 449, 498, 17, 70, "Input",
 CellTags->"b:5.3",
 CellID->31020],
Cell[16564, 468, 3190, 102, 170, "Output",
 CellTags->"b:5.3",
 CellID->563202646]
}, Open  ]],
Cell[CellGroupData[{
Cell[19791, 575, 353, 12, 28, "Input",
 CellTags->"b:5.3",
 CellID->15529],
Cell[20147, 589, 4600, 80, 236, "Output",
 Evaluatable->False,
 CellTags->"b:5.3",
 CellID->421314032]
}, Open  ]],
Cell[24762, 672, 115, 2, 70, "MathCaption",
 CellTags->"b:5.3",
 CellID->30109],
Cell[CellGroupData[{
Cell[24902, 678, 564, 19, 70, "Input",
 CellTags->"b:5.3",
 CellID->17984],
Cell[25469, 699, 297, 7, 70, "Message",
 CellTags->"b:5.3",
 CellID->603560234],
Cell[25769, 708, 1102, 38, 92, "Output",
 CellTags->"b:5.3",
 CellID->26969210]
}, Open  ]],
Cell[26886, 749, 359, 11, 70, "MathCaption",
 CellTags->"b:5.3",
 CellID->21617],
Cell[CellGroupData[{
Cell[27270, 764, 510, 18, 70, "Input",
 CellTags->"b:5.3",
 CellID->4015],
Cell[27783, 784, 836, 30, 79, "Output",
 CellTags->"b:5.3",
 CellID->127224169]
}, Open  ]],
Cell[CellGroupData[{
Cell[28656, 819, 335, 11, 70, "Input",
 CellTags->"b:5.3",
 CellID->3684],
Cell[28994, 832, 104171, 1733, 70, "Output",
 CellTags->"b:5.3",
 CellID->75038455]
}, Open  ]],
Cell[133180, 2568, 467, 14, 70, "MathCaption",
 CellTags->"b:5.3",
 CellID->17906],
Cell[CellGroupData[{
Cell[133672, 2586, 860, 27, 70, "Input",
 CellTags->"b:5.3",
 CellID->25928],
Cell[134535, 2615, 4890, 141, 229, "Output",
 CellTags->"b:5.3",
 CellID->143741239]
}, Open  ]],
Cell[CellGroupData[{
Cell[139462, 2761, 491, 17, 28, "Input",
 CellTags->"b:5.3",
 CellID->28118],
Cell[139956, 2780, 13189, 221, 244, "Output",
 Evaluatable->False,
 CellTags->"b:5.3",
 CellID->88075883]
}, Open  ]],
Cell[153160, 3004, 458, 16, 70, "MathCaption",
 CellTags->"b:5.3",
 CellID->15199],
Cell[CellGroupData[{
Cell[153643, 3024, 495, 17, 28, "Input",
 CellTags->"b:5.3",
 CellID->11785],
Cell[154141, 3043, 9851, 166, 274, "Output",
 Evaluatable->False,
 CellTags->"b:5.3",
 CellID->718140921]
}, Open  ]],
Cell[164007, 3212, 103, 2, 70, "MathCaption",
 CellTags->"b:5.3",
 CellID->19199],
Cell[CellGroupData[{
Cell[164135, 3218, 917, 29, 70, "Input",
 CellTags->"b:5.3",
 CellID->12420],
Cell[165055, 3249, 2485, 76, 192, "Output",
 CellTags->"b:5.3",
 CellID->375997990]
}, Open  ]],
Cell[CellGroupData[{
Cell[167577, 3330, 553, 19, 28, "Input",
 CellTags->"b:5.3",
 CellID->18271],
Cell[168133, 3351, 7928, 135, 245, "Output",
 Evaluatable->False,
 CellTags->"b:5.3",
 CellID->118802028]
}, Open  ]],
Cell[176076, 3489, 104, 2, 70, "MathCaption",
 CellTags->"b:5.3",
 CellID->27415],
Cell[CellGroupData[{
Cell[176205, 3495, 636, 21, 70, "Input",
 CellTags->"b:5.3",
 CellID->6085],
Cell[176844, 3518, 723, 25, 51, "Output",
 CellTags->"b:5.3",
 CellID->49199284]
}, Open  ]],
Cell[177582, 3546, 306, 11, 70, "MathCaption",
 CellTags->"b:5.3",
 CellID->3580],
Cell[CellGroupData[{
Cell[177913, 3561, 789, 25, 47, "Input",
 CellTags->"b:5.3",
 CellID->1331],
Cell[178705, 3588, 81146, 1335, 320, "Output",
 Evaluatable->False,
 CellTags->"b:5.3",
 CellID->6343060]
}, Open  ]],
Cell[CellGroupData[{
Cell[259888, 4928, 72, 1, 70, "RelatedTutorialsSection",
 CellID->211781956],
Cell[259963, 4931, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[260167, 4938, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

