(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25698,        976]
NotebookOptionsPosition[     15241,        599]
NotebookOutlinePosition[     22086,        830]
CellTagsIndexPosition[     21885,        819]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["References", "Title",
 CellTags->{"c:60", "b:6.0"},
 CellID->8387],

Cell[TextData[{
 "[AB04] M. L. Abell and J. P. Braselton, ",
 StyleBox["Differential Equations with ",
  FontSlant->"Italic"],
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", 3rd ed., New York: Elsevier Academic Press, 2004."
}], "Text",
 CellTags->"b:6.0",
 CellID->13444],

Cell[TextData[{
 "[A89] S. A. Abramov, \[OpenCurlyDoubleQuote]Rational solutions of linear",
 " ",
 "differential and difference equations with polynomial coefficients, \
\[CloseCurlyDoubleQuote] ",
 StyleBox["USSR Comput. Maths. Math. Phys.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["29",
  FontWeight->"Bold"],
 ", 1989 pp. 7\[Dash]12."
}], "Text",
 CellTags->"b:6.0",
 CellID->23186],

Cell[TextData[{
 "[A96] S. A. Abramov, \[OpenCurlyDoubleQuote]Symbolic search algorithms \
for",
 " ",
 "partial d\[CloseCurlyQuote]Alembertian solutions of linear equations, \
\[CloseCurlyDoubleQuote] ",
 StyleBox["Programming and Computer Software",
  FontSlant->"Italic"],
 ", ",
 StyleBox["22",
  FontWeight->"Bold"],
 "(1), 1996 p. 26. "
}], "Text",
 CellTags->"b:6.0",
 CellID->14507],

Cell[TextData[{
 "[AB01] S. A. Abramov and M. Bronstein, \[OpenCurlyDoubleQuote]On solutions \
of linear functional systems,\[CloseCurlyDoubleQuote] in ",
 StyleBox["Proc. ISSAC\[CloseCurlyQuote]01",
  FontSlant->"Italic"],
 ", pp. 1\[Dash]6."
}], "Text",
 CellTags->"b:6.0",
 CellID->4360],

Cell[TextData[{
 "[AK91] S. A. Abramov and K. Yu. Kvansenko, \[OpenCurlyDoubleQuote]Fast \
algorithms to search for the rational solutions of linear differential \
equations with polynomial coefficients,\[CloseCurlyDoubleQuote] ",
 StyleBox["Proc. ISSAC",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 StyleBox["91",
  FontSlant->"Italic"],
 ", pp. 267\[Dash]270."
}], "Text",
 CellTags->"b:6.0",
 CellID->17827],

Cell[TextData[{
 "[AP94] S. A. Abramov and M. Petkovsek, \[OpenCurlyDoubleQuote]D\
\[CloseCurlyQuote]Alembertian solutions of linear differential and \
difference",
 " ",
 "equations,\[CloseCurlyDoubleQuote] ",
 StyleBox["Proc. ISSAC",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 StyleBox["94",
  FontSlant->"Italic"],
 ", pp. 169\[Dash]174. "
}], "Text",
 CellTags->"b:6.0",
 CellID->28074],

Cell[TextData[{
 "[ABP95] S. A. Abramov, M. Bronstein, and M. Petkovsek,",
 " ",
 "\[OpenCurlyDoubleQuote]On polynomial solutions of linear operator \
equations, \[CloseCurlyDoubleQuote] ",
 StyleBox["Proc. ISSAC",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 StyleBox["95",
  FontSlant->"Italic"],
 ", pp. 290\[Dash]296."
}], "Text",
 CellTags->"b:6.0",
 CellID->26431],

Cell[TextData[{
 "[B93] A. Bocharov, \[OpenCurlyDoubleQuote]Symbolic solvers for nonlinear",
 " ",
 "differential equations,\[CloseCurlyDoubleQuote] ",
 StyleBox["The Mathematica Journal",
  FontSlant->"Italic"],
 ", ",
 StyleBox["3",
  FontWeight->"Bold"],
 "(2), 1993 pp. 63\[Dash]69."
}], "Text",
 CellTags->"b:6.0",
 CellID->7152],

Cell[TextData[{
 "[BD97] W. F. Boyce and R. C. DiPrima, ",
 StyleBox["Elementary Differential Equations",
  FontSlant->"Italic"],
 ", New York: John Wiley and Sons, 1997."
}], "Text",
 CellTags->"b:6.0",
 CellID->30271],

Cell[TextData[{
 "[BM91] C. B. Boyer and U. C. Merzbach, ",
 StyleBox["A History of Mathematics",
  FontSlant->"Italic"],
 ", 2nd ed., New York: John Wiley, 1991."
}], "Text",
 CellTags->"b:6.0",
 CellID->10268],

Cell[TextData[{
 "[B91] M. Bronstein, \[OpenCurlyDoubleQuote]The Risch differential equation \
on an algebraic curve,\[CloseCurlyDoubleQuote] ",
 StyleBox["Proc. ISSAC\[CloseCurlyQuote]91",
  FontSlant->"Italic"],
 ", pp. 241\[Dash]246."
}], "Text",
 CellTags->"b:6.0",
 CellID->4693],

Cell[TextData[{
 "[B92] M. Bronstein, \[OpenCurlyDoubleQuote]On solutions of linear ordinary \
differential equations in their coefficient field,\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symbolic Computation",
  FontSlant->"Italic"],
 ", ",
 StyleBox["13",
  FontWeight->"Bold"],
 ", 1992 pp. 413\[Dash]439."
}], "Text",
 CellTags->"b:6.0",
 CellID->19885],

Cell[TextData[{
 "[B92a] M. Bronstein, \[OpenCurlyDoubleQuote]Integration and differential \
equations in computer algebra,\[CloseCurlyDoubleQuote] ",
 StyleBox["Programming and Computer Software",
  FontSlant->"Italic"],
 ", ",
 StyleBox["18",
  FontWeight->"Bold"],
 "(5), 1992 pp. 201\[Dash]217."
}], "Text",
 CellTags->"b:6.0",
 CellID->337],

Cell[TextData[{
 "[B92b] M. Bronstein, \[OpenCurlyDoubleQuote]Linear ordinary differential \
equations: Breaking through the order 2 barrier,\[CloseCurlyDoubleQuote] ",
 StyleBox["Proc. ISSAC",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 StyleBox["92",
  FontSlant->"Italic"],
 ", pp. 42\[Dash]48."
}], "Text",
 CellTags->"b:6.0",
 CellID->31311],

Cell[TextData[{
 StyleBox["[C80] S. L. Campbell, ",
  FontFamily->"Times New Roman"],
 StyleBox["Singular Systems of Differential Equations I",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 StyleBox[", London: Pitman, 1980.",
  FontFamily->"Times New Roman"]
}], "Text",
 CellTags->"b:6.0",
 CellID->17604],

Cell[TextData[{
 StyleBox["[C82] S. L. Campbell, ",
  FontFamily->"Times New Roman"],
 StyleBox["Singular Systems of Differential Equations II",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 StyleBox[", London: Pitman, 1982.",
  FontFamily->"Times New Roman"]
}], "Text",
 CellTags->"b:6.0",
 CellID->12677],

Cell[TextData[{
 "[CC04] L. Chan and E. S. Cheb-Terrab,",
 " ",
 "\[OpenCurlyDoubleQuote]Non-Liouvillian solutions for second order linear \
ODEs,\[CloseCurlyDoubleQuote] ",
 StyleBox["Proc. ISSAC",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 StyleBox["04",
  FontSlant->"Italic"],
 ", ",
 StyleBox["Santander, Spain",
  FontSlant->"Italic"],
 ", pp. 80\[Dash]86."
}], "Text",
 CellTags->"b:6.0",
 CellID->406],

Cell[TextData[{
 "[CDM97] E. S. Cheb-Terrab, L. G. S. Duarte, and L. A. C. P. da Mota, \
\[OpenCurlyDoubleQuote]Computer algebra solving of first order ODEs using",
 " ",
 "symmetry methods,\[CloseCurlyDoubleQuote] ",
 StyleBox["Comp. Phys. Comm.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["101",
  FontWeight->"Bold"],
 ", 1997 p. 254."
}], "Text",
 CellTags->"b:6.0",
 CellID->7768],

Cell[TextData[{
 "[CR99] E. S. Cheb-Terrab and A. D. Roche,",
 " ",
 "\[OpenCurlyDoubleQuote]Integrating factors ",
 StyleBox["for",
  FontVariations->{"CompatibilityType"->0}],
 " second order ODEs,\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symbolic Computation",
  FontSlant->"Italic"],
 ", ",
 StyleBox["27",
  FontWeight->"Bold"],
 ", 1999 p. 501."
}], "Text",
 CellTags->"b:6.0",
 CellID->29022],

Cell[TextData[{
 "[CR00] E. S. Cheb-Terrab and A. D. Roche, \[OpenCurlyDoubleQuote]Abel ODEs: \
Equivalence and integrable classes,\[CloseCurlyDoubleQuote] ",
 StyleBox["Comp. Phys. Comm.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["130",
  FontWeight->"Bold"],
 ", 2000 p. 204."
}], "Text",
 CellTags->"b:6.0",
 CellID->19413],

Cell[TextData[{
 StyleBox["[D58] M. P. Drazin, \[OpenCurlyDoubleQuote]Pseudo inverses in",
  FontFamily->"Times New Roman"],
 " ",
 StyleBox["associative rays and semigroups,\[CloseCurlyDoubleQuote] ",
  FontFamily->"Times New Roman"],
 StyleBox["American Mathematical Monthly",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontFamily->"Times New Roman"],
 StyleBox["65",
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],
 StyleBox[", 1958 pp. 506",
  FontFamily->"Times New Roman"],
 "\[Dash]",
 StyleBox["514.",
  FontFamily->"Times New Roman"]
}], "Text",
 CellTags->"b:6.0",
 CellID->5000],

Cell[TextData[{
 "[F59] A. R. Forsyth, ",
 StyleBox["Theory of Differential Equations, ",
  FontSlant->"Italic"],
 "6 vols.",
 ", New York: Dover, 1959."
}], "Text",
 CellTags->"b:6.0",
 CellID->542],

Cell[TextData[{
 "[I99] N. H. Ibragimov, ",
 StyleBox["Elementary Lie Group Analysis and Ordinary Differential Equations",
  
  FontSlant->"Italic"],
 ", New York: John Wiley & Sons, 1999."
}], "Text",
 CellTags->{"I99", "b:6.0"},
 CellID->17537],

Cell[TextData[{
 "[I44] E. L. Ince, ",
 StyleBox["Ordinary Differential Equations",
  FontSlant->"Italic"],
 ", New York: Dover, 1944."
}], "Text",
 CellTags->"b:6.0",
 CellID->30038],

Cell[TextData[{
 "[K59] E. Kamke, ",
 StyleBox["Differentialgleichungen: Losungsmethoden und Losungen",
  FontSlant->"Italic"],
 ", Leipzig: Akademische Verlagsgesellschaft, 1959."
}], "Text",
 CellTags->{"K59", "b:6.0"},
 CellID->21388],

Cell[TextData[{
 "[K74] E. Kamke, ",
 StyleBox["Differentialgleichungen Losungsmethoden und Losungen, Bd. II:",
  FontSlant->"Italic"],
 " ",
 StyleBox["Partielle differentialgleichungen",
  FontSlant->"Italic"],
 ", New York: Chelsea Publishing Co., 1974."
}], "Text",
 CellTags->{"K74", "b:6.0"},
 CellID->7355],

Cell[TextData[{
 "[K00] J. Kevorkian, ",
 StyleBox["Partial Differential Equations: Analytical Solution Techniques",
  FontSlant->"Italic"],
 ", New York: Springer-Verlag, 2000."
}], "Text",
 CellTags->{"K00", "b:6.0"},
 CellID->13289],

Cell[TextData[{
 "[K72] M. Kline, ",
 StyleBox["Mathematical Thought from Ancient to Modern Times",
  FontSlant->"Italic"],
 ", Vol. 2, New York: Oxford University Press, 1972."
}], "Text",
 CellTags->"b:6.0",
 CellID->31647],

Cell[TextData[{
 "[K86] J. J. Kovacic, \[OpenCurlyDoubleQuote]An algorithm for solving second \
order linear homogeneous differential equations,\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symbolic Computation",
  FontSlant->"Italic"],
 ", ",
 StyleBox["2",
  FontWeight->"Bold"],
 ", 1986 pp. 3\[Dash]43."
}], "Text",
 CellTags->"b:6.0",
 CellID->3181],

Cell["\<\
[L01] J. J. Kovacic, \[OpenCurlyDoubleQuote]An algorithm for solving second \
order linear homogeneous differential equations,\[CloseCurlyDoubleQuote] \
Lecture, City College of New York, 2001.\
\>", "Text",
 CellTags->"b:6.0",
 CellID->13093],

Cell[TextData[{
 "[KPS03] P. K. Kythe, P. Puri, and M. R. Sch\[ADoubleDot]ferkotter, ",
 StyleBox["Partial Differential Equations and Boundary Value Problems with",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", 2nd ed., Boca Raton, FL: Chapman and Hall/CRC, ",
  FontVariations->{"CompatibilityType"->0}],
 "2003."
}], "Text",
 CellTags->"b:6.0",
 CellID->16584],

Cell[TextData[{
 "[L65] N. N. Lebedev, ",
 StyleBox["Special Functions and Their Applications",
  FontSlant->"Italic"],
 ", Englewood-Cliffs, NJ: Prentice-Hall, 1965."
}], "Text",
 CellTags->"b:6.0",
 CellID->10987],

Cell[TextData[{
 StyleBox["[M00] C. D. Meyer, ",
  FontFamily->"Times New Roman"],
 StyleBox["Matrix Analysis and Applied Linear Algebra",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 StyleBox[", Philadelphia: SIAM, 2000.",
  FontFamily->"Times New Roman"]
}], "Text",
 CellTags->"b:6.0",
 CellID->10761],

Cell[TextData[{
 "[M60] G. M. Murphy, ",
 StyleBox["Ordinary Differential Equations and Their Solutions",
  FontSlant->"Italic"],
 ", New York: Van Nostrand, 1960."
}], "Text",
 CellTags->"b:6.0",
 CellID->20493],

Cell[TextData[{
 "[M47] N. W. McLachlan, ",
 StyleBox["Theory and Application of Mathieu Functions",
  FontSlant->"Italic"],
 ", Oxford: Oxford University Press, 1947."
}], "Text",
 CellTags->"b:6.0",
 CellID->8217],

Cell[TextData[{
 "[O95] P. J. Olver, ",
 StyleBox["Equivalence, Invariants and Symmetry",
  FontSlant->"Italic"],
 ", Cambridge: Cambridge University Press, 1995."
}], "Text",
 CellTags->"b:6.0",
 CellID->9501],

Cell[TextData[{
 "[PZ95] A. D. Polynanin and V. F. Zaitsev, ",
 StyleBox["Handbook of Exact Solutions for Ordinary Differential Equations",
  FontSlant->"Italic"],
 ", Boca Raton, FL: CRC Press, 1995."
}], "Text",
 CellTags->"b:6.0",
 CellID->17482],

Cell[TextData[{
 "[S81] B. D. Saunders, \[OpenCurlyDoubleQuote]An Implementation of Kovacic\
\[CloseCurlyQuote]s Algorithm ",
 StyleBox["for ",
  FontVariations->{"CompatibilityType"->0}],
 "Solving Second Order Linear Homogeneous Differential Equations, \
\[CloseCurlyDoubleQuote] in ",
 StyleBox["Proc. SYMSAC",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 StyleBox["81",
  FontSlant->"Italic"],
 " (P. Wang, ed.), New York: ACM, p. 105. "
}], "Text",
 CellTags->"b:6.0",
 CellID->29447],

Cell[TextData[{
 "[S85] L. Schlesinger, ",
 StyleBox["Handbuch der Theorie der linearen differentialgleichungen",
  FontSlant->"Italic"],
 ", Leipzig: Teubner, 1985."
}], "Text",
 CellTags->"b:6.0",
 CellID->15665],

Cell[TextData[{
 "[SS98] M. Shirvani and J. W.-H. So, \[OpenCurlyDoubleQuote]Solutions of",
 " ",
 "linear differential algebraic equations,\[CloseCurlyDoubleQuote] ",
 StyleBox["SIAM Review",
  FontSlant->"Italic"],
 ", ",
 StyleBox["40",
  FontWeight->"Bold"],
 "(2), 1998 pp. 344\[Dash]346."
}], "Text",
 CellTags->"b:6.0",
 CellID->10753],

Cell[TextData[{
 "[S57] I. Sneddon, ",
 StyleBox["Elements of Partial Differential Equations",
  FontSlant->"Italic"],
 ", Singapore: McGraw-Hill, 1957."
}], "Text",
 CellTags->{"S57", "b:6.0"},
 CellID->22104],

Cell[TextData[{
 "[T05] M. Trott, ",
 StyleBox["The Mathematica GuideBook for Symbolics",
  FontSlant->"Italic"],
 ", Berlin: Springer-Verlag, 2005."
}], "Text",
 CellTags->"b:6.0",
 CellID->15084],

Cell[TextData[{
 "[UW96] F. Ulmer and J-A. Weil, \[OpenCurlyDoubleQuote]Note on Kovacic\
\[CloseCurlyQuote]s algorithm,\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symbolic Computation",
  FontSlant->"Italic"],
 ", ",
 StyleBox["22",
  FontWeight->"Bold"],
 ", 1996. pp. 179\[Dash]200. "
}], "Text",
 CellTags->"b:6.0",
 CellID->19095],

Cell[TextData[{
 "[WW27] E. T. Whittaker and G. N. Watson, ",
 StyleBox["A Course of Modern Analysis",
  FontSlant->"Italic"],
 ", 4th ed., Cambridge: Cambridge University Press, 1927."
}], "Text",
 CellTags->"b:6.0",
 CellID->13525],

Cell[TextData[{
 "[W02] S. Wolfram, ",
 StyleBox["A New Kind of Science",
  FontSlant->"Italic"],
 ", Champaign: Wolfram Media, Inc., 2002."
}], "Text",
 CellTags->"b:6.0",
 CellID->30221],

Cell[TextData[{
 "[W04] S. Wolfram, ",
 StyleBox["The",
  FontSlant->"Italic"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 StyleBox["Book",
  FontSlant->"Italic"],
 ", 5th ed., Champaign: Wolfram Media, Inc., 2004."
}], "Text",
 CellTags->"b:6.0",
 CellID->3964],

Cell[TextData[{
 "[Z89] D. Zwillinger, ",
 StyleBox["Handbook of Differential Equations",
  FontSlant->"Italic"],
 ", San Diego: Academic Press, 1989."
}], "Text",
 CellTags->"b:6.0",
 CellID->21781]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"References - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveWellPosedness"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 46.3135878}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "[AB04] M. L. Abell and J. P. Braselton, Differential Equations with \
Mathematica, 3rd ed., New York: Elsevier Academic Press, 2004. [A89] S. A. \
Abramov, 'Rational solutions of linear differential and difference equations \
with polynomial coefficients, ' USSR Comput. Maths. Math. Phys., 29, 1989 pp. \
7-12. [A96] S. A. Abramov, 'Symbolic search algorithms for partial \
d'Alembertian solutions of linear equations, ' Programming and Computer \
Software, 22(1), 1996 p. 26. ", "synonyms" -> {}, "title" -> "References", 
    "type" -> "Tutorial", "uri" -> "tutorial/DSolveReferences"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:60"->{
  Cell[728, 29, 72, 2, 70, "Title",
   CellTags->{"c:60", "b:6.0"},
   CellID->8387]},
 "b:6.0"->{
  Cell[728, 29, 72, 2, 70, "Title",
   CellTags->{"c:60", "b:6.0"},
   CellID->8387],
  Cell[803, 33, 278, 9, 70, "Text",
   CellTags->"b:6.0",
   CellID->13444],
  Cell[1084, 44, 387, 13, 70, "Text",
   CellTags->"b:6.0",
   CellID->23186],
  Cell[1474, 59, 390, 14, 70, "Text",
   CellTags->"b:6.0",
   CellID->14507],
  Cell[1867, 75, 290, 8, 70, "Text",
   CellTags->"b:6.0",
   CellID->4360],
  Cell[2160, 85, 414, 12, 70, "Text",
   CellTags->"b:6.0",
   CellID->17827],
  Cell[2577, 99, 395, 14, 70, "Text",
   CellTags->"b:6.0",
   CellID->28074],
  Cell[2975, 115, 373, 13, 70, "Text",
   CellTags->"b:6.0",
   CellID->26431],
  Cell[3351, 130, 334, 12, 70, "Text",
   CellTags->"b:6.0",
   CellID->7152],
  Cell[3688, 144, 219, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->30271],
  Cell[3910, 153, 211, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->10268],
  Cell[4124, 162, 284, 8, 70, "Text",
   CellTags->"b:6.0",
   CellID->4693],
  Cell[4411, 172, 356, 11, 70, "Text",
   CellTags->"b:6.0",
   CellID->19885],
  Cell[4770, 185, 345, 11, 70, "Text",
   CellTags->"b:6.0",
   CellID->337],
  Cell[5118, 198, 350, 11, 70, "Text",
   CellTags->"b:6.0",
   CellID->31311],
  Cell[5471, 211, 318, 10, 70, "Text",
   CellTags->"b:6.0",
   CellID->17604],
  Cell[5792, 223, 319, 10, 70, "Text",
   CellTags->"b:6.0",
   CellID->12677],
  Cell[6114, 235, 414, 16, 70, "Text",
   CellTags->"b:6.0",
   CellID->406],
  Cell[6531, 253, 384, 13, 70, "Text",
   CellTags->"b:6.0",
   CellID->7768],
  Cell[6918, 268, 399, 15, 70, "Text",
   CellTags->"b:6.0",
   CellID->29022],
  Cell[7320, 285, 326, 11, 70, "Text",
   CellTags->"b:6.0",
   CellID->19413],
  Cell[7649, 298, 629, 21, 70, "Text",
   CellTags->"b:6.0",
   CellID->5000],
  Cell[8281, 321, 199, 8, 70, "Text",
   CellTags->"b:6.0",
   CellID->542],
  Cell[8483, 331, 246, 8, 70, "Text",
   CellTags->{"I99", "b:6.0"},
   CellID->17537],
  Cell[8732, 341, 183, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->30038],
  Cell[8918, 350, 237, 7, 70, "Text",
   CellTags->{"K59", "b:6.0"},
   CellID->21388],
  Cell[9158, 359, 313, 10, 70, "Text",
   CellTags->{"K74", "b:6.0"},
   CellID->7355],
  Cell[9474, 371, 235, 7, 70, "Text",
   CellTags->{"K00", "b:6.0"},
   CellID->13289],
  Cell[9712, 380, 225, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->31647],
  Cell[9940, 389, 350, 11, 70, "Text",
   CellTags->"b:6.0",
   CellID->3181],
  Cell[10293, 402, 253, 6, 70, "Text",
   CellTags->"b:6.0",
   CellID->13093],
  Cell[10549, 410, 496, 14, 70, "Text",
   CellTags->"b:6.0",
   CellID->16584],
  Cell[11048, 426, 215, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->10987],
  Cell[11266, 435, 317, 10, 70, "Text",
   CellTags->"b:6.0",
   CellID->10761],
  Cell[11586, 447, 212, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->20493],
  Cell[11801, 456, 215, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->8217],
  Cell[12019, 465, 210, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->9501],
  Cell[12232, 474, 249, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->17482],
  Cell[12484, 483, 492, 15, 70, "Text",
   CellTags->"b:6.0",
   CellID->29447],
  Cell[12979, 500, 214, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->15665],
  Cell[13196, 509, 342, 12, 70, "Text",
   CellTags->"b:6.0",
   CellID->10753],
  Cell[13541, 523, 210, 7, 70, "Text",
   CellTags->{"S57", "b:6.0"},
   CellID->22104],
  Cell[13754, 532, 197, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->15084],
  Cell[13954, 541, 332, 11, 70, "Text",
   CellTags->"b:6.0",
   CellID->19095],
  Cell[14289, 554, 233, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->13525],
  Cell[14525, 563, 188, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->30221],
  Cell[14716, 572, 281, 13, 70, "Text",
   CellTags->"b:6.0",
   CellID->3964],
  Cell[15000, 587, 199, 7, 70, "Text",
   CellTags->"b:6.0",
   CellID->21781]},
 "I99"->{
  Cell[8483, 331, 246, 8, 70, "Text",
   CellTags->{"I99", "b:6.0"},
   CellID->17537]},
 "K59"->{
  Cell[8918, 350, 237, 7, 70, "Text",
   CellTags->{"K59", "b:6.0"},
   CellID->21388]},
 "K74"->{
  Cell[9158, 359, 313, 10, 70, "Text",
   CellTags->{"K74", "b:6.0"},
   CellID->7355]},
 "K00"->{
  Cell[9474, 371, 235, 7, 70, "Text",
   CellTags->{"K00", "b:6.0"},
   CellID->13289]},
 "S57"->{
  Cell[13541, 523, 210, 7, 70, "Text",
   CellTags->{"S57", "b:6.0"},
   CellID->22104]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:60", 17403, 647},
 {"b:6.0", 17502, 651},
 {"I99", 21376, 796},
 {"K59", 21475, 800},
 {"K74", 21574, 804},
 {"K00", 21673, 808},
 {"S57", 21772, 812}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 72, 2, 70, "Title",
 CellTags->{"c:60", "b:6.0"},
 CellID->8387],
Cell[803, 33, 278, 9, 70, "Text",
 CellTags->"b:6.0",
 CellID->13444],
Cell[1084, 44, 387, 13, 70, "Text",
 CellTags->"b:6.0",
 CellID->23186],
Cell[1474, 59, 390, 14, 70, "Text",
 CellTags->"b:6.0",
 CellID->14507],
Cell[1867, 75, 290, 8, 70, "Text",
 CellTags->"b:6.0",
 CellID->4360],
Cell[2160, 85, 414, 12, 70, "Text",
 CellTags->"b:6.0",
 CellID->17827],
Cell[2577, 99, 395, 14, 70, "Text",
 CellTags->"b:6.0",
 CellID->28074],
Cell[2975, 115, 373, 13, 70, "Text",
 CellTags->"b:6.0",
 CellID->26431],
Cell[3351, 130, 334, 12, 70, "Text",
 CellTags->"b:6.0",
 CellID->7152],
Cell[3688, 144, 219, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->30271],
Cell[3910, 153, 211, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->10268],
Cell[4124, 162, 284, 8, 70, "Text",
 CellTags->"b:6.0",
 CellID->4693],
Cell[4411, 172, 356, 11, 70, "Text",
 CellTags->"b:6.0",
 CellID->19885],
Cell[4770, 185, 345, 11, 70, "Text",
 CellTags->"b:6.0",
 CellID->337],
Cell[5118, 198, 350, 11, 70, "Text",
 CellTags->"b:6.0",
 CellID->31311],
Cell[5471, 211, 318, 10, 70, "Text",
 CellTags->"b:6.0",
 CellID->17604],
Cell[5792, 223, 319, 10, 70, "Text",
 CellTags->"b:6.0",
 CellID->12677],
Cell[6114, 235, 414, 16, 70, "Text",
 CellTags->"b:6.0",
 CellID->406],
Cell[6531, 253, 384, 13, 70, "Text",
 CellTags->"b:6.0",
 CellID->7768],
Cell[6918, 268, 399, 15, 70, "Text",
 CellTags->"b:6.0",
 CellID->29022],
Cell[7320, 285, 326, 11, 70, "Text",
 CellTags->"b:6.0",
 CellID->19413],
Cell[7649, 298, 629, 21, 70, "Text",
 CellTags->"b:6.0",
 CellID->5000],
Cell[8281, 321, 199, 8, 70, "Text",
 CellTags->"b:6.0",
 CellID->542],
Cell[8483, 331, 246, 8, 70, "Text",
 CellTags->{"I99", "b:6.0"},
 CellID->17537],
Cell[8732, 341, 183, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->30038],
Cell[8918, 350, 237, 7, 70, "Text",
 CellTags->{"K59", "b:6.0"},
 CellID->21388],
Cell[9158, 359, 313, 10, 70, "Text",
 CellTags->{"K74", "b:6.0"},
 CellID->7355],
Cell[9474, 371, 235, 7, 70, "Text",
 CellTags->{"K00", "b:6.0"},
 CellID->13289],
Cell[9712, 380, 225, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->31647],
Cell[9940, 389, 350, 11, 70, "Text",
 CellTags->"b:6.0",
 CellID->3181],
Cell[10293, 402, 253, 6, 70, "Text",
 CellTags->"b:6.0",
 CellID->13093],
Cell[10549, 410, 496, 14, 70, "Text",
 CellTags->"b:6.0",
 CellID->16584],
Cell[11048, 426, 215, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->10987],
Cell[11266, 435, 317, 10, 70, "Text",
 CellTags->"b:6.0",
 CellID->10761],
Cell[11586, 447, 212, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->20493],
Cell[11801, 456, 215, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->8217],
Cell[12019, 465, 210, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->9501],
Cell[12232, 474, 249, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->17482],
Cell[12484, 483, 492, 15, 70, "Text",
 CellTags->"b:6.0",
 CellID->29447],
Cell[12979, 500, 214, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->15665],
Cell[13196, 509, 342, 12, 70, "Text",
 CellTags->"b:6.0",
 CellID->10753],
Cell[13541, 523, 210, 7, 70, "Text",
 CellTags->{"S57", "b:6.0"},
 CellID->22104],
Cell[13754, 532, 197, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->15084],
Cell[13954, 541, 332, 11, 70, "Text",
 CellTags->"b:6.0",
 CellID->19095],
Cell[14289, 554, 233, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->13525],
Cell[14525, 563, 188, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->30221],
Cell[14716, 572, 281, 13, 70, "Text",
 CellTags->"b:6.0",
 CellID->3964],
Cell[15000, 587, 199, 7, 70, "Text",
 CellTags->"b:6.0",
 CellID->21781]
}, Open  ]],
Cell[15214, 597, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

