(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18388,        657]
NotebookOptionsPosition[     11923,        447]
NotebookOutlinePosition[     16150,        571]
CellTagsIndexPosition[     16026,        564]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Riccati Equations", "Title",
 CellTags->{"RiccatiODE", "c:13", "b:1.1.0.4"},
 CellID->4872],

Cell[TextData[{
 "A ",
 ButtonBox["Riccati equation ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToODEs#14708"],
 "is a first-order equation of the form "
}], "Text",
 CellID->86130161],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], 
    RowBox[{"(", "x", ")"}]}], "\[LongEqual]", 
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "+", 
    RowBox[{
     RowBox[{"g", "(", "x", ")"}], 
     RowBox[{"y", "(", "x", ")"}]}], "+", 
    RowBox[{
     RowBox[{"h", "(", "x", ")"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"y", "(", "x", ")"}], "2"], "."}]}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->45682714],

Cell["\<\
This equation was used by Count Riccati of Venice (1676\[Dash]1754) to help \
in solving second-order ordinary differential equations.\
\>", "Text",
 CellID->416241441],

Cell["\<\
Solving Riccati equations is considerably more difficult than solving linear \
ODEs. \
\>", "Text",
 CellTags->"b:1.1.0.4",
 CellID->8106],

Cell["\<\
Here is a simple Riccati equation for which the solution is available in \
closed form.\
\>", "MathCaption",
 CellTags->"b:1.1.0.4",
 CellID->3656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], " ", "+", 
      RowBox[{"(", 
       RowBox[{"2", "/", 
        RowBox[{"x", "^", "2"}]}], ")"}], "-", 
      RowBox[{"3", 
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "^", "2"}]}]}], "\[Equal]", "0"}], ",", 
    " ", 
    RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellTags->"b:1.1.0.4",
 CellLabel->"In[1]:=",
 CellID->3343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["x", "5"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["x", "6"]}], "+", 
       RowBox[{"3", " ", "x", " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{171, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.4",
 CellLabel->"Out[1]=",
 CellID->561163849]
}, Open  ]],

Cell["\<\
Any Riccati equation can be transformed to a second-order linear ODE. If the \
latter can be solved explicitly, then a solution for the Riccati equation can \
be derived.\
\>", "Text",
 CellTags->"b:1.1.0.4",
 CellID->27080],

Cell["\<\
Here is an example of a Riccati equation and the corresponding second-order \
ODE, which is Legendre\[CloseCurlyQuote]s equation.\
\>", "MathCaption",
 CellTags->"b:1.1.0.4",
 CellID->16080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"u", "'"}], "[", "x", "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "x"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"x", "^", "2"}]}], ")"}]}], ")"}], "*", 
       RowBox[{"u", "[", "x", "]"}]}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"15", "/", "4"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"x", "^", "2"}]}], ")"}]}], ")"}], "-", 
      RowBox[{
       RowBox[{"u", "[", "x", "]"}], "^", "2"}]}]}], ",", " ", 
    RowBox[{"u", "[", "x", "]"}], ",", "x"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellTags->"b:1.1.0.4",
 CellLabel->"In[2]:=",
 CellID->14868],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "x"}], " ", 
          RowBox[{"C", "[", "1", "]"}], " ", 
          RowBox[{"LegendreP", "[", 
           RowBox[{
            FractionBox["3", "2"], ",", "x"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"C", "[", "1", "]"}], " ", 
          RowBox[{"LegendreP", "[", 
           RowBox[{
            FractionBox["5", "2"], ",", "x"}], "]"}]}], "-", 
         RowBox[{"x", " ", 
          RowBox[{"LegendreQ", "[", 
           RowBox[{
            FractionBox["3", "2"], ",", "x"}], "]"}]}], "+", 
         RowBox[{"LegendreQ", "[", 
          RowBox[{
           FractionBox["5", "2"], ",", "x"}], "]"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["x", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"C", "[", "1", "]"}], " ", 
          RowBox[{"LegendreP", "[", 
           RowBox[{
            FractionBox["3", "2"], ",", "x"}], "]"}]}], "+", 
         RowBox[{"LegendreQ", "[", 
          RowBox[{
           FractionBox["3", "2"], ",", "x"}], "]"}]}], ")"}]}], ")"}]}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{562, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.4",
 CellLabel->"Out[2]=",
 CellID->51612097]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"x", "^", "2"}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], " ", "-", 
     RowBox[{"2", "x", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"15", "/", "4"}], ")"}], "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.0.4",
 CellLabel->"In[3]:=",
 CellID->13713],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"LegendreP", "[", 
       RowBox[{
        FractionBox["3", "2"], ",", "x"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"LegendreQ", "[", 
       RowBox[{
        FractionBox["3", "2"], ",", "x"}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{364, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.4",
 CellLabel->"Out[3]=",
 CellID->40423479]
}, Open  ]],

Cell["\<\
Finally, consider the following Riccati equation. It is integrable because \
the sum of the coefficients of the terms on the right-hand side is 0.\
\>", "MathCaption",
 CellTags->"b:1.1.0.4",
 CellID->3251],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", " ", 
    RowBox[{
     RowBox[{"3", "x"}], "+", 
     RowBox[{"5", "*", 
      RowBox[{"y", "[", "x", "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", "x"}], "+", "5"}], ")"}], "*", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "2"}]}]}]}]}], ";"}]], "Input",
 CellTags->"b:1.1.0.4",
 CellLabel->"In[4]:=",
 CellID->27216],

Cell[BoxData[
 RowBox[{
  RowBox[{"RightHandSideCoeffs", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "x"}], ",", " ", "5", ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", "x"}], "+", "5"}], ")"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->72997650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", "RightHandSideCoeffs", " ", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->239638996],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->224791560]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "y", ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.0.4",
 CellLabel->"In[7]:=",
 CellID->12079],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"1", "+", 
       FractionBox[
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "5"}], " ", "x"}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["x", "2"]}]}]], 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "+", 
         RowBox[{
          FractionBox["1", "12"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "6"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", "x"}], " ", 
               RowBox[{"(", 
                RowBox[{"5", "+", 
                 RowBox[{"3", " ", "x"}]}], ")"}]}]]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"25", "/", "12"}]], " ", 
             SqrtBox[
              RowBox[{"3", " ", "\[Pi]"}]], " ", 
             RowBox[{"Erf", "[", 
              FractionBox[
               RowBox[{"5", "+", 
                RowBox[{"6", " ", "x"}]}], 
               RowBox[{"2", " ", 
                SqrtBox["3"]}]], "]"}]}]}], ")"}]}]}]]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{485, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.4",
 CellLabel->"Out[7]=",
 CellID->696839930]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:1.1.0.4",
 CellID->17040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellTags->"b:1.1.0.4",
 CellLabel->"In[8]:=",
 CellID->31531],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.4",
 CellLabel->"Out[8]=",
 CellID->517043125]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->94838416],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Riccati Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveBernoulliEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveExactEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 48.1886358}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A Riccati equation is a first-order equation of the form This equation \
was used by Count Riccati of Venice (1676-1754) to help in solving \
second-order ordinary differential equations. Solving Riccati equations is \
considerably more difficult than solving linear ODEs. ", "synonyms" -> {}, 
    "title" -> "Riccati Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveRiccatiEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "RiccatiODE"->{
  Cell[1280, 43, 97, 2, 70, "Title",
   CellTags->{"RiccatiODE", "c:13", "b:1.1.0.4"},
   CellID->4872]},
 "c:13"->{
  Cell[1280, 43, 97, 2, 70, "Title",
   CellTags->{"RiccatiODE", "c:13", "b:1.1.0.4"},
   CellID->4872]},
 "b:1.1.0.4"->{
  Cell[1280, 43, 97, 2, 70, "Title",
   CellTags->{"RiccatiODE", "c:13", "b:1.1.0.4"},
   CellID->4872],
  Cell[2283, 82, 148, 5, 70, "Text",
   CellTags->"b:1.1.0.4",
   CellID->8106],
  Cell[2434, 89, 157, 5, 70, "MathCaption",
   CellTags->"b:1.1.0.4",
   CellID->3656],
  Cell[2616, 98, 530, 19, 28, "Input",
   CellTags->"b:1.1.0.4",
   CellID->3343],
  Cell[3149, 119, 636, 22, 57, "Output",
   CellTags->"b:1.1.0.4",
   CellID->561163849],
  Cell[3800, 144, 234, 6, 70, "Text",
   CellTags->"b:1.1.0.4",
   CellID->27080],
  Cell[4037, 152, 200, 5, 70, "MathCaption",
   CellTags->"b:1.1.0.4",
   CellID->16080],
  Cell[4262, 161, 877, 30, 70, "Input",
   CellTags->"b:1.1.0.4",
   CellID->14868],
  Cell[5142, 193, 1579, 50, 81, "Output",
   CellTags->"b:1.1.0.4",
   CellID->51612097],
  Cell[6758, 248, 631, 21, 70, "Input",
   CellTags->"b:1.1.0.4",
   CellID->13713],
  Cell[7392, 271, 621, 22, 51, "Output",
   CellTags->"b:1.1.0.4",
   CellID->40423479],
  Cell[8028, 296, 216, 5, 70, "MathCaption",
   CellTags->"b:1.1.0.4",
   CellID->3251],
  Cell[8247, 303, 498, 18, 70, "Input",
   CellTags->"b:1.1.0.4",
   CellID->27216],
  Cell[9417, 353, 188, 6, 70, "Input",
   CellTags->"b:1.1.0.4",
   CellID->12079],
  Cell[9608, 361, 1485, 46, 82, "Output",
   CellTags->"b:1.1.0.4",
   CellID->696839930],
  Cell[11108, 410, 90, 2, 70, "MathCaption",
   CellTags->"b:1.1.0.4",
   CellID->17040],
  Cell[11223, 416, 148, 5, 70, "Input",
   CellTags->"b:1.1.0.4",
   CellID->31531],
  Cell[11374, 423, 207, 7, 36, "Output",
   CellTags->"b:1.1.0.4",
   CellID->517043125]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"RiccatiODE", 14180, 498},
 {"c:13", 14297, 502},
 {"b:1.1.0.4", 14419, 506}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 97, 2, 70, "Title",
 CellTags->{"RiccatiODE", "c:13", "b:1.1.0.4"},
 CellID->4872],
Cell[1380, 47, 213, 7, 70, "Text",
 CellID->86130161],
Cell[1596, 56, 503, 18, 70, "DisplayMath",
 CellID->45682714],
Cell[2102, 76, 178, 4, 70, "Text",
 CellID->416241441],
Cell[2283, 82, 148, 5, 70, "Text",
 CellTags->"b:1.1.0.4",
 CellID->8106],
Cell[2434, 89, 157, 5, 70, "MathCaption",
 CellTags->"b:1.1.0.4",
 CellID->3656],
Cell[CellGroupData[{
Cell[2616, 98, 530, 19, 28, "Input",
 CellTags->"b:1.1.0.4",
 CellID->3343],
Cell[3149, 119, 636, 22, 57, "Output",
 CellTags->"b:1.1.0.4",
 CellID->561163849]
}, Open  ]],
Cell[3800, 144, 234, 6, 70, "Text",
 CellTags->"b:1.1.0.4",
 CellID->27080],
Cell[4037, 152, 200, 5, 70, "MathCaption",
 CellTags->"b:1.1.0.4",
 CellID->16080],
Cell[CellGroupData[{
Cell[4262, 161, 877, 30, 70, "Input",
 CellTags->"b:1.1.0.4",
 CellID->14868],
Cell[5142, 193, 1579, 50, 81, "Output",
 CellTags->"b:1.1.0.4",
 CellID->51612097]
}, Open  ]],
Cell[CellGroupData[{
Cell[6758, 248, 631, 21, 70, "Input",
 CellTags->"b:1.1.0.4",
 CellID->13713],
Cell[7392, 271, 621, 22, 51, "Output",
 CellTags->"b:1.1.0.4",
 CellID->40423479]
}, Open  ]],
Cell[8028, 296, 216, 5, 70, "MathCaption",
 CellTags->"b:1.1.0.4",
 CellID->3251],
Cell[8247, 303, 498, 18, 70, "Input",
 CellTags->"b:1.1.0.4",
 CellID->27216],
Cell[8748, 323, 322, 11, 70, "Input",
 CellID->72997650],
Cell[CellGroupData[{
Cell[9095, 338, 124, 3, 70, "Input",
 CellID->239638996],
Cell[9222, 343, 158, 5, 36, "Output",
 CellID->224791560]
}, Open  ]],
Cell[CellGroupData[{
Cell[9417, 353, 188, 6, 70, "Input",
 CellTags->"b:1.1.0.4",
 CellID->12079],
Cell[9608, 361, 1485, 46, 82, "Output",
 CellTags->"b:1.1.0.4",
 CellID->696839930]
}, Open  ]],
Cell[11108, 410, 90, 2, 70, "MathCaption",
 CellTags->"b:1.1.0.4",
 CellID->17040],
Cell[CellGroupData[{
Cell[11223, 416, 148, 5, 70, "Input",
 CellTags->"b:1.1.0.4",
 CellID->31531],
Cell[11374, 423, 207, 7, 36, "Output",
 CellTags->"b:1.1.0.4",
 CellID->517043125]
}, Open  ]],
Cell[CellGroupData[{
Cell[11618, 435, 71, 1, 70, "RelatedTutorialsSection",
 CellID->94838416],
Cell[11692, 438, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[11896, 445, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

