(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11870,        416]
NotebookOptionsPosition[      6917,        260]
NotebookOutlinePosition[     10608,        368]
CellTagsIndexPosition[     10485,        361]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Euler and Legendre Equations", "Title",
 CellTags->{"c:20", "b:1.1.1.2"},
 CellID->23779],

Cell[TextData[{
 "An ",
 StyleBox["Euler equation",
  FontSlant->"Italic"],
 " has the general form"
}], "Text",
 CellTags->"b:1.1.1.2",
 CellID->20663],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], 
     RowBox[{
      SuperscriptBox["y", "\[Prime]\[Prime]",
       MultilineFunction->None], "(", "x", ")"}]}], "+", 
    RowBox[{"a", "x", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "(", "x", ")"}]}], "+", 
    RowBox[{"b", 
     RowBox[{"y", "(", "x", ")"}]}]}], "\[LongEqual]", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:1.1.1.2",
 CellID->12259],

Cell["\<\
Euler equations can be solved by transforming them to equations with constant \
coefficients.\
\>", "Text",
 CellTags->"b:1.1.1.2",
 CellID->26653],

Cell["This is an example of an Euler equation.", "MathCaption",
 CellTags->"b:1.1.1.2",
 CellID->27936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{"5", "*", "x", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"6", "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.1.2",
 CellLabel->"(Local) In[1]:=",
 CellID->2095],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{
         SqrtBox["2"], " ", 
         RowBox[{"Log", "[", "x", "]"}]}], "]"}]}], 
      SuperscriptBox["x", "2"]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{
         SqrtBox["2"], " ", 
         RowBox[{"Log", "[", "x", "]"}]}], "]"}]}], 
      SuperscriptBox["x", "2"]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{367, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.2",
 CellLabel->"(Local) Out[1]=",
 CellID->24365]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Legendre linear equation",
  FontSlant->"Italic"],
 " is a generalization of the Euler equation. It is an ODE of the form "
}], "Text",
 CellTags->{"LegendreODE", "b:1.1.1.2"},
 CellID->11874],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "x"}], "+", "d"}], ")"}], "2"], 
     RowBox[{
      SuperscriptBox["y", "\[Prime]\[Prime]",
       MultilineFunction->None], "(", "x", ")"}]}], "+", 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "x"}], "+", "d"}], ")"}], 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "(", "x", ")"}]}], "+", 
    RowBox[{"b", 
     RowBox[{"y", "(", "x", ")"}]}]}], "\[LongEqual]", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:1.1.1.2",
 CellID->7720],

Cell["Here is an example of a Legendre linear equation.", "MathCaption",
 CellTags->"b:1.1.1.2",
 CellID->26835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "x"}], "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{"5", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", "x"}], "+", "1"}], ")"}], "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"6", "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.1.2",
 CellLabel->"(Local) In[2]:=",
 CellID->25680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         SqrtBox["5"], " ", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "x"}]}], "]"}]}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "x"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         SqrtBox["5"], " ", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "x"}]}], "]"}]}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "x"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{453, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.2",
 CellLabel->"(Local) Out[2]=",
 CellID->8976]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->85565885],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Euler and Legendre Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/\
DSolveLinearSecondOrderEquationsWithConstantCoefficients"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveExactLinearSecondOrderODEs"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 48.4855184}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "An Euler equation has the general form Euler equations can be solved by \
transforming them to equations with constant coefficients. This is an example \
of an Euler equation.", "synonyms" -> {}, "title" -> 
    "Euler and Legendre Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveSecondOrderEulerAndLegendreEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:20"->{
  Cell[1280, 43, 95, 2, 70, "Title",
   CellTags->{"c:20", "b:1.1.1.2"},
   CellID->23779]},
 "b:1.1.1.2"->{
  Cell[1280, 43, 95, 2, 70, "Title",
   CellTags->{"c:20", "b:1.1.1.2"},
   CellID->23779],
  Cell[1378, 47, 152, 7, 70, "Text",
   CellTags->"b:1.1.1.2",
   CellID->20663],
  Cell[1533, 56, 500, 17, 70, "DisplayMath",
   CellTags->"b:1.1.1.2",
   CellID->12259],
  Cell[2036, 75, 157, 5, 70, "Text",
   CellTags->"b:1.1.1.2",
   CellID->26653],
  Cell[2196, 82, 103, 2, 70, "MathCaption",
   CellTags->"b:1.1.1.2",
   CellID->27936],
  Cell[2324, 88, 525, 17, 28, "Input",
   CellTags->"b:1.1.1.2",
   CellID->2095],
  Cell[2852, 107, 781, 27, 61, "Output",
   CellTags->"b:1.1.1.2",
   CellID->24365],
  Cell[3648, 137, 228, 7, 70, "Text",
   CellTags->{"LegendreODE", "b:1.1.1.2"},
   CellID->11874],
  Cell[3879, 146, 654, 23, 70, "DisplayMath",
   CellTags->"b:1.1.1.2",
   CellID->7720],
  Cell[4536, 171, 112, 2, 70, "MathCaption",
   CellTags->"b:1.1.1.2",
   CellID->26835],
  Cell[4673, 177, 687, 23, 70, "Input",
   CellTags->"b:1.1.1.2",
   CellID->25680],
  Cell[5363, 202, 1212, 41, 64, "Output",
   CellTags->"b:1.1.1.2",
   CellID->8976]},
 "LegendreODE"->{
  Cell[3648, 137, 228, 7, 70, "Text",
   CellTags->{"LegendreODE", "b:1.1.1.2"},
   CellID->11874]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:20", 9178, 313},
 {"b:1.1.1.2", 9287, 317},
 {"LegendreODE", 10361, 354}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 95, 2, 70, "Title",
 CellTags->{"c:20", "b:1.1.1.2"},
 CellID->23779],
Cell[1378, 47, 152, 7, 70, "Text",
 CellTags->"b:1.1.1.2",
 CellID->20663],
Cell[1533, 56, 500, 17, 70, "DisplayMath",
 CellTags->"b:1.1.1.2",
 CellID->12259],
Cell[2036, 75, 157, 5, 70, "Text",
 CellTags->"b:1.1.1.2",
 CellID->26653],
Cell[2196, 82, 103, 2, 70, "MathCaption",
 CellTags->"b:1.1.1.2",
 CellID->27936],
Cell[CellGroupData[{
Cell[2324, 88, 525, 17, 28, "Input",
 CellTags->"b:1.1.1.2",
 CellID->2095],
Cell[2852, 107, 781, 27, 61, "Output",
 CellTags->"b:1.1.1.2",
 CellID->24365]
}, Open  ]],
Cell[3648, 137, 228, 7, 70, "Text",
 CellTags->{"LegendreODE", "b:1.1.1.2"},
 CellID->11874],
Cell[3879, 146, 654, 23, 70, "DisplayMath",
 CellTags->"b:1.1.1.2",
 CellID->7720],
Cell[4536, 171, 112, 2, 70, "MathCaption",
 CellTags->"b:1.1.1.2",
 CellID->26835],
Cell[CellGroupData[{
Cell[4673, 177, 687, 23, 70, "Input",
 CellTags->"b:1.1.1.2",
 CellID->25680],
Cell[5363, 202, 1212, 41, 64, "Output",
 CellTags->"b:1.1.1.2",
 CellID->8976]
}, Open  ]],
Cell[CellGroupData[{
Cell[6612, 248, 71, 1, 70, "RelatedTutorialsSection",
 CellID->85565885],
Cell[6686, 251, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[6890, 258, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

