(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65876,       2099]
NotebookOptionsPosition[     49978,       1517]
NotebookOutlinePosition[     58848,       1812]
CellTagsIndexPosition[     58755,       1806]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Symbolic Parameters and Inexact Quantities ", "Title",
 CellTags->{"c:56", "b:5.5"},
 CellID->20476],

Cell["\<\
The differential equations that arise in practice are of two types.\
\>", "Text",
 CellTags->"b:5.5",
 CellID->30041],

Cell[CellGroupData[{

Cell[TextData[{
 "Equations in which the only variables are the independent and dependent \
variables. Thus, all the variables that appear in the first argument to ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " are also in the second or third arguments. "
}], "BulletedText",
 CellTags->"b:5.5",
 CellID->3351],

Cell["Here is an example of this type.", "MathCaption",
 CellTags->"b:5.5",
 CellID->8329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], " ", "-", 
     RowBox[{"8", "*", "x", "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], " ", "\[Equal]", "0"}], ",", " ", "y",
    ",", "x"}], "]"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[1]:=",
 CellID->16290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"AiryAi", "[", 
         RowBox[{"2", " ", "x"}], "]"}], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        RowBox[{"AiryBi", "[", 
         RowBox[{"2", " ", "x"}], "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[1]=",
 CellID->83068728]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Equations in which there are other symbolic quantities, such as mass or the \
spring constant. The solution in this case depends on the independent \
variables, the dependent variables, and the additional symbolic parameters.\
\>", "BulletedText",
 CellTags->"b:5.5",
 CellID->23072],

Cell[TextData[{
 "This equation has a symbolic parameter ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:5.5",
 CellID->3591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", 
        RowBox[{
         RowBox[{"k", "^", "2"}], "*", 
         RowBox[{"y", "[", "x", "]"}]}]}], " ", "\[Equal]", " ", 
       RowBox[{"x", "^", "2"}]}], ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"3", "k"}], "+", "1"}]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "k"}]}], "}"}], ",", 
    " ", "y", ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[2]:=",
 CellID->12189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{
         SuperscriptBox["k", "2"], " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"k", " ", "x"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["k", "4"], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"k", " ", "x"}], "]"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["k", "5"], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"k", " ", "x"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["k", "4"], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"k", " ", "x"}], "]"}]}]}], 
       SuperscriptBox["k", "4"]]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{542, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[2]=",
 CellID->455226116]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is equipped to deal with both types of equations. It is extremely useful \
to have the solution available for all possible values of the parameters in \
the second type of equation. "
}], "Text",
 CellTags->"b:5.5",
 CellID->31490],

Cell[TextData[{
 "Here is a plot of the previous solution for different values of the \
parameter ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:5.5",
 CellID->3239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "/.", 
       RowBox[{"{", 
        RowBox[{"k", "\[Rule]", " ", "i"}], "}"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "5", ",", " ", "2"}], "}"}]}], "]"}], 
    "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[3]:=",
 CellID->14893],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[3]=",
 CellID->148090797]
}, Open  ]],

Cell["\<\
It should be noted that the presence of symbolic parameters can lead to \
fairly complicated output.\
\>", "Text",
 CellTags->"b:5.5",
 CellID->17063],

Cell[TextData[{
 "This is seen in the following example (equation 2.14, page 401 of [",
 ButtonBox["K59",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveReferences#21388"],
 "])."
}], "MathCaption",
 CellTags->"b:5.5",
 CellID->10681],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], " ", "-", " ", 
    RowBox[{"c", "*", 
     RowBox[{"x", "^", "a"}], "*", 
     RowBox[{"y", "[", "x", "]"}]}]}]}], " ", ";"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[4]:=",
 CellID->25903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"eqn", "\[Equal]", "0"}], ",", " ", "y", ",", " ", "x"}], 
   "]"}]}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[5]:=",
 CellID->27005],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         FractionBox["1", 
          RowBox[{"2", "+", "a"}]]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"2", "+", "a"}], ")"}], 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", "+", "a"}]]}]], " ", 
        SuperscriptBox["c", 
         FractionBox["1", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "a"}], ")"}]}]]], " ", 
        SuperscriptBox["x", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"1", "+", 
            FractionBox["a", "2"]}], 
           RowBox[{"2", "+", "a"}]]}]], " ", 
        RowBox[{"BesselI", "[", 
         RowBox[{
          FractionBox["1", 
           RowBox[{"2", "+", "a"}]], ",", 
          FractionBox[
           RowBox[{"2", " ", 
            SqrtBox["c"], " ", 
            SuperscriptBox["x", 
             FractionBox[
              RowBox[{"2", "+", "a"}], "2"]]}], 
           RowBox[{"2", "+", "a"}]]}], "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", 
          FractionBox["1", 
           RowBox[{"2", "+", "a"}]]}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"2", "+", "a"}], ")"}], 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", "+", "a"}]]}]], " ", 
        SuperscriptBox["c", 
         FractionBox["1", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "a"}], ")"}]}]]], " ", 
        SuperscriptBox["x", 
         FractionBox[
          RowBox[{"1", "+", 
           FractionBox["a", "2"]}], 
          RowBox[{"2", "+", "a"}]]], " ", 
        RowBox[{"BesselI", "[", 
         RowBox[{
          FractionBox["1", 
           RowBox[{
            RowBox[{"-", "2"}], "-", "a"}]], ",", 
          FractionBox[
           RowBox[{"2", " ", 
            SqrtBox["c"], " ", 
            SuperscriptBox["x", 
             FractionBox[
              RowBox[{"2", "+", "a"}], "2"]]}], 
           RowBox[{"2", "+", "a"}]]}], "]"}], " ", 
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{
          FractionBox["1", 
           RowBox[{"2", "+", "a"}]], "+", 
          FractionBox["a", 
           RowBox[{"2", "+", "a"}]]}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{551, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[5]=",
 CellID->160249938]
}, Open  ]],

Cell["\<\
However, for some special values of the parameters, the solution might be \
significantly simpler.\
\>", "Text",
 CellTags->"b:5.5",
 CellID->18479],

Cell[TextData[{
 "For these values of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 ", the solution is much more simple."
}], "MathCaption",
 CellTags->"b:5.5",
 CellID->1695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", "\[Rule]", " ", "0"}], ",", " ", 
     RowBox[{"c", "\[Rule]", " ", "4"}]}], "}"}]}]}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[6]:=",
 CellID->6139],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], " ", 
   RowBox[{"Cosh", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"C", "[", "2", "]"}], " ", 
   RowBox[{"Sinh", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}]}]], "Output",
 ImageSize->{222, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[6]=",
 CellID->398481400]
}, Open  ]],

Cell["\<\
Occasionally, a solution is valid for most, but not all, values of the \
parameters.\
\>", "Text",
 CellTags->"b:5.5",
 CellID->13998],

Cell[TextData[{
 "Since the input in this example is not valid at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", the solution has the same limitation."
}], "MathCaption",
 CellTags->"b:5.5",
 CellID->21083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], " ", "\[Equal]", "x"}], ",", " ",
       
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", 
       RowBox[{"1", "/", "a"}]}]}], "}"}], ",", " ", "y", ",", "x"}], 
   "]"}]}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[7]:=",
 CellID->23639],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      FractionBox[
       RowBox[{"2", "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "2"]}]}], 
       RowBox[{"2", " ", "a"}]]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{204, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[7]=",
 CellID->551435822]
}, Open  ]],

Cell[TextData[{
 "Of course, there is a simple remedy in this case: setting ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", 
    FractionBox["1", "a"]}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:5.5",
 CellID->27621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], " ", "\[Equal]", "x"}], ",", " ",
       
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "k"}]}], "}"}], ",", " ", 
    "y", ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[8]:=",
 CellID->29993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "k"}], "+", 
         SuperscriptBox["x", "2"]}], ")"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{228, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[8]=",
 CellID->336276692]
}, Open  ]],

Cell[TextData[{
 "In summary, the ability to solve differential equations with symbolic \
parameters is a ",
 StyleBox["powerful and essential feature",
  FontSlant->"Italic"],
 " of any symbolic solver such as ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ". However, the following points should be noted."
}], "Text",
 CellTags->"b:5.5",
 CellID->15722]
}, Open  ]],

Cell["\<\
The solution might be complicated, and such calculations often require \
significant time and memory.\
\>", "BulletedText",
 CellTags->"b:5.5",
 CellID->23838],

Cell["\<\
The answer might not be valid for certain exceptional values of the \
parameters.\
\>", "BulletedText",
 CellTags->"b:5.5",
 CellID->24828],

Cell[CellGroupData[{

Cell["\<\
The solution might be easy to verify symbolically for some special values of \
the parameters, but in the general case a numerical verification method is \
preferable.\
\>", "BulletedText",
 CellTags->"b:5.5",
 CellID->12581],

Cell[TextData[{
 "Numerical quantities in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be of three types: infinite precision, machine precision, or arbitrary \
precision. The first type of number is referred to as \
\[OpenCurlyDoubleQuote]exact\[CloseCurlyDoubleQuote], while the remaining two \
types represent incomplete information and are therefore called \
\[OpenCurlyDoubleQuote]inexact\[CloseCurlyDoubleQuote]. "
}], "Text",
 CellTags->"b:5.5",
 CellID->24399],

Cell["Here is a simple example showing all three kinds of numbers.", \
"MathCaption",
 CellTags->"b:5.5",
 CellID->8978],

Cell[BoxData[
 RowBox[{
  RowBox[{"exactpi", " ", "=", " ", "Pi"}], ";"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[9]:=",
 CellID->11891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "exactpi", "]"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[10]:=",
 CellID->1023],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[10]=",
 CellID->724847426]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"machinepi", " ", "=", " ", 
    RowBox[{"N", "[", "Pi", "]"}]}], ")"}], "//", "InputForm"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[12]:=",
 CellID->24834],

Cell["3.141592653589793", "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[12]//InputForm=",
 CellID->825763686]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "machinepi", "]"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[13]:=",
 CellID->2702],

Cell[BoxData["MachinePrecision"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[13]=",
 CellID->765784900]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"highprecisionpi", " ", "=", " ", 
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", " ", "30"}], "]"}]}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[14]:=",
 CellID->20502],

Cell[BoxData["3.141592653589793238462643383279502884197167679584`30."], \
"Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[14]=",
 CellID->31196534]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "highprecisionpi", "]"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[15]:=",
 CellID->10687],

Cell[BoxData["30.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[15]=",
 CellID->30529317]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is a symbolic solver, the algorithms used by it are primarily based on the \
assumption of exact input. However, equations that contain inexact quantities \
are handled by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " in the usual way. "
}], "Text",
 CellTags->"b:5.5",
 CellID->15891],

Cell["\<\
These equations contain the inexact number 3. and 3.`40, respectively.\
\>", "MathCaption",
 CellTags->"b:5.5",
 CellID->24637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
    RowBox[{"3.", " ", 
     RowBox[{"x", "[", "t", "]"}]}]}], ",", " ", "x", ",", " ", "t"}], 
  "]"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[16]:=",
 CellID->18413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"3.`", " ", "t"}]], " ", 
       RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{213, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[16]=",
 CellID->141971873]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
    RowBox[{"3.`40", "*", " ", 
     RowBox[{"x", "[", "t", "]"}]}]}], ",", " ", "x", ",", " ", "t"}], 
  "]"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[17]:=",
 CellID->22816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"3.`39.39794000867204", " ", "t"}]], " ", 
       RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{403, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[17]=",
 CellID->497478768]
}, Open  ]],

Cell["\<\
Inexact input could arise, for example, when the coefficients in the \
equations are derived from a previous calculation and are known only \
approximately. In such cases, it might not be practical to convert the \
equations to exact form, as this could slow down the calculation \
significantly.\
\>", "Text",
 CellTags->"b:5.5",
 CellID->13162],

Cell[TextData[{
 "Here is a system of linear ODEs that all have exact coefficients. Note that \
even with a fairly small value of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", the calculation takes a long time to finish."
}], "MathCaption",
 CellTags->"b:5.5",
 CellID->8935],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    FormBox[
     SubscriptBox["x", "0"],
     TraditionalForm], "[", "t_", "]"}], ":=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    FormBox[
     SubscriptBox["x", "n"],
     TraditionalForm], "[", "t_", "]"}], ":=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eqns", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["x", "i"], "'"}], "[", "t", "]"}], " ", "-", " ", 
        RowBox[{"(", " ", 
         RowBox[{
          RowBox[{
           SubscriptBox["x", 
            RowBox[{"i", "+", "1"}]], "[", "t", "]"}], " ", "-", " ", 
          RowBox[{"2", " ", 
           RowBox[{
            SubscriptBox["x", "i"], "[", "t", "]"}]}], " ", "+", " ", 
          RowBox[{
           SubscriptBox["x", 
            RowBox[{"i", "-", "1"}]], "[", "t", "]"}]}], ")"}]}], ",", " ", 
       RowBox[{
        RowBox[{
         SubscriptBox["x", "i"], "[", "0", "]"}], " ", "-", " ", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vars", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["x", "i"], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sol", "=", 
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "\[Equal]", "0"}], "&"}], ",", 
        RowBox[{"Flatten", "[", "eqns", "]"}]}], "]"}], ",", "vars", ",", 
      "t"}], "]"}]}], ";"}], "//", "Timing"}]}], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[18]:=",
 CellID->29126],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"35.703`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[23]=",
 CellID->360824292]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "[", "sol", "]"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[24]:=",
 CellID->19877],

Cell[BoxData["212851"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[24]=",
 CellID->49635889]
}, Open  ]],

Cell["\<\
This verifies the solution. Since the solution is complicated, a numerical \
verification method is used.\
\>", "MathCaption",
 CellTags->"b:5.5",
 CellID->26260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"eqns", "/.", "sol"}], "/.", " ", 
      RowBox[{"{", 
       RowBox[{"t", "\[Rule]", " ", 
        RowBox[{"RandomReal", "[", " ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", " ", 
          RowBox[{"WorkingPrecision", " ", "\[Rule]", " ", "200"}]}], "]"}]}],
        "}"}]}], "//", "N"}], "//", "Chop"}], "//", "Flatten"}], "//", 
  "Union"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[25]:=",
 CellID->27189],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[25]=",
 CellID->118430727]
}, Open  ]],

Cell[TextData[{
 "If a single inexact quantity is introduced (in the function",
 StyleBox[" ",
  FontColor->RGBColor[1, 0, 0]],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "0"], "[", "t", "]"}], TraditionalForm]], 
  "InlineMath"],
 StyleBox[")", "TR"],
 ", the solution is returned more quickly."
}], "MathCaption",
 CellTags->"b:5.5",
 CellID->13874],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    FormBox[
     SubscriptBox["x", "0"],
     TraditionalForm], "[", "t_", "]"}], ":=", "0."}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    FormBox[
     SubscriptBox["x", "n"],
     TraditionalForm], "[", "t_", "]"}], ":=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eqns", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["x", "i"], "'"}], "[", "t", "]"}], " ", "-", " ", 
        RowBox[{"(", " ", 
         RowBox[{
          RowBox[{
           SubscriptBox["x", 
            RowBox[{"i", "+", "1"}]], "[", "t", "]"}], " ", "-", " ", 
          RowBox[{"2", " ", 
           RowBox[{
            SubscriptBox["x", "i"], "[", "t", "]"}]}], " ", "+", " ", 
          RowBox[{
           SubscriptBox["x", 
            RowBox[{"i", "-", "1"}]], "[", "t", "]"}]}], ")"}]}], ",", " ", 
       RowBox[{
        RowBox[{
         SubscriptBox["x", "i"], "[", "0", "]"}], " ", "-", " ", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vars", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["x", "i"], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sol", "=", 
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "\[Equal]", "0"}], "&"}], ",", 
        RowBox[{"Flatten", "[", "eqns", "]"}]}], "]"}], ",", "vars", ",", 
      "t"}], "]"}]}], ";"}], "//", "Timing"}]}], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[26]:=",
 CellID->2663],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.7499999999999989`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[31]=",
 CellID->255147482]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "[", "sol", "]"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[32]:=",
 CellID->32195],

Cell[BoxData["1563"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[32]=",
 CellID->60661836]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"eqns", "/.", "sol"}], "/.", " ", 
      RowBox[{"{", 
       RowBox[{"t", "\[Rule]", " ", 
        RowBox[{"RandomReal", "[", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], "]"}]}], " ", "}"}]}], "//", 
     RowBox[{
      RowBox[{"N", "[", "#", "]"}], "&"}]}], "//", "Chop"}], "//", 
   "Flatten"}], "//", "Union"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[33]:=",
 CellID->16360],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[33]=",
 CellID->249461648]
}, Open  ]],

Cell[TextData[{
 "Thus, it is often desirable to continue working with inexact quantities \
even within a symbolic function such as ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ". However, it should be noted that the solution obtained in such cases \
could have a certain amount of numerical error and should be checked \
carefully. It is therefore recommended that if the problem size is not too \
large (for instance, if there are fewer than five equations), the input \
should be converted to exact form using the ",
 Cell[BoxData[
  ButtonBox["Rationalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationalize"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"b:5.5",
 CellID->18588],

Cell["This equation contains inexact quantities.", "MathCaption",
 CellTags->"b:5.5",
 CellID->7811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"0.0001", "*", 
       RowBox[{"x", "[", "t", "]"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "3.07"}]}], "}"}], ",", " ", 
   RowBox[{"x", "[", "t", "]"}], ",", " ", "t"}], "]"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[34]:=",
 CellID->28245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
    RowBox[{"3.07`", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"0.0001`", " ", "t"}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{152, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[34]=",
 CellID->277752595]
}, Open  ]],

Cell["\<\
Here the equation is converted to exact form before being solved.\
\>", "MathCaption",
 CellTags->"b:5.5",
 CellID->32425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"Rationalize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{"0.0001", "*", 
         RowBox[{"x", "[", "t", "]"}]}]}], ",", " ", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "3.07"}]}], "}"}], ",", " ",
      "0"}], "]"}], ",", " ", 
   RowBox[{"x", "[", "t", "]"}], ",", " ", "t"}], "]"}]], "Input",
 CellTags->"b:5.5",
 CellLabel->"In[35]:=",
 CellID->26867],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{"307", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"t", "/", "10000"}]]}], "100"]}], "}"}], "}"}]], "Output",
 ImageSize->{149, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellLabel->"Out[35]=",
 CellID->170992134]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->39658249],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Symbolic Parameters and Inexact Quantities  - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveGeneratedParametersOption"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveWellPosedness"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 51.2043380}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The differential equations that arise in practice are of two types. Here \
is an example of this type. This equation has a symbolic parameter k.", 
    "synonyms" -> {}, "title" -> 
    "Symbolic Parameters and Inexact Quantities ", "type" -> "Tutorial", 
    "uri" -> "tutorial/DSolveSymbolicAndInexactQuantities"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:56"->{
  Cell[1280, 43, 106, 2, 70, "Title",
   CellTags->{"c:56", "b:5.5"},
   CellID->20476]},
 "b:5.5"->{
  Cell[1280, 43, 106, 2, 70, "Title",
   CellTags->{"c:56", "b:5.5"},
   CellID->20476],
  Cell[1389, 47, 127, 4, 70, "Text",
   CellTags->"b:5.5",
   CellID->30041],
  Cell[1541, 55, 384, 10, 70, "BulletedText",
   CellTags->"b:5.5",
   CellID->3351],
  Cell[1928, 67, 90, 2, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->8329],
  Cell[2043, 73, 348, 12, 28, "Input",
   CellTags->"b:5.5",
   CellID->16290],
  Cell[2394, 87, 632, 21, 36, "Output",
   CellTags->"b:5.5",
   CellID->83068728],
  Cell[3075, 114, 293, 6, 70, "BulletedText",
   CellTags->"b:5.5",
   CellID->23072],
  Cell[3371, 122, 182, 7, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->3591],
  Cell[3578, 133, 727, 24, 28, "Input",
   CellTags->"b:5.5",
   CellID->12189],
  Cell[4308, 159, 1072, 34, 55, "Output",
   CellTags->"b:5.5",
   CellID->455226116],
  Cell[5395, 196, 365, 10, 70, "Text",
   CellTags->"b:5.5",
   CellID->31490],
  Cell[5763, 208, 223, 8, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->3239],
  Cell[6011, 220, 571, 19, 28, "Input",
   CellTags->"b:5.5",
   CellID->14893],
  Cell[6585, 241, 18492, 308, 244, "Output",
   Evaluatable->False,
   CellTags->"b:5.5",
   CellID->148090797],
  Cell[25092, 552, 160, 5, 70, "Text",
   CellTags->"b:5.5",
   CellID->17063],
  Cell[25255, 559, 245, 8, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->10681],
  Cell[25503, 569, 311, 11, 70, "Input",
   CellTags->"b:5.5",
   CellID->25903],
  Cell[25839, 584, 225, 8, 70, "Input",
   CellTags->"b:5.5",
   CellID->27005],
  Cell[26067, 594, 2791, 89, 123, "Output",
   CellTags->"b:5.5",
   CellID->160249938],
  Cell[28873, 686, 158, 5, 70, "Text",
   CellTags->"b:5.5",
   CellID->18479],
  Cell[29034, 693, 271, 10, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->1695],
  Cell[29330, 707, 385, 13, 70, "Input",
   CellTags->"b:5.5",
   CellID->6139],
  Cell[29718, 722, 473, 16, 51, "Output",
   CellTags->"b:5.5",
   CellID->398481400],
  Cell[30206, 741, 144, 5, 70, "Text",
   CellTags->"b:5.5",
   CellID->13998],
  Cell[30353, 748, 254, 8, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->21083],
  Cell[30632, 760, 440, 16, 70, "Input",
   CellTags->"b:5.5",
   CellID->23639],
  Cell[31075, 778, 485, 17, 55, "Output",
   CellTags->"b:5.5",
   CellID->551435822],
  Cell[31575, 798, 249, 9, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->27621],
  Cell[31849, 811, 413, 15, 70, "Input",
   CellTags->"b:5.5",
   CellID->29993],
  Cell[32265, 828, 518, 19, 51, "Output",
   CellTags->"b:5.5",
   CellID->336276692],
  Cell[32798, 850, 428, 13, 70, "Text",
   CellTags->"b:5.5",
   CellID->15722],
  Cell[33241, 866, 169, 5, 70, "BulletedText",
   CellTags->"b:5.5",
   CellID->23838],
  Cell[33413, 873, 149, 5, 70, "BulletedText",
   CellTags->"b:5.5",
   CellID->24828],
  Cell[33587, 882, 235, 6, 70, "BulletedText",
   CellTags->"b:5.5",
   CellID->12581],
  Cell[33825, 890, 481, 11, 70, "Text",
   CellTags->"b:5.5",
   CellID->24399],
  Cell[34309, 903, 120, 3, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->8978],
  Cell[34432, 908, 143, 5, 70, "Input",
   CellTags->"b:5.5",
   CellID->11891],
  Cell[34600, 917, 127, 4, 70, "Input",
   CellTags->"b:5.5",
   CellID->1023],
  Cell[34730, 923, 189, 6, 36, "Output",
   CellTags->"b:5.5",
   CellID->724847426],
  Cell[34956, 934, 214, 7, 70, "Input",
   CellTags->"b:5.5",
   CellID->24834],
  Cell[35173, 943, 198, 6, 50, "Output",
   CellTags->"b:5.5",
   CellID->825763686],
  Cell[35408, 954, 129, 4, 70, "Input",
   CellTags->"b:5.5",
   CellID->2702],
  Cell[35540, 960, 195, 6, 36, "Output",
   CellTags->"b:5.5",
   CellID->765784900],
  Cell[35772, 971, 192, 6, 70, "Input",
   CellTags->"b:5.5",
   CellID->20502],
  Cell[35967, 979, 234, 7, 36, "Output",
   CellTags->"b:5.5",
   CellID->31196534],
  Cell[36238, 991, 136, 4, 70, "Input",
   CellTags->"b:5.5",
   CellID->10687],
  Cell[36377, 997, 181, 6, 36, "Output",
   CellTags->"b:5.5",
   CellID->30529317],
  Cell[36573, 1006, 505, 16, 70, "Text",
   CellTags->"b:5.5",
   CellID->15891],
  Cell[37081, 1024, 137, 4, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->24637],
  Cell[37243, 1032, 304, 11, 70, "Input",
   CellTags->"b:5.5",
   CellID->18413],
  Cell[37550, 1045, 479, 16, 39, "Output",
   CellTags->"b:5.5",
   CellID->141971873],
  Cell[38066, 1066, 312, 11, 70, "Input",
   CellTags->"b:5.5",
   CellID->22816],
  Cell[38381, 1079, 496, 16, 39, "Output",
   CellTags->"b:5.5",
   CellID->497478768],
  Cell[38892, 1098, 356, 8, 70, "Text",
   CellTags->"b:5.5",
   CellID->13162],
  Cell[39251, 1108, 300, 8, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->8935],
  Cell[39576, 1120, 1915, 65, 70, "Input",
   CellTags->"b:5.5",
   CellID->29126],
  Cell[41494, 1187, 234, 8, 36, "Output",
   CellTags->"b:5.5",
   CellID->360824292],
  Cell[41765, 1200, 124, 4, 70, "Input",
   CellTags->"b:5.5",
   CellID->19877],
  Cell[41892, 1206, 183, 6, 36, "Output",
   CellTags->"b:5.5",
   CellID->49635889],
  Cell[42090, 1215, 172, 5, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->26260],
  Cell[42287, 1224, 550, 18, 70, "Input",
   CellTags->"b:5.5",
   CellID->27189],
  Cell[42840, 1244, 201, 7, 36, "Output",
   CellTags->"b:5.5",
   CellID->118430727],
  Cell[43056, 1254, 368, 13, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->13874],
  Cell[43449, 1271, 1915, 65, 70, "Input",
   CellTags->"b:5.5",
   CellID->2663],
  Cell[45367, 1338, 245, 8, 36, "Output",
   CellTags->"b:5.5",
   CellID->255147482],
  Cell[45649, 1351, 124, 4, 70, "Input",
   CellTags->"b:5.5",
   CellID->32195],
  Cell[45776, 1357, 181, 6, 36, "Output",
   CellTags->"b:5.5",
   CellID->60661836],
  Cell[45994, 1368, 500, 17, 70, "Input",
   CellTags->"b:5.5",
   CellID->16360],
  Cell[46497, 1387, 201, 7, 36, "Output",
   CellTags->"b:5.5",
   CellID->249461648],
  Cell[46713, 1397, 780, 19, 70, "Text",
   CellTags->"b:5.5",
   CellID->18588],
  Cell[47496, 1418, 100, 2, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->7811],
  Cell[47621, 1424, 466, 15, 70, "Input",
   CellTags->"b:5.5",
   CellID->28245],
  Cell[48090, 1441, 388, 13, 39, "Output",
   CellTags->"b:5.5",
   CellID->277752595],
  Cell[48493, 1457, 132, 4, 70, "MathCaption",
   CellTags->"b:5.5",
   CellID->32425],
  Cell[48650, 1465, 559, 18, 70, "Input",
   CellTags->"b:5.5",
   CellID->26867],
  Cell[49212, 1485, 412, 14, 54, "Output",
   CellTags->"b:5.5",
   CellID->170992134]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:56", 52187, 1569},
 {"b:5.5", 52289, 1573}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 106, 2, 70, "Title",
 CellTags->{"c:56", "b:5.5"},
 CellID->20476],
Cell[1389, 47, 127, 4, 70, "Text",
 CellTags->"b:5.5",
 CellID->30041],
Cell[CellGroupData[{
Cell[1541, 55, 384, 10, 70, "BulletedText",
 CellTags->"b:5.5",
 CellID->3351],
Cell[1928, 67, 90, 2, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->8329],
Cell[CellGroupData[{
Cell[2043, 73, 348, 12, 28, "Input",
 CellTags->"b:5.5",
 CellID->16290],
Cell[2394, 87, 632, 21, 36, "Output",
 CellTags->"b:5.5",
 CellID->83068728]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3075, 114, 293, 6, 70, "BulletedText",
 CellTags->"b:5.5",
 CellID->23072],
Cell[3371, 122, 182, 7, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->3591],
Cell[CellGroupData[{
Cell[3578, 133, 727, 24, 28, "Input",
 CellTags->"b:5.5",
 CellID->12189],
Cell[4308, 159, 1072, 34, 55, "Output",
 CellTags->"b:5.5",
 CellID->455226116]
}, Open  ]],
Cell[5395, 196, 365, 10, 70, "Text",
 CellTags->"b:5.5",
 CellID->31490],
Cell[5763, 208, 223, 8, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->3239],
Cell[CellGroupData[{
Cell[6011, 220, 571, 19, 28, "Input",
 CellTags->"b:5.5",
 CellID->14893],
Cell[6585, 241, 18492, 308, 244, "Output",
 Evaluatable->False,
 CellTags->"b:5.5",
 CellID->148090797]
}, Open  ]],
Cell[25092, 552, 160, 5, 70, "Text",
 CellTags->"b:5.5",
 CellID->17063],
Cell[25255, 559, 245, 8, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->10681],
Cell[25503, 569, 311, 11, 70, "Input",
 CellTags->"b:5.5",
 CellID->25903],
Cell[CellGroupData[{
Cell[25839, 584, 225, 8, 70, "Input",
 CellTags->"b:5.5",
 CellID->27005],
Cell[26067, 594, 2791, 89, 123, "Output",
 CellTags->"b:5.5",
 CellID->160249938]
}, Open  ]],
Cell[28873, 686, 158, 5, 70, "Text",
 CellTags->"b:5.5",
 CellID->18479],
Cell[29034, 693, 271, 10, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->1695],
Cell[CellGroupData[{
Cell[29330, 707, 385, 13, 70, "Input",
 CellTags->"b:5.5",
 CellID->6139],
Cell[29718, 722, 473, 16, 51, "Output",
 CellTags->"b:5.5",
 CellID->398481400]
}, Open  ]],
Cell[30206, 741, 144, 5, 70, "Text",
 CellTags->"b:5.5",
 CellID->13998],
Cell[30353, 748, 254, 8, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->21083],
Cell[CellGroupData[{
Cell[30632, 760, 440, 16, 70, "Input",
 CellTags->"b:5.5",
 CellID->23639],
Cell[31075, 778, 485, 17, 55, "Output",
 CellTags->"b:5.5",
 CellID->551435822]
}, Open  ]],
Cell[31575, 798, 249, 9, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->27621],
Cell[CellGroupData[{
Cell[31849, 811, 413, 15, 70, "Input",
 CellTags->"b:5.5",
 CellID->29993],
Cell[32265, 828, 518, 19, 51, "Output",
 CellTags->"b:5.5",
 CellID->336276692]
}, Open  ]],
Cell[32798, 850, 428, 13, 70, "Text",
 CellTags->"b:5.5",
 CellID->15722]
}, Open  ]],
Cell[33241, 866, 169, 5, 70, "BulletedText",
 CellTags->"b:5.5",
 CellID->23838],
Cell[33413, 873, 149, 5, 70, "BulletedText",
 CellTags->"b:5.5",
 CellID->24828],
Cell[CellGroupData[{
Cell[33587, 882, 235, 6, 70, "BulletedText",
 CellTags->"b:5.5",
 CellID->12581],
Cell[33825, 890, 481, 11, 70, "Text",
 CellTags->"b:5.5",
 CellID->24399],
Cell[34309, 903, 120, 3, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->8978],
Cell[34432, 908, 143, 5, 70, "Input",
 CellTags->"b:5.5",
 CellID->11891],
Cell[CellGroupData[{
Cell[34600, 917, 127, 4, 70, "Input",
 CellTags->"b:5.5",
 CellID->1023],
Cell[34730, 923, 189, 6, 36, "Output",
 CellTags->"b:5.5",
 CellID->724847426]
}, Open  ]],
Cell[CellGroupData[{
Cell[34956, 934, 214, 7, 70, "Input",
 CellTags->"b:5.5",
 CellID->24834],
Cell[35173, 943, 198, 6, 50, "Output",
 CellTags->"b:5.5",
 CellID->825763686]
}, Open  ]],
Cell[CellGroupData[{
Cell[35408, 954, 129, 4, 70, "Input",
 CellTags->"b:5.5",
 CellID->2702],
Cell[35540, 960, 195, 6, 36, "Output",
 CellTags->"b:5.5",
 CellID->765784900]
}, Open  ]],
Cell[CellGroupData[{
Cell[35772, 971, 192, 6, 70, "Input",
 CellTags->"b:5.5",
 CellID->20502],
Cell[35967, 979, 234, 7, 36, "Output",
 CellTags->"b:5.5",
 CellID->31196534]
}, Open  ]],
Cell[CellGroupData[{
Cell[36238, 991, 136, 4, 70, "Input",
 CellTags->"b:5.5",
 CellID->10687],
Cell[36377, 997, 181, 6, 36, "Output",
 CellTags->"b:5.5",
 CellID->30529317]
}, Open  ]],
Cell[36573, 1006, 505, 16, 70, "Text",
 CellTags->"b:5.5",
 CellID->15891],
Cell[37081, 1024, 137, 4, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->24637],
Cell[CellGroupData[{
Cell[37243, 1032, 304, 11, 70, "Input",
 CellTags->"b:5.5",
 CellID->18413],
Cell[37550, 1045, 479, 16, 39, "Output",
 CellTags->"b:5.5",
 CellID->141971873]
}, Open  ]],
Cell[CellGroupData[{
Cell[38066, 1066, 312, 11, 70, "Input",
 CellTags->"b:5.5",
 CellID->22816],
Cell[38381, 1079, 496, 16, 39, "Output",
 CellTags->"b:5.5",
 CellID->497478768]
}, Open  ]],
Cell[38892, 1098, 356, 8, 70, "Text",
 CellTags->"b:5.5",
 CellID->13162],
Cell[39251, 1108, 300, 8, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->8935],
Cell[CellGroupData[{
Cell[39576, 1120, 1915, 65, 70, "Input",
 CellTags->"b:5.5",
 CellID->29126],
Cell[41494, 1187, 234, 8, 36, "Output",
 CellTags->"b:5.5",
 CellID->360824292]
}, Open  ]],
Cell[CellGroupData[{
Cell[41765, 1200, 124, 4, 70, "Input",
 CellTags->"b:5.5",
 CellID->19877],
Cell[41892, 1206, 183, 6, 36, "Output",
 CellTags->"b:5.5",
 CellID->49635889]
}, Open  ]],
Cell[42090, 1215, 172, 5, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->26260],
Cell[CellGroupData[{
Cell[42287, 1224, 550, 18, 70, "Input",
 CellTags->"b:5.5",
 CellID->27189],
Cell[42840, 1244, 201, 7, 36, "Output",
 CellTags->"b:5.5",
 CellID->118430727]
}, Open  ]],
Cell[43056, 1254, 368, 13, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->13874],
Cell[CellGroupData[{
Cell[43449, 1271, 1915, 65, 70, "Input",
 CellTags->"b:5.5",
 CellID->2663],
Cell[45367, 1338, 245, 8, 36, "Output",
 CellTags->"b:5.5",
 CellID->255147482]
}, Open  ]],
Cell[CellGroupData[{
Cell[45649, 1351, 124, 4, 70, "Input",
 CellTags->"b:5.5",
 CellID->32195],
Cell[45776, 1357, 181, 6, 36, "Output",
 CellTags->"b:5.5",
 CellID->60661836]
}, Open  ]],
Cell[CellGroupData[{
Cell[45994, 1368, 500, 17, 70, "Input",
 CellTags->"b:5.5",
 CellID->16360],
Cell[46497, 1387, 201, 7, 36, "Output",
 CellTags->"b:5.5",
 CellID->249461648]
}, Open  ]],
Cell[46713, 1397, 780, 19, 70, "Text",
 CellTags->"b:5.5",
 CellID->18588],
Cell[47496, 1418, 100, 2, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->7811],
Cell[CellGroupData[{
Cell[47621, 1424, 466, 15, 70, "Input",
 CellTags->"b:5.5",
 CellID->28245],
Cell[48090, 1441, 388, 13, 39, "Output",
 CellTags->"b:5.5",
 CellID->277752595]
}, Open  ]],
Cell[48493, 1457, 132, 4, 70, "MathCaption",
 CellTags->"b:5.5",
 CellID->32425],
Cell[CellGroupData[{
Cell[48650, 1465, 559, 18, 70, "Input",
 CellTags->"b:5.5",
 CellID->26867],
Cell[49212, 1485, 412, 14, 54, "Output",
 CellTags->"b:5.5",
 CellID->170992134]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49673, 1505, 71, 1, 70, "RelatedTutorialsSection",
 CellID->39658249],
Cell[49747, 1508, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[49951, 1515, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

