(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    126149,       3493]
NotebookOptionsPosition[    108151,       2851]
NotebookOutlinePosition[    118200,       3178]
CellTagsIndexPosition[    118103,       3172]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Linear Systems of ODEs", "Title",
 CellTags->{"c:33", "b:1.2.1"},
 CellID->10542],

Cell["\<\
Here is a system of two ODEs whose coefficient matrix has real and distinct \
eigenvalues.\
\>", "MathCaption",
 CellTags->"b:1.2.1",
 CellID->13063],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[12]:=",
 CellID->21547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "A", "]"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[13]:=",
 CellID->30502],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[13]=",
 CellID->94147145]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"X", "[", "t_", "]"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", " ", 
     RowBox[{"y", "[", "t", "]"}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[14]:=",
 CellID->9099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"system", " ", "=", " ", 
  RowBox[{"MapThread", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "\[Equal]", "#2"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "'"}], "[", "t", "]"}], ",", 
      RowBox[{"A", ".", 
       RowBox[{"X", "[", "t", "]"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[15]:=",
 CellID->25023],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"x", "[", "t", "]"}]}], "-", 
     RowBox[{"6", " ", 
      RowBox[{"y", "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "-", 
     RowBox[{"y", "[", "t", "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[15]=",
 CellID->141688606]
}, Open  ]],

Cell[TextData[{
 "This solves the system. Note that the general solution depends on two \
arbitrary constants ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:1.2.1",
 CellID->31203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"system", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[16]:=",
 CellID->30048],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "t"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["\[ExponentialE]", "t"]}]}], ")"}], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["\[ExponentialE]", "t"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", "t"]}], ")"}], " ", 
         RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "t"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", "t"]}], ")"}], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "t"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", "t"]}]}], ")"}], " ", 
         RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{384, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[16]=",
 CellID->122293535]
}, Open  ]],

Cell[TextData[{
 "Here is a plot of some particular solutions obtained by giving specific \
values to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 ". In this case, the origin is a called a ",
 StyleBox["node.",
  FontSlant->"Italic"]
}], "MathCaption",
 CellTags->"b:1.2.1",
 CellID->1570],

Cell[BoxData[
 RowBox[{
  RowBox[{"particularsols", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "[", "t", "]"}], ",", " ", 
            RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", "sol"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"C", "[", "1", "]"}], " ", "\[Rule]", " ", 
            RowBox[{"1", "/", "i"}]}], ",", " ", 
           RowBox[{
            RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", 
            RowBox[{"1", "/", "j"}]}]}], "}"}]}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"-", "20"}], ",", "20", ",", " ", "6"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"-", "20"}], ",", "20", ",", " ", "6"}], "}"}]}], "]"}], 
      "]"}], ",", " ", "2"}], "]"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[17]:=",
 CellID->8636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "particularsols", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[18]:=",
 CellID->9458],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 304},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[18]=",
 CellID->37375055]
}, Open  ]],

Cell["\<\
In this system the eigenvalues of the coefficient matrix are complex \
conjugates of each other.\
\>", "MathCaption",
 CellTags->"b:1.2.1",
 CellID->8456],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", 
       RowBox[{"-", "8"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       RowBox[{"-", "5"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[19]:=",
 CellID->9405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "A", "]"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[20]:=",
 CellID->11531],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[20]=",
 CellID->322682584]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"X", "[", "t_", "]"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", " ", 
     RowBox[{"y", "[", "t", "]"}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[21]:=",
 CellID->26819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"system", " ", "=", " ", 
  RowBox[{"MapThread", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "\[Equal]", "#2"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "'"}], "[", "t", "]"}], ",", 
      RowBox[{"A", ".", 
       RowBox[{"X", "[", "t", "]"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[22]:=",
 CellID->7975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"7", " ", 
      RowBox[{"x", "[", "t", "]"}]}], "-", 
     RowBox[{"8", " ", 
      RowBox[{"y", "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"5", " ", 
      RowBox[{"x", "[", "t", "]"}]}], "-", 
     RowBox[{"5", " ", 
      RowBox[{"y", "[", "t", "]"}]}]}]}]}], "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[22]=",
 CellID->250604687]
}, Open  ]],

Cell["This solves the system.", "MathCaption",
 CellTags->"b:1.2.1",
 CellID->7531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"system", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[23]:=",
 CellID->31495],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["\[ExponentialE]", "t"], " ", 
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", " ", "t"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "t"], " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"2", " ", "t"}], "]"}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}]}], ")"}]}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "t"], " ", 
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"2", " ", "t"}], "]"}], "-", 
           RowBox[{"3", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["5", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", "t"], " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", " ", "t"}], "]"}]}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{470, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[23]=",
 CellID->426791507]
}, Open  ]],

Cell[TextData[{
 "This plots the solution for various values of the arbitrary parameters. The \
",
 StyleBox["spiraling",
  FontSlant->"Italic"],
 " behavior is typical for systems with complex eigenvalues."
}], "MathCaption",
 CellTags->"b:1.2.1",
 CellID->30591],

Cell[BoxData[
 RowBox[{
  RowBox[{"particularsols", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "[", "t", "]"}], ",", " ", 
            RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", "sol"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"C", "[", "1", "]"}], " ", "\[Rule]", " ", 
            RowBox[{"1", "/", "i"}]}], ",", " ", 
           RowBox[{
            RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", 
            RowBox[{"1", "/", "j"}]}]}], "}"}]}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"-", "10"}], ",", "10", ",", " ", "8"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"-", "10"}], ",", "10", ",", " ", "8"}], "}"}]}], "]"}], 
      "]"}], ",", " ", "2"}], "]"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[24]:=",
 CellID->26803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "particularsols", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "35"}], ",", "35"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}], ",", " ", 
   RowBox[{"PlotPoints", " ", "\[Rule]", " ", "70"}], ",", " ", 
   RowBox[{"Method", "->", 
    RowBox[{"{", 
     RowBox[{"Compiled", " ", "\[Rule]", " ", "False"}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[25]:=",
 CellID->3388],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[25]=",
 CellID->347423990]
}, Open  ]],

Cell["\<\
Solving homogeneous systems of ODEs with constant coefficients and of \
arbitrary order is a straightforward matter. They are solved by converting \
them to a system of first-order ODEs.\
\>", "Text",
 CellTags->"b:1.2.1",
 CellID->7450],

Cell["\<\
This solves a homogeneous system of ODEs of order 3, with constant \
coefficients.\
\>", "MathCaption",
 CellTags->"b:1.2.1",
 CellID->12319],

Cell[BoxData[
 RowBox[{
  RowBox[{"system", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'''"}], "[", "t", "]"}], "+", " ", 
      RowBox[{"y", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'''"}], "[", "t", "]"}], "-", 
      RowBox[{"64", " ", 
       RowBox[{"x", "[", "t", "]"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[26]:=",
 CellID->6272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"system", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], ",", " ", 
      RowBox[{
       RowBox[{"system", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}]}], "}"}], ",", " ", 
    
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[27]:=",
 CellID->25791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         FractionBox["1", "3"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "3", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["1", "96"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "6", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}], "-", 
           RowBox[{
            SqrtBox["3"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["1", "24"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}], "-", 
           RowBox[{
            SqrtBox["3"], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["1", "192"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SqrtBox["3"]}], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "-", 
           RowBox[{"Sin", "[", "t", "]"}], "-", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}]}], ")"}]}], "-", 
        RowBox[{
         FractionBox["1", "24"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "5", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sin", "[", "t", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["1", "12"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "4", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SqrtBox["3"]}], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "+", 
           RowBox[{"Sin", "[", "t", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}]}], ")"}]}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         FractionBox["1", "3"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "5", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}]}], ")"}]}], "-", 
        RowBox[{
         FractionBox["2", "3"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "4", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}], "-", 
           RowBox[{
            SqrtBox["3"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["1", "24"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}], "-", 
           RowBox[{
            SqrtBox["3"], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}], "-", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SqrtBox["3"]}], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "-", 
           RowBox[{"Sin", "[", "t", "]"}], "-", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["8", "3"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "3", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sin", "[", "t", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["1", "12"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "t"}]], " ", 
         RowBox[{"C", "[", "6", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SqrtBox["3"]}], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "+", 
           RowBox[{"Sin", "[", "t", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", "t", "]"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SqrtBox["3"], " ", "t"}]], " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}]}], ")"}]}]}]}], "]"}]}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{590, 447},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[27]=",
 CellID->16117136]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:1.2.1",
 CellID->10133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"system", "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", " ", 
      RowBox[{"RandomComplex", "[", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", 
      RowBox[{"RandomComplex", "[", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", 
      RowBox[{"RandomComplex", "[", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"C", "[", "3", "]"}], "\[Rule]", " ", 
      RowBox[{"RandomComplex", "[", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"C", "[", "4", "]"}], "\[Rule]", " ", 
      RowBox[{"RandomComplex", "[", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"C", "[", "5", "]"}], "\[Rule]", " ", 
      RowBox[{"RandomComplex", "[", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"C", "[", "6", "]"}], "\[Rule]", " ", 
      RowBox[{"RandomComplex", "[", "]"}]}]}], "}"}]}], "//", 
  "Chop"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[28]:=",
 CellID->1775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[28]=",
 CellID->119191296]
}, Open  ]],

Cell["\<\
In general, systems of linear ODEs with non-constant coefficients can only be \
solved in cases where the coefficient matrix has a simple structure, as \
illustrated in the following examples.\
\>", "Text",
 CellTags->"b:1.2.1",
 CellID->23569],

Cell[TextData[{
 "This first-order system has a diagonal coefficient matrix. The system is ",
 StyleBox["uncoupled",
  FontSlant->"Italic"],
 " because the first equation involves only ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 " and the second equation depends only on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 ". Thus, each equation in the system can be integrated independently of the \
other."
}], "MathCaption",
 CellTags->"b:1.2.1",
 CellID->18300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], "*", 
       RowBox[{"x", "[", "t", "]"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"t", "^", "2"}], "*", 
       RowBox[{"y", "[", "t", "]"}]}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[29]:=",
 CellID->17954],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          RowBox[{"Cos", "[", "t", "]"}]}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          SuperscriptBox["t", "3"], "3"]], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{420, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[29]=",
 CellID->716780278]
}, Open  ]],

Cell["\<\
The rows of the coefficient matrix for this system form an orthogonal set of \
vectors.\
\>", "MathCaption",
 CellTags->"b:1.2.1",
 CellID->3585],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"E", "^", "t"}], ",", " ", 
       RowBox[{"Tan", "[", "t", "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Tan", "[", "t", "]"}]}], ",", " ", 
       RowBox[{"E", "^", "t"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[30]:=",
 CellID->2257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A", ".", 
   RowBox[{"Transpose", "[", "A", "]"}]}], "/", 
  RowBox[{"Det", "[", "A", "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[31]:=",
 CellID->25333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[31]=",
 CellID->345205457]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"X", "[", "t_", "]"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", " ", 
     RowBox[{"y", "[", "t", "]"}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[32]:=",
 CellID->10490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"system", " ", "=", " ", 
  RowBox[{"MapThread", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "\[Equal]", "#2"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "'"}], "[", "t", "]"}], ",", 
      RowBox[{"A", ".", 
       RowBox[{"X", "[", "t", "]"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[33]:=",
 CellID->10103],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "t"], " ", 
      RowBox[{"x", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Tan", "[", "t", "]"}], " ", 
      RowBox[{"y", "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Tan", "[", "t", "]"}]}], " ", 
      RowBox[{"x", "[", "t", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "t"], " ", 
      RowBox[{"y", "[", "t", "]"}]}]}]}]}], "}"}]], "Output",
 ImageSize->{393, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[33]=",
 CellID->110378199]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"system", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[34]:=",
 CellID->17233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          SuperscriptBox["\[ExponentialE]", "t"]], " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"Log", "[", 
           RowBox[{"Cos", "[", "t", "]"}], "]"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          SuperscriptBox["\[ExponentialE]", "t"]], " ", 
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"Log", "[", 
           RowBox[{"Cos", "[", "t", "]"}], "]"}], "]"}]}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          SuperscriptBox["\[ExponentialE]", "t"]], " ", 
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"Log", "[", 
           RowBox[{"Cos", "[", "t", "]"}], "]"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          SuperscriptBox["\[ExponentialE]", "t"]], " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"Log", "[", 
           RowBox[{"Cos", "[", "t", "]"}], "]"}], "]"}]}]}]}], "]"}]}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{498, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[34]=",
 CellID->205184344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"system", "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[35]:=",
 CellID->24271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[35]=",
 CellID->90612572]
}, Open  ]],

Cell["\<\
Here is a system of three first-order ODEs. The coefficient matrix is upper \
triangular.\
\>", "MathCaption",
 CellTags->"b:1.2.1",
 CellID->18990],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"E", "^", "t"}], ",", " ", "2", ",", " ", "3"}], "}"}], ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[36]:=",
 CellID->30338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "A", "]"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[37]:=",
 CellID->21641],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SuperscriptBox["\[ExponentialE]", "t"], "2", "3"},
     {"0", "2", 
      RowBox[{"-", "1"}]},
     {"0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{75, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[37]//MatrixForm=",
 CellID->453089989]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"X", "[", "t_", "]"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", " ", 
     RowBox[{"y", "[", "t", "]"}], ",", " ", 
     RowBox[{"z", "[", "t", "]"}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[38]:=",
 CellID->19047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"system", " ", "=", " ", 
  RowBox[{"MapThread", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "\[Equal]", "#2"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "'"}], "[", "t", "]"}], ",", 
      RowBox[{"A", ".", 
       RowBox[{"X", "[", "t", "]"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[39]:=",
 CellID->2352],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "t"], " ", 
      RowBox[{"x", "[", "t", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"y", "[", "t", "]"}]}], "+", 
     RowBox[{"3", " ", 
      RowBox[{"z", "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"y", "[", "t", "]"}]}], "-", 
     RowBox[{"z", "[", "t", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["z", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{"z", "[", "t", "]"}]}]}], "}"}]], "Output",
 ImageSize->{438, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[39]=",
 CellID->269302012]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"system", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[40]:=",
 CellID->479],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          SuperscriptBox["\[ExponentialE]", "t"]], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           SuperscriptBox["\[ExponentialE]", "t"]}], ")"}], " ", 
         RowBox[{"C", "[", "2", "]"}]}], "-", 
        RowBox[{"5", " ", 
         RowBox[{"C", "[", "3", "]"}]}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "t"}]], " ", 
         RowBox[{"C", "[", "2", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "t"], " ", 
         RowBox[{"C", "[", "3", "]"}]}]}]}], "]"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "t"], " ", 
        RowBox[{"C", "[", "3", "]"}]}]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{444, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[40]=",
 CellID->197819530]
}, Open  ]],

Cell["\<\
As for single ODEs, there are sophisticated modern algorithms for solving \
systems of ODEs with rational coefficients.\
\>", "Text",
 CellTags->"b:1.2.1",
 CellID->32683],

Cell["\<\
This solves a system of two first-order ODEs with rational coefficients. Note \
that the solution is composed entirely of rational functions.\
\>", "MathCaption",
 CellTags->"b:1.2.1",
 CellID->10002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5", "+", "x"}], ")"}], " ", 
         RowBox[{"w", "[", "x", "]"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "-", 
           RowBox[{"2", " ", "x"}], "+", 
           SuperscriptBox["x", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["x", "3"]}], ")"}]}]], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"6", "+", 
           RowBox[{"2", " ", "x"}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["x", "3"]}], "-", 
           SuperscriptBox["x", "5"]}], ")"}], " ", 
         RowBox[{"y", "[", "x", "]"}]}], 
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "-", 
           RowBox[{"2", " ", "x"}], "+", 
           SuperscriptBox["x", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["x", "3"]}], ")"}]}]]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"20", " ", 
            SuperscriptBox["x", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["x", "3"]}]}], ")"}], " ", 
         RowBox[{"w", "[", "x", "]"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5", "+", "x"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["x", "3"]}], ")"}]}]], "-", 
       FractionBox[
        RowBox[{"4", " ", "x", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "-", 
           RowBox[{"2", " ", "x"}], "+", 
           SuperscriptBox["x", "2"]}], ")"}], " ", 
         RowBox[{"y", "[", "x", "]"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5", "+", "x"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["x", "3"]}], ")"}]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "w"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[41]:=",
 CellID->15568],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{"x", " ", 
          RowBox[{"C", "[", "1", "]"}]}], 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          RowBox[{"2", " ", "x"}], "+", 
          SuperscriptBox["x", "2"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"C", "[", "2", "]"}]}], 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          RowBox[{"2", " ", "x"}], "+", 
          SuperscriptBox["x", "2"]}]]}]}], "]"}]}], ",", 
    RowBox[{"w", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{"C", "[", "1", "]"}], 
         RowBox[{"5", "+", "x"}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["x", "4"], " ", 
          RowBox[{"C", "[", "2", "]"}]}], 
         RowBox[{"5", "+", "x"}]]}]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{546, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[41]=",
 CellID->417148286]
}, Open  ]],

Cell[TextData[{
 "In the following example, the algorithm finds one rational solution for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 ". (The equation for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 " is uncoupled from the rest of the system.) Using the rational solution, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is able to find the remaining exponential solution for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellTags->"b:1.2.1",
 CellID->16895],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"system", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", "t", "+", 
               RowBox[{"t", "^", "2"}]}], ")"}], "*", 
             RowBox[{"x", "[", "t", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6"}], "+", 
               RowBox[{"t", "^", "2"}]}], ")"}], "*", 
             RowBox[{"y", "[", "t", "]"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "t"}], ")"}], "*", "t"}], ")"}]}]}], ",",
       
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"2", "*", "t"}], "+", 
             RowBox[{"t", "^", "2"}]}], ")"}], "*", 
           RowBox[{"x", "[", "t", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"24", "-", 
             RowBox[{"2", "*", "t"}], "-", 
             RowBox[{"3", "*", 
              RowBox[{"t", "^", "2"}]}]}], ")"}], "*", 
           RowBox[{"y", "[", "t", "]"}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "t"}], ")"}], "*", "t"}], ")"}]}]}], ",",
       " ", 
      RowBox[{
       RowBox[{
        RowBox[{"z", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"t", "*", 
        RowBox[{"z", "[", "t", "]"}]}]}]}], "}"}]}], ";"}], " "}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[42]:=",
 CellID->6135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"system", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "t"}], "]"}], 
  " "}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[43]:=",
 CellID->18008],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "-", "t"}], ")"}], " ", 
          RowBox[{"C", "[", "1", "]"}]}], 
         SuperscriptBox["t", "3"]], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "t"}]], " ", 
         RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"4", "+", "t"}], ")"}], " ", 
          RowBox[{"C", "[", "1", "]"}]}], 
         SuperscriptBox["t", "3"]], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "t"}]], " ", 
         RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          SuperscriptBox["t", "2"], "2"]], " ", 
        RowBox[{"C", "[", "3", "]"}]}]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{493, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[43]=",
 CellID->349874127]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"system", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[44]:=",
 CellID->16742],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True", ",", "True"}], "}"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[44]=",
 CellID->53119518]
}, Open  ]],

Cell[TextData[{
 "The systems considered so far have all been homogeneous. If the system is \
inhomogeneous (that is, if there are terms free from any dependent variables \
and their derivatives), ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " applies either the ",
 StyleBox["method of variation of parameters",
  FontSlant->"Italic"],
 " or the ",
 StyleBox["method of undetermined coefficients",
  FontSlant->"Italic"],
 " to find the general solution. "
}], "Text",
 CellTags->"b:1.2.1",
 CellID->23699],

Cell["This solves an inhomogeneous system. ", "MathCaption",
 CellTags->"b:1.2.1",
 CellID->23188],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", 
       RowBox[{"-", "8"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       RowBox[{"-", "5"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[45]:=",
 CellID->20178],

Cell[BoxData[
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"t", "/", "10"}], ")"}]}], ",", "t"}], "}"}]}], ";"}]], "Input",\

 CellTags->"b:1.2.1",
 CellLabel->"In[46]:=",
 CellID->4042],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"X", "[", "t_", "]"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", " ", 
     RowBox[{"y", "[", "t", "]"}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[47]:=",
 CellID->31357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"system", " ", "=", " ", 
  RowBox[{"MapThread", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "\[Equal]", "#2"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "'"}], "[", "t", "]"}], ",", 
      RowBox[{
       RowBox[{"A", ".", 
        RowBox[{"X", "[", "t", "]"}]}], "+", "B"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[48]:=",
 CellID->23941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"t", "/", "10"}]], "+", 
     RowBox[{"7", " ", 
      RowBox[{"x", "[", "t", "]"}]}], "-", 
     RowBox[{"8", " ", 
      RowBox[{"y", "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{"t", "+", 
     RowBox[{"5", " ", 
      RowBox[{"x", "[", "t", "]"}]}], "-", 
     RowBox[{"5", " ", 
      RowBox[{"y", "[", "t", "]"}]}]}]}]}], "}"}]], "Output",
 ImageSize->{364, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[48]=",
 CellID->42544529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"system", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[49]:=",
 CellID->7469],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{577, 292},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[49]=",
 CellID->518640375]
}, Open  ]],

Cell[TextData[{
 "Particular solutions to the system can be obtained by assigning values to \
the constants ",
 StyleBox["C[1]", "MR"],
 " and ",
 StyleBox["C[2]", "MR"],
 ". "
}], "Text",
 CellTags->"b:1.2.1",
 CellID->4380],

Cell["Here is a plot of the solution for one choice of parameters.", \
"MathCaption",
 CellTags->"b:1.2.1",
 CellID->31913],

Cell[BoxData[
 RowBox[{
  RowBox[{"particularsol", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", " ", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", 
       RowBox[{"-", "1"}]}], ",", " ", 
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", "2"}]}], "}"}]}]}], 
  ";"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[50]:=",
 CellID->14964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "particularsol", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:1.2.1",
 CellLabel->"In[51]:=",
 CellID->25710],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.1",
 CellLabel->"Out[51]=",
 CellID->161821782]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->154642037],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear Systems of ODEs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveIntroductionToSystemsOfODEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveSystemsOfNonlinearODEs"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 53.0012590}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Here is a system of two ODEs whose coefficient matrix has real and \
distinct eigenvalues. This solves the system. Note that the general solution \
depends on two arbitrary constants C[1] and C[2]. Here is a plot of some \
particular solutions obtained by giving specific values to C[1] and C[2]. In \
this case, the origin is a called a node.", "synonyms" -> {}, "title" -> 
    "Linear Systems of ODEs", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveSystemsOfLinearODEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:33"->{
  Cell[1280, 43, 87, 2, 70, "Title",
   CellTags->{"c:33", "b:1.2.1"},
   CellID->10542]},
 "b:1.2.1"->{
  Cell[1280, 43, 87, 2, 70, "Title",
   CellTags->{"c:33", "b:1.2.1"},
   CellID->10542],
  Cell[1370, 47, 159, 5, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->13063],
  Cell[1532, 54, 330, 13, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->21547],
  Cell[1887, 71, 126, 4, 28, "Input",
   CellTags->"b:1.2.1",
   CellID->30502],
  Cell[2016, 77, 225, 8, 36, "Output",
   CellTags->"b:1.2.1",
   CellID->94147145],
  Cell[2256, 88, 284, 10, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->9099],
  Cell[2565, 102, 407, 14, 28, "Input",
   CellTags->"b:1.2.1",
   CellID->25023],
  Cell[2975, 118, 707, 24, 36, "Output",
   CellTags->"b:1.2.1",
   CellID->141688606],
  Cell[3697, 145, 456, 17, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->31203],
  Cell[4178, 166, 241, 8, 28, "Input",
   CellTags->"b:1.2.1",
   CellID->30048],
  Cell[4422, 176, 1650, 50, 58, "Output",
   CellTags->"b:1.2.1",
   CellID->122293535],
  Cell[6087, 229, 530, 19, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->1570],
  Cell[6620, 250, 1066, 31, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->8636],
  Cell[7711, 285, 416, 13, 28, "Input",
   CellTags->"b:1.2.1",
   CellID->9458],
  Cell[8130, 300, 27664, 458, 325, "Output",
   Evaluatable->False,
   CellTags->"b:1.2.1",
   CellID->37375055],
  Cell[35809, 761, 164, 5, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->8456],
  Cell[35976, 768, 329, 13, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->9405],
  Cell[36330, 785, 126, 4, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->11531],
  Cell[36459, 791, 349, 12, 36, "Output",
   CellTags->"b:1.2.1",
   CellID->322682584],
  Cell[36823, 806, 285, 10, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->26819],
  Cell[37133, 820, 406, 14, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->7975],
  Cell[37542, 836, 761, 26, 36, "Output",
   CellTags->"b:1.2.1",
   CellID->250604687],
  Cell[38318, 865, 83, 2, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->7531],
  Cell[38426, 871, 241, 8, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->31495],
  Cell[38670, 881, 1721, 52, 73, "Output",
   CellTags->"b:1.2.1",
   CellID->426791507],
  Cell[40406, 936, 264, 8, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->30591],
  Cell[40673, 946, 1067, 31, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->26803],
  Cell[41765, 981, 543, 15, 47, "Input",
   CellTags->"b:1.2.1",
   CellID->3388],
  Cell[42311, 998, 11350, 191, 240, "Output",
   Evaluatable->False,
   CellTags->"b:1.2.1",
   CellID->347423990],
  Cell[53676, 1192, 247, 6, 70, "Text",
   CellTags->"b:1.2.1",
   CellID->7450],
  Cell[53926, 1200, 151, 5, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->12319],
  Cell[54080, 1207, 451, 16, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->6272],
  Cell[54556, 1227, 499, 17, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->25791],
  Cell[55058, 1246, 12479, 348, 468, "Output",
   CellTags->"b:1.2.1",
   CellID->16117136],
  Cell[67552, 1597, 88, 2, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->10133],
  Cell[67665, 1603, 1082, 31, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->1775],
  Cell[68750, 1636, 226, 8, 36, "Output",
   CellTags->"b:1.2.1",
   CellID->119191296],
  Cell[68991, 1647, 254, 6, 70, "Text",
   CellTags->"b:1.2.1",
   CellID->23569],
  Cell[69248, 1655, 563, 16, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->18300],
  Cell[69836, 1675, 621, 21, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->17954],
  Cell[70460, 1698, 834, 27, 51, "Output",
   CellTags->"b:1.2.1",
   CellID->716780278],
  Cell[71309, 1728, 155, 5, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->3585],
  Cell[71467, 1735, 448, 16, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->2257],
  Cell[71940, 1755, 201, 7, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->25333],
  Cell[72144, 1764, 325, 12, 36, "Output",
   CellTags->"b:1.2.1",
   CellID->345205457],
  Cell[72484, 1779, 285, 10, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->10490],
  Cell[72794, 1793, 407, 14, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->10103],
  Cell[73204, 1809, 936, 31, 39, "Output",
   CellTags->"b:1.2.1",
   CellID->110378199],
  Cell[74177, 1845, 241, 8, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->17233],
  Cell[74421, 1855, 1675, 48, 67, "Output",
   CellTags->"b:1.2.1",
   CellID->205184344],
  Cell[76133, 1908, 204, 7, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->24271],
  Cell[76340, 1917, 231, 8, 36, "Output",
   CellTags->"b:1.2.1",
   CellID->90612572],
  Cell[76586, 1928, 158, 5, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->18990],
  Cell[76747, 1935, 459, 16, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->30338],
  Cell[77231, 1955, 125, 4, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->21641],
  Cell[77359, 1961, 844, 26, 80, "Output",
   CellTags->"b:1.2.1",
   CellID->453089989],
  Cell[78218, 1990, 331, 11, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->19047],
  Cell[78574, 2005, 406, 14, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->2352],
  Cell[78983, 2021, 1010, 33, 39, "Output",
   CellTags->"b:1.2.1",
   CellID->269302012],
  Cell[80030, 2059, 249, 8, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->479],
  Cell[80282, 2069, 1482, 45, 66, "Output",
   CellTags->"b:1.2.1",
   CellID->197819530],
  Cell[81779, 2117, 181, 5, 70, "Text",
   CellTags->"b:1.2.1",
   CellID->32683],
  Cell[81963, 2124, 210, 5, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->10002],
  Cell[82198, 2133, 2652, 84, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->15568],
  Cell[84853, 2219, 1278, 42, 56, "Output",
   CellTags->"b:1.2.1",
   CellID->417148286],
  Cell[86146, 2264, 919, 29, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->16895],
  Cell[87068, 2295, 2055, 66, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->6135],
  Cell[89148, 2365, 254, 9, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->18008],
  Cell[89405, 2376, 1547, 49, 87, "Output",
   CellTags->"b:1.2.1",
   CellID->349874127],
  Cell[90989, 2430, 150, 5, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->16742],
  Cell[91142, 2437, 269, 9, 36, "Output",
   CellTags->"b:1.2.1",
   CellID->53119518],
  Cell[91426, 2449, 581, 17, 70, "Text",
   CellTags->"b:1.2.1",
   CellID->23699],
  Cell[92010, 2468, 98, 2, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->23188],
  Cell[92111, 2472, 335, 13, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->20178],
  Cell[92449, 2487, 261, 11, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->4042],
  Cell[92713, 2500, 285, 10, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->31357],
  Cell[93023, 2514, 440, 16, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->23941],
  Cell[93466, 2532, 849, 28, 39, "Output",
   CellTags->"b:1.2.1",
   CellID->42544529],
  Cell[94352, 2565, 240, 8, 28, "Input",
   CellTags->"b:1.2.1",
   CellID->7469],
  Cell[94595, 2575, 6962, 119, 313, "Output",
   Evaluatable->False,
   CellTags->"b:1.2.1",
   CellID->518640375],
  Cell[101572, 2697, 225, 9, 70, "Text",
   CellTags->"b:1.2.1",
   CellID->4380],
  Cell[101800, 2708, 123, 3, 70, "MathCaption",
   CellTags->"b:1.2.1",
   CellID->31913],
  Cell[101926, 2713, 610, 21, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->14964],
  Cell[102561, 2738, 255, 8, 28, "Input",
   CellTags->"b:1.2.1",
   CellID->25710],
  Cell[102819, 2748, 4989, 86, 152, "Output",
   Evaluatable->False,
   CellTags->"b:1.2.1",
   CellID->161821782]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:33", 110522, 2905},
 {"b:1.2.1", 110627, 2909}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 87, 2, 70, "Title",
 CellTags->{"c:33", "b:1.2.1"},
 CellID->10542],
Cell[1370, 47, 159, 5, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->13063],
Cell[1532, 54, 330, 13, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->21547],
Cell[CellGroupData[{
Cell[1887, 71, 126, 4, 28, "Input",
 CellTags->"b:1.2.1",
 CellID->30502],
Cell[2016, 77, 225, 8, 36, "Output",
 CellTags->"b:1.2.1",
 CellID->94147145]
}, Open  ]],
Cell[2256, 88, 284, 10, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->9099],
Cell[CellGroupData[{
Cell[2565, 102, 407, 14, 28, "Input",
 CellTags->"b:1.2.1",
 CellID->25023],
Cell[2975, 118, 707, 24, 36, "Output",
 CellTags->"b:1.2.1",
 CellID->141688606]
}, Open  ]],
Cell[3697, 145, 456, 17, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->31203],
Cell[CellGroupData[{
Cell[4178, 166, 241, 8, 28, "Input",
 CellTags->"b:1.2.1",
 CellID->30048],
Cell[4422, 176, 1650, 50, 58, "Output",
 CellTags->"b:1.2.1",
 CellID->122293535]
}, Open  ]],
Cell[6087, 229, 530, 19, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->1570],
Cell[6620, 250, 1066, 31, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->8636],
Cell[CellGroupData[{
Cell[7711, 285, 416, 13, 28, "Input",
 CellTags->"b:1.2.1",
 CellID->9458],
Cell[8130, 300, 27664, 458, 325, "Output",
 Evaluatable->False,
 CellTags->"b:1.2.1",
 CellID->37375055]
}, Open  ]],
Cell[35809, 761, 164, 5, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->8456],
Cell[35976, 768, 329, 13, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->9405],
Cell[CellGroupData[{
Cell[36330, 785, 126, 4, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->11531],
Cell[36459, 791, 349, 12, 36, "Output",
 CellTags->"b:1.2.1",
 CellID->322682584]
}, Open  ]],
Cell[36823, 806, 285, 10, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->26819],
Cell[CellGroupData[{
Cell[37133, 820, 406, 14, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->7975],
Cell[37542, 836, 761, 26, 36, "Output",
 CellTags->"b:1.2.1",
 CellID->250604687]
}, Open  ]],
Cell[38318, 865, 83, 2, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->7531],
Cell[CellGroupData[{
Cell[38426, 871, 241, 8, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->31495],
Cell[38670, 881, 1721, 52, 73, "Output",
 CellTags->"b:1.2.1",
 CellID->426791507]
}, Open  ]],
Cell[40406, 936, 264, 8, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->30591],
Cell[40673, 946, 1067, 31, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->26803],
Cell[CellGroupData[{
Cell[41765, 981, 543, 15, 47, "Input",
 CellTags->"b:1.2.1",
 CellID->3388],
Cell[42311, 998, 11350, 191, 240, "Output",
 Evaluatable->False,
 CellTags->"b:1.2.1",
 CellID->347423990]
}, Open  ]],
Cell[53676, 1192, 247, 6, 70, "Text",
 CellTags->"b:1.2.1",
 CellID->7450],
Cell[53926, 1200, 151, 5, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->12319],
Cell[54080, 1207, 451, 16, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->6272],
Cell[CellGroupData[{
Cell[54556, 1227, 499, 17, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->25791],
Cell[55058, 1246, 12479, 348, 468, "Output",
 CellTags->"b:1.2.1",
 CellID->16117136]
}, Open  ]],
Cell[67552, 1597, 88, 2, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->10133],
Cell[CellGroupData[{
Cell[67665, 1603, 1082, 31, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->1775],
Cell[68750, 1636, 226, 8, 36, "Output",
 CellTags->"b:1.2.1",
 CellID->119191296]
}, Open  ]],
Cell[68991, 1647, 254, 6, 70, "Text",
 CellTags->"b:1.2.1",
 CellID->23569],
Cell[69248, 1655, 563, 16, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->18300],
Cell[CellGroupData[{
Cell[69836, 1675, 621, 21, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->17954],
Cell[70460, 1698, 834, 27, 51, "Output",
 CellTags->"b:1.2.1",
 CellID->716780278]
}, Open  ]],
Cell[71309, 1728, 155, 5, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->3585],
Cell[71467, 1735, 448, 16, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->2257],
Cell[CellGroupData[{
Cell[71940, 1755, 201, 7, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->25333],
Cell[72144, 1764, 325, 12, 36, "Output",
 CellTags->"b:1.2.1",
 CellID->345205457]
}, Open  ]],
Cell[72484, 1779, 285, 10, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->10490],
Cell[CellGroupData[{
Cell[72794, 1793, 407, 14, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->10103],
Cell[73204, 1809, 936, 31, 39, "Output",
 CellTags->"b:1.2.1",
 CellID->110378199]
}, Open  ]],
Cell[CellGroupData[{
Cell[74177, 1845, 241, 8, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->17233],
Cell[74421, 1855, 1675, 48, 67, "Output",
 CellTags->"b:1.2.1",
 CellID->205184344]
}, Open  ]],
Cell[CellGroupData[{
Cell[76133, 1908, 204, 7, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->24271],
Cell[76340, 1917, 231, 8, 36, "Output",
 CellTags->"b:1.2.1",
 CellID->90612572]
}, Open  ]],
Cell[76586, 1928, 158, 5, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->18990],
Cell[76747, 1935, 459, 16, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->30338],
Cell[CellGroupData[{
Cell[77231, 1955, 125, 4, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->21641],
Cell[77359, 1961, 844, 26, 80, "Output",
 CellTags->"b:1.2.1",
 CellID->453089989]
}, Open  ]],
Cell[78218, 1990, 331, 11, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->19047],
Cell[CellGroupData[{
Cell[78574, 2005, 406, 14, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->2352],
Cell[78983, 2021, 1010, 33, 39, "Output",
 CellTags->"b:1.2.1",
 CellID->269302012]
}, Open  ]],
Cell[CellGroupData[{
Cell[80030, 2059, 249, 8, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->479],
Cell[80282, 2069, 1482, 45, 66, "Output",
 CellTags->"b:1.2.1",
 CellID->197819530]
}, Open  ]],
Cell[81779, 2117, 181, 5, 70, "Text",
 CellTags->"b:1.2.1",
 CellID->32683],
Cell[81963, 2124, 210, 5, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->10002],
Cell[CellGroupData[{
Cell[82198, 2133, 2652, 84, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->15568],
Cell[84853, 2219, 1278, 42, 56, "Output",
 CellTags->"b:1.2.1",
 CellID->417148286]
}, Open  ]],
Cell[86146, 2264, 919, 29, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->16895],
Cell[87068, 2295, 2055, 66, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->6135],
Cell[CellGroupData[{
Cell[89148, 2365, 254, 9, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->18008],
Cell[89405, 2376, 1547, 49, 87, "Output",
 CellTags->"b:1.2.1",
 CellID->349874127]
}, Open  ]],
Cell[CellGroupData[{
Cell[90989, 2430, 150, 5, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->16742],
Cell[91142, 2437, 269, 9, 36, "Output",
 CellTags->"b:1.2.1",
 CellID->53119518]
}, Open  ]],
Cell[91426, 2449, 581, 17, 70, "Text",
 CellTags->"b:1.2.1",
 CellID->23699],
Cell[92010, 2468, 98, 2, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->23188],
Cell[92111, 2472, 335, 13, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->20178],
Cell[92449, 2487, 261, 11, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->4042],
Cell[92713, 2500, 285, 10, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->31357],
Cell[CellGroupData[{
Cell[93023, 2514, 440, 16, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->23941],
Cell[93466, 2532, 849, 28, 39, "Output",
 CellTags->"b:1.2.1",
 CellID->42544529]
}, Open  ]],
Cell[CellGroupData[{
Cell[94352, 2565, 240, 8, 28, "Input",
 CellTags->"b:1.2.1",
 CellID->7469],
Cell[94595, 2575, 6962, 119, 313, "Output",
 Evaluatable->False,
 CellTags->"b:1.2.1",
 CellID->518640375]
}, Open  ]],
Cell[101572, 2697, 225, 9, 70, "Text",
 CellTags->"b:1.2.1",
 CellID->4380],
Cell[101800, 2708, 123, 3, 70, "MathCaption",
 CellTags->"b:1.2.1",
 CellID->31913],
Cell[101926, 2713, 610, 21, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->14964],
Cell[CellGroupData[{
Cell[102561, 2738, 255, 8, 28, "Input",
 CellTags->"b:1.2.1",
 CellID->25710],
Cell[102819, 2748, 4989, 86, 152, "Output",
 Evaluatable->False,
 CellTags->"b:1.2.1",
 CellID->161821782]
}, Open  ]],
Cell[CellGroupData[{
Cell[107845, 2839, 72, 1, 70, "RelatedTutorialsSection",
 CellID->154642037],
Cell[107920, 2842, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[108124, 2849, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

