(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20550,        601]
NotebookOptionsPosition[     15069,        427]
NotebookOutlinePosition[     18988,        539]
CellTagsIndexPosition[     18895,        533]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Nonlinear Systems of ODEs", "Title",
 CellTags->{"c:34", "b:1.2.2"},
 CellID->25385],

Cell[TextData[{
 "Following are two examples of nonlinear systems of ODEs that can be solved \
symbolically using ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"b:1.2.2",
 CellID->20073],

Cell[TextData[{
 "The first three equations in this system of four nonlinear ODEs can be \
solved independently because none of their right-hand sides depend on ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 ", or ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:1.2.2",
 CellID->27504],

Cell[BoxData[
 RowBox[{
  RowBox[{"system", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"p", "'"}], "[", "x", "]"}], " ", "==", " ", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"q", "'"}], "[", "x", "]"}], " ", "==", " ", "x"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"r", "'"}], "[", "x", "]"}], " ", "==", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"s", "'"}], "[", "x", "]"}], " ", "==", " ", 
      RowBox[{
       RowBox[{"r", "[", "x", "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "[", "x", "]"}], " ", "+", " ", 
         RowBox[{"4", "*", 
          RowBox[{"q", "[", "x", "]"}], "*", 
          RowBox[{"r", "[", "x", "]"}]}]}], ")"}]}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellTags->"b:1.2.2",
 CellLabel->"In[1]:=",
 CellID->9462],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"sol", "=", 
   RowBox[{"DSolve", "[", 
    RowBox[{"system", ",", " ", 
     RowBox[{"{", 
      RowBox[{"p", ",", "q", ",", "r", ",", "s"}], "}"}], ",", " ", "x"}], 
    "]"}], " "}],
  FormatType->StandardForm]], "Input",
 CellTags->"b:1.2.2",
 CellLabel->"In[2]:=",
 CellID->32703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"x", "+", 
        RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], ",", 
    RowBox[{"q", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox[
         SuperscriptBox["x", "2"], "2"], "+", 
        RowBox[{"C", "[", "2", "]"}]}]}], "]"}]}], ",", 
    RowBox[{"r", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"C", "[", "3", "]"}]}], "]"}]}], ",", 
    RowBox[{"s", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"ArcTan", "[", 
           FractionBox[
            RowBox[{"1", "+", 
             RowBox[{"4", " ", "x", " ", 
              RowBox[{"C", "[", "3", "]"}]}]}], 
            SqrtBox[
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"8", " ", 
               RowBox[{"C", "[", "1", "]"}], " ", 
               RowBox[{"C", "[", "3", "]"}]}], "+", 
              RowBox[{"32", " ", 
               RowBox[{"C", "[", "2", "]"}], " ", 
               SuperscriptBox[
                RowBox[{"C", "[", "3", "]"}], "2"]}]}]]], "]"}], " ", 
          RowBox[{"C", "[", "3", "]"}]}], 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"8", " ", 
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"C", "[", "3", "]"}]}], "+", 
           RowBox[{"32", " ", 
            RowBox[{"C", "[", "2", "]"}], " ", 
            SuperscriptBox[
             RowBox[{"C", "[", "3", "]"}], "2"]}]}]]], "+", 
        RowBox[{"C", "[", "4", "]"}]}]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{556, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.2",
 CellLabel->"Out[2]=",
 CellID->1727267998]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"system", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellTags->"b:1.2.2",
 CellLabel->"In[3]:=",
 CellID->11069],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}], 
  "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.2",
 CellLabel->"Out[3]=",
 CellID->662579502]
}, Open  ]],

Cell[TextData[{
 "This system of two nonlinear ODEs is ",
 StyleBox["autonomous",
  FontSlant->"Italic"],
 ", in the sense that the right-hand sides of the equations do not depend on \
",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:1.2.2",
 CellID->3529],

Cell[BoxData[
 RowBox[{
  RowBox[{"system", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"u", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"v", "[", "x", "]"}], "]"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"v", "'"}], "[", "x", "]"}], " ", "\[Equal]", 
      RowBox[{"u", "[", "x", "]"}]}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:1.2.2",
 CellLabel->"In[4]:=",
 CellID->31552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{"system", ",", " ", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", "x"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellTags->"b:1.2.2",
 CellLabel->"In[5]:=",
 CellID->32074],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{527, 416},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.2",
 CellLabel->"Out[5]=",
 CellID->189232363]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"system", "/.", "sol"}], "//", "Simplify"}], "//", 
   "PowerExpand"}], "//", "Simplify"}]], "Input",
 CellTags->"b:1.2.2",
 CellLabel->"In[6]:=",
 CellID->3730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.2",
 CellLabel->"Out[6]=",
 CellID->760239807]
}, Open  ]],

Cell[TextData[{
 "The previous two examples demonstrate that the solutions to fairly simple \
systems are usually complicated expressions of the independent variable. In \
fact, the solution is often available only in implicit form and may thus \
contain ",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " objects or unevaluated ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " objects."
}], "Text",
 CellTags->"b:1.2.2",
 CellID->10844],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->813756073],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Nonlinear Systems of ODEs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveSystemsOfLinearODEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveLieSymmetryMethods"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 56.2044660}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Following are two examples of nonlinear systems of ODEs that can be \
solved symbolically using DSolve. The first three equations in this system of \
four nonlinear ODEs can be solved independently because none of their \
right-hand sides depend on p, q, r, or s. This system of two nonlinear ODEs \
is autonomous, in the sense that the right-hand sides of the equations do not \
depend on x.", "synonyms" -> {}, "title" -> "Nonlinear Systems of ODEs", 
    "type" -> "Tutorial", "uri" -> "tutorial/DSolveSystemsOfNonlinearODEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:34"->{
  Cell[1280, 43, 90, 2, 70, "Title",
   CellTags->{"c:34", "b:1.2.2"},
   CellID->25385]},
 "b:1.2.2"->{
  Cell[1280, 43, 90, 2, 70, "Title",
   CellTags->{"c:34", "b:1.2.2"},
   CellID->25385],
  Cell[1373, 47, 287, 10, 70, "Text",
   CellTags->"b:1.2.2",
   CellID->20073],
  Cell[1663, 59, 505, 17, 70, "MathCaption",
   CellTags->"b:1.2.2",
   CellID->27504],
  Cell[2171, 78, 856, 28, 70, "Input",
   CellTags->"b:1.2.2",
   CellID->9462],
  Cell[3052, 110, 320, 11, 28, "Input",
   CellTags->"b:1.2.2",
   CellID->32703],
  Cell[3375, 123, 2083, 62, 113, "Output",
   CellTags->"b:1.2.2",
   CellID->1727267998],
  Cell[5495, 190, 149, 5, 28, "Input",
   CellTags->"b:1.2.2",
   CellID->11069],
  Cell[5647, 197, 285, 10, 36, "Output",
   CellTags->"b:1.2.2",
   CellID->662579502],
  Cell[5947, 210, 312, 11, 70, "MathCaption",
   CellTags->"b:1.2.2",
   CellID->3529],
  Cell[6262, 223, 497, 17, 70, "Input",
   CellTags->"b:1.2.2",
   CellID->31552],
  Cell[6784, 244, 296, 10, 28, "Input",
   CellTags->"b:1.2.2",
   CellID->32074],
  Cell[7083, 256, 6554, 112, 437, "Output",
   Evaluatable->False,
   CellTags->"b:1.2.2",
   CellID->189232363],
  Cell[13674, 373, 220, 8, 70, "Input",
   CellTags->"b:1.2.2",
   CellID->3730],
  Cell[13897, 383, 231, 8, 36, "Output",
   CellTags->"b:1.2.2",
   CellID->760239807],
  Cell[14143, 394, 595, 17, 70, "Text",
   CellTags->"b:1.2.2",
   CellID->10844]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:34", 17461, 479},
 {"b:1.2.2", 17566, 483}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 90, 2, 70, "Title",
 CellTags->{"c:34", "b:1.2.2"},
 CellID->25385],
Cell[1373, 47, 287, 10, 70, "Text",
 CellTags->"b:1.2.2",
 CellID->20073],
Cell[1663, 59, 505, 17, 70, "MathCaption",
 CellTags->"b:1.2.2",
 CellID->27504],
Cell[2171, 78, 856, 28, 70, "Input",
 CellTags->"b:1.2.2",
 CellID->9462],
Cell[CellGroupData[{
Cell[3052, 110, 320, 11, 28, "Input",
 CellTags->"b:1.2.2",
 CellID->32703],
Cell[3375, 123, 2083, 62, 113, "Output",
 CellTags->"b:1.2.2",
 CellID->1727267998]
}, Open  ]],
Cell[CellGroupData[{
Cell[5495, 190, 149, 5, 28, "Input",
 CellTags->"b:1.2.2",
 CellID->11069],
Cell[5647, 197, 285, 10, 36, "Output",
 CellTags->"b:1.2.2",
 CellID->662579502]
}, Open  ]],
Cell[5947, 210, 312, 11, 70, "MathCaption",
 CellTags->"b:1.2.2",
 CellID->3529],
Cell[6262, 223, 497, 17, 70, "Input",
 CellTags->"b:1.2.2",
 CellID->31552],
Cell[CellGroupData[{
Cell[6784, 244, 296, 10, 28, "Input",
 CellTags->"b:1.2.2",
 CellID->32074],
Cell[7083, 256, 6554, 112, 437, "Output",
 Evaluatable->False,
 CellTags->"b:1.2.2",
 CellID->189232363]
}, Open  ]],
Cell[CellGroupData[{
Cell[13674, 373, 220, 8, 70, "Input",
 CellTags->"b:1.2.2",
 CellID->3730],
Cell[13897, 383, 231, 8, 36, "Output",
 CellTags->"b:1.2.2",
 CellID->760239807]
}, Open  ]],
Cell[14143, 394, 595, 17, 70, "Text",
 CellTags->"b:1.2.2",
 CellID->10844],
Cell[CellGroupData[{
Cell[14763, 415, 72, 1, 70, "RelatedTutorialsSection",
 CellID->813756073],
Cell[14838, 418, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[15042, 425, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

