(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42196,       1452]
NotebookOptionsPosition[     33823,       1174]
NotebookOutlinePosition[     36395,       1237]
CellTagsIndexPosition[     36301,       1231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AbsoluteTime" :> 
         Documentation`HelpLookup["paclet:ref/AbsoluteTime"], 
         "AbsoluteTiming" :> 
         Documentation`HelpLookup["paclet:ref/AbsoluteTiming"], "DateList" :> 
         Documentation`HelpLookup["paclet:ref/DateList"], "DatePattern" :> 
         Documentation`HelpLookup["paclet:ref/DatePattern"], "DateString" :> 
         Documentation`HelpLookup["paclet:ref/DateString"], "Pause" :> 
         Documentation`HelpLookup["paclet:ref/Pause"], "SessionTime" :> 
         Documentation`HelpLookup["paclet:ref/SessionTime"], 
         "TimeConstrained" :> 
         Documentation`HelpLookup["paclet:ref/TimeConstrained"], "TimeUsed" :> 
         Documentation`HelpLookup["paclet:ref/TimeUsed"], "TimeZone" :> 
         Documentation`HelpLookup["paclet:ref/TimeZone"], "Timing" :> 
         Documentation`HelpLookup["paclet:ref/Timing"], "$TimeUnit" :> 
         Documentation`HelpLookup["paclet:ref/$TimeUnit"], "$TimeZone" :> 
         Documentation`HelpLookup["paclet:ref/$TimeZone"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"AbsoluteTime\"\>", 
      2->"\<\"AbsoluteTiming\"\>", 3->"\<\"DateList\"\>", 
      4->"\<\"DatePattern\"\>", 5->"\<\"DateString\"\>", 6->"\<\"Pause\"\>", 
      7->"\<\"SessionTime\"\>", 8->"\<\"TimeConstrained\"\>", 
      9->"\<\"TimeUsed\"\>", 10->"\<\"TimeZone\"\>", 11->"\<\"Timing\"\>", 
      12->"\<\"$TimeUnit\"\>", 13->"\<\"$TimeZone\"\>"}, "\<\"functions\"\>", 
      
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Date and Time Functions", "Title",
 CellTags->{"S2.14.3", "3.1"},
 CellID->28650],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DateList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DateList"], "[", "]"}], Cell[TextData[{
     "give the current local date and time in the form ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["year", "TI"], ",", 
       StyleBox["month", "TI"], ",", 
       StyleBox["day", "TI"], ",", 
       StyleBox["hour", "TI"], ",", 
       StyleBox["minute", "TI"], ",", 
       StyleBox["second", "TI"], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DateList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DateList"], "[", 
     RowBox[{
      ButtonBox["TimeZone",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TimeZone"], "->", 
      StyleBox["z", "TI"]}], "]"}], Cell[TextData[{
     "give the current date and time in time zone ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["$TimeZone",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$TimeZone"], Cell[
    "give the time zone assumed by your computer system", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2598],

Cell["Finding the date and time. ", "Caption",
 CellID->3309],

Cell["This gives the current date and time. ", "MathCaption",
 CellID->4693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->4686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2005", ",", "3", ",", "31", ",", "19", ",", "21", ",", 
   "29.566769`8.223378849498314"}], "}"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->30080]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " function returns whatever your computer system gives as the current date \
and time. It assumes that any corrections for daylight saving time and so on \
have already been done by your computer system. In addition, it assumes that \
your computer system has been set for the appropriate time zone. "
}], "Text",
 CellID->10116],

Cell[TextData[{
 "The variable ",
 Cell[BoxData[
  ButtonBox["$TimeZone",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeZone"]], "InlineFormula"],
 " returns the current time zone assumed by your computer system. The time \
zone is given as the number of hours which must be added to Greenwich mean \
time (GMT) to obtain the correct local time. Thus, for example, U.S. eastern \
standard time (EST) corresponds to time zone ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "5"}], TraditionalForm]], "InlineMath"],
 ". Note that daylight saving time corrections must be included in the time \
zone, so U.S. eastern daylight time (EDT) corresponds to time zone ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "4"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->12249],

Cell["\<\
This gives the current time zone assumed by your computer system. \
\>", "MathCaption",
 CellID->26667],

Cell[CellGroupData[{

Cell[BoxData["$TimeZone"], "Input",
 CellLabel->"In[2]:= ",
 CellID->1528],

Cell[BoxData[
 RowBox[{"-", "6.`"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->26679]
}, Open  ]],

Cell["\<\
This gives the current date and time in time zone +9, the time zone for \
Japan. \
\>", "MathCaption",
 CellID->7864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"TimeZone", "->", "9"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->29421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2005", ",", "4", ",", "1", ",", "10", ",", "21", ",", 
   "29.579505`8.22356588324475"}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->8405]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AbsoluteTime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsoluteTime"], "[", "]"}], Cell["\<\
total number of seconds since the beginning of January 1, 1900\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["SessionTime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SessionTime"], "[", "]"}], Cell[TextData[{
     "total number of seconds elapsed since the beginning of your current ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TimeUsed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TimeUsed"], "[", "]"}], Cell[TextData[{
     "total number of seconds of CPU time used in your current ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session"
    }], "TableText"]},
   {
    ButtonBox["$TimeUnit",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$TimeUnit"], Cell[
    "the minimum time interval recorded on your computer system", 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8826],

Cell["Time functions. ", "Caption",
 CellID->6816],

Cell[TextData[{
 "You should realize that on any computer system, there is a certain \
\[OpenCurlyDoubleQuote]granularity\[CloseCurlyDoubleQuote] in the times that \
can be measured. This granularity is given as the value of the global \
variable ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 ". Typically it is either about ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "100"], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "1000"], TraditionalForm]], "InlineMath"],
 " of a second. "
}], "Text",
 CellID->7516],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Pause",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pause"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "pause for at least ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " seconds"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27726],

Cell["Pausing during a calculation. ", "Caption",
 CellID->28666],

Cell["This gives various time functions. ", "MathCaption",
 CellID->29087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AbsoluteTime", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{"TimeUsed", "[", "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->27681],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.321285689607146`16.273881223410402*^9", ",", 
   "6.125768`7.238705538328957", ",", "2.2399999999999998`"}], 
  "}"}]], "Output",
 ImageSize->{275, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->19964]
}, Open  ]],

Cell[TextData[{
 "This pauses for 10 seconds, then re-evaluates the time functions. Note that \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TimeUsed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeUsed"], "[", "]"}]], "InlineFormula"],
 " is not affected by the pause. "
}], "MathCaption",
 CellID->1340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pause", "[", "10", "]"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"AbsoluteTime", "[", "]"}], ",", 
    RowBox[{"SessionTime", "[", "]"}], ",", 
    RowBox[{"TimeUsed", "[", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->5686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.321285699616089`16.273881224719183*^9", ",", 
   "16.134709`7.659306130522296", ",", "2.2399999999999998`"}], 
  "}"}]], "Output",
 ImageSize->{282, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->6021]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AbsoluteTime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsoluteTime"], "[", 
     StyleBox["date", "TI"], "]"}], Cell[
    "convert from date to absolute time", "TableText"]},
   {
    RowBox[{
     ButtonBox["DateList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DateList"], "[", 
     StyleBox["time", "TI"], "]"}], Cell[
    "convert from absolute time to date", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11662],

Cell["Converting between dates and absolute times. ", "Caption",
 CellID->14721],

Cell[TextData[{
 "This sets ",
 Cell[BoxData["d"], "InlineFormula"],
 " to be the current date. "
}], "MathCaption",
 CellID->6064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"DateList", "[", "]"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->29309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2005", ",", "3", ",", "31", ",", "19", ",", "21", ",", 
   "39.625914`8.350554271176247"}], "}"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->20415]
}, Open  ]],

Cell["This adds one month to the current date. ", "MathCaption",
 CellID->17902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DateList", "[", "]"}], "+", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], 
   "}"}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->29873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2005", ",", "4", ",", "31", ",", "19", ",", "21", ",", 
   "39.629234`8.35059065638824"}], "}"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->17124]
}, Open  ]],

Cell["This gives the number of seconds in the additional month. ", \
"MathCaption",
 CellID->23941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AbsoluteTime", "[", "%", "]"}], "-", 
  RowBox[{"AbsoluteTime", "[", "d", "]"}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->32745],

Cell[BoxData["2.67840000332`12.879420419710103*^6"], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->31762]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DateList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DateList"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], Cell[
    "convert a date string to a date list", "TableText"]},
   {
    RowBox[{
     ButtonBox["DateList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DateList"], "[", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], "]"}], Cell[
    TextData[{
     "give the date list obtained by extracting elements ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     " from ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->723938156],

Cell["Converting from different date formats.", "Caption",
 CellID->429994093],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " to convert a date string into a date list, as long as the date format is \
sufficiently unambiguous."
}], "Text",
 CellID->723219625],

Cell["This attempts to interpret the string as a date.", "MathCaption",
 CellID->488401269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "\"\<June 23, 1988 - 3:55 pm\>\"", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->182875357],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1988", ",", "6", ",", "23", ",", "15", ",", "55", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->421449440]
}, Open  ]],

Cell[TextData[{
 "For more control of the conversion, you can specify the order and type of \
date elements appearing in the string. The elements can be strings like ",
 Cell[BoxData["\"\<Year\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Quarter\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Month\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<MonthName\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Day\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DayName\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Hour\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<AMPM\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Minute\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData["\"\<Second\>\""], "InlineFormula"],
 "."
}], "Text",
 CellID->26165321],

Cell["This extracts a date using the specified elements.", "MathCaption",
 CellID->294388234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<3/5/2001\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Month\>\"", ",", "\"\<Day\>\"", ",", "\"\<Year\>\""}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->180088275],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2001", ",", "3", ",", "5", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->78987697]
}, Open  ]],

Cell["\<\
If the date element delimiters contain letters or digits, these must also be \
specified as part of the date elements.\
\>", "Text",
 CellID->480416833],

Cell["This extracts a date containing a letter as a separator.", "MathCaption",
 CellID->458545515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Jun Y1988\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MonthName\>\"", ",", "\"\< Y\>\"", ",", "\"\<Year\>\""}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->368732601],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1988", ",", "6", ",", "1", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->9904857]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DateString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DateString"], "[", "]"}], Cell[
    "give a string representing current local date and time", "TableText"]},
   {
    RowBox[{
     ButtonBox["DateString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DateString"], "[", 
     RowBox[{
      StyleBox["datespec", "TI"], ",", " ", 
      StyleBox["elems", "TI"]}], "]"}], Cell[TextData[{
     "give elements ",
     Cell[BoxData[
      StyleBox["elems", "TI"]], "InlineFormula"],
     " of date and time given by ",
     Cell[BoxData[
      StyleBox["datespec", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->327840979],

Cell["Converting to different date formats.", "Caption",
 CellID->296133347],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 " is used to give a nice string representation of a date and time. The exact \
output format can be specified from a long list of date elements, such as ",
 Cell[BoxData["\"\<DateTime\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DayName\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<HourShort\>\""], "InlineFormula"],
 ", etc."
}], "Text",
 CellID->309525349],

Cell["This gives the current date and time in the default format.", \
"MathCaption",
 CellID->952012251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->38853904],

Cell[BoxData["\<\"Fri 15 Dec 2006 13:27:47\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->31501465]
}, Open  ]],

Cell["This specifies a format for the given date.", "MathCaption",
 CellID->153629779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1988", ",", "6", ",", "23", ",", "15", ",", "55", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<MonthName\>\"", ",", "\"\< \>\"", ",", "\"\<DayShort\>\"", ",", 
     "\"\<, \>\"", ",", "\"\<Year\>\"", ",", "\"\< - \>\"", ",", 
     "\"\<Hour12Short\>\"", ",", "\"\<:\>\"", ",", "\"\<Minute\>\"", ",", 
     "\"\< \>\"", ",", "\"\<AMPMLowerCase\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->28243291],

Cell[BoxData["\<\"June 23, 1988 - 3:55 pm\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->256112589]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DatePattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DatePattern"], "[", 
     StyleBox["elems", "TI"], "]"}], Cell[
    "string pattern matching a date with the given elements", "TableText"]}
  }]], "DefinitionBox",
 CellID->39213745],

Cell["Extracting dates from a string.", "Caption",
 CellID->99497160],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DatePattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DatePattern"], "[", 
   StyleBox["elems", "TI"], "]"}]], "InlineFormula"],
 " as a string pattern in string matching functions. The date elements are \
the same as used in ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 ", although the default date element delimiters are restricted to the",
 " ",
 Cell[BoxData["/"], "InlineFormula"],
 ", ",
 Cell[BoxData["-"], "InlineFormula"],
 ", ",
 Cell[BoxData[":"], "InlineFormula"],
 " or ",
 Cell[BoxData["."], "InlineFormula"],
 " characters. Other delimiters can be given explicitly in the list of date \
elements."
}], "Text",
 CellID->474346171],

Cell["This extracts dates of the given format from a string.", "MathCaption",
 CellID->628414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abc 12/5/2005 def 1/15/2002 ghi\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"DatePattern", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<Month\>\"", ",", "\"\<Day\>\"", ",", "\"\<Year\>\""}], 
       "}"}], "]"}]}], "\[RuleDelayed]", 
    RowBox[{"DateList", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->169311784],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2005", ",", "12", ",", "5", ",", "0", ",", "0", ",", "0.`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2002", ",", "1", ",", "15", ",", "0", ",", "0", ",", "0.`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->54275786]
}, Open  ]],

Cell["This extracts dates with explicit delimiters.", "MathCaption",
 CellID->248622215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abc Mar 2002 def Aug 2005 ghi\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"DatePattern", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<MonthName\>\"", ",", "\"\< \>\"", ",", "\"\<Year\>\""}], 
       "}"}], "]"}]}], "\[RuleDelayed]", 
    RowBox[{"DateList", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->120283111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2002", ",", "3", ",", "1", ",", "0", ",", "0", ",", "0.`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2005", ",", "8", ",", "1", ",", "0", ",", "0", ",", "0.`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->12249345]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Timing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Timing"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and return a list of the CPU time needed, together with the result \
obtained"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AbsoluteTiming",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsoluteTiming"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", giving the absolute time taken"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28423],

Cell[TextData[{
 "Timing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " operations. "
}], "Caption",
 CellID->27531],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 " allows you to measure the CPU time associated with the evaluation of a \
single ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. ",
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 " corresponds to the increase in ",
 Cell[BoxData[
  ButtonBox["TimeUsed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeUsed"]], "InlineFormula"],
 ". Note that only CPU time associated with the actual evaluation of the \
expression within the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is included. The time needed to format the expression for output, \
and any time associated with external programs, is not included. "
}], "Text",
 CellID->4806],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteTiming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTiming"]], "InlineFormula"],
 " allows you to measure absolute total elapsed time. You should realize, \
however, that the time reported for a particular calculation by both ",
 Cell[BoxData[
  ButtonBox["AbsoluteTiming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTiming"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 " depends on many factors. "
}], "Text",
 CellID->12268],

Cell[TextData[{
 "First, the time depends in detail on the computer system you are using. It \
depends not only on instruction times, but also on memory caching, as well as \
on the details of the optimization done in compiling the parts of the \
internal code of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " used in the calculation. "
}], "Text",
 CellID->9318],

Cell[TextData[{
 "The time also depends on the precise state of your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session when the calculation was done. Many of the internal optimizations \
used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " depend on details of preceding calculations. For example, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " often uses previous results it has obtained, and avoids unnecessarily \
reevaluating expressions. In addition, some ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions build internal tables when they are first called in a particular \
way, so that if they are called in that way again, they run much faster. For \
all of these kinds of reasons, it is often the case that a particular \
calculation may not take the same amount of time if you run it at different \
points in the same ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Text",
 CellID->5602],

Cell[TextData[{
 "This gives the CPU time needed for the calculation. The semicolon causes \
the result of the calculation to be given as ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"100000", "!"}], ";"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->24307],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.49`", " ", "Second"}], ",", "Null"}], "}"}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->23481]
}, Open  ]],

Cell[TextData[{
 "Now ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has built internal tables for factorial functions, and the calculation \
takes no measurable CPU time. "
}], "MathCaption",
 CellID->1012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"100000", "!"}], ";"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->21136],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", " ", "Second"}], ",", "Null"}], "}"}]], "Output",
 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->26630]
}, Open  ]],

Cell["However, some absolute time does elapse. ", "MathCaption",
 CellID->24114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"100000", "!"}], ";"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->26809],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.000102`2.460145165257889", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->4084]
}, Open  ]],

Cell[TextData[{
 "Note that the results you get from ",
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 " are only accurate to the timing granularity ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 " of your computer system. Thus, for example, a timing reported as ",
 Cell[BoxData["0"], "InlineFormula"],
 " could in fact be as much as ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->23556],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["TimeConstrained",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TimeConstrained"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "try to evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", aborting the calculation after ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " seconds"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TimeConstrained",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TimeConstrained"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["failexpr", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "return ",
     Cell[BoxData[
      StyleBox["failexpr", "TI"]], "InlineFormula"],
     " if the time constraint is not met"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12290],

Cell["Time\[Hyphen]constrained calculation. ", "Caption",
 CellID->21293],

Cell[TextData[{
 "When you use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interactively, it is quite common to try doing a calculation, but to abort \
the calculation if it seems to be taking too long. You can emulate this \
behavior inside a program by using ",
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " tries to evaluate a particular expression for a specified amount of time. \
If it does not succeed, then it aborts the evaluation, and returns either ",
 Cell[BoxData[
  ButtonBox["$Aborted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Aborted"]], "InlineFormula"],
 ", or an expression you specify. "
}], "Text",
 CellID->29996],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 ", for example, to have ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " try a particular approach to a problem for a certain amount of time, and \
then to switch to another approach if the first one has not yet succeeded. \
You should realize however that ",
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " may overrun the time you specify if ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot be interrupted during a particular part of a calculation. In \
addition, you should realize that because different computer systems run at \
different speeds, programs that use ",
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " will often give different results on different systems."
}], "Text",
 CellID->29152]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Date and Time Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 51.8903196}", "context" -> "", 
    "keywords" -> {
     "AbsoluteTime", "AbsoluteTiming", "alarm", "batch mode", "clicks", 
      "clock", "calendar conversion", "CPU time", "date", "DateList", 
      "DatePattern", "dates", "DateString", "Day", "daylight saving time", 
      "elapsed time", "evaluation time", "execution time", "FromDate", "GMT", 
      "granularity", "Greenwich mean time", "hour", "minute", "month", 
      "pause", "performance analysis", "profiling", "quantization", 
      "resource constraints", "runtime", "second", "SessionTime", "sleep", 
      "time", "TimeConstrained", "time differences", "TimeUsed", "TimeZone", 
      "timing", "ToDate", "wait", "wall clock time", "year", "TimeUnit"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Finding the date and time. This gives the current date and time. The \
Mathematica DateList function returns whatever your computer system gives as \
the current date and time. It assumes that any corrections for daylight \
saving time and so on have already been done by your computer system. In \
addition, it assumes that your computer system has been set for the \
appropriate time zone. ", "synonyms" -> {"2.14.3"}, "title" -> 
    "Date and Time Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/DateAndTimeFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.14.3"->{
  Cell[2462, 61, 87, 2, 70, "Title",
   CellTags->{"S2.14.3", "3.1"},
   CellID->28650]},
 "3.1"->{
  Cell[2462, 61, 87, 2, 70, "Title",
   CellTags->{"S2.14.3", "3.1"},
   CellID->28650]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.14.3", 36088, 1220},
 {"3.1", 36188, 1224}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1837, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2462, 61, 87, 2, 70, "Title",
 CellTags->{"S2.14.3", "3.1"},
 CellID->28650],
Cell[2552, 65, 1465, 43, 70, "DefinitionBox",
 CellID->2598],
Cell[4020, 110, 61, 1, 70, "Caption",
 CellID->3309],
Cell[4084, 113, 76, 1, 70, "MathCaption",
 CellID->4693],
Cell[CellGroupData[{
Cell[4185, 118, 95, 3, 28, "Input",
 CellID->4686],
Cell[4283, 123, 280, 9, 36, "Output",
 CellID->30080]
}, Open  ]],
Cell[4578, 135, 529, 14, 70, "Text",
 CellID->10116],
Cell[5110, 151, 783, 20, 70, "Text",
 CellID->12249],
Cell[5896, 173, 113, 3, 70, "MathCaption",
 CellID->26667],
Cell[CellGroupData[{
Cell[6034, 180, 74, 2, 28, "Input",
 CellID->1528],
Cell[6111, 184, 174, 6, 36, "Output",
 CellID->26679]
}, Open  ]],
Cell[6300, 193, 127, 4, 70, "MathCaption",
 CellID->7864],
Cell[CellGroupData[{
Cell[6452, 201, 132, 4, 70, "Input",
 CellID->29421],
Cell[6587, 207, 277, 9, 36, "Output",
 CellID->8405]
}, Open  ]],
Cell[6879, 219, 1400, 42, 70, "DefinitionBox",
 CellID->8826],
Cell[8282, 263, 50, 1, 70, "Caption",
 CellID->6816],
Cell[8335, 266, 637, 19, 70, "Text",
 CellID->7516],
Cell[8975, 287, 633, 20, 70, "DefinitionBox",
 CellID->27726],
Cell[9611, 309, 65, 1, 70, "Caption",
 CellID->28666],
Cell[9679, 312, 74, 1, 70, "MathCaption",
 CellID->29087],
Cell[CellGroupData[{
Cell[9778, 317, 222, 7, 70, "Input",
 CellID->27681],
Cell[10003, 326, 302, 10, 39, "Output",
 CellID->19964]
}, Open  ]],
Cell[10320, 339, 312, 10, 70, "MathCaption",
 CellID->1340],
Cell[CellGroupData[{
Cell[10657, 353, 281, 9, 70, "Input",
 CellID->5686],
Cell[10941, 364, 302, 10, 39, "Output",
 CellID->6021]
}, Open  ]],
Cell[11258, 377, 777, 23, 70, "DefinitionBox",
 CellID->11662],
Cell[12038, 402, 80, 1, 70, "Caption",
 CellID->14721],
Cell[12121, 405, 131, 5, 70, "MathCaption",
 CellID->6064],
Cell[CellGroupData[{
Cell[12277, 414, 119, 4, 70, "Input",
 CellID->29309],
Cell[12399, 420, 280, 9, 36, "Output",
 CellID->20415]
}, Open  ]],
Cell[12694, 432, 80, 1, 70, "MathCaption",
 CellID->17902],
Cell[CellGroupData[{
Cell[12799, 437, 210, 7, 70, "Input",
 CellID->29873],
Cell[13012, 446, 279, 9, 36, "Output",
 CellID->17124]
}, Open  ]],
Cell[13306, 458, 99, 2, 70, "MathCaption",
 CellID->23941],
Cell[CellGroupData[{
Cell[13430, 464, 167, 5, 70, "Input",
 CellID->32745],
Cell[13600, 471, 190, 5, 36, "Output",
 CellID->31762]
}, Open  ]],
Cell[13805, 479, 1115, 33, 70, "DefinitionBox",
 CellID->723938156],
Cell[14923, 514, 78, 1, 70, "Caption",
 CellID->429994093],
Cell[15004, 517, 363, 11, 70, "Text",
 CellID->723219625],
Cell[15370, 530, 91, 1, 70, "MathCaption",
 CellID->488401269],
Cell[CellGroupData[{
Cell[15486, 535, 134, 3, 70, "Input",
 CellID->182875357],
Cell[15623, 540, 255, 8, 36, "Output",
 CellID->421449440]
}, Open  ]],
Cell[15893, 551, 775, 24, 70, "Text",
 CellID->26165321],
Cell[16671, 577, 93, 1, 70, "MathCaption",
 CellID->294388234],
Cell[CellGroupData[{
Cell[16789, 582, 267, 8, 70, "Input",
 CellID->180088275],
Cell[17059, 592, 250, 8, 36, "Output",
 CellID->78987697]
}, Open  ]],
Cell[17324, 603, 162, 4, 70, "Text",
 CellID->480416833],
Cell[17489, 609, 99, 1, 70, "MathCaption",
 CellID->458545515],
Cell[CellGroupData[{
Cell[17613, 614, 270, 8, 70, "Input",
 CellID->368732601],
Cell[17886, 624, 248, 8, 36, "Output",
 CellID->9904857]
}, Open  ]],
Cell[18149, 635, 735, 23, 70, "DefinitionBox",
 CellID->327840979],
Cell[18887, 660, 76, 1, 70, "Caption",
 CellID->296133347],
Cell[18966, 663, 510, 14, 70, "Text",
 CellID->309525349],
Cell[19479, 679, 104, 2, 70, "MathCaption",
 CellID->952012251],
Cell[CellGroupData[{
Cell[19608, 685, 100, 3, 70, "Input",
 CellID->38853904],
Cell[19711, 690, 189, 5, 36, "Output",
 CellID->31501465]
}, Open  ]],
Cell[19915, 698, 86, 1, 70, "MathCaption",
 CellID->153629779],
Cell[CellGroupData[{
Cell[20026, 703, 527, 13, 70, "Input",
 CellID->28243291],
Cell[20556, 718, 190, 5, 36, "Output",
 CellID->256112589]
}, Open  ]],
Cell[20761, 726, 308, 9, 70, "DefinitionBox",
 CellID->39213745],
Cell[21072, 737, 69, 1, 70, "Caption",
 CellID->99497160],
Cell[21144, 740, 806, 26, 70, "Text",
 CellID->474346171],
Cell[21953, 768, 94, 1, 70, "MathCaption",
 CellID->628414],
Cell[CellGroupData[{
Cell[22072, 773, 415, 11, 70, "Input",
 CellID->169311784],
Cell[22490, 786, 404, 13, 36, "Output",
 CellID->54275786]
}, Open  ]],
Cell[22909, 802, 88, 1, 70, "MathCaption",
 CellID->248622215],
Cell[CellGroupData[{
Cell[23022, 807, 415, 11, 70, "Input",
 CellID->120283111],
Cell[23440, 820, 402, 13, 36, "Output",
 CellID->12249345]
}, Open  ]],
Cell[23857, 836, 1028, 32, 70, "DefinitionBox",
 CellID->28423],
Cell[24888, 870, 124, 6, 70, "Caption",
 CellID->27531],
Cell[25015, 878, 875, 26, 70, "Text",
 CellID->4806],
Cell[25893, 906, 608, 18, 70, "Text",
 CellID->12268],
Cell[26504, 926, 372, 9, 70, "Text",
 CellID->9318],
Cell[26879, 937, 964, 24, 70, "Text",
 CellID->5602],
Cell[27846, 963, 292, 9, 70, "MathCaption",
 CellID->31907],
Cell[CellGroupData[{
Cell[28163, 976, 141, 5, 70, "Input",
 CellID->24307],
Cell[28307, 983, 237, 8, 36, "Output",
 CellID->23481]
}, Open  ]],
Cell[28559, 994, 215, 7, 70, "MathCaption",
 CellID->1012],
Cell[CellGroupData[{
Cell[28799, 1005, 142, 5, 70, "Input",
 CellID->21136],
Cell[28944, 1012, 236, 8, 36, "Output",
 CellID->26630]
}, Open  ]],
Cell[29195, 1023, 80, 1, 70, "MathCaption",
 CellID->24114],
Cell[CellGroupData[{
Cell[29300, 1028, 150, 5, 70, "Input",
 CellID->26809],
Cell[29453, 1035, 261, 9, 36, "Output",
 CellID->4084]
}, Open  ]],
Cell[29729, 1047, 639, 20, 70, "Text",
 CellID->23556],
Cell[30371, 1069, 1375, 41, 70, "DefinitionBox",
 CellID->12290],
Cell[31749, 1112, 73, 1, 70, "Caption",
 CellID->21293],
Cell[31825, 1115, 886, 24, 70, "Text",
 CellID->29996],
Cell[32714, 1141, 1067, 28, 70, "Text",
 CellID->29152]
}, Open  ]],
Cell[33796, 1172, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

