(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17448,        620]
NotebookOptionsPosition[     12200,        462]
NotebookOutlinePosition[     15244,        537]
CellTagsIndexPosition[     15153,        531]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Building Up Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BuildingUpCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Building Up Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Clear" :> Documentation`HelpLookup["paclet:ref/Clear"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Clear\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Defining Variables", "Title",
 CellTags->{"S1.2.2", "2.1"},
 CellID->7572],

Cell[TextData[{
 "When you do long calculations, it is often convenient to give ",
 StyleBox["names",
  FontSlant->"Italic"],
 " to your intermediate results. Just as in standard mathematics, or in other \
computer languages, you can do this by introducing named ",
 StyleBox["variables",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->6249],

Cell[TextData[{
 "This sets the value of the ",
 StyleBox["variable",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData["x"], "InlineFormula"],
 " to be ",
 Cell[BoxData["5"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "5"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29174],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138769199]
}, Open  ]],

Cell[TextData[{
 "Whenever ",
 Cell[BoxData["x"], "InlineFormula"],
 " appears, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " now replaces it with the value ",
 Cell[BoxData["5"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "^", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32611],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->254240000]
}, Open  ]],

Cell[TextData[{
 "This assigns a new value to ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"7", "+", "4"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8419],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->146111868]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["pi"], "InlineFormula"],
 " is set to be the numerical value of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 " to 40\[Hyphen]digit accuracy. "
}], "MathCaption",
 CellID->3805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pi", "=", 
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "40"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7585],

Cell[BoxData["3.1415926535897932384626433832795028841971676788548462879281`40.\
"], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->225244625]
}, Open  ]],

Cell[TextData[{
 "Here is the value you defined for ",
 Cell[BoxData["pi"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31450],

Cell[CellGroupData[{

Cell[BoxData["pi"], "Input",
 CellLabel->"In[5]:=",
 CellID->1615],

Cell[BoxData["3.1415926535897932384626433832795028841971676788548462879281`40.\
"], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->130834936]
}, Open  ]],

Cell[TextData[{
 "This gives the numerical value of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Pi]", "2"], TraditionalForm]], "InlineMath"],
 ", to the same accuracy as ",
 Cell[BoxData["pi"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pi", "^", "2"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->9166],

Cell[BoxData["9.869604401089358618834490999876151135313688596893`39.\
69897000433602"], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->34542023]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "assign a value to the variable ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "=", 
     StyleBox["y", "TI"], "=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "assign a value to both ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "=.", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Clear",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Clear"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "remove any value assigned to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16074],

Cell["Assigning values to variables. ", "Caption",
 CellID->13509],

Cell[TextData[{
 "It is very important to realize that values you assign to variables are ",
 StyleBox["permanent",
  FontSlant->"Italic"],
 ". Once you have assigned a value to a particular variable, the value will \
be kept until you explicitly remove it. The value will, of course, disappear \
if you start a whole new ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Text",
 CellID->30300],

Cell[TextData[{
 "Forgetting about definitions you made earlier is the single most common \
cause of mistakes when using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you set ",
 Cell[BoxData[
  RowBox[{"x", "=", "5"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that you ",
 StyleBox["always",
  FontSlant->"Italic"],
 " want ",
 Cell[BoxData["x"], "InlineFormula"],
 " to have the value ",
 Cell[BoxData["5"], "InlineFormula"],
 ", until or unless you explicitly tell it otherwise. To avoid mistakes, you \
should remove values you have defined as soon as you have finished using \
them. "
}], "Text",
 CellID->19695],

Cell[BoxData[GridBox[{
   {Cell["\<\
\[FilledSmallSquare] Remove values you assign to variables as soon as you \
finish using them.\
\>", "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9573],

Cell[TextData[{
 "A useful principle in using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->15589],

Cell[TextData[{
 "The variables you define can have almost any names. There is no limit on \
the length of their names. One constraint, however, is that variable names \
can never ",
 StyleBox["start",
  FontSlant->"Italic"],
 " with numbers. For example, ",
 Cell[BoxData["x2"], "InlineFormula"],
 " could be a variable, but ",
 Cell[BoxData[
  RowBox[{"2", "x"}]], "InlineFormula"],
 " means ",
 Cell[BoxData[
  RowBox[{"2", "*", "x"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->13161],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses both upper\[Hyphen] and lower\[Hyphen]case letters. There is a \
convention that built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects always have names starting with upper\[Hyphen]case (capital) \
letters. To avoid confusion, you should always choose names for your own \
variables that start with lower\[Hyphen]case letters."
}], "Text",
 CellID->31172],

Cell[BoxData[GridBox[{
   {
    StyleBox["aaaaa", "TI"], Cell["\<\
a variable name containing only lower\[Hyphen]case letters\
\>", "TableText"]},
   {
    StyleBox["Aaaaa", "TI"], Cell["\<\
a built\[Hyphen]in object whose name begins with a capital letter\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17968],

Cell["Naming conventions. ", "Caption",
 CellID->27358],

Cell[TextData[{
 "You can type formulas involving variables in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " almost exactly as you would in mathematics. There are a few important \
points to watch, however. "
}], "Text",
 CellID->26031],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      RowBox[{"x", "y"}]], "InlineFormula"],
     " means ",
     Cell[BoxData["x"], "InlineFormula"],
     " times ",
     Cell[BoxData["y"], "InlineFormula"],
     "."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData["xy"], "InlineFormula"],
     " with no space is the variable with name ",
     Cell[BoxData["xy"], "InlineFormula"],
     "."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      RowBox[{"5", "x"}]], "InlineFormula"],
     " means ",
     Cell[BoxData["5"], "InlineFormula"],
     " times ",
     Cell[BoxData["x"], "InlineFormula"],
     "."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      RowBox[{"x", "^", "2", "y"}]], "InlineFormula"],
     " means ",
     Cell[BoxData[
      RowBox[{"(", "x", "^", "2", ")", " ", "y"}]], "InlineFormula"],
     ", not ",
     Cell[BoxData[
      RowBox[{"x", "^", "(", "2", "y", ")"}]], "InlineFormula"],
     "."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26268],

Cell[TextData[{
 "Some points to watch when using variables in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->19426],

Cell[TextData[ButtonBox["Building Up Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/BuildingUpCalculationsOverview"]], "RelatedTutorials",
 CellID->71949343]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Defining Variables - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Building Up Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/BuildingUpCalculationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/UsingPreviousResults"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MakingListsOfObjects"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 54.1872534}", "context" -> "", 
    "keywords" -> {
     "assignments", "builtin functions", "built-in functions", 
      "capital letters", "Case sensitivity", "clear", "defining values", 
      "definitions", "deleting values", "equals sign", "erasing values", 
      "identifiers", "killing", "lowercase letters", "mistakes", "names", 
      "parameters", "removing values", "set", "setting values", "symbols", 
      "Undefining symbols", "unset", "uppercase letters", "variables"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "When you do long calculations, it is often convenient to give names to \
your intermediate results. Just as in standard mathematics, or in other \
computer languages, you can do this by introducing named variables. This sets \
the value of the variable x to be 5. Whenever x appears, Mathematica now \
replaces it with the value 5. ", "synonyms" -> {"1.2.2"}, "title" -> 
    "Defining Variables", "type" -> "Tutorial", "uri" -> 
    "tutorial/DefiningVariables"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.2.2"->{
  Cell[1808, 58, 80, 2, 70, "Title",
   CellTags->{"S1.2.2", "2.1"},
   CellID->7572]},
 "2.1"->{
  Cell[1808, 58, 80, 2, 70, "Title",
   CellTags->{"S1.2.2", "2.1"},
   CellID->7572]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.2.2", 14944, 520},
 {"2.1", 15042, 524}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1183, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1808, 58, 80, 2, 70, "Title",
 CellTags->{"S1.2.2", "2.1"},
 CellID->7572],
Cell[1891, 62, 345, 10, 70, "Text",
 CellID->6249],
Cell[2239, 74, 228, 10, 70, "MathCaption",
 CellID->14640],
Cell[CellGroupData[{
Cell[2492, 88, 88, 3, 28, "Input",
 CellID->29174],
Cell[2583, 93, 158, 5, 36, "Output",
 CellID->138769199]
}, Open  ]],
Cell[2756, 101, 245, 10, 70, "MathCaption",
 CellID->943],
Cell[CellGroupData[{
Cell[3026, 115, 88, 3, 28, "Input",
 CellID->32611],
Cell[3117, 120, 159, 5, 36, "Output",
 CellID->254240000]
}, Open  ]],
Cell[3291, 128, 127, 5, 70, "MathCaption",
 CellID->20289],
Cell[CellGroupData[{
Cell[3443, 137, 110, 4, 28, "Input",
 CellID->8419],
Cell[3556, 143, 159, 5, 36, "Output",
 CellID->146111868]
}, Open  ]],
Cell[3730, 151, 233, 7, 70, "MathCaption",
 CellID->3805],
Cell[CellGroupData[{
Cell[3988, 162, 142, 5, 70, "Input",
 CellID->7585],
Cell[4133, 169, 224, 6, 36, "Output",
 CellID->225244625]
}, Open  ]],
Cell[4372, 178, 134, 5, 70, "MathCaption",
 CellID->31450],
Cell[CellGroupData[{
Cell[4531, 187, 66, 2, 70, "Input",
 CellID->1615],
Cell[4600, 191, 224, 6, 36, "Output",
 CellID->130834936]
}, Open  ]],
Cell[4839, 200, 258, 9, 70, "MathCaption",
 CellID->11064],
Cell[CellGroupData[{
Cell[5122, 213, 88, 3, 70, "Input",
 CellID->9166],
Cell[5213, 218, 227, 6, 36, "Output",
 CellID->34542023]
}, Open  ]],
Cell[5455, 227, 1285, 41, 70, "DefinitionBox",
 CellID->16074],
Cell[6743, 270, 66, 1, 70, "Caption",
 CellID->13509],
Cell[6812, 273, 415, 11, 70, "Text",
 CellID->30300],
Cell[7230, 286, 675, 22, 70, "Text",
 CellID->19695],
Cell[7908, 310, 465, 13, 70, "FramedBox",
 CellID->9573],
Cell[8376, 325, 134, 6, 70, "Caption",
 CellID->15589],
Cell[8513, 333, 490, 16, 70, "Text",
 CellID->13161],
Cell[9006, 351, 454, 11, 70, "Text",
 CellID->31172],
Cell[9463, 364, 590, 17, 70, "DefinitionBox",
 CellID->17968],
Cell[10056, 383, 55, 1, 70, "Caption",
 CellID->27358],
Cell[10114, 386, 245, 7, 70, "Text",
 CellID->26031],
Cell[10362, 395, 1461, 48, 70, "FramedBox",
 CellID->26268],
Cell[11826, 445, 151, 6, 70, "Caption",
 CellID->19426],
Cell[11980, 453, 178, 4, 70, "RelatedTutorials",
 CellID->71949343]
}, Open  ]],
Cell[12173, 460, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

