(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46893,       1709]
NotebookOptionsPosition[     37046,       1374]
NotebookOutlinePosition[     39972,       1448]
CellTagsIndexPosition[     39879,       1442]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> 
          Documentation`HelpLookup["paclet:tutorial/CalculusOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calculus\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integrate" :> Documentation`HelpLookup["paclet:ref/Integrate"],
           "PrincipalValue" :> 
          Documentation`HelpLookup["paclet:ref/PrincipalValue"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Integrate\"\>", 2->"\<\"PrincipalValue\"\>", 
       3->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Definite Integrals", "Title",
 CellTags->{"S3.5.8", "8.1"},
 CellID->28510],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "the indefinite integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Integral]", 
        RowBox[{"f", " ", "d", "\[InvisibleSpace]", "x"}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     "the definite integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         SubscriptBox["x", 
          StyleBox["min",
           FontSlant->"Italic"]], 
         SubscriptBox["x", 
          StyleBox["max",
           FontSlant->"Italic"]]], 
        RowBox[{"f", " ", "d", "\[InvisibleSpace]", "x"}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the multiple integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         SubscriptBox["x", 
          StyleBox["min",
           FontSlant->"Italic"]], 
         SubscriptBox["x", 
          StyleBox["max",
           FontSlant->"Italic"]]], 
        RowBox[{"d", "x", " ", 
         RowBox[{
          SubsuperscriptBox["\[Integral]", 
           SubscriptBox["y", 
            StyleBox["min",
             FontSlant->"Italic"]], 
           SubscriptBox["y", 
            StyleBox["max",
             FontSlant->"Italic"]]], 
          RowBox[{"d", "y", " ", "f"}]}]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10422],

Cell["Integration functions. ", "Caption",
 CellID->30774],

Cell[TextData[{
 "Here is the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "a", "b"], 
    SuperscriptBox["x", "2"], " ", "d", "x"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->8779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30910],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["a", "3"], "3"]}], "+", 
  FractionBox[
   SuperscriptBox["b", "3"], "3"]}]], "Output",
 ImageSize->{58, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1169788549]
}, Open  ]],

Cell[TextData[{
 "This gives the multiple integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "a"], 
    RowBox[{"d", "x", " ", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "b"], 
      RowBox[{"d", "\[InvisibleSpace]", 
       RowBox[{"y", "(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->4182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25391],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", "a", " ", "b", " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], ")"}]}]], "Output",
 ImageSize->{90, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1957016351]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["y"], "InlineFormula"],
 " integral is done first. Its limits can depend on the value of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". This ordering is the same as is used in functions like ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->874],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["a", "4"], "3"]], "Output",
 ImageSize->{21, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->834068943]
}, Open  ]],

Cell["\<\
In simple cases, definite integrals can be done by finding indefinite forms \
and then computing appropriate limits. But there is a vast range of integrals \
for which the indefinite form cannot be expressed in terms of standard \
mathematical functions, but the definite form still can be. \
\>", "Text",
 CellID->14902],

Cell["\<\
This indefinite integral cannot be done in terms of standard mathematical \
functions. \
\>", "MathCaption",
 CellID->28255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4460],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{112, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1183683464]
}, Open  ]],

Cell["\<\
This definite integral, however, can be done in terms of a Bessel function. \
\>", "MathCaption",
 CellID->6972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->26821],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]", " ", 
  RowBox[{"BesselJ", "[", 
   RowBox[{"0", ",", "1"}], "]"}]}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1677925856]
}, Open  ]],

Cell["\<\
Here is an integral where the indefinite form can be found, but it is much \
more efficient to work out the definite form directly. \
\>", "MathCaption",
 CellID->25547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->21577],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"(", 
   RowBox[{"EulerGamma", "+", 
    RowBox[{"Log", "[", "4", "]"}]}], ")"}]}]], "Output",
 ImageSize->{193, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->847027609]
}, Open  ]],

Cell["\<\
Just because an integrand may contain special functions, it does not mean \
that the definite integral will necessarily be complicated. \
\>", "MathCaption",
 CellID->25605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselK", "[", 
     RowBox[{"0", ",", "x"}], "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->30195],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], "4"]], "Output",
 ImageSize->{22, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->207532066]
}, Open  ]],

Cell["Special functions nevertheless occur in this result. ", "MathCaption",
 CellID->7950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselK", "[", 
     RowBox[{"0", ",", "x"}], "]"}], " ", 
    RowBox[{"BesselJ", "[", 
     RowBox[{"0", ",", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->16343],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"Gamma", "[", 
    FractionBox["1", "4"], "]"}], "2"], 
  RowBox[{"4", " ", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]]}]]], "Output",
 ImageSize->{73, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->709485798]
}, Open  ]],

Cell["\<\
The integrand here is simple, but the definite integral is not. \
\>", "MathCaption",
 CellID->2481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", "^", "2"}], "]"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1012],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"HypergeometricPFQ", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["3", "4"], ",", 
         FractionBox["5", "4"]}], "}"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "64"]}]}], "]"}]}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", 
        FractionBox["1", "4"], "]"}], "+", 
       RowBox[{"Sin", "[", 
        FractionBox["1", "4"], "]"}]}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{469, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->2122937575]
}, Open  ]],

Cell["\<\
Even when you can find the indefinite form of an integral, you will often not \
get the correct answer for the definite integral if you just subtract the \
values of the limits at each end point. The problem is that within the domain \
of integration there may be singularities whose effects are ignored if you \
follow this procedure. \
\>", "Text",
 CellID->23439],

Cell[TextData[{
 "Here is the indefinite integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    SuperscriptBox["x", "2"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->13428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->5912],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", "x"]}]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->469707434]
}, Open  ]],

Cell["This subtracts the limits at each end point. ", "MathCaption",
 CellID->5967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{"%", ",", 
    RowBox[{"x", "->", "2"}]}], "]"}], "-", 
  RowBox[{"Limit", "[", 
   RowBox[{"%", ",", 
    RowBox[{"x", "->", 
     RowBox[{"-", "2"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->24408],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->131862005]
}, Open  ]],

Cell[TextData[{
 "The true definite integral is divergent because of the double pole at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->1908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->17223],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], ":", 
  " ", "\<\"Integral of \\!\\(1\\/x\\^2\\) does not converge on \
\\!\\({\\(\\(-2\\)\\), 2}\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", ButtonNote -> \
\\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[12]:=",
 CellID->58289470],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "2"}], "2"], 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["x", "2"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{58, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->539000851]
}, Open  ]],

Cell["\<\
Here is a more subtle example, involving branch cuts rather than poles. \
\>", "MathCaption",
 CellID->26434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"a", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->5204],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"Tan", "[", 
       FractionBox["x", "2"], "]"}]}], 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["a", "2"]}]]], "]"}]}], 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox["a", "2"]}]]]], "Output",
 ImageSize->{122, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->494818438]
}, Open  ]],

Cell["Taking limits in the indefinite integral gives 0. ", "MathCaption",
 CellID->4319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{"%", ",", 
    RowBox[{"x", "->", 
     RowBox[{"2", "Pi"}]}]}], "]"}], "-", 
  RowBox[{"Limit", "[", 
   RowBox[{"%", ",", 
    RowBox[{"x", "->", "0"}]}], "]"}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->958],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->274063351]
}, Open  ]],

Cell[TextData[{
 "The definite integral, however, gives the correct result which depends on \
",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ". The assumption assures convergence. "
}], "MathCaption",
 CellID->26806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"a", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "a", "<", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->8166],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox["a", "2"]}]]]], "Output",
 ImageSize->{60, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1777787353]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", 
     ButtonBox["PrincipalValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrincipalValue"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "the Cauchy principal value of a definite integral", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11367],

Cell["Principal value integrals. ", "Caption",
 CellID->17692],

Cell[TextData[{
 "Here is the indefinite integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "x"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->21787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->28532],

Cell[BoxData[
 RowBox[{"Log", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->344429377]
}, Open  ]],

Cell[TextData[{
 "Substituting in the limits ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "2"}], TraditionalForm]], "InlineMath"],
 " yields a strange result involving ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->30974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{"%", ",", 
    RowBox[{"x", "->", "2"}]}], "]"}], "-", 
  RowBox[{"Limit", "[", 
   RowBox[{"%", ",", 
    RowBox[{"x", "->", 
     RowBox[{"-", "1"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[17]:=",
 CellID->3447],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]"}], "+", 
  RowBox[{"Log", "[", "2", "]"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->1042830013]
}, Open  ]],

Cell["The ordinary Riemann definite integral is divergent. ", "MathCaption",
 CellID->18283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->26222],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], ":", 
  " ", "\<\"Integral of \\!\\(1\\/x\\) does not converge on \
\\!\\({\\(\\(-1\\)\\), 2}\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", ButtonNote -> \
\\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[18]:=",
 CellID->145492832],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "1"}], "2"], 
  RowBox[{
   FractionBox["1", "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{52, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->514174740]
}, Open  ]],

Cell["The Cauchy principal value, however, is finite. ", "MathCaption",
 CellID->28583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PrincipalValue", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->26948],

Cell[BoxData[
 RowBox[{"Log", "[", "2", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->1170867352]
}, Open  ]],

Cell["\<\
When parameters appear in an indefinite integral, it is essentially always \
possible to get results that are correct for almost all values of these \
parameters. But for definite integrals this is no longer the case. The most \
common problem is that a definite integral may converge only when the \
parameters that appear in it satisfy certain specific conditions. \
\>", "Text",
 CellID->17982],

Cell[TextData[{
 "This indefinite integral is correct for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[NotEqual]", "-", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->22018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->14776],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->894552607]
}, Open  ]],

Cell[TextData[{
 "For the definite integral, however, ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " must satisfy a condition in order for the integral to be convergent. "
}], "MathCaption",
 CellID->31111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->32182],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "n", "]"}], ">", 
    RowBox[{"-", "1"}]}], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", "n"}]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SuperscriptBox["x", "n"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "n", "]"}], "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{475, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->229893581]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is replaced by 2, the condition is satisfied. "
}], "MathCaption",
 CellID->19490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"n", "->", "2"}]}]], "Input",
 CellLabel->"In[22]:=",
 CellID->8925],

Cell[BoxData[
 FractionBox["1", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->605817940]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["GenerateConditions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GenerateConditions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to generate explicit conditions", "TableText"]},
   {
    ButtonBox["Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Assumptions"], 
    ButtonBox["$Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Assumptions"], Cell[
    "what relations about parameters to assume", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6486],

Cell[TextData[{
 "Options for ",
 StyleBox["Integrate", "MR"],
 ". "
}], "Caption",
 CellID->19677],

Cell[TextData[{
 "With the assumption ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", ">", "2"}], TraditionalForm]], "InlineMath"],
 ", the result is always ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->15969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"(", 
     RowBox[{"n", ">", "2"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->11643],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->454672736]
}, Open  ]],

Cell[TextData[{
 "Even when a definite integral is convergent, the presence of singularities \
on the integration path can lead to discontinuous changes when the parameters \
vary. Sometimes a single formula containing functions like ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " can be used to summarize the result. In other cases, however, an explicit \
",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " is more convenient. "
}], "Text",
 CellID->15677],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " here gives the condition for the integral to be convergent. "
}], "MathCaption",
 CellID->22668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->31068],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"a", "\[Element]", "Reals"}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", "\[Pi]", " ", 
    RowBox[{"Sign", "[", "a", "]"}]}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "x"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"a", "\[NotEqual]", 
       RowBox[{"Re", "[", "a", "]"}]}]}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{548, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->738149048]
}, Open  ]],

Cell[TextData[{
 "Here is the result assuming that ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " is real. "
}], "MathCaption",
 CellID->32196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"Im", "[", "a", "]"}], "==", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->7783],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[Pi]", " ", 
  RowBox[{"Sign", "[", "a", "]"}]}]], "Output",
 ImageSize->{79, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->946864801]
}, Open  ]],

Cell[TextData[{
 "The result is discontinuous as a function of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ". The discontinuity can be traced to the essential singularity of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->7727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->29426],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWM1OwkAQnnYL3PSgoCb86atINGK8aZRjQ0zgoBjkwUzkIfQCF30BE4IX
LiYeSEzq7nbLttNtu2BRiE33Z2Znvp3sfNnd9szuta5v7F67aVePu/Zdq928
rx51ulRFDADo09LdBdp3aI+XvuPQ1q0btDbBbQEIq8lk8tm5faQv1GhF6KjJ
BNZhLZNpyXi656c35nbFESyO8PryPhyM6As1VjErIWeRbHrydPolUQ5pbYGH
xmLmD2SRbCLZ9T7V8GKi2toSK5LRwsYRYtn1qgvMnGitQAQNpU+0VuZrXk+1
dvFIpGddSDgj+ivJuWdJOZz9eG7o+uvNG82PdOeJ5krWkTxcHa4sjhfkCsMh
PtvZrqL0PwmtXQ7ZqXcCjyumlr+McNH5wn4ZJ243UdsvZz/ZQdqSWJtyhL6K
9NtKFL83CDSCUCESbdOXH9buiZYoYvLLlYiY8xw1j+Y+QNZFJOPYisi/wNuC
WOt50UrCL4hSCWW+LEbKoZFKAEGVgRmiQr+vXPm0TwM3Ze7zQIvBRcxezG58
MieNz2u/avP9FI/vOgF+s+5GgowZkzQrtk/C33Li2ZLGmfEfTy89v/U+tf6C
G8u7E/3eLXjVb7Fp3n7XnSMqVvh3DDmXzpdr8lqn58USdqm0TukrWfxnOOf/
EsbjDzFuBLiA94uL4WBkxay3//8GGN8r6/tS\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->453091832]
}, Open  ]],

Cell[TextData[{
 "There is no convenient way to represent this answer in terms of ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 ", so ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " generates an explicit ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"0", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}], "/", "x"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"Im", "[", "a", "]"}], "==", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->17612],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "<", 
     RowBox[{"-", "1"}]}], "||", 
    RowBox[{"a", ">", "1"}]}], ",", 
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"ArcSin", "[", 
      FractionBox["1", "a"], "]"}]}], 
    RowBox[{"Abs", "[", "a", "]"}]], ",", 
   FractionBox["\[Pi]", "2"]}], "]"}]], "Output",
 ImageSize->{231, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->358261630]
}, Open  ]],

Cell[TextData[{
 "Here is a plot of the resulting function of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->11027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "%", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->11408],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytmF2IVVUUx49zZhwTcsYZtVHHxqy0D/s208yZ0VGnkrAewix6mMTQhzLM
oLSHeihf6qVeEiIf+gAzwkgswSgSIiESJCEqCIOwhyRIehCC22+tde6sPWv2
dWa0C/ec/bH+/7X2Wmuvve99YGjn1i1PDe3ctnlo/uCOoWe2btv87Px123cw
VE4qiuIQ3xe7Cto1Wvo9VKvxTp9XyLOUOf0U83g00+2t3vPD/Iws6sqkz7Po
C/08S1ulo6l6z67eZZDuq+VtnKksM4OuBWOgu4P8LH3Ls2kc6HmV3EhUj/Sa
Xcr8N3KkZwQy50GZ7a/eV2U9Njp+m4LcIxcYNcfa5yDfSdptDrItoT859KeN
0Y/yY/GNNT9R+Uu1r6kWs0qaPWP0Y4bH+c4LxGWio5Ifm/5Hvksb1aSafPbs
P5uf+Oi5nYf3vfPdF0d/OfXDHw8yLsIbdP7nn/5kmMntT3/6+GP7Ebdk1Oyb
evr0X8e//Y3Zl186um3rwb6Ve5HZ8+pX77934sT3v68Peu9XDBNMI2QAtAOG
gvEzZ/5W3mKqPC+D/bPDP+596zi6kUQeFCOIFesC91pFMIO1b77xjXGDAw2C
ZRmn1q5iCn1GYdv48AcPbXgXAz45eAp1qwPrKpVmgundu44gCgDpAx+ehEK5
LEOm4Bg0v/7aMRyADNR0z5073xsYV6o0E0wjBCMAYMe+/hUKyzatMa2sBRtR
tv6+fSwHlQgUKwLf3SrLDLJYiCwI2iKrPMVcjSPm4hbU4W8WgwHLAtNdKseE
MSGKfZileDspWsgGbDUlBL5YWuXKnTpLBG1JBjSMVcQWlkuS4RliL7bdEbTf
XteOcUgROcw4f/5f3Z/F1cqBRwgns9ggOXBb4LhVpWC3lVZSii2u1TkIjR8L
Ze6WwHBzwoAUPgdh2OI6eTZjFQHDDEy9KaAXK5oJstnRixR9vaLps36bWxzQ
N6oEfoIfAkQVU43DamlNMt4QkMaN1XiYwNBQTGH2EXlijlqVkxqk8iWOQJNE
UeVs7WKhbTgULgp6FtYtIT1wLg3FmN9Log+f7LSFAaf+K8kd7JC8UPkqehhr
sa6kHHWN9rGP+eFoW56UWEkE8ZLW+6Zw95BzUsbiCaGZUKILP2G8cRVLhAEq
3XsjTv7WgG8K/QV1PmyRpua07gXh6xgXXzl8Z3CeJSq+tOKZPmG77Ewjk0gG
aerutP1dWgWVZtso3pbKl9FvPfVIEHfJ6KUJH328Sewb8KU88cZit09iS15I
PJSxWFbPC0alUrRVVrVW78gyr24H8mwOwxfL6zlJ9rhURLk3DKXVtGQDsF2k
2R1Q3SFSyxOUW9BdxXVuWInKVRWcfcJmlubcoMP6hI4AStNQ9wR75wTUnLDe
FQkK3ZQciVxEzQ6Wq7ydUSXlhirlUhHFJCLSTFHE0a4Jo1BddV3YIvMqb/ft
hKsri/L5FIUuyrysq6vyuEkziAKX7gvriXd461OZyG9p9iYoshN7G6NwHIXN
Uf06ChF00pwVUNa3WijNvgTFDmMvNUb5Cgy1Kqw23n1n1j3OgS1e6k9QzpVH
eY6nKM/aet2dFbLVpO0eheNwnzRnBB0zQvxWJSi3LI/yOKUoz/w8yndOinLf
5FG+AkMNhOh2BlRniO7qBOU53Fn5znRQaig4Udo58jrcBkOt0VEWg1Ol2ZFF
rR14m8VGlHNFVEewZWAYNXxijpL2dQ4kOjy35aQWUDy1cidPR8iulJGFslxp
xhNB7wIjTqIoYbwUKoqe8+pviGRHx/8z8rwiMD1YtCbh88wbH18qYbye2ymv
583F8nqkUl7fXxfL6zs45cXVOFwjXbP8n1zL3zeMhXQhaZzFfvF5BrdnUV4N
U5RHOqLaQ+TWJijPu/YqzibtVTCV9ltDXoffx1KU19k8yqOconw35VGecynK
I5BHkWSkWkThbpzeGOW+NdRgiENbFsWv86qfonzv1W997cGGdYm0162ow/pe
t1JUuAGPQvluc5RUu7j6thC/VIfvrLwOj2qKcq48yjMsRXkujPSZrzOV9tXl
dbhPU5TfgvIoz5wURQKQBo1RHm1D3RsyI/4DaCg/kyeC8rqRojxL8yhnTVFu
gaAENH7p0f9weu0ZTFAUGMpMY5RHJEV5HCaOqv9qTs/lRr+kjc33V8LW7DYU
xZSAi2e+8XhOpjxefS+Nx/dBnkcOtMvHiW90Yo1Xf/wPO56fY/MU+mn0W/gC
+PKF54/s3vW5/GcyTR6C4u39Pa98+eSWjyPqwP6TlJ3GKCYRcVT+v+ZHw+hG
c8ek/wC6qKBy\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->182686173]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->170938756],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CalculusOverview"]], "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Definite Integrals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Calculus", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/CalculusOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/IntegralsThatCanAndCannotBeDone"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/IntegralsOverRegions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 54.6091392}", "context" -> "", 
    "keywords" -> {
     "applicability", "assumptions", "calculus", "Cauchy principal value", 
      "conditions", "convergence", "criteria", "definite integration", 
      "divergent integrals", "essential singularities", 
      "fundamental theorem of calculus", "GenerateConditions", "inequalities",
       "inferences", "integrals", "Integrate", "integration", "limits", 
      "parameters", "PrincipalValue", "Riemann integrals", "singularities", 
      "types"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Integration functions. Here is the integral \
SubsuperscriptBox[\\[Integral], a, b]x^2 dx. This gives the multiple integral \
SubsuperscriptBox[\\[Integral], 0, a]dx SubsuperscriptBox[\\[Integral], 0, \
b]dy(x^2+y^2). ", "synonyms" -> {"3.5.8"}, "title" -> "Definite Integrals", 
    "type" -> "Tutorial", "uri" -> "tutorial/DefiniteIntegrals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.5.8"->{
  Cell[1973, 60, 81, 2, 70, "Title",
   CellTags->{"S3.5.8", "8.1"},
   CellID->28510]},
 "8.1"->{
  Cell[1973, 60, 81, 2, 70, "Title",
   CellTags->{"S3.5.8", "8.1"},
   CellID->28510]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.5.8", 39668, 1431},
 {"8.1", 39767, 1435}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1348, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1973, 60, 81, 2, 70, "Title",
 CellTags->{"S3.5.8", "8.1"},
 CellID->28510],
Cell[2057, 64, 3028, 97, 70, "DefinitionBox",
 CellID->10422],
Cell[5088, 163, 58, 1, 70, "Caption",
 CellID->30774],
Cell[5149, 166, 252, 10, 70, "MathCaption",
 CellID->8779],
Cell[CellGroupData[{
Cell[5426, 180, 207, 7, 28, "Input",
 CellID->30910],
Cell[5636, 189, 293, 11, 54, "Output",
 CellID->1169788549]
}, Open  ]],
Cell[5944, 203, 487, 17, 70, "MathCaption",
 CellID->4182],
Cell[CellGroupData[{
Cell[6456, 224, 326, 11, 28, "Input",
 CellID->25391],
Cell[6785, 237, 321, 11, 51, "Output",
 CellID->1957016351]
}, Open  ]],
Cell[7121, 251, 502, 17, 70, "MathCaption",
 CellID->5764],
Cell[CellGroupData[{
Cell[7648, 272, 324, 11, 28, "Input",
 CellID->874],
Cell[7975, 285, 202, 7, 54, "Output",
 CellID->834068943]
}, Open  ]],
Cell[8192, 295, 331, 6, 70, "Text",
 CellID->14902],
Cell[8526, 303, 134, 4, 70, "MathCaption",
 CellID->28255],
Cell[CellGroupData[{
Cell[8685, 311, 186, 6, 70, "Input",
 CellID->4460],
Cell[8874, 319, 302, 10, 50, "Output",
 CellID->1183683464]
}, Open  ]],
Cell[9191, 332, 122, 3, 70, "MathCaption",
 CellID->6972],
Cell[CellGroupData[{
Cell[9338, 339, 268, 9, 70, "Input",
 CellID->26821],
Cell[9609, 350, 254, 8, 36, "Output",
 CellID->1677925856]
}, Open  ]],
Cell[9878, 361, 179, 4, 70, "MathCaption",
 CellID->25547],
Cell[CellGroupData[{
Cell[10082, 369, 326, 11, 70, "Input",
 CellID->21577],
Cell[10411, 382, 335, 12, 51, "Output",
 CellID->847027609]
}, Open  ]],
Cell[10761, 397, 183, 4, 70, "MathCaption",
 CellID->25605],
Cell[CellGroupData[{
Cell[10969, 405, 276, 9, 70, "Input",
 CellID->30195],
Cell[11248, 416, 206, 7, 54, "Output",
 CellID->207532066]
}, Open  ]],
Cell[11469, 426, 91, 1, 70, "MathCaption",
 CellID->7950],
Cell[CellGroupData[{
Cell[11585, 431, 338, 11, 70, "Input",
 CellID->16343],
Cell[11926, 444, 323, 12, 64, "Output",
 CellID->709485798]
}, Open  ]],
Cell[12264, 459, 110, 3, 70, "MathCaption",
 CellID->2481],
Cell[CellGroupData[{
Cell[12399, 466, 324, 11, 70, "Input",
 CellID->1012],
Cell[12726, 479, 820, 29, 51, "Output",
 CellID->2122937575]
}, Open  ]],
Cell[13561, 511, 376, 7, 70, "Text",
 CellID->23439],
Cell[13940, 520, 210, 8, 70, "MathCaption",
 CellID->13428],
Cell[CellGroupData[{
Cell[14175, 532, 173, 6, 70, "Input",
 CellID->5912],
Cell[14351, 540, 197, 7, 51, "Output",
 CellID->469707434]
}, Open  ]],
Cell[14563, 550, 83, 1, 70, "MathCaption",
 CellID->5967],
Cell[CellGroupData[{
Cell[14671, 555, 274, 10, 70, "Input",
 CellID->24408],
Cell[14948, 567, 176, 6, 36, "Output",
 CellID->131862005]
}, Open  ]],
Cell[15139, 576, 218, 7, 70, "MathCaption",
 CellID->1908],
Cell[CellGroupData[{
Cell[15382, 587, 254, 9, 70, "Input",
 CellID->17223],
Cell[15639, 598, 457, 9, 70, "Message",
 CellID->58289470],
Cell[16099, 609, 337, 12, 52, "Output",
 CellID->539000851]
}, Open  ]],
Cell[16451, 624, 119, 3, 70, "MathCaption",
 CellID->26434],
Cell[CellGroupData[{
Cell[16595, 631, 264, 10, 70, "Input",
 CellID->5204],
Cell[16862, 643, 479, 18, 86, "Output",
 CellID->494818438]
}, Open  ]],
Cell[17356, 664, 88, 1, 70, "MathCaption",
 CellID->4319],
Cell[CellGroupData[{
Cell[17469, 669, 273, 10, 70, "Input",
 CellID->958],
Cell[17745, 681, 159, 5, 36, "Output",
 CellID->274063351]
}, Open  ]],
Cell[17919, 689, 237, 7, 70, "MathCaption",
 CellID->26806],
Cell[CellGroupData[{
Cell[18181, 700, 443, 15, 70, "Input",
 CellID->8166],
Cell[18627, 717, 269, 10, 62, "Output",
 CellID->1777787353]
}, Open  ]],
Cell[18911, 730, 1135, 33, 70, "DefinitionBox",
 CellID->11367],
Cell[20049, 765, 62, 1, 70, "Caption",
 CellID->17692],
Cell[20114, 768, 184, 7, 70, "MathCaption",
 CellID->21787],
Cell[CellGroupData[{
Cell[20323, 779, 149, 5, 70, "Input",
 CellID->28532],
Cell[20475, 786, 188, 6, 36, "Output",
 CellID->344429377]
}, Open  ]],
Cell[20678, 795, 391, 15, 70, "MathCaption",
 CellID->30974],
Cell[CellGroupData[{
Cell[21094, 814, 273, 10, 70, "Input",
 CellID->3447],
Cell[21370, 826, 270, 9, 36, "Output",
 CellID->1042830013]
}, Open  ]],
Cell[21655, 838, 92, 1, 70, "MathCaption",
 CellID->18283],
Cell[CellGroupData[{
Cell[21772, 843, 229, 8, 70, "Input",
 CellID->26222],
Cell[22004, 853, 454, 9, 70, "Message",
 CellID->145492832],
Cell[22461, 864, 311, 11, 51, "Output",
 CellID->514174740]
}, Open  ]],
Cell[22787, 878, 87, 1, 70, "MathCaption",
 CellID->28583],
Cell[CellGroupData[{
Cell[22899, 883, 280, 9, 70, "Input",
 CellID->26948],
Cell[23182, 894, 189, 6, 36, "Output",
 CellID->1170867352]
}, Open  ]],
Cell[23386, 903, 407, 7, 70, "Text",
 CellID->17982],
Cell[23796, 912, 208, 7, 70, "MathCaption",
 CellID->22018],
Cell[CellGroupData[{
Cell[24029, 923, 149, 5, 70, "Input",
 CellID->14776],
Cell[24181, 930, 250, 9, 54, "Output",
 CellID->894552607]
}, Open  ]],
Cell[24446, 942, 229, 6, 70, "MathCaption",
 CellID->31111],
Cell[CellGroupData[{
Cell[24700, 952, 208, 7, 70, "Input",
 CellID->32182],
Cell[24911, 961, 642, 21, 51, "Output",
 CellID->229893581]
}, Open  ]],
Cell[25568, 985, 173, 6, 70, "MathCaption",
 CellID->19490],
Cell[CellGroupData[{
Cell[25766, 995, 113, 4, 70, "Input",
 CellID->8925],
Cell[25882, 1001, 179, 6, 51, "Output",
 CellID->605817940]
}, Open  ]],
Cell[26076, 1010, 996, 27, 70, "DefinitionBox3Col",
 CellID->6486],
Cell[27075, 1039, 99, 5, 70, "Caption",
 CellID->19677],
Cell[27177, 1046, 336, 13, 70, "MathCaption",
 CellID->15969],
Cell[CellGroupData[{
Cell[27538, 1063, 304, 10, 70, "Input",
 CellID->11643],
Cell[27845, 1075, 202, 7, 51, "Output",
 CellID->454672736]
}, Open  ]],
Cell[28062, 1085, 589, 16, 70, "Text",
 CellID->15677],
Cell[28654, 1103, 231, 8, 70, "MathCaption",
 CellID->22668],
Cell[CellGroupData[{
Cell[28910, 1115, 273, 9, 70, "Input",
 CellID->31068],
Cell[29186, 1126, 696, 21, 51, "Output",
 CellID->738149048]
}, Open  ]],
Cell[29897, 1150, 166, 6, 70, "MathCaption",
 CellID->32196],
Cell[CellGroupData[{
Cell[30088, 1160, 375, 12, 70, "Input",
 CellID->7783],
Cell[30466, 1174, 247, 8, 51, "Output",
 CellID->946864801]
}, Open  ]],
Cell[30728, 1185, 442, 14, 70, "MathCaption",
 CellID->7727],
Cell[CellGroupData[{
Cell[31195, 1203, 200, 7, 28, "Input",
 CellID->29426],
Cell[31398, 1212, 921, 19, 135, "Output",
 Evaluatable->False,
 CellID->453091832]
}, Open  ]],
Cell[32334, 1234, 430, 16, 70, "MathCaption",
 CellID->10697],
Cell[CellGroupData[{
Cell[32789, 1254, 467, 15, 70, "Input",
 CellID->17612],
Cell[33259, 1271, 483, 17, 61, "Output",
 CellID->358261630]
}, Open  ]],
Cell[33757, 1291, 169, 6, 70, "MathCaption",
 CellID->11027],
Cell[CellGroupData[{
Cell[33951, 1301, 236, 8, 28, "Input",
 CellID->11408],
Cell[34190, 1311, 2544, 46, 145, "Output",
 Evaluatable->False,
 CellID->182686173]
}, Open  ]],
Cell[CellGroupData[{
Cell[36771, 1362, 72, 1, 70, "RelatedTutorialsSection",
 CellID->170938756],
Cell[36846, 1365, 146, 3, 70, "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],
Cell[37019, 1372, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

