(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19045,        664]
NotebookOptionsPosition[     14571,        528]
NotebookOutlinePosition[     17338,        599]
CellTagsIndexPosition[     17247,        593]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DSolve" :> Documentation`HelpLookup["paclet:ref/DSolve"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"DSolve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Differential Equations", "Title",
 CellTags->{"S1.5.9", "9.1"},
 CellID->15565],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     StyleBox["eqns", "TI"], ",", 
     StyleBox["y", "TI"], "[", 
     StyleBox["x", "TI"], "]", ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "solve a differential equation for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["y", "TI"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     ", taking ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " as the independent variable"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     StyleBox["eqns", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "give a solution for ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " in pure function form"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3093],

Cell["Solving an ordinary differential equation. ", "Caption",
 CellID->13608],

Cell[TextData[{
 "Here is the solution to the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]"], "(", "x", ")"}], "=", 
    RowBox[{
     RowBox[{"a", 
      RowBox[{"y", "(", "x", ")"}]}], "+", "1"}]}], TraditionalForm]], 
  "InlineMath"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " is a coefficient which must be determined from boundary conditions. "
}], "MathCaption",
 CellID->6172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"y", "[", "x", "]"}]}], "+", "1"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->11243],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "a"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{158, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->29929]
}, Open  ]],

Cell["\<\
If you include an appropriate initial condition, there are no undetermined \
coefficients in the solution. \
\>", "MathCaption",
 CellID->7514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"y", "[", "x", "]"}]}], "+", "1"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->10168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", " ", "x"}]]}], "a"]}], "}"}], "}"}]], "Output",
 ImageSize->{127, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->5055]
}, Open  ]],

Cell[TextData[{
 "Whereas algebraic equations such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", "x", "=", "1"}], TraditionalForm]], 
  "InlineMath"],
 " are equations for ",
 StyleBox["variables",
  FontSlant->"Italic"],
 ", differential equations such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "\[Prime]\[Prime]"], "(", "x", ")"}], "+", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]"], "(", "x", ")"}]}], "=", 
    RowBox[{"y", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " are equations for ",
 StyleBox["functions",
  FontSlant->"Italic"],
 ". In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you must always give differential equations explicitly in terms of \
functions such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ", and you must specify the variables such as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " on which the functions depend. As a result, you must write an equation \
such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "\[Prime]\[Prime]"], "(", "x", ")"}], "+", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]"], "(", "x", ")"}]}], "=", 
    RowBox[{"y", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " in the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}]}], "==", 
   RowBox[{"y", "[", "x", "]"}]}]], "InlineFormula"],
 ". You cannot write it as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"y", "''"}], "+", 
    RowBox[{"y", "'"}]}], "==", "y"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->11191],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can solve both linear and nonlinear ordinary differential equations, as \
well as lists of simultaneous equations. If you do not specify enough initial \
or boundary conditions, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will give solutions that involve an appropriate number of undetermined \
coefficients. Each time you use ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ", it names the undetermined coefficients ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 ", etc. "
}], "Text",
 CellID->5973],

Cell["\<\
Here is a pair of simultaneous differential equations, with no initial or \
boundary conditions. The solution you get involves two undetermined \
coefficients. \
\>", "MathCaption",
 CellID->8922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "==", 
      RowBox[{"y", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "==", 
      RowBox[{"x", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", 
     RowBox[{"y", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "t"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "t"}]]}], ")"}], " ", 
       RowBox[{"C", "[", "1", "]"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "t"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "t"}]]}], ")"}], " ", 
       RowBox[{"C", "[", "2", "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "t"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "t"}]]}], ")"}], " ", 
       RowBox[{"C", "[", "1", "]"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "t"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "t"}]]}], ")"}], " ", 
       RowBox[{"C", "[", "2", "]"}]}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{334, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->5651]
}, Open  ]],

Cell[TextData[{
 "When you ask ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " to get you a solution for ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 ", the rules it returns specify how to replace ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 " in any expression. However, these rules do not specify how to replace \
objects such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", "'"}], "[", "x", "]"}]], "InlineFormula"],
 ". If you want to manipulate solutions that you get from ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ", you will often find it better to ask for solutions for ",
 Cell[BoxData["y"], "InlineFormula"],
 ", rather than for ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->10986],

Cell[TextData[{
 "This gives the solution for ",
 Cell[BoxData["y"], "InlineFormula"],
 " as a \[OpenCurlyDoubleQuote]pure function\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
 CellID->2144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
    RowBox[{"x", "+", 
     RowBox[{"y", "[", "x", "]"}]}]}], ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->16446],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "x", "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->31577]
}, Open  ]],

Cell[TextData[{
 "You can now use the replacement operator to apply this solution to \
expressions involving ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
   RowBox[{"y", "[", "x", "]"}]}], "/.", "%"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->14629],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], "-", "x", "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", "x"], " ", 
    RowBox[{"C", "[", "1", "]"}]}]}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->29916]
}, Open  ]],

Cell[TextData[{
 ButtonBox["\"Pure Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PureFunctions"],
 " explains how the \[OpenCurlyDoubleQuote]pure function\
\[CloseCurlyDoubleQuote] that appears in the result from ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " works. "
}], "Text",
 CellID->5874],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can handle combinations of algebraic and differential equations. It can \
also handle partial differential equations, in which there is more than one \
independent variable. "
}], "Text",
 CellID->15791],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->45146570],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Differential Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/Inequalities-SymbolicMathematics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PowerSeries"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 1.2811850}", "context" -> "", 
    "keywords" -> {
     "C", "differential equations", "DSolve", "equations", "ODEs", 
      "ordinary differential equations", "solving differential equations", 
      "undetermined coefficients"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Solving an ordinary differential equation. Here is the solution to the \
differential equation y^,(x)=ay(x)+1. C[1] is a coefficient which must be \
determined from boundary conditions. If you include an appropriate initial \
condition, there are no undetermined coefficients in the solution. ", 
    "synonyms" -> {"1.5.9"}, "title" -> "Differential Equations", "type" -> 
    "Tutorial", "uri" -> "tutorial/DifferentialEquations-Basics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.9"->{
  Cell[1800, 58, 85, 2, 70, "Title",
   CellTags->{"S1.5.9", "9.1"},
   CellID->15565]},
 "9.1"->{
  Cell[1800, 58, 85, 2, 70, "Title",
   CellTags->{"S1.5.9", "9.1"},
   CellID->15565]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.9", 17036, 582},
 {"9.1", 17135, 586}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1175, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1800, 58, 85, 2, 70, "Title",
 CellTags->{"S1.5.9", "9.1"},
 CellID->15565],
Cell[1888, 62, 1285, 41, 70, "DefinitionBox",
 CellID->3093],
Cell[3176, 105, 78, 1, 70, "Caption",
 CellID->13608],
Cell[3257, 108, 553, 19, 70, "MathCaption",
 CellID->6172],
Cell[CellGroupData[{
Cell[3835, 131, 320, 11, 28, "Input",
 CellID->11243],
Cell[4158, 144, 460, 16, 51, "Output",
 CellID->29929]
}, Open  ]],
Cell[4633, 163, 153, 4, 70, "MathCaption",
 CellID->7514],
Cell[CellGroupData[{
Cell[4811, 171, 440, 15, 28, "Input",
 CellID->10168],
Cell[5254, 188, 401, 14, 52, "Output",
 CellID->5055]
}, Open  ]],
Cell[5670, 205, 1809, 63, 70, "Text",
 CellID->11191],
Cell[7482, 270, 886, 28, 70, "Text",
 CellID->5973],
Cell[8371, 300, 206, 5, 70, "MathCaption",
 CellID->8922],
Cell[CellGroupData[{
Cell[8602, 309, 519, 18, 70, "Input",
 CellID->6748],
Cell[9124, 329, 1674, 52, 81, "Output",
 CellID->5651]
}, Open  ]],
Cell[10813, 384, 941, 29, 70, "Text",
 CellID->10986],
Cell[11757, 415, 192, 5, 70, "MathCaption",
 CellID->2144],
Cell[CellGroupData[{
Cell[11974, 424, 264, 9, 70, "Input",
 CellID->16446],
Cell[12241, 435, 487, 16, 36, "Output",
 CellID->31577]
}, Open  ]],
Cell[12743, 454, 190, 6, 70, "MathCaption",
 CellID->26517],
Cell[CellGroupData[{
Cell[12958, 464, 192, 7, 70, "Input",
 CellID->14629],
Cell[13153, 473, 334, 11, 36, "Output",
 CellID->29916]
}, Open  ]],
Cell[13502, 487, 389, 12, 70, "Text",
 CellID->5874],
Cell[13894, 501, 352, 10, 70, "Text",
 CellID->15791],
Cell[CellGroupData[{
Cell[14271, 515, 71, 1, 70, "RelatedTutorialsSection",
 CellID->45146570],
Cell[14345, 518, 172, 4, 70, "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],
Cell[14544, 526, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

