(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35658,        703]
NotebookOptionsPosition[     31799,        602]
NotebookOutlinePosition[     34944,        678]
CellTagsIndexPosition[     34850,        672]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Input and Output in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PrintingStyleEnvironment" :> 
          Documentation`HelpLookup["paclet:ref/PrintingStyleEnvironment"], 
          "ScreenStyleEnvironment" :> 
          Documentation`HelpLookup["paclet:ref/ScreenStyleEnvironment"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"PrintingStyleEnvironment\"\>", 
       2->"\<\"ScreenStyleEnvironment\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Displaying and Printing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Notebooks"
}], "Title",
 CellTags->{"S1.10.11", "11.1"},
 CellID->26363],

Cell[TextData[{
 "Depending on the purpose for which you are using a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook, you may want to change its overall appearance. The front end \
allows you to specify independently the styles to be used for display on the \
screen and for printing. Typically you can do this by choosing appropriate \
items in the ",
 StyleBox[ButtonBox["Format",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
 " menu. "
}], "Text",
 CellID->5716],

Cell[BoxData[GridBox[{
   {
    ButtonBox["ScreenStyleEnvironment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ScreenStyleEnvironment"], Cell[
    "styles to be used for screen display", "TableText"]},
   {
    ButtonBox["PrintingStyleEnvironment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrintingStyleEnvironment"], Cell[
    "styles to be used for printed output", "TableText"]},
   {"Working", Cell[
    "standard style definitions for screen display", "TableText"]},
   {"Presentation", Cell[
    "style definitions for presentations", "TableText"]},
   {"SlideShow", Cell[
    "style definitions for displaying presentation slides", "TableText"]},
   {"Printout", Cell["style definitions for printed output", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10573],

Cell["\<\
Front end settings that define the global appearance of a notebook. \
\>", "Caption",
 CellID->31561],

Cell["\<\
Here is a typical notebook as it appears in working form on the screen. \
\>", "MathCaption",
 CellID->23245],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 254},
 ImageMargins->{{1, 0}, {0, 1}},
 CellID->6473],

Cell["\<\
Here is a preview of how the notebook would appear when printed out. \
\>", "MathCaption",
 CellID->24353],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 184},
 ImageMargins->0,
 CellID->1181],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->34123256],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Displaying and Printing Mathematica Notebooks - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MixingTextAndFormulas"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SettingUpHyperlinks"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 12.5627238}", "context" -> "", 
    "keywords" -> {
     "condensed style environment", "laptop computers", "notebook computers", 
      "portable computers", "presentation style environment", "printing", 
      "PrintingStyleEnvironment", "printout style environment", 
      "ScreenStyleEnvironment", "small screens", "working style environment"},
     "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Depending on the purpose for which you are using a Mathematica notebook, \
you may want to change its overall appearance. The front end allows you to \
specify independently the styles to be used for display on the screen and for \
printing. Typically you can do this by choosing appropriate items in the \
Format menu. Front end settings that define the global appearance of a \
notebook. Here is a typical notebook as it appears in working form on the \
screen. ", "synonyms" -> {"1.10.11"}, "title" -> 
    "Displaying and Printing Mathematica Notebooks", "type" -> "Tutorial", 
    "uri" -> "tutorial/DisplayingAndPrintingMathematicaNotebooks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.11"->{
  Cell[2049, 63, 169, 7, 70, "Title",
   CellTags->{"S1.10.11", "11.1"},
   CellID->26363]},
 "11.1"->{
  Cell[2049, 63, 169, 7, 70, "Title",
   CellTags->{"S1.10.11", "11.1"},
   CellID->26363]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.11", 34630, 661},
 {"11.1", 34734, 665}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1424, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2049, 63, 169, 7, 70, "Title",
 CellTags->{"S1.10.11", "11.1"},
 CellID->26363],
Cell[2221, 72, 512, 13, 70, "Text",
 CellID->5716],
Cell[2736, 87, 1109, 27, 70, "DefinitionBox",
 CellID->10573],
Cell[3848, 116, 111, 3, 70, "Caption",
 CellID->31561],
Cell[3962, 121, 119, 3, 70, "MathCaption",
 CellID->23245],
Cell[4084, 126, 14935, 247, 70, "Picture",
 CellID->6473],
Cell[19022, 375, 116, 3, 70, "MathCaption",
 CellID->24353],
Cell[19141, 380, 12318, 205, 70, "Picture",
 CellID->1181],
Cell[CellGroupData[{
Cell[31484, 589, 71, 1, 70, "RelatedTutorialsSection",
 CellID->34123256],
Cell[31558, 592, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],
Cell[31772, 600, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

