(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18322,        620]
NotebookOptionsPosition[     12939,        456]
NotebookOutlinePosition[     16126,        538]
CellTagsIndexPosition[     15951,        530]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Textual Input and Output" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Documentation Constructs", "Title",
 CellTags->{"S2.9.23", "23.1"},
 CellID->4287],

Cell[TextData[{
 "When you write programs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", there are various ways to document your code. As always, by far the best \
thing is to write clear code, and to name the objects you define as \
explicitly as possible. "
}], "Text",
 CellID->2699],

Cell[TextData[{
 "Sometimes, however, you may want to add some \
\[OpenCurlyDoubleQuote]commentary text\[CloseCurlyDoubleQuote] to your code, \
to make it easier to understand. You can add such text at any point in your \
code simply by enclosing it in matching ",
 Cell[BoxData["(*"], "InlineFormula"],
 " and ",
 Cell[BoxData["*)"], "InlineFormula"],
 ". Notice that in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", \[OpenCurlyDoubleQuote]comments\[CloseCurlyDoubleQuote] enclosed in ",
 Cell[BoxData["(*"], "InlineFormula"],
 " and ",
 Cell[BoxData["*)"], "InlineFormula"],
 " can be nested in any way. "
}], "Text",
 CellID->18110],

Cell[TextData[{
 "You can use comments anywhere in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code you write. "
}], "MathCaption",
 CellID->18643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"a", ">", "b"}], ",", 
   RowBox[{"(*", "then", "*)"}], " ", "p", ",", 
   RowBox[{"(*", "else", "*)"}], " ", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17465],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"a", ">", "b"}], ",", "p", ",", "q"}], "]"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->422013928]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{"(*", 
     StyleBox["text", "TI"], "*)"}], Cell[TextData[{
     "a comment that can be inserted anywhere in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " code"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2529],

Cell[TextData[{
 "Comments in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->9981],

Cell[TextData[{
 "There is a convention in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that all functions intended for later use should be given a definite \
\[OpenCurlyDoubleQuote]usage message\[CloseCurlyDoubleQuote], which documents \
their basic usage. This message is defined as the value of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "::", "usage"}]], "InlineFormula"],
 ", and is retrieved when you type ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->2112],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "::", "usage", "=", "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\""}], Cell[
    "define the usage message for a function", "TableText"]},
   {
    RowBox[{"?", 
     StyleBox["f", "TI"]}], Cell[
    "get information about a function", "TableText"]},
   {
    RowBox[{"??", 
     StyleBox["f", "TI"]}], Cell[
    "get more information about a function", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13476],

Cell["Usage messages for functions. ", "Caption",
 CellID->4381],

Cell[TextData[{
 "Here is the definition of a function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8247],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26890],

Cell[TextData[{
 "Here is a \[OpenCurlyDoubleQuote]usage message\[CloseCurlyDoubleQuote] for \
",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "::", "usage"}], "=", 
  "\"\<f[x] gives the square of x.\>\""}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8805],

Cell[BoxData["\<\"f[x] gives the square of x.\"\>"], "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->59378880]
}, Open  ]],

Cell[TextData[{
 "This gives the usage message for ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3989],

Cell[BoxData[
 StyleBox["\<\"f[x] gives the square of x.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3381740341-3154565",
 CellID->372886065]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"??", "f"}]], "InlineFormula"],
 " gives all the information ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has about ",
 Cell[BoxData["f"], "InlineFormula"],
 ", including the actual definition. "
}], "MathCaption",
 CellID->23165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "f"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->15431],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"f[x] gives the square of x.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellTags->"Info3381740343-1785941",
 CellID->224571184],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         SuperscriptBox["x", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3381740343-1785941",
 CellID->36501695]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "When you define a function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", you can usually display its value using ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ". However, if you give a usage message for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " just gives the usage message. Only when you type ",
 Cell[BoxData[
  RowBox[{"??", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " do you get all the details about ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", including its actual definition. "
}], "Text",
 CellID->17206],

Cell[TextData[{
 "If you ask for information using ",
 Cell[BoxData["?"], "InlineFormula"],
 " about just one function, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will print out the complete usage messages for the function. If you ask \
for information on several functions at the same time, however, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will give the name of each function, if possible with a link to its usage \
information. "
}], "Text",
 CellID->26578],

Cell[TextData[{
 "This gives all the symbols in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that start with \"Plot\"."
}], "MathCaption",
 CellID->377957390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Plot*"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->12860862],

Cell[BoxData[
 DynamicModuleBox[{Typeset`open$$ = True}, 
  PaneSelectorBox[{False->
   RowBox[{
    OpenerBox[Dynamic[Typeset`open$$],
     ImageSize->Small], 
    StyleBox["System`", "InfoHeading"]}], True->GridBox[{
     {
      RowBox[{
       OpenerBox[Dynamic[Typeset`open$$],
        ImageSize->Small], 
       StyleBox["System`", "InfoHeading"]}]},
     {GridBox[{
        {
         ButtonBox["Plot",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`Plot"},
          ButtonNote->"System`"], 
         ButtonBox["PlotJoined",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`PlotJoined"},
          ButtonNote->"System`"], 
         ButtonBox["PlotRange",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`PlotRange"},
          ButtonNote->"System`"], 
         ButtonBox["PlotStyle",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`PlotStyle"},
          ButtonNote->"System`"]},
        {
         ButtonBox["Plot3D",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`Plot3D"},
          ButtonNote->"System`"], 
         ButtonBox["PlotLabel",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`PlotLabel"},
          ButtonNote->"System`"], 
         ButtonBox["PlotRangeClipping",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`PlotRangeClipping"},
          ButtonNote->"System`"], ""},
        {
         ButtonBox["Plot3Matrix",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`Plot3Matrix"},
          ButtonNote->"System`"], 
         ButtonBox["PlotMarkers",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`PlotMarkers"},
          ButtonNote->"System`"], 
         ButtonBox["PlotRangePadding",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`PlotRangePadding"},
          ButtonNote->"System`"], ""},
        {
         ButtonBox["PlotDivision",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`PlotDivision"},
          ButtonNote->"System`"], 
         ButtonBox["PlotPoints",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`PlotPoints"},
          ButtonNote->"System`"], 
         ButtonBox["PlotRegion",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3382443248-7549212", "System`PlotRegion"},
          ButtonNote->"System`"], ""}
       },
       DefaultBaseStyle->"InfoGrid",
       GridBoxItemSize->{"Columns" -> {{
            Scaled[0.2375]}}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}]}, 
   Dynamic[Typeset`open$$],
   ImageSize->Automatic]]], "Print", "InfoCell",
 CellID->668334639]
}, Open  ]],

Cell[TextData[{
 "If you use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a text\[Hyphen]based interface, then messages and comments are the \
primary mechanisms for documenting your definitions. However, if you use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a notebook interface, then you will be able to give much more \
extensive documentation in text cells in the notebook."
}], "Text",
 CellID->18166],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->71563542],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Documentation Constructs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/InternationalMessages"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 13.3908700}", "context" -> "", 
    "keywords" -> {
     "(*", "*)", "comments", "documentation constructs", "information", 
      "messages", "question mark", "usage messages"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When you write programs in Mathematica, there are various ways to \
document your code. As always, by far the best thing is to write clear code, \
and to name the objects you define as explicitly as possible. Sometimes, \
however, you may want to add some 'commentary text' to your code, to make it \
easier to understand. You can add such text at any point in your code simply \
by enclosing it in matching (* and *). Notice that in Mathematica, 'comments' \
enclosed in (* and *) can be nested in any way. You can use comments anywhere \
in the Mathematica code you write. ", "synonyms" -> {"2.9.23"}, "title" -> 
    "Documentation Constructs", "type" -> "Tutorial", "uri" -> 
    "tutorial/DocumentationConstructs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.23"->{
  Cell[1270, 43, 88, 2, 70, "Title",
   CellTags->{"S2.9.23", "23.1"},
   CellID->4287]},
 "23.1"->{
  Cell[1270, 43, 88, 2, 70, "Title",
   CellTags->{"S2.9.23", "23.1"},
   CellID->4287]},
 "Info3381740341-3154565"->{
  Cell[6141, 231, 153, 4, 70, "Print",
   CellTags->"Info3381740341-3154565",
   CellID->372886065]},
 "Info3381740343-1785941"->{
  Cell[6724, 259, 153, 4, 70, "Print",
   CellTags->"Info3381740343-1785941",
   CellID->224571184],
  Cell[6880, 265, 776, 23, 70, "Print",
   CellTags->"Info3381740343-1785941",
   CellID->36501695]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.23", 15374, 508},
 {"23.1", 15475, 512},
 {"Info3381740341-3154565", 15594, 516},
 {"Info3381740343-1785941", 15725, 520}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 645, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1270, 43, 88, 2, 70, "Title",
 CellTags->{"S2.9.23", "23.1"},
 CellID->4287],
Cell[1361, 47, 298, 8, 70, "Text",
 CellID->2699],
Cell[1662, 57, 645, 17, 70, "Text",
 CellID->18110],
Cell[2310, 76, 162, 6, 70, "MathCaption",
 CellID->18643],
Cell[CellGroupData[{
Cell[2497, 86, 229, 7, 28, "Input",
 CellID->17465],
Cell[2729, 95, 243, 8, 36, "Output",
 CellID->422013928]
}, Open  ]],
Cell[2987, 106, 561, 17, 70, "DefinitionBox",
 CellID->2529],
Cell[3551, 125, 117, 6, 70, "Caption",
 CellID->9981],
Cell[3671, 133, 543, 16, 70, "Text",
 CellID->2112],
Cell[4217, 151, 767, 22, 70, "DefinitionBox",
 CellID->13476],
Cell[4987, 175, 64, 1, 70, "Caption",
 CellID->4381],
Cell[5054, 178, 135, 5, 70, "MathCaption",
 CellID->8247],
Cell[5192, 185, 141, 5, 70, "Input",
 CellID->26890],
Cell[5336, 192, 176, 6, 70, "MathCaption",
 CellID->16671],
Cell[CellGroupData[{
Cell[5537, 202, 152, 5, 70, "Input",
 CellID->8805],
Cell[5692, 209, 192, 5, 36, "Output",
 CellID->59378880]
}, Open  ]],
Cell[5899, 217, 132, 5, 70, "MathCaption",
 CellID->30032],
Cell[CellGroupData[{
Cell[6056, 226, 82, 3, 70, "Input",
 CellID->3989],
Cell[6141, 231, 153, 4, 70, "Print",
 CellTags->"Info3381740341-3154565",
 CellID->372886065]
}, Open  ]],
Cell[6309, 238, 281, 10, 70, "MathCaption",
 CellID->23165],
Cell[CellGroupData[{
Cell[6615, 252, 84, 3, 70, "Input",
 CellID->15431],
Cell[CellGroupData[{
Cell[6724, 259, 153, 4, 70, "Print",
 CellTags->"Info3381740343-1785941",
 CellID->224571184],
Cell[6880, 265, 776, 23, 70, "Print",
 CellTags->"Info3381740343-1785941",
 CellID->36501695]
}, Open  ]]
}, Open  ]],
Cell[7683, 292, 715, 24, 70, "Text",
 CellID->17206],
Cell[8401, 318, 486, 13, 70, "Text",
 CellID->26578],
Cell[8890, 333, 168, 6, 70, "MathCaption",
 CellID->377957390],
Cell[CellGroupData[{
Cell[9083, 343, 91, 3, 70, "Input",
 CellID->12860862],
Cell[9177, 348, 2978, 77, 70, "Print",
 CellID->668334639]
}, Open  ]],
Cell[12170, 428, 438, 11, 70, "Text",
 CellID->18166],
Cell[CellGroupData[{
Cell[12633, 443, 71, 1, 70, "RelatedTutorialsSection",
 CellID->71563542],
Cell[12707, 446, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[12912, 454, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

