(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15127,        511]
NotebookOptionsPosition[      9959,        359]
NotebookOutlinePosition[     13152,        436]
CellTagsIndexPosition[     13061,        430]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Modularity and the Naming of Things" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Modularity and the Naming of Things\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dummy Variables in Mathematics", "Title",
 CellTags->{"S2.7.5", "5.1"},
 CellID->27415],

Cell[TextData[{
 "When you set up mathematical formulas, you often have to introduce various \
kinds of local objects or \[OpenCurlyDoubleQuote]dummy variables\
\[CloseCurlyDoubleQuote]. You can treat such dummy variables using modules \
and other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " scoping constructs. "
}], "Text",
 CellID->6085],

Cell["\<\
Integration variables are a common example of dummy variables in mathematics. \
When you write down a formal integral, conventional notation requires you to \
introduce an integration variable with a definite name. This variable is \
essentially \[OpenCurlyDoubleQuote]local\[CloseCurlyDoubleQuote] to the \
integral, and its name, while arbitrary, must not conflict with any other \
names in your mathematical expression. \
\>", "Text",
 CellID->318],

Cell["Here is a function for evaluating an integral. ", "MathCaption",
 CellID->3580],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", "n_", "]"}], ":=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "s", "]"}], " ", 
     RowBox[{"s", "^", "n"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->1331],

Cell[TextData[{
 "The ",
 Cell[BoxData["s"], "InlineFormula"],
 " here conflicts with the integration variable. "
}], "MathCaption",
 CellID->7267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"s", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->8387],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{
    SuperscriptBox["s", 
     RowBox[{"1", "+", "s"}]], " ", 
    RowBox[{"f", "[", "s", "]"}]}], 
   RowBox[{"\[DifferentialD]", "s"}]}]}]], "Output",
 ImageSize->{94, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->13444]
}, Open  ]],

Cell["\<\
Here is a definition with the integration variable specified as local to a \
module. \
\>", "MathCaption",
 CellID->23186],

Cell[BoxData[
 RowBox[{
  RowBox[{"pm", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "s", "}"}], ",", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "s", "]"}], " ", 
       RowBox[{"s", "^", "n"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}]}]], "Input",\

 CellLabel->"In[3]:= ",
 CellID->14507],

Cell[TextData[{
 "Since you have used a module, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically renames the integration variable to avoid a conflict. "
}], "MathCaption",
 CellID->4360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pm", "[", 
  RowBox[{"s", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->17827],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{
    SuperscriptBox["s$20", 
     RowBox[{"1", "+", "s"}]], " ", 
    RowBox[{"f", "[", "s$20", "]"}]}], 
   RowBox[{"\[DifferentialD]", "s$20"}]}]}]], "Output",
 ImageSize->{157, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->28074]
}, Open  ]],

Cell[TextData[{
 "In many cases, the most important issue is that dummy variables should be \
kept local, and should not interfere with other variables in your \
mathematical expression. In some cases, however, what is instead important is \
that different uses of the ",
 StyleBox["same",
  FontSlant->"Italic"],
 " dummy variable should not conflict. "
}], "Text",
 CellID->26431],

Cell["\<\
Repeated dummy variables often appear in products of vectors and tensors. \
With the \[OpenCurlyDoubleQuote]summation convention\[CloseCurlyDoubleQuote], \
any vector or tensor index that appears exactly twice is summed over all its \
possible values. The actual name of the repeated index never matters, but if \
there are two separate repeated indices, it is essential that their names do \
not conflict. \
\>", "Text",
 CellID->7152],

Cell[TextData[{
 "This sets up the repeated index ",
 Cell[BoxData["j"], "InlineFormula"],
 " as a dummy variable. "
}], "MathCaption",
 CellID->30271],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "[", "i_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "j", "}"}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"i", ",", "j"}], "]"}], " ", 
     RowBox[{"b", "[", "j", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->10268],

Cell["\<\
The module gives different instances of the dummy variable different names. \
\>", "MathCaption",
 CellID->4693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "[", "i1", "]"}], " ", 
  RowBox[{"q", "[", "i2", "]"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->19885],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", 
   RowBox[{"i1", ",", "j$29"}], "]"}], " ", 
  RowBox[{"a", "[", 
   RowBox[{"i2", ",", "j$30"}], "]"}], " ", 
  RowBox[{"b", "[", "j$29", "]"}], " ", 
  RowBox[{"b", "[", "j$30", "]"}]}]], "Output",
 ImageSize->{260, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->337]
}, Open  ]],

Cell[TextData[{
 "There are many situations in mathematics where you need to have variables \
with unique names. One example is in representing solutions to equations. \
With an equation like ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cos", "(", "x", ")"}], "=", "1"}], TraditionalForm]], 
  "InlineMath"],
 ", there are an infinite number of solutions, each of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"2", "\[Pi]", " ", "n"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is a dummy variable that can be equal to any integer."
}], "Text",
 CellID->31311],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " solves this equation, it creates a dummy variable."
}], "MathCaption",
 CellID->555585135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "==", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->788473],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"2", " ", "\[Pi]", " ", 
    RowBox[{"C", "[", "1", "]"}]}]}]}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->82412204]
}, Open  ]],

Cell["Here is a way to make the dummy variable unique. ", "MathCaption",
 CellID->69226094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "==", "1"}], ",", "x", ",", 
   RowBox[{"GeneratedParameters", ":>", 
    RowBox[{"Unique", "[", "C", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->126584964],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C$489", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"2", " ", "\[Pi]", " ", 
    RowBox[{"C$489", "[", "1", "]"}]}]}]}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->697956972]
}, Open  ]],

Cell[TextData[{
 "Another place where unique objects are needed is in representing \
\[OpenCurlyDoubleQuote]constants of integration\[CloseCurlyDoubleQuote]. When \
you do an integral, you are effectively solving an equation for a derivative. \
In general, there are many possible solutions to the equation, differing by \
additive \[OpenCurlyDoubleQuote]constants of integration\
\[CloseCurlyDoubleQuote]. The standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " function always returns a solution with no constant of integration. But if \
you were to introduce constants of integration, you would need to use modules \
to make sure that they are always unique."
}], "Text",
 CellID->19413],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->321219383],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dummy Variables in Mathematics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/VariablesInPureFunctionsAndRules"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/BlocksAndLocalValues"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 56.9544852}", "context" -> "", 
    "keywords" -> {
     "constants of integration", "dummy variables", 
      "Einstein summation convention", "indices", "integration", 
      "summation convention", "summation variables", "tensors", "variables"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "When you set up mathematical formulas, you often have to introduce \
various kinds of local objects or 'dummy variables'. You can treat such dummy \
variables using modules and other Mathematica scoping constructs. Integration \
variables are a common example of dummy variables in mathematics. When you \
write down a formal integral, conventional notation requires you to introduce \
an integration variable with a definite name. This variable is essentially \
'local' to the integral, and its name, while arbitrary, must not conflict \
with any other names in your mathematical expression. Here is a function for \
evaluating an integral. ", "synonyms" -> {"2.7.5"}, "title" -> 
    "Dummy Variables in Mathematics", "type" -> "Tutorial", "uri" -> 
    "tutorial/DummyVariablesInMathematics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.5"->{
  Cell[1303, 44, 93, 2, 70, "Title",
   CellTags->{"S2.7.5", "5.1"},
   CellID->27415]},
 "5.1"->{
  Cell[1303, 44, 93, 2, 70, "Title",
   CellTags->{"S2.7.5", "5.1"},
   CellID->27415]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.5", 12850, 419},
 {"5.1", 12949, 423}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 678, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1303, 44, 93, 2, 70, "Title",
 CellTags->{"S2.7.5", "5.1"},
 CellID->27415],
Cell[1399, 48, 351, 9, 70, "Text",
 CellID->6085],
Cell[1753, 59, 461, 8, 70, "Text",
 CellID->318],
Cell[2217, 69, 85, 1, 70, "MathCaption",
 CellID->3580],
Cell[2305, 72, 321, 11, 70, "Input",
 CellID->1331],
Cell[2629, 85, 147, 5, 70, "MathCaption",
 CellID->7267],
Cell[CellGroupData[{
Cell[2801, 94, 116, 4, 28, "Input",
 CellID->8387],
Cell[2920, 100, 372, 13, 51, "Output",
 CellID->13444]
}, Open  ]],
Cell[3307, 116, 132, 4, 70, "MathCaption",
 CellID->23186],
Cell[3442, 122, 421, 15, 70, "Input",
 CellID->14507],
Cell[3866, 139, 206, 6, 70, "MathCaption",
 CellID->4360],
Cell[CellGroupData[{
Cell[4097, 149, 118, 4, 70, "Input",
 CellID->17827],
Cell[4218, 155, 382, 13, 51, "Output",
 CellID->28074]
}, Open  ]],
Cell[4615, 171, 382, 9, 70, "Text",
 CellID->26431],
Cell[5000, 182, 446, 8, 70, "Text",
 CellID->7152],
Cell[5449, 192, 151, 5, 70, "MathCaption",
 CellID->30271],
Cell[5603, 199, 315, 11, 70, "Input",
 CellID->10268],
Cell[5921, 212, 122, 3, 70, "MathCaption",
 CellID->4693],
Cell[CellGroupData[{
Cell[6068, 219, 147, 5, 70, "Input",
 CellID->19885],
Cell[6218, 226, 370, 12, 36, "Output",
 CellID->337]
}, Open  ]],
Cell[6603, 241, 669, 19, 70, "Text",
 CellID->31311],
Cell[7275, 262, 168, 6, 70, "MathCaption",
 CellID->555585135],
Cell[CellGroupData[{
Cell[7468, 272, 180, 6, 70, "Input",
 CellID->788473],
Cell[7651, 280, 348, 11, 36, "Output",
 CellID->82412204]
}, Open  ]],
Cell[8014, 294, 91, 1, 70, "MathCaption",
 CellID->69226094],
Cell[CellGroupData[{
Cell[8130, 299, 271, 8, 70, "Input",
 CellID->126584964],
Cell[8404, 309, 357, 11, 36, "Output",
 CellID->697956972]
}, Open  ]],
Cell[8776, 323, 829, 18, 70, "Text",
 CellID->19413],
Cell[CellGroupData[{
Cell[9630, 345, 72, 1, 70, "RelatedTutorialsSection",
 CellID->321219383],
Cell[9705, 348, 200, 5, 70, "RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],
Cell[9932, 357, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

