(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19907,        492]
NotebookOptionsPosition[     15540,        371]
NotebookOutlinePosition[     18684,        448]
CellTagsIndexPosition[     18592,        442]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Input and Output in Notebooks" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Editing and Evaluating Two\[Hyphen]Dimensional Expressions\
\>", "Title",
 CellTags->{"S1.10.3", "3.1"},
 CellID->5000],

Cell["\<\
When you see a two\[Hyphen]dimensional expression on the screen, you can edit \
it much as you would edit text. You can for example place your cursor \
somewhere and start typing. Or you can select a part of the expression, then \
remove it using the Delete key, or insert a new version by typing it in. \
\>", "Text",
 CellID->542],

Cell["\<\
In addition to ordinary text editing features, there are some keys that you \
can use to move around in two\[Hyphen]dimensional expressions. \
\>", "Text",
 CellID->17537],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox[".", "KeyEvent"]
    }], "TableText"], Cell[
    "select the next larger subexpression", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell[
    "move to the right of the current structure", "TableText"]},
   {Cell[TextData[StyleBox["\[RightArrow]", "KeyEvent"]], "TableText"], Cell[
    "move to the next character", "TableText"]},
   {Cell[TextData[StyleBox["\[LeftArrow]", "KeyEvent"]], "TableText"], Cell[
    "move to the previous character", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30038],

Cell["\<\
Ways to move around in two\[Hyphen]dimensional expressions. \
\>", "Caption",
 CellID->21388],

Cell[TextData[{
 "This shows the sequence of subexpressions selected by repeatedly typing ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[".", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->7355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{522, 401},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->13289],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Shift", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Enter", "KeyEvent"]
    }], "TableText"], Cell["evaluate the whole current cell", "TableText"]},
   {
    StyleBox[Cell[TextData[{
      StyleBox["Shift", "KeyEvent"],
      StyleBox["+", "KeyEventDelimiter"],
      StyleBox["Control", "KeyEvent"],
      StyleBox["+", "KeyEventDelimiter"],
      StyleBox["Enter", "KeyEvent"],
      "  or  ",
      StyleBox["Command", "KeyEvent"],
      StyleBox["+", "KeyEventDelimiter"],
      StyleBox["Return", "KeyEvent"]
     }], "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell["evaluate only the selected subexpression", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31647],

Cell["\<\
Ways to evaluate two\[Hyphen]dimensional expressions. \
\>", "Caption",
 CellID->3181],

Cell["\<\
In most computations, you will want to go from one step to the next by taking \
the whole expression that you have generated, and then evaluating it. But if \
for example you are trying to manipulate a single formula to put it into a \
particular form, you may instead find it more convenient to perform a \
sequence of operations separately on different parts of the expression.\
\>", "Text",
 CellID->13093],

Cell[TextData[{
 "You do this by selecting each part you want to operate on, then inserting \
the operation you want to perform, then using ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Control", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " or ",
 StyleBox["Command", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Return", "KeyEvent"],
 ". "
}], "Text",
 CellID->16584],

Cell["Here is an expression with one part selected.", "MathCaption",
 CellID->10987],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWr1uE0EQPt9v/BMHJ8hgGyE3gASdERVFOqhIhZTaCpFsJASYvAZ9aKAA
noMnCZ0fAApKjtvx3TfeY/d85G7POHKk23ze2Zmdv53bXfvZ+Gxy+mp8Nj0Z
D5/Oxm8m05N3wyevZ1GXU7Msu2FZ1tHQEjiMYNI4VhiG1mg0oocQNTuiqRHR
sq35fM6k+hIp4o9o1vn5B3pC0VLji8Y2PdKVRtI4UjVqSGlnNYe9sCsU5Ogx
zPGbhqgHbNm37FeM/VhQXVFp7gE5i0VD1SdCs2LCbSHoAZAHRMLfmhR+KhpP
fApMTjMlAU7ykR5vcya8k3gpokfIRwq4mNoBlROEOWyZ9waQW40BdxXT2EBO
Zl/8ek3+7MzBvjwR+aKvo67b2iDnOF+B9hDgIHMc2TIp3zwX2eOVZ9RgLZFy
ZcXy5qXWPEemrjsROVKurE6qRnCfLxvKdYMNPQBH5WsqpQShLlAL6DpiUZGK
VKUDnWK7smJVpsGxQolbFU5NeVLHNKmC3pOTj3c1L0vV5AWynSS9L1U48f/a
ityKvPIi21ikD7Fw+T1D25KRdXHxPSYkyBboUMHxtVTtuMA9AroPxNrFhASx
dimOrXaboR2fY+qZevLm4XGmlE+GdE/tuQqf5LpAqpPczhJvZHw8W7IkPYEc
UF1QmcOWebtAruxWRzmleQM/GgqTaq7Kzqs9BXUvNjTyNSR76dRO4qftSwmw
Mwf7QB7So6egEm/7f3NYucWnpTDP3Nm+jRWhOtv/eyoEciRzRJxRGwUhKBp7
cy4x9abhIlX2TYfqKkAVWC7AXnkx7WdGsjJ7zUetikudvNU6R3lW9Wmj68jU
vDV6rX6paJ0Wvufi1/81cORdp7y1Um2ouI83Y8zrI1bk1g44stdpOfd68ZR/
22s0aqmcUt2c8fulAz1XRSNx1wFQF6ip2w914HntGy5b0yZQak+jUtyUW2lm
7TVkE8mxrytcgc5xbaB9XY3ZXT25yj8qXcwfH1tI9r7sgZGcKzRkoDvwNiGF
v774kqACX2uqLlqa6LuJvtSVSx16DnSXLw3o2Uff55S3xf/L6/4cM9A3pIco
grcFOgL1WzzDcowLOY1E/IxzZVlqcZtIxo+kZhbVcVN/jbBlvww7//CrJhqz
7Gv9ORn/eKwhmpqS1FyQFqJrfwDSYctN\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{522, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->10761],

Cell[TextData[{
 "Pressing ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Control", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " evaluates the selected part."
}], "MathCaption",
 CellID->20493],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWktv00AQdmzHdh6tkyD1kXDIAaiAAyiAhDhRhKA9ACd6jyKkFIpApQjx
JzgXib+XHwBI3KB418k33dXYcmR7zSNVO5nMa2dmx2Pv1E/GJ9MXr8cnh5Px
8PHx+O30cPJu+OjNcURyapZlNy3Leji0BH4WoXNwFv3GoC1AJBcTRqORBA0B
ajHLcuTnbDaTfyQU8EKnp58joQhK4Algm5W0Y8noqwQ1AZwsOnYcW0T/JYAB
nZ+S6YI9/1sZMGXgQNBdcVFcAebEGymvlgibClAX37y8C9nC6DVgdWByoVdS
1Vl8nS+2WvKPW/LSoiJiKx6KxsXiDrhUUqRhq7obwFxTIVxmFrKBOam0udHF
j50q7KkLyWxsJ3Grj9fPKOcx2Do22U+Vk9G8LCNAFzVULy6sfkW75aquZa3O
xAAdlVt9OdJuuapDWrcgmqeGSh2EQu1Bo4Jri9y4AGwDWFvlOkadlD3bT3Jt
jXHcmGsHjBsDo4vLemlgIa3Bb6lFSE9GRwX7MkHdS1ufCjYvLfxYGS3SaIiK
uIUqoSfpfZTUe2APwN0B9qxgr9ax2h1g9HS4B+wDsF1g14GtvDrfDneAUaP4
COx+5Z7SozPdZ64CCxifSeMe4z1x90uLQ7vRl3yQaKmYlPMRm4XY6qovWv7c
jLpBKnd9aa4HbouJzS84k5upmdwrrSK41So9l3WBkZONpO2hZGunDi+jbjo3
XJrrg0tNIawyxdxhqug+ucYEWNWpl8qHjqXcVcvpJtI0jYChcV4RjboZ5Spr
WeTJVZgab3n3S+p6JoYDWVtG1j1P122mcjtLcxNro5T8DRiaiTqoaq7yj95O
jOXUxP0jsW/kHlPR000HGhRHD1gL3C5jL2D8I7kOMO1m7ahcG3nuMf5R7sOC
c6Ctq+Wg5L3Uao0bhZFGF55ye9QGl2oyUPMnuTdAo36g7Qw37AozuttKMtpj
vC8vu1IicbzYQpVQ/jwmrDaTqyaTnJvAKHVbaiVSEtO94lLHzUBNHObbTJuj
schdJjl99eKUtF01QMm9WFoc3ACsBRqNTmkUdjsp7ZtJjD7sUUOhMRoVyAC0
pwtarv9ZP4flL/BgGxjllAbY+nRafObxQFr5PjdwfstyRiaNfJPMumK3MKe/
CuAV4uff/YbFf26A3pcyplvd21fxC2KLF6/8+O2rDJJBLBkL1X4DAUeu9g==
\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{522, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->8217],

Cell[TextData[{
 "The ",
 StyleBox["AlgebraicManipulation", "DialogElementName"],
 " palette also provides a number of convenient operations which will \
transform in place any selected subexpression."
}], "Text",
 CellID->80219132],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->582449302],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Editing and Evaluating Two-Dimensional Expressions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/EnteringTwoDimensionalInput"],
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/EnteringFormulas"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 57.3138694}", "context" -> "", 
    "keywords" -> {
     "arrow keys", "control", "editing", "evaluation", "expand selection", 
      "extend selection", "in-place evaluation", "motion keys", 
      "mouse selection", "parent subexpression", "selection", 
      "ShiftControlEnter", "ShiftEnter", "subtree", "tree"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When you see a two-dimensional expression on the screen, you can edit it \
much as you would edit text. You can for example place your cursor somewhere \
and start typing. Or you can select a part of the expression, then remove it \
using the Delete key, or insert a new version by typing it in. In addition to \
ordinary text editing features, there are some keys that you can use to move \
around in two-dimensional expressions. Ways to move around in two-dimensional \
expressions. ", "synonyms" -> {"1.10.3"}, "title" -> 
    "Editing and Evaluating Two-Dimensional Expressions", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/EditingAndEvaluatingTwoDimensionalExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.3"->{
  Cell[1286, 44, 129, 4, 70, "Title",
   CellTags->{"S1.10.3", "3.1"},
   CellID->5000]},
 "3.1"->{
  Cell[1286, 44, 129, 4, 70, "Title",
   CellTags->{"S1.10.3", "3.1"},
   CellID->5000]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.3", 18379, 431},
 {"3.1", 18479, 435}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 661, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1286, 44, 129, 4, 70, "Title",
 CellTags->{"S1.10.3", "3.1"},
 CellID->5000],
Cell[1418, 50, 342, 6, 70, "Text",
 CellID->542],
Cell[1763, 58, 181, 4, 70, "Text",
 CellID->17537],
Cell[1947, 64, 1058, 25, 70, "DefinitionBox",
 CellID->30038],
Cell[3008, 91, 103, 3, 70, "Caption",
 CellID->21388],
Cell[3114, 96, 227, 7, 70, "MathCaption",
 CellID->7355],
Cell[3344, 105, 6246, 106, 70, "Picture",
 Evaluatable->False,
 CellID->13289],
Cell[9593, 213, 1239, 32, 70, "DefinitionBox",
 CellID->31647],
Cell[10835, 247, 96, 3, 70, "Caption",
 CellID->3181],
Cell[10934, 252, 419, 7, 70, "Text",
 CellID->13093],
Cell[11356, 261, 461, 14, 70, "Text",
 CellID->16584],
Cell[11820, 277, 84, 1, 70, "MathCaption",
 CellID->10987],
Cell[11907, 280, 1377, 26, 70, "Picture",
 Evaluatable->False,
 CellID->10761],
Cell[13287, 308, 269, 9, 70, "MathCaption",
 CellID->20493],
Cell[13559, 319, 1405, 27, 70, "Picture",
 Evaluatable->False,
 CellID->8217],
Cell[14967, 348, 232, 6, 70, "Text",
 CellID->80219132],
Cell[CellGroupData[{
Cell[15224, 358, 72, 1, 70, "RelatedTutorialsSection",
 CellID->582449302],
Cell[15299, 361, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],
Cell[15513, 369, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

