(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35931,       1302]
NotebookOptionsPosition[     29510,       1081]
NotebookOutlinePosition[     31666,       1139]
CellTagsIndexPosition[     31573,       1133]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"CharacteristicPolynomial" :> 
         Documentation`HelpLookup["paclet:ref/CharacteristicPolynomial"], 
         "Eigensystem" :> Documentation`HelpLookup["paclet:ref/Eigensystem"], 
         "Eigenvalues" :> Documentation`HelpLookup["paclet:ref/Eigenvalues"], 
         "Eigenvectors" :> 
         Documentation`HelpLookup["paclet:ref/Eigenvectors"], "N" :> 
         Documentation`HelpLookup["paclet:ref/N"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"CharacteristicPolynomial\"\>", 
      2->"\<\"Eigensystem\"\>", 3->"\<\"Eigenvalues\"\>", 
      4->"\<\"Eigenvectors\"\>", 5->"\<\"N\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eigenvalues and Eigenvectors", "Title",
 CellTags->{"S3.7.9", "9.1"},
 CellID->9501],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Eigenvalues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvalues"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "a list of the eigenvalues of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvectors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvectors"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "a list of the eigenvectors of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigensystem",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigensystem"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "a list of the form ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["eigenvalues", "TI"], ",", 
       StyleBox["eigenvectors", "TI"], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Eigenvalues",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Eigenvalues"], "[", 
      RowBox[{
       ButtonBox["N",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/N"], "[", 
       StyleBox["m", "TI"], "]"}], "]"}], Cell[", etc.", "TableText"]}], Cell[
    "numerical eigenvalues", "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Eigenvalues",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Eigenvalues"], "[", 
      RowBox[{
       ButtonBox["N",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/N"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}], "]"}], Cell[", etc.", "TableText"]}], 
    Cell[TextData[{
     "numerical eigenvalues, starting with ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "\[Hyphen]digit precision"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CharacteristicPolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacteristicPolynomial"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the characteristic polynomial of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17482],

Cell["Eigenvalues and eigenvectors. ", "Caption",
 CellID->29447],

Cell[TextData[{
 "The eigenvalues of a matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath"],
 " are the values ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Lambda]", "i"], TraditionalForm]], "InlineMath"],
 " for which one can find nonzero vectors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v", "TB"], "i"], TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m", "TB"], ".", 
    SubscriptBox[
     StyleBox["v", "TB"], "i"], "=", 
    SubscriptBox["\[Lambda]", "i"], 
    SubscriptBox[
     StyleBox["v", "TB"], "i"]}], TraditionalForm]], "InlineMath"],
 ". The eigenvectors are the vectors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v", "TB"], "i"], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->15665],

Cell[TextData[{
 "The ",
 StyleBox["characteristic polynomial",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    ButtonBox["CharacteristicPolynomial",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacteristicPolynomial"], "[", 
    RowBox[{
     StyleBox["m", "TI"], ",", 
     StyleBox["x", "TI"]}], "]"}]}]], "InlineFormula"],
 " for an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"], "[", 
   RowBox[{
    StyleBox["m", "TI"], "-", 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     RowBox[{
      ButtonBox["IdentityMatrix",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/IdentityMatrix"], "[", 
      StyleBox["n", "TI"], "]"}]}]}], "]"}]], "InlineFormula"],
 ". The eigenvalues are the roots of this polynomial. "
}], "Text",
 CellID->10753],

Cell[TextData[{
 "Finding the eigenvalues of an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix in general involves solving an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 "\[Hyphen]degree polynomial equation. For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[GreaterEqual]", "5"}], TraditionalForm]], "InlineMath"],
 ", therefore, the results cannot in general be expressed purely in terms of \
explicit radicals. ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects can nevertheless always be used, although except for fairly sparse \
or otherwise simple matrices the expressions obtained are often unmanageably \
complex."
}], "Text",
 CellID->22104],

Cell["\<\
Even for a matrix as simple as this, the explicit form of the eigenvalues is \
quite complicated. \
\>", "MathCaption",
 CellID->15084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"2", "a"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->19095],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "a"}], "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"]}]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "a"}], "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"]}]}]]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{278, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->13525]
}, Open  ]],

Cell[TextData[{
 "If you give a matrix of approximate real numbers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will find the approximate numerical eigenvalues and eigenvectors. "
}], "Text",
 CellID->30221],

Cell["\<\
Here is a 2\[Times]2 numerical matrix. \
\>", "MathCaption",
 CellID->3964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2.3", ",", "4.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6.7", ",", 
      RowBox[{"-", "1.2"}]}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->21781],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.3`", ",", "4.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.7`", ",", 
     RowBox[{"-", "1.2`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->4872]
}, Open  ]],

Cell["The matrix has two eigenvalues, in this case both real. ", "MathCaption",
 CellID->8106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "m", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->3656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.313028717610211`", ",", 
   RowBox[{"-", "5.213028717610212`"}]}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->3343]
}, Open  ]],

Cell[TextData[{
 "Here are the two eigenvectors of ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->27080],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.7463353736931401`", ",", "0.665570063910871`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5138392648448873`"}], ",", "0.8578864784478573`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->16080]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eigensystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigensystem"]], "InlineFormula"],
 " computes the eigenvalues and eigenvectors at the same time. The assignment \
sets ",
 Cell[BoxData["vals"], "InlineFormula"],
 " to the list of eigenvalues, and ",
 Cell[BoxData["vecs"], "InlineFormula"],
 " to the list of eigenvectors. "
}], "MathCaption",
 CellID->14868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
  RowBox[{"Eigensystem", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->21411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6.313028717610211`", ",", 
     RowBox[{"-", "5.213028717610212`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7463353736931401`", ",", "0.665570063910871`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5138392648448873`"}], ",", "0.8578864784478573`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->13713]
}, Open  ]],

Cell["\<\
This verifies that the first eigenvalue and eigenvector satisfy the \
appropriate condition. \
\>", "MathCaption",
 CellID->20968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", ".", 
   RowBox[{"vecs", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "==", 
  RowBox[{
   RowBox[{"vals", "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", 
   RowBox[{"vecs", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->3251],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->27216]
}, Open  ]],

Cell["\<\
This finds the eigenvalues of a random 4\[Times]4 matrix. For nonsymmetric \
matrices, the eigenvalues can have imaginary parts.\
\>", "MathCaption",
 CellID->12079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RandomReal", "[", "]"}], ",", 
    RowBox[{"{", "4", "}"}], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->28768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.30021506699942`", ",", 
   RowBox[{"0.3197643687884096`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.5471987005585399`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.3197643687884096`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.5471987005585399`", " ", "\[ImaginaryI]"}]}], ",", 
   "0.44929072781246243`"}], "}"}]], "Output",
 ImageSize->{428, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->17040]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Eigenvalues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvalues"]], "InlineFormula"],
 " always gives you a list of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " eigenvalues for an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "\[Times]",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " matrix. The eigenvalues correspond to the roots of the characteristic \
polynomial for the matrix, and may not necessarily be distinct. ",
 Cell[BoxData[
  ButtonBox["Eigenvectors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvectors"]], "InlineFormula"],
 ", on the other hand, gives a list of eigenvectors which are guaranteed to \
be independent. If the number of such eigenvectors is less than ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  ButtonBox["Eigenvectors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvectors"]], "InlineFormula"],
 " appends zero vectors to the list it returns, so that the total length of \
the list is always ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->31531],

Cell["Here is a 3\[Times]3 matrix. ", "MathCaption",
 CellID->12933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mz", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->23779],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->132041750]
}, Open  ]],

Cell["The matrix has three eigenvalues, all equal to zero. ", "MathCaption",
 CellID->12259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "mz", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->26653],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->27936]
}, Open  ]],

Cell[TextData[{
 "There is, however, only one independent eigenvector for the matrix. ",
 Cell[BoxData[
  ButtonBox["Eigenvectors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvectors"]], "InlineFormula"],
 " appends two zero vectors to give a total of three vectors in this case. "
}], "MathCaption",
 CellID->2095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", "mz", "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->24365],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->11874]
}, Open  ]],

Cell["This gives the characteristic polynomial of the matrix.", "MathCaption",
 CellID->39611851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{"mz", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->182071307],

Cell[BoxData[
 RowBox[{"-", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->27061715]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Eigenvalues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvalues"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the largest ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " eigenvalues of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvectors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvectors"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the corresponding eigenvectors of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigensystem",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigensystem"], "[", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["k", "TI"]}], "]"}], Cell[TextData[{
     "the largest ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " eigenvalues with corresponding eigenvectors"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvalues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvalues"], "[", 
     StyleBox["m", "TI"], ",", "-", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the smallest ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " eigenvalues of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvectors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvectors"], "[", 
     StyleBox["m", "TI"], ",", "-", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the corresponding eigenvectors of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigensystem",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigensystem"], "[", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      RowBox[{"-", 
       StyleBox["k", "TI"]}]}], "]"}], Cell[TextData[{
     "the smallest ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " eigenvalues with corresponding eigenvectors"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7720],

Cell["Finding largest and smallest eigenvalues. ", "Caption",
 CellID->26835],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eigenvalues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvalues"]], "InlineFormula"],
 " sorts numeric eigenvalues so that the ones with large absolute value come \
first. In many situations, you may be interested only in the largest or \
smallest eigenvalues of a matrix. You can get these efficiently using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{"-", 
     StyleBox["k", "TI"]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->25680],

Cell["This computes the exact eigenvalues of an integer matrix. ", \
"MathCaption",
 CellID->8976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->18455],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      SqrtBox["33"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "-", 
      SqrtBox["33"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{187, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->5725]
}, Open  ]],

Cell["The eigenvalues are sorted in decreasing order of size. ", "MathCaption",
 CellID->4071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->24808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.372281323269014`", ",", 
   RowBox[{"-", "0.3722813232690143`"}]}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->13559]
}, Open  ]],

Cell["\<\
This gives the three eigenvalues with largest absolute value. \
\>", "MathCaption",
 CellID->9156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{"Tan", "[", 
       RowBox[{"i", "/", "j"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "10"}], "}"}]}], "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->5602],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.044003451118863`", ",", 
   RowBox[{"2.9439646789164517`", "\[InvisibleSpace]", "+", 
    RowBox[{"6.037276203776878`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"2.9439646789164517`", "\[InvisibleSpace]", "-", 
    RowBox[{"6.037276203776878`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{326, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->17832]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Eigenvalues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvalues"], "[", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["a", "TI"], "}", "]"}], Cell[TextData[{
     "the generalized eigenvalues of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvectors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvectors"], "[", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["a", "TI"], "}", "]"}], Cell[TextData[{
     "the generalized eigenvectors of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigensystem",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigensystem"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["m", "TI"], ",", 
       StyleBox["a", "TI"]}], "}"}], "]"}], Cell[TextData[{
     "the generalized eigensystem of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CharacteristicPolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacteristicPolynomial"], "[", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["a", "TI"], "}", ",", 
     StyleBox["x", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the generalized characteristic polynomial of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7905],

Cell["\<\
Generalized eigenvalues, eigenvectors, and characteristic polynomial. \
\>", "Caption",
 CellID->10440],

Cell[TextData[{
 "The generalized eigenvalues for a matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath"],
 " with respect to a matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TB"], TraditionalForm]], "InlineMath"],
 " are defined to be those ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Lambda]", "i"], TraditionalForm]], "InlineMath"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m", "TB"], ".", 
    SubscriptBox[
     StyleBox["v", "TB"], "i"], "=", 
    SubscriptBox["\[Lambda]", "i"], 
    StyleBox["a", "TB"], ".", 
    SubscriptBox[
     StyleBox["v", "TB"], "i"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->7375],

Cell[TextData[{
 "The generalized eigenvalues correspond to zeros of the generalized \
characteristic polynomial ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"], "[", 
   RowBox[{
    StyleBox["m", "TI"], "-", 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox["a", "TI"]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21562],

Cell[TextData[{
 "Note that while ordinary matrix eigenvalues always have definite values, \
some generalized eigenvalues will always be ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " if the generalized characteristic polynomial vanishes, which happens if ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TB"], TraditionalForm]], "InlineMath"],
 " share a null space. Note also that generalized eigenvalues can be \
infinite."
}], "Text",
 CellID->22885],

Cell[TextData[{
 "These two matrices share a one\[Hyphen]dimensional null space, so one \
generalized eigenvalue is ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.5", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->21080],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "Indeterminate"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->1836]
}, Open  ]],

Cell["This gives a generalized characteristic polynomial.", "MathCaption",
 CellID->11002783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.5", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0"}], "}"}]}], "}"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->135298306],

Cell[BoxData[
 RowBox[{"1.5`", "\[InvisibleSpace]", "-", 
  RowBox[{"2.`", " ", "x"}]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->40887788]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eigenvalues and Eigenvectors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 59.8451842}", "context" -> "", 
    "keywords" -> {
     "CharacteristicPolynomial", "Eigensystem", "Eigenvalues", "Eigenvectors",
       "EISPACK", "generalized eigenvalues", "LAPACK", "matrices", 
      "matrix pencils", "multiplicity", "similarity transformation", 
      "singular eigenvalue problem"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Eigenvalues and eigenvectors. The eigenvalues of a matrix m are the \
values \\[Lambda]_i for which one can find nonzero vectors v_i such that \
m.v_i=\\[Lambda]_iv_i. The eigenvectors are the vectors v_i. The \
characteristic polynomial CharacteristicPolynomial[m,x] for an nxn matrix is \
given by Det[m-x IdentityMatrix[n]]. The eigenvalues are the roots of this \
polynomial. ", "synonyms" -> {"3.7.9"}, "title" -> 
    "Eigenvalues and Eigenvectors", "type" -> "Tutorial", "uri" -> 
    "tutorial/EigenvaluesAndEigenvectors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.7.9"->{
  Cell[1643, 48, 90, 2, 70, "Title",
   CellTags->{"S3.7.9", "9.1"},
   CellID->9501]},
 "9.1"->{
  Cell[1643, 48, 90, 2, 70, "Title",
   CellTags->{"S3.7.9", "9.1"},
   CellID->9501]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.7.9", 31364, 1122},
 {"9.1", 31462, 1126}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1018, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1643, 48, 90, 2, 70, "Title",
 CellTags->{"S3.7.9", "9.1"},
 CellID->9501],
Cell[1736, 52, 2807, 88, 70, "DefinitionBox",
 CellID->17482],
Cell[4546, 142, 65, 1, 70, "Caption",
 CellID->29447],
Cell[4614, 145, 847, 31, 70, "Text",
 CellID->15665],
Cell[5464, 178, 974, 35, 70, "Text",
 CellID->10753],
Cell[6441, 215, 892, 25, 70, "Text",
 CellID->22104],
Cell[7336, 242, 145, 4, 70, "MathCaption",
 CellID->15084],
Cell[CellGroupData[{
Cell[7506, 250, 297, 11, 28, "Input",
 CellID->19095],
Cell[7806, 263, 719, 27, 52, "Output",
 CellID->13525]
}, Open  ]],
Cell[8540, 293, 218, 6, 70, "Text",
 CellID->30221],
Cell[8761, 301, 85, 3, 70, "MathCaption",
 CellID->3964],
Cell[CellGroupData[{
Cell[8871, 308, 268, 10, 70, "Input",
 CellID->21781],
Cell[9142, 320, 331, 12, 36, "Output",
 CellID->4872]
}, Open  ]],
Cell[9488, 335, 94, 1, 70, "MathCaption",
 CellID->8106],
Cell[CellGroupData[{
Cell[9607, 340, 103, 3, 70, "Input",
 CellID->3656],
Cell[9713, 345, 253, 8, 36, "Output",
 CellID->3343]
}, Open  ]],
Cell[9981, 356, 132, 5, 70, "MathCaption",
 CellID->22593],
Cell[CellGroupData[{
Cell[10138, 365, 105, 3, 70, "Input",
 CellID->27080],
Cell[10246, 370, 396, 13, 36, "Output",
 CellID->16080]
}, Open  ]],
Cell[10657, 386, 417, 12, 70, "MathCaption",
 CellID->14868],
Cell[CellGroupData[{
Cell[11099, 402, 180, 6, 70, "Input",
 CellID->21411],
Cell[11282, 410, 567, 19, 36, "Output",
 CellID->13713]
}, Open  ]],
Cell[11864, 432, 140, 4, 70, "MathCaption",
 CellID->20968],
Cell[CellGroupData[{
Cell[12029, 440, 306, 11, 70, "Input",
 CellID->3251],
Cell[12338, 453, 158, 5, 36, "Output",
 CellID->27216]
}, Open  ]],
Cell[12511, 461, 175, 4, 70, "MathCaption",
 CellID->12079],
Cell[CellGroupData[{
Cell[12711, 469, 254, 8, 70, "Input",
 CellID->28768],
Cell[12968, 479, 496, 12, 36, "Output",
 CellID->17040]
}, Open  ]],
Cell[13479, 494, 1236, 36, 70, "Text",
 CellID->31531],
Cell[14718, 532, 68, 1, 70, "MathCaption",
 CellID->12933],
Cell[CellGroupData[{
Cell[14811, 537, 329, 11, 70, "Input",
 CellID->23779],
Cell[15143, 550, 391, 13, 36, "Output",
 CellID->132041750]
}, Open  ]],
Cell[15549, 566, 92, 1, 70, "MathCaption",
 CellID->12259],
Cell[CellGroupData[{
Cell[15666, 571, 105, 3, 70, "Input",
 CellID->26653],
Cell[15774, 576, 210, 7, 36, "Output",
 CellID->27936]
}, Open  ]],
Cell[15999, 586, 326, 8, 70, "MathCaption",
 CellID->2095],
Cell[CellGroupData[{
Cell[16350, 598, 107, 3, 70, "Input",
 CellID->24365],
Cell[16460, 603, 389, 13, 36, "Output",
 CellID->11874]
}, Open  ]],
Cell[16864, 619, 97, 1, 70, "MathCaption",
 CellID->39611851],
Cell[CellGroupData[{
Cell[16986, 624, 144, 4, 70, "Input",
 CellID->182071307],
Cell[17133, 630, 198, 7, 36, "Output",
 CellID->27061715]
}, Open  ]],
Cell[17346, 640, 2645, 86, 70, "DefinitionBox",
 CellID->7720],
Cell[19994, 728, 77, 1, 70, "Caption",
 CellID->26835],
Cell[20074, 731, 875, 28, 70, "Text",
 CellID->25680],
Cell[20952, 761, 98, 2, 70, "MathCaption",
 CellID->8976],
Cell[CellGroupData[{
Cell[21075, 767, 254, 9, 70, "Input",
 CellID->18455],
Cell[21332, 778, 431, 17, 51, "Output",
 CellID->5725]
}, Open  ]],
Cell[21778, 798, 94, 1, 70, "MathCaption",
 CellID->4071],
Cell[CellGroupData[{
Cell[21897, 803, 95, 3, 70, "Input",
 CellID->24808],
Cell[21995, 808, 256, 8, 36, "Output",
 CellID->13559]
}, Open  ]],
Cell[22266, 819, 108, 3, 70, "MathCaption",
 CellID->9156],
Cell[CellGroupData[{
Cell[22399, 826, 396, 13, 70, "Input",
 CellID->5602],
Cell[22798, 841, 466, 12, 36, "Output",
 CellID->17832]
}, Open  ]],
Cell[23279, 856, 2362, 72, 70, "DefinitionBox",
 CellID->7905],
Cell[25644, 930, 113, 3, 70, "Caption",
 CellID->10440],
Cell[25760, 935, 713, 26, 70, "Text",
 CellID->7375],
Cell[26476, 963, 403, 15, 70, "Text",
 CellID->21562],
Cell[26882, 980, 634, 18, 70, "Text",
 CellID->22885],
Cell[27519, 1000, 288, 9, 70, "MathCaption",
 CellID->21962],
Cell[CellGroupData[{
Cell[27832, 1013, 476, 17, 70, "Input",
 CellID->21080],
Cell[28311, 1032, 215, 7, 36, "Output",
 CellID->1836]
}, Open  ]],
Cell[28541, 1042, 93, 1, 70, "MathCaption",
 CellID->11002783],
Cell[CellGroupData[{
Cell[28659, 1047, 566, 19, 70, "Input",
 CellID->135298306],
Cell[29228, 1068, 228, 7, 36, "Output",
 CellID->40887788]
}, Open  ]]
}, Open  ]],
Cell[29483, 1079, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

