(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23506,        846]
NotebookOptionsPosition[     17397,        653]
NotebookOutlinePosition[     20440,        730]
CellTagsIndexPosition[     20349,        724]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Equations and Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Equations and Inequalities\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Eliminate" :> Documentation`HelpLookup["paclet:ref/Eliminate"],
           "Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], 
          "SolveAlways" :> 
          Documentation`HelpLookup["paclet:ref/SolveAlways"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Eliminate\"\>", 2->"\<\"Solve\"\>", 
       3->"\<\"SolveAlways\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eliminating Variables", "Title",
 CellTags->{"S3.4.6", "6.1"},
 CellID->1009],

Cell[TextData[{
 "When you write down a set of simultaneous equations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you are specifying a collection of constraints between variables. When \
you use ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ", you are finding values for some of the variables in terms of others, \
subject to the constraints represented by the equations."
}], "Text",
 CellID->22012],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Solve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Solve"], "[", 
     StyleBox["eqns", "TI"], ",", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["elims", "TI"], "]"}], Cell[TextData[{
     "find solutions for ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     ", eliminating the variables ",
     Cell[BoxData[
      StyleBox["elims", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eliminate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eliminate"], "[", 
     StyleBox["eqns", "TI"], ",", 
     StyleBox["elims", "TI"], "]"}], Cell[TextData[{
     "rearrange equations to eliminate the variables ",
     Cell[BoxData[
      StyleBox["elims", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18136],

Cell["Eliminating variables. ", "Caption",
 CellID->11455],

Cell[TextData[{
 "Here are two equations involving ",
 Cell[BoxData["x"], "InlineFormula"],
 ", ",
 Cell[BoxData["y"], "InlineFormula"],
 " and the \[OpenCurlyDoubleQuote]parameters\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "==", 
     RowBox[{
      RowBox[{"6", "a"}], "+", 
      RowBox[{"3", "b"}]}]}], ",", 
    RowBox[{"y", "==", 
     RowBox[{
      RowBox[{"9", "a"}], "+", 
      RowBox[{"2", " ", "x"}]}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25043],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "+", "y"}], "\[Equal]", 
    RowBox[{
     RowBox[{"6", " ", "a"}], "+", 
     RowBox[{"3", " ", "b"}]}]}], ",", 
   RowBox[{"y", "\[Equal]", 
    RowBox[{
     RowBox[{"9", " ", "a"}], "+", 
     RowBox[{"2", " ", "x"}]}]}]}], "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1476466119]
}, Open  ]],

Cell[TextData[{
 "If you solve for both ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ", you get results in terms of ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqn", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17922],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      RowBox[{"7", " ", "a"}], "+", 
      RowBox[{"2", " ", "b"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1372636057]
}, Open  ]],

Cell[TextData[{
 "Similarly, if you solve for ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["a"], "InlineFormula"],
 ", you get results in terms of ",
 Cell[BoxData["y"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqn", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26018],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "7"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"9", " ", "b"}], "-", "y"}], ")"}]}]}], ",", 
    RowBox[{"a", "\[Rule]", 
     RowBox[{
      FractionBox["1", "7"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "b"}], "+", "y"}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{227, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->852008846]
}, Open  ]],

Cell[TextData[{
 "If you only want to solve for ",
 Cell[BoxData["x"], "InlineFormula"],
 ", however, you have to specify whether you want to eliminate ",
 Cell[BoxData["y"], "InlineFormula"],
 " or ",
 Cell[BoxData["a"], "InlineFormula"],
 " or ",
 Cell[BoxData["b"], "InlineFormula"],
 ". This eliminates ",
 Cell[BoxData["y"], "InlineFormula"],
 ", and so gives the result in terms of ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqn", ",", "x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "a"}], "+", "b"}]}], "}"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->128537120]
}, Open  ]],

Cell[TextData[{
 "If you eliminate ",
 Cell[BoxData["a"], "InlineFormula"],
 ", then you get a result in terms of ",
 Cell[BoxData["y"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqn", ",", "x", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->3335],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     FractionBox["1", "7"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"9", " ", "b"}], "-", "y"}], ")"}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{120, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1009754827]
}, Open  ]],

Cell[TextData[{
 "In some cases, you may want to construct explicitly equations in which \
variables have been eliminated. You can do this using ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->3169],

Cell[TextData[{
 "This combines the two equations in the list ",
 Cell[BoxData["eqn"], "InlineFormula"],
 ", by eliminating the variable ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"eqn", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5303],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"9", " ", "b"}], "-", "y"}], "\[Equal]", 
  RowBox[{"7", " ", "x"}]}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1231085242]
}, Open  ]],

Cell[TextData[{
 "This is what you get if you eliminate ",
 Cell[BoxData["y"], "InlineFormula"],
 " instead of ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"eqn", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->24199],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "-", "x"}], "\[Equal]", "a"}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1591099774]
}, Open  ]],

Cell[TextData[{
 "As a more sophisticated example of ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 ", consider the problem of writing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "5"], "+", 
    SuperscriptBox["y", "5"]}], TraditionalForm]], "InlineMath"],
 " in terms of the \[OpenCurlyDoubleQuote]symmetric polynomials\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "y"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"x", "y"}], "TI"], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->24791],

Cell[TextData[{
 "To solve the problem, we simply have to write ",
 Cell[BoxData["f"], "InlineFormula"],
 " in terms of ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 ", eliminating the original variables ",
 Cell[BoxData["x"], "InlineFormula"],
 " and\[NonBreakingSpace]",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "==", 
      RowBox[{
       RowBox[{"x", "^", "5"}], "+", 
       RowBox[{"y", "^", "5"}]}]}], ",", 
     RowBox[{"a", "==", 
      RowBox[{"x", "+", "y"}]}], ",", 
     RowBox[{"b", "==", 
      RowBox[{"x", " ", "y"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->8681],

Cell[BoxData[
 RowBox[{"f", "\[Equal]", 
  RowBox[{
   SuperscriptBox["a", "5"], "-", 
   RowBox[{"5", " ", 
    SuperscriptBox["a", "3"], " ", "b"}], "+", 
   RowBox[{"5", " ", "a", " ", 
    SuperscriptBox["b", "2"]}]}]}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->945004600]
}, Open  ]],

Cell[TextData[{
 "In dealing with sets of equations, it is common to consider some of the \
objects that appear as true \[OpenCurlyDoubleQuote]variables\
\[CloseCurlyDoubleQuote], and others as \[OpenCurlyDoubleQuote]parameters\
\[CloseCurlyDoubleQuote]. In some cases, you may need to know for what values \
of parameters a particular relation between the variables is ",
 StyleBox["always",
  FontSlant->"Italic"],
 " satisfied. "
}], "Text",
 CellID->8753],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SolveAlways",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SolveAlways"], "[", 
     StyleBox["eqns", "TI"], ",", 
     StyleBox["vars", "TI"], "]"}], Cell[TextData[{
     "solve for the values of parameters for which the ",
     Cell[BoxData[
      StyleBox["eqns", "TI"]], "InlineFormula"],
     " are satisfied for all values of the ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24033],

Cell["Solving for parameters that make relations always true. ", "Caption",
 CellID->32029],

Cell[TextData[{
 "This finds the values of parameters that make the equation hold for all ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"x", "^", "2"}]}]}], "==", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "^", "2"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->7042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "1"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->2111796092]
}, Open  ]],

Cell["This equates two series. ", "MathCaption",
 CellID->20083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", "x"}], "]"}]}], "+", 
     RowBox[{"Cos", "[", 
      RowBox[{"3", "x"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}], "==", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Cosh", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->527918693],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWNtuEzEQddabtHQDSW+o4qlQUC+KaNWbRCgo8AAP0BfEEzygqIImhaqo
7YfwJfxCPs34Mqa7Z2d33SZURMraY8+csc+Mndkc9i8HX0/7l8Oj/vLb8/7P
wfDoYvnN2bkekjUhaq+EEA+XhO4r3bNf83mtv67rep/0s64n56n9Re2enT00
T+ltlZgxj/pf2eo42/zoI7D9zmo5P+9BtwnyIsiPOeyUvM+i3q1AXQH5B8j8
Wu9VoCIPpyDvWtR3MNoeE3WHRW2yMeDjhxwPWa091o9h2oiL1D6B+RMad3Gq
w+xTkOdAxqxc1Y9Iiwm1H0G2WStisNoCeTbAS1pOQP5QMT9tVyFhNFLuvDVg
vFEwHtM4cjbF2KflLtkV2cfEVUQtnsAGRczaxeksSFshx0vkDVf3YCLoPKOo
hUxYH7k8xhXyWogdwnoeJQwbuNAdvL/CcKIcDsY+Ifadqf9MV+wVYzip1YRF
NZPHLMPFsxzT3FnzZ9Ppj0YjYsYs38qkJzP2oXqQNZWrNFr+ZIbvTZIV+uSi
x+3hjt1Dr9eDPYzn/WYn18jxPzurBzdC9VHBKmA8fm7zRE42RuG3q7/Zc7fD
NWL2glldCO7t3a0Yk//rFm0pl2ftFJ7LNcTDevQlyLISASuMheKdBlcAyF5n
ApiOOe6UlNXfuFusJksqgZL8blJ8WsX7Kqk4JVkvhLMUgGZzr6BSW1H8XYIV
/HN1Ve9FzM2G1Wcb9JMSP2Z8M1C/ZveCby9Y+ePdsKHc79AXaiMWxcfuvnK/
mPh2yaF62cRjTWXzdBvmJeu1xTFf+W7XBOwO+VzPRll3dmmG9463xGyQd2Si
A7JnYp+NHvffQUxZHzO8Dwity1on7Ir5N2REPs6x9ewaPsx6JcPON5XNg4j0
3Bt+2D80XdA6A9lhfSbk3zBrM88KGKmrGcygnQAb9w+UqP0B9Crh6w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{321, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->121726438]
}, Open  ]],

Cell["This finds values of the undetermined coefficients. ", "MathCaption",
 CellID->32718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->12244],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     FractionBox["10", "3"]}], ",", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["10", "3"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{134, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->423016630]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->43671172],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eliminating Variables - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GenericAndNonGenericSolutions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 1.7983592}", "context" -> "", 
    "keywords" -> {
     "back solving", "eliminate variables", "eliminating variables", 
      "elimination", "equations", "method of undetermined coefficients", 
      "series", "simultaneous equations", "solve", "SolveAlways", 
      "symmetric polynomials", "undetermined coefficients", 
      "Zariski closure"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "When you write down a set of simultaneous equations in Mathematica, you \
are specifying a collection of constraints between variables. When you use \
Solve, you are finding values for some of the variables in terms of others, \
subject to the constraints represented by the equations. Eliminating \
variables. Here are two equations involving x, y and the 'parameters' a and \
b. ", "synonyms" -> {"3.4.6"}, "title" -> "Eliminating Variables", "type" -> 
    "Tutorial", "uri" -> "tutorial/EliminatingVariables"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.6"->{
  Cell[2063, 62, 83, 2, 70, "Title",
   CellTags->{"S3.4.6", "6.1"},
   CellID->1009]},
 "6.1"->{
  Cell[2063, 62, 83, 2, 70, "Title",
   CellTags->{"S3.4.6", "6.1"},
   CellID->1009]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.6", 20140, 713},
 {"6.1", 20238, 717}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1438, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2063, 62, 83, 2, 70, "Title",
 CellTags->{"S3.4.6", "6.1"},
 CellID->1009],
Cell[2149, 66, 486, 13, 70, "Text",
 CellID->22012],
Cell[2638, 81, 1149, 35, 70, "DefinitionBox",
 CellID->18136],
Cell[3790, 118, 58, 1, 70, "Caption",
 CellID->11455],
Cell[3851, 121, 335, 11, 70, "MathCaption",
 CellID->18762],
Cell[CellGroupData[{
Cell[4211, 136, 360, 14, 28, "Input",
 CellID->25043],
Cell[4574, 152, 446, 16, 36, "Output",
 CellID->1476466119]
}, Open  ]],
Cell[5035, 171, 287, 11, 70, "MathCaption",
 CellID->21],
Cell[CellGroupData[{
Cell[5347, 186, 171, 6, 28, "Input",
 CellID->17922],
Cell[5521, 194, 419, 15, 36, "Output",
 CellID->1372636057]
}, Open  ]],
Cell[5955, 212, 295, 11, 70, "MathCaption",
 CellID->9248],
Cell[CellGroupData[{
Cell[6275, 227, 171, 6, 70, "Input",
 CellID->26018],
Cell[6449, 235, 588, 22, 51, "Output",
 CellID->852008846]
}, Open  ]],
Cell[7052, 260, 517, 17, 70, "MathCaption",
 CellID->23717],
Cell[CellGroupData[{
Cell[7594, 281, 131, 4, 70, "Input",
 CellID->9714],
Cell[7728, 287, 279, 10, 36, "Output",
 CellID->128537120]
}, Open  ]],
Cell[8022, 300, 243, 9, 70, "MathCaption",
 CellID->13290],
Cell[CellGroupData[{
Cell[8290, 313, 131, 4, 70, "Input",
 CellID->3335],
Cell[8424, 319, 367, 14, 51, "Output",
 CellID->1009754827]
}, Open  ]],
Cell[8806, 336, 301, 9, 70, "Text",
 CellID->3169],
Cell[9110, 347, 218, 7, 70, "MathCaption",
 CellID->21895],
Cell[CellGroupData[{
Cell[9353, 358, 125, 4, 70, "Input",
 CellID->5303],
Cell[9481, 364, 258, 9, 36, "Output",
 CellID->1231085242]
}, Open  ]],
Cell[9754, 376, 192, 7, 70, "MathCaption",
 CellID->21979],
Cell[CellGroupData[{
Cell[9971, 387, 126, 4, 70, "Input",
 CellID->24199],
Cell[10100, 393, 211, 7, 36, "Output",
 CellID->1591099774]
}, Open  ]],
Cell[10326, 403, 683, 24, 70, "Text",
 CellID->24791],
Cell[11012, 429, 395, 13, 70, "MathCaption",
 CellID->18661],
Cell[CellGroupData[{
Cell[11432, 446, 449, 16, 70, "Input",
 CellID->8681],
Cell[11884, 464, 366, 12, 36, "Output",
 CellID->945004600]
}, Open  ]],
Cell[12265, 479, 459, 10, 70, "Text",
 CellID->8753],
Cell[12727, 491, 813, 23, 70, "DefinitionBox",
 CellID->24033],
Cell[13543, 516, 91, 1, 70, "Caption",
 CellID->32029],
Cell[13637, 519, 171, 5, 70, "MathCaption",
 CellID->15987],
Cell[CellGroupData[{
Cell[13833, 528, 345, 13, 70, "Input",
 CellID->7042],
Cell[14181, 543, 332, 11, 36, "Output",
 CellID->2111796092]
}, Open  ]],
Cell[14528, 557, 64, 1, 70, "MathCaption",
 CellID->20083],
Cell[CellGroupData[{
Cell[14617, 562, 596, 20, 28, "Input",
 CellID->527918693],
Cell[15216, 584, 1184, 23, 54, "Output",
 Evaluatable->False,
 CellID->121726438]
}, Open  ]],
Cell[16415, 610, 91, 1, 70, "MathCaption",
 CellID->32718],
Cell[CellGroupData[{
Cell[16531, 615, 127, 4, 70, "Input",
 CellID->12244],
Cell[16661, 621, 363, 13, 51, "Output",
 CellID->423016630]
}, Open  ]],
Cell[CellGroupData[{
Cell[17061, 639, 71, 1, 70, "RelatedTutorialsSection",
 CellID->43671172],
Cell[17135, 642, 208, 5, 70, "RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],
Cell[17370, 651, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

