(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    449573,       9071]
NotebookOptionsPosition[    440770,       8812]
NotebookOutlinePosition[    445011,       8906]
CellTagsIndexPosition[    444914,       8900]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArithmeticGeometricMean" :> 
          Documentation`HelpLookup["paclet:ref/ArithmeticGeometricMean"], 
          "DedekindEta" :> Documentation`HelpLookup["paclet:ref/DedekindEta"],
           "E" :> Documentation`HelpLookup["paclet:ref/E"], "EllipticE" :> 
          Documentation`HelpLookup["paclet:ref/EllipticE"], "EllipticExp" :> 
          Documentation`HelpLookup["paclet:ref/EllipticExp"], "EllipticF" :> 
          Documentation`HelpLookup["paclet:ref/EllipticF"], "EllipticK" :> 
          Documentation`HelpLookup["paclet:ref/EllipticK"], "EllipticLog" :> 
          Documentation`HelpLookup["paclet:ref/EllipticLog"], "EllipticNomeQ" :> 
          Documentation`HelpLookup["paclet:ref/EllipticNomeQ"], "EllipticPi" :> 
          Documentation`HelpLookup["paclet:ref/EllipticPi"], "EllipticTheta" :> 
          Documentation`HelpLookup["paclet:ref/EllipticTheta"], 
          "EllipticThetaPrime" :> 
          Documentation`HelpLookup["paclet:ref/EllipticThetaPrime"], 
          "InverseEllipticNomeQ" :> 
          Documentation`HelpLookup["paclet:ref/InverseEllipticNomeQ"], 
          "InverseJacobiCN" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiCN"], 
          "InverseJacobiSN" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiSN"], 
          "InverseWeierstrassP" :> 
          Documentation`HelpLookup["paclet:ref/InverseWeierstrassP"], 
          "JacobiAmplitude" :> 
          Documentation`HelpLookup["paclet:ref/JacobiAmplitude"], "JacobiCN" :> 
          Documentation`HelpLookup["paclet:ref/JacobiCN"], "JacobiSN" :> 
          Documentation`HelpLookup["paclet:ref/JacobiSN"], "JacobiZeta" :> 
          Documentation`HelpLookup["paclet:ref/JacobiZeta"], 
          "KleinInvariantJ" :> 
          Documentation`HelpLookup["paclet:ref/KleinInvariantJ"], 
          "ModularLambda" :> 
          Documentation`HelpLookup["paclet:ref/ModularLambda"], "SiegelTheta" :> 
          Documentation`HelpLookup["paclet:ref/SiegelTheta"], 
          "WeierstrassHalfPeriods" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassHalfPeriods"], 
          "WeierstrassInvariants" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassInvariants"], 
          "WeierstrassP" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassP"], 
          "WeierstrassPPrime" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassPPrime"], 
          "WeierstrassSigma" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassSigma"], 
          "WeierstrassZeta" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassZeta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArithmeticGeometricMean\"\>", 
       2->"\<\"DedekindEta\"\>", 3->"\<\"E\"\>", 4->"\<\"EllipticE\"\>", 
       5->"\<\"EllipticExp\"\>", 6->"\<\"EllipticF\"\>", 
       7->"\<\"EllipticK\"\>", 8->"\<\"EllipticLog\"\>", 
       9->"\<\"EllipticNomeQ\"\>", 10->"\<\"EllipticPi\"\>", 
       11->"\<\"EllipticTheta\"\>", 12->"\<\"EllipticThetaPrime\"\>", 
       13->"\<\"InverseEllipticNomeQ\"\>", 14->"\<\"InverseJacobiCN\"\>", 
       15->"\<\"InverseJacobiSN\"\>", 16->"\<\"InverseWeierstrassP\"\>", 
       17->"\<\"JacobiAmplitude\"\>", 18->"\<\"JacobiCN\"\>", 
       19->"\<\"JacobiSN\"\>", 20->"\<\"JacobiZeta\"\>", 
       21->"\<\"KleinInvariantJ\"\>", 22->"\<\"ModularLambda\"\>", 
       23->"\<\"SiegelTheta\"\>", 24->"\<\"WeierstrassHalfPeriods\"\>", 
       25->"\<\"WeierstrassInvariants\"\>", 26->"\<\"WeierstrassP\"\>", 
       27->"\<\"WeierstrassPPrime\"\>", 28->"\<\"WeierstrassSigma\"\>", 
       29->"\<\"WeierstrassZeta\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Elliptic Integrals and Elliptic Functions", "Title",
 CellTags->{"S3.2.12", "12.1"},
 CellID->7229],

Cell["\<\
Even more so than for other special functions, you need to be very careful \
about the arguments you give to elliptic integrals and elliptic functions. \
There are several incompatible conventions in common use, and often these \
conventions are distinguished only by the specific names given to arguments \
or by the presence of separators other than commas between arguments. \
\>", "Text",
 CellID->20652],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      "\[FilledSmallSquare] Amplitude ",
      Cell[BoxData[
       FormBox["\[Phi]", TraditionalForm]], "InlineMath"],
      " (used by ",
      StyleBox["Mathematica",
       FontSlant->"Italic"],
      ", in radians)"
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Argument ",
      Cell[BoxData[
       FormBox["u", TraditionalForm]], "InlineMath"],
      " (used by ",
      StyleBox["Mathematica",
       FontSlant->"Italic"],
      "): related to amplitude by ",
      Cell[BoxData[
       FormBox[
        RowBox[{"\[Phi]", "=", 
         RowBox[{"am", "(", "u", ")"}]}], TraditionalForm]], "InlineMath"]
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Delta amplitude ",
      Cell[BoxData[
       FormBox[
        RowBox[{"\[CapitalDelta]", "(", "\[Phi]", ")"}], TraditionalForm]], 
       "InlineMath"],
      ": ",
      Cell[BoxData[
       FormBox[
        RowBox[{
         RowBox[{"\[CapitalDelta]", "(", "\[Phi]", ")"}], "=", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{"m", 
            RowBox[{
             SuperscriptBox["sin", "2"], "(", "\[Phi]", ")"}]}]}]]}], 
        TraditionalForm]], "InlineMath"]
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Coordinate ",
      Cell[BoxData[
       FormBox["x", TraditionalForm]], "InlineMath"],
      ": ",
      Cell[BoxData[
       FormBox[
        RowBox[{"x", "=", 
         RowBox[{"sin", "(", "\[Phi]", ")"}]}], TraditionalForm]], 
       "InlineMath"]
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Characteristic ",
      Cell[BoxData[
       FormBox["n", TraditionalForm]], "InlineMath"],
      " (used by ",
      StyleBox["Mathematica",
       FontSlant->"Italic"],
      " in elliptic integrals of the third kind)"
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Parameter ",
      Cell[BoxData[
       FormBox["m", TraditionalForm]], "InlineMath"],
      " (used by ",
      StyleBox["Mathematica",
       FontSlant->"Italic"],
      "): preceded by ",
      Cell[BoxData[
       FormBox["\[VerticalSeparator]", TraditionalForm]], "InlineMath"],
      ", as in ",
      Cell[BoxData[
       FormBox[
        RowBox[{"I", "(", 
         RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
        TraditionalForm]], "InlineMath"]
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Complementary parameter ",
      Cell[BoxData[
       FormBox[
        SubscriptBox["m", "1"], TraditionalForm]], "InlineMath"],
      ": ",
      Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox["m", "1"], "=", 
         RowBox[{"1", "-", "m"}]}], TraditionalForm]], "InlineMath"]
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Modulus ",
      Cell[BoxData[
       FormBox["k", TraditionalForm]], "InlineMath"],
      ": preceded by comma, as in ",
      Cell[BoxData[
       FormBox[
        RowBox[{"I", "(", 
         RowBox[{"\[Phi]", ",", "k"}], ")"}], TraditionalForm]], 
       "InlineMath"],
      "; ",
      Cell[BoxData[
       FormBox[
        RowBox[{"m", "=", 
         SuperscriptBox["k", "2"]}], TraditionalForm]], "InlineMath"],
      " "
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Modular angle ",
      Cell[BoxData[
       FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
      ": preceded by ",
      Cell[BoxData[
       FormBox["\\", TraditionalForm]], "InlineMath"],
      "\[ThinSpace], as in ",
      Cell[BoxData[
       FormBox[
        RowBox[{"I", "(", 
         RowBox[{"\[Phi]", "\\", "\[Alpha]"}], ")"}], TraditionalForm]], 
       "InlineMath"],
      "; ",
      Cell[BoxData[
       FormBox[
        RowBox[{"m", "=", 
         RowBox[{
          SuperscriptBox["sin", "2"], "(", "\[Alpha]", ")"}]}], 
        TraditionalForm]], "InlineMath"],
      " "
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Nome ",
      Cell[BoxData[
       FormBox["q", TraditionalForm]], "InlineMath"],
      ": preceded by comma in ",
      Cell[BoxData[
       FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
      " functions; ",
      Cell[BoxData[
       FormBox[
        RowBox[{"q", "=", 
         RowBox[{
          RowBox[{"exp", "[", 
           RowBox[{
            RowBox[{"-", "\[Pi]"}], " ", 
            RowBox[{
             RowBox[{"K", "(", 
              RowBox[{"1", "-", "m"}], ")"}], "/", "K"}], 
            RowBox[{"{", "m", ")"}]}], "]"}], "=", 
          RowBox[{"exp", "(", 
           RowBox[{"i", " ", "\[Pi]", " ", 
            RowBox[{
             SuperscriptBox["\[Omega]", "\[Prime]"], "/", "\[Omega]"}]}], 
           ")"}]}]}], TraditionalForm]], "InlineMath"],
      " "
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Invariants ",
      Cell[BoxData[
       FormBox[
        SubscriptBox["g", "2"], TraditionalForm]], "InlineMath"],
      ", ",
      Cell[BoxData[
       FormBox[
        SubscriptBox["g", "3"], TraditionalForm]], "InlineMath"],
      " (used by ",
      StyleBox["Mathematica",
       FontSlant->"Italic"],
      ") "
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Half\[Hyphen]periods ",
      Cell[BoxData[
       FormBox["\[Omega]", TraditionalForm]], "InlineMath"],
      ", ",
      Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Omega]", "\[Prime]"], TraditionalForm]], 
       "InlineMath"],
      ": ",
      Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox["g", "2"], "=", 
         RowBox[{"60", 
          RowBox[{
           UnderoverscriptBox["\[Sum]", 
            RowBox[{"r", ",", " ", "s"}], "\[Prime]",
            LimitsPositioning->True], 
           SuperscriptBox["w", 
            RowBox[{"-", "4"}]]}]}]}], TraditionalForm]], "InlineMath"],
      ", ",
      Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox["g", "3"], "=", 
         RowBox[{"140", 
          RowBox[{
           UnderoverscriptBox["\[Sum]", 
            RowBox[{"r", ",", " ", "s"}], "\[Prime]",
            LimitsPositioning->True], 
           SuperscriptBox["w", 
            RowBox[{"-", "6"}]]}]}]}], TraditionalForm]], "InlineMath"],
      ", where ",
      Cell[BoxData[
       FormBox[
        RowBox[{"w", "=", 
         RowBox[{
          RowBox[{"2", "r", "\[InvisibleSpace]", "\[Omega]"}], "+", 
          RowBox[{"2", 
           SuperscriptBox["s\[Omega]", "\[Prime]"]}]}]}], TraditionalForm]], 
       "InlineMath"],
      " "
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Ratio of periods ",
      Cell[BoxData[
       FormBox["\[Tau]", TraditionalForm]], "InlineMath"],
      ": ",
      Cell[BoxData[
       FormBox[
        RowBox[{"\[Tau]", "=", 
         RowBox[{
          SuperscriptBox["\[Omega]", "\[Prime]"], "/", "\[Omega]"}]}], 
        TraditionalForm]], "InlineMath"],
      " "
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Discriminant ",
      Cell[BoxData[
       FormBox["\[CapitalDelta]", TraditionalForm]], "InlineMath"],
      ": ",
      Cell[BoxData[
       FormBox[
        RowBox[{"\[CapitalDelta]", "=", 
         RowBox[{
          SubsuperscriptBox["g", "2", "3"], "-", 
          RowBox[{"27", 
           SubsuperscriptBox["g", "3", "2"]}]}]}], TraditionalForm]], 
       "InlineMath"],
      " "
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Parameters of curve ",
      Cell[BoxData[
       FormBox["a", TraditionalForm]], "InlineMath"],
      ", ",
      Cell[BoxData[
       FormBox["b", TraditionalForm]], "InlineMath"],
      " (used by ",
      StyleBox["Mathematica",
       FontSlant->"Italic"],
      ") "
     }], "TableText"]},
    {Cell[TextData[{
      "\[FilledSmallSquare] Coordinate ",
      Cell[BoxData[
       FormBox["y", TraditionalForm]], "InlineMath"],
      " (used by ",
      StyleBox["Mathematica",
       FontSlant->"Italic"],
      "): related by ",
      Cell[BoxData[
       FormBox[
        RowBox[{
         SuperscriptBox["y", "2"], "=", 
         RowBox[{
          SuperscriptBox["x", "3"], "+", 
          RowBox[{"a", 
           SuperscriptBox["x", "2"]}], "+", 
          RowBox[{"b", " ", "x"}]}]}], TraditionalForm]], "InlineMath"],
      " "
     }], "TableText"]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}], TraditionalForm]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, False, False, False, {False}, False}, "RowsIndexed" -> {}},
 
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->18864],

Cell["\<\
Common argument conventions for elliptic integrals and elliptic functions. \
\>", "Caption",
 CellID->4769],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["JacobiAmplitude",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiAmplitude"], "[", 
     StyleBox["u", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "give the amplitude ",
     Cell[BoxData[
      StyleBox["\[Phi]", "TR"]], "InlineFormula"],
     " corresponding to argument ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipticNomeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticNomeQ"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "give the nome ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " corresponding to parameter ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseEllipticNomeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseEllipticNomeQ"], "[", 
     StyleBox["q", "TI"], "]"}], Cell[TextData[{
     "give the parameter ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " corresponding to nome ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["WeierstrassInvariants",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassInvariants"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["\[Omega]", "TR"], ",", 
       FormBox[
        SuperscriptBox[
         StyleBox["\[Omega]", "TR"], "\[Prime]"],
        TraditionalForm]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the invariants ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]], "InlineFormula"],
     " corresponding to the half\[Hyphen]periods ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["\[Omega]", "TR"], ",", 
        SuperscriptBox[
         StyleBox["\[Omega]", "TR"], "\[Prime]"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["WeierstrassHalfPeriods",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassHalfPeriods"], "[", "{", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["2", "TR"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["3", "TR"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the half\[Hyphen]periods ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["\[Omega]", "TR"], ",", 
        SuperscriptBox[
         StyleBox["\[Omega]", "TR"], "\[Prime]"]}], "}"}]], "InlineFormula"],
     " corresponding to the invariants ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->30470],

Cell["Converting between different argument conventions. ", "Caption",
 CellID->15005],

Cell[CellGroupData[{

Cell["Elliptic Integrals", "Section",
 CellID->21047],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EllipticK",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticK"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "complete elliptic integral of the first kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{"K", 
        RowBox[{"(", "m", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipticF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticF"], "[", 
     RowBox[{
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[TextData[{
     "elliptic integral of the first kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{"F", "(", 
        RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipticE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticE"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "complete elliptic integral of the second kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        ButtonBox["E",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/E"], 
        RowBox[{"(", "m", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipticE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticE"], "[", 
     RowBox[{
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[TextData[{
     "elliptic integral of the second kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        ButtonBox["E",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/E"], 
        RowBox[{"(", 
         RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipticPi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticPi"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "complete elliptic integral of the third kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CapitalPi]", 
        RowBox[{"(", 
         RowBox[{"n", "\[VerticalSeparator]", "m"}], ")"}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipticPi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticPi"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[TextData[{
     "elliptic integral of the third kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CapitalPi]", 
        RowBox[{"(", 
         RowBox[{"n", ";", 
          RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}]}], ")"}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JacobiZeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiZeta"], "[", 
     RowBox[{
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[TextData[{
     "Jacobi zeta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Z", 
        RowBox[{"(", 
         RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->1594],

Cell["Elliptic integrals. ", "Caption",
 CellID->21487],

Cell[TextData[{
 "Integrals of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"R", "(", 
      RowBox[{"x", ",", "y"}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is a rational function, and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["y", "2"], TraditionalForm]], "InlineMath"],
 " is a cubic or quartic polynomial in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", are known as ",
 StyleBox["elliptic integrals",
  FontWeight->"Bold"],
 ". Any elliptic integral can be expressed in terms of the three standard \
kinds of ",
 StyleBox["Legendre\[Hyphen]Jacobi elliptic integrals",
  FontWeight->"Bold"],
 ". "
}], "Text",
 CellID->24326],

Cell[TextData[{
 "The ",
 StyleBox["elliptic integral of the first kind",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticF"], "[", 
   RowBox[{
    StyleBox["\[Phi]", "TR"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is given for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Pi]", "/", "2", "<", "\[Phi]", "<", "\[Pi]", "/", "2"}], 
   TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", 
     RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"[", 
        RowBox[{"1", "-", 
         RowBox[{"m", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "\[Theta]", ")"}]}]}], "]"}], 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]], 
      RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 Cell[BoxData[
  FormBox[
   RowBox[{"=", 
    SubsuperscriptBox["\[Integral]", "0", 
     RowBox[{"sin", 
      RowBox[{"(", "\[Phi]", ")"}]}]], 
    SuperscriptBox[
     RowBox[{"[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["t", "2"]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "m", 
         SuperscriptBox["t", "2"]}], ")"}]}], "]"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]], "\[DifferentialD]", "t"}], 
   TraditionalForm]], "InlineMath"],
 ". This elliptic integral arises in solving the equations of motion for a \
simple pendulum. It is sometimes known as an ",
 StyleBox["incomplete elliptic integral of the first kind",
  FontWeight->"Bold"],
 "."
}], "Text",
 CellID->3276],

Cell[TextData[{
 "Note that the arguments of the elliptic integrals are sometimes given in \
the opposite order from what is used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->21323],

Cell[TextData[{
 "The ",
 StyleBox["complete elliptic integral of the first kind",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticK",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticK"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"K", "(", "m", ")"}], "=", 
    RowBox[{"F", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "\[VerticalSeparator]", "m"}], ")"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". Note that ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is used to denote the ",
 StyleBox["complete",
  FontSlant->"Italic"],
 " elliptic integral of the first kind, while ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath"],
 " is used for its incomplete form. In many applications, the parameter ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is not given explicitly, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"K", "(", "m", ")"}], TraditionalForm]], "InlineMath"],
 " is denoted simply by ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 ". The ",
 StyleBox["complementary complete elliptic integral of the first kind",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["K", "\[Prime]"], "(", "m", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"K", "(", 
    RowBox[{"1", "-", "m"}], ")"}], TraditionalForm]], "InlineMath"],
 ". It is often denoted ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["K", "\[Prime]"], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", 
    SuperscriptBox["K", "\[Prime]"]}], TraditionalForm]], "InlineMath"],
 " give the \[OpenCurlyDoubleQuote]real\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]imaginary\[CloseCurlyDoubleQuote] \
quarter\[Hyphen]periods of the corresponding Jacobi elliptic functions \
discussed later. "
}], "Text",
 CellID->6540],

Cell[TextData[{
 "The ",
 StyleBox["elliptic integral of the second kind",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticE"], "[", 
   RowBox[{
    StyleBox["\[Phi]", "TR"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is given for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Pi]", "/", "2", "<", "\[Phi]", "<", "\[Pi]", "/", "2"}], 
   TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"E", "(", 
     RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"[", 
        RowBox[{"1", "-", 
         RowBox[{"m", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "\[Theta]", ")"}]}]}], "]"}], 
       RowBox[{"1", "/", "2"}]], 
      RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 Cell[BoxData[
  FormBox[
   RowBox[{"=", 
    SubsuperscriptBox["\[Integral]", "0", 
     RowBox[{"sin", 
      RowBox[{"(", "\[Phi]", ")"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["t", "2"]}], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "m", 
       SuperscriptBox["t", "2"]}], ")"}], 
     RowBox[{"1", "/", "2"}]], "\[DifferentialD]", "t"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->7679],

Cell[TextData[{
 "The ",
 StyleBox["complete elliptic integral of the second kind",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticE"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"E", "(", "m", ")"}], "=", 
    RowBox[{"E", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "\[VerticalSeparator]", "m"}], ")"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". It is often denoted ",
 Cell[BoxData[
  FormBox["E", TraditionalForm]], "InlineMath"],
 ". The complementary form is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["E", "\[Prime]"], "(", "m", ")"}], "=", 
    RowBox[{"E", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->23990],

Cell[TextData[{
 "The ",
 StyleBox["Jacobi zeta function",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["JacobiZeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiZeta"], "[", 
   RowBox[{
    StyleBox["\[Phi]", "TR"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Z", "(", 
     RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{
     RowBox[{"E", "(", 
      RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], "-", 
     RowBox[{
      RowBox[{"E", "(", "m", ")"}], 
      RowBox[{
       RowBox[{"F", "(", 
        RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], "/", 
       RowBox[{"K", "(", "m", ")"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->32588],

Cell[TextData[{
 "The ",
 StyleBox["Heuman lambda function",
  FontWeight->"Bold"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CapitalLambda]", "0"], "(", 
     RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"F", "(", 
       RowBox[{"\[Phi]", "\[VerticalSeparator]", 
        RowBox[{"1", "-", "m"}]}], ")"}], "/", 
      RowBox[{"K", "(", 
       RowBox[{"1", "-", "m"}], ")"}]}], "+", 
     RowBox[{
      FractionBox["2", "\[Pi]"], 
      RowBox[{"K", "(", "m", ")"}], 
      RowBox[{"Z", "(", 
       RowBox[{"\[Phi]", "\[VerticalSeparator]", 
        RowBox[{"1", "-", "m"}]}], ")"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->24710],

Cell[TextData[{
 "The ",
 StyleBox["elliptic integral of the third kind",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticPi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticPi"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["\[Phi]", "TR"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalPi]", "(", 
     RowBox[{"n", ";", 
      RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}]}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"n", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "\[Theta]", ")"}]}]}], ")"}], 
       RowBox[{"-", "1"}]], 
      SuperscriptBox[
       RowBox[{"[", 
        RowBox[{"1", "-", 
         RowBox[{"m", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "\[Theta]", ")"}]}]}], "]"}], 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]], 
      RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->29271],

Cell[TextData[{
 "The ",
 StyleBox["complete elliptic integral of the third kind",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticPi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticPi"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalPi]", "(", 
     RowBox[{"n", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{"\[CapitalPi]", "(", 
     RowBox[{"n", ";", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "\[VerticalSeparator]", "m"}]}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->17945],

Cell[TextData[{
 "Here is a plot of the complete elliptic integral of the second kind ",
 Cell[BoxData[
  FormBox[
   RowBox[{"E", "(", "m", ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->29221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", "m", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->28470],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWE1sVFUUfsxPFf9orJYiKBOMUo3GxohOCGpRAhMCaQkQij+hkwadhpCO
LZIJEqqiVpE4KsESomlw02U3JF122WWXXXbZZZddPr9zzjvMu/ed+VUWTtKZ
e9459/x+59z7erx4qXT+YvHS+Fgxd2SyWC6Nj03lDk9M4lF6SxAE9/E30Rdg
HWLFf/fDEL/J71fwnYJAmqg0SdLTgJfPxnlZ4ckn8LnpB9wg1YTXiwU9Shk8
lg/66TtT4wRB1vPumYREl6ft6YREJvGkpwWZXk9vOiGRquOz75FtLdOiHw/X
10day17DCrTiM9WR6rz9IXqqNmwP0y363nkuk7qS9ur7mPXs/pd1117vin57
o18/pz2x5+qltU9p6dr4VBEn9WN1uh/nPd7gSyYjyfyLfX9prB3Y8f316Xbl
26X/b/pl8m9ubkYjo6vDvO/y6Oeb8H16J9OlUqkDPwind5i9sLAwPDxMS8FP
BHn+aBf4GfiD6bW1tYGBgY2NjeBR3tLtSd3WPEFqdXU12NpACi7AEVrWpMiy
cEdHR+fm5mj5mKnjFklPT08/YXJ/j7hPOpr16VPmnl8j7jaTW4243Y7GqtYD
HFp2x8peb16kDVzc1LyNjIzMzs7KOZDYaaOyRv/MNKpTKBTm5+dl2rakhcgb
WuHBwcGlpSWZ5m378BPTy8vL+Xx+ZWWF707ta/mRacQAX9bX1+VMaFvLDNPl
chlZpd7dHjZCO/3+oBmE3Wq1GuwwsfCdxtjf30+Zes6Uus40qhnFsNNBzrdE
ZaTiwA8Wu0wtXzONXkJHUU1fMKWmmUbDRH2327F1jW0hKthCX8FWztRyNRYX
2dpjSn3FdKVSQYUprhcdW1fUX3BnZmaCl8LGHUG01REVplEDRASPgpdNBPj3
OF/LZRaCl+gI4ACR7+0ISV9qfpGZxcVFvnsktfh3ZOITORXzAvlHIV5teX+c
nlRERV68ZmppfgqVWUJqBOzBn9fDZp3Be9KoaFSPN0xsXGTNgiAghA4CU+6C
IlJgBFfedFDE/DRihB5C0VumlpLmFUcJUovFPlPuszDqNajK5XI4dd5xrAkf
1hCbeJ039Yy59uD1flOuqPZwKoi9A6bcKMuBjSghig3vxgpWr1viVTmn+caM
gVMY3u93hKxPNDJMCNQDQ+1gR3o+ciPHEPnQ1KP3EYqDHp/lh+gvbJJMHDL3
NevTM7FKotMQ0OGO4jjNenB+FfhDi9DvEPVda3FKcwjDMA8njppVPxHWsI9w
EfQxU26IA0YqMAQhB+zSGXbcQe6Q5g0IwnyD0iFT17EY0uAecHLClDuqcggA
eALCT5pyhVieIYf8nHb8OsJ8wAi4lPydMfUcisnJteOsKfdBrB4i97Fj76Dy
4Yzk/tOwTicl/vPjY+o9VxeSca4jLB7Q2OCz6CmaemhfJqi9z+93c4JYxuru
i88F35+81uhBbs+beuK9GH/+dgwLCAH7P2+6n373uRhCIsdDv3f8d3Q/d3wa
RPNAdFwwccGnUNQjfX19Am05hRKyfMZl0SIym9AudHuZcHDEJ2oWz8GVUUQy
X5j6+A6QhWuwCtvwgN6LpkzZvS4WENhlxy7fbjIYl2BKzSumnj0aLy4B8A/T
mu7YV0zZnMaCOQP/cNBTbq46dne7MWDGUAzXwjq9Y5xCibfVjNzaJcpvTMQ0
m747tFIy+RAl3bKvt6yLSL7rZxGxVBLfFP33HfnD7zBZnLLwBLqiSs+Yuup1
U4/mJs8fLG7U3d+I7taqolaoGDyi29jN0OqwVFB789+mMUilgQlC9i8mch5X
lKGC4i4WwW+m7FbNs5xm0E7+3HJQxv8ryKKGkj94TrZvm/oyWnu55gJJ9CZy
x5RNuTEB4fTuc9exHXRJHMCjxAHyz5o2Og2wT2YH9dKcawleUK3vOTr/Nr0R
mWDLP4mvz8o=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->519490413]
}, Open  ]],

Cell[TextData[{
 "Here is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"K", "(", "\[Alpha]", ")"}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "=", 
    SuperscriptBox["30", "\[EmptySmallCircle]"]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->23589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticK", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"30", " ", "Degree"}], "]"}], "^", "2"}], "]"}], "//", 
  "N"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->23955],

Cell[BoxData["1.685750354812596`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->4978]
}, Open  ]],

Cell["\<\
The elliptic integrals have a complicated structure in the complex plane. \
\>", "MathCaption",
 CellID->24779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{"px", "+", 
       RowBox[{"I", " ", "py"}]}], ",", "2"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"px", ",", "0.5", ",", "2.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"py", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "60"}]}], "]"}]], "Input",
 CellLabel->"In[83]:=",
 CellID->5006],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytfWl0HNl1XrmqurnNxtHMSKPRGtnW4jixFCd2Tuz4ONGx8iNxnHOcE584
cSLL8irZWka7ZiE5wx3EShLcOTMccoYbtkYDjUajG2jsBHcQGwEQXIYcSooj
++RffE9yv3vvqy4Ueka0Ep7H2lBd9e733XvffUu99+8+/+yffvHLn3/2z77w
+Y987muf/8qf/tkXvv6R3/qrr/Gl4Gc8z8vw/7r3eXz8f/hI/meIiP8Q2/45
b0P+k4+zgA/kKp/z/9+Q479I/GVV7ByHvybXv5S4mq5615cTV1MPdFfAm0p+
kGMvrPzVW/GUdbwJEjLhEM/4ZCSTb7Jg/1CVNy5/xydk9z1DK3jA+zc+4H3f
snysecD7v2H3yw1f/OIXcbj6AX/721UYd+g8bcjpj5XyOE5p2yuK/z6hGeGK
Nz5l96fcXziv+pd/Lrvf+Yl5fk+VHOnT9FF69Vdl9x+SEq142mP2tHU/9RMe
iSNv+VkTXYvEE9R+JcJ7+TNW4uQ09qHoSQfGSeHSu2N5+uUI+zgja2OSCV6p
A2PED9H0zs/574nfhfvHKOSfOlkiFGK//Cfyyz+wX7g3+/vwK/45H2OLJ/l4
UgVnu1Pf/PuJ36fl93zAe/w+td9yYSgnbe4z8pRfppW27vB/JoGN3zyq9/Ae
h6l9ds57OZRsG+xepNGxd35anv5PE1eTvu7JKnkSyt31vaMUJPKC8yCWHycD
wzgK+vaP0k+dn8ftvdBTiLdqr71QX++l8G48He8N9WX6Pud5P/NA73mMKl5M
nrfH5OH34ZXpvZVzJ37EiXHgr8hD0rv/46p5Ce3dzsJXO1mRBxzwHmmEwr0j
xgIfN4+w+IBhhPZJAvW+KsOos++k5jl7j193fH3gHXMXP3/YnpDUkMByH+w2
VDTXns+bkPOukoyQJvWLLAYghSDYBM1yjq2PDSxIRZMHJnMipfkyX5Qs35+O
7CxeEkRWazinJce75d3YpnmD66k99mLOW5THUDPYLHALDvtG4rlwKNizVQVi
WXyHPH4ujuqKp4UOU97jMLXb3sl7TYpnRQYfGwiwZ9iS3MD7cO+w3g1NbR4m
pBHyHciWqyS76QfE+rOW45TtVzVZzptGqAnYNo2YlvA7dw+bVMOEw1DONavY
+ntcTvfKNd5ylkPOsL9v+F1zm1qR25Thqzr+r6hStktumszSeK8pbBpZlm+/
SXViVZO9uUnznOJNKP4C1zWfYod8iJwmc+nKvXePAp+Ry8/QO8eC73easQLn
0Si/QeOI6SCEGLbkOSlClQJpyOnPkOjPEMlhuGdIbXDvEHFimYbIB/oxva54
EGddbq8yfKCKl1gu+3vjmp+Ka77nmMHvG0epEYe88RtN+3mvCT9b1Who814O
dTME6ZyHS+E4UBGdlD6khC3wfo8Iqlg0DzkfmvQ7n3pAyZ6gij8XyZrGyMTA
C3gfGkOQyE/kP9VoHLEImkL9meQLWx/XnES8bxqEDfEmFQUBsCTcAPreRaJP
PqBE6ykWg4qPHycWinPiWBI6RB6Rq4G5aTC5eI9DnzdBg6KMPaTQ3w5SIzKP
jejmIGlSPlQmiBfs4Wt7B5dJ5GzrFx5Qkkft/kfcX/aeo91CD/IsFt0wsizf
FTmGqGFIfyQC6CWWi9losLzzXlPA0sjThJxIBk6QwhcpEvmMnX/iAaV5yHh5
zP1l3wQpNVLjg0Qu9/XDVI9DbML6IYr0JIWToH4QV7DFYdBg+YMwZT3kx5Wp
say1JuzDpjL8cpNcCnaXUe6UiaXbKylyFjEJPh75t3g9YJ3tUW/y0nyw/zw1
nzNBWAa/fmSZDKn6hEySO5UJW583Yb1JwHsnFW/KTm6tsfB5gyRm0cS080Ak
jMTjrc8Spt5Rpl80JhBHe6v44OAF2j9BrF3qwyCCn8x3vZYhqTqzhLpBqoMl
1Fne68pUF6HPR5Z9n/ep+gHL7wBx4vwPqM9uHKBG+5O/ewCOgTmRVCXvPy95
/wXL+3td3g9doAPniXUp8l2VvNcNU50d+lG+hwiHOA+ivKssOBc74Oz7dZYx
3uMQ5wHkAKy8r++PSlH1eAOSAdzJG0jj7xl4V7v5OZHHxdXVYl1XfkrUsoYP
jl6iwxdJJY4cW4MVNOmYhLVgptakqx2MnhjUGkW8rwXgtZZH3st5Xb95cJaP
hYOUfkO/+b5+asR5Uz+Y6ieWcc9ANaZUspUeIBmNuXqclMIP88Grl0lFZIXk
02Zxd01SFIFKdQTpWsipQomItcpaSmSrlRw52fxay3ttv5ZnsuGT2pJiUsf7
VRC0RJoa5A/Y+iysyBqwrHvs95bjn39ACV3NMMn9+7BZx+evXaFXLtMRERrO
hK1QSyuR2PNrzYnzXlNo0ga7jEne4zC1y5jk/S5kmjcS4+4qMQole0oJpNYV
SeQO652snPzGktYzEjl1ZVZSAt/Z4AOggHIMN3zESX3sKsUFV/vdIy0yUqA5
qXcNkiaJaiOJWULwWwOJa/qdlxQrrzFJea/Jr2FpdxXtl0Wpfwa1QKBocWdj
kZpKSLtLlXJgRYy3Ir5dIfVT74CGi+pd7f1ncfkRPjg+Sa9HQDizbo6c8DDt
GnKy+7z3nfw1ZapBKcCbABiIvAOkSe5mUFI7DYmdRdIkSNT06TMYhl19Fh+k
6/qkNOojTg1FYkD8JiCmgJCLxZZJ9f+GR/yXLi6It/h9DJvH+OTENWKYWF9e
vQLXoDCxlahrYGWpk8rCLvEGfs0gpWqWoxQaJsFOGMVOkQhbnzcBo+KFO4q4
tqOPOAU7+7TmYFFQTYE4+bsK7CVqC2KVBeIEoPqosQ/esLgSB9Mer+LNHxAt
VxrEWwGi9mDozJtTVIEk5i3NcYirZOsBEstRACo7pVzdOeDiwp1iO9j62KR2
9NOOkiWxBIbGZ1Qgjr+joGX2jl7a2Ytf9PJb+GDtrl55aa/gUqCGAnBp6qPd
xSTbfx8knqqiFRJpPsonJ6epOhAxR1In9sP5NH3gPQ5xLjYCGNIs9g6XoARc
+kH2YHuJthc1v7wX+bcVKNjWi7/1uh4Bf3ue8eH/O/PK+a481eaprpfqe61M
purtUO8k9RN2/z9ykp6eoVMi7BsqrDiLo85rmrMYkaIxMMm8FIu2QxJEGlBi
vUBJ3Q7d5w3kEhy2scazbF64VfR7ay9xCrbmydVmtvXwL3jjb8/hKTna2VMp
S1P1eWropcZe2l2ISsh0THItI1yd7JecXZ+dJRVNbfz1SfhBTyIcNXA+VgOH
NsuDK/KE2AQRZUwJl3UsU0osd1uRtolD28r2vFUk66UtkiDvFpYsvaUHHPK/
LTlc5K38ds2ObpzW5GhXjup6iIVrzFNTr8YdCQ4/LJKtrcIsTj9t8nuPtcyR
ShuZL3t9Po68Ph+r7daLLxNBAxVVpN1uMQzvwR5yGrCQXmprkVhGTaKPW9hX
Qcxgcy9tzisf1gLoPR7Vt1/uos2csrQlS1uztC0rOHZRTRft6qa6HDX0QOzd
InZS6g9VpE57y8tIvClxt4vWg7br5JDg01POfj2JgNSxe65GqG0P7MH87YYE
77cbz+LLt7H+bjO/CxD40AcG4ZY+Ygy2iCr6m2GEDMMX3T/V2Je6aROnrsiK
N3WS/1KGI5OXM7Q5Q1sygkcn1WSptovqu6kxR7vzUWwAND8SlW1hzEfJ0xLW
jpf8otMFgcHzsA2xeZwRiRs5H7/uijo+hjvjquWYOXW2bwXC9LyfGIdtYtU+
70LAkFK936KJcfA3F/RqhILk8iW24WCTKP9G1nl/YxdnaUOWNnQaLP6GDkZk
QzttbKdN7fRyu1hUB23PUE0n1WapoZuachoHJnXkgwJHvL/UgRTvU8XlT7pr
qbY5YkQ0SQ5577fz8Xq9sMxhSODEXp+PD8eiJvUWznx8BigEPKIlJdGSAJtw
SxHowO61tBdHB6/0Up6QemgTpxxtFHw2dNGLnLL0Qie9kEHOnxcw/Odb+VnP
t9ALLbShhTa1iN/zgr09tC9f1WNou+6y3o1lcSay8XFXYjAgoiNBu8iPreDx
ePs8zlsTXkUKQj62QFKrwxpFDkJtgIbkxXQm3GrxodrPFi0NBIlVLxfo5V6k
l8QFbMoDD9YRhmPNhm6gwVdfyNLznfRchp7roO+3S95RRfVWbWuhmnaqz1BT
lvbmaP9yy/nQSgxWtJFXekY/ahYGNGA8AkZgcJi1CSJ83hr3LlJaelKjXOlk
2bWwFflbY7qBUlHOtxbjlswlRZHilsPW5DM8PpAJWVc2iXQbuXTcgNLxxW56
oYuez6pz9Nbrj75xkp59k549Qd84Tt8+Tt8/jt+8fIq2n6G6NmrqpOZuOtBD
h6uXM89UPO6yiCGdwOpDhmnIWMnvGS/AlOKN2h3j1CHJ87F5TEHjv5wRy3pD
/LGGGPFgSuMLNqtgq5ax/pZiVIuQ+tRm+N6Xxevy9iXFxwc2uGuDxgvitZ76
Xoa+20HfaadvtdI3W+jZM+Zv/uo4ffk1+vJR+vJh+tph+vYR/Gbbm1R3lvZ0
0L4sHe6ho73VapfvFzhcj5/EHfzID9h5StBonyPTmDBCo+O6QIF7FI158zNn
nJ85LlHJKxxtqZORuDKyKClNwi0l2I4msR6IyXhoehk1BACDm18qRDj4L7K2
PPNCNz3fRc910felCP5OB327nb7ZSs+20NccLn9+jP74KP3RAfrCXvqjRvpS
k4D8CtWdpOY2OpSloz30WoFeL1XVnQo2K/okY5pTibXbxIAAmVgcwyY+J6xY
HOedgQuAGK6qPmXmyc8saGTHv2sRDPkYQavUcONhXWSDokmlROkE1fI3F/Xp
EYiC2SamP81KtTFPGziJVr2QI/95LsCeUhS/24mL3+qgb7bR11vpq2fpL08Z
kH94lP7LfvrdevqdzfQfn6e/2CJ5OUEHW+jVLno9H/UIxsusd2ude7gqtqsT
2L4n8uez7MHMMqGOwNjwDQxV0cMwI3qYUVTxsscYWv4Lm3OL828JYCPnpk1k
ood4KIMJKIPNrq2DoVQDNV0UTJ/Z2FvB9EWB9fkcMarAtIu+m6XvCKzfbKdn
BdavtQBZfslfnqQ/f53+8BD9QR393tfpt//T/+LbDr5prcDh6X46U6YzQ5HV
vmsLQrJdYG1VfNck8HWtKmGEb7u4tAhfM3XV1uvmAFMO20cZ206XIpBZe0+6
aOw1rm9p29w5qxKFHIhxabpZwBXN3GxNKS+LsnIKgC+uML4bJfkb4A1fdErL
0UMO0QOXFzl6UeIMn92BtxYOISsliBgFx6YcgL10mmqOUlPNjyXPq9oGKNNH
7QPUVqa2YWqTDvX/bwivTSBcaZ9pnSV1EOooAHdMk3FPusPKZ1Vfz+eN/pbh
5R22ITar4lirp0CtSD3osqB3gKyFfbOUzJvNPyjmL0sYF8M82CSKDbUONvbq
uem6/p0LcI39OIDm/eM7i6Stos1lOjJMp8aoLF5qScqa0gDly5Qbpu5Ryo5R
5zhlpBCItxHGvMJPhfe6BN4uNvJbZygUnOFVZ6l9VpVb2rqBcypznQxnAVzr
Hp2MOBBeo3Bryi4u02/Fec3rLmLUioYnEbQ6ZoU7VMCRGN+Xre2Q9y+hXMMm
UAYkIJANhwjbtSySCvrTNQPSPC3dj9rPvWcYg2UOufF33VN0bgnH//s+3Rej
OzdBgxNUmqDeCeqZoO7z1CXdHeJb32lUT8UjuxEzyRFrDydwTpteA2fW5Rno
NuCGp+YwYZYiRy3v7OC90274EcTjTEBgngS4p4E7/p4VxL2oboG+DfUpJ2JR
6UGpt0ReGwG6lHyrK6gXodgoBUX3Aa7vajQcj4ltYPOhmjJph0i99Ps2yIiJ
PeIXDozT4Qk6ep5evUDHL9Fp4by0YKXi3/4N/fXb9NYizUjEM3qZypeodIkK
Fyl/kXIXl7VGVsM92ZK7PD5zVoFfP5rA37WUBII/dJwpECrYkzP82g7L8He4
pPhnJBDJGP5eoPrvGQfyJFV6Pl+gkLmQvEPe9V2LIEZ/Effzx1yYp+2ojYJc
jbh55cRKU6ki4GJoDEijIlrivSc817fIHNTL8IgmHTk2Rs1jtG+cDpyjQ+Jb
XrtEJ67QqUlqmaKOGcprDr11nMW7P6a3f0R37tHiTZqSbI5P0fAkDVyl4hXn
CXOXndNx8Yk20Lt/y0Zdr2idWFnvxF/Wi0lUxtcyPtPUOk2hsw51QmodabUO
/aflbdCBspcJykgSbqQvVThR75+F95eNF4v4QibFexL2IlUWpuW0q+VrmyAi
R1ci1EkzCNOwTVr/uBqnLEhviPZxDZLSIL3AH/ZkdNRuGeYHJsbBBB56no5c
oKMX6NWL9Lrgefoa5O2co/wi9d+k8bu4eP1/0uJfw1aW7tPCWzR7k64u0EXR
wJFp4yPVd5V6r1LPFcpdifxU3C6eIFfnrT5a2gtbROJWQRz2IICHBrky1y5e
yZmCeaQwo9FjCiins/MEzxNhba1/wPdpPuG9pRvUfcMKjSiqjKrMHO0ccuVB
o2tRqSmbRaCnRfrSn9bWygZR86ZRg5ivMMRM14EJOjhBirKq/OtX6MRVenOS
TovJZeYot0DFmzT8luG4ZupH+MPcD2nuPiCfvkOTN+nyDTpvZZu3qjxN/VNU
vEaFScpPUs/Vn4R3osfS1RK9gE2PQQfuPjahwT9DUurOaNwoRW7HrMMciMud
Gafm6vkRXXaKsfKWk89EBEyAxuFdCwY7Hy7q77sXQQAnje/VJWk712lpvABi
Ence1I7+MWvI0ZJCNPvpxhFDXm9gtwXlPmfge9I0xk945SK9eomOiYoz+Kem
6Ow0yjl1o4UlGrjt8L/0Q7ryQ5r8Af4wdZ+u3aNrb4GIyzftjrWj8qPyDPVP
U3GKClPUe416JiknmhOvfeL2J6Py+N3jUjfW1QvOTpESI6z4rRVmtHAInCVI
LYqJgVGgZMho/BkwF1IKpLLCByxCjMKLuFBDEC6CbvChpmBWhpNP5m6ArqiU
UHd0XKoC1k59zlqStKAw7XcceFJXgAGchwEwDfor/jnbAD8HZiAcn2Wh5ojz
3L1A+SUqOSaemrhPF+7Txft06T5dvk9X3sbdV+7S5TtWbk/coLEFGpEslmep
f4aK00LHFOWvUe6aaFbSLh6PyudqpflqVx4zCYJ6iyMjhFfCL+CV0u0zCEU1
8UWmwDcG1LJUsWAUYhlwTVmXPPNJ0jwGw9Akvj/FbEiJwfB7j+eW7PIyB+Va
fQ9IMa2ge1L5Vd33ofnvqbj3iyjW+Seq/oo7W8AZtvwZc4BdAn3xFpXvGPqr
x9+mc2/TxNt0/m268DZdvEcX79LFt6yUnrgFDsZu0OgCDc/ToIhbmqXiDBWm
qdeVCkH3NVdKu74w9UvrErhHfYRn+Aerz14jxl9TizhK5SCIceC34z9wN0tg
/DNzzkdmRKM0KRFZcAGfZH1BIcssuh+YL7JYVZDHNd7LIZMgsWvCO2m94bA0
MyvuYjvA/om4whv2V/ADpu4NcRLs/VntuSrJZZmaWM8N6rtJ/XcUhdF7qn3j
9+jcPZq4R/7EXfUOq8/dovGbNLYE/IcXaHCeytepf87aNvLT1DNFXJ1Q4Fdo
//oIfZE1KnvPyO285eSfxf8p8gF9oJ5HZBPkp6NIiAnwwIIUER3qh8CG3Acq
0p0xFrLXo7IYf++yCIj33ZKg+RJnO/x7loiT8vlRtYSMa52MGmqtXXLCyghF
XTX+NVF3dTaMuiq9ujEAfx2FFD+zRzxf5HXSQ3dp+C6N3KVRiX3G7pLPUZB6
/vE7NH6bxm9JLWGJRm7Q8CJ4KM/TgLWlpPpmqTBDvRzRTlMOdtA9VaXdsXL+
WMUeln1NIGXv6UkSi0gpOWc14YHMjdzB3ESctM8oT7AM5kFLk4zESZ2wDGwC
pULG7ElpkK3UHLpQZkSEwCxQZsAwUrlFu8sOYCV+D/4vqSaBqg+as5I+iFPL
6xRxY6iUAWIMJ4UWroawi9Om+IiZ3ptwSqp5g+x7hjhMCjhWGpGkPVxj7LJW
j96m0VtIIzfxgKEbNLjovvvw1pWuU1Ee3DtL+RnqmQEz3dOwky7JZlQeuO8M
qo3kDypMrag5hMwUW9EkqQnhbmbK4topap2y0DZkrsRm8ISOGQNVLCczi9aM
OQTfSpiUHpAhqzFWwPykuq12zTzkzGP5OAiYEFVl5oL36Z4le7ge8DZgF+89
o6dwZnPwQZ7UMZQmLVbUVfFFNhqmRnk8K+zwTzrEbtQ9Mjt9t5ynH7gjxTDK
D8dUClGt+zeCv4ywmaVHbtEwp5s0JFkZvFGp+ZXmqXid+qpxBaJwX9WvV5Pn
KyOtFSVONPqEmdPkM31eoGbm/B0b2jXSGIBtbUp5Yw41tU+rB9S2EbY45hBW
pi2k2esV6cW2pKSZJ7Uqru9y6K82ygT2qCcS7sT73Yi8XwjecI33eUSh2Dzl
SQinPKoRMWXMoJZL6vAiy1KijT6JNZg+HffGRc6AS0qgP2il0BBfCYZui0GB
Z2yCoZs0uIRk0fAAVxQXiIljmfuuU2GOeiVDPbPgTmwp++4esGqLShUGk6NM
om8jlD4P/IlMIRMY0SasweyUuHaLIDqsbsmMaZKSKWvtXF1sccyY3+1YW0A9
zQNj2tKgjEHMRUoLZ/kogl4V8XVT+cLFJ3piJZg2uXCNRCNgLZciE9NOpoim
vHrYgIsov/82wdBUa8q3aVASW9xt1czBWzR4E6ns+Fk1cIP6JaclrmgKSwX4
FZC0Nu8q1t0zYmLTlOU0RZ1i884nJr9BeVB+pOU3rfzoa5igs5MSX2hs7WgC
RyjFrId2GiUZCBKWVmVmKr3PnbPwj1kX55mNMV2cQmErJyWXsMX7VI9FeExP
3mjSt+TF+WCr9sVM9d6M7D7A8fqIMy6WmDMmTOOHOFWZeWtsUKrUIxdvq4TM
maaAmZO/cEXTZ+LC8i3V1bXgRygqCUvFBeqbp4IQ1TtnX1nnZokZ6poxhrgk
r2JRK8qkld/WKU9uFEKyPy+qo6IYk+SfRamm1qR8gSnNk1oUc9UxLVypz8uI
RoEla7tMMVddc6QMCfDK0jwMyrHkBT0L4gFRomGTyi+SMSbUaUkPS+g12+I9
Dn3mSZ+g5GEbYvOwctch3HHZ1uKasjscZd2L5EJNL+ByjAMN0LaSO+GN+ZNb
B27RANwgNuHAzZiH7+fclfiBKSayuEh9ohSFqNWG4emZI045yYnyyb4RtfvO
aTM5L/YN2gNxWX1M8rJ6r1LpCZcp84xCZ+s1i2va2PrgF4VB5jIjqXPWvDf7
xC60+TCB3cIhMwgCBZcei0dAGNjjjbOx1SAoNFLknzAT6BUcgj3vIU+ik+wi
qGGmIvcXcWQeMGSSAoSDeGbxlj0zKN1iv2hXeY/kdIIP+jUMEmaC4g0wU0Q+
+1x7c+91ynOag8HlhJ1uIYjZyc6otcmzMlPxmqxqDUVtyum4TT3ASPE4O2cd
O2nlRf8xO+IVp6wFrV3srQP5ycxYKcQUZSWzCY40hWZY4GQZR73OB/JBr+KT
wj7FdBQcV8IPn4mFFYy3QsVDemsKtxCiMEtMWqdrwMgtRWWej+AQv+K9xIm8
8Zk39ZC3KMXMsbXEbAjHQWlJmQLJN/Arfu5atSZkSwpQZqznOoxJSfOZMq3/
siVlOE1Rx1Tk0zCM/eEH5CWKLs8aL7gHtAStwk1UbwqZmPYpUv8nPW2diCiU
ESUFjPiwmHQuFgn2zJNworz4vYtq7b0ufCggCiyYl+M9DoUHYUwJwDbtrq3h
A6bC0k0YDBPSrfGjtGXxdeEijLjoq7DgrElTULypXysXjYU+SfaNRO8CMf55
SRCFo6TcnLp+NRorlRkKI4LLdDARtjvrge1gFKrgXOkHW1fhp+L7zN5cL44+
m1lp0XSNfDfGg8loQ/2gXd41HfPKsBXOjg9KUl2zKIv4cvecuDKL5ZgRScCK
eQnASRARwujfoHTBfFlkH2HMJgo3Kxz5BdN6JcTO2YheuRQhtKqgpX8oFtIn
j8TWLzqe+aColhn0cc2tzyw2LCwSSJDkMws+c+Cthd3NWb4YEhYzKwG/8uBn
UMagmBaV9bQfMDlyLsZAZUyz54KDR2J24WxATMLQb7famQ8HlcpMu7eLE/UE
/UDR73ax2+qcGrFAD50SE4dcwD9dWKwYRJ9wkWIk/D5FKA24UGor0BrrVUM+
FZ0XtMTAXYGzpT5J/OSbdg0XlpDY7xjj/PKCJG0fAgOLllPOsnCAdhMWJTJz
kbFrVvsSswIDX0WxCnuI4txlJcpKLlyclvRR68yGYrbQyrFa6zXrGeDHrmGq
O5wFKhUozJgAayxlrZ8zE+YUQAqWR0oM6JqTnXUQyaFTrGgqb0LnRXifBrrQ
G1b0vDbcyXGQ5MQ5sZjl4DxixDxeqJtYrwSsEl5T8tXjTFZ+l+4WWRBmiu9F
TQ6QB5mZyIYdMgh23hX1ZPvC6rjHklpLhDie2WY20K5FDryd2FvQKcCL9uM+
9o/iK6EnnhRgjDkKM+CujHBBx9gXJcH/Bga5eGmcqIv2ojJ0hU8XtFeri8pJ
35oVytJW45vmp5OeS7yWECG0SeFTkHjA4W8HvnAA78hE9EhSbUIJZ3HHnLlY
tfnO2egLA/MOiDSlPDCfvXIMb4UH3/6KP64iN1KFkQfq6XYpkTsEeC7xYVud
ZltrUFeSSI5TTsLuCHeWwtpqQ44qALpg5DPqEnusiEjSpWTMCQbE+Twaoc/Y
muoLVFkZfKG1fT5GEGugr47XWKwWEyRrNYJ1pVXBRdaItq1GOF+J81CxkuhP
Rt1I1cv65Bm2jNakLXJElN/mmrJiXzX+RCvwjYV1rnxQE+DUxolL4nazA+VC
tWI1WhNmrLYDIhwXfv669WYUFkhJQFx+g0raGM9+vn/J6l2ArV+AxxaRvkT8
EC/OAoPJTgdKv2j18Q4Z+a2tY3yM2oSy4FephQSOESWBQx1rdWECAhc/o4Zq
NVbUf7RlSCtF0mKUnXPj/GZJGy20BSPV4erKaDacqnwVF8d97QrcXTn7qLum
gLPPmVS8H+1w9YWMtNl0SutA17TULDlrgjja4eZQvzFO+uaBeHEBiHNNtaTN
D+ptfK7QhgPmbQZuk6v0+iU74D2qxwE26/tuWYuJdhWrvneImbXOosKtrY6t
UudW+BXiZXVCqV84/UcLJ/Q/v2Q+MWoB4IS2HG3vXiC1AE32FQTM4KGsC4PQ
fi4haUa46BA6eNuu0boYQNDyjlagbES1NBvj/x5XBrReNdVXvpUH6L20zKQj
FroFgZz1xaS4rlm4jvYdTxp6GFeWqB9tBgNLFZ9ThnqWWbfLt+35SgXY0HaI
krTJllxrxZOR8ntScY40v1UQODONZittxz8jvY58g7UtmgUAPz5O5a3cz7vs
iAMK1KdJMydzYG3WYmTalg1b6JqPWnjwNPRioDaUcSQE0uL6xdh8N2jxi3iw
qm91HpLjnSvzNTIF7ZLY0qxVsVNsIcvlMHPgret2MQAbQl4ap0GBsFDUri8f
7aOrB1xZV5YG1EFxObwNB42FsBxrKff775D3/n5pH/KkJGXI1PXoMC98VuKM
4IyY/8kpNPe+4bq8lAk0RS0ac74rIswKQmv3SDvgPe1+8x38ofXSiRmgvVpb
v7PSh6QJPRLql2di9TNGUjswzBK0p7cl6qtP1s6UheSY6Pc462i7Spy4dJnE
mOZJYiYy8izlwfXceGtz0p/jSd8OiJgDEcxCaR59CILymsEl9AsN3aQh7SYS
fHk77EYmhEN3aFAS5EF/BXouPsCEMBeFmENSb6QFAMY5TqPbmM3gpOTtxCR6
ILW35IT0dJ2RgSgdrj2X2fBjPS+uNu1L75qagyYMFIisYhGNmq6HR02DI1Nr
BQyyMhZEG7iEHxmxkFH/EKBfcFWcGwzGsr4nefrZiKHkN2LKkPTr88UnnJ9S
ZpgXn2nxM9YjuY4Z6ZbeaWYjL4SAijn0vYGKefe+oRvgYhgeYoTLXPTehSN3
zE5G3iJ/2Hr6PjooPX3ltzCAhK0CRYPYgyeduR3yjVVUIpxylqAceNLn+Nrl
Sv+j9gtjhMScFSjSUmt9zdLnjL7n+EiNxag2L0M59NXKAQbXzFe0H6Oistct
6QgdKxy1q9xzvXnCcrt0q2Pg1bTUK9wIFJASYoSK6y6szkhyvLWMPkopM+2S
OqyVyXuoU56TvQaD6Z4SeqZBT6+AxvSU7KutVHkB3dtD4jXQ4e2Posweu01j
d5Cshjf6FoYxjMh4hjhLTE5eSgvYSKy4PhOzjjfUOq6QMuNJ1/3Ri5Vu/GNX
jEllyZMwFyW8tecvOdbSOa05hxjf4XqvdciT2cS8IpJ1I0VkrIKNpAoxngR2
gZH8bY4Iz82e6kamYDQERqy4niVFm+/R0b+PVGFBfOW6jquUmaTOSYf8NUF+
SpCfFuQFy7X916k8T4MLGPAxcoNGRbzxW3TuNp2z3tJzd8n75LgbNDLqkGfM
tYzQ0iEjn2nqwCstldkUknZwiRRtT0a0HDpvo1uOXLBGpDd0AJfG9fNW4nBc
tFSxBzBhfbxAHkYg7XpZGYm8bHSaaosqvw7jkXFVQD1si2rQqHlNawmuA3XR
b4ehKOmzsVbrOOrJse6PR+XFFSg+29hV9O5dNfiBvYza67EI2VtdmqWBOQxx
GlqgkUUau0HjS3TOtd9cuEvnOd3jJ2GEFK49OnYPmGtBoFELioBZAM7qrePc
4XhEtz0fqh2oQkOzfUbbW39IwD4wgUGkOqyL4VfFf12GEmko1eZ8U7dhraNa
XRgRurFlNu4VI57UNmxs8ryOR5NRs9EoKfEt0H0dSa6dVqjP6cjnGBsYjyg1
PIzg1TEaVk6kErhL9KTfiPHFigdiFiSBBj+DD486RQm7nEdal5exlIVpDOvj
8/IcBvqNzNPYIo3foPOub/vTl96iS3fp8j269DZdfBujNs/fp4n7EkHdQZsF
O2UWVZ3N2WkMfmY382ak9TIkyByMjJRWlQcFwoInA6r3jttIRyZFDUKHO0TD
SG3wkNU0BOvuG640wAh7aafHtxBZ942EDFUWK7BeHv2uYk5H1OrgZ2VAmJER
6a0zrmyeJh03HY9qk98+KvqPJ64+5urRbZcdC1coc8XK524ZTNxzDcNYC1MY
1dovJjc0RyPXadw8p/crl2/TVXHpk2/T5H26+gO68gO69AO6+AMakmK69wZi
kfY5DOjWKDRS/mPiZzz59AlO5oIh7snAXYY4jvhumWpVB/ryFaWE2WIClEKO
rPS7cx1goobQpbaQ6tLoKNBPHwRyTaGDPNDR/NH48lT82wr9zG6G9BsldfmA
XRmuYFod+fdUQz4w5C87TWfoO69QVgq17quUu4qR9b2T1HeNSlM04N720YuL
dOUmXbtN03dpRgYkz/yQpn5Ekz/CUFkGPb9ognBmT4mOnxCAXrtUUfCKg5mo
AK3IYs5gX2ZSVbBlHk6MdMe8R3xp75iZB7Om5TKXBTaocc4+5ZYR9uZ5kGnf
YR+odejHKNp2KujjQ7roi4oO11IADtrcx45O8eU3CUSr4/5EFdw1zmm7BOA7
LlPmMnVepqyI0S0fjuSvUuEqFa1e/bGJObq8QFNLNHeHFu7RjR/Qjf+Bmy/f
Jw5Di0tojtESiqF+4yp0GjhfdC5kgsyLC7yMnSJsM+/Kl34NOrOjfM2BMdO1
brY1T75y1y8L+BH8uKMypvR4NYfDXmXR2hSzi/b9Cb59cN/CdVbiT/ley76f
0E/ooPzWIzBHCrp+W2qlr36PIf1GCUyT54r8k+bp10eafok4cRnCm3THJcpc
ok4x/e7LlLus7/7Z0lUqi6ZOTNOVOZpdpKXbdPc+3ftreutvcL20iMbd9mmM
Pz0hhvLqRXrlAj7nAtDqpccojrLqrEJcP2QfbtRiFrdB/V7sfZ5MxRVN1MTX
9YsaNgg2Dny8oaBPLnMy7e6Dz6xr7Et1Lpg+y9fjDlpPvynXfhE3I0TlC0ff
NDpZs022zSmu701clfgGs2+2XqQ2Se0XqeMiZS6aBT2dkw8ICxfxMeGgIH7l
Gl2fpXtL9Lc/pLs/pHNSXW2ZpDe5JGOLvkCHBcf947RvDJ8SYRpx/bIZs/HK
PLB1DsgIRZvTDBD6vPExTdCTnsxyYtN6yB9VqZkWBveAA1fjeASUzonYHAcV
3bXvCEV3rdzM6AwaoWGLT7L82Fe67jAZd1ePTN5XDVfpablArZJEQz/YIW4z
c56y56lrgnITlJ+g4jkaFMhmLtCPp+nm7N+VrtAZCSKOjGNy/2aZEr7Jzf5b
L/OC1pbtg1yFz02npdNL9ds8MTqrkMyKsqWk89o8sVk+f9R7WVOZnmYB85AL
zSvugYPOuUqAnqnop8w7Im0yqqORdsoME3NohJCZXrRVYP1P0E3xvjo7agJD
0cH3t0xQq6Q2gal9nDrGqHOMsiPUNUQ5kWS0lxY6qND7d/u7MXebJ5NkYjLA
ImbB00ngMKNYiWRqGDxYJ/uw7509/Va3T81BvkjXD3dxgt2TqoSMPGvx7jED
Taf7jOr7p6atStPmJiXJiG2LSXfMy5evUpZh9hLBS9t2DC/PvrV6F31TrN5v
/jGag/nMOToryT/LBcWqFiljW0aoZZhaytTaTy0Drk79vRf+9tnD9PWTYn/P
dfIrXuiiF7tt9gJMx4E5DvyNNuvLRpvNxnNf3kff6ns+NuHmJFLrPZmlr3YI
074xUvFYV231zSmzVQxBtLbv5TORdFi/aBjNmsQpNIySmpJscVWMPpC4Ku0Y
GGdw+hydHpc0RqdH6bQ4p1NDdKpstbIjBVzZVKeieKtf7KEXZV4NxkTh2NRL
mwo2O0R87gLMZuDbbBLeejZBxYFLkD1jVhE7ctEaiU5Mmpnhs4E5KxMEh8AJ
7uYZs3lcoDkfTEhVNZJZcZfIDgpPjhHSKJ0coTdtxYOnj5foWIFeydHBDmo6
hTd+tY7+62b63Rr6z3tx+ifH6Usn6StnMGPIN9pw5TsZzNHyvSzmFtHJL/ji
i6Y7XshAbXJA+ao1BZtSQz6LFy8UzbfDOLETq3M4ebHa6rGrlYLzjOuL8Vdo
BoDyTTs+/EAIfagaQvj5G7E1ZT54fJBeFyf7ahGzFh3K0b5OamihHW/i4rMH
6c+a6U8O0B8fxumXT9BXTmLGn2+00LcEpe9m6HudMg9IF73gUBILE+tSiPBP
9EWmX5LJcmTWBpmd6enITyGV4NkBVRTVTdi0MRXTcsWghhk6d5TZmMy8xfuP
JWRPtvspQh82HyMl4AdQLozQ8WF6fYiODdJrA/SqfLl9uIApr/Z2UWMH1bTg
ygsn6DvH6NnX6GvH6KsyRdbXT2F+qG+20LfbMGMUX/m+oCKaABR0fjJREgHB
vPEWm+RNIgFM0CTJk3kEE2GWJ1NOqmGxwugcfDqrGmzLSS7zpqciSUl7KLWd
86MJFKQFCF/NHRumY0P02iC9OkBH++mIeLr9eUyK1pSlugztaNPKjZc2T9pN
G3K0UeaIwexZOstYNK/WZpNSRHP0otSRmcsei8IcLWQ8+XBeJxI8Jh+1sHAn
HcUtag2f+gmMSpTt/YNqEsIrvDpErw7S0QE60k+HS8rLYy+10kaZFO/5Fnqu
Fe97ro2ea6fnO+j5DCbRg8V30QYVNkc+JpfDTzH1nkw7p7KqSkupiqI3Pksb
eN3qIryt4i09qdLsFi9w4HxFu/E9z7UKr2e0cv0Pq/KpMVlSy6OvZ1jaVwa1
Acl7b3Mv5oRszFFdN+3K0g4Ra3MHvSTTJW5sJ8yfyIJm6MVOzKqIuRVl3ryN
3ZhakGXGFIw+yywMYk6a1BaZis8mtPR0vo/AzfeB6R4xGwU26PVXt+dJk5BO
B4/6gvuAydNvy7TR7BelsIsk4gOV9GerSKpfbBwp0+EBOtRPB0q0XzKzp5ea
8pgZtC6HWUJhTDJ76JZO2txJL3fSS4LApizz2WUWulnME1TqzKRmoSagxlMa
aWKrM5tsi+bzlnbQR+G4Bm2W5z3jNs8/R0+vXDZhPQnhVbF13lyTqMLoz5lH
Er3FHGUQr0wHB+hAP+0v0T6RcHcBM7025DHx6y7xuDu6aXu38rOZL6Q2i2Vu
zmNuVcimc63qbKOYaDaQOUi3RjFjUWZrkQgomsN1AFPHeTKz6cPxWoknqzAc
cYKpO3pj6l2k+niCPfFG6Cs4VCZOBwZofz/tK1GzStdncxKmdvbQjh7anqNt
OdOyHpvv13PT/3o6by7E6CNNgsJ2mRvZzbzhSW0r3NFfqcTK3LUP71hujlFh
84p+lnrVZn6Vlcb8SBs/UU2eQOU5WDa7W7Nbpt1ukKmm60S/duWpJk+Yghlz
MSvKedqOcELma4YUBcIUx2mRgVnZbja1Xae6DncYOyqKVIhE+x6KwlFPViNQ
OzsiPjXSvl+q6jM/WUUasa1HDpRp/wDt66dmAXJPCTNlNxVFrD6IxRdrC7SL
LaYGSrVTrmArHHDdxN9hNQ+tpHgyZ3XK8i9J5/QesBlJbd5vm/3aW1cxKBdc
Rvyo6iWY+ZSdrXMlG0RQKQZiUpREiiKmkK8vWm5rdE51T6Zal8noOQ/MwE5j
gPcyUT1n2PIqeoS6qczkjuKRs6spshed4TtiQ4tvzDUculyqh0/Wt0HqgUHk
fV+Z/Gar2tjaDhpLcc7rJHl+rc2AtatImjCDvhfUiMfCFodaPtVormHZvAkS
c9BrS0UkgPXw1I/YQg+RT9PC+uMmh7QFqO9e0eKochxwpdHqPQOEBTn6qUnW
6Gh0Czv49SVd6wG/4IotFoLAahBiCbtM6916CtEKEtpCEPIGfjzANOqr42ag
vkqrsB+z3Epb8zJP5XIrrSf7sbLQvkFqLiPhCpYOSe0eoKYByzQEwVojfr2b
4biun2olgZ3kSiW1ljuuWMt6EVhXIlolIyov4u5HZm1G5nRO8mU6LpoxRPs5
DZK/T9ZtknzuBX9YkCbYPRAvmWQNGxxgLRhJQZ1d0RVjOPl1mse0W4nF2q9C
3oiEKY3GI88idU+gqfN2frqaZ0lXcjpE+zgN6hyEu03nmsrUFK0J1KCeWJYJ
CuvLoq3pxKo3yI2U16vrtLVy2Jje64rb91mudO7ez1TJldoO56bZ1jHbq2tH
yXt2a458rEvUWLbYoEGWOsJCR35i9SOc+/W2lo0t/oTnpxG348fI44gsUiSx
ri5b9ITlUWJVXUF1RWsxkBumA2jz3o/1+WyVkWZZUA3rxkU5Hqy81a30Fa2W
hTW05K6GSt5kjS1bgyuospaYW69LFlRTtZReAeRY15L5ZdPGin2PxHJqTzR0
Rf/2DFG4O7auGtY6aIqvVFa5V9Zj0wyuyJ2eK+H4pzECn+sicOqhJOJHXnVV
uX+WQDcdz7Mt+BlgDb699i5dtU7y7Ls82+p2cm/T8IqV5cLofCRCOZQV6Eb1
R5o/W6dujVm2+B9dFziRP/FCnLlgv63PtU9WlZR8yjnnFdmF/KFb89EWIwxj
6yk2mXzpaO1Fbe4PsR6jpz3QQEpXjv3Vd0Lq4CgdQH8X58jfbws47XNrpOoX
R1jQc9iSrjcpy04GWIjS2sV5nxY3ElsH0vKSjuVFVkuVFaF9G02+PA+j6kFk
jdBoddNmXclV+ZPlUE3T97jlPHX9TuFSz+MrgDrdc1+h6XrU/yKBh+RQmEG2
dUVYXZhW1uoNo6w06/qJshhroPOMYZtyK+DaOq6yxqK98dfljb9W5Y3y3INj
pCnAGsqp6MX7dZ1cGT0SW0NYltaNra8r6+3GNO835W2/Xu1tQfQ2z8dGXqj/
pP17v1uXubJC74qVlD0d4Qa5Pitv+pdV3qT88CvsBVgdOnBP5z0WgMYq0mHM
ov+NPO03TDci/Tw0LjN0hgfHzbJlmWt5Yir2638rv/7NRF6ibw31KZx8fg5+
97D9TtYllxVOk7/DXY/YXb8rd/3rxF3JdrmHjYHfk7s/a5Ik71pjz/x9ueu3
KFkjdlrz3+Tvn4v9GjWuwP76BfkrMEPjwZ/Imfcz/xf1tL0o\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318070688]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elliptic Functions", "Section",
 CellID->20135],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["JacobiAmplitude",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiAmplitude"], "[", 
     StyleBox["u", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "amplitude function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"am", "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["JacobiSN",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/JacobiSN"], "[", 
      RowBox[{
       StyleBox["u", "TI"], ",", 
       StyleBox["m", "TI"]}], "]"}], Cell[", ", "TableText"], 
     RowBox[{
      ButtonBox["JacobiCN",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/JacobiCN"], "[", 
      RowBox[{
       StyleBox["u", "TI"], ",", 
       StyleBox["m", "TI"]}], "]"}], Cell[", etc.", "TableText"]}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "Jacobi elliptic functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{"sn", "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     ", etc."
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["InverseJacobiSN",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InverseJacobiSN"], "[", 
      RowBox[{
       StyleBox["v", "TI"], ",", 
       StyleBox["m", "TI"]}], "]"}], Cell[", ", "TableText"], 
     RowBox[{
      ButtonBox["InverseJacobiCN",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InverseJacobiCN"], "[", 
      RowBox[{
       StyleBox["v", "TI"], ",", 
       StyleBox["m", "TI"]}], "]"}], Cell[", etc.", "TableText"]}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "inverse Jacobi elliptic functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["sn", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     ", etc."
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipticTheta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticTheta"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["u", "TI"], ",", 
     StyleBox["q", "TI"], "]"}], Cell[TextData[{
     "theta functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[CurlyTheta]", "a"], "(", 
        RowBox[{"u", ",", "q"}], ")"}], TraditionalForm]], "InlineMath"],
     " (",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"a", "=", "1"}], ",", "\[Ellipsis]", ",", "4"}], 
       TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipticThetaPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticThetaPrime"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["u", "TI"], ",", 
     StyleBox["q", "TI"], "]"}], Cell[TextData[{
     "derivatives of theta functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[CurlyTheta]", "a", "\[Prime]"], "(", 
        RowBox[{"u", ",", "q"}], ")"}], TraditionalForm]], "InlineMath"],
     " (",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"a", "=", "1"}], ",", "\[Ellipsis]", ",", "4"}], 
       TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SiegelTheta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SiegelTheta"], "[", 
     RowBox[{
      StyleBox["\[Tau]", "TR"], ",", 
      StyleBox["s", "TI"]}], "]"}], Cell[TextData[{
     "Siegel theta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CapitalTheta]", "(", 
        RowBox[{"\[Tau]", ",", "s"}], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SiegelTheta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SiegelTheta"], "[", 
     RowBox[{
      StyleBox["v", "TI"], ",", 
      StyleBox["\[Tau]", "TR"], ",", 
      StyleBox["s", "TI"]}], "]"}], Cell[TextData[{
     "Siegel theta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"\[CapitalTheta]", "[", "v", "]"}], 
        RowBox[{"(", 
         RowBox[{"\[Tau]", ",", "s"}], ")"}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["WeierstrassP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassP"], "[", 
     StyleBox["u", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["2", "TR"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["3", "TR"]], "}", "]"}], Cell[TextData[{
     "Weierstrass elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[WeierstrassP]", "(", 
        RowBox[{
         RowBox[{"u", ";", 
          SubscriptBox["g", "2"]}], ",", 
         SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["WeierstrassPPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassPPrime"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "derivative of Weierstrass elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["\[WeierstrassP]", "\[Prime]"], "(", 
        RowBox[{
         RowBox[{"u", ";", 
          SubscriptBox["g", "2"]}], ",", 
         SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseWeierstrassP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseWeierstrassP"], "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["inverse Weierstrass elliptic function", "TableText"]},
   {
    RowBox[{
     ButtonBox["WeierstrassSigma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassSigma"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[TextData[{
     "Weierstrass sigma function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Sigma]", "(", 
        RowBox[{
         RowBox[{"u", ";", 
          SubscriptBox["g", "2"]}], ",", 
         SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["WeierstrassZeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassZeta"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[TextData[{
     "Weierstrass zeta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Zeta]", "(", 
        RowBox[{
         RowBox[{"u", ";", 
          SubscriptBox["g", "2"]}], ",", 
         SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->23487],

Cell["Elliptic and related functions. ", "Caption",
 CellID->27196],

Cell["\<\
Rational functions involving square roots of quadratic forms can be \
integrated in terms of inverse trigonometric functions. The trigonometric \
functions can thus be defined as inverses of the functions obtained from \
these integrals. \
\>", "Text",
 CellID->29033],

Cell[TextData[{
 "By analogy, ",
 StyleBox["elliptic functions",
  FontWeight->"Bold"],
 " are defined as inverses of the functions obtained from elliptic integrals. \
"
}], "Text",
 CellID->2088],

Cell[TextData[{
 "The ",
 StyleBox["amplitude",
  FontWeight->"Bold"],
 " for Jacobi elliptic functions ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["JacobiAmplitude",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiAmplitude"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is the inverse of the elliptic integral of the first kind. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    RowBox[{"F", "(", 
     RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". In working with Jacobi elliptic functions, the argument ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is often dropped, so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"am", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is written as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"am", "(", "u", ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->12935],

Cell[TextData[{
 "The ",
 StyleBox["Jacobi elliptic functions",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["JacobiSN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSN"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["JacobiCN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiCN"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " are given respectively by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sn", "(", "u", ")"}], "=", 
    RowBox[{"sin", "(", "\[Phi]", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cn", "(", "u", ")"}], "=", 
    RowBox[{"cos", "(", "\[Phi]", ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". In addition, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["JacobiDN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiDN"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"dn", "(", "u", ")"}], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"m", 
        RowBox[{
         SuperscriptBox["sin", "2"], "(", "\[Phi]", ")"}]}]}]], "=", 
     RowBox[{"\[CapitalDelta]", "(", "\[Phi]", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->19779],

Cell[TextData[{
 "There are a total of twelve Jacobi elliptic functions ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{"Jacobi", 
     StyleBox["PQ", "TI"]}]], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 ", with the letters ",
 StyleBox["P",
  FontSlant->"Italic"],
 " and ",
 StyleBox["Q",
  FontSlant->"Italic"],
 " chosen from the set ",
 Cell[BoxData["S"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["C",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/C"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ". Each Jacobi elliptic function ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{"Jacobi", 
     StyleBox["PQ", "TI"]}]], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " satisfies the relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"pq", "(", "u", ")"}], "=", 
    RowBox[{
     RowBox[{"pn", "(", "u", ")"}], "/", 
     RowBox[{"qn", "(", "u", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", where for these purposes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"nn", "(", "u", ")"}], "=", "1"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->15993],

Cell[TextData[{
 "There are many relations between the Jacobi elliptic functions, somewhat \
analogous to those between trigonometric functions. In limiting cases, in \
fact, the Jacobi elliptic functions reduce to trigonometric functions. So, \
for example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sn", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "0"}], ")"}], "=", 
    RowBox[{"sin", "(", "u", ")"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sn", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "1"}], ")"}], "=", 
    RowBox[{"tanh", "(", "u", ")"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cn", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "0"}], ")"}], "=", 
    RowBox[{"cos", "(", "u", ")"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cn", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "1"}], ")"}], "=", 
    RowBox[{"sech", "(", "u", ")"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"dn", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "0"}], ")"}], "=", "1"}], 
   TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"dn", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "1"}], ")"}], "=", 
    RowBox[{"sech", "(", "u", ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->14790],

Cell[TextData[{
 "The notation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Pq", "(", "u", ")"}], TraditionalForm]], "InlineMath"],
 " is often used for the integrals ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "u"], 
    RowBox[{
     RowBox[{
      SuperscriptBox["pq", "2"], "(", "t", ")"}], 
     RowBox[{"\[DifferentialD]", "t"}]}]}], TraditionalForm]], "InlineMath"],
 ". These integrals can be expressed in terms of the Jacobi zeta function \
defined earlier. "
}], "Text",
 CellID->24962],

Cell[TextData[{
 "One of the most important properties of elliptic functions is that they are \
",
 StyleBox["doubly periodic",
  FontSlant->"Italic"],
 " in the complex values of their arguments. Ordinary trigonometric functions \
are singly periodic, in the sense that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"z", "+", "s\[Omega]"}], ")"}], "=", 
    RowBox[{"f", "(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 " for any integer ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 ". The elliptic functions are doubly periodic, so that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"z", "+", 
      RowBox[{"r", "\[InvisibleSpace]", "\[Omega]"}], "+", 
      SuperscriptBox["s\[Omega]", "\[Prime]"]}], ")"}], "=", 
    RowBox[{"f", "(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 " for any pair of integers ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->18965],

Cell[TextData[{
 "The Jacobi elliptic functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sn", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ", etc. are doubly periodic in the complex ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " plane. Their periods include ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", "=", 
    RowBox[{"4", 
     RowBox[{"K", "(", "m", ")"}]}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Omega]", "\[Prime]"], "=", 
    RowBox[{"4", "i", "\[InvisibleSpace]", 
     RowBox[{"K", "(", 
      RowBox[{"1", "-", "m"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the complete elliptic integral of the first kind. "
}], "Text",
 CellID->11001],

Cell[TextData[{
 "The choice of p and q in the notation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"pq", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " for Jacobi elliptic functions can be understood in terms of the values of \
the functions at the quarter periods ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", 
    SuperscriptBox["K", "\[Prime]"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->19105],

Cell[TextData[{
 "This shows two complete periods in each direction of the absolute value of \
the Jacobi elliptic function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sn", "(", 
    RowBox[{"u", "\[VerticalSeparator]", 
     FractionBox["1", "3"]}], ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->11807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"JacobiSN", "[", 
     RowBox[{
      RowBox[{"ux", "+", 
       RowBox[{"I", " ", "uy"}]}], ",", 
      RowBox[{"1", "/", "3"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ux", ",", "0", ",", 
     RowBox[{"4", " ", 
      RowBox[{"EllipticK", "[", 
       RowBox[{"1", "/", "3"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"uy", ",", "0", ",", 
     RowBox[{"4", " ", 
      RowBox[{"EllipticK", "[", 
       RowBox[{"2", "/", "3"}], "]"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24567],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx03Xnc50dVJ/re1yzdeZJ+eiF0mAEFh4nigojg71EZRA3uMjjoXFBARAe9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   "], {{{}, 
     {RGBColor[0.3489844782615441, 0.15402297659562703`, 0.607520218482658], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3mUVdWVxm9NTIVgMdQLVe9BvVf1iiosoLDWcgI0prUdQQUE7QAaUGRw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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwll2uU1WUVxnfMHBziZo5wFJA458yZjnAOnGHWUoZb0lKT6wDKLcgL5HAr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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.460121434784633, 0.34726012978688, 0.763736655447975], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNvQeUlUW2/n06QXefDgea3DR0piN0AEUBA1nMmAEDoIIBGDPmHDDn8A2M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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmndgVUXaxg8tISEJCSVBULn35l5IbiA3BRGBSO9ioVgQRFHBRUWlqFhW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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.569289166252783, 0.536351471105676, 0.9096234016915501], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnXd4VNXWxidgAiEJCURCMpOEECYhmUCGBCsWwIqggr0j9t57w46iFAGx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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3d8lVUShr8EElJICISWgCS53BuSm3ovWFCUDgIqHaSpuFZQUNeCHRuC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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.651000545487549, 0.667638921102842, 0.9114861694636148], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXd4VVXWxi9JKCkkgXSSQBLITSc3N2KZsYxdFOyCil0RsWDXsY2KvY0F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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3mcz9X3x9/IMphh9hlkPrN8PrN8zGcZad+0p9JiKckeSUhpV1kqWvgq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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7327119247223159, 0.798926371100007, 0.9133489372356801], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXd8lMX2xlcSEhJIQoCwSIzsbsJuks1uliBY8CqKeq2IgiJSRClKkSKi
YKNj7xUVGxZsKErTC/Zrb1iwAwqIir13f8+XZ/K5vz/ezzs77/Q5c+ac55yZ
jZ8w8cgJLSKRyPutIpE8vU/pFok8VROJvFgUidSURCL3FEciSX3rqvDcNpFI
rcJPpJVGT+/ySOS4TCTyaJ3SKr5aaUpaO7xI3+/Qk1GaL7ORyEqliSt+c1Uk
0kvvjvmRyHNdI5GTlX9H5bk7qnraRSLLd4hE2lZGIpN2jEQeURsm7+hwVUu/
+T1Q6U8JYeJ5TwnxCbWhro3riis8S+HOCv9XbXlOTx+150e15ayGSOQ0dfwm
xd2ip17xf+UikRfikch45dmqts1Qmr1VZnkyElnW5DruU5t6qLyr1M6iikjk
tlb+fXW12q1+9lR4dpXfhepjmdq3i8K9NLYLlKZz1v3/r8ofp753UvlTVe6p
evoo7ff6/l3WeS5Snd8p3f5K017f9lDc9aq3THNUpDm6X7+3qK799c6qro5K
s5fC+6iuYR01HurTS6WRyFG1mttUJPK0+vWT4gcp/hg9xyucVX8uLIhETkpE
IpfUq06F31RcTnU2anyeUf1nNLmdtyr/Pvp2XoHb26212/zpTipP4Z75ngPC
zB3vgSF+s8qZrXL20u8R6t+fDc5fqvCvtS5zaZHruVF9fFbpz2oybbyr8DkK
N9IGjWEy6z4vVHgnhXsrHNVc3K733noeKvJ7ocr5U9//yHpc5lU5bRe1Z7LC
k/TkFUYiD2sczlSeFgrniQ5HaWxG6nlf9c5s8li8UuT6kxqTzurzftC4yr9F
Y7KLvs1U+xtVz8/qV+fWplXe0OfKIvfjDqX/XbQ3U2nOVDnlmsfWmscHmEfV
dWaDx+dBpd9c6Ll+XmU+p2eTfj+f77eaFHld6/IThc/J81xAQ6OU9xml+bjQ
9Hmayv+vyn+dtay5navyr1K9U1TXS6KH21VGeaXzv600Y5R+qdIvU/h70XxJ
g2npBaW9QvHnKn5DF9Gf4vdT/CsdIpE5rdzWL9TGJepbe/2eovhtGpdLFT9O
76v1nq/2nKHy31I5G1XO6Ypfqfi2as9Zil+v+K8Vf7bCGxX+TuG7Vc47SrdG
6c5U/DrFb1L8aaG/0N4cpblfaW5QmjMUvivUd3KIu1z1HhTasrvqGqVylqic
JSpnktIXaJ4v0bf9leZivXNKM17x+Yq/SL8nKvxJ+HZPmcZRPGqp5rqLeEuR
xruj+nus1vHSOofzVP5sjd0hyvONxnkOY6V0W0VrI/T9DM1Pb7X7BIUzqquH
wkcqfJPGs4XynqO8ByrvDgp/Ll40TeGIwp8qPFXhNqrrpJj4lcIfqPzJGdNn
kdLsoH7dobIuaHLd1Fuo+H+0Tha1Mi85t8H85B/xuomqaw+V84i+H5t1++DX
T6mN00VXSxXfV/GDFH+/wvspPEDh9o2RSDs9QxTes6Xft6uZ76n8iRmvk3rR
23mqa4H6GNNYLRCtdVK6VzXuQ/VOKX6e6pqv5wHN0XKV30/lD9O33bWWl7Ry
urTC9+ndX8/zRX7vrLznVbkt/dXWIrWlVaPH8dMqt/cExV9Y5fLGKby72nmM
wjXKOz3QVKXCM9XWIXoGtfZ6HRLW7AMa7wNV5lzV/6DaP0/v94q9vqZqbBrh
5608z3u38JzPCfN+mMa2s/rzenv1o9z0B+0tKXF577LuSl039Sb1/V7RVLWe
cW09tz8qPFbfZgUeW1Hq8ImhjTNDO9t1MM+CX81U/cflXN91rUxHu7bw3vaY
2n1qnulrRqCxM/UeljPtd9Nc/am1fRe8Re3sqriE2nBKidtH287W3I7UuOyq
smYpfI7CcxS+QnWNUZqz4duKuzTp36crTRoaVr23lrse1td+2muWiT76qszn
9X1EznxiutL30O+7lH5MuePgG1e28p58vsJDRftv1XqPz7R1O9k7lmhMx2lM
1olGjlZ4B43JuZrjGXnmkey/7Muzqsw38zVu/4jvD1c9SbVnotpTpXLK1ZZv
JQ+MUPwypb2/yGXkaXze0vjspXKe1Fo/UW34l+bkUdV/cJF5wlSl6a5y3ipz
Png0dSPzHK7nigLzznVdzD8HioiO0bNQNDFM9PKU6H+j2tar1HXS5q5K/7vS
36rwjorvEOiAZ2ygB3hw8/7wmfbi0Yqbne/9gDC8nXSMD/N1YsjLWHULYWjs
Xo393mrP6WrPAI1Dl2qPU3elG6/2/Km5S6u/UdU1QH25U7RxWoX7eY/y7tXo
34tLXMZaxQ9SOYlq02lvzd1dGreaNt4neDPmBypNlP5rvaxUOUeonA3Ku0Lh
fgqvV/jbIsc9rna0En1V1rp/XxX5+3LFv1DktXW/wsuV93Dl/Ui/Hy5yW85T
/N/iUR1rLZdM0xzfqbm6B3lG4Vnq190Kv1bktb5S6R9RG2cWen2mNT9X1Tv8
oMo/qNF84ZMi13OZ0i9TfF/Ff6jfG4r8nq/49UXe20/RGPZVG4rUhuP07UDV
3zPIDweLRg7Sc7HCnTTPbQOP+FTp5zZZFv24yO/TVc7XXc3r4fNfFvl9meLn
llkOfxdeVW76op+DAu94VGlf0Lcz1K4eoqtvirwnXK28Q9SmgxV+Ut+/7WoZ
lG83an5+SFqOukrhr5KWUY9Ue4/QcyW8S3Hj9ezKWla9u+h9p9bsSYo7Muff
0OOoQJ+0Z2hr85OrWjnf/Up/stL3V/rd9PvKEtMc9MZ+NSnsWSO0Lv7ROrxV
/RqjcJ7m5XaFFxa7TPqIDgCfgM9c3cr50C/YcyibfeeNEvPb/sjAynuo8r6n
9kxUmtc1/tcr/jfxiaH6PUTPBIUH6/0a67DMMsATSj+23HLH5QWec9Y68/6r
xrCq1mN6ktK8onyX6dsAtbm/nm2Ki6gfoxR+U9/66n2Yns2Kn1xuGeaGAtPX
jQWmsaPY+/Rcq9+HKO3Bej5R2n+gKYXfUDmT1c5eGoNrlGao0g7Rs1DhWxR/
nNJ+ojS3aE2uDXIY9PBpoWXmCvHO2WFf/lrzkBNNv6m0XyqcVfi5DtYZ0B1+
Fc08ojlpL959gcr6Xmn2UJqvlGaG6tiZ+VO6TzppzRQ7zyGSUz5oMl85Rnkf
qvUec3e55bSYnv6Ssxa1tb5xmMIL21rOhv6fCrT7LTSiuj6mbW0sxyX0HELe
Nq73fpW5XvMUV/xG9Wu4vh2h+GdrLB8jG/fIN+10yvN6Ya1At4vYEzU377Yw
L0DWQc4ZrfS9WloX6C/5+chK/4ZHLiizXokeeUXS+9ZLCp+Ys0zaeudIpFjP
WM3H+HLTDTRzsvIuLLNesCjlMWJ8blMbflYb3mrhMV6V9DgPUvr99b1I75s0
tvM6+nep9rJzxH9+bml6Ze9k3/xN/T8fPSPfuh97Nvv1t8jmCn+o+A+0rt8U
j5un3xsU3pp1HmRq5oDxf0/xL2S958wo97plzSKDM2fM1xaVObeVaerzQpf3
Sr71BPKxT7HPzW5leeonhc9T+ON8y27/FFh++1Hx5+r3RoX37ax1XmJe2Vdj
c0+tw9A3dA54MVDxH4quehd5TpD5hivv3FLraaS/WjTwcpFlwbO0NqMa0/+I
LjdpDB8qdlkfqY8fZV33QarzOuX9QeEhKv8jlf/vIq836AwaO0Lvu5HxFJ5f
at2A8FeKu1bv2kLPB+1hHx9f5TCyaFW+eVip2n+L6KRRczdc/Hqc+jdWT+9S
4yIpPavV1+XIOkrfPs9rlDDrtFbf6/RUqa5WKqe43mXeJfppUPizFl4DrIX9
FX9PWBfIpZ/ovanMcuykBsviyM317fyN+Blqyzl6+qs9Y9TmtYrvrXLeUl1t
2BPLrB/xhh5o80Nl5rfHae5+0bhPKTOeNLnMmNI1razTFLYwNoAOzB65TGPf
OW79r0zv8nqvTWR/9CXkf/Z4wuhNE9j7y6zbUufDod73yzwujElK5eyjcg5W
2jvVx6TCm5X+HcW3r3eeLer3xQ0e64lK90qZ9ZdflKZPvcfovqjLRK6OKX6P
eo8D48R4MddrtX6vF61cpblvqzG7Nu494vQq637ofedA0y2NsdwfdV7GuUz0
+JrW+LUal8dUziyVM6XI+wz7DTpmjdIvLLcsPTToYOhTR4vmj6p0ub+0dF3I
89D3zDK3ATwDvRGdcTQyVK3lTeRg5oO5eErp55RZfijX9xviDndU39Ypvlee
6ydMG2blW+ZlbD/XGF7aYFpk/D8o81idoXKm6+mrun5UeXvW+1u/UvNOeGpt
yEN65BfkGLDEbSrzcpWZbmdZtVuQXRmzdBhz9PJ7Au3dpHE7O24ZA9kOfg6f
vFI8eAR8LaxH8DPWIWO4JIzjZvGBZer/BJX/S4Hf9dCC5iSpubmGfarUOOM4
fRunel9p4/AEfZ/Q4H3hZMVv0Z51quIXR90+2jZfMvBwpbla4Ys0hhfrWaN6
doz6N3QLL/6u0HT+d85yFbLRnznrV+hW0MUnTaaNuQq/o7E9DZxJe8Vklf+F
2ngfeGPKevGx6sORReYbN6uP53f0b/rdrMdfqjxPtfH+uEHtWR+1PHUxuIvq
mqn4ZSozlnIeeAC8gP4uUd4X27gN4GjgaU2q6wCt/QtKHI9s/n2h1+6DpcaL
pyP7ih7rM6a7A6PGCH5WuskaszfbOM3FpcYR+iJTiz98oOeHQu8NvK+OWL5E
hmfvRt5nnpH5b2HvrXbdyCPN+sex4i+r21q+H6bwYwrPVvgXjc1JYILsP5qv
0RrPm3bw3vkr8pjq+qGD90b2VWTJOYXmw0MVvyq0440if2e9f6r2bsk6P7rF
L4WWKZAZqIf9fTzYToNxwj9U/zQ9MyhH+dbq+azQ+yjv3dSGXupT+wbT0PGq
98nQjrEq54QG46grirwHg1W+18F7Mb+Rhy8KtLe1g/c69lvkEOpE5mE/Zh7g
LeyZfGfPWqQxGa/yu7Qw70XPhpeic9/T0b+fSZluoJkPFb+mjefujmLjjtDN
SH1fL7oaUGQefUGReelPSr8VeU6/G0TPg/X8XmqZmL2WvXVZqcsiz3Tx1Wl6
imhHG8dR3spS2zAoh30hGfbQ47SeNtRar2Bddg2Y3iaN54UN/t1JdY5T+HNk
B62X59SveSrnEdHSK4ofqTQX6NtVxf/T/3mz525oabwNzH4f1X+R6nkVPKbE
fP37gGfdF/az3oq/UPGvtDLfBg+GdzM/zBM8oZXGqrjRecC2wbrB+8F9rqUu
jDhK81fW3za2NBYIVv2k2vyd2jy3nW0V2CywSywrN4bFvnNXuTEjeO/f6HpZ
pwP33dxk7HdknscA/v+4yvxUZZ6lMh8oMeYHRn6H4idXm74f1fjcXWwZCHkC
rB0sbpLo89QG731bNLYris0v7tW8JPRttsZii2jgWb0HK/7KUttyCDN/A4ss
D9xYbly2otB7APWwB21qY+wWnOIy5b2u2HmOU5/eq3f8LWH/Yk8rVh87NJoX
3p2yHIkMeava9pLm/YqAPbQqNP4A9nx6wNsfKbXucbnSrFTfn1K/hmhMpujZ
Jn4yS/ELyo03Fuq5XWvnFKWpVd+vVfxW5S9Q/JpS29huUPpRea4TOW2pxqSH
xmReG8sUW5osV/yt8fm2jdNHpU901HO+1kB7pV/Z5Pb9GrXcBTa2r/peXmdc
8aU2bhdhcEGwCXCJAo1NQdx75VdK/0TO9j54QzOvXZpvrAV+26m7aCv0F9x1
nJ6/VeaqPPM2dCV4G/ou/K1S6V8OawcbFzgCGMKxalckbhke3glfhic/jz1O
z9SosdwLqkxXk5RvY9Z6w2NVxmuos63SLktYfxjWYJscdriJKru0m7Fk7BLg
/uiK2PIomzVRk7VtCbtSXO38NqyXAWrbHzHrudgBsA1AW53T2o9jxsSQiVeF
/iIjZqJeU52ytvlh75uuNuwoGturwnya/Ya9pqXSPioau1DhU5SmTGlyFebT
zfz+czC5hPX3rqp3B6XLz7NdC1wGTOaErO1qyEbsS+wz7Fcvw6/0nKl6Vueb
ftm/sJERBy+ZrrF5ocY4IXaK06pM6zPTXjOslzKVcUjW8ws2Cp4HzyHcXuFP
NQZfhzDxIxtsn8Pe9qzG8L9gphqbnVTOwKzLB4do2cFYxJchjPxJfH4IT1a/
P260npfN2sYGTj9ebV5eYztjt7SxOXA5eCdjjH3lROV9q9FYxWkas7bdbFsY
kfZ6gP4/0/fqrLGVLap3bXvry2A8r4fwzqKHLYHXfaD00azxnU1K83R769GD
Q15woYEhHttre63LdnrmVJkv7xX4NuMCfoMtEjnonvaWeQ8QTX2t9X5de+uR
vJH9V6nevgnjYNg6kO2Q60YofSTr/LflGx9CNuiQtm0VbPzXLkoS87z/rXE4
pdF71KuK7xSzPZH3sxmHV6qeipzlOPJ9kHHe+xXfKme5eJD2z1zKOu4CaDZh
G8EmzfMndZbdWXtgmdjBRymuEL0UJ4N666jslfC88VHzMTAAcCNkDvaeXcI+
9Tb6Wcb7JjagK6PeP19Xma/VWZ/sFvV6xvYJttQnZvyks94vZjwml6mcGzLe
ZzerH1tyLqtc89NWz0zNUZXi1iQsSzQo7zsZ87ofu/g34Te6uNztMlgrY5/4
M+SpjBZ6+lbZNlChtndWfM+4bRvYNRritotgEzk9alsvdn3s+MdWmQ4nSR5+
UGN7pfj2XSW2iWMbv77O8j2y/dgG2+SwgUXU3imN3vN7Rr22wfLAFcAXkAOR
UyiP36PituWAuyJrL4gGHUhzuqKr6e3QrO1/4DGF6lOBnkFq3wdK80hX0yr6
E7wKLOXQSss7HfJN/0+FdbHdTl9g/4Szo5ZHsZ3vlrLNAxxoX/VnJ+VtIq/K
T6Usx2FjRN9A19hJ8SdkjEt/pjn6POd2T1ZbVin9terb4ZWWdxqUpovSj8gY
y92sck5JeL11Ur5VCcsiX4BBpq0DPJwwj4O/rU6YT8GjdtT7kYT36JzaUiNe
0Fb1Viu+Jme5ED0KXAbd6qI6y47IjchKfEfGSCjtywmH36MvMetM4K/oiH8p
f4nSlOYsQ7fR+0Gl/1Pxr6q8mcpzlNIPyppGoc/PFfdA0n45t2pOu6mfIzQf
WxU/IWbZ5LCs90X2RHArcEPW4MBi7z3sO8gayDngQ4dnPUaMD/4Sc6usR4Et
oksjG5yfZ70K3wDwg9F1xhDQg0dXGEdAvh4Ts4x9Sp0xbvBt6mO/Yzw7q57K
nH+vqLKdhrJrFVeXc5vAwE6tMw4GpntshbHLkXXGu8G6T9IcjtXzrebxB43B
xQnPB3oIY8kYMkfovMT/qDQ/Nfo3+v3ifOv4P4geRqUtt6FXo9tkwVc1tulG
140eAz4H7nmz4jOKH1phWZWxR14HCyQO7BVs+9CY8e2BWrNH6/kKHyTVNTtt
P4OfFJ6Xti/CwIBHI9++JPqtUfyDbW3zHJq0PeO0hPcteMW3yjs0bayhp+iz
a3fj95/q+9bG/+mQvLFlbFHclITDXbOWLVif4F9gEOga72Y8poznrHKXh27b
R+lba15+KzA9gDlDE9+ojG8b/ftrvecnHI9eB+7QQU9K+d5MmMY+VPlTVP6v
bY0bgxlj41itPt6dtM/Weyrn/Ubr4WAAYyqs5+yoNnzYaJ7L2CTD+Jyc8N7M
vkzZU0P5z+FfpvDitpabka0PyDOWeWOdZTfon3YhbyP3owMjX92m+e3eaJou
U73vNHo/e1fvsQnLtci3tJHwIqXv0ei2or+Or7BO9bnmqGPa9gz0YbDFnnn2
bUEORy/YpjQ908Yg4BvwCfSsZr1rzzxjMKNjLgOdbFzM38GsF+RbfgYTGh4z
/SKbgi9gjwB7u6TO+NunSlOatk0FfWJSzGOD3oxejg4+oNh9I/8BSdsVwMwO
VbhtwnrqkcVuK+27Trz32krzl37Fpg/C4PEHxTyuYOd9Y+ZDC5X2xkrTB7rf
w/nGi44o9lolHr25fUfrzujW7F3IDJVZ83T4+eEJy0bIRfCI8wNfQjeaWGH9
tlvCMgryyR2ao90b/e0ErZeXs7ZXgPHv2dE4P3okmCa65KlKm6f8m1qaJqAN
bDQzFd9e8b8r/qhirzG+zU/7G/HYlNkrwKMe1fgfETPG1jNpOQwZbM+k92/2
brCQ/jGvm1Uam5WVHtvb8bloND31Lza9Qsf4OcDj4FO7pt1W2rlG+VZXOg22
uM1Zy1XoTB8Hvek37ZuxWts74YFgnvDBCwJGAx18vpP9CdZLD+4r2fk38a57
mR+FtzZYr+yrNq2WjLK82OkmB4z/khLjeeDGvJ8u9l4MPwGjWlZg+8XiCtsw
PlLbP0tbjp4X7BrwavBI9KQVCs9Sm/+VcVnMEdgC88SzuNiY+j4qb6nqvqvY
9vSlxfbXwe6I/fGSfPN0xgx7AXIKPpHYxCaV20aHz9h+KmdZifOfrnr/6fY/
+xBv1ttpiv+rm8sFg6LOafn2s2Bs8LUYXeWxuV31rWUfz9gOgg334WLbMQ9S
XStK/HuaytyhyfNxRblts8gGHytvXaNx+elKk9dk3IT1zzqETqAb1g9rhzXG
OmQNwgugFfp8oPL+qTYPKvaah56gk/7IfRnbwOEvyAfwKWRoeAF84P1O1uEW
BDwFXIW96ijlbQE/CvZzykDW7V5hbGhRsdc/64Q10k/pUTRGBZrjvSjPc0O7
8FPCZrG62PLeevW9ttE2jP4q8zGVubLYPpy87w48hPGAj5xc4vzYO4Yq37BG
0xn1/xH2Q+gbHBK7A3OJLwY+b4epbX938++zFd4t43bcpjaclrG/xiHQQ4N9
JSZUuX/YGbHxE4dsf5nmbnOpZY9oJ+sZ6C74qiBjLg82lMcrjEPh74iPC/am
19XezWnL0RPByeqNtQ8Ur2iRsc/TsKR9AfFdwD6LbRY7MjSEjRy6Qh/ENwWd
ENwGXxnqfT/fPh/4e0Cb+I5An+vyHcaH5MUgl35Z4DEmPeMMhkA7wRHwxaR8
+CE2eerFL+U+8ZX9Y7a74uuJHwx70LX5DuMXcSJ7e6P7zxoDg2Kd4pN1fLnt
US9Jv/+9wbaehMbwkKgxdXR73uDq4C7gP+BNizr+z26DLyn9ZY3jcwLfAt9g
jeLfPC3Y3wiDQ44LvlTU9ZLm+sxa26bwD6B88LqqTtY50JnQecDEwcN3UvwB
wa68RLz8Tc3Xr9hp8+yThL0DOjm5ynI4vvXEg59DO+Cmw4NPAWHsKdcU228Y
XQafqaOTtlsMDT6D+LfsFHyLsRes1Fj92OB4eM6oKstp2JGgO2xJ+GNfX2zM
ZOtO9ttmTaNv0ydwfvzO8F07J8j5yOTI+vgEE8YOgm6JjomvSJtOxpH4fUWx
9VR0QHRfwuie5Uqze9D9sDu/WGHbM3ogcdgmWivNLkEf/jhgc/gw46dLe7CX
FXQyXse3k0U7ExpdFvoz+fCXfrCjMSnwqKzW8Q8N7jPjhi0LnReehb6Ivsm+
AN8B35tQbVsRdqKjtG8WdLOP/xFa721qzac488A6gV/hr1IXtQ0dmx1r6Aqx
tiHK26qbfdKPU7iF2rlThdtIH/GDuFT1XJbz70NVb113l4Wv9/HV9uf7RXT4
Q519SsDyKWO737me0tBvZNIxCculyMUTEpaNwdNOjHotsFZYO9iiLlTZq3P+
1kt0ulu9ba6nit/sGLdcirxcGWTm2aq/U9yyGbb60VHjcneqjLtyLnej0myo
s316P+ni46vtV7JXyjIW8tVwvS/J2ffylGrbCcBysYlNqTZeeYzq+TXrvmEb
ro3aHvGXyv6tzv4x0Au0hA0LXeSBhOkcP6D3s/YFwp+FN7TfiC9Szr7q+C49
m7X/En4348rtX/pWvc+o4C/2nzpj37VhfbOusXvtrrzf5Wwr66XwDznbAPFh
oTxo9uCUsWnkq4dUzrasz57cqrS35VzWpfX2lcf+CD+EF4K54fv5dPD/LBCt
1ce9D5YofUnc2MLIatuw0cexB46qNkZ8leKuznlcsItOrDZef4Detd3tL3BQ
mW2w8HP8uV7P2qcLGwrfseMjC78S5OF16DtZz2MrtScT9/6IXw/54AGtFb9L
3Guhm97f5GxjLFH8rvq9WPEPqIyKuH3NntGYjK813sPYrMp5fHL19qVA72in
cFm97XXQ0brQBnw02gY/jaO1HktrLW9crDK7xK0fcbaHvW1xwDfAGpBh4MPw
YHxFzlWZy1XvUMZE++eKnP3S8Sc/t8prH3vGsKjje6rOnePWxbA/E48dE9so
++F1EctHvwR78Yy4faOR/dBZrgqYWxfR9N0l5uuL1OZpGc9Jk/jE0w3mTc8p
/izFjymzHEP/6Eu+2vhl2rg4Z3iQvbCDgU/jm4ifFzLxSUHGxg9xbKBt/M+G
RI1jl1cYT4RP4xNIW9hf8OEkDr5NW8EJwS0ZP3Caz4Lt46Jga9sWfO3w08NG
An7LesFHpne9bSAD1I/HcvbzuVhjvkbhMVHbY8dGbZOdov6Wxo0P5Nfb1wfc
Ax11SZiv1VXeK/mdUZq6evvlYCfCRoS/7kGih8Jay474lexeb/6BPYI6wbH3
Vdze9fbT4UzFSVHbKZAFwUKwd4/RGHeIWz+AD0I7yGP/Ur6uceMDu9Tblwjd
EHsBdIRtojWYdr19UPCHKqq3L9Q89X2Z+j44ansBb+wR+HAcGzVG+mTQcdCJ
sDEwPoxbSmVU19u36SyNVfu4cSpsocOjtofeoPhk3JgGuiDyJrZ4bGykYX1d
rPovyhkjf7rGZ/yQQeaL7p6MWQ5EDkAe4KwWcgJh9k18bHeoN5bcU/vL99XG
NNjbKwLei3yFnoiMtZvS/FBtvRt9kHj8cGYlfT6BswnsX3sE+zhY+fOBD37Q
yXJJc1u2hjbsojK/qzb+c1bS5xY4S4Ad46+gR4N//xO3Hg3OjMzBXnGi+vhQ
jeWXkxvcf/qOHyByGzwenxNkO2SgPlHL68hMd6V9jpEzMStqbHNCdsI3Bl9S
/GTwtSwJ2AjnRPDtQF6c0uy/q/m4Le1zhpzDmKH0ZQE/YY62hHl8Ie0zivCw
DZ2sezN++P9SDjopWCyYLDYjwtiUkM3YD+aGMPamuSHNgMDX4GnYm+YFLBc7
KrZiZOZfGsyD4D/wP9JzpubhwEehDfLzDR7Ke34IV+zs36THf4gykSHxaSAN
MucNUcvuyCALNW+fxX3262aFt8V9Fqdf8CGHlsD6mOcdCo0ngyX/rDF8Ju1z
p8hf+CVtCONPviNDXvgCaxZ+RR+xGeNvgO/BhcF2/EvoP33HVsfaBTeD538Y
eDvYPfo0PB89cXTwccLOfkEoExvXPk22czEOHXZ2n6c02LcYvQH7DnItch+2
k1eCfY5zhxNDOZwT5LwrNk14E34M8Bbkvf2C/wY4GbI4fHJlkPvh28j4I8P4
d4A/6Nmitkf17qjns1L7xbest38z/gC/Re2rwJk/zv5hL54Uzs5C28iC+M5s
34tVxoS09Vj83tBp8KUfL17SXeuxHfYX5A6Fo+yX6ntvha/SHB0l/n90xv7Y
2G2OCbYb9ou/g70Pv4YHk/Zt6C7+3Trpc06rO9sH5DHVtZfKW5I1DlKl8Pys
8SNwkKfCfremxHo1+t6ctOum3p2Ufm7WvljwPvQHdAfwIrAi9D5saeAf8PY/
1Ibf9bxaavwG3wn28TFJn2HAvwz5B9kH3+bj1d8HaqyjTEj63AK+YH+rjL/0
rC01j+sX6BPduWfYUzJq49qkcccm8PNq0zr88vPAS1nf2IpZ19j10LXQs8BZ
0dOw44Al/RLm9K8GY3O0HZ4Kb0UnWhqwMHSEA8MZE3RtfhPGPsv74BDPWSXy
wpPZj34K+zXY+uEhHjtnv1A+Nth/NRn7w45KHehu8K1TAu/CNkpe7KS099fQ
Zvy/Dwz1ss+BUbF/XZm03zx4HPwUPw90cM49cQaK80oXKk1R0nr7IL1711p2
GazwPrXW8YYrvG+tsR50qZ+CPjU/6bMZYDbnJo2Hgl2he+WS1r84e8MZHM7Z
RRSXq/XvExTuU2vM8XyF/+lqnRza5YwWbSxWfFOt28pZP87zUB68a1hn66Fg
AWAC+LpzLm12mAvOCIwL8WBFhMFtODeA73hNwA0mBDzhPO0nR9baBw273aTA
WyaGM87IqZw32Bh8d+CRFwa5Dv/Mf3c2XvdxyEN6/IkmBn5OG6kLjGIH0dj7
XXw2ra/o8LBK27rBQAcFfJX9lbOOLwS8BTwWnGWL9KNZTf4Nf2S/ZG7pCzgh
2Ae0Cu4KHrRJ6Wc0+dtnCs9p8jfkVmRpeCG8BpwUjBQ76C0lxt7RgXonrQe9
gx+I8tcVWg7gfBpYBtjU8hJjUuMDPkMfOdvXosH9Qu/8I+ie8GBsDPBhzkav
72Jbw/azeqVej7+Wegzwp2JtQuPwInS1pqT1tb/Eo45u9FmTS/HpqLU8/7bC
x9R6D2jJuYSk/QKT2Lvixj6rFb4kbtyddYRvPTzqSZVZ0WD84VWVc3St+Tj+
zeNDv6CFyWF+m/FT6AVbzMoq7zM82GLpK2/iwXwYrxUhDE+CN4H/LA5YCJgh
fIkzk4wHGMQRYb3jXzEr0PY1QffA5siZJMLsZexzg0N4cDivRLg5Hf4DzXcr
gCHgW4McDW4DPkS9YETYoZZXuS3kGxzyYhN5vMp2EXjJ44GfNP8GR8TmsqbK
dhfsudhy8Y+l7OWhfPQR0oDdXZ70+VXOqSI/sbZZ19D96pCGMegXxoFyiUeX
wY6MDfmhAut764M8s1eTz5Pj588+Nyucw8L/gr6AleEbylkCMEx8FPDXAo8t
29lhzpiX7uw0YKTwj7GBh2zPF/LCD8YGfoI/wbSQl/FlvsAA8SGbGsrBF2dm
4O13BZtHUUg7M6Sn/qmhPZQ3PdQFRjMqyCpgzmCUxCETDQr9wp6NDwwyEmlJ
A6YGtjYyhJGzRgbZkveoEM9+3L/KuDc8gnMk8BB8r/oHWuU9IKTBp+XYQBu8
B4V6wc+xzWBbJO1RIX3zb+RqdGVkTmicvZ9zsNAg/KtXOHNUpbW4v9b8DeXG
xvZuMj4GRs0ZA3Bqzk/NLDcNIDvDc+G3vJE14eEdok7H2QH2Leww+FKyXvB3
2S/id78Q3inEs3bAWYgnDhsH+A34PHFHhPQTQ73UBW1AN9AAvHB82IOmhnho
AHm/Isi6jD/z0T/oI+2Dn9v8EM8csbcjExQGmiwL5XPnBr6/2G2wg+MvOyvw
YfY56oWWSD810OzpgT6h59bhDB1pW4f0zb+h5x4a+8IGjy+8G7sTOj7+ItjE
8GNBf8VvCdkMn6Nk8DsCOwYzAPPEZwV7GvgbforgqejgYMjgx2DvD2tu2yZ9
Jw26G3obNlDuXGmRMmbzOzJG0ufFkYM2B56A/xhhZCvy7lpp2W+T2j61u3+D
yYDHgKXjR7l7k+1wjHFFGP8VimuX9N0Y0DL8gjUFj5kRaIx7XLh3Bn8y9Jho
s89wGAfOth8a9nTC7As3VZrnI9vRL3R5vvcNadgj+c1Yso4Kg58YfHhBpXkm
Y7gw2PrZTxaGMvnNftMhxK8IexD3vnA3EHemsH6hK9Yd9ixs8GcGvg3PBvfo
o7l+OGsfa+zt289wqvw/wVHTPseLbyF2DmScCo3h9LR9r1eW+GwtdixsZGA/
2Iy2afy3KP9M0eVzCq+q9dlR/O/xu0THxTb1co1tRhm1YWHW+jr+P/j+XF1g
nyX8lS4oMFYMTozMC7+En27nmeX2FQDLQjbh7Ar7LVgSMh0+D8gpzWfKf1Nb
uqR9lhjd5tTQ33e1798kmqnHpwsfn+7WobCb/ifYUvE342wStr3dNA5n62lR
ZrvfumDDQEek38gunDXlTiDO6XNWmfNOnHUCW4B/Q3s3qJ5dultvO1tj8naN
ZSv8nDjDw/mdztrT1iTt04F+A61D52D14PTw+HeVdmNYO7w3hDBnmTmfie0d
XsCexP6CTIkNb1rg/e0CncwMPId9ind54D/sU+XBz5N7GnrU+9wafL1/4O1z
QjnsF/Ax5hmsg7uSOMOMveh89fHjGtts5ym8ocb2xlkKv1Njuyj20vcDRvx4
ic8PYDe9WePUQ89zna1zHRjkImQD5AJwbPYT7lRgT5lTbhkAbJDzZy8nrYvv
oXmboye/zHa/VTW2/YGbI0uCo7K2wWXAOlibW8J+t3/wN2W/xf7POQd8Sm7H
ZyrtOwHwNTw6nCU8Szr+vqLvODKK2nCknnfaWbbknO2tEZ87JP1dEefhN/NC
3MAQ37vJ94Vxpu9VrZX3q61PoytwNgy5qRZ8MWsMmzNhM7paz+csybp29vk4
XPH9Mv5dL3n4y+pwB0mZZSh8RRoU/1W11yHrf2LQQ/dWvt4Z20Hu0DraJ+Zz
6hOD/wdpssr7dbV557v4m1WbTnOK/6bacmEbjdMeGd/bwJ0v9wef/5XYjWM+
rzY47fqoC9+KAV2N0ZOvV8iLH8GhXe038InqWl9tXgVe0yPsL/hZoMvyG5/W
ocGvtUF5D1P6e9XuZ5T33WrzmJ/BGqt9vnx4xn4z2Ac2q20nx3wu6g+laaw2
Tjk4Y18H/BxiKvPfir+p3Fg988wa3LPJmD64NHHvhnh8E7oF/wTOKHLWEVmF
c9VndjXf2VfhPnpeVZ7+td4L2Qe3KXxKzGdf2JevC/5jPMjv6FPoUtjB0KfQ
+dgT0Pvw7wJjRqdDNl8WZP7Z3H+j9ifVjmOyvtuIe416BVpFNjtXaQ5XfDrq
uP6BhrH39w9n+XsHGoZuiRsQ0uDXB/69c6HPf9EnbDy7aDwPzpj2HlC//h3z
WXD0jscqrWuAqYCbgJnwBhNBBgBvXBV8vTi/gH8D9aOjrAl5B4c9nfXLGal7
ksbIiCsM8f1C+ZQJpsUeyf6IvkL56COU+VjQg74I7SPtl0nr9uj1H3TxfTfs
77QJ3gRfwreIs6P45+EXzpkf8Alw+56VxuoZa86QbD8rpTJO7e5vyGyfVv1P
rtsaZDl8lLi/AH9BzhM0pnymgDO708K+hn8TZ/DwNcR3CXsPWAP9Wh30tbXg
t53sm4R8lRf88MEoKQd/1E80L/0zpl3G45EwJshS2BywfRSrzbtWm+/+rTnt
Vu39mXNkr7XzWpwm+vmX4ndW2QeovH/reV3f9tN7/4zTYSskjvYsV70HZtzG
kqh5DTan3Zpsg8TOCO0cEuiHs41vt7Mf3mGK65vxb+4vuTv46D6mMo+K+Wxc
N4V3SBpnos61od4Xa3y2B7+XE9TmlNpcHLVdhTljvhizD8K4jVaahmq3cXmQ
4ZDf+P5+SMO9UfcFuzx+Utxlg68URmz8JPCR4EzejeF8+odq28iYz/syD9PD
nHKfH/eFcW7wDaUZFvO5avzIsO9i+/xItHB2k9c9trQOgbdw5wLneLGho7Oh
Q3IWA58Awsi9byjvGXHjvM2+TWAji0IYvGKHmO9XYl03pX0egLMAJWn7yOIf
y54Nbgtmi48VcfBt7HX46jJf2CHJx/mjHmn78vKtIm3f3+Z7THhzHod2vVLn
tm2315UGzLPc+D134iEzcS6IvXJssJvCe/E/4y4M7rLgrNXXwdcFXw38CfAl
QE7GJxpZGbvlgjrj28g46MnINlsChs1ev0r09U+X4Pua77LwHcZ/mr5z9ofz
B7kGywX433EnEDIOciS+5+xxYOHb79cr8pk65FtkMOxz6Bjb+UmVZT10wxc1
R1Pitq8gJyEvYU9HJiYvvKhf0E/gmegZhwZdg/u6UgnLpfjDcRcY95U1Ku7y
eod5ZxMOLw7lY89CD8ZfDV2YPW9IkI2hb3gB65GzLfh4IeOMTPtsAOcCODd6
a6Bt9FXiOEfGHvVYwP12VL+qG2y/Bit/PszL1JBGYsR2TOGpMP7IgOgEjNXG
oB+QBj8h8tL3IWn7+jPWyN/cP4C/CjZe7MHYefFNgO/QfvDFN+LWhZZqDJ5I
GSM9V3N0fMb+uYP0/Yk665YPpPyb8GylebPB5/bXKu9rKdv6O9f6bgV0wBP0
HqEnCg6r9/C49WHuy+pY4jUxSXmPS1kPGq738Sl/QwaibDBn7O1rUta76tWW
o+qMoWL37hps34+qnP+m7Cf/usIvp7z/4vfxfMp703YfrlLjgezr3PuDTz/0
DC3jf8i5gm1lHivOUcwvsT1riMbq7bj9kTnXxNjgt4w/1NMp22zwzcJ3DV+v
urTvBgJPwD+ZMYAfgKODp+PXsULtHJWyHXOqyj+g3nUjV8Eb8aNgzJ6u87jN
4nyJ0vytNF1U9uhG+4fih1jTYNkE3Y/+0JcKxV+X8p7FeXjOCoIZgk3h44F9
Hr8Mztfhm5FWGeMb3YeTlG+MnsoSn13mjT8HdiawXTBtfLWOqzYWuCTlu2/w
KR6tfg1LWZ9FPyQ/+PZoxZ2op7PKuk9pRqZst+XOHvgVPrF9OjsMD2N+loTx
BJtfl7Ash/7xr5TXBXh2n5T5dmeFD0qZP/ygNLumvEZuCLIgeTn3Tf34qYBx
HR6wL2Qn8DL2BfwDtt/fGrHOD68ETzg1nOdmr4R33hb2lN3rrCejI+Pn3nzX
WqbOdxNwLwFjx9kdxgEMgXMz0DPn65eXu220ibM+nKVdkfLdB/hr34Is38Vn
HMAjOBPOvZTpOq8HaBpf8GZfadqxOOxfnJfFJwh/PGyH+Mwy5tvS9hniG+d0
uSMAXxf2ixEhzPna4SEv7+NDXmzvpIdun0173Blz/LmeT5uPQq+MK7pJTDTy
Vdr5v0n7/kTqYN9g/2DtfBWwFXCVuWmfd2K8ZqV9Dopxwd/t1rT5KD7Oh8TM
1+GX+E0w1+AK3CELtoC/fPN9eO1VZ4ecfT/hqfhrQD/4rN2ZNr8v0PfCnO8/
4w68zsGHtmXMd18i5+PnOLPOuB+yNXgG5ymQF/A7gA4r1d/P074PDt+3p9OW
KfDNOaPO2OC5nLeI+U4OdJRlgQZ61VlvR2eHRhgTzpOyL+H3wThfqby/xHzv
LLS1IOxT+ABOrjMOCabMnQLww5EaqyNq7PPOuXPqQg89MWNeDy8Dk+D+XHAJ
fNkurLNvw4tac8+lzIvAkk4KPmPM/6hAA+wv+Kngo8Je/WKd9+vtWFCR9yD8
SsFkwIfBfJBdkFvWiZ8dmvDdeuxN+FjgX8Hdn/snzHvzg68b+zL3e8DL4GPY
SLGJoNM/HuwQyCHcu4X8h+wHf8OfAB6Ajyb2DLDfbwOexHxxvh2ehsyDHxB3
HGMDZJ9DjgBTxf/+lrCnY0OEB8Mz0SGJ5ywWMhi2cOzg+NxzTyv9OizhfhLG
vrIxzCm4OlgjeP5PAXdkftcH3gff47wCci797wI/a/AdAvD1EfHgi1Xu+7rh
t4dm7CPImHAGBbkb+sB/AjwJuyfnzjk3gF/ZPhn7GrIf4SMIzbIX75nxeQb4
cLXo+bu05xvdABrgLNvNafNZ1h24D3wJX8B5os9tMd9zs7vKObTGPH5gxudb
sHlSxphAS4MyPr8BBjks43Ms+G5gs0XeRdbdmvb5H87+1IDlZK1DdFJ4S9r9
3ytjuQS5gTM7x4Q+gu8MCf3i/D1l4OvYFfwm6/sEj1C4R4N58aa0z1cwRmBG
x4SxxZdySMjLWDKm4Kj4Z3AHJefLGIPrAn8Ga14QwpUq76y4zx5tE4/5Ime/
J/CD3gGfRB6MxCwTVin93LjPGOFP/WXgwx0bfU/B9vuP8+wHiWzTptF3WHB/
xYCAVyAPnJz2XWboDpzJw7cMvzLuCuX+evjjDf/vzMRW7mzJ2fetHPtz3Gd0
Nii8sdF3W2KrQNfFxxS/wtdTxhDQV8HRkHnwayEMVoa+jw0QXR5bTWmw13Cf
xzF19q3i7hnu1GCtNt8TgX1lYMAM0SnA8jmLSV2sg/yY1wLyQp8gP4AZgbng
V/u75nZw3D6txwbfyu33MBTZdovd9mql+S3m+8ixF5MGmzHrATkNf2j0rc1B
5wIPABcAj4G34X/GngjGjr8p+Dxyzb0Jx4M1Iv+hA8ITuFcFXeARpbks4Ta8
pvF+NWefRGj3gOBrQZ/BSdEBsStwLpDymu/CwM70U9bnEDiD8JLKeDFnn7KD
1aelkv/OK/Wd/LzRL//J+uwB5w6aZQX2o1NFC2+m7K+Sr3k+IW5/5P3QuVXO
7FLfj8gbHRf/DO6HA1/Hf2dtmGvOMCPfo+dy9w/3YsAT8aPHZ4r1jl8B+iG6
IXcdcb8qvPF71X9xk79h/0WWQo4CN8d/CxnhW6W5sMnf8BMvbbANM6Y2nx/3
OTl4JXsGezT4O9g6OjpzeFngJ/iKXRHCG7L23cdvH5sGZ+KRW/Gr4J5rdENs
vsgTyBLskdiEkA3xIeJ+AbDXL9S2eU1O94HCZzZZzj4i2F5p50tZnzfgrAE+
R9yzj9/RNXHfA8h5tKIG6xvoGvgQMTfMC22/PLT5+rjv3UMHwaeJ+yDwa7pZ
839Tzj6qYGRg4pyD5KzkvOAn8I72ohWN3p+QD6ElaAp55q1S24Ow6WGDwy6H
/QN/OHzhmMNXwjyCs9MuvmEDernUdqC3s/b1x88fO8SmUvsFsmeQF9s0dj+w
o+1n86PhXhjF36S8LeK+sx/sjD6Df7BuHiq1Pn27+rcoZ5/c2RqrJ2KWddnX
WL+s4yvUx2sbrfNzN8+Rddb7OLN2X6kxiQWq66+Y/xPgeL3X1frbiQqvr3V9
2HrB2jjz+nk2nOtQ+jdU9puN/g8N7kMaUWd7MfsLPt/4jXLPE/cfIdPAR6gb
DGRa2ndu4lsFTsy9Wuiq6J4zSixPsofg98resVS0dH7C9llwfM4UoWu/mvRd
kKwhfOSXp2wnRZ+emPB+h42Es3+c+8Ouxl3tnHFGJkB2hPfiY3t2zvWhf9IO
2sD+tq3Uexz6/RsJ1/unxue2lHVm/nPghqTP/SCXYdekXnw9oTfO50Kz+PNC
t/xfwU1J+9ejR/Bm3vH5nZ5zOu4uWpwyNnV5wrwSPnmI9ug6jdvicuu+38et
/85VmvtS5r3Y3Ph/CNZ9VOV1zNmPACwM/gUuxxlu9mz2a/bn68MejRzAuQX6
iK7QLugL6BjbeWiB/UXQN8BpkDGx3SIbLE76bgLG7hzkiJhlcu6jYX7gb9h9
t/8PhcIXqs3LUrbZ3aH3+ITn6B6Fpyac5vWkfUCvCzgEawl5mPMN6XDGgfty
7k/ZDnJBwrQCnaB/j0q4bfTr7iBPQl+zw/xic1gTMP6d075HmLV5asLtoA3g
KK8lTJ9n6PuymPErZC/Oe6AXsA7WhrXAOZItQUYal3Df6BdjjK8x44w+8VLC
eZm3eQnPHXIzthPq4v487gJDr+B+EPR29OJ14DCNtrWCVz2UMGbF+bB9kz4j
hv6A7xTjwHnIUSXGAPGV4hwFY87YX5RwmL0AmzfloCcNyVhX4l4B1gzrBX0F
v3P0He6+4Tu8GvxmecLx4E//SVjnYv0zDviOXyE6ujxn/1zGYGsYB3QIdAlk
cmRFfFzICz9YHHgCuCOyM7INfovzQvpHk/b/a74TkDf71Oqk7ei0e0nS97/M
DWMAj2YcirkbJmc/I+zS/LcKeyzy3fog44ED/RQ3FoRMT5vhV5sU/0mj7e3o
yi2Dvsw5PNoN5t8nnGPGZo/s/0CD+/B/tE1HuQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3mczfX3xz+2mTHGjGHGWCp37p25s92ZuSNrSoQiS9ZQITvZkiVavnYt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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.809144004152413, 0.862508847501944, 0.89319321582154], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHeclNX1xkfDuqBbZzssbJ/d2ZnZXYoUFbGioqIhGlvUYEFRAbErINaf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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmgzWUax38qy63LcY+72u56zr1nu9clShKVqJElU41WhSzZypTKWmEi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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8825263685437609, 0.8869799106841162, 0.860317982334547], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mgeUVFW2hq+KxK5umm7tJtmhupJV1YEigwKSQZIBxQRiQlREVFRA0FEU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnd8lVXyxl8BJYRACCRyUSDlJrl5vYV7EzoqRTpCACFgwcIiIiIgSm8q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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.9065379999999997, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtmHmwVMUVxq8KPuMSRQkYE7vfzMR5cxkdva9MobG0KhpL4xIXFFBBEUEE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3d4lfUVx18Reh9RW1YTpfZ9k3s1ySUachOpiArKkC2rGmrBIgoIKJuy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         "],
         VertexColors->None], 
        PolygonBox[{{12410, 13248, 7949, 8008, 5920}, {12721, 12720, 8020, 
         7857, 5254}, {12726, 12727, 5272, 7832, 8023}, {12414, 13251, 7956, 
         8009, 5923}, {12764, 12763, 8026, 7863, 5292}, {13251, 12355, 5864, 
         7997, 7956}, {13235, 12419, 5927, 8011, 7921}, {12715, 12716, 5236, 
         7817, 8018}, {12706, 12705, 8016, 7858, 5221}, {13244, 12367, 5882, 
         7999, 7939}, {12697, 12696, 8015, 7854, 5208}, {12760, 12761, 5283, 
         7859, 8025}, {12709, 12708, 8017, 7860, 5226}, {12394, 13225, 7903, 
         8004, 5905}, {12416, 13233, 7917, 8010, 5925}, {12694, 12693, 8014, 
         7852, 5203}, {13239, 12424, 5932, 8013, 7928}, {13245, 12345, 5854, 
         7993, 7942}, {13224, 8825, 5756, 7982, 7902}, {12765, 12766, 5300, 
         7848, 8027}, {8937, 13243, 7938, 7992, 5852}, {13231, 12402, 5912, 
         8007, 7914}, {8829, 13226, 7906, 7983, 5759}, {8899, 13234, 7920, 
         7987, 5825}, {8905, 13238, 7927, 7989, 5829}, {8835, 13230, 7913, 
         7985, 5763}, {13232, 8895, 5822, 7986, 7916}, {12722, 12723, 5262, 
         7829, 8021}, {8951, 13249, 7952, 7996, 5862}, {13228, 8831, 5760, 
         7984, 7909}, {8931, 13240, 7931, 7990, 5848}, {12769, 12770, 5310, 
         7851, 8029}, {12388, 13242, 7935, 8002, 5900}, {8945, 13246, 7945, 
         7994, 5858}, {13227, 12397, 5907, 8005, 7907}, {13247, 12374, 5888, 
         8000, 7946}, {12758, 12759, 5274, 7836, 8024}, {12399, 13229, 7910, 
         8006, 5910}, {13248, 12351, 5860, 7995, 7949}, {12717, 12718, 5245, 
         7853, 8019}, {12392, 13245, 7942, 8003, 5903}, {13242, 12341, 5850, 
         7991, 7935}, {13241, 12362, 5878, 7998, 7932}, {13250, 12379, 5892, 
         8001, 7953}, {13236, 8901, 5826, 7988, 7923}, {12768, 12767, 8028, 
         7849, 5302}, {12725, 12724, 8022, 7830, 5264}, {12421, 13237, 7924, 
         8012, 5930}},
         VertexColors->None]}]}}, {{}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{9831, 12696, 12697, 11906, 11907, 8425, 10244, 8424, 11905, 
        12347, 8941, 12345, 13245, 12392, 12393, 10589, 11935, 11161, 8939, 
        11048, 8938, 11160, 9046, 9790, 9789, 10107, 8657, 9163, 13125, 9162, 
        8397, 9122, 13117, 9123, 8968, 10134, 8967, 10067, 9047, 11055, 8832, 
        11056, 8833, 10615, 11945, 10613, 12403, 12402, 13231, 13230, 8835, 
        12269, 12600, 12599, 10170, 8465, 11947, 11946, 12727, 12726, 13220}],
       
       "3.5`"], 
      TooltipBox[
       LineBox[{9834, 12720, 12721, 11936, 11937, 8452, 10155, 12912, 12913, 
        12266, 8825, 13224, 13225, 12394, 12395, 10594, 11938, 10592, 8653, 
        10750, 10376, 10377, 11676, 10061, 8958, 10100, 8959, 9112, 13114, 
        9111, 8394, 9153, 13122, 9154, 8652, 10104, 9780, 9781, 9042, 10334, 
        10333, 10738, 8647, 10562, 11899, 10558, 12363, 12362, 13241, 13240, 
        8931, 12340, 12585, 12584, 10144, 8442, 11927, 11926, 12716, 12715, 
        13218}],
       "3.5`"], 
      TooltipBox[
       LineBox[{9850, 12708, 12709, 11920, 11921, 8437, 10245, 8436, 11919, 
        12357, 8955, 12355, 13251, 12414, 12415, 10629, 11957, 11165, 8953, 
        11127, 8952, 11164, 9052, 9806, 9805, 10111, 8689, 9175, 13129, 9174, 
        8410, 9146, 13121, 9147, 8980, 10140, 8979, 10076, 9053, 11134, 8902, 
        11135, 8903, 10655, 11967, 10653, 12425, 12424, 13239, 13238, 8905, 
        12321, 12632, 12631, 10197, 8489, 11969, 11968, 12770, 12769, 13223}],
       
       "3.5`"], 
      TooltipBox[
       LineBox[{9853, 12763, 12764, 11958, 11959, 8476, 10182, 12918, 12919, 
        12318, 8895, 13232, 13233, 12416, 12417, 10634, 11960, 10632, 8685, 
        10798, 10387, 10388, 11700, 10070, 8970, 10102, 8971, 9136, 13118, 
        9135, 8407, 9165, 13126, 9166, 8684, 10108, 9796, 9797, 9048, 10354, 
        10353, 10786, 8679, 10572, 11913, 10568, 12375, 12374, 13247, 13246, 
        8945, 12350, 12617, 12616, 10171, 8466, 11949, 11948, 12759, 12758, 
        13221}],
       "3.5`"], 
      TooltipBox[
       LineBox[{12368, 10563, 11904, 10567, 8650, 10744, 10336, 10337, 9045, 
        9787, 9786, 10106, 8655, 9160, 13124, 9159, 8396, 9119, 13116, 9120, 
        8965, 10101, 8964, 10065, 11678, 10379, 10378, 10754, 8656, 10606, 
        11944, 10608, 12400, 12399, 13229, 13228, 8831, 12268, 12915, 12914, 
        10163, 8459, 11943, 11942, 12725, 12724, 13219, 12722, 12723, 11940, 
        11941, 8458, 10162, 12591, 12592, 12267, 8829, 13226, 13227, 12397, 
        12398, 10599, 11939, 10601, 8827, 11054, 8826, 11053, 9044, 10063, 
        8961, 10133, 8962, 9115, 13115, 9114, 8395, 9156, 13123, 9157, 8654, 
        10105, 9783, 9784, 9043, 11158, 8932, 11037, 8933, 11159, 11930, 
        10583, 12389, 12388, 13242, 12341, 8935, 12343, 11900, 8420, 10148, 
        8421, 11902, 11901, 12694, 12693, 9830, 12717, 12718, 11931, 11932, 
        8447, 10150, 12586, 12587, 12344, 8937, 13243, 13244, 12367, 12368}],
       "3.5`"], 
      TooltipBox[
       LineBox[{12380, 10573, 11918, 10577, 8682, 10792, 10356, 10357, 9051, 
        9803, 9802, 10110, 8687, 9172, 13128, 9171, 8409, 9143, 13120, 9144, 
        8977, 10103, 8976, 10074, 11702, 10390, 10389, 10802, 8688, 10646, 
        11966, 10648, 12422, 12421, 13237, 13236, 8901, 12320, 12921, 12920, 
        10190, 8483, 11965, 11964, 12768, 12767, 13222, 12765, 12766, 11962, 
        11963, 8482, 10189, 12623, 12624, 12319, 8899, 13234, 13235, 12419, 
        12420, 10639, 11961, 10641, 8897, 11133, 8896, 11132, 9050, 10072, 
        8973, 10139, 8974, 9139, 13119, 9138, 8408, 9168, 13127, 9169, 8686, 
        10109, 9799, 9800, 9049, 11162, 8946, 11116, 8947, 11163, 11952, 
        10623, 12411, 12410, 13248, 12351, 8949, 12353, 11914, 8432, 10175, 
        8433, 11916, 11915, 12706, 12705, 9849, 12760, 12761, 11953, 11954, 
        8471, 10177, 12618, 12619, 12354, 8951, 13249, 13250, 12379, 12380}],
       "3.5`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{8325, 12695, 9486, 11526, 9487, 11527, 9483, 11524, 9485, 
        11523, 9484, 10047, 12346, 8940, 11448, 9304, 10588, 11447, 11446, 
        9959, 8451, 11051, 11052, 11047, 11725, 11724, 8219, 8147, 9779, 9161,
         10711, 12065, 8586, 9879, 8587, 11196, 11197, 11194, 8969, 11195, 
        11199, 11198, 8545, 10068, 12570, 12571, 11429, 9261, 9791, 8151, 
        11281, 8160, 11682, 11280, 10349, 10617, 10616, 8464, 9990, 11464, 
        11465, 10614, 9319, 11466, 8834, 9972, 10429, 10427, 9322, 11467, 
        9320, 11556, 9515, 11553, 9514, 11555, 9881}],
       "3"], 
      TooltipBox[
       LineBox[{8329, 12719, 9508, 11547, 9509, 11548, 9306, 11621, 9655, 
        10419, 11759, 9961, 8824, 11451, 9307, 10593, 11450, 11449, 9974, 
        8453, 10590, 10591, 10338, 10340, 11677, 8152, 11263, 9962, 13000, 
        9963, 9110, 10687, 12022, 8534, 10062, 8535, 11178, 11179, 11176, 
        8960, 11177, 11181, 11180, 8579, 9876, 8578, 10707, 10706, 9152, 
        10038, 10037, 11250, 11031, 11032, 10332, 10561, 10560, 8419, 9951, 
        8418, 11898, 10559, 8982, 11234, 8930, 10036, 10408, 10406, 9286, 
        11437, 9284, 11541, 9501, 11538, 9500, 11540, 9872}],
       "3"], 
      TooltipBox[
       LineBox[{8354, 12707, 9498, 11536, 9499, 11537, 9495, 11534, 9497, 
        11533, 9496, 10059, 12356, 8954, 11484, 9358, 10628, 11483, 11482, 
        10004, 8475, 11130, 11131, 11126, 11742, 11741, 8239, 8185, 9795, 
        9173, 10717, 12071, 8596, 9891, 8597, 11230, 11231, 11228, 8981, 
        11229, 11233, 11232, 8571, 10077, 12574, 12575, 11433, 9270, 9807, 
        8189, 11315, 8198, 11706, 11314, 10369, 10657, 10656, 8488, 10035, 
        11500, 11501, 10654, 9373, 11502, 8904, 10017, 10474, 10472, 9376, 
        11503, 9374, 11575, 9533, 11572, 9532, 11574, 9893}],
       "3"], 
      TooltipBox[
       LineBox[{8358, 12762, 9526, 11566, 9527, 11567, 9360, 11624, 9658, 
        10464, 11777, 10006, 8894, 11487, 9361, 10633, 11486, 11485, 10019, 
        8477, 10630, 10631, 10358, 10360, 11701, 8190, 11297, 10007, 13010, 
        10008, 9134, 10697, 12045, 8560, 10071, 8561, 11212, 11213, 11210, 
        8972, 11211, 11215, 11214, 8589, 9888, 8588, 10713, 10712, 9164, 
        10050, 10049, 11284, 11110, 11111, 10352, 10571, 10570, 8431, 9996, 
        8430, 11912, 10569, 8990, 11242, 8944, 10048, 10453, 10451, 9340, 
        11473, 9338, 11560, 9519, 11557, 9518, 11559, 9884}],
       "3"], 
      TooltipBox[
       LineBox[{11550, 9511, 11506, 9510, 11549, 9880, 11551, 9512, 11509, 
        9513, 11552, 9314, 11622, 9656, 10425, 11760, 9967, 8830, 11462, 9315,
         10607, 11461, 11460, 9983, 8460, 10604, 10605, 10339, 10345, 11679, 
        8157, 11275, 9968, 13001, 9969, 9118, 10690, 12032, 8541, 10066, 8542,
         11190, 11191, 11188, 8966, 11189, 11193, 11192, 8584, 9878, 8583, 
        10710, 10709, 9158, 10044, 10043, 11255, 11042, 11043, 10335, 10566, 
        10565, 8423, 9957, 8422, 11903, 10564, 8985, 11238, 8936, 10042, 
        10416, 10413, 9298, 11444, 9296, 11545, 9505, 11542, 9504, 11544, 
        8324, 12692, 9480, 11520, 9481, 11521, 9293, 11518, 9479, 10411, 9478,
         10041, 12342, 8934, 11442, 9295, 10582, 11441, 11440, 9953, 8446, 
        11040, 11041, 11036, 11721, 11720, 8217, 8143, 9777, 9155, 10708, 
        12062, 8581, 9877, 8582, 11184, 11185, 11182, 8963, 11183, 11187, 
        11186, 8538, 10064, 12568, 12569, 11428, 9260, 9785, 8149, 11269, 
        8156, 11681, 11268, 10344, 10603, 10602, 8457, 9981, 11452, 11453, 
        10600, 9311, 11454, 8828, 9966, 10422, 10420, 9313, 11456, 9312, 
        11550}],
       "3"], 
      TooltipBox[
       LineBox[{11569, 9529, 11512, 9528, 11568, 9892, 11570, 9530, 11515, 
        9531, 11571, 9368, 11625, 9659, 10470, 11778, 10012, 8900, 11498, 
        9369, 10647, 11497, 11496, 10028, 8484, 10644, 10645, 10359, 10365, 
        11703, 8195, 11309, 10013, 13011, 10014, 9142, 10700, 12055, 8567, 
        10075, 8568, 11224, 11225, 11222, 8978, 11223, 11227, 11226, 8594, 
        9890, 8593, 10716, 10715, 9170, 10056, 10055, 11289, 11121, 11122, 
        10355, 10576, 10575, 8435, 10002, 8434, 11917, 10574, 8993, 11246, 
        8950, 10054, 10461, 10458, 9352, 11480, 9350, 11564, 9523, 11561, 
        9522, 11563, 8353, 12704, 9492, 11530, 9493, 11531, 9347, 11528, 9491,
         10456, 9490, 10053, 12352, 8948, 11478, 9349, 10622, 11477, 11476, 
        9998, 8470, 11119, 11120, 11115, 11738, 11737, 8237, 8181, 9793, 9167,
         10714, 12068, 8591, 9889, 8592, 11218, 11219, 11216, 8975, 11217, 
        11221, 11220, 8564, 10073, 12572, 12573, 11432, 9269, 9801, 8187, 
        11303, 8194, 11705, 11302, 10364, 10643, 10642, 8481, 10026, 11488, 
        11489, 10640, 9365, 11490, 8898, 10011, 10467, 10465, 9367, 11492, 
        9366, 11569}],
       "3"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{8323, 9912, 11539, 9913, 9285, 9814, 10407, 8256, 10092, 8257,
         10405, 9949, 8805, 10078, 8806, 11237, 8984, 12361, 8983, 12360, 
        11236, 12240, 11235, 12241, 12243, 12242, 10579, 10578, 8443, 10580, 
        10581, 10538, 10539, 8372, 11386, 11387, 9701, 12930, 9700, 12931, 
        10216, 8580, 12061, 12060, 8809, 12247, 11791, 11792, 9109, 11358, 
        9055, 12430, 9056, 11318, 12094, 8618, 10202, 9390, 12645, 9391, 
        11361, 11360, 8326, 13194, 11359, 10495, 10596, 10595, 8454, 10758, 
        10759, 12120, 12119, 8658, 12118, 11261, 13092, 9008, 11260, 9009, 
        11262, 8837, 10156, 8836, 9973, 10081, 10080, 9976, 8268, 10418, 9816,
         9305, 9917, 11546, 9916, 10123}],
       "2.5`"], 
      TooltipBox[
       LineBox[{8337, 9898, 11554, 9899, 9321, 9897, 10428, 9896, 10095, 8277,
         10430, 9988, 8848, 10169, 8849, 11283, 9019, 11282, 9018, 10768, 
        10771, 8663, 10767, 10770, 10769, 8463, 10756, 10757, 10755, 11369, 
        11368, 11628, 11629, 9671, 12924, 9670, 12925, 10205, 8546, 12036, 
        12035, 8823, 12265, 11813, 11814, 9121, 11812, 11811, 12264, 8822, 
        12111, 8629, 10219, 9430, 12667, 9431, 11393, 11392, 10746, 10747, 
        10745, 10749, 10748, 11427, 11049, 11050, 10492, 10493, 10494, 9006, 
        11258, 9007, 11259, 8821, 10154, 8820, 9958, 10417, 8266, 9948, 8267, 
        11522, 9815, 9482, 9915, 11525, 9914, 10122}],
       "2.5`"], 
      TooltipBox[
       LineBox[{8352, 9932, 11558, 9933, 9339, 9821, 10452, 8285, 10096, 8286,
         10450, 9994, 8875, 10084, 8876, 11245, 8992, 12373, 8991, 12372, 
        11244, 12292, 11243, 12293, 12295, 12294, 10619, 10618, 8467, 10620, 
        10621, 10552, 10553, 8384, 11394, 11395, 9711, 12938, 9710, 12939, 
        10224, 8590, 12067, 12066, 8879, 12299, 11843, 11844, 9133, 11370, 
        9069, 12448, 9070, 11326, 12104, 8623, 10210, 9410, 12658, 9411, 
        11373, 11372, 8355, 13196, 11371, 10520, 10636, 10635, 8478, 10806, 
        10807, 12136, 12135, 8690, 12134, 11295, 13096, 9030, 11294, 9031, 
        11296, 8907, 10183, 8906, 10018, 10087, 10086, 10021, 8297, 10463, 
        9823, 9359, 9937, 11565, 9936, 10131}],
       "2.5`"], 
      TooltipBox[
       LineBox[{8366, 9904, 11573, 9905, 9375, 9903, 10473, 9902, 10099, 8306,
         10475, 10033, 8918, 10196, 8919, 11317, 9041, 11316, 9040, 10816, 
        10819, 8695, 10815, 10818, 10817, 8487, 10804, 10805, 10803, 11381, 
        11380, 11632, 11633, 9691, 12928, 9690, 12929, 10213, 8572, 12059, 
        12058, 8893, 12317, 11865, 11866, 9145, 11864, 11863, 12316, 8892, 
        12113, 8631, 10227, 9440, 12669, 9441, 11401, 11400, 10794, 10795, 
        10793, 10797, 10796, 11431, 11128, 11129, 10517, 10518, 10519, 9028, 
        11292, 9029, 11293, 8891, 10181, 8890, 10003, 10462, 8295, 9993, 8296,
         11532, 9822, 9494, 9935, 11535, 9934, 10130}],
       "2.5`"], 
      TooltipBox[
       LineBox[{11577, 9548, 11519, 9547, 11576, 9597, 11611, 9595, 11543, 
        9596, 11612, 9297, 11620, 9654, 10414, 11758, 8262, 10093, 8263, 
        10415, 9955, 8815, 10079, 8816, 11241, 8987, 12366, 8986, 12365, 
        11240, 12253, 11239, 12254, 12256, 12255, 10585, 10584, 8448, 10586, 
        10587, 10540, 10541, 8373, 11390, 11391, 9703, 12932, 9702, 12933, 
        10218, 8585, 12064, 12063, 8818, 12260, 11803, 11804, 9117, 11364, 
        9059, 12435, 9060, 11319, 12095, 8619, 10204, 9393, 12649, 9394, 
        11367, 11366, 8327, 13195, 11365, 10496, 10610, 10609, 8461, 10765, 
        10766, 12126, 12125, 8661, 12124, 11273, 13093, 9014, 11272, 9015, 
        11274, 8844, 10164, 8843, 9982, 10083, 10082, 9985, 8273, 10426, 
        10424, 11463, 12596, 12595, 11459, 12594, 11511, 9400, 11508, 9399, 
        11510, 11823, 11822, 13160, 9397, 12652, 9398, 11507, 12590, 13172, 
        11455, 12854, 12855, 11592, 10421, 11591, 11590, 10094, 8272, 10423, 
        9979, 8841, 10161, 8842, 11271, 9013, 11270, 9012, 10761, 10764, 8660,
         10760, 10763, 10762, 8456, 10752, 10753, 10751, 11363, 11362, 11626, 
        11627, 9669, 12922, 9668, 12923, 10203, 8539, 12026, 12025, 8814, 
        12252, 11801, 11802, 9113, 11800, 11799, 12251, 8813, 12110, 8628, 
        10217, 9428, 12666, 9429, 11389, 11388, 10740, 10741, 10739, 10743, 
        10742, 11426, 11038, 11039, 10489, 10490, 10491, 9001, 11253, 9002, 
        11254, 8812, 10149, 8811, 9952, 10409, 8260, 9947, 8261, 10412, 10410,
         9294, 11439, 9292, 11577}],
       "2.5`"], 
      TooltipBox[
       LineBox[{11582, 9556, 11529, 9555, 11581, 9601, 11616, 9599, 11562, 
        9600, 11617, 9351, 11623, 9657, 10459, 11776, 8291, 10097, 8292, 
        10460, 10000, 8885, 10085, 8886, 11249, 8995, 12378, 8994, 12377, 
        11248, 12305, 11247, 12306, 12308, 12307, 10625, 10624, 8472, 10626, 
        10627, 10554, 10555, 8385, 11398, 11399, 9713, 12940, 9712, 12941, 
        10226, 8595, 12070, 12069, 8888, 12312, 11855, 11856, 9141, 11376, 
        9073, 12453, 9074, 11327, 12105, 8624, 10212, 9413, 12662, 9414, 
        11379, 11378, 8356, 13197, 11377, 10521, 10650, 10649, 8485, 10813, 
        10814, 12142, 12141, 8693, 12140, 11307, 13097, 9036, 11306, 9037, 
        11308, 8914, 10191, 8913, 10027, 10089, 10088, 10030, 8302, 10471, 
        10469, 11499, 12628, 12627, 11495, 12626, 11517, 9420, 11514, 9419, 
        11516, 11875, 11874, 13161, 9417, 12665, 9418, 11513, 12622, 13173, 
        11491, 12858, 12859, 11603, 10466, 11602, 11601, 10098, 8301, 10468, 
        10024, 8911, 10188, 8912, 11305, 9035, 11304, 9034, 10809, 10812, 
        8692, 10808, 10811, 10810, 8480, 10800, 10801, 10799, 11375, 11374, 
        11630, 11631, 9689, 12926, 9688, 12927, 10211, 8565, 12049, 12048, 
        8884, 12304, 11853, 11854, 9137, 11852, 11851, 12303, 8883, 12112, 
        8630, 10225, 9438, 12668, 9439, 11397, 11396, 10788, 10789, 10787, 
        10791, 10790, 11430, 11117, 11118, 10514, 10515, 10516, 9023, 11287, 
        9024, 11288, 8882, 10176, 8881, 9997, 10454, 8289, 9992, 8290, 10457, 
        10455, 9348, 11475, 9346, 11582}],
       "2.5`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{8153, 11680, 12184, 8752, 12185, 8753, 10900, 11819, 11057, 
        11059, 13034, 11058, 8426, 9975, 8427, 11909, 11908, 8988, 12370, 
        9832, 9833, 9010, 11264, 9011, 12396, 8838, 12270, 12272, 12271, 8269,
         9536, 8270, 13021, 9308, 10158, 10157, 8455, 10597, 10598, 10341, 
        10342, 8154, 11265, 9964, 9965, 9108, 12017, 12018, 12019, 9214, 
        12550, 8533, 12021, 12020, 12489, 12488, 12644, 12428, 12429, 11973, 
        11974, 8494, 12524, 9176, 11972, 11971, 11970, 9054, 10040, 10039, 
        11251, 11167, 11168, 11166, 11170, 11169, 8490, 10246, 10247, 9545, 
        12796, 9544, 12797, 9590, 8258, 12245, 12246, 12244, 8807, 12468, 
        9093, 11340, 9092, 9871, 8646, 12540, 9196, 12074, 12075, 8606, 9950, 
        11436, 11338, 11339, 10670, 12010, 10895, 8743, 10863, 8742, 10894, 
        8808}],
       "2"], 
      TooltipBox[
       LineBox[{8191, 11704, 12215, 8782, 12216, 8783, 10969, 11871, 11136, 
        11138, 13044, 11137, 8438, 10020, 8439, 11923, 11922, 8996, 12382, 
        9851, 9852, 9032, 11298, 9033, 12418, 8908, 12322, 12324, 12323, 8298,
         9538, 8299, 13028, 9362, 10185, 10184, 8479, 10637, 10638, 10361, 
        10362, 8192, 11299, 10009, 10010, 9132, 12040, 12041, 12042, 9224, 
        12558, 8559, 12044, 12043, 12517, 12516, 12657, 12446, 12447, 11993, 
        11994, 8504, 12528, 9180, 11992, 11991, 11990, 9068, 10052, 10051, 
        11285, 11201, 11202, 11200, 11204, 11203, 8500, 10251, 10252, 9553, 
        12800, 9552, 12801, 9592, 8287, 12297, 12298, 12296, 8877, 12476, 
        9099, 11349, 9098, 9883, 8678, 12544, 9200, 12082, 12083, 8610, 9995, 
        11472, 11347, 11348, 10679, 12012, 10964, 8773, 10932, 8772, 10963, 
        8878}],
       "2"], 
      TooltipBox[
       LineBox[{8850, 13210, 13211, 13108, 11063, 12148, 8707, 12149, 10822, 
        10674, 12011, 12472, 12473, 11469, 13083, 11468, 12601, 9989, 8609, 
        12081, 12080, 9199, 12543, 9839, 9840, 9188, 11404, 9189, 11405, 8847,
         10324, 10325, 9987, 9986, 8276, 11588, 11589, 9820, 9819, 10305, 
        9585, 10168, 10167, 8544, 10691, 10692, 10348, 11278, 13187, 8159, 
        11279, 8150, 9788, 8704, 12147, 8703, 12553, 9217, 8543, 12034, 12033,
         12495, 12494, 12651, 12436, 12437, 11988, 11989, 8497, 12527, 9179, 
        11987, 11986, 11985, 9061, 9778, 8146, 8218, 11722, 11723, 11044, 
        11046, 11045, 8449, 10152, 10153, 9303, 13020, 8265, 9541, 12369, 
        12262, 12263, 12261, 8819, 12390, 9004, 11257, 9003, 9875, 8651, 
        12391, 9005, 11933, 11934, 8450, 9960, 11445, 11029, 13033, 11030, 
        11028, 11790, 10488, 10898, 12183, 8751, 10897, 8750, 10896, 11675}],
       "2"], 
      TooltipBox[
       LineBox[{8920, 13214, 13215, 13109, 11142, 12160, 8723, 12161, 10842, 
        10683, 12013, 12480, 12481, 11505, 13089, 11504, 12633, 10034, 8613, 
        12089, 12088, 9203, 12547, 9858, 9859, 9194, 11408, 9195, 11409, 8917,
         10328, 10329, 10032, 10031, 8305, 11599, 11600, 9827, 9826, 10307, 
        9588, 10195, 10194, 8570, 10701, 10702, 10368, 11312, 13189, 8197, 
        11313, 8188, 9804, 8720, 12159, 8719, 12561, 9227, 8569, 12057, 12056,
         12523, 12522, 12664, 12454, 12455, 12008, 12009, 8507, 12531, 9183, 
        12007, 12006, 12005, 9075, 9794, 8184, 8238, 11739, 11740, 11123, 
        11125, 11124, 8473, 10179, 10180, 9357, 13027, 8294, 9543, 12381, 
        12314, 12315, 12313, 8889, 12412, 9026, 11291, 9025, 9887, 8683, 
        12413, 9027, 11955, 11956, 8474, 10005, 11481, 11108, 13043, 11109, 
        11107, 11842, 10513, 10967, 12214, 8781, 10966, 8780, 10965, 11699}],
       "2"], 
      TooltipBox[LineBox[CompressedData["
1:eJwl01tMz3EYx/EnLmSLYWOOo5CsUjk05/OFY7a6qeZGZSzkOG64cVEOM+qC
bDYmhxtzStxic1ZcuHDYQpkbckEm1D+v5uLd5/t8v8/3eT7P9/cvtWx7YVVS
RCT5U5YbMWViRGdmRDqtTY94nBpRbj9DXD8t4jR6JkS0ObuaFTFI7ufpEYNp
CuZmR8zDfJyfGrGXDpsRkaXOPutMWu1u1+SIcRkRY1FmvxglaHUnIyfipLwh
zk7RD/beY5E+C1Eq74a4QP+1aMQnNc/KzXY3Cx389vD9xF6ds2rxOnk1tMn+
zrSIj/La0YYVZtrHU2+emjRBC+hAHpKRrc4l811GAy7iArqwYApfKFP7ufdp
Rgveir/plevuS/EL1IlrsVn957QZCfu9WC8v2X5M4l3cjb84o84PM3zHIDO0
jo/YwlMl9niH3RjsbhMPt1Hhfqt3KjLTEjMU0k4z/sQPHDP7Tn3nqJui3mxa
pfY2FNkfJ67WtwYd7oaaX+kss35RN5/OxCrfYTXW4BEP+2mab72RlwPWFfSw
mr085PGaZJ1Pg+bSK84b1RsivkmH0ls0IX+E8+Go17tc3kP1H2CO89lYqf5t
Xu/gvhlG6nuP5nm/bnXOuZNj1mn4Zp6EvC32t6JNfERuOz1KD3mPQr2K8Mf5
b6wz71I9lqFUXILFznfwdp2nayjR4y5P97DJWT+1DvLxzvfpb/2K5ruXkLeL
jx46gL9efYutu7zvLzzj7Sk2OTtOT/TFffvIkdchfuPOE/FjPMIGca7aLXqM
5PVh3zfAKN9lDEaj2/55Phuw2m/inXdbZm+5Gdb01eTpLV6jMu3///8/j3uw
3w==
        "]],
       "2"], 
      TooltipBox[LineBox[CompressedData["
1:eJwl01toz3EYx/FnuGBsw5ii7GSnzPmwaNioFYWIbeWwIYVkcopkh0wunG64
2VDMtUNhpTZXjivHiynmsDlsdyYKV17/XLz/n9/z/X6fz/M839//l721bu2e
pIhI8nN4ZsSi3IiM4ohSeik/oj874oj1xeLr0yNuYLy1tIKIV85tnBrxfXbE
JroBS6ZFlKEcbUU86bg5EfMTPp7n0ZN8/+RFZBVGZGKb9U3YjE9yimZEtDg3
xl4r7bPWi3J1ylDj3D1xlfqV6MYY/bQ5O0/uXAzqN2lWxIC1y+qdFlc7d4Z2
mKc9xxx0AjKwPUt/ehrKfz0dQitpqh5SUMLnsfme4AEe4SEm8lyu9grs5f3R
/XxCL96Lf/BeKPezuA/XxG04qLd+OoDx+s3AIedGW0+e4s7E6RiL23yy+Gdi
hnrD9Nqgp3pcdA+tyJf7wv5LtMj/ov+9zi0zQx0tVKcIBXht9pN0Nd/p/FbR
JnfUiBrreeLzer2AP3Kn8fxNm837i+8JehzrvYdKVOGlHhpprnfdoJcmz/X0
FM8RmKPXkbSEJtPZ9Jb9u/zGiu/QdNpOh9NJ9ifistrHErPxf45F9kuxjn+n
Xu/jqxkmq/uFrnF/RXKuySlxd/PxwzxDrNfzbUj8p8VnnR2g5+gz91GpVhUK
5OZjt3lXqrEKW+TUYqn9/e6zy/5T7FfjqZ66cNTeFF7N+kiSm+f5b2ZEhbxU
/vX6SKFp+hjh/exLfEPWUvEtMQMO2LtCr+K9u/+ABc4Ninv02iN+h7eoE5fx
/qlGsXrd+nyDHd7LLuzEOLkd+uxEk5q97q3W2QozVPNMQSpG4WbO/+//H9Pg
n2I=
        "]],
       "2"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{8135, 11669, 11670, 10862, 10865, 10864, 8522, 10668, 10669, 
        10373, 11016, 12996, 8210, 11017, 9722, 12946, 12948, 12947, 9560, 
        12807, 12808, 12804, 12806, 12805, 8510, 9184, 12532, 12533, 12116, 
        8644, 9563, 13168, 9562, 8140, 9755, 13182, 9756, 9754, 10296, 9288, 
        10145, 9287, 9290, 13142, 9289, 9627, 12892, 9626, 12640, 9386, 11793,
         11794, 11795, 10200, 11798, 11797, 11796, 9387, 12641, 9628, 12893, 
        9629, 8744, 13104, 8745, 8315, 12178, 8746, 12175, 12177, 12176, 8141,
         9502, 13164, 9503, 8803, 11786, 11787, 8316, 12384, 8317, 9476, 
        12686, 12688, 12687, 9258, 12900, 12901, 11713, 12997, 8211, 11712, 
        11018, 11019, 10876, 10878, 13031, 10877, 8318, 9894, 13032, 9895, 
        9546, 9808, 8212, 10060, 9907, 9908, 9594, 9910, 13078, 9909, 8523, 
        10671, 13079, 10672, 10374, 11023, 12998, 8213, 11024, 9723, 12949, 
        12951, 12950, 9561, 12817, 12818, 12814, 12816, 12815, 8511, 9185, 
        12534, 12535, 12117, 8645, 9565, 13169, 9564, 8144, 9758, 13183, 9759,
         9757, 10297, 9300, 10151, 9299, 9302, 13143, 9301, 9631, 12894, 9630,
         12642, 9388, 11805, 11806, 11807, 10201, 11810, 11809, 11808, 9389, 
        12643, 9632, 12895, 9633, 8747, 13105, 8748, 8319, 12182, 8749, 12179,
         12181, 12180, 8145, 9506, 13165, 9507, 8804, 11788, 11789, 8320, 
        12385, 8321, 9477, 12689, 12691, 12690, 9259, 12902, 12903, 11715, 
        12999, 8214, 11714, 11025, 11026, 10891, 10893, 10892, 8322, 10486, 
        10487, 10375, 11027, 11717, 8215, 11716}],
       "1.5`"], 
      TooltipBox[
       LineBox[{8168, 10927, 11726, 10928, 10380, 10676, 10675, 8525, 10925, 
        10926, 10922, 10924, 12988, 10923, 12989, 8167, 12958, 12959, 12957, 
        12961, 12960, 9571, 12827, 12828, 12824, 12826, 12825, 8515, 11345, 
        8514, 10663, 10662, 9081, 9569, 9568, 10235, 8225, 9810, 9767, 10301, 
        9457, 10234, 9266, 12598, 9318, 12597, 9317, 12677, 9456, 11895, 8399,
         12676, 9455, 12674, 9454, 12675, 10137, 11818, 11817, 12650, 9395, 
        11825, 8335, 11824, 9401, 8224, 13005, 8706, 8336, 12189, 8755, 12188,
         12279, 12278, 8846, 8223, 13004, 9265, 8662, 12127, 12129, 12128, 
        12405, 8334, 12749, 12750, 12748, 12752, 12751, 9517, 12746, 12747, 
        12743, 12745, 12744, 8165, 11685, 11686, 10917, 10919, 13036, 10918, 
        8333, 9923, 13037, 9924, 9586, 9922, 9921, 8164, 11654, 9750, 11656, 
        9751, 10292, 9264, 9920, 13081, 9919, 8524, 10915, 13082, 10916, 
        10912, 10914, 12985, 10913, 12986, 8163, 12953, 12954, 12952, 12956, 
        12955, 9570, 12822, 12823, 12819, 12821, 12820, 8513, 11344, 8512, 
        10661, 10660, 9080, 9567, 9566, 10233, 8222, 9809, 9766, 10300, 9453, 
        10232, 9263, 12589, 9310, 12588, 9309, 12673, 9452, 11894, 8398, 
        12672, 9451, 12670, 9450, 12671, 10135, 11816, 11815, 12646, 9392, 
        11821, 8331, 11820, 9396, 8221, 13003, 8705, 8332, 12187, 8754, 12186,
         12274, 12273, 8839, 8220, 13002, 9262, 8659, 12121, 12123, 12122, 
        12404, 8330, 12734, 12735, 12733, 12737, 12736, 9516, 12731, 12732, 
        12728, 12730, 12729, 8161, 11683, 11684, 10905, 10907, 10906, 8328, 
        10903, 10904, 10899, 10902, 10901, 11065}],
       "1.5`"], 
      TooltipBox[
       LineBox[{8173, 11693, 11694, 10931, 10934, 10933, 8526, 10677, 10678, 
        10384, 11095, 13006, 8230, 11096, 9724, 12962, 12964, 12963, 9572, 
        12832, 12833, 12829, 12831, 12830, 8516, 9190, 12536, 12537, 12132, 
        8676, 9575, 13170, 9574, 8178, 9761, 13184, 9762, 9760, 10298, 9342, 
        10172, 9341, 9344, 13152, 9343, 9639, 12896, 9638, 12653, 9406, 11845,
         11846, 11847, 10208, 11850, 11849, 11848, 9407, 12654, 9640, 12897, 
        9641, 8774, 13106, 8775, 8344, 12209, 8776, 12206, 12208, 12207, 8179,
         9520, 13166, 9521, 8873, 11838, 11839, 8345, 12406, 8346, 9488, 
        12698, 12700, 12699, 9267, 12906, 12907, 11730, 13007, 8231, 11729, 
        11097, 11098, 10945, 10947, 13041, 10946, 8347, 9900, 13042, 9901, 
        9554, 9811, 8232, 10069, 9927, 9928, 9598, 9930, 13084, 9929, 8527, 
        10680, 13085, 10681, 10385, 11102, 13008, 8233, 11103, 9725, 12965, 
        12967, 12966, 9573, 12842, 12843, 12839, 12841, 12840, 8517, 9191, 
        12538, 12539, 12133, 8677, 9577, 13171, 9576, 8182, 9764, 13185, 9765,
         9763, 10299, 9354, 10178, 9353, 9356, 13153, 9355, 9643, 12898, 9642,
         12655, 9408, 11857, 11858, 11859, 10209, 11862, 11861, 11860, 9409, 
        12656, 9644, 12899, 9645, 8777, 13107, 8778, 8348, 12213, 8779, 12210,
         12212, 12211, 8183, 9524, 13167, 9525, 8874, 11840, 11841, 8349, 
        12407, 8350, 9489, 12701, 12703, 12702, 9268, 12908, 12909, 11732, 
        13009, 8234, 11731, 11104, 11105, 10960, 10962, 10961, 8351, 10511, 
        10512, 10386, 11106, 11734, 8235, 11733}],
       "1.5`"], 
      TooltipBox[
       LineBox[{8206, 10996, 11743, 10997, 10391, 10685, 10684, 8529, 10994, 
        10995, 10991, 10993, 12994, 10992, 12995, 8205, 12974, 12975, 12973, 
        12977, 12976, 9583, 12852, 12853, 12849, 12851, 12850, 8521, 11354, 
        8520, 10667, 10666, 9089, 9581, 9580, 10241, 8245, 9813, 9769, 10303, 
        9471, 10240, 9275, 12630, 9372, 12629, 9371, 12685, 9470, 11897, 8412,
         12684, 9469, 12682, 9468, 12683, 10143, 11870, 11869, 12663, 9415, 
        11877, 8364, 11876, 9421, 8244, 13015, 8722, 8365, 12220, 8785, 12219,
         12331, 12330, 8916, 8243, 13014, 9274, 8694, 12143, 12145, 12144, 
        12427, 8363, 12792, 12793, 12791, 12795, 12794, 9535, 12789, 12790, 
        12786, 12788, 12787, 8203, 11709, 11710, 10986, 10988, 13046, 10987, 
        8362, 9943, 13047, 9944, 9589, 9942, 9941, 8202, 11655, 9752, 11657, 
        9753, 10293, 9273, 9940, 13087, 9939, 8528, 10984, 13088, 10985, 
        10981, 10983, 12991, 10982, 12992, 8201, 12969, 12970, 12968, 12972, 
        12971, 9582, 12847, 12848, 12844, 12846, 12845, 8519, 11353, 8518, 
        10665, 10664, 9088, 9579, 9578, 10239, 8242, 9812, 9768, 10302, 9467, 
        10238, 9272, 12621, 9364, 12620, 9363, 12681, 9466, 11896, 8411, 
        12680, 9465, 12678, 9464, 12679, 10141, 11868, 11867, 12659, 9412, 
        11873, 8360, 11872, 9416, 8241, 13013, 8721, 8361, 12218, 8784, 12217,
         12326, 12325, 8909, 8240, 13012, 9271, 8691, 12137, 12139, 12138, 
        12426, 8359, 12777, 12778, 12776, 12780, 12779, 9534, 12774, 12775, 
        12771, 12773, 12772, 8199, 11707, 11708, 10974, 10976, 10975, 8357, 
        10972, 10973, 10968, 10971, 10970, 11144}],
       "1.5`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{8314, 10484, 10485, 10394, 11328, 13016, 8252, 11329, 11748, 
        11747, 11746, 9279, 12580, 9278, 12885, 9615, 12884, 9614, 11414, 
        9242, 10866, 8734, 10395, 11410, 12548, 9204, 12090, 12091, 10867, 
        8735, 12171, 12172, 11672, 11671, 8136, 10868, 10727, 10728, 10726, 
        8636, 10729, 8698, 9426, 13048, 8370, 10116, 9234, 13136, 9235, 8792, 
        11000, 11002, 11001, 8310, 11003, 11004, 12233, 12232, 8793, 9623, 
        13174, 9622, 10117, 8392, 13062, 9448, 9828, 9384, 8311, 10118, 9236, 
        12564, 9237, 11665, 11666, 8132, 9906, 8137, 10870, 10871, 10869, 
        8736, 10872, 11783, 11782, 8794, 12234, 10397, 10396, 8737, 10873, 
        9243, 11415, 10874, 10875, 10398, 11005, 13017, 8253, 11006, 11751, 
        11750, 11749, 12582, 12581, 9280, 12713, 12714, 12710, 12712, 12711, 
        9870, 12810, 12811, 12809, 12813, 12812, 9281, 12910, 12911, 11752, 
        11753, 11754, 10090, 11757, 11756, 11755, 9283, 12583, 9282, 12887, 
        9617, 12886, 9616, 11416, 9244, 10879, 8738, 10399, 11411, 12549, 
        9209, 12092, 12093, 10880, 8739, 12173, 12174, 11674, 11673, 8138, 
        10881, 10733, 10734, 10732, 8641, 10735, 8699, 9427, 13049, 8371, 
        10119, 9238, 13137, 9239, 8797, 11007, 11009, 11008, 8312, 11010, 
        11011, 12236, 12235, 8798, 9625, 13175, 9624, 10120, 8393, 13063, 
        9449, 9829, 9385, 8313, 10121, 9240, 12565, 9241, 11667, 11668, 8134, 
        9911, 8139, 10883, 10884, 10882, 8740, 10885, 11785, 11784, 8799, 
        12237, 10401, 10400, 8741, 10886, 9245, 11417, 10887, 10888, 10402, 
        11014, 13018, 8254, 11015, 8255, 10404, 10403, 10890, 10889, 11418}],
       "1"], 
      TooltipBox[
       LineBox[{8338, 10840, 10841, 10837, 10839, 10838, 11346, 8280, 10438, 
        10437, 10502, 10501, 11833, 11832, 10836, 8713, 10835, 8712, 12555, 
        9221, 12098, 12099, 10921, 8757, 12198, 12199, 11080, 11079, 11728, 
        8229, 8166, 12987, 10382, 10351, 10773, 8665, 13095, 10507, 10508, 
        9437, 13055, 8381, 10223, 8380, 13054, 9709, 11635, 12156, 12157, 
        10549, 10548, 8382, 11077, 11078, 12287, 12286, 8856, 9460, 13066, 
        8403, 10237, 8404, 13067, 9461, 9842, 9435, 13051, 8375, 10221, 9434, 
        12937, 9707, 12936, 9706, 9925, 11075, 8228, 13191, 11074, 12153, 
        12152, 8711, 13101, 10543, 11889, 11888, 8943, 12349, 10436, 10920, 
        12197, 12196, 12195, 10500, 11830, 11831, 10833, 10834, 10830, 10832, 
        10831, 11073, 11763, 11762, 11761, 12603, 12602, 9323, 12741, 12742, 
        12738, 12740, 12739, 8400, 12871, 12872, 12870, 12874, 12873, 9602, 
        12868, 12869, 12866, 9603, 12867, 11331, 8279, 10435, 10434, 10499, 
        10498, 11829, 11828, 10829, 8710, 10828, 8709, 12554, 9219, 12096, 
        12097, 10911, 8756, 12193, 12194, 11072, 11071, 11727, 8227, 8162, 
        12984, 10381, 10350, 10772, 8664, 13094, 10504, 10505, 9436, 13053, 
        8377, 10222, 8376, 13052, 9708, 11634, 12154, 12155, 10545, 10544, 
        8378, 11069, 11070, 12283, 12282, 8853, 9458, 13064, 8401, 10236, 
        8402, 13065, 9459, 9841, 9433, 13050, 8374, 10220, 9432, 12935, 9705, 
        12934, 9704, 9918, 11067, 8226, 13190, 11066, 12151, 12150, 8708, 
        13100, 10542, 11887, 11886, 8942, 12348, 10433, 10910, 12192, 12191, 
        12190, 10497, 11826, 11827, 10826, 10827, 10823, 10825, 10824, 11064, 
        8278, 10432, 10431, 10909, 10908, 11419}],
       "1"], 
      TooltipBox[
       LineBox[{8343, 10509, 10510, 10439, 11333, 13023, 8281, 11334, 11766, 
        11765, 11764, 9333, 12612, 9332, 12889, 9619, 12888, 9618, 11420, 
        9254, 10935, 8764, 10440, 11412, 12556, 9222, 12100, 12101, 10936, 
        8765, 12202, 12203, 11696, 11695, 8174, 10937, 10775, 10776, 10774, 
        8668, 10777, 8714, 9402, 13038, 8339, 10124, 9246, 13138, 9247, 8859, 
        11068, 11082, 11081, 8379, 10546, 10547, 11084, 11083, 8860, 13177, 
        13178, 13176, 9636, 10125, 8405, 13068, 9462, 9843, 9403, 8340, 10126,
         9248, 12566, 9249, 11689, 11690, 8171, 9926, 8175, 10939, 10940, 
        10938, 8766, 10941, 11835, 11834, 8866, 12288, 10442, 10441, 8767, 
        10942, 9255, 11421, 10943, 10944, 10443, 11089, 13024, 8282, 11090, 
        11769, 11768, 11767, 12614, 12613, 9334, 12756, 12757, 12753, 12755, 
        12754, 9882, 12835, 12836, 12834, 12838, 12837, 9335, 12916, 12917, 
        11770, 11771, 11772, 10091, 11775, 11774, 11773, 9337, 12615, 9336, 
        12891, 9621, 12890, 9620, 11422, 9256, 10948, 8768, 10444, 11413, 
        12557, 9223, 12102, 12103, 10949, 8769, 12204, 12205, 11698, 11697, 
        8176, 10950, 10781, 10782, 10780, 8673, 10783, 8715, 9404, 13039, 
        8341, 10127, 9250, 13139, 9251, 8863, 11076, 11086, 11085, 8383, 
        10550, 10551, 11088, 11087, 8864, 13180, 13181, 13179, 9637, 10128, 
        8406, 13069, 9463, 9846, 9405, 8342, 10129, 9252, 12567, 9253, 11691, 
        11692, 8172, 9931, 8177, 10952, 10953, 10951, 8770, 10954, 11837, 
        11836, 8869, 12289, 10446, 10445, 8771, 10955, 9257, 11423, 10956, 
        10957, 10447, 11093, 13025, 8283, 11094, 8284, 10449, 10448, 10959, 
        10958, 11424}],
       "1"], 
      TooltipBox[
       LineBox[{8367, 10860, 10861, 10857, 10859, 10858, 11355, 8309, 10483, 
        10482, 10527, 10526, 11885, 11884, 10856, 8729, 10855, 8728, 12563, 
        9233, 12108, 12109, 10990, 8787, 12229, 12230, 11157, 11156, 11745, 
        8249, 8204, 12993, 10393, 10371, 10821, 8697, 13099, 10534, 10535, 
        9447, 13061, 8391, 10231, 8390, 13060, 9719, 11637, 12168, 12169, 
        10537, 10536, 8369, 11154, 11155, 12339, 12338, 8926, 9474, 13072, 
        8416, 10243, 8417, 13073, 9475, 9861, 9445, 13057, 8387, 10229, 9444, 
        12945, 9717, 12944, 9716, 9945, 11153, 8248, 13193, 11152, 12165, 
        12164, 8727, 13103, 10557, 11893, 11892, 8957, 12359, 10481, 10989, 
        12228, 12227, 12226, 10525, 11882, 11883, 10853, 10854, 10850, 10852, 
        10851, 11151, 11781, 11780, 11779, 12635, 12634, 9377, 12784, 12785, 
        12781, 12783, 12782, 8413, 12880, 12881, 12879, 12883, 12882, 9604, 
        12877, 12878, 12875, 9605, 12876, 11336, 8308, 10480, 10479, 10524, 
        10523, 11881, 11880, 10849, 8726, 10848, 8725, 12562, 9230, 12106, 
        12107, 10980, 8786, 12224, 12225, 11150, 11149, 11744, 8247, 8200, 
        12990, 10392, 10370, 10820, 8696, 13098, 10529, 10530, 9446, 13059, 
        8389, 10230, 8388, 13058, 9718, 11636, 12166, 12167, 10532, 10531, 
        8368, 11147, 11148, 12335, 12334, 8923, 9472, 13070, 8414, 10242, 
        8415, 13071, 9473, 9860, 9443, 13056, 8386, 10228, 9442, 12943, 9715, 
        12942, 9714, 9938, 11146, 8246, 13192, 11145, 12163, 12162, 8724, 
        13102, 10556, 11891, 11890, 8956, 12358, 10478, 10979, 12223, 12222, 
        12221, 10522, 11878, 11879, 10846, 10847, 10843, 10845, 10844, 11143, 
        8307, 10477, 10476, 10978, 10977, 11425}],
       "1"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{8130, 11664, 13204, 8732, 12170, 8733, 12457, 9077, 12456, 
        9076, 12484, 12485, 12014, 12015, 9606, 8614, 10198, 9660, 9661, 9104,
         13216, 11356, 13202, 8634, 12114, 8635, 9206, 13130, 9205, 8131}],
       "0.5`"], 
      TooltipBox[
       LineBox[{8133, 9210, 13132, 9211, 8640, 12115, 8639, 13203, 11357, 
        13217, 9106, 9665, 9664, 10199, 8616, 9609, 12016, 12486, 12487, 
        12459, 12458, 9078, 12460, 9079, 11330, 11642, 13198, 8532, 11643, 
        8531, 9864, 10309, 10308, 9608, 9770, 10724, 10260, 9607, 10318, 
        10319, 10259, 10258, 10132, 8530, 10686, 9946, 8796, 10330, 8795, 
        11434, 11435, 12577, 12576, 9276, 9742, 8615, 10276, 9662, 9663, 9105,
         10731, 8637, 10730, 8638, 9208, 13131, 9207, 10112}],
       "0.5`"], 
      TooltipBox[
       LineBox[{8169, 11687, 13205, 8760, 12200, 8761, 12475, 9097, 12474, 
        9096, 9329, 13149, 9328, 9733, 8553, 10281, 9678, 9679, 9130, 9848, 
        9847, 10317, 8865, 11662, 9774, 11661, 9775, 11663, 9651, 10275, 9652,
         9653, 12905, 12443, 9067, 12442, 12445, 12444, 8675, 10784, 8674, 
        10785, 9131, 9687, 9686, 10283, 8558, 9735, 9331, 13150, 13151, 12611,
         12610, 8871, 12290, 8872, 12291, 8716, 10383, 11091, 13212, 11092, 
        13213, 8870}],
       "0.5`"], 
      TooltipBox[
       LineBox[{8170, 11688, 13206, 8762, 12201, 8763, 12463, 9085, 12462, 
        9084, 12512, 12513, 12037, 12038, 9610, 8621, 10206, 9680, 9681, 9063,
         13111, 11322, 13110, 8666, 12130, 8667, 12502, 12503, 12500, 9125, 
        12501, 9218, 12497, 9124, 12496, 12499, 12498, 8857, 10503, 11320, 
        11321, 9062, 9673, 9672, 10278, 8550, 9730, 9324, 13144, 13145, 12605,
         12604, 8851, 12280, 8852, 12281, 8759, 10929, 8758, 10930, 8858}],
       "0.5`"], 
      TooltipBox[
       LineBox[{8207, 8250, 8730, 8632, 10214, 9422, 13162, 9423, 9149, 9695, 
        9694, 10285, 8576, 9740, 9379, 13156, 9380, 9090, 12467, 9091, 11337, 
        11652, 13201, 8605, 11653, 8604, 9869, 10315, 10314, 9646, 10273, 
        9647, 9559, 13077, 8508, 10255, 8509, 12337, 8925, 12336, 8924, 12638,
         12639, 13158, 13157, 9381, 9749, 8627, 10286, 9696, 9697, 9150, 
        11385, 11384, 10533, 8929, 9232, 13135, 9231, 10115}],
       "0.5`"], 
      TooltipBox[
       LineBox[{8208, 8251, 8731, 8633, 10215, 9424, 13163, 9425, 9151, 9699, 
        9698, 10287, 8577, 9741, 9382, 13159, 9383, 9102, 12482, 9103, 12483, 
        8791, 12231, 8790, 13207, 11711, 8209}],
       "0.5`"], 
      TooltipBox[
       LineBox[{8800, 13209, 11013, 13208, 11012, 10372, 8700, 12239, 8802, 
        12238, 8801, 12578, 12579, 13141, 13140, 9277, 9743, 8617, 10277, 
        9666, 9667, 9107, 10737, 8642, 10736, 8643, 9213, 13133, 9212, 
        10113}],
       "0.5`"], 
      TooltipBox[
       LineBox[{8928, 10999, 8788, 10998, 8789, 12333, 8922, 12332, 8921, 
        12636, 12637, 13155, 13154, 9378, 9748, 8626, 10284, 9692, 9693, 9148,
         11383, 11382, 10528, 8927, 9229, 13134, 9228, 10114}],
       "0.5`"], 
      TooltipBox[
       LineBox[{12285, 8855, 12284, 8854, 12606, 12607, 13148, 13147, 9327, 
        9732, 8552, 10280, 9676, 9677, 9065, 11324, 11323, 10506, 8862, 12506,
         12507, 12504, 9128, 12505, 9220, 12509, 9129, 12508, 12511, 12510, 
        8672, 12131, 8671, 13112, 11325, 13113, 9066, 9685, 9684, 10207, 8622,
         9613, 12039, 12514, 12515, 12465, 12464, 9086, 12466, 9087, 11335, 
        11646, 13199, 8557, 11647, 8556, 9866, 10311, 10310, 9612, 9771, 
        10725, 10265, 9611, 10320, 10321, 10264, 10263, 10138, 8555, 10696, 
        9991, 8868, 10331, 8867, 11470, 11471, 12609, 12608, 9330, 9734, 8554,
         10282, 9682, 9683, 9127, 10779, 8669, 10778, 8670, 12440, 12441, 
        12438, 9064, 12439, 12904, 9650, 9649, 10274, 9648, 11660, 9773, 
        11658, 9772, 11659, 8861, 10316, 9844, 9845, 9126, 9675, 9674, 10279, 
        8551, 9731, 9325, 13146, 9326, 9082, 12461, 9083, 11332, 11650, 13200,
         8601, 11651, 8600, 9868, 10313, 10312, 9634, 10270, 9635, 9551, 
        13075, 8498, 10250, 8499, 12285}],
       "0.5`"]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->NCache[{{0, 4 EllipticK[
        Rational[1, 3]]}, {0, 4 EllipticK[
        Rational[2, 3]]}}, {{0, 6.935667541031741}, {0, 8.115836410995263}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->25400297]
}, Open  ]],

Cell[TextData[{
 "Also built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are the ",
 StyleBox["inverse Jacobi elliptic functions",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseJacobiSN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiSN"], "[", 
   RowBox[{
    StyleBox["v", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseJacobiCN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiCN"], "[", 
   RowBox[{
    StyleBox["v", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 ", etc. The inverse function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["sn", 
     RowBox[{"-", "1"}]], "(", 
    RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ", for example, gives the value of ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "=", 
    RowBox[{"sn", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". The inverse Jacobi elliptic functions are related to elliptic integrals."
}], "Text",
 CellID->2669],

Cell[TextData[{
 "The four ",
 StyleBox["theta functions",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[CurlyTheta]", "a"], "(", 
    RowBox[{"u", ",", "q"}], ")"}], TraditionalForm]], "InlineMath"],
 " are obtained from",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticTheta"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["u", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " by taking ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " to be ",
 Cell[BoxData["1"], "InlineFormula"],
 ", ",
 Cell[BoxData["2"], "InlineFormula"],
 ", ",
 Cell[BoxData["3"], "InlineFormula"],
 " or ",
 Cell[BoxData["4"], "InlineFormula"],
 ". The functions are defined by: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "1"], "(", 
     RowBox[{"u", ",", "q"}], ")"}], "=", 
    RowBox[{"2", 
     SuperscriptBox["q", 
      RowBox[{"1", "/", "4"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n", "=", "0"}], "\[Infinity]",
       LimitsPositioning->True], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], 
       SuperscriptBox["q", 
        RowBox[{"n", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]], "sin", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "n", "+", "1"}], ")"}], "u"}], "]"}]}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "2"], "(", 
     RowBox[{"u", ",", "q"}], ")"}], "=", 
    RowBox[{"2", 
     SuperscriptBox["q", 
      RowBox[{"1", "/", "4"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n", "=", "0"}], "\[Infinity]",
       LimitsPositioning->True], 
      RowBox[{
       SuperscriptBox["q", 
        RowBox[{"n", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]], "cos", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "n", "+", "1"}], ")"}], "u"}], "]"}]}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "3"], "(", 
     RowBox[{"u", ",", "q"}], ")"}], "=", 
    RowBox[{"1", "+", 
     RowBox[{"2", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"n", "=", "1"}], "\[Infinity]",
        LimitsPositioning->True], 
       RowBox[{
        SuperscriptBox["q", 
         SuperscriptBox["n", "2"]], 
        RowBox[{"cos", "(", 
         RowBox[{"2", "n", "u"}], ")"}]}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "4"], "(", 
     RowBox[{"u", ",", "q"}], ")"}], "=", 
    RowBox[{"1", "+", 
     RowBox[{"2", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"n", "=", "1"}], "\[Infinity]",
        LimitsPositioning->True], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"], 
        SuperscriptBox["q", 
         SuperscriptBox["n", "2"]], 
        RowBox[{"cos", "(", 
         RowBox[{"2", "n", "u"}], ")"}]}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". The theta functions are often written as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[CurlyTheta]", "a"], "(", "u", ")"}], TraditionalForm]], 
  "InlineMath"],
 " with the parameter ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " not explicitly given. The theta functions are sometimes written in the \
form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CurlyTheta]", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is related to ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", 
    RowBox[{"exp", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"-", "\[Pi]"}], 
       RowBox[{
        RowBox[{"K", "(", 
         RowBox[{"1", "-", "m"}], ")"}], "/", 
        RowBox[{"K", "(", "m", ")"}]}]}], "]"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". In addition, ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " is sometimes replaced by ",
 Cell[BoxData[
  FormBox["\[Tau]", TraditionalForm]], "InlineMath"],
 ", given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", 
    SuperscriptBox["e", 
     RowBox[{"i", "\[Pi]\[Tau]"}]]}], TraditionalForm]], "InlineMath"],
 ". All the theta functions satisfy a diffusion\[Hyphen]like differential \
equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[PartialD]", "2"], 
      RowBox[{"\[CurlyTheta]", "(", 
       RowBox[{"u", ",", "\[Tau]"}], ")"}]}], "/", 
     RowBox[{"\[PartialD]", 
      SuperscriptBox["u", "2"]}]}], "=", 
    RowBox[{"4", "\[Pi]", "i", " ", 
     RowBox[{
      RowBox[{"\[PartialD]", 
       RowBox[{"\[CurlyTheta]", "(", 
        RowBox[{"u", ",", "\[Tau]"}], ")"}]}], "/", 
      RowBox[{"\[PartialD]", "\[Tau]"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->3134],

Cell[TextData[{
 "The Siegel theta function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SiegelTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SiegelTheta"], "[", 
   RowBox[{
    StyleBox["\[Tau]", "TR"], ",", 
    StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
 " with Riemann square modular matrix ",
 Cell[BoxData[
  FormBox["\[Tau]", TraditionalForm]], "InlineMath"],
 " of dimension ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " and vector ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " generalizes the elliptic theta functions to complex dimension ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ". It is defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalTheta]", "(", 
     RowBox[{"\[Tau]", ",", "s"}], ")"}], "=", 
    RowBox[{
     UnderscriptBox["\[Sum]", "n"], 
     RowBox[{"exp", "(", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"\[Pi]", "(", 
        RowBox[{
         RowBox[{"n", ".", "\[Tau]", ".", "n"}], "+", 
         RowBox[{"2", 
          RowBox[{"n", ".", "s"}]}]}], ")"}]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " runs over all ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "-dimensional integer vectors. The Siegel theta function with characteristic \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SiegelTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SiegelTheta"], "[", 
   RowBox[{
    StyleBox["\[Nu]", "TR"], ",", 
    StyleBox["\[Tau]", "TR"], ",", 
    StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
 " is defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalTheta]", "(", 
     RowBox[{"\[Nu]", ",", "\[Tau]", ",", "s"}], ")"}], "=", 
    RowBox[{
     UnderscriptBox["\[Sum]", "n"], 
     RowBox[{"exp", "(", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"\[Pi]", "(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "+", "\[Alpha]"}], ")"}], ".", "\[Tau]", ".", 
          RowBox[{"(", 
           RowBox[{"n", "+", "\[Alpha]"}], ")"}]}], "+", 
         RowBox[{"2", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "+", "\[Alpha]"}], ")"}], ".", 
           RowBox[{"(", 
            RowBox[{"s", "+", "\[Beta]"}], ")"}]}]}]}], ")"}]}], ")"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", where the characteristic ",
 Cell[BoxData[
  StyleBox["\[Nu]", "TR"]], "InlineFormula"],
 " is a pair of ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "-dimensional vectors ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"]}], "}"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->445837411],

Cell["\<\
The Jacobi elliptic functions can be expressed as ratios of the theta \
functions. \
\>", "Text",
 CellID->32671],

Cell[TextData[{
 "An alternative notation for theta functions is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalTheta]", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "4"], "(", 
     RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CapitalTheta]", "1"], "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "3"], "(", 
     RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"H", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "1"], "(", "v", ")"}]}], TraditionalForm]],
   "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["H", "1"], "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "2"], "(", "v", ")"}]}], TraditionalForm]],
   "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Pi]", "u"}], "/", "2"}], 
     RowBox[{"K", "(", "m", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->1457],

Cell[TextData[{
 "The ",
 StyleBox["Neville theta functions",
  FontWeight->"Bold"],
 " can be defined in terms of the theta functions as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "s"], "(", "u", ")"}], "=", 
    RowBox[{"2", 
     RowBox[{"K", "(", "m", ")"}], 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CurlyTheta]", "1"], "(", 
       RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], "/"}]}]}], 
   TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Pi]\[CurlyTheta]", "1", "\[Prime]"], "(", 
    RowBox[{"0", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "c"], "(", "u", ")"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CurlyTheta]", "2"], "(", 
      RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], "/", 
     RowBox[{
      SubscriptBox["\[CurlyTheta]", "2"], "(", 
      RowBox[{"0", "\[VerticalSeparator]", "m"}], ")"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "d"], "(", "u", ")"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CurlyTheta]", "3"], "(", 
      RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], "/", 
     RowBox[{
      SubscriptBox["\[CurlyTheta]", "3"], "(", 
      RowBox[{"0", "\[VerticalSeparator]", "m"}], ")"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "n"], "(", "u", ")"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CurlyTheta]", "4"], "(", 
      RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], "/", 
     RowBox[{
      SubscriptBox["\[CurlyTheta]", "4"], "(", 
      RowBox[{"0", "\[VerticalSeparator]", "m"}], ")"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Pi]", "u"}], "/", "2"}], 
     RowBox[{"K", "(", "m", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". The Jacobi elliptic functions can be represented as ratios of the Neville \
theta functions. "
}], "Text",
 CellID->12998],

Cell[TextData[{
 "The ",
 StyleBox["Weierstrass elliptic function",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassP"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " can be considered as the inverse of an elliptic integral. The Weierstrass \
function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[WeierstrassP]", "(", 
    RowBox[{
     RowBox[{"u", ";", 
      SubscriptBox["g", "2"]}], ",", 
     SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"],
 " gives the value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    SubsuperscriptBox["\[Integral]", "\[Infinity]", "x"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"4", 
       SuperscriptBox["t", "3"], "-", 
       SubscriptBox["g", "2"], "t", "-", 
       SubscriptBox["g", "3"]}], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]], "\[DifferentialD]", "t"}], 
   TraditionalForm]], "InlineMath"],
 ". The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WeierstrassPPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassPPrime"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[WeierstrassP]", "\[Prime]"], "(", 
     RowBox[{
      RowBox[{"u", ";", 
       SubscriptBox["g", "2"]}], ",", 
      SubscriptBox["g", "3"]}], ")"}], "=", 
    RowBox[{
     FractionBox["\[PartialD]", 
      RowBox[{"\[PartialD]", "u"}]], 
     RowBox[{"\[WeierstrassP]", "(", 
      RowBox[{"u", ";", 
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->3545],

Cell[TextData[{
 "The Weierstrass functions are also sometimes written in terms of their ",
 StyleBox["fundamental half\[Hyphen]periods",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox["\[Omega]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Omega]", "\[Prime]"], TraditionalForm]], "InlineMath"],
 ", obtained from the invariants ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "2"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "3"], TraditionalForm]], "InlineMath"],
 " using ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["WeierstrassHalfPeriods",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WeierstrassHalfPeriods"], "[", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13597],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseWeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseWeierstrassP"], "[", 
   RowBox[{
    StyleBox["p", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " finds one of the two values of ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", 
    RowBox[{"\[WeierstrassP]", "(", 
     RowBox[{
      RowBox[{"u", ";", 
       SubscriptBox["g", "2"]}], ",", 
      SubscriptBox["g", "3"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". This value always lies in the parallelogram defined by the complex number \
half\[Hyphen]periods ",
 Cell[BoxData[
  FormBox["\[Omega]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Omega]", "\[Prime]"], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->14218],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseWeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseWeierstrassP"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      StyleBox["q", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " finds the unique value of ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", 
    RowBox[{"\[WeierstrassP]", "(", 
     RowBox[{
      RowBox[{"u", ";", 
       SubscriptBox["g", "2"]}], ",", 
      SubscriptBox["g", "3"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", 
    RowBox[{
     SuperscriptBox["\[WeierstrassP]", "\[Prime]"], "(", 
     RowBox[{
      RowBox[{"u", ";", 
       SubscriptBox["g", "2"]}], ",", 
      SubscriptBox["g", "3"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". In order for any such value of ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " to exist, ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " must be related by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["q", "2"], "=", "4", 
    SuperscriptBox["p", "3"], "-", 
    SubscriptBox["g", "2"], "p", "-", 
    SubscriptBox["g", "3"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->8838],

Cell[TextData[{
 "The ",
 StyleBox["Weierstrass zeta function",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WeierstrassZeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassZeta"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " and ",
 StyleBox["Weierstrass sigma function",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WeierstrassSigma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassSigma"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " are related to the Weierstrass elliptic functions by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Zeta]", "\[Prime]"], "(", 
     RowBox[{
      RowBox[{"z", ";", 
       SubscriptBox["g", "2"]}], ",", 
      SubscriptBox["g", "3"]}], ")"}], "=", 
    RowBox[{"-", 
     RowBox[{"\[WeierstrassP]", "(", 
      RowBox[{"z", ";", 
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Sigma]", "\[Prime]"], "(", 
      RowBox[{
       RowBox[{"z", ";", 
        SubscriptBox["g", "2"]}], ",", 
       SubscriptBox["g", "3"]}], ")"}], "/", 
     RowBox[{"\[Sigma]", "(", 
      RowBox[{"z", ";", 
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], ")"}]}], "=", 
    RowBox[{"\[Zeta]", "(", 
     RowBox[{"z", ";", 
      SubscriptBox["g", "2"], ",", 
      SubscriptBox["g", "3"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->14844],

Cell["\<\
The Weierstrass zeta and sigma functions are not strictly elliptic functions \
since they are not periodic. \
\>", "Text",
 CellID->7372]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elliptic Modular Functions", "Section",
 CellID->8563],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DedekindEta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DedekindEta"], "[", 
     StyleBox["\[Tau]", "TR"], "]"}], Cell[TextData[{
     "Dedekind eta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Eta]", "(", "\[Tau]", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["KleinInvariantJ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/KleinInvariantJ"], "[", 
     StyleBox["\[Tau]", "TR"], "]"}], Cell[TextData[{
     "Klein invariant modular function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"J", "(", "\[Tau]", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ModularLambda",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ModularLambda"], "[", 
     StyleBox["\[Tau]", "TR"], "]"}], Cell[TextData[{
     "modular lambda function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Lambda]", "(", "\[Tau]", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->21028],

Cell["Elliptic modular functions. ", "Caption",
 CellID->29264],

Cell[TextData[{
 "The ",
 StyleBox["modular lambda function",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ModularLambda",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ModularLambda"], "[", 
   StyleBox["\[Tau]", "TR"], "]"}]], "InlineFormula"],
 " relates the ratio of half\[Hyphen]periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Tau]", "=", 
    SuperscriptBox["\[Omega]", "\[Prime]"], "/", "\[Omega]"}], 
   TraditionalForm]], "InlineMath"],
 " to the parameter according to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", 
    RowBox[{"\[Lambda]", "(", "\[Tau]", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->28801],

Cell[TextData[{
 "The ",
 StyleBox["Klein invariant modular function",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["KleinInvariantJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KleinInvariantJ"], "[", 
   StyleBox["\[Tau]", "TR"], "]"}]], "InlineFormula"],
 " and the ",
 StyleBox["Dedekind eta function",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DedekindEta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DedekindEta"], "[", 
   StyleBox["\[Tau]", "TR"], "]"}]], "InlineFormula"],
 " satisfy the relations ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalDelta]", "=", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["g", "2", "3"], "/", 
      RowBox[{"J", "(", "\[Tau]", ")"}]}], "=", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], "12"], 
      RowBox[{
       SuperscriptBox["\[Eta]", "24"], "(", "\[Tau]", ")"}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->14723],

Cell[TextData[{
 "Modular elliptic functions are defined to be invariant under certain \
fractional linear transformations of their arguments. Thus for example ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", "(", "\[Tau]", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is invariant under any combination of the transformations ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Tau]", "\[Rule]", "\[Tau]", "+", "2"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Tau]", "\[Rule]", "\[Tau]", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", "2", "\[Tau]"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->13490]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generalized Elliptic Integrals and Functions", "Section",
 CellID->7604],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ArithmeticGeometricMean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArithmeticGeometricMean"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "the arithmetic\[Hyphen]geometric mean of ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipticExp",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticExp"], "[", 
     StyleBox["u", "TI"], ",", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}", "]"}], Cell[TextData[{
     "generalized exponential associated with the elliptic curve ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["y", "2"], "=", 
        RowBox[{
         SuperscriptBox["x", "3"], "+", 
         RowBox[{"a", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"b", "\[InvisibleSpace]", "x"}]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EllipticLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticLog"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}", "]"}], Cell[TextData[{
     "generalized logarithm associated with the elliptic curve ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["y", "2"], "=", 
        RowBox[{
         SuperscriptBox["x", "3"], "+", 
         RowBox[{"a", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"b", "\[InvisibleSpace]", "x"}]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->31601],

Cell["Generalized elliptic integrals and functions. ", "Caption",
 CellID->24227],

Cell["\<\
The definitions for elliptic integrals and functions given above are based on \
traditional usage. For modern algebraic geometry, it is convenient to use \
slightly more general definitions. \
\>", "Text",
 CellID->11197],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticLog"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " is defined as the value of the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], 
    SubsuperscriptBox["\[Integral]", "\[Infinity]", "x"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["t", "3"], "+", "a", 
       SuperscriptBox["t", "2"], "+", "b", "t"}], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]], "\[DifferentialD]", "t"}], 
   TraditionalForm]], "InlineMath"],
 ", where the sign of the square root is specified by giving the value of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "3"], "+", "a", 
      SuperscriptBox["x", "2"], "+", "b", "x"}]]}], TraditionalForm]], 
  "InlineMath"],
 ". Integrals of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "\[Infinity]", "x"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["t", "2"], "+", "a", "t"}], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]], "\[DifferentialD]", "t"}], 
   TraditionalForm]], "InlineMath"],
 " can be expressed in terms of the ordinary logarithm (and inverse \
trigonometric functions). You can think of ",
 Cell[BoxData[
  ButtonBox["EllipticLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticLog"]], "InlineFormula"],
 " as giving a generalization of this, where the polynomial under the square \
root is now of degree three. "
}], "Text",
 CellID->23692],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticExp"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  ButtonBox["EllipticLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticLog"]], "InlineFormula"],
 ". It returns the list ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
 " that appears in ",
 Cell[BoxData[
  ButtonBox["EllipticLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticLog"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["EllipticExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticExp"]], "InlineFormula"],
 " is an elliptic function, doubly periodic in the complex ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " plane. "
}], "Text",
 CellID->19771],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArithmeticGeometricMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArithmeticGeometricMean"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " gives the ",
 StyleBox["arithmetic\[Hyphen]geometric mean",
  FontWeight->"Bold"],
 " (",
 StyleBox["AGM",
  FontWeight->"Bold"],
 ") of two numbers ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ". This quantity is central to many numerical algorithms for computing \
elliptic integrals and other functions. For positive reals ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " the AGM is obtained by starting with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "0"], "=", "a"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "0"], "=", "b"}], TraditionalForm]], "InlineMath"],
 ", then iterating the transformation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", 
     RowBox[{"n", "+", "1"}]], "=", 
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["a", "n"], "+", 
      SubscriptBox["b", "n"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", 
     RowBox[{"n", "+", "1"}]], "=", 
    SqrtBox[
     RowBox[{
      SubscriptBox["a", "n"], 
      SubscriptBox["b", "n"]}]]}], TraditionalForm]], "InlineMath"],
 " until ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], "=", 
    SubscriptBox["b", "n"]}], TraditionalForm]], "InlineMath"],
 " to the precision required. "
}], "Text",
 CellID->20363],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->540557962],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Elliptic Integrals and Elliptic Functions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SpecialFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 2.9233880}", "context" -> "", 
    "keywords" -> {
     "absolute invariant", "amplitude", "ArithmeticGeometricMean", 
      "complete elliptic integrals", "DedekindEta", "discriminant", 
      "doubly periodic functions", "EllipticE", "EllipticExp", "EllipticF", 
      "elliptic functions", "elliptic integral of first kind", 
      "elliptic integral of second kind", "elliptic integral of third kind", 
      "elliptic integrals", "EllipticK", "EllipticLog", 
      "elliptic modular functions", "EllipticNomeQ", "EllipticPi", 
      "EllipticTheta", "EllipticThetaPrime", "functions", "halfperiods", 
      "half-periods", "halfperiod values", "Heuman lambda function", 
      "incomplete elliptic integrals", "integrals", "invariants", 
      "InverseEllipticNomeQ", "InverseJacobiSN", "InverseJacobiCN ", 
      "InverseWeierstrassP", "JacobiAmplitude", "Jacobi elliptic functions", 
      "JacobiSN", "JacobiSN JacobiCN ", "JacobiZeta", "Jacobi zeta function", 
      "KleinInvariantJ", "LegendreJacobi elliptic integrals", "modular angle",
       "modular functions", "ModularLambda", "modulus", 
      "Neville theta functions", "Nome", "parameters", "pendulum", 
      "theta functions", "Weierstrass elliptic function", 
      "WeierstrassHalfPeriods", "WeierstrassInvariants", "WeierstrassP", 
      "WeierstrassPPrime", "WeierstrassSigma", "WeierstrassZeta", 
      "zeta function"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Even more so than for other special functions, you need to be very \
careful about the arguments you give to elliptic integrals and elliptic \
functions. There are several incompatible conventions in common use, and \
often these conventions are distinguished only by the specific names given to \
arguments or by the presence of separators other than commas between \
arguments. Common argument conventions for elliptic integrals and elliptic \
functions. Converting between different argument conventions. ", 
    "synonyms" -> {"3.2.12"}, "title" -> 
    "Elliptic Integrals and Elliptic Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/EllipticIntegralsAndEllipticFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.12"->{
  Cell[5290, 114, 105, 2, 70, "Title",
   CellTags->{"S3.2.12", "12.1"},
   CellID->7229]},
 "12.1"->{
  Cell[5290, 114, 105, 2, 70, "Title",
   CellTags->{"S3.2.12", "12.1"},
   CellID->7229]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.12", 444696, 8889},
 {"12.1", 444799, 8893}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 4665, 87, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5290, 114, 105, 2, 70, "Title",
 CellTags->{"S3.2.12", "12.1"},
 CellID->7229],
Cell[5398, 118, 418, 7, 70, "Text",
 CellID->20652],
Cell[5819, 127, 9020, 288, 70, "FramedBox",
 CellID->18864],
Cell[14842, 417, 117, 3, 70, "Caption",
 CellID->4769],
Cell[14962, 422, 3739, 118, 70, "DefinitionBox",
 CellID->30470],
Cell[18704, 542, 86, 1, 70, "Caption",
 CellID->15005],
Cell[CellGroupData[{
Cell[18815, 547, 53, 1, 70, "Section",
 CellID->21047],
Cell[18871, 550, 3752, 121, 70, "DefinitionBox",
 CellID->1594],
Cell[22626, 673, 55, 1, 70, "Caption",
 CellID->21487],
Cell[22684, 676, 831, 28, 70, "Text",
 CellID->24326],
Cell[23518, 706, 1798, 61, 70, "Text",
 CellID->3276],
Cell[25319, 769, 218, 7, 70, "Text",
 CellID->21323],
Cell[25540, 778, 2116, 71, 70, "Text",
 CellID->6540],
Cell[27659, 851, 1563, 56, 70, "Text",
 CellID->7679],
Cell[29225, 909, 912, 34, 70, "Text",
 CellID->23990],
Cell[30140, 945, 841, 31, 70, "Text",
 CellID->32588],
Cell[30984, 978, 769, 27, 70, "Text",
 CellID->24710],
Cell[31756, 1007, 1209, 43, 70, "Text",
 CellID->29271],
Cell[32968, 1052, 704, 26, 70, "Text",
 CellID->17945],
Cell[33675, 1080, 222, 7, 70, "MathCaption",
 CellID->29221],
Cell[CellGroupData[{
Cell[33922, 1091, 216, 7, 28, "Input",
 CellID->28470],
Cell[34141, 1100, 2178, 40, 132, "Output",
 Evaluatable->False,
 CellID->519490413]
}, Open  ]],
Cell[36334, 1143, 323, 13, 70, "MathCaption",
 CellID->23589],
Cell[CellGroupData[{
Cell[36682, 1160, 217, 8, 70, "Input",
 CellID->23955],
Cell[36902, 1170, 171, 5, 36, "Output",
 CellID->4978]
}, Open  ]],
Cell[37088, 1178, 121, 3, 70, "MathCaption",
 CellID->24779],
Cell[CellGroupData[{
Cell[37234, 1185, 472, 15, 28, "Input",
 CellID->5006],
Cell[37709, 1202, 18439, 306, 165, "Output",
 Evaluatable->False,
 CellID->318070688]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56197, 1514, 53, 1, 70, "Section",
 CellID->20135],
Cell[56253, 1517, 8304, 270, 70, "DefinitionBox",
 CellID->23487],
Cell[64560, 1789, 67, 1, 70, "Caption",
 CellID->27196],
Cell[64630, 1792, 278, 6, 70, "Text",
 CellID->29033],
Cell[64911, 1800, 196, 7, 70, "Text",
 CellID->2088],
Cell[65110, 1809, 1202, 42, 70, "Text",
 CellID->12935],
Cell[66315, 1853, 1694, 65, 70, "Text",
 CellID->19779],
Cell[68012, 1920, 1439, 58, 70, "Text",
 CellID->15993],
Cell[69454, 1980, 1484, 48, 70, "Text",
 CellID->14790],
Cell[70941, 2030, 531, 17, 70, "Text",
 CellID->24962],
Cell[71475, 2049, 1080, 33, 70, "Text",
 CellID->18965],
Cell[72558, 2084, 888, 29, 70, "Text",
 CellID->11001],
Cell[73449, 2115, 542, 18, 70, "Text",
 CellID->19105],
Cell[73994, 2135, 329, 10, 70, "MathCaption",
 CellID->11807],
Cell[CellGroupData[{
Cell[74348, 2149, 622, 20, 70, "Input",
 CellID->24567],
Cell[74973, 2171, 332157, 5432, 70, "Output",
 CellID->25400297]
}, Open  ]],
Cell[407145, 7606, 1254, 45, 70, "Text",
 CellID->2669],
Cell[408402, 7653, 5353, 192, 70, "Text",
 CellID->3134],
Cell[413758, 7847, 2778, 93, 70, "Text",
 CellID->445837411],
Cell[416539, 7942, 123, 4, 70, "Text",
 CellID->32671],
Cell[416665, 7948, 1425, 51, 70, "Text",
 CellID->1457],
Cell[418093, 8001, 2292, 77, 70, "Text",
 CellID->12998],
Cell[420388, 8080, 2286, 81, 70, "Text",
 CellID->3545],
Cell[422677, 8163, 1096, 39, 70, "Text",
 CellID->13597],
Cell[423776, 8204, 1126, 39, 70, "Text",
 CellID->14218],
Cell[424905, 8245, 1671, 60, 70, "Text",
 CellID->8838],
Cell[426579, 8307, 2061, 75, 70, "Text",
 CellID->14844],
Cell[428643, 8384, 147, 4, 70, "Text",
 CellID->7372]
}, Open  ]],
Cell[CellGroupData[{
Cell[428827, 8393, 60, 1, 70, "Section",
 CellID->8563],
Cell[428890, 8396, 1463, 45, 70, "DefinitionBox",
 CellID->21028],
Cell[430356, 8443, 63, 1, 70, "Caption",
 CellID->29264],
Cell[430422, 8446, 681, 25, 70, "Text",
 CellID->28801],
Cell[431106, 8473, 1017, 38, 70, "Text",
 CellID->14723],
Cell[432126, 8513, 674, 21, 70, "Text",
 CellID->13490]
}, Open  ]],
Cell[CellGroupData[{
Cell[432837, 8539, 78, 1, 70, "Section",
 CellID->7604],
Cell[432918, 8542, 2316, 68, 70, "DefinitionBox",
 CellID->31601],
Cell[435237, 8612, 81, 1, 70, "Caption",
 CellID->24227],
Cell[435321, 8615, 231, 5, 70, "Text",
 CellID->11197],
Cell[435555, 8622, 1951, 63, 70, "Text",
 CellID->23692],
Cell[437509, 8687, 1065, 38, 70, "Text",
 CellID->19771],
Cell[438577, 8727, 1852, 67, 70, "Text",
 CellID->20363],
Cell[CellGroupData[{
Cell[440454, 8798, 72, 1, 70, "RelatedTutorialsSection",
 CellID->540557962],
Cell[440529, 8801, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[440743, 8810, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

