(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54211,       1885]
NotebookOptionsPosition[     46554,       1628]
NotebookOutlinePosition[     49310,       1700]
CellTagsIndexPosition[     49216,       1694]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Input and Output in Notebooks" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Entering Formulas", "Title",
 CellTags->{"S1.10.4", "4.1"},
 CellID->3393],

Cell[BoxData[GridBox[{
   {Cell["character", "TableHeader"], Cell["short form", "TableHeader"], Cell[
    "long form", "TableHeader"], Cell["symbol", "TableHeader"]},
   {Cell[BoxData[
     FormBox["\[Pi]", TraditionalForm]], "InlineMath"], 
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["p", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[BoxData[
     ButtonBox["\\[Pi]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Pi"]], "InlineCharacterName"], 
    ButtonBox["Pi",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Pi"]},
   {Cell[BoxData[
     FormBox["\[Infinity]", TraditionalForm]], "InlineMath"], 
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["inf", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[BoxData[
     ButtonBox["\\[Infinity]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Infinity"]], "InlineCharacterName"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"]},
   {Cell[BoxData[
     FormBox["\[Degree]", TraditionalForm]], "InlineMath"], 
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["deg", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[BoxData[
     ButtonBox["\\[Degree]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Degree"]], "InlineCharacterName"], 
    ButtonBox["Degree",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Degree"]}
  }]], "DefinitionBox4Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.15], 
     Scaled[0.3], 
     Scaled[0.2], {
      Scaled[0.35]}}, "ColumnsIndexed" -> {}}},
 CellID->8738],

Cell["Special forms for some common symbols.", "Caption",
 CellID->15279],

Cell[TextData[{
 "This is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", 
   RowBox[{"60", 
    ButtonBox["Degree",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Degree"]}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"60", "\[Degree]"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->1608],

Cell[BoxData[
 FractionBox[
  SqrtBox["3"], "2"]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->12654]
}, Open  ]],

Cell["Here is the long form of the input. ", "MathCaption",
 CellID->3822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"60", " ", "\[Degree]"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->32707],

Cell[BoxData[
 FractionBox[
  SqrtBox["3"], "2"]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->24245]
}, Open  ]],

Cell["You can enter the same input like this. ", "MathCaption",
 CellID->1338],

Cell[CellGroupData[{

Cell[TextData[{
 "Sin[60 \[AliasIndicator]",
 StyleBox["deg\[AliasIndicator]", "InlineCode"],
 "]"
}], "Input", "ConversionLockdown",
 CellLabel->"In[3]:= ",
 CellID->144],

Cell[BoxData[
 FractionBox[
  SqrtBox["3"], "2"]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->22290]
}, Open  ]],

Cell["Here the angle is in radians. ", "MathCaption",
 CellID->31339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  FractionBox["\[Pi]", "3"], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->23154],

Cell[BoxData[
 FractionBox[
  SqrtBox["3"], "2"]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->24604]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["special characters", "TableHeader"], Cell[
    "short form", "TableHeader"], Cell["long form", "TableHeader"], Cell[
    "ordinary characters", "TableHeader"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[LessEqual]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], " ", 
      StyleBox["Esc", "KeyEvent"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["<=", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], " ", 
      StyleBox["y", "TI"]}]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[LessEqual]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/LessEqual"]], "InlineCharacterName"],
      " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", "<=", " ", 
     StyleBox["y", "TI"]}]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[GreaterEqual]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], " ", 
      StyleBox["Esc", "KeyEvent"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox[">=", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], " ", 
      StyleBox["y", "TI"]}]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[GreaterEqual]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/GreaterEqual"]], 
      "InlineCharacterName"], " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", ">=", " ", 
     StyleBox["y", "TI"]}]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[NotEqual]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], " ", 
      StyleBox["Esc", "KeyEvent"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["!=", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], " ", 
      StyleBox["y", "TI"]}]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[NotEqual]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/NotEqual"]], "InlineCharacterName"], 
     " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", "!=", " ", 
     StyleBox["y", "TI"]}]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[Element]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["el", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"], " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[Element]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Element"]], "InlineCharacterName"], 
     " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["Element",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Element"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "]"}]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[Rule]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], " ", 
      StyleBox["Esc", "KeyEvent"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["->", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], " ", 
      StyleBox["y", "TI"]}]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[Rule]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"], " ",
      
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", "->", " ", 
     StyleBox["y", "TI"]}]}
  }]], "DefinitionBox4Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {True}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.25]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->4623],

Cell[TextData[{
 "Special forms for a few operators. \"",
 ButtonBox["Operator Input Forms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax#23301"],
 "\" gives a complete list. "
}], "Caption",
 CellID->22225],

Cell[TextData[{
 "Here the replacement rule is entered using two ordinary characters, as ",
 Cell[BoxData["->"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "/", 
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}]}], "/.", 
  RowBox[{"x", "->", 
   RowBox[{"3", "+", "y"}]}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->21724],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", "+", "y"}], 
  RowBox[{"4", "+", "y"}]]], "Output",
 ImageSize->{35, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->31981]
}, Open  ]],

Cell["This means exactly the same. ", "MathCaption",
 CellID->2330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "/", 
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}]}], "/.", 
  RowBox[{"x", " ", "\[Rule]", " ", 
   RowBox[{"3", "+", "y"}]}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->29733],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", "+", "y"}], 
  RowBox[{"4", "+", "y"}]]], "Output",
 ImageSize->{35, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->28223]
}, Open  ]],

Cell["As does this. ", "MathCaption",
 CellID->20594],

Cell[CellGroupData[{

Cell[TextData[{
 "x/(x+1) /. x ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]->\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " 3 + y"
}], "Input",
 CellLabel->"In[8]:= ",
 CellID->29445],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", "+", "y"}], 
  RowBox[{"4", "+", "y"}]]], "Output",
 ImageSize->{35, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->18805]
}, Open  ]],

Cell[TextData[{
 "When you type the ordinary-character form for certain operators, the front \
end automatically replaces them with the special-character form. For \
instance, when you type the last three examples, the front end automatically \
substitutes the ",
 Cell[BoxData[
  FormBox["\[Rule]", TraditionalForm]], "InlineMath"],
 " character for ",
 Cell[BoxData["->"], "InlineFormula"],
 "."
}], "Text",
 CellID->260415718],

Cell[TextData[{
 "The special arrow form ",
 Cell[BoxData[
  FormBox["\[Rule]", TraditionalForm]], "InlineMath"],
 " is by default also used for output. "
}], "MathCaption",
 CellID->8616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "==", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->5750],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->20489]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["special characters", "TableHeader"], Cell[
    "short form", "TableHeader"], Cell["long form", "TableHeader"], Cell[
    "ordinary characters", "TableHeader"]},
   {
    RowBox[{
     StyleBox["x", "TI"], " ", "\[Divide]", " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["div", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"], " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[Divide]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Divide"]], "InlineCharacterName"], 
     " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", "/", " ", 
     StyleBox["y", "TI"]}]},
   {
    RowBox[{
     StyleBox["x", "TI"], " ", "\[Times]", " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["*", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"], " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[Times]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"], 
     " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", "*", " ", 
     StyleBox["y", "TI"]}]},
   {
    RowBox[{
     StyleBox["x", "TI"], " ", "\[Cross]", " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["cross", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"], " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[Cross]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"], 
     " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["Cross",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cross"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "]"}]},
   {
    RowBox[{
     StyleBox["x", "TI"], " ", "\[Equal]", " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], " ", 
      StyleBox["Esc", "KeyEvent"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["==", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], " ", 
      StyleBox["y", "TI"]}]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[Equal]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Equal"]], "InlineCharacterName"], 
     " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", "==", " ", 
     StyleBox["y", "TI"]}]},
   {
    RowBox[{
     StyleBox["x", "TI"], " ", "\[LongEqual]", " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], " ", 
      StyleBox["Esc", "KeyEvent"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["l", "InlineCode"]}], 
     StyleBox["=", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], " ", 
      StyleBox["y", "TI"]}]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[LongEqual]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/LongEqual"]], "InlineCharacterName"],
      " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", "==", " ", 
     StyleBox["y", "TI"]}]},
   {
    RowBox[{
     StyleBox["x", "TI"], " ", "\[And]", " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], " ", 
      StyleBox["Esc", "KeyEvent"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["&&", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], " ", 
      StyleBox["y", "TI"]}]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[And]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"], " ", 
     
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", "&&", " ", 
     StyleBox["y", "TI"]}]},
   {
    RowBox[{
     StyleBox["x", "TI"], " ", "\[Or]", " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], " ", 
      StyleBox["Esc", "KeyEvent"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["||", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], " ", 
      StyleBox["y", "TI"]}]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[Or]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Or"]], "InlineCharacterName"], " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", "||", " ", 
     StyleBox["y", "TI"]}]},
   {
    RowBox[{"\[Not]", " ", 
     StyleBox["x", "TI"]}], 
    RowBox[{
     RowBox[{
      StyleBox["Esc", "KeyEvent"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["!", "InlineCode"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"], " ", 
     StyleBox["x", "TI"]}], 
    RowBox[{Cell[BoxData[
      ButtonBox["\\[Not]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Not"]], "InlineCharacterName"], " ", 
     
     StyleBox["x", "TI"]}], 
    RowBox[{"!", " ", 
     StyleBox["x", "TI"]}]},
   {
    RowBox[{
     StyleBox["x", "TI"], " ", "\[Implies]", " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], " ", 
      StyleBox["Esc", "KeyEvent"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["=", "InlineCode"], 
     RowBox[{
      StyleBox[">", "InlineCode"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      RowBox[{
       StyleBox["Esc", "KeyEvent"], " ", 
       StyleBox["y", "TI"]}]}]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[Implies]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Implies"]], "InlineCharacterName"], 
     " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     RowBox[{"=", ">"}], " ", 
     StyleBox["y", "TI"]}]},
   {
    RowBox[{
     StyleBox["x", "TI"], " ", "\[Union]", " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["un", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"], " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[Union]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Union"]], "InlineCharacterName"], 
     " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["Union",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Union"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "]"}]},
   {
    RowBox[{
     StyleBox["x", "TI"], " ", "\[Intersection]", " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["inter", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"], " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[Intersection]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Intersection"]], 
      "InlineCharacterName"], " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     ButtonBox["Intersection",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Intersection"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "]"}]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[InvisibleComma]", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], " ", 
      StyleBox["Esc", "KeyEvent"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox[",", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], " ", 
      StyleBox["y", "TI"]}]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[InvisibleComma]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/InvisibleComma"]], 
      "InlineCharacterName"], " ", 
     StyleBox["y", "TI"]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox[",", "InlineCode"], " ", 
     StyleBox["y", "TI"]}]},
   {
    RowBox[{
     StyleBox["f", "TI"], "\[InvisibleApplication]", 
     StyleBox["x", "TI"]}], 
    RowBox[{
     StyleBox["f", "TI"], " ", 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["@", "InlineCode"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["Esc", "KeyEvent"]}], " ", 
     StyleBox["x", "TI"]}], 
    RowBox[{
     StyleBox["f", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[InvisibleApplication]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/InvisibleApplication"]], 
      "InlineCharacterName"], " ", 
     StyleBox["x", "TI"]}], 
    RowBox[{
     StyleBox["f", "TI"], " ", "@", " ", 
     StyleBox["x", "TI"], Cell[" or ", "TableText"], 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["x", "TI"], "]"}]}]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[ImplicitPlus]", 
     FractionBox[
      StyleBox["y", "TI"], 
      StyleBox["z", "TI"]]}], 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], " ", 
      StyleBox["Esc", "KeyEvent"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["+", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], " ", 
      FractionBox[
       StyleBox["y", "TI"], 
       StyleBox["z", "TI"]]}]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", Cell[BoxData[
      ButtonBox["\\[ImplicitPlus]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/ImplicitPlus"]], 
      "InlineCharacterName"], " ", 
     FractionBox[
      StyleBox["y", "TI"], 
      StyleBox["z", "TI"]]}], 
    RowBox[{
     StyleBox["x", "TI"], " ", "+", " ", 
     StyleBox["y", "TI"], " ", "/", " ", 
     StyleBox["z", "TI"]}]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "DefinitionBox4Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, True, True, False, False, False, False, False, True, 
     False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.2], 
     Scaled[0.2], 
     Scaled[0.35], {
      Scaled[0.25]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->27338],

Cell["\<\
Some operators with special forms used for input but not output. \
\>", "Caption",
 CellID->21963],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " understands ",
 Cell[BoxData[
  FormBox["\[Divide]", TraditionalForm]], "InlineMath"],
 ", but does not use it by default for output. "
}], "MathCaption",
 CellID->28135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", "\[Divide]", " ", "y"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->14697],

Cell[BoxData[
 FractionBox["x", "y"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->32209]
}, Open  ]],

Cell[TextData[{
 "Many of the forms of input discussed here use special characters, but \
otherwise just consist of ordinary one\[Hyphen]dimensional lines of text. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks, however, also make it possible to use two\[Hyphen]dimensional \
forms of input. "
}], "Text",
 CellID->21630],

Cell[BoxData[GridBox[{
   {Cell["two-dimensional", "TableHeader"], Cell[
    "one-dimensional", "TableHeader"], ""},
   {Cell[BoxData[
     FormBox[
      SuperscriptBox["x", "y"], TraditionalForm]], "InlineMath"], 
    RowBox[{
     StyleBox["x", "TI"], "^", 
     StyleBox["y", "TI"]}], Cell["power", "TableText"]},
   {Cell[BoxData[
     FormBox[
      FractionBox["x", "y"], TraditionalForm]], "InlineMath"], 
    RowBox[{
     StyleBox["x", "TI"], "/", 
     StyleBox["y", "TI"]}], Cell["division", "TableText"]},
   {Cell[BoxData[
     FormBox[
      SqrtBox["x"], TraditionalForm]], "InlineMath"], 
    RowBox[{
     ButtonBox["Sqrt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sqrt"], "[", 
     StyleBox["x", "TI"], "]"}], Cell["square root", "TableText"]},
   {Cell[BoxData[
     FormBox[
      RadicalBox["x", "n"], TraditionalForm]], "InlineMath"], 
    RowBox[{
     StyleBox["x", "TI"], "^", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["1", "TR"], "/", 
       StyleBox["n", "TI"]}], ")"}]}], Cell[TextData[{
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " root"
    }], "TableText"]},
   {Cell[BoxData[
     FormBox[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", 
         SubscriptBox["i", 
          StyleBox["min", "TI"]]}], 
        SubscriptBox["i", 
         StyleBox["max", "TI"]]], "f"}], TraditionalForm]], "InlineMath"], 
    RowBox[{
     ButtonBox["Sum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sum"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell["sum", "TableText"]},
   {Cell[BoxData[
     FormBox[
      RowBox[{
       UnderoverscriptBox["\[Product]", 
        RowBox[{"i", "=", 
         SubscriptBox["i", 
          StyleBox["min", "TI"]]}], 
        SubscriptBox["i", 
         StyleBox["max", "TI"]]], "f"}], TraditionalForm]], "InlineMath"], 
    RowBox[{
     ButtonBox["Product",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Product"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell[
    "product", "TableText"]},
   {Cell[BoxData[
     FormBox[
      RowBox[{"\[Integral]", 
       RowBox[{"f", " ", 
        RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], 
     "InlineMath"], 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[
    "indefinite integral", "TableText"]},
   {Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        StyleBox[
         SubscriptBox["x", "min"], "TI",
         FontVariations->{"StrikeThrough"->True}], 
        SubscriptBox["x", 
         StyleBox["max", "TI"]]], 
       RowBox[{"f", " ", 
        RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], 
     "InlineMath"], 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell[
    "definite integral", "TableText"]},
   {Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "f"}], TraditionalForm]], 
     "InlineMath"], 
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell["partial derivative", "TableText"]},
   {Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[PartialD]", 
        RowBox[{"x", ",", "y"}]], "f"}], TraditionalForm]], "InlineMath"], 
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "]"}], Cell[
    "multivariate partial derivative", "TableText"]},
   {Cell[BoxData[
     FormBox[
      SuperscriptBox["z", "\[Conjugate]"], TraditionalForm]], "InlineMath"], 
    RowBox[{
     ButtonBox["Conjugate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Conjugate"], "[", 
     StyleBox["x", "TI"], "]"}], Cell["complex conjugate", "TableText"]},
   {Cell[BoxData[
     FormBox[
      SuperscriptBox["m", "\[Transpose]"], TraditionalForm]], "InlineMath"], 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["transpose", "TableText"]},
   {Cell[BoxData[
     FormBox[
      SuperscriptBox["m", "\[ConjugateTranspose]"], TraditionalForm]], 
     "InlineMath"], 
    RowBox[{
     ButtonBox["ConjugateTranspose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["conjugate transpose", "TableText"]},
   {Cell[BoxData[
     FormBox[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       RowBox[{
        RowBox[{"[", "["}], 
        RowBox[{"i", ",", "j", ",", "\[Ellipsis]"}], 
        RowBox[{"]", "]"}]}]], TraditionalForm]], "InlineMath"], 
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "part extraction", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, False, False, False, False, False, 
     False, False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], 
     Scaled[0.35], {
      Scaled[0.4]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->23224],

Cell[TextData[{
 "Some two\[Hyphen]dimensional forms that can be used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks. "
}], "Caption",
 CellID->1908],

Cell[TextData[{
 "You can enter two\[Hyphen]dimensional forms using any of the mechanisms \
discussed in\[NonBreakingSpace]\"",
 ButtonBox["Entering Two-Dimensional Input\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/EnteringTwoDimensionalInput"],
 ". Note that upper and lower limits for sums and products must be entered as \
overscripts and underscripts\[LongDash]not superscripts and subscripts."
}], "Text",
 CellID->26737],

Cell[TextData[{
 "This enters an indefinite integral. Note the use of ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter the \[OpenCurlyDoubleQuote]differential \
d\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
 CellID->24474],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]int\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " f[x] ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " x"
}], "Input",
 CellLabel->"In[11]:= ",
 CellID->31920],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{63, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->27372]
}, Open  ]],

Cell["\<\
Here is an indefinite integral that can be explicitly evaluated. \
\>", "MathCaption",
 CellID->10293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     SuperscriptBox["x", "2"]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->3855],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"], "[", "x", "]"}]}]], "Output",
 ImageSize->{88, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->6734]
}, Open  ]],

Cell[TextData[{
 "Here is the usual ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input for this integral. "
}], "MathCaption",
 CellID->9561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->31056],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"], "[", "x", "]"}]}]], "Output",
 ImageSize->{88, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->27606]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["short form", "TableHeader"], Cell["long form", "TableHeader"], ""},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["sum", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[BoxData[
     ButtonBox["\\[Sum]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Sum"]], "InlineCharacterName"], Cell[
    TextData[{
     "summation sign ",
     Cell[BoxData[
      FormBox["\[Sum]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["prod", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[BoxData[
     ButtonBox["\\[Product]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Product"]], "InlineCharacterName"], 
    Cell[TextData[{
     "product sign ",
     Cell[BoxData[
      FormBox["\[Product]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["int", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[BoxData[
     ButtonBox["\\[Integral]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Integral"]], "InlineCharacterName"], 
    Cell[TextData[{
     "integral sign ",
     Cell[BoxData[
      FormBox["\[Integral]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["dd", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[BoxData[
     ButtonBox["\\[DifferentialD]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/DifferentialD"]], 
     "InlineCharacterName"], Cell[TextData[{
     "special ",
     Cell[BoxData[
      FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
     " for use in integrals "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["pd", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[BoxData[
     ButtonBox["\\[PartialD]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/PartialD"]], "InlineCharacterName"], 
    Cell[TextData[{
     "partial derivative operator ",
     Cell[BoxData[
      FormBox["\[PartialD]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["co", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[BoxData[
     ButtonBox["\\[Conjugate]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Conjugate"]], "InlineCharacterName"], 
    Cell[TextData[{
     "conjugate symbol ",
     Cell[BoxData[
      FormBox["\[Conjugate]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["tr", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[BoxData[
     ButtonBox["\\[Transpose]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Transpose"]], "InlineCharacterName"], 
    Cell[TextData[{
     "transpose symbol ",
     Cell[BoxData[
      FormBox["\[Transpose]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["ct", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[BoxData[
     ButtonBox["\\[ConjugateTranspose]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/ConjugateTranspose"]], 
     "InlineCharacterName"], Cell[TextData[{
     "conjugate transpose symbol ",
     Cell[BoxData[
      FormBox["\[ConjugateTranspose]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["[", "InlineCode"], 
     RowBox[{
      StyleBox["[", "InlineCode"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["Esc", "KeyEvent"]}]}], Cell[BoxData[
     ButtonBox["\\[LeftDoubleBracket]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/LeftDoubleBracket"]], 
     "InlineCharacterName"], Cell["part brackets", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], 
     Scaled[0.35], {
      Scaled[0.4]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->14119],

Cell[TextData[{
 "Some special characters used in entering formulas. ",
 ButtonBox["Mathematical and Other Notation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicalAndOtherNotationOverview"],
 " gives a complete list. "
}], "Caption",
 CellID->6741],

Cell[TextData[{
 "You should realize that even though a summation sign can look almost \
identical to a capital sigma it is treated in a very different way by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The point is that a sigma is just a letter; but a summation sign is an \
operator which tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to perform a ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " operation."
}], "Text",
 CellID->30432],

Cell["Capital sigma is just a letter. ", "MathCaption",
 CellID->24684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"\[CapitalSigma]", "^", "2"}]}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->12779],

Cell[BoxData[
 RowBox[{"a", "+", 
  SuperscriptBox["\[CapitalSigma]", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->12279]
}, Open  ]],

Cell["A summation sign, on the other hand, is an operator. ", "MathCaption",
 CellID->18283],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]sum\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["+", "KeyEvent"],
 " n=0 ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " m ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " 1/f[n]"
}], "Input",
 CellLabel->"In[16]:= ",
 CellID->20667],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"n", "=", "0"}], "m"], 
  FractionBox["1", 
   RowBox[{"f", "[", "n", "]"}]]}]], "Output",
 ImageSize->{54, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->30836]
}, Open  ]],

Cell[TextData[{
 "Much as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " distinguishes between a summation sign and a capital sigma, it also \
distinguishes between an ordinary ",
 Cell[BoxData["d"], "InlineFormula"],
 ", the \[OpenCurlyDoubleQuote]partial d\[CloseCurlyDoubleQuote] \[PartialD] \
that is used for taking derivatives, and the special \
\[OpenCurlyDoubleQuote]differential d\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 " that is used in the standard notation for integrals. It is crucial that \
you use the differential ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 "\[LongDash]entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "\[LongDash]when you type in an integral. If you try to use an ordinary ",
 Cell[BoxData["d"], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will just interpret this as a symbol called ",
 Cell[BoxData["d"], "InlineFormula"],
 "\[LongDash]it will not understand that you are entering the second part of \
an integration operator. "
}], "Text",
 CellID->18028],

Cell[TextData[{
 "This computes the derivative of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "n"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->32119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  SuperscriptBox["x", "n"]}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->20577],

Cell[BoxData[
 RowBox[{"n", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->10737]
}, Open  ]],

Cell["\<\
Here is the same derivative specified in ordinary one\[Hyphen]dimensional \
form. \
\>", "MathCaption",
 CellID->14091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->20556],

Cell[BoxData[
 RowBox[{"n", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->22795]
}, Open  ]],

Cell["This computes the third derivative. ", "MathCaption",
 CellID->16060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"x", ",", "x", ",", "x"}]], 
  SuperscriptBox["x", "n"]}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->21901],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "n"}]]}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->8793]
}, Open  ]],

Cell["\<\
Here is the equivalent one\[Hyphen]dimensional input form. \
\>", "MathCaption",
 CellID->3432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x", ",", "x", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->2136],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "n"}]]}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->4580]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->819248578],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Entering Formulas - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EditingAndEvaluatingTwoDimensionalExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/EnteringTablesAndMatrices"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 6.1265950}", "context" -> "", 
    "keywords" -> {
     "derivatives", "DifferentialD", "formulas", "function application", 
      "indices", "integrals", "limits", "logic expressions", 
      "multiple derivatives", "PartialD", "partial derivatives", "parts", 
      "pd", "products", "set operations", "sigma", "special characters", 
      "subscripts", "sums"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Special forms for some common symbols. This is equivalent to \
Sin[60Degree]. Here is the long form of the input. ", 
    "synonyms" -> {"1.10.4"}, "title" -> "Entering Formulas", "type" -> 
    "Tutorial", "uri" -> "tutorial/EnteringFormulas"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.4"->{
  Cell[1286, 44, 80, 2, 70, "Title",
   CellTags->{"S1.10.4", "4.1"},
   CellID->3393]},
 "4.1"->{
  Cell[1286, 44, 80, 2, 70, "Title",
   CellTags->{"S1.10.4", "4.1"},
   CellID->3393]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.4", 49005, 1683},
 {"4.1", 49104, 1687}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 661, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1286, 44, 80, 2, 70, "Title",
 CellTags->{"S1.10.4", "4.1"},
 CellID->3393],
Cell[1369, 48, 2072, 55, 70, "DefinitionBox4Col",
 CellID->8738],
Cell[3444, 105, 73, 1, 70, "Caption",
 CellID->15279],
Cell[3520, 108, 326, 13, 70, "MathCaption",
 CellID->19882],
Cell[CellGroupData[{
Cell[3871, 125, 122, 4, 28, "Input",
 CellID->1608],
Cell[3996, 131, 187, 7, 56, "Output",
 CellID->12654]
}, Open  ]],
Cell[4198, 141, 74, 1, 70, "MathCaption",
 CellID->3822],
Cell[CellGroupData[{
Cell[4297, 146, 128, 4, 28, "Input",
 CellID->32707],
Cell[4428, 152, 187, 7, 56, "Output",
 CellID->24245]
}, Open  ]],
Cell[4630, 162, 78, 1, 70, "MathCaption",
 CellID->1338],
Cell[CellGroupData[{
Cell[4733, 167, 171, 6, 70, "Input",
 CellID->144],
Cell[4907, 175, 187, 7, 56, "Output",
 CellID->22290]
}, Open  ]],
Cell[5109, 185, 69, 1, 70, "MathCaption",
 CellID->31339],
Cell[CellGroupData[{
Cell[5203, 190, 121, 4, 70, "Input",
 CellID->23154],
Cell[5327, 196, 187, 7, 56, "Output",
 CellID->24604]
}, Open  ]],
Cell[5529, 206, 4226, 135, 70, "DefinitionBox4Col",
 CellID->4623],
Cell[9758, 343, 226, 7, 70, "Caption",
 CellID->22225],
Cell[9987, 352, 171, 5, 70, "MathCaption",
 CellID->20078],
Cell[CellGroupData[{
Cell[10183, 361, 210, 8, 70, "Input",
 CellID->21724],
Cell[10396, 371, 221, 8, 53, "Output",
 CellID->31981]
}, Open  ]],
Cell[10632, 382, 67, 1, 70, "MathCaption",
 CellID->2330],
Cell[CellGroupData[{
Cell[10724, 387, 225, 8, 70, "Input",
 CellID->29733],
Cell[10952, 397, 221, 8, 53, "Output",
 CellID->28223]
}, Open  ]],
Cell[11188, 408, 53, 1, 70, "MathCaption",
 CellID->20594],
Cell[CellGroupData[{
Cell[11266, 413, 211, 8, 70, "Input",
 CellID->29445],
Cell[11480, 423, 221, 8, 53, "Output",
 CellID->18805]
}, Open  ]],
Cell[11716, 434, 429, 11, 70, "Text",
 CellID->260415718],
Cell[12148, 447, 188, 6, 70, "MathCaption",
 CellID->8616],
Cell[CellGroupData[{
Cell[12361, 457, 170, 6, 70, "Input",
 CellID->5750],
Cell[12534, 465, 332, 12, 36, "Output",
 CellID->20489]
}, Open  ]],
Cell[12881, 480, 11431, 366, 70, "DefinitionBox4Col",
 CellID->27338],
Cell[24315, 848, 108, 3, 70, "Caption",
 CellID->21963],
Cell[24426, 853, 238, 8, 70, "MathCaption",
 CellID->28135],
Cell[CellGroupData[{
Cell[24689, 865, 108, 3, 70, "Input",
 CellID->14697],
Cell[24800, 870, 176, 6, 51, "Output",
 CellID->32209]
}, Open  ]],
Cell[24991, 879, 339, 8, 70, "Text",
 CellID->21630],
Cell[25333, 889, 6719, 211, 70, "DefinitionBox3Col",
 CellID->23224],
Cell[32055, 1102, 170, 6, 70, "Caption",
 CellID->1908],
Cell[32228, 1110, 438, 9, 70, "Text",
 CellID->26737],
Cell[32669, 1121, 305, 8, 70, "MathCaption",
 CellID->24474],
Cell[CellGroupData[{
Cell[32999, 1133, 317, 11, 70, "Input",
 CellID->31920],
Cell[33319, 1146, 264, 9, 50, "Output",
 CellID->27372]
}, Open  ]],
Cell[33598, 1158, 112, 3, 70, "MathCaption",
 CellID->10293],
Cell[CellGroupData[{
Cell[33735, 1165, 224, 8, 70, "Input",
 CellID->3855],
Cell[33962, 1175, 326, 12, 70, "Output",
 CellID->6734]
}, Open  ]],
Cell[34303, 1190, 151, 6, 70, "MathCaption",
 CellID->9561],
Cell[CellGroupData[{
Cell[34479, 1200, 203, 7, 70, "Input",
 CellID->31056],
Cell[34685, 1209, 327, 12, 70, "Output",
 CellID->27606]
}, Open  ]],
Cell[35027, 1224, 5195, 148, 70, "DefinitionBox3Col",
 CellID->14119],
Cell[40225, 1374, 267, 7, 70, "Caption",
 CellID->6741],
Cell[40495, 1383, 531, 16, 70, "Text",
 CellID->30432],
Cell[41029, 1401, 71, 1, 70, "MathCaption",
 CellID->24684],
Cell[CellGroupData[{
Cell[41125, 1406, 127, 4, 70, "Input",
 CellID->12779],
Cell[41255, 1412, 216, 7, 36, "Output",
 CellID->12279]
}, Open  ]],
Cell[41486, 1422, 92, 1, 70, "MathCaption",
 CellID->18283],
Cell[CellGroupData[{
Cell[41603, 1427, 512, 19, 70, "Input",
 CellID->20667],
Cell[42118, 1448, 285, 10, 58, "Output",
 CellID->30836]
}, Open  ]],
Cell[42418, 1461, 1221, 30, 70, "Text",
 CellID->18028],
Cell[43642, 1493, 182, 7, 70, "MathCaption",
 CellID->32119],
Cell[CellGroupData[{
Cell[43849, 1504, 141, 5, 70, "Input",
 CellID->20577],
Cell[43993, 1511, 246, 9, 36, "Output",
 CellID->10737]
}, Open  ]],
Cell[44254, 1523, 129, 4, 70, "MathCaption",
 CellID->14091],
Cell[CellGroupData[{
Cell[44408, 1531, 142, 5, 70, "Input",
 CellID->20556],
Cell[44553, 1538, 246, 9, 36, "Output",
 CellID->22795]
}, Open  ]],
Cell[44814, 1550, 75, 1, 70, "MathCaption",
 CellID->16060],
Cell[CellGroupData[{
Cell[44914, 1555, 175, 6, 70, "Input",
 CellID->21901],
Cell[45092, 1563, 400, 15, 36, "Output",
 CellID->8793]
}, Open  ]],
Cell[45507, 1581, 105, 3, 70, "MathCaption",
 CellID->3432],
Cell[CellGroupData[{
Cell[45637, 1588, 161, 5, 70, "Input",
 CellID->2136],
Cell[45801, 1595, 400, 15, 36, "Output",
 CellID->4580]
}, Open  ]],
Cell[CellGroupData[{
Cell[46238, 1615, 72, 1, 70, "RelatedTutorialsSection",
 CellID->819248578],
Cell[46313, 1618, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],
Cell[46527, 1626, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

